"""Generated message classes for messagestreams version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'messagestreams'


class AuthenticationConfig(_messages.Message):
  r"""Represents a config used to authenticate message requests.

  Fields:
    googleOauth: If specified, an [OAuth
      token](https://developers.google.com/identity/protocols/OAuth2) will be
      generated and attached as an `Authorization` header in the HTTP request.
      This type of authorization should generally only be used when calling
      Google APIs hosted on *.googleapis.com.
    googleOidc: This authenticate method will apply Google OIDC tokens signed
      by a GCP service account to the requests.
  """

  googleOauth = _messages.MessageField('GoogleOAuth', 1)
  googleOidc = _messages.MessageField('GoogleOidc', 2)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Conversion(_messages.Message):
  r"""Conversion defines how to transform an incoming message payload from one
  format to another.

  Fields:
    outputDataFormat: Required. The output data format of the conversion.
  """

  outputDataFormat = _messages.MessageField('DataFormat', 1)


class CreateReferenceRequest(_messages.Message):
  r"""The CreateReferenceRequest request.

  Fields:
    parent: Required. The parent resource name (target_resource of this
      reference). For example: `//targetservice.googleapis.com/projects/{my-
      project}/locations/{location}/instances/{my-instance}`.
    reference: Required. The reference to be created.
    referenceId: The unique id of this resource. Must be unique within a scope
      of a target resource, but does not have to be globally unique. Reference
      ID is part of resource name of the reference. Resource name is generated
      in the following way: {parent}/references/{reference_id}. Reference ID
      field is currently required but id auto generation might be added in the
      future. It can be any arbitrary string, either GUID or any other string,
      however CLHs can use preprocess callbacks to perform a custom
      validation.
    requestId: Optional. Request ID is an idempotency ID of the request. It
      must be a valid UUID. Zero UUID (00000000-0000-0000-0000-000000000000)
      is not supported.
  """

  parent = _messages.StringField(1)
  reference = _messages.MessageField('Reference', 2)
  referenceId = _messages.StringField(3)
  requestId = _messages.StringField(4)


class DataFormat(_messages.Message):
  r"""The data format of a message payload.

  Enums:
    TypeValueValuesEnum: Required. The format type of a message payload.

  Fields:
    schema: Optional. The schema of a message payload.
    type: Required. The format type of a message payload.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The format type of a message payload.

    Values:
      TYPE_UNSPECIFIED: FORMAT types unspecified.
      JSON: JSON
      PROTOCOL_BUFFERS: PROTO
      AVRO: AVRO
    """
    TYPE_UNSPECIFIED = 0
    JSON = 1
    PROTOCOL_BUFFERS = 2
    AVRO = 3

  schema = _messages.MessageField('Schema', 1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class DeleteReferenceRequest(_messages.Message):
  r"""The DeleteReferenceRequest request.

  Fields:
    name: Required. Full resource name of the reference, in the following
      format:
      `//{targer_service}/{target_resource}/references/{reference_id}`. For
      example: `//targetservice.googleapis.com/projects/{my-
      project}/locations/{location}/instances/{my-instance}/references/{xyz}`.
    requestId: Optional. Request ID is an idempotency ID of the request. It
      must be a valid UUID. Zero UUID (00000000-0000-0000-0000-000000000000)
      is not supported.
  """

  name = _messages.StringField(1)
  requestId = _messages.StringField(2)


class Destination(_messages.Message):
  r"""Specifications of a destination to which the request should be routed
  to.

  Fields:
    authenticationConfig: Optional. An authentication config used to
      authenticate message requests, such that destinations can verify the
      source. For example, this can be used with private GCP destinations that
      require GCP crendential to access like Cloud Run. This field is optional
      and should be set only by users interested in authenticated push.
    networkConfig: Optional. Network config is used to configure how Message
      Streams resolves and connect to a destination.
    serviceEndpoint: Required. The URL of a endpoint to route traffic to. If a
      DNS FQDN is provided as the endpoint, Message Streams will create a
      peering zone to the consumer VPC and forward DNS requests to the VPC
      specified by network config to resolve the service endpoint. See:
      https://cloud.google.com/dns/docs/zones/zones-overview#peering_zones
  """

  authenticationConfig = _messages.MessageField('AuthenticationConfig', 1)
  networkConfig = _messages.MessageField('NetworkConfig', 2)
  serviceEndpoint = _messages.StringField(3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GetReferenceRequest(_messages.Message):
  r"""The GetReferenceRequest request.

  Fields:
    name: Required. Full resource name of the reference, in the following
      format:
      `//{target_service}/{target_resource}/references/{reference_id}`. For
      example: `//targetservice.googleapis.com/projects/{my-
      project}/locations/{location}/instances/{my-instance}/references/{xyz}`.
  """

  name = _messages.StringField(1)


class GoogleOAuth(_messages.Message):
  r"""Contains information needed for generating an [OAuth
  token](https://developers.google.com/identity/protocols/OAuth2). This type
  of authorization should generally only be used when calling Google APIs
  hosted on *.googleapis.com.

  Fields:
    scope: Optional. OAuth scope to be used for generating OAuth access token.
      If not specified, "https://www.googleapis.com/auth/cloud-platform" will
      be used.
    serviceAccount: Required. [Service account
      email](https://cloud.google.com/iam/docs/service-accounts) to be used
      for generating OAuth token. The service account must be within the same
      project as the job. The caller must have iam.serviceAccounts.actAs
      permission for the service account.
  """

  scope = _messages.StringField(1)
  serviceAccount = _messages.StringField(2)


class GoogleOidc(_messages.Message):
  r"""Represents a config used to authenticate with a Google OIDC token using
  a GCP service account. Use this authentication method to invoke your Cloud
  Run and Cloud Functions destinations or HTTP endpoints that support Google
  OIDC.

  Fields:
    audience: Optional. Audience to be used to generate the OIDC Token. The
      audience claim identifies the recipient that the JWT is intended for. If
      unspecified, the destination URI will be used.
    serviceAccount: Required. The IAM service account email used as the
      identity of the stream resource. The service account is used to generate
      OIDC tokens for the outbound messages. It's also used to read messages
      from the "source". In addition to service account email, the resource
      name of the service account can be used in the format of
      `projects/-/serviceAccounts/{ACCOUNT}`, ACCOUNT can be email address or
      uniqueId of the service account (see https://cloud.google.com/iam/refere
      nce/rest/v1/projects.serviceAccounts/get).
  """

  audience = _messages.StringField(1)
  serviceAccount = _messages.StringField(2)


class KafkaAuthenticationConfig(_messages.Message):
  r"""Authentication configuration.

  Fields:
    saslAuth: A SaslAuthConfig attribute.
  """

  saslAuth = _messages.MessageField('SaslAuthConfig', 1)


class KafkaSource(_messages.Message):
  r"""Kafka Source configuration.

  Fields:
    brokerUris: Required. The Kafka broker URIs. e.g. 10.12.34.56:8080
    consumerGroupId: Required. The consumer group ID used by the Kafka broker
      to track the offsets of all topic partitions being read by this Stream.
    initialOffset: Required. The initial message offset from which to start
      streaming. Supported values: newest, oldest.
    kafkaAuthenticationConfig: Optional. Authentication configuration used to
      authenticate the Kafka client with the Kafka broker, and authorize to
      read the topic(s).
    topics: Required. The Kafka topics to read from.
  """

  brokerUris = _messages.StringField(1, repeated=True)
  consumerGroupId = _messages.StringField(2)
  initialOffset = _messages.StringField(3)
  kafkaAuthenticationConfig = _messages.MessageField('KafkaAuthenticationConfig', 4)
  topics = _messages.StringField(5, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListReferencesRequest(_messages.Message):
  r"""The ListResourceMetadataRequest request.

  Fields:
    pageSize: The maximum number of items to return. If unspecified, server
      will pick an appropriate default. Server may return fewer items than
      requested. A caller should only rely on response's next_page_token to
      determine if there are more References left to be queried.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Required. The parent resource name (target_resource of this
      reference). For example: `//targetservice.googleapis.com/projects/{my-
      project}/locations/{location}/instances/{my-instance}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3)


class ListReferencesResponse(_messages.Message):
  r"""The ListReferencesResponse response.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    references: The list of references.
  """

  nextPageToken = _messages.StringField(1)
  references = _messages.MessageField('Reference', 2, repeated=True)


class ListStreamsResponse(_messages.Message):
  r"""Message for response to listing streams

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    streams: The list of Stream
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  streams = _messages.MessageField('Stream', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Mediation(_messages.Message):
  r"""Mediation defines different ways to modify the stream.

  Fields:
    bindAttributesAsRawHeaders: Optional. If bind_attributes_as_raw_headers
      set true, we will bind the attributes of an incoming cloud event as raw
      HTTP headers.
    conversion: Optional. Conversion defines the way to convert an incoming
      message payload from one format to another.
    transformation: Optional. Transformation defines the way to transform an
      incoming message.
  """

  bindAttributesAsRawHeaders = _messages.BooleanField(1)
  conversion = _messages.MessageField('Conversion', 2)
  transformation = _messages.MessageField('Transformation', 3)


class MessagestreamsProjectsLocationsGetRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class MessagestreamsProjectsLocationsListRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class MessagestreamsProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class MessagestreamsProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class MessagestreamsProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class MessagestreamsProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MessagestreamsProjectsLocationsStreamsCreateRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsStreamsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    stream: A Stream resource to be passed as the request body.
    streamId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and stream_id from the method_signature
      of Create RPC
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  stream = _messages.MessageField('Stream', 3)
  streamId = _messages.StringField(4)


class MessagestreamsProjectsLocationsStreamsDeleteRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsStreamsDeleteRequest object.

  Fields:
    etag: Optional. If provided, the stream will only be deleted if the etag
      matches the current etag on the resource.
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class MessagestreamsProjectsLocationsStreamsGetRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsStreamsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class MessagestreamsProjectsLocationsStreamsListRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsStreamsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListStreamsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MessagestreamsProjectsLocationsStreamsPatchRequest(_messages.Message):
  r"""A MessagestreamsProjectsLocationsStreamsPatchRequest object.

  Fields:
    name: The resource name of the stream. Must be unique within the location
      of the project and must be in
      `projects/{project}/locations/{location}/streams/{stream}` format.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    stream: A Stream resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Stream resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  stream = _messages.MessageField('Stream', 3)
  updateMask = _messages.StringField(4)


class NetworkConfig(_messages.Message):
  r"""Represents a network config to be used for destination resolution and
  connectivity.

  Fields:
    networkAttachment: Required. Name of the NetworkAttachment that allows
      access to the consumer VPC. The NetworkAttachment must be in the same
      region as the Stream. Format: `projects/{PROJECT_ID}/regions/{REGION}/ne
      tworkAttachments/{NETWORK_ATTACHMENT_NAME}`
  """

  networkAttachment = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Reference(_messages.Message):
  r"""Represents a reference to a resource.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    createTime: Output only. The creation time.
    details: Details of the reference type with no implied semantics.
      Cumulative size of the field must not be more than 1KiB.
    name: Output only. Relative resource name of the reference. Includes
      target resource as a parent and reference uid
      `{target_resource}/references/{reference_id}`. For example,
      `projects/{my-project}/locations/{location}/instances/{my-
      instance}/references/{xyz}`.
    sourceResource: Required. Full resource name of the resource which refers
      the target resource. For example:
      //tpu.googleapis.com/projects/myproject/nodes/mynode
    targetUniqueId: Output only. The unique_id of the target resource. Example
      1: (For arcus resource) A-1-0-2-387420123-13-913517247483640811
      unique_id format defined in go/m11n-unique-id-as-resource-id Example 2:
      (For CCFE resource) 123e4567-e89b-12d3-a456-426614174000
    type: Required. Type of the reference. A service might impose limits on
      number of references of a specific type. Note: It's recommended to use
      CAPITALS_WITH_UNDERSCORES style for a type name.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  name = _messages.StringField(3)
  sourceResource = _messages.StringField(4)
  targetUniqueId = _messages.StringField(5)
  type = _messages.StringField(6)


class SaslAuthConfig(_messages.Message):
  r"""SASL/Plain or SASL/SCRAM mechanism configuration.

  Enums:
    MechanismValueValuesEnum:

  Fields:
    mechanism: A MechanismValueValuesEnum attribute.
    passwordSecret: Required. The password for the authentication identity may
      be loaded from Secret Manager. Supported Format: 1-
      "projects/{project}/secrets/{secret}/versions/{version}" 2- "projects/{p
      roject}/locations/{location}/secrets/{secret}/versions/{version}"
    username: Required. The SASL authentication identity (username).
  """

  class MechanismValueValuesEnum(_messages.Enum):
    r"""MechanismValueValuesEnum enum type.

    Values:
      AUTH_MECHANISM_UNSPECIFIED: <no description>
      PLAIN: <no description>
      SHA_256: <no description>
      SHA_512: <no description>
    """
    AUTH_MECHANISM_UNSPECIFIED = 0
    PLAIN = 1
    SHA_256 = 2
    SHA_512 = 3

  mechanism = _messages.EnumField('MechanismValueValuesEnum', 1)
  passwordSecret = _messages.StringField(2)
  username = _messages.StringField(3)


class Schema(_messages.Message):
  r"""The value of a schema, either a schema definition or a schema uri. For
  now only schema definition is supported.

  Fields:
    schemaDefinition: Optional. The entire schema definition is stored in this
      field.
  """

  schemaDefinition = _messages.StringField(1)


class Source(_messages.Message):
  r"""Represents the source where we stream data from.

  Fields:
    kafka: A KafkaSource attribute.
    networkConfig: Optional. Network config is used to configure how Message
      Streams resolves and connect to a source.
    pubsubSubscription: A string attribute.
  """

  kafka = _messages.MessageField('KafkaSource', 1)
  networkConfig = _messages.MessageField('NetworkConfig', 2)
  pubsubSubscription = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Stream(_messages.Message):
  r"""The representation of the stream resource.

  Enums:
    EventarcTransformationTypeValueValuesEnum: Optional.

  Messages:
    AnnotationsValue: Optional. User-defined annotations. See
      https://google.aip.dev/128#annotations
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    annotations: Optional. User-defined annotations. See
      https://google.aip.dev/128#annotations
    createTime: Output only. [Output only] Create time stamp
    displayName: Optional. Display name of resource.
    etag: Output only. This checksum is computed by the server based on the
      value of other fields, and might be sent only on create requests to
      ensure that the client has an up-to-date value before proceeding.
    eventarcTransformationType: Optional.
    generateReplies: Optional. Whether to generate messages that contain the
      details of the final HTTP response of a message stream and is sent to
      the message bus that the message was received from. Ignored if the
      message did not come from a bus.
    inputDataFormat: Optional. An input data format must be set if there is a
      Conversion or Transformation mediation, otherwise it is optional. An
      input schema is required if the payload is in AVRO or PROTOCOL_BINDING
      content types. An input schema is not required for JSON, and XML content
      types but will be used if specified.
    labels: Optional. Labels as key value pairs
    mediations: Optional. Mediations to define the way to modify the incoming
      message.
    name: The resource name of the stream. Must be unique within the location
      of the project and must be in
      `projects/{project}/locations/{location}/streams/{stream}` format.
    source: Optional. Source specifies where the stream reads data from.
    streamAction: Required. The specifications for routing messaging traffic
      and applying associated policies.
    streamIdentityOverride: Optional.
    uid: Output only. Server-assigned unique identifier for the stream. The
      value is a UUID4 string and guaranteed to remain unchanged until the
      resource is deleted.
    updateTime: Output only. [Output only] Update time stamp
    useSharedPool: Optional. use_shared_pool specifies whether the Stream will
      run with dedicated resources or using the shared pool. Dedicated pools
      cost more but provide better workload isolation and peak performance
      guarantees. Certain functionality of Stream may be available only in
      dedicated pools.
  """

  class EventarcTransformationTypeValueValuesEnum(_messages.Enum):
    r"""Optional.

    Values:
      EVENTARC_TRANSFORMATION_CONFIG_UNSPECIFIED: The transformation type is
        unknown (e.g. the query parameter value is invalid). This type is only
        relevant for data plane metrics and should not be used by the CLH.
      EVENTARC_NOT_AN_EVENT: The request does not correspond to an event, so
        it should not be transformed. This type is only relevant for data
        plane metrics and should not be used by the CLH.
      EVENTARC_CE_PUBSUB_BINDING: The transformation in which a CloudEvent is
        extracted from the Pub/Sub message (i.e. the Pub/Sub Protocol Binding,
        see https://github.com/google/knative-gcp/blob/main/docs/spec/pubsub-
        protocol-binding.md). This transformation is very generic and should
        be used for any trigger where EventFlow creates the Pub/Sub messages.
        In practice, this means Audit Log events and events from Ingress
        Platform.
      EVENTARC_CUSTOM_PUBSUB: The transformation in which an arbitrary Pub/Sub
        message is converted into a Pub/Sub event, as specified in go/cloud-
        events-on-google-devx-design.
      EVENTARC_GCS_NOTIFICATION: The transformation in which a Cloud Storage
        Pub/Sub Notification (http://cloud/storage/docs/pubsub-notifications)
        is converted into a CloudEvent, as specified in go/gcs-event-
        conversion. This transformation is specific to the Cloud Storage stop-
        gap integration (go/eventarc-gcs-stopgap-detailed-design).
    """
    EVENTARC_TRANSFORMATION_CONFIG_UNSPECIFIED = 0
    EVENTARC_NOT_AN_EVENT = 1
    EVENTARC_CE_PUBSUB_BINDING = 2
    EVENTARC_CUSTOM_PUBSUB = 3
    EVENTARC_GCS_NOTIFICATION = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. User-defined annotations. See
    https://google.aip.dev/128#annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  createTime = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.StringField(4)
  eventarcTransformationType = _messages.EnumField('EventarcTransformationTypeValueValuesEnum', 5)
  generateReplies = _messages.BooleanField(6)
  inputDataFormat = _messages.MessageField('DataFormat', 7)
  labels = _messages.MessageField('LabelsValue', 8)
  mediations = _messages.MessageField('Mediation', 9, repeated=True)
  name = _messages.StringField(10)
  source = _messages.MessageField('Source', 11)
  streamAction = _messages.MessageField('StreamAction', 12)
  streamIdentityOverride = _messages.StringField(13)
  uid = _messages.StringField(14)
  updateTime = _messages.StringField(15)
  useSharedPool = _messages.BooleanField(16)


class StreamAction(_messages.Message):
  r"""The specifications for routing messaging traffic and applying associated
  policies.

  Fields:
    destinations: Required. The destination to which traffic should be
      forwarded. Currently, only a single destination is supported.
  """

  destinations = _messages.MessageField('Destination', 1, repeated=True)


class Transformation(_messages.Message):
  r"""Transformation defines the way to transfer an incoming message.

  Fields:
    celExpression: Optional. The CEL expression to transform the incoming
      message.
  """

  celExpression = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
