"""Generated message classes for dataplex version v1.

Dataplex API is used to manage the lifecycle of data lakes.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'dataplex'


class DataplexProjectsLocationsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesActionsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesActionsListRequest object.

  Fields:
    pageSize: Optional. Maximum number of actions to return. The service may
      return fewer than this value. If unspecified, at most 10 actions will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListLakeActions
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListLakeActions must match the call that
      provided the page token.
    parent: Required. The resource name of the parent lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsLakesContentGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.To learn
      which resources support conditions in their IAM policies, see the IAM
      documentation (https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesContentSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesContentTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesContentTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesCreateRequest object.

  Fields:
    googleCloudDataplexV1Lake: A GoogleCloudDataplexV1Lake resource to be
      passed as the request body.
    lakeId: Required. Lake identifier. This ID will be used to generate names
      such as database and dataset names when publishing metadata to Hive
      Metastore and BigQuery. * Must contain only lowercase letters, numbers
      and hyphens. * Must start with a letter. * Must end with a number or a
      letter. * Must be between 1-63 characters. * Must be unique within the
      customer project / location.
    parent: Required. The resource name of the lake location, of the form:
      projects/{project_number}/locations/{location_id} where location_id
      refers to a GCP region.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Lake = _messages.MessageField('GoogleCloudDataplexV1Lake', 1)
  lakeId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesDeleteRequest object.

  Fields:
    name: Required. The resource name of the lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesEnvironmentsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.To learn
      which resources support conditions in their IAM policies, see the IAM
      documentation (https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesEnvironmentsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesEnvironmentsTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesEnvironmentsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.To learn
      which resources support conditions in their IAM policies, see the IAM
      documentation (https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesGetRequest object.

  Fields:
    name: Required. The resource name of the lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of Lakes to return. The service may
      return fewer than this value. If unspecified, at most 10 lakes will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListLakes call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListLakes must match the call that provided the
      page token.
    parent: Required. The resource name of the lake location, of the form:
      projects/{project_number}/locations/{location_id} where location_id
      refers to a GCP region.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsLakesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesPatchRequest object.

  Fields:
    googleCloudDataplexV1Lake: A GoogleCloudDataplexV1Lake resource to be
      passed as the request body.
    name: Output only. The relative resource name of the lake, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Lake = _messages.MessageField('GoogleCloudDataplexV1Lake', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesResolveLakeActionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesResolveLakeActionsRequest object.

  Fields:
    googleCloudDataplexV1ResolveLakeActionsRequest: A
      GoogleCloudDataplexV1ResolveLakeActionsRequest resource to be passed as
      the request body.
    lake: Required. The name of the lake for which actions are being resolved
      of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
  """

  googleCloudDataplexV1ResolveLakeActionsRequest = _messages.MessageField('GoogleCloudDataplexV1ResolveLakeActionsRequest', 1)
  lake = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTasksGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.To learn
      which resources support conditions in their IAM policies, see the IAM
      documentation (https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTasksSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTasksTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTasksTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesActionsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesActionsListRequest object.

  Fields:
    pageSize: Optional. Maximum number of actions to return. The service may
      return fewer than this value. If unspecified, at most 10 actions will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListZoneActions
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListZoneActions must match the call that
      provided the page token.
    parent: Required. The resource name of the parent zone: projects/{project_
      number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsLakesZonesAssetsActionsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsActionsListRequest object.

  Fields:
    pageSize: Optional. Maximum number of actions to return. The service may
      return fewer than this value. If unspecified, at most 10 actions will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListAssetActions
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListAssetActions must match the call that
      provided the page token.
    parent: Required. The resource name of the parent asset: projects/{project
      _number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/
      {asset_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataplexProjectsLocationsLakesZonesAssetsCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsCreateRequest object.

  Fields:
    assetId: Required. Asset identifier. This ID will be used to generate
      names such as table names when publishing metadata to Hive Metastore and
      BigQuery. * Must contain only lowercase letters, numbers and hyphens. *
      Must start with a letter. * Must end with a number or a letter. * Must
      be between 1-63 characters. * Must be unique within the zone.
    googleCloudDataplexV1Asset: A GoogleCloudDataplexV1Asset resource to be
      passed as the request body.
    parent: Required. The resource name of the parent zone:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}`
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  assetId = _messages.StringField(1)
  googleCloudDataplexV1Asset = _messages.MessageField('GoogleCloudDataplexV1Asset', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesZonesAssetsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsDeleteRequest object.

  Fields:
    name: Required. The resource name of the asset:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}/assets/{asset_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesAssetsGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.To learn
      which resources support conditions in their IAM policies, see the IAM
      documentation (https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesAssetsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsGetRequest object.

  Fields:
    name: Required. The resource name of the asset:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}/assets/{asset_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesAssetsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of asset to return. The service may
      return fewer than this value. If unspecified, at most 10 assets will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListAssets call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListAssets must match the call that provided the
      page token.
    parent: Required. The resource name of the parent zone:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsLakesZonesAssetsPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsPatchRequest object.

  Fields:
    googleCloudDataplexV1Asset: A GoogleCloudDataplexV1Asset resource to be
      passed as the request body.
    name: Output only. The relative resource name of the asset, of the form: p
      rojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{
      zone_id}/assets/{asset_id}
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Asset = _messages.MessageField('GoogleCloudDataplexV1Asset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesZonesAssetsResolveAssetActionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsResolveAssetActionsRequest
  object.

  Fields:
    asset: Required. The name of the asset for which actions are being
      resolved of the form: projects/{project_number}/locations/{location_id}/
      lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}
    googleCloudDataplexV1ResolveAssetActionsRequest: A
      GoogleCloudDataplexV1ResolveAssetActionsRequest resource to be passed as
      the request body.
  """

  asset = _messages.StringField(1, required=True)
  googleCloudDataplexV1ResolveAssetActionsRequest = _messages.MessageField('GoogleCloudDataplexV1ResolveAssetActionsRequest', 2)


class DataplexProjectsLocationsLakesZonesAssetsSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesAssetsTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesAssetsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesCreateRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesCreateRequest object.

  Fields:
    googleCloudDataplexV1Zone: A GoogleCloudDataplexV1Zone resource to be
      passed as the request body.
    parent: Required. The resource name of the parent lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
    zoneId: Required. Zone identifier. This ID will be used to generate names
      such as database and dataset names when publishing metadata to Hive
      Metastore and BigQuery. * Must contain only lowercase letters, numbers
      and hyphens. * Must start with a letter. * Must end with a number or a
      letter. * Must be between 1-63 characters. * Must be unique within the
      lake.
  """

  googleCloudDataplexV1Zone = _messages.MessageField('GoogleCloudDataplexV1Zone', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)
  zoneId = _messages.StringField(4)


class DataplexProjectsLocationsLakesZonesDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesDeleteRequest object.

  Fields:
    name: Required. The resource name of the zone:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}`
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesEntitiesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesGetRequest object.

  Enums:
    ViewValueValuesEnum: Optional. Used to select the subset of information
      about the Entity to return. Defaults to BASIC.

  Fields:
    name: Required. The resource name of the entity:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}/entities/{entity_id_or_entity_uid} The entity id part
      could either be the entity unique ID or the user provided ID.
    view: Optional. Used to select the subset of information about the Entity
      to return. Defaults to BASIC.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. Used to select the subset of information about the Entity to
    return. Defaults to BASIC.

    Values:
      ENTITY_VIEW_UNSPECIFIED: The API will default to the BASIC view.
      BASIC: Minimal view that does not include the schema.
      SCHEMA: Includes basic information and schema.
      STATS: Includes basic information and statistics.
      FULL: Includes everything.
    """
    ENTITY_VIEW_UNSPECIFIED = 0
    BASIC = 1
    SCHEMA = 2
    STATS = 3
    FULL = 4

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class DataplexProjectsLocationsLakesZonesEntitiesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesListRequest object.

  Enums:
    ViewValueValuesEnum: Required. Specify the entity view to make a partial
      list request.

  Fields:
    filter: Optional. Filter request by name prefix.
    pageSize: Optional. Maximum number of entities to return. The service may
      return fewer than this value. If unspecified, at most 10 entities will
      be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. Page token received from a previous ListEntities
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListEntities must match the call that
      provided the page token.
    parent: Required. The resource name of the parent zone:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}`
    view: Required. Specify the entity view to make a partial list request.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Required. Specify the entity view to make a partial list request.

    Values:
      ENTITY_VIEW_UNSPECIFIED: The default / unset value. The API will default
        to the FULL view.
      TABLES: Only list table entities.
      FILESETS: Only list fileset entities.
    """
    ENTITY_VIEW_UNSPECIFIED = 0
    TABLES = 1
    FILESETS = 2

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class DataplexProjectsLocationsLakesZonesEntitiesPartitionsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesPartitionsGetRequest
  object.

  Fields:
    name: Required. The resource name of the partition:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}/entities/{entity_id}/partitions/{partition_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesEntitiesPartitionsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesEntitiesPartitionsListRequest
  object.

  Fields:
    filter: Optional. Filter request.
    pageSize: Optional. Maximum number of partitions to return. The service
      may return fewer than this value. If unspecified, at most 10 partitions
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. Page token received from a previous ListPartitions
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to ListPartitions must match the call that
      provided the page token.
    parent: Required. The resource name of the parent entity:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}/entities/{entity_id}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DataplexProjectsLocationsLakesZonesGetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.To learn
      which resources support conditions in their IAM policies, see the IAM
      documentation (https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesGetRequest object.

  Fields:
    name: Required. The resource name of the zone:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
      /zones/{zone_id}
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsLakesZonesListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesListRequest object.

  Fields:
    filter: Optional. Filter request.
    orderBy: Optional. Order by fields for the result.
    pageSize: Optional. Maximum number of zones to return. The service may
      return fewer than this value. If unspecified, at most 10 zones will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. Page token received from a previous ListZones call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to ListZones must match the call that provided the
      page token.
    parent: Required. The resource name of the parent lake:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataplexProjectsLocationsLakesZonesPatchRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesPatchRequest object.

  Fields:
    googleCloudDataplexV1Zone: A GoogleCloudDataplexV1Zone resource to be
      passed as the request body.
    name: Output only. The relative resource name of the zone, of the form: pr
      ojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{z
      one_id}
    updateMask: Required. Mask of fields to update.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is false.
  """

  googleCloudDataplexV1Zone = _messages.MessageField('GoogleCloudDataplexV1Zone', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class DataplexProjectsLocationsLakesZonesResolveZoneActionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesResolveZoneActionsRequest object.

  Fields:
    googleCloudDataplexV1ResolveZoneActionsRequest: A
      GoogleCloudDataplexV1ResolveZoneActionsRequest resource to be passed as
      the request body.
    zone: Required. The name of the zone for which actions are being resolved
      of the form: projects/{project_number}/locations/{location_id}/lakes/{la
      ke_id}/zones/{zone_id}
  """

  googleCloudDataplexV1ResolveZoneActionsRequest = _messages.MessageField('GoogleCloudDataplexV1ResolveZoneActionsRequest', 1)
  zone = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesSetIamPolicyRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsLakesZonesTestIamPermissionsRequest(_messages.Message):
  r"""A DataplexProjectsLocationsLakesZonesTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataplexProjectsLocationsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in AIP-160 (https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the next_page_token field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DataplexProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A DataplexProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class DataplexProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A DataplexProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A DataplexProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DataplexProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A DataplexProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for Empty is empty JSON object {}.
  """



class GoogleCloudDataplexV1Action(_messages.Message):
  r"""Action represents an issue requiring administrator action for
  resolution.

  Enums:
    CategoryValueValuesEnum: The category of issue associated with the action.

  Fields:
    asset: Output only. The relative resource name of the asset, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/
      {zone_id}/assets/{asset_id}
    category: The category of issue associated with the action.
    dataLocations: The list of data locations associated with this action.
      Cloud Storage locations are represented as URI paths(E.g.
      gs://bucket/table1/year=2020/month=Jan/). BigQuery locations refer to
      resource names(E.g. //bigquery.googleapis.com/projects/project-
      id/datasets/dataset-id).
    detectTime: The time that the issue was detected.
    failedSecurityPolicyApply: Details for issues related to applying security
      policy.
    incompatibleDataSchema: Details for issues related to incompatible schemas
      detected within data.
    invalidDataFormat: Details for issues related to invalid or unsupported
      data formats.
    invalidDataOrganization: Details for issues related to invalid data
      arrangement.
    invalidDataPartition: Details for issues related to invalid or unsupported
      data partition structure.
    invalidDiscoveryConfig: Details for issues related to invalid discovery
      configuration files.
    invalidMetastore: Details for issues related to metadata publishing to
      Dataproc Metastore caused by issues in the metastore service instance,
      e.g., wrong metastore configuration.
    invalidSecurityPolicy: Details for issues related to invalid security
      policy specifications.
    issue: Detailed description of the issue requiring action.
    lake: Output only. The relative resource name of the lake, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
    locations: The list of data locations associated with this action. Paths
      reflect the underlying storage service. Cloud Storage locations are
      represented as URI paths. BigQuery locations refer to resource names.
    missingData: Details for issues related to absence of data within managed
      resources.
    missingMetastore: Details for issues related to metadata publishing to
      Dataproc Metastore due to a missing metastore service instance.
    missingResource: Details for issues related to absence of a managed
      resource.
    name: Output only. The relative resource name of the action, of the form:
      projects/{project}/locations/{location}/lakes/{lake}/actions/{action} pr
      ojects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/actions/
      {action} projects/{project}/locations/{location}/lakes/{lake}/zones/{zon
      e}/assets/{asset}/actions/{action}
    unauthorizedDataset: Details for issues related to metadata publishing to
      BigQuery due to unauthorized errors.
    unauthorizedResource: Details for issues related to lack of permissions to
      access data resources.
    zone: Output only. The relative resource name of the zone, of the form: pr
      ojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{z
      one_id}
  """

  class CategoryValueValuesEnum(_messages.Enum):
    r"""The category of issue associated with the action.

    Values:
      CATEGORY_UNSPECIFIED: Unspecified category
      RESOURCE_MANAGEMENT: Resource management related issues.
      SECURITY_POLICY: Security policy related issues.
      DATA_DISCOVERY: Data and discovery related issues.
      METADATA_PUBLISHING: Metadata publishing related issues.
    """
    CATEGORY_UNSPECIFIED = 0
    RESOURCE_MANAGEMENT = 1
    SECURITY_POLICY = 2
    DATA_DISCOVERY = 3
    METADATA_PUBLISHING = 4

  asset = _messages.StringField(1)
  category = _messages.EnumField('CategoryValueValuesEnum', 2)
  dataLocations = _messages.StringField(3, repeated=True)
  detectTime = _messages.StringField(4)
  failedSecurityPolicyApply = _messages.MessageField('GoogleCloudDataplexV1ActionFailedSecurityPolicyApply', 5)
  incompatibleDataSchema = _messages.MessageField('GoogleCloudDataplexV1ActionIncompatibleDataSchema', 6)
  invalidDataFormat = _messages.MessageField('GoogleCloudDataplexV1ActionInvalidDataFormat', 7)
  invalidDataOrganization = _messages.MessageField('GoogleCloudDataplexV1ActionInvalidDataOrganization', 8)
  invalidDataPartition = _messages.MessageField('GoogleCloudDataplexV1ActionInvalidDataPartition', 9)
  invalidDiscoveryConfig = _messages.MessageField('GoogleCloudDataplexV1ActionInvalidDiscoveryConfig', 10)
  invalidMetastore = _messages.MessageField('GoogleCloudDataplexV1ActionInvalidMetastore', 11)
  invalidSecurityPolicy = _messages.MessageField('GoogleCloudDataplexV1ActionInvalidSecurityPolicy', 12)
  issue = _messages.StringField(13)
  lake = _messages.StringField(14)
  locations = _messages.MessageField('GoogleCloudDataplexV1ActionLocation', 15, repeated=True)
  missingData = _messages.MessageField('GoogleCloudDataplexV1ActionMissingData', 16)
  missingMetastore = _messages.MessageField('GoogleCloudDataplexV1ActionMissingMetastore', 17)
  missingResource = _messages.MessageField('GoogleCloudDataplexV1ActionMissingResource', 18)
  name = _messages.StringField(19)
  unauthorizedDataset = _messages.MessageField('GoogleCloudDataplexV1ActionUnauthorizedDataset', 20)
  unauthorizedResource = _messages.MessageField('GoogleCloudDataplexV1ActionUnauthorizedResource', 21)
  zone = _messages.StringField(22)


class GoogleCloudDataplexV1ActionFailedSecurityPolicyApply(_messages.Message):
  r"""Failed to apply security policy to the managed resource(s) under a lake,
  zone or an asset. For a lake or zone resource, one or more underlying assets
  has a failure applying security policy to the associated managed resource.

  Fields:
    asset: Resource name of one of the assets with failing security policy
      application. Populated for a lake or zone resource only.
  """

  asset = _messages.StringField(1)


class GoogleCloudDataplexV1ActionIncompatibleDataSchema(_messages.Message):
  r"""Action details for incompatible schemas detected by discovery.

  Fields:
    existingSchema: The existing and expected schema of the table. The schema
      is provided as a JSON formatted structure listing columns and data
      types.
    newSchema: The new and incompatible schema within the table. The schema is
      provided as a JSON formatted structured listing columns and data types.
    sampledDataLocations: The list of data locations sampled and used for
      format/schema inference.
    table: The name of the table containing invalid data.
  """

  existingSchema = _messages.StringField(1)
  newSchema = _messages.StringField(2)
  sampledDataLocations = _messages.StringField(3, repeated=True)
  table = _messages.StringField(4)


class GoogleCloudDataplexV1ActionInvalidDataFormat(_messages.Message):
  r"""Action details for invalid or unsupported data files detected by
  discovery.

  Fields:
    sampledDataLocations: The list of data locations sampled and used for
      format/schema inference.
  """

  sampledDataLocations = _messages.StringField(1, repeated=True)


class GoogleCloudDataplexV1ActionInvalidDataOrganization(_messages.Message):
  r"""Action details for invalid data arrangement."""


class GoogleCloudDataplexV1ActionInvalidDataPartition(_messages.Message):
  r"""Action details for invalid or unsupported partitions detected by
  discovery.
  """



class GoogleCloudDataplexV1ActionInvalidDiscoveryConfig(_messages.Message):
  r"""Action details for invalid discovery configuration data detected by
  discovery.
  """



class GoogleCloudDataplexV1ActionInvalidMetastore(_messages.Message):
  r"""Action details for issues of metadata publishing to Dataproc Metastore
  caused by issues in the metastore service instance, e.g., wrong metastore
  configuration.
  """



class GoogleCloudDataplexV1ActionInvalidSecurityPolicy(_messages.Message):
  r"""Action details for invalid security policy issues raised when the
  specified security policy cannot be applied on a managed resource.
  """



class GoogleCloudDataplexV1ActionLocation(_messages.Message):
  r"""The list of data locations associated with this action. Paths reflect
  the underlying storage service. Cloud Storage locations are represented as
  URI paths. BigQuery locations refer to resource names.

  Fields:
    fileset: The fileset containing invalid data referenced by its catalog
      name.
    paths: Paths (e.g., Cloud Storage paths) where issues identified in this
      action are found.
    table: The table containing invalid data referenced by its catalog name.
  """

  fileset = _messages.StringField(1)
  paths = _messages.StringField(2, repeated=True)
  table = _messages.StringField(3)


class GoogleCloudDataplexV1ActionMissingData(_messages.Message):
  r"""Action details for absence of data detected by discovery."""


class GoogleCloudDataplexV1ActionMissingMetastore(_messages.Message):
  r"""Action details for issues of metadata publishing to Dataproc Metastore
  due to a missing metastore service instance.
  """



class GoogleCloudDataplexV1ActionMissingResource(_messages.Message):
  r"""Action details for resource references in assets that cannot be located.
  """



class GoogleCloudDataplexV1ActionUnauthorizedDataset(_messages.Message):
  r"""Action details for issues of metadata publishing to BigQuery due to
  unauthorized errors.
  """



class GoogleCloudDataplexV1ActionUnauthorizedResource(_messages.Message):
  r"""Action details for unauthorized resource issues raised to indicate that
  the service account associated with the lake instance is not authorized to
  access or manage the resource associated with an asset.
  """



class GoogleCloudDataplexV1Asset(_messages.Message):
  r"""An asset represents a cloud resource that is being managed within a lake
  as a member of a zone.

  Enums:
    StateValueValuesEnum: Output only. Current state of the asset.

  Messages:
    LabelsValue: Optional. User defined labels for the asset.

  Fields:
    actions: Output only. The current set of actions required of the
      administrator for this asset.
    createTime: Output only. The time when the asset was created.
    description: Optional. Description of the asset.
    discoverySpec: Optional. Specification of the discovery feature applied to
      data referenced by this asset. When this spec is left unset, the asset
      will use the spec set on the parent zone.
    discoveryStatus: Output only. Status of the discovery feature applied to
      data referenced by this asset.
    displayName: Optional. User friendly display name.
    labels: Optional. User defined labels for the asset.
    name: Output only. The relative resource name of the asset, of the form: p
      rojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{
      zone_id}/assets/{asset_id}
    resourceSpec: Required. Specification of the resource that is referenced
      by this asset.
    resourceStatus: Output only. Status of the resource referenced by this
      asset.
    securitySpec: Optional. Specification of the security policy applied to
      resource referenced by this asset. Typically it should take a few
      minutes for the security policy to fully propagate.
    securityStatus: Output only. Status of the security policy applied to
      resource referenced by this asset.
    state: Output only. Current state of the asset.
    uid: Output only. System generated globally unique ID for the asset. This
      ID will be different if the asset is deleted and re-created with the
      same name.
    updateTime: Output only. The time when the asset was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the asset.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User defined labels for the asset.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  actions = _messages.MessageField('GoogleCloudDataplexV1Action', 1, repeated=True)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  discoverySpec = _messages.MessageField('GoogleCloudDataplexV1AssetDiscoverySpec', 4)
  discoveryStatus = _messages.MessageField('GoogleCloudDataplexV1AssetDiscoveryStatus', 5)
  displayName = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  resourceSpec = _messages.MessageField('GoogleCloudDataplexV1AssetResourceSpec', 9)
  resourceStatus = _messages.MessageField('GoogleCloudDataplexV1AssetResourceStatus', 10)
  securitySpec = _messages.MessageField('GoogleCloudDataplexV1AssetSecuritySpec', 11)
  securityStatus = _messages.MessageField('GoogleCloudDataplexV1AssetSecurityStatus', 12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  uid = _messages.StringField(14)
  updateTime = _messages.StringField(15)


class GoogleCloudDataplexV1AssetDiscoverySpec(_messages.Message):
  r"""Settings to manage the metadata discovery and publishing for an asset.

  Enums:
    InheritanceModeValueValuesEnum: Optional. Inheritance behavior for this
      config. By default, all fields in this config override any values
      specified at the zone level. When configured as INHERIT some fields in
      this config are ignored and the zone level configuration is used
      instead. All fields that behave this way are called out as such via
      documentation. Deprecated: Rather than configure inheritance behavior
      via this enum, users can enable inheritance by omitting the discovery
      config entirely.

  Fields:
    enabled: Optional. Whether discovery is enabled. When inheritance_mode is
      set to INHERIT this field is unset and ignored.
    excludePatterns: Optional. The list of patterns to apply for selecting
      data to exclude during discovery. For Cloud Storage bucket assets, these
      are interpreted as glob patterns used to match object names. For
      BigQuery dataset assets, these are interpreted as patterns to match
      table names. When inheritance_mode is set to INHERIT this field is unset
      and ignored.
    includePatterns: Optional. The list of patterns to apply for selecting
      data to include during discovery if only a subset of the data should
      considered. For Cloud Storage bucket assets, these are interpreted as
      glob patterns used to match object names. For BigQuery dataset assets,
      these are interpreted as patterns to match table names. When
      inheritance_mode is set to INHERIT this field is unset and ignored.
    inheritanceMode: Optional. Inheritance behavior for this config. By
      default, all fields in this config override any values specified at the
      zone level. When configured as INHERIT some fields in this config are
      ignored and the zone level configuration is used instead. All fields
      that behave this way are called out as such via documentation.
      Deprecated: Rather than configure inheritance behavior via this enum,
      users can enable inheritance by omitting the discovery config entirely.
    publishing: Optional. Settings to manage metadata publishing for the zone.
    schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
      running discovery jobs periodically. Discovery jobs must be scheduled at
      least 30 minutes apart.
  """

  class InheritanceModeValueValuesEnum(_messages.Enum):
    r"""Optional. Inheritance behavior for this config. By default, all fields
    in this config override any values specified at the zone level. When
    configured as INHERIT some fields in this config are ignored and the zone
    level configuration is used instead. All fields that behave this way are
    called out as such via documentation. Deprecated: Rather than configure
    inheritance behavior via this enum, users can enable inheritance by
    omitting the discovery config entirely.

    Values:
      INHERITANCE_MODE_UNSPECIFIED: Unspecified inheritance mode that is
        interpreted as OVERRIDE.
      OVERRIDE: Override all zone config values with those specified at the
        asset level.
      INHERIT: All values specified at the zone level should replace those
        specified at the asset level.
    """
    INHERITANCE_MODE_UNSPECIFIED = 0
    OVERRIDE = 1
    INHERIT = 2

  enabled = _messages.BooleanField(1)
  excludePatterns = _messages.StringField(2, repeated=True)
  includePatterns = _messages.StringField(3, repeated=True)
  inheritanceMode = _messages.EnumField('InheritanceModeValueValuesEnum', 4)
  publishing = _messages.MessageField('GoogleCloudDataplexV1AssetDiscoverySpecMetadataPublishing', 5)
  schedule = _messages.StringField(6)


class GoogleCloudDataplexV1AssetDiscoverySpecMetadataPublishing(_messages.Message):
  r"""Settings to manage metadata publishing for an asset.

  Fields:
    filesetNamePrefix: Immutable. The prefix for fileset names. If provided,
      fileset names are prefixed with the specified value.
    tableNamePrefix: Immutable. The prefix for table names. If provided, table
      names are prefixed with the specified value.
  """

  filesetNamePrefix = _messages.StringField(1)
  tableNamePrefix = _messages.StringField(2)


class GoogleCloudDataplexV1AssetDiscoveryStatus(_messages.Message):
  r"""Status of discovery for an asset.

  Enums:
    StateValueValuesEnum: The current status of the discovery feature.

  Fields:
    lastRunDuration: The duration of the last run of the discovery job of the
      asset.
    lastRunTime: The time when the last discovery job started.
    latestProcessedChangeTime: Timestamp of the latest change to data that has
      been processed. This is only valid when discovery is in
      PROCESSING_CHANGES state.
    message: Additional information about the current state.
    nextRunTime: The time when the next scheduled discovery job will start.
    state: The current status of the discovery feature.
    stats: Data Stats of the asset reported by discovery.
    updateTime: Last update time of the status.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current status of the discovery feature.

    Values:
      STATE_UNSPECIFIED: State is unspecified.
      SCHEDULED: Discovery for the asset is scheduled.
      IN_PROGRESS: Discovery for the asset is running.
      PAUSED: User-provided discovery schedule is temporarily ineffective, and
        discovery runs on an alternative schedule when there is any pending
        discovery action.
      ERROR: Discovery for the asset has errors.
      DISABLED: Discovery for the asset is disabled.
      PROCESSING_DATA: Discovery for the asset is processing all the data in
        the storage resource.
      PROCESSING_CHANGES: Discovery for the asset is processing changes to the
        data.
    """
    STATE_UNSPECIFIED = 0
    SCHEDULED = 1
    IN_PROGRESS = 2
    PAUSED = 3
    ERROR = 4
    DISABLED = 5
    PROCESSING_DATA = 6
    PROCESSING_CHANGES = 7

  lastRunDuration = _messages.StringField(1)
  lastRunTime = _messages.StringField(2)
  latestProcessedChangeTime = _messages.StringField(3)
  message = _messages.StringField(4)
  nextRunTime = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  stats = _messages.MessageField('GoogleCloudDataplexV1AssetDiscoveryStatusStats', 7)
  updateTime = _messages.StringField(8)


class GoogleCloudDataplexV1AssetDiscoveryStatusStats(_messages.Message):
  r"""The aggregated data statistics for the asset reported by discovery. The
  data is collected from the last run of the discovery jobs.

  Fields:
    dataItems: The count of data items within the referenced resource.
    dataRangeEndTime: The latest update timestamp of data in the attached
      resource (e.g. Cloud Storage objects, or BigQuery tables).
    dataRangeStartTime: The earilest creation timestamp of data in the
      attached resource (e.g. Cloud Storage objects, or BigQuery tables).
    dataSize: The number of stored data bytes within the referenced resource.
    filesets: The count of fileset entities within the referenced resource.
    tables: The count of table entities within the referenced resource.
  """

  dataItems = _messages.IntegerField(1)
  dataRangeEndTime = _messages.StringField(2)
  dataRangeStartTime = _messages.StringField(3)
  dataSize = _messages.IntegerField(4)
  filesets = _messages.IntegerField(5)
  tables = _messages.IntegerField(6)


class GoogleCloudDataplexV1AssetResourceSpec(_messages.Message):
  r"""Identifies the cloud resource that is referenced by this asset.

  Enums:
    CreationPolicyValueValuesEnum: Immutable. Creation policy for the
      referenced resource.
    DeletionPolicyValueValuesEnum: Optional. Deletion policy for the
      referenced resource.
    TypeValueValuesEnum: Required. Immutable. Type of resource.

  Fields:
    creationPolicy: Immutable. Creation policy for the referenced resource.
    deletionPolicy: Optional. Deletion policy for the referenced resource.
    name: Immutable. Relative name of the cloud resource that contains the
      data that is being managed within a lake. For example:
      projects/{project_number}/buckets/{bucket_id}
      projects/{project_number}/datasets/{dataset_id} If the creation policy
      indicates ATTACH behavior, then an existing resource must be provided.
      If the policy indicates CREATE behavior, new resource will be created
      with the given name.However if it is empty, nthen the resource will be
      created using {asset_id}-{UUID} template for name. The location of the
      referenced resource must always match that of the asset.
    type: Required. Immutable. Type of resource.
  """

  class CreationPolicyValueValuesEnum(_messages.Enum):
    r"""Immutable. Creation policy for the referenced resource.

    Values:
      CREATION_POLICY_UNSPECIFIED: Policy not specified.
      ATTACH_RESOURCE: Attach existing resource. This is the default behavior.
      CREATE_RESOURCE: Create a new resource for the asset.
    """
    CREATION_POLICY_UNSPECIFIED = 0
    ATTACH_RESOURCE = 1
    CREATE_RESOURCE = 2

  class DeletionPolicyValueValuesEnum(_messages.Enum):
    r"""Optional. Deletion policy for the referenced resource.

    Values:
      DELETION_POLICY_UNSPECIFIED: Policy not specified.
      DETACH_RESOURCE: Detach resource when asset is deleted. This is the
        default behavior.
      DELETE_RESOURCE: Delete resource when the asset is deleted.
    """
    DELETION_POLICY_UNSPECIFIED = 0
    DETACH_RESOURCE = 1
    DELETE_RESOURCE = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. Type of resource.

    Values:
      TYPE_UNSPECIFIED: Type not specified.
      STORAGE_BUCKET: Cloud Storage bucket.
      BIGQUERY_DATASET: BigQuery dataset.
    """
    TYPE_UNSPECIFIED = 0
    STORAGE_BUCKET = 1
    BIGQUERY_DATASET = 2

  creationPolicy = _messages.EnumField('CreationPolicyValueValuesEnum', 1)
  deletionPolicy = _messages.EnumField('DeletionPolicyValueValuesEnum', 2)
  name = _messages.StringField(3)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class GoogleCloudDataplexV1AssetResourceStatus(_messages.Message):
  r"""Status of the resource referenced by an asset.

  Enums:
    StateValueValuesEnum: The current state of the managed resource.

  Fields:
    message: Additional information about the current state.
    state: The current state of the managed resource.
    updateTime: Last update time of the status.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the managed resource.

    Values:
      STATE_UNSPECIFIED: State unspecified.
      READY: Resource does not have any errors.
      ERROR: Resource has errors.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    ERROR = 2

  message = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  updateTime = _messages.StringField(3)


class GoogleCloudDataplexV1AssetSecuritySpec(_messages.Message):
  r"""Settings to manage the security policy applied to data referenced by an
  asset.

  Fields:
    overrideParentSpec: Optional. Indicates whether the policy overrides the
      list of groups specified in the policy associated with the parent lake
      and zone. By default, the policy is additive. If this flag is true, the
      list of groups must each include at least one entry.
    ownerGroups: Optional. A list of groups that should be granted the
      roles/dataplex.dataOwner IAM role, that allows group members to modify
      the resources (including their IAM policies and child resources)
      referenced by an asset. For example, yourgroup@yourdomain.com. It cannot
      be a service account, user or another type of identity.
    readerGroups: Optional. A list of groups that should be granted the
      roles/dataplex.dataReader IAM role, that allows group members to read
      data referenced by an asset. For example, yourgroup@yourdomain.com. It
      cannot be a service account, user or another type of identity.
    writerGroups: Optional. A list of groups that should be granted the
      roles/dataplex.dataWriter IAM role, that allows group members to update
      data referenced by an asset. For example, yourgroup@yourdomain.com. It
      cannot be a service account, user or another type of identity.
  """

  overrideParentSpec = _messages.BooleanField(1)
  ownerGroups = _messages.StringField(2, repeated=True)
  readerGroups = _messages.StringField(3, repeated=True)
  writerGroups = _messages.StringField(4, repeated=True)


class GoogleCloudDataplexV1AssetSecurityStatus(_messages.Message):
  r"""Security policy status of the asset. Data security policy, i.e.,
  readers, writers & owners, should be specified in the lake/zone/asset IAM
  policy.

  Enums:
    StateValueValuesEnum: The current state of the security policy applied to
      the attached resource.

  Fields:
    appliedOwnerGroups: Cumulative set of owner groups that were last applied
      on the managed resource. These groups may have been specified at lake,
      zone or asset levels.
    appliedReaderGroups: Cumulative set of reader groups that were last
      applied on the managed resource. These groups may have been specified at
      lake, zone or asset levels.
    appliedWriterGroups: Cumulative set of writer groups that were last
      applied on the managed resource. These groups may have been specified at
      lake, zone or asset levels.
    message: Additional information about the current state.
    state: The current state of the security policy applied to the attached
      resource.
    updateTime: Last update time of the status.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the security policy applied to the attached
    resource.

    Values:
      STATE_UNSPECIFIED: State unspecified.
      READY: Security policy has been successfully applied to the attached
        resource.
      APPLYING: Security policy is in the process of being applied to the
        attached resource.
      ERROR: Security policy could not be applied to the attached resource due
        to errors.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    APPLYING = 2
    ERROR = 3

  appliedOwnerGroups = _messages.StringField(1, repeated=True)
  appliedReaderGroups = _messages.StringField(2, repeated=True)
  appliedWriterGroups = _messages.StringField(3, repeated=True)
  message = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  updateTime = _messages.StringField(6)


class GoogleCloudDataplexV1AssetStatus(_messages.Message):
  r"""Aggregated status of the underlying assets of a lake or zone.

  Fields:
    activeAssets: Number of active assets.
    securityPolicyApplyingAssets: Number of assets that are in process of
      updating the security policy on attached resources.
    updateTime: Last update time of the status.
  """

  activeAssets = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  securityPolicyApplyingAssets = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  updateTime = _messages.StringField(3)


class GoogleCloudDataplexV1Entity(_messages.Message):
  r"""Represents tables and fileset metadata contained within a Zone.

  Enums:
    SystemValueValuesEnum: Required. Identifies the storage system of the
      entity data.
    TypeValueValuesEnum: Required. The type of entity.

  Fields:
    asset: Required. The name of the asset associated with the storage
      location containing the entity data.
    catalogEntry: Output only. The name of the associated Data Catalog entry.
    compatibility: Output only. Metadata stores the entity is compatible with.
    compatibilityDeprecated: Output only. Metadata stores the entity is
      compatible with.
    createTime: Output only. The time when the entity was created.
    dataPath: Required. Immutable. The storage path of the entity data. For
      Cloud Storage data, this is the fully-qualified path to the entity, such
      as gs://bucket/path/to/data. For BigQuery data, this is the name of the
      table resource such as
      projects/project_id/datasets/dataset_id/tables/table_id.
    dataPathPattern: Optional. The set of items within the data path
      constituting the data in the entity represented as a glob path. Eg.
      gs://bucket/path/to/data/**/*.csv.
    description: Optional. User friendly longer description text.
    displayName: Optional. User friendly display name.
    etag: Optional. The etag for this entity. Required for update requests, it
      must match the server's etag.
    format: Required. Identifies the storage format of the entity data. This
      does not apply to entities with data stored in BigQuery.
    id: Required. A user provide entity ID. It is mutable and will be used for
      the published table name.
    name: Output only. Immutable. The resource name of the entity, of the
      form: projects/{project_number}/locations/{location_id}/lakes/{lake_id}/
      zones/{zone_id}/entities/{entity} The {entity} is a generated unique ID.
    schema: Required. The description of the data structure and layout. Schema
      is not included in list responses and only included in SCHEMA and FULL
      entity views of get entity response.
    system: Required. Identifies the storage system of the entity data.
    type: Required. The type of entity.
    updateTime: Output only. The time when the entity was last updated.
  """

  class SystemValueValuesEnum(_messages.Enum):
    r"""Required. Identifies the storage system of the entity data.

    Values:
      STORAGE_SYSTEM_UNSPECIFIED: StorageSystem unspecified.
      CLOUD_STORAGE: The entity data is contained within a Cloud Storage
        bucket.
      BIGQUERY: The entity data is contained within a BigQuery dataset.
    """
    STORAGE_SYSTEM_UNSPECIFIED = 0
    CLOUD_STORAGE = 1
    BIGQUERY = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of entity.

    Values:
      TYPE_UNSPECIFIED: Type unspecified.
      TABLE: Structured and semi-structured data.
      FILESET: Unstructured data.
    """
    TYPE_UNSPECIFIED = 0
    TABLE = 1
    FILESET = 2

  asset = _messages.StringField(1)
  catalogEntry = _messages.StringField(2)
  compatibility = _messages.MessageField('GoogleCloudDataplexV1EntityCompatibilityStatus', 3)
  compatibilityDeprecated = _messages.MessageField('GoogleCloudDataplexV1EntityCompatibility', 4)
  createTime = _messages.StringField(5)
  dataPath = _messages.StringField(6)
  dataPathPattern = _messages.StringField(7)
  description = _messages.StringField(8)
  displayName = _messages.StringField(9)
  etag = _messages.StringField(10)
  format = _messages.MessageField('GoogleCloudDataplexV1StorageFormat', 11)
  id = _messages.StringField(12)
  name = _messages.StringField(13)
  schema = _messages.MessageField('GoogleCloudDataplexV1Schema', 14)
  system = _messages.EnumField('SystemValueValuesEnum', 15)
  type = _messages.EnumField('TypeValueValuesEnum', 16)
  updateTime = _messages.StringField(17)


class GoogleCloudDataplexV1EntityCompatibility(_messages.Message):
  r"""Metadata stores the entity is compatible with.

  Fields:
    bigquery: Output only. Whether the entity can be represented in BigQuery.
    hiveMetastore: Output only. Whether the entity can be represented in Hive
      Metastore.
  """

  bigquery = _messages.BooleanField(1)
  hiveMetastore = _messages.BooleanField(2)


class GoogleCloudDataplexV1EntityCompatibilityStatus(_messages.Message):
  r"""Provides information about compatibility with various metadata stores.

  Fields:
    bigquery: Output only. Whether this entity is compatible with BigQuery.
    hiveMetastore: Output only. Whether this entity is compatible with Hive
      Metastore.
  """

  bigquery = _messages.MessageField('GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility', 1)
  hiveMetastore = _messages.MessageField('GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility', 2)


class GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility(_messages.Message):
  r"""Provides information about compatibility for a specific metadata store.

  Fields:
    compatible: Output only. Whether the entity is compatible and can be
      represented in the metadata store.
    reason: Output only. Provides additional detail if the entity is
      incompatible with the metadata store.
  """

  compatible = _messages.BooleanField(1)
  reason = _messages.StringField(2)


class GoogleCloudDataplexV1JobEvent(_messages.Message):
  r"""The payload associated with Job logs that contains events describing
  jobs that have run within a Lake.

  Fields:
    discovery: Details about the discovery job.
    endTime: The time when the job ended running.
    jobId: The unique id identifying the job.
    message: The log message.
    startTime: The time when the job started running.
  """

  discovery = _messages.MessageField('GoogleCloudDataplexV1JobEventDiscoveryDetails', 1)
  endTime = _messages.StringField(2)
  jobId = _messages.StringField(3)
  message = _messages.StringField(4)
  startTime = _messages.StringField(5)


class GoogleCloudDataplexV1JobEventDiscoveryDetails(_messages.Message):
  r"""Details about discovery jobs.

  Fields:
    actionsDetected: Whether the job resulted in actions on the asset.
    assetId: The id of the associated asset.
    dataItemsRead: The number of data items within the asset that were read.
    metadataEventCount: The number of metadata events logged in this job.
    zoneId: The id of the associated zone.
  """

  actionsDetected = _messages.BooleanField(1)
  assetId = _messages.StringField(2)
  dataItemsRead = _messages.IntegerField(3)
  metadataEventCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  zoneId = _messages.StringField(5)


class GoogleCloudDataplexV1Lake(_messages.Message):
  r"""A lake is a centralized repository for managing enterprise data across
  the organization distributed across many cloud projects, and stored in a
  variety of storage services such as Google Cloud Storage and BigQuery. The
  resources attached to a lake are referred to as managed resources. Data
  within these managed resources can be structured or unstructured. A lake
  provides data admins with tools to organize, secure and manage their data at
  scale, and provides data scientists and data engineers an integrated
  experience to easily search, discover, analyze and transform data and
  associated metadata.

  Enums:
    StateValueValuesEnum: Output only. Current state of the lake.

  Messages:
    LabelsValue: Optional. User-defined labels for the lake.

  Fields:
    actions: Output only. The current set of actions required of the
      administrator for this lake.
    assetStatus: Output only. Aggregated status of the underlying assets of
      the lake.
    createTime: Output only. The time when the lake was created.
    description: Optional. Description of the lake.
    displayName: Optional. User friendly display name.
    labels: Optional. User-defined labels for the lake.
    metastore: Optional. Settings to manage lake and Dataproc Metastore
      service instance association.
    metastoreStatus: Output only. Metastore status of the lake.
    name: Output only. The relative resource name of the lake, of the form:
      projects/{project_number}/locations/{location_id}/lakes/{lake_id}
    securitySpec: Optional. Specification of the security policy applied to
      data in this lake. Typically it should take a few minutes for the
      security policy to fully propagate.
    securityStatus: Output only. Status of the security policy applied to data
      in this lake.
    serviceAccount: Output only. Service account associated with this lake.
      This service account must be authorized to access or operate on
      resources managed by the lake.
    state: Output only. Current state of the lake.
    uid: Output only. System generated globally unique ID for the lake. This
      ID will be different if the lake is deleted and re-created with the same
      name.
    updateTime: Output only. The time when the lake was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the lake.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels for the lake.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  actions = _messages.MessageField('GoogleCloudDataplexV1Action', 1, repeated=True)
  assetStatus = _messages.MessageField('GoogleCloudDataplexV1AssetStatus', 2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  metastore = _messages.MessageField('GoogleCloudDataplexV1LakeMetastore', 7)
  metastoreStatus = _messages.MessageField('GoogleCloudDataplexV1LakeMetastoreStatus', 8)
  name = _messages.StringField(9)
  securitySpec = _messages.MessageField('GoogleCloudDataplexV1LakeSecuritySpec', 10)
  securityStatus = _messages.MessageField('GoogleCloudDataplexV1SecurityStatus', 11)
  serviceAccount = _messages.StringField(12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  uid = _messages.StringField(14)
  updateTime = _messages.StringField(15)


class GoogleCloudDataplexV1LakeMetastore(_messages.Message):
  r"""Settings to manage association of Dataproc Metastore with a lake.

  Fields:
    service: Optional. A relative reference to the Dataproc Metastore
      (https://cloud.google.com/dataproc-metastore/docs) service associated
      with the lake:
      projects/{project_id}/locations/{location_id}/services/{service_id}
  """

  service = _messages.StringField(1)


class GoogleCloudDataplexV1LakeMetastoreStatus(_messages.Message):
  r"""Status of Lake and Dataproc Metastore service instance association.

  Enums:
    StateValueValuesEnum: Current state of association.

  Fields:
    message: Additional information about the current status.
    state: Current state of association.
    updateTime: Last update time of the metastore status of the lake.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Current state of association.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      NONE: A Metastore service instance is not associated with the lake.
      READY: A Metastore service instance is attached to the lake.
      UPDATING: Attach/detach is in progress.
      ERROR: Attach/detach could not be done due to errors.
    """
    STATE_UNSPECIFIED = 0
    NONE = 1
    READY = 2
    UPDATING = 3
    ERROR = 4

  message = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  updateTime = _messages.StringField(3)


class GoogleCloudDataplexV1LakeSecuritySpec(_messages.Message):
  r"""Settings to manage the security policy applied to data in a lake.

  Fields:
    ownerGroups: Optional. A list of groups that should be granted the
      roles/dataplex.dataOwner IAM role, that allows group members to modify
      the resources (including their IAM policies and child resources) managed
      within a lake. By default this is inherited by all assets within the
      lake. For example, yourgroup@yourdomain.com. It cannot be a service
      account, user or another type of identity.
    readerGroups: Optional. A list of groups that should be granted the
      roles/dataplex.dataReader IAM role, that allows group members to read
      data being managed within a lake. By default this is inherited by all
      assets within a lake. For example, yourgroup@yourdomain.com. It cannot
      be a service account, user or another type of identity.
    writerGroups: Optional. A list of groups that should be granted the
      roles/dataplex.dataWriter IAM role, that allows group members to update
      data being managed within a lake. By default this is inherited by all
      assets within a lake. For example, yourgroup@yourdomain.com. It cannot
      be a service account, user or another type of identity.
  """

  ownerGroups = _messages.StringField(1, repeated=True)
  readerGroups = _messages.StringField(2, repeated=True)
  writerGroups = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListActionsResponse(_messages.Message):
  r"""List actions response.

  Fields:
    actions: Actions under the given parent lake/zone/asset.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  actions = _messages.MessageField('GoogleCloudDataplexV1Action', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListAssetsResponse(_messages.Message):
  r"""List assets response.

  Fields:
    assets: Asset under the given parent zone.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  assets = _messages.MessageField('GoogleCloudDataplexV1Asset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListEntitiesResponse(_messages.Message):
  r"""List metadata entities response.

  Fields:
    entities: Entities under the given parent zone.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  entities = _messages.MessageField('GoogleCloudDataplexV1Entity', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDataplexV1ListLakesResponse(_messages.Message):
  r"""List lakes response.

  Fields:
    lakes: Lakes under the given parent location.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachableLocations: Locations that could not be reached.
  """

  lakes = _messages.MessageField('GoogleCloudDataplexV1Lake', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachableLocations = _messages.StringField(3, repeated=True)


class GoogleCloudDataplexV1ListPartitionsResponse(_messages.Message):
  r"""List metadata partitions response.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    partitions: Partitions under the given parent entity.
  """

  nextPageToken = _messages.StringField(1)
  partitions = _messages.MessageField('GoogleCloudDataplexV1Partition', 2, repeated=True)


class GoogleCloudDataplexV1ListZonesResponse(_messages.Message):
  r"""List zones response.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    zones: Zones under the given parent lake.
  """

  nextPageToken = _messages.StringField(1)
  zones = _messages.MessageField('GoogleCloudDataplexV1Zone', 2, repeated=True)


class GoogleCloudDataplexV1MetadataEvent(_messages.Message):
  r"""The payload associated with Metadata logs that contains events
  describing entities that were discovered.

  Enums:
    EntityTypeValueValuesEnum: The type of the entity being created, updated
      or deleted.
    EventTypeValueValuesEnum: The type of event.

  Fields:
    assetId: The id of the associated asset.
    entityType: The type of the entity being created, updated or deleted.
    eventType: The type of event.
    fileset: The fileset being created, updated or deleted.
    jobId: The unique id of the discovery job that resulted in this event.
    message: The log message.
    partition: The partition being created or deleted.
    table: The table being created, updated or deleted.
  """

  class EntityTypeValueValuesEnum(_messages.Enum):
    r"""The type of the entity being created, updated or deleted.

    Values:
      ENTITY_TYPE_UNSPECIFIED: An unspecified entity type.
      TABLE: An event representing a table.
      FILESET: An event representing a fileset.
      PARTITION: An event representing a partition within a table or fileset.
    """
    ENTITY_TYPE_UNSPECIFIED = 0
    TABLE = 1
    FILESET = 2
    PARTITION = 3

  class EventTypeValueValuesEnum(_messages.Enum):
    r"""The type of event.

    Values:
      EVENT_TYPE_UNSPECIFIED: An unspecified event type.
      CREATE: An event representing a metadata entity being created.
      UPDATE: An event representing a metadata entity being updated.
      DELETE: An event representing a metadata entity being deleted.
    """
    EVENT_TYPE_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2
    DELETE = 3

  assetId = _messages.StringField(1)
  entityType = _messages.EnumField('EntityTypeValueValuesEnum', 2)
  eventType = _messages.EnumField('EventTypeValueValuesEnum', 3)
  fileset = _messages.MessageField('GoogleCloudDataplexV1MetadataEventFileset', 4)
  jobId = _messages.StringField(5)
  message = _messages.StringField(6)
  partition = _messages.MessageField('GoogleCloudDataplexV1MetadataEventPartition', 7)
  table = _messages.MessageField('GoogleCloudDataplexV1MetadataEventTable', 8)


class GoogleCloudDataplexV1MetadataEventFileset(_messages.Message):
  r"""Details about fileset entities being created, updated or deleted.

  Fields:
    dataFormat: The format of the data within the fileset.
    dataItemsCount: The number of data items in the fileset.
    location: The data location of the fileset.
    name: The name of the fileset entity.
  """

  dataFormat = _messages.StringField(1)
  dataItemsCount = _messages.IntegerField(2)
  location = _messages.StringField(3)
  name = _messages.StringField(4)


class GoogleCloudDataplexV1MetadataEventPartition(_messages.Message):
  r"""Details about paritions of entities being created or deleted.

  Messages:
    KeysValue: The set of key/value pairs identifying the partition.

  Fields:
    dataItemsCount: The number of data items in the partition.
    entity: The name of the table or fileset entity containing this partition.
    keys: The set of key/value pairs identifying the partition.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class KeysValue(_messages.Message):
    r"""The set of key/value pairs identifying the partition.

    Messages:
      AdditionalProperty: An additional property for a KeysValue object.

    Fields:
      additionalProperties: Additional properties of type KeysValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a KeysValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dataItemsCount = _messages.IntegerField(1)
  entity = _messages.StringField(2)
  keys = _messages.MessageField('KeysValue', 3)


class GoogleCloudDataplexV1MetadataEventTable(_messages.Message):
  r"""Details about table entities being created, updated or deleted.

  Fields:
    dataFormat: The format of the data within the table.
    dataItemsCount: The number of data items in the table.
    externalTables: The list of associated external tables published for the
      table. This is formatted using fully-qualified names such as:
      dpms:project.location.service.database.table and
      bigquery:project.location.dataset.table
    location: The data location of the table.
    name: The name of the table entity.
    schema: The schema of the table.
  """

  dataFormat = _messages.StringField(1)
  dataItemsCount = _messages.IntegerField(2)
  externalTables = _messages.StringField(3, repeated=True)
  location = _messages.StringField(4)
  name = _messages.StringField(5)
  schema = _messages.StringField(6)


class GoogleCloudDataplexV1OperationMetadata(_messages.Message):
  r"""Represents the metadata of a long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to Code.CANCELLED.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class GoogleCloudDataplexV1Partition(_messages.Message):
  r"""Represents partition metadata contained within Entity instances.

  Fields:
    etag: Optional. The etag for this partitioin. Required for update
      requests, it must match the server's etag.
    location: Required. Immutable. The location of the entity data within the
      partition. Eg. gs://bucket/path/to/entity/key1=value1/key2=value2
    name: Output only. The resource name of the entity, of the form: projects/
      {project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}
      /entities/{entity}/partitions/{partition} The {partition} is a generated
      unique ID.
    values: Required. Immutable. The set of values representing the partition.
      These correspond to the partition schema defined in the parent entity.
  """

  etag = _messages.StringField(1)
  location = _messages.StringField(2)
  name = _messages.StringField(3)
  values = _messages.StringField(4, repeated=True)


class GoogleCloudDataplexV1ResolveAssetActionsRequest(_messages.Message):
  r"""ResolveAssetActions request."""


class GoogleCloudDataplexV1ResolveLakeActionsRequest(_messages.Message):
  r"""ResolveLakeActions request."""


class GoogleCloudDataplexV1ResolveZoneActionsRequest(_messages.Message):
  r"""ResolveZoneActions request."""


class GoogleCloudDataplexV1Schema(_messages.Message):
  r"""The schema information describing the structure and layout of the data.

  Enums:
    PartitionStyleValueValuesEnum: Optional. The structure of paths containing
      partition data within the entity.

  Fields:
    fields: Optional. The sequence of fields describing data in table
      entities.
    partitionFields: Optional. The sequence of fields describing the partition
      structure in entities. If this is empty, there are no partitions within
      the data.
    partitionStyle: Optional. The structure of paths containing partition data
      within the entity.
    userManaged: Required. Whether the schema is user managed, or managed by
      the service. User managed schemas are not automatically updated by
      discovery jobs.
  """

  class PartitionStyleValueValuesEnum(_messages.Enum):
    r"""Optional. The structure of paths containing partition data within the
    entity.

    Values:
      PARTITION_STYLE_UNSPECIFIED: PartitionStyle unspecified
      HIVE_COMPATIBLE: Partitions are hive-compatible. Eg.
        gs://bucket/path/to/table/dt=2019-10-31/lang=en Eg.
        gs://bucket/path/to/table/dt=2019-10-31/lang=en/late
    """
    PARTITION_STYLE_UNSPECIFIED = 0
    HIVE_COMPATIBLE = 1

  fields = _messages.MessageField('GoogleCloudDataplexV1SchemaSchemaField', 1, repeated=True)
  partitionFields = _messages.MessageField('GoogleCloudDataplexV1SchemaPartitionField', 2, repeated=True)
  partitionStyle = _messages.EnumField('PartitionStyleValueValuesEnum', 3)
  userManaged = _messages.BooleanField(4)


class GoogleCloudDataplexV1SchemaPartitionField(_messages.Message):
  r"""Represents a key field within the entity's partition structure.

  Enums:
    TypeValueValuesEnum: Required. The type of the field.

  Fields:
    name: Required. The name of the field.
    type: Required. The type of the field.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the field.

    Values:
      TYPE_UNSPECIFIED: SchemaType unspecified.
      BOOLEAN: Boolean field.
      BYTE: Single byte numeric field.
      INT16: 16-bit numeric field.
      INT32: 32-bit numeric field.
      INT64: 64-bit numeric field.
      FLOAT: Floating point numeric field.
      DOUBLE: Double precision numeric field.
      DECIMAL: Real value numeric field.
      STRING: Sequence of characters field.
      BINARY: Sequence of bytes field.
      TIMESTAMP: Date and time field.
      DATE: Date field.
      TIME: Time field.
      RECORD: Structured field. The nested fields define the structure of the
        map. If all the nested fields are nullable, this represents a union.
    """
    TYPE_UNSPECIFIED = 0
    BOOLEAN = 1
    BYTE = 2
    INT16 = 3
    INT32 = 4
    INT64 = 5
    FLOAT = 6
    DOUBLE = 7
    DECIMAL = 8
    STRING = 9
    BINARY = 10
    TIMESTAMP = 11
    DATE = 12
    TIME = 13
    RECORD = 14

  name = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudDataplexV1SchemaSchemaField(_messages.Message):
  r"""Represents a column field within a table schema.

  Enums:
    ModeValueValuesEnum: Required. Additional field semantics.
    TypeValueValuesEnum: Required. The type of the field.

  Fields:
    description: Optional. User friendly field description.
    fields: Optional. Any nested field for complex types.
    mode: Required. Additional field semantics.
    name: Required. The name of the field.
    type: Required. The type of the field.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Required. Additional field semantics.

    Values:
      MODE_UNSPECIFIED: Mode unspecified.
      REQUIRED: The field has required semantics.
      NULLABLE: The field has optional semantics and may be null.
      REPEATED: The field has repeated (0 or more) semantics and is a list of
        values.
    """
    MODE_UNSPECIFIED = 0
    REQUIRED = 1
    NULLABLE = 2
    REPEATED = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the field.

    Values:
      TYPE_UNSPECIFIED: SchemaType unspecified.
      BOOLEAN: Boolean field.
      BYTE: Single byte numeric field.
      INT16: 16-bit numeric field.
      INT32: 32-bit numeric field.
      INT64: 64-bit numeric field.
      FLOAT: Floating point numeric field.
      DOUBLE: Double precision numeric field.
      DECIMAL: Real value numeric field.
      STRING: Sequence of characters field.
      BINARY: Sequence of bytes field.
      TIMESTAMP: Date and time field.
      DATE: Date field.
      TIME: Time field.
      RECORD: Structured field. The nested fields define the structure of the
        map. If all the nested fields are nullable, this represents a union.
    """
    TYPE_UNSPECIFIED = 0
    BOOLEAN = 1
    BYTE = 2
    INT16 = 3
    INT32 = 4
    INT64 = 5
    FLOAT = 6
    DOUBLE = 7
    DECIMAL = 8
    STRING = 9
    BINARY = 10
    TIMESTAMP = 11
    DATE = 12
    TIME = 13
    RECORD = 14

  description = _messages.StringField(1)
  fields = _messages.MessageField('GoogleCloudDataplexV1SchemaSchemaField', 2, repeated=True)
  mode = _messages.EnumField('ModeValueValuesEnum', 3)
  name = _messages.StringField(4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class GoogleCloudDataplexV1SecurityStatus(_messages.Message):
  r"""Status of the security policy specified on lakes & zones.

  Enums:
    StateValueValuesEnum: The current state of the security policy applied to
      data.

  Fields:
    message: Additional information about the current state.
    state: The current state of the security policy applied to data.
    updateTime: Last update time of the status.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the security policy applied to data.

    Values:
      STATE_UNSPECIFIED: State unspecified.
      READY: Security policy has been successfully applied to data.
      APPLYING: Security policy is in the process of being applied to data.
      ERROR: Security policy could not be applied to data due to errors.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    APPLYING = 2
    ERROR = 3

  message = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  updateTime = _messages.StringField(3)


class GoogleCloudDataplexV1StorageFormat(_messages.Message):
  r"""Describes the format of the data within its storage location.

  Enums:
    CompressionFormatValueValuesEnum: Optional. The compression type
      associated with the stored data. If this is not specified, the data is
      uncompressed.
    FormatValueValuesEnum: Required. The data format associated with the
      stored data, represented using content type values.

  Fields:
    compressionFormat: Optional. The compression type associated with the
      stored data. If this is not specified, the data is uncompressed.
    csv: Optional. Additional information about CSV formatted data.
    format: Required. The data format associated with the stored data,
      represented using content type values.
    json: Optional. Additional information about CSV formatted data.
    mimeType: Optional. The mime type descriptor for the data. This is valid
      for formats other than UNKNOWN and MIXED.
    userManaged: Required. Whether the format and content type are user-
      managed or managed by the service. User managed formats are not
      automatically updated by discovery jobs.
  """

  class CompressionFormatValueValuesEnum(_messages.Enum):
    r"""Optional. The compression type associated with the stored data. If
    this is not specified, the data is uncompressed.

    Values:
      COMPRESSION_FORMAT_UNSPECIFIED: CompressionFormat unspecified. Implies
        uncompressed data.
      ZIP: Zip compressed set of files.
      GZIP: GZip compressed set of files.
      BZIP2: BZip2 compressed set of files.
    """
    COMPRESSION_FORMAT_UNSPECIFIED = 0
    ZIP = 1
    GZIP = 2
    BZIP2 = 3

  class FormatValueValuesEnum(_messages.Enum):
    r"""Required. The data format associated with the stored data, represented
    using content type values.

    Values:
      FORMAT_UNSPECIFIED: Format unspecified.
      PARQUET: Parquet-formatted structured data.
      AVRO: Avro-formatted structured data.
      ORC: Orc-formatted structured data.
      CSV: Csv-formatted semi-structured data.
      JSON: Json-formatted semi-structured data.
      IMAGE: Image data formats (such as jpg, png, etc.)
      AUDIO: Audio data formats (such as mp3, wav, etc.)
      VIDEO: Video data formats (such as mp4, mpg, etc.)
      TEXT: Textual data formats (such as txt, xml, etc.)
      TFRECORD: TensorFlow record format
      OTHER: Data that doesn't match a specific format.
      UNKNOWN: Data of an unknown format.
    """
    FORMAT_UNSPECIFIED = 0
    PARQUET = 1
    AVRO = 2
    ORC = 3
    CSV = 4
    JSON = 5
    IMAGE = 6
    AUDIO = 7
    VIDEO = 8
    TEXT = 9
    TFRECORD = 10
    OTHER = 11
    UNKNOWN = 12

  compressionFormat = _messages.EnumField('CompressionFormatValueValuesEnum', 1)
  csv = _messages.MessageField('GoogleCloudDataplexV1StorageFormatCsvOptions', 2)
  format = _messages.EnumField('FormatValueValuesEnum', 3)
  json = _messages.MessageField('GoogleCloudDataplexV1StorageFormatJsonOptions', 4)
  mimeType = _messages.StringField(5)
  userManaged = _messages.BooleanField(6)


class GoogleCloudDataplexV1StorageFormatCsvOptions(_messages.Message):
  r"""Describes CSV and similar semi-structured data formats.

  Fields:
    delimiter: Optional. The delimiter being used to separate values. This
      defaults to ','.
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
    headerRows: Optional. The number of rows to interpret as header rows that
      should be skipped when reading data rows.
    quote: Optional. The character used to quote column values. This defaults
      to empty, implying unquoted data.
  """

  delimiter = _messages.StringField(1)
  encoding = _messages.StringField(2)
  headerRows = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  quote = _messages.StringField(4)


class GoogleCloudDataplexV1StorageFormatJsonOptions(_messages.Message):
  r"""Describes JSON data format

  Fields:
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
  """

  encoding = _messages.StringField(1)


class GoogleCloudDataplexV1Zone(_messages.Message):
  r"""A zone represents a logical group of related assets within a lake. A
  zone can be used to map to organizational structure or represent stages of
  data readiness from raw to curated. It provides managing behavior that is
  shared or inherited by all contained assets.

  Enums:
    StateValueValuesEnum: Output only. Current state of the zone.
    TypeValueValuesEnum: Required. Immutable. The type of the zone.

  Messages:
    LabelsValue: Optional. User defined labels for the zone.

  Fields:
    actions: Output only. The current set of actions required of the
      administrator for this zone.
    assetStatus: Output only. Aggregated status of the underlying assets of
      the zone.
    createTime: Output only. The time when the zone was created.
    description: Optional. Description of the zone.
    discoverySpec: Optional. Specification of the discovery feature applied to
      data in this zone.
    displayName: Optional. User friendly display name.
    labels: Optional. User defined labels for the zone.
    name: Output only. The relative resource name of the zone, of the form: pr
      ojects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{z
      one_id}
    resourceSpec: Required. Specification of the resources that are referenced
      by the assets within this zone.
    securitySpec: Optional. Specification of the security policy applied to
      data in this zone. Typically it should take a few minutes for the
      security policy to fully propagate.
    securityStatus: Output only. Status of the security policy applied to data
      in this zone.
    state: Output only. Current state of the zone.
    type: Required. Immutable. The type of the zone.
    uid: Output only. System generated globally unique ID for the zone. This
      ID will be different if the zone is deleted and re-created with the same
      name.
    updateTime: Output only. The time when the zone was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the zone.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The type of the zone.

    Values:
      TYPE_UNSPECIFIED: Zone type not specified.
      RAW: A zone that contains data that needs further processing before it
        is considered generally ready for consumption and analytics workloads.
      CURATED: A zone that contains data that is considered to be ready for
        broader consumption and analytics workloads. Curated structured data
        stored in Cloud Storage must conform to certain file formats (parquet,
        avro and orc) and organized in a hive-compatible directory layout.
    """
    TYPE_UNSPECIFIED = 0
    RAW = 1
    CURATED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User defined labels for the zone.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  actions = _messages.MessageField('GoogleCloudDataplexV1Action', 1, repeated=True)
  assetStatus = _messages.MessageField('GoogleCloudDataplexV1AssetStatus', 2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  discoverySpec = _messages.MessageField('GoogleCloudDataplexV1ZoneDiscoverySpec', 5)
  displayName = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  resourceSpec = _messages.MessageField('GoogleCloudDataplexV1ZoneResourceSpec', 9)
  securitySpec = _messages.MessageField('GoogleCloudDataplexV1ZoneSecuritySpec', 10)
  securityStatus = _messages.MessageField('GoogleCloudDataplexV1SecurityStatus', 11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  type = _messages.EnumField('TypeValueValuesEnum', 13)
  uid = _messages.StringField(14)
  updateTime = _messages.StringField(15)


class GoogleCloudDataplexV1ZoneDiscoverySpec(_messages.Message):
  r"""Settings to manage the metadata discovery and publishing in a zone.

  Fields:
    enabled: Required. Whether discovery is enabled.
    excludePatterns: Optional. The list of patterns to apply for selecting
      data to exclude during discovery. For Cloud Storage bucket assets, these
      are interpreted as glob patterns used to match object names. For
      BigQuery dataset assets, these are interpreted as patterns to match
      table names.
    includePatterns: Optional. The list of patterns to apply for selecting
      data to include during discovery if only a subset of the data should
      considered. For Cloud Storage bucket assets, these are interpreted as
      glob patterns used to match object names. For BigQuery dataset assets,
      these are interpreted as patterns to match table names.
    publishing: Optional. Settings to manage metadata publishing from the
      zone.
    schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
      running discovery jobs periodically. Discovery jobs must be scheduled at
      least 30 minutes apart. To explicitly set a timezone to the cron tab,
      apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
      "RON_TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid
      string from IANA time zone database. For example,
      "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * *
      *".
  """

  enabled = _messages.BooleanField(1)
  excludePatterns = _messages.StringField(2, repeated=True)
  includePatterns = _messages.StringField(3, repeated=True)
  publishing = _messages.MessageField('GoogleCloudDataplexV1ZoneDiscoverySpecMetadataPublishing', 4)
  schedule = _messages.StringField(5)


class GoogleCloudDataplexV1ZoneDiscoverySpecMetadataPublishing(_messages.Message):
  r"""Settings to manage metadata publishing from a zone.

  Fields:
    bigquery: Required. Settings to manage metadata publishing to BigQuery in
      the zone.
    metastore: Required. Settings to manage metadata publishing to a Hive
      Metastore in the zone.
  """

  bigquery = _messages.MessageField('GoogleCloudDataplexV1ZoneDiscoverySpecMetadataPublishingBigQuery', 1)
  metastore = _messages.MessageField('GoogleCloudDataplexV1ZoneDiscoverySpecMetadataPublishingMetastore', 2)


class GoogleCloudDataplexV1ZoneDiscoverySpecMetadataPublishingBigQuery(_messages.Message):
  r"""Settings to manage metadata publishing to BigQuery from a zone.

  Fields:
    datasetName: Immutable. The name of the BigQuery dataset associated with
      the zone. The specified value is interpreted as a name template that can
      refer to ${lake_id} and ${zone_id} placeholders. If unspecified, this
      defaults to "${lake_id}_${zone_id}". The dataset is created in the
      project associated with the parent lake. The specified name must not
      already be in use. Upon creation, this field is updated to reflect the
      actual dataset name.
    enabled: Required. Whether to publish metadata to BigQuery.
  """

  datasetName = _messages.StringField(1)
  enabled = _messages.BooleanField(2)


class GoogleCloudDataplexV1ZoneDiscoverySpecMetadataPublishingMetastore(_messages.Message):
  r"""Settings to manage metadata publishing to a Hive Metastore from a zone.

  Fields:
    databaseName: Immutable. The name of the metastore database associated
      with the zone. The specified value is interpreted as a name template
      that can refer to ${lake_id} and ${zone_id} placeholders. If
      unspecified, this defaults to "${lake_id}_${zone_id}". The database is
      created in the metastore instance associated with the parent lake. The
      specified name must not already be in use. Upon creation, this field is
      updated to reflect the actual database name. Maximum length is 128.
    enabled: Required. Whether to publish metadata to metastore.
  """

  databaseName = _messages.StringField(1)
  enabled = _messages.BooleanField(2)


class GoogleCloudDataplexV1ZoneResourceSpec(_messages.Message):
  r"""Settings for resources attached as assets within a zone.

  Enums:
    LocationTypeValueValuesEnum: Required. Immutable. The location type of the
      resources that are allowed to be attached to the assets within this
      zone.

  Fields:
    locationType: Required. Immutable. The location type of the resources that
      are allowed to be attached to the assets within this zone.
  """

  class LocationTypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The location type of the resources that are
    allowed to be attached to the assets within this zone.

    Values:
      LOCATION_TYPE_UNSPECIFIED: Unspecified location type.
      SINGLE_REGION: Resources that are associated with a single region.
      MULTI_REGION: Resources that are associated with a multi-region
        location.
    """
    LOCATION_TYPE_UNSPECIFIED = 0
    SINGLE_REGION = 1
    MULTI_REGION = 2

  locationType = _messages.EnumField('LocationTypeValueValuesEnum', 1)


class GoogleCloudDataplexV1ZoneSecuritySpec(_messages.Message):
  r"""Settings to manage the security policy applied to data in a zone.

  Fields:
    overrideParentSpec: Optional. Indicates whether the policy overrides the
      list of groups specified in the policy associated with the parent lake
      or adds to the parent policy. By default, the policy is additive. If
      this flag is true, the list of groups must each include at least one
      entry.
    ownerGroups: Optional. A list of groups that should be granted the
      roles/dataplex.dataOwner IAM role, that allows group members to modify
      the resources (including their IAM policies and child resources) managed
      within a zone. By default this is inherited by all assets within the
      zone. For example, yourgroup@yourdomain.com. It cannot be a service
      account, user or another type of identity.
    readerGroups: Optional. A list of groups that should be granted the
      roles/dataplex.dataReader IAM role, that allows group members to read
      data being managed within a zone. By default this is inherited by all
      assets within a zone. For example, yourgroup@yourdomain.com. It cannot
      be a service account, user or another type of identity.
    writerGroups: Optional. A list of groups that should be granted the
      roles/dataplex.dataWriter IAM role, that allows group members to update
      data being managed within a zone. By default this is inherited by all
      assets within a zone. For example, yourgroup@yourdomain.com. It cannot
      be a service account, user or another type of identity.
  """

  overrideParentSpec = _messages.BooleanField(1)
  ownerGroups = _messages.StringField(2, repeated=True)
  readerGroups = _messages.StringField(3, repeated=True)
  writerGroups = _messages.StringField(4, repeated=True)


class GoogleCloudLocationListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: "us-east1".
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: "projects/example-project/locations/us-
      east1"
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.If there are AuditConfigs for both allServices and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, storage.googleapis.com, cloudsql.googleapis.com. allServices is
      a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates members with a role.

  Fields:
    condition: The condition that is associated with this binding.If the
      condition evaluates to true, then this binding applies to the current
      request.If the condition evaluates to false, then this binding does not
      apply to the current request. However, a different role binding might
      grant the same role to one or more of the members in this binding.To
      learn which resources support conditions in their IAM policies, see the
      IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. members can have the following values: allUsers: A special
      identifier that represents anyone who is on the internet; with or
      without a Google account. allAuthenticatedUsers: A special identifier
      that represents anyone who is authenticated with a Google account or a
      service account. user:{emailid}: An email address that represents a
      specific Google account. For example, alice@example.com .
      serviceAccount:{emailid}: An email address that represents a service
      account. For example, my-other-app@appspot.gserviceaccount.com.
      group:{emailid}: An email address that represents a Google group. For
      example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An
      email address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      alice@example.com?uid=123456789012345678901. If the user is recovered,
      this value reverts to user:{emailid} and the recovered user retains the
      role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An
      email address (plus unique identifier) representing a service account
      that has been recently deleted. For example, my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901. If the
      service account is undeleted, this value reverts to
      serviceAccount:{emailid} and the undeleted service account retains the
      role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email
      address (plus unique identifier) representing a Google group that has
      been recently deleted. For example,
      admins@example.com?uid=123456789012345678901. If the group is recovered,
      this value reverts to group:{emailid} and the recovered group retains
      the role in the binding. domain:{domain}: The G Suite domain (primary)
      that represents all the users of that domain. For example, google.com or
      example.com.
    role: Role that is assigned to members. For example, roles/viewer,
      roles/editor, or roles/owner.
  """

  condition = _messages.MessageField('GoogleTypeExpr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class GoogleIamV1Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.A Policy is a collection of bindings. A
  binding binds one or more members to a single role. Members can be user
  accounts, service accounts, Google groups, and domains (such as G Suite). A
  role is a named list of permissions; each role can be an IAM predefined role
  or a user-created custom role.For some types of Google Cloud resources, a
  binding can also specify a condition, which is a logical expression that
  allows access to a resource only if the expression evaluates to true. A
  condition can add constraints based on attributes of the request, the
  resource, or both. To learn which resources support conditions in their IAM
  policies, see the IAM documentation
  (https://cloud.google.com/iam/help/conditions/resource-policies).JSON
  example: { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } YAML example: bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the IAM
  documentation (https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of members to a role. Optionally, may specify
      a condition that determines how and when the bindings are applied. Each
      of the bindings must contain at least one member.
    etag: etag is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the etag in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An etag is returned in the response to getIamPolicy, and
      systems are expected to put that etag in the request to setIamPolicy to
      ensure that their change will be applied to the same version of the
      policy.Important: If you use IAM Conditions, you must include the etag
      field whenever you call setIamPolicy. If you omit this field, then IAM
      allows you to overwrite a version 3 policy with a version 1 policy, and
      all of the conditions in the version 3 policy are lost.
    version: Specifies the format of the policy.Valid values are 0, 1, and 3.
      Requests that specify an invalid value are rejected.Any operation that
      affects conditional role bindings must specify version 3. This
      requirement applies to the following operations: Getting a policy that
      includes a conditional role binding Adding a conditional role binding to
      a policy Changing a conditional role binding in a policy Removing any
      role binding, with or without a condition, from a policy that includes
      conditionsImportant: If you use IAM Conditions, you must include the
      etag field whenever you call setIamPolicy. If you omit this field, then
      IAM allows you to overwrite a version 3 policy with a version 1 policy,
      and all of the conditions in the version 3 policy are lost.If a policy
      does not include any conditions, operations on that policy may specify
      any valid version or leave the field unset.To learn which resources
      support conditions in their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleIamV1SetIamPolicyRequest(_messages.Message):
  r"""Request message for SetIamPolicy method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the resource. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used:paths: "bindings, etag"
  """

  policy = _messages.MessageField('GoogleIamV1Policy', 1)
  updateMask = _messages.StringField(2)


class GoogleIamV1TestIamPermissionsRequest(_messages.Message):
  r"""Request message for TestIamPermissions method.

  Fields:
    permissions: The set of permissions to check for the resource. Permissions
      with wildcards (such as '*' or 'storage.*') are not allowed. For more
      information see IAM Overview
      (https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleIamV1TestIamPermissionsResponse(_messages.Message):
  r"""Response message for TestIamPermissions method.

  Fields:
    permissions: A subset of TestPermissionsRequest.permissions that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as Delete, the
      response is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.

  Fields:
    done: If the value is false, it means the operation is still in progress.
      If true, the operation is completed, and either error or response is
      available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the name should be a resource name ending with operations/{unique_id}.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as Delete, the response
      is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as Delete, the response
    is google.protobuf.Empty. If the original method is standard
    Get/Create/Update, the response should be the resource. For other methods,
    the response should have the type XxxResponse, where Xxx is the original
    method name. For example, if the original method name is TakeSnapshot(),
    the inferred response type is TakeSnapshotResponse.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The Status type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by gRPC (https://github.com/grpc). Each Status message contains three
  pieces of data: error code, error message, and error details.You can find
  out more about this error model and how to work with it in the API Design
  Guide (https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeExpr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
