"""Generated message classes for vmwareengine version v1.

The Google VMWare Engine API lets you programmatically manage VMware
environments.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'vmwareengine'


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Cluster(_messages.Message):
  r"""A cluster in a private cloud.

  Enums:
    StateValueValuesEnum: Output only. State of the resource.

  Messages:
    LabelsValue: Labels are a way to attach lightweight metadata to resources
      for filtering and querying resource data. No more than 64 user labels
      can be associated with each resource. Label keys and values can be no
      longer than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).

  Fields:
    createTime: Output only. Creation time of this resource in RFC3339 text
      format.
    labels: Labels are a way to attach lightweight metadata to resources for
      filtering and querying resource data. No more than 64 user labels can be
      associated with each resource. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).
    management: Output only. True if the cluster is a management cluster;
      false otherwise. There can only be one management cluster in a private
      cloud and it has to be the first one.
    name: Output only. The resource name of this cluster. Resource names are
      schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-
      cloud/clusters/my-cluster`
    nodeCount: Required. Number of bare metal nodes in this cluster.
    nodeTypeId: Required. The canonical identifier of node types (`NodeType`)
      in this cluster. For example: standard-72.
    state: Output only. State of the resource.
    updateTime: Output only. Last update time of this resource in RFC3339 text
      format.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the resource.

    Values:
      STATE_UNSPECIFIED: The default value. This value should never be used.
      ACTIVE: The Cluster is operational and can be used by the user.
      CREATING: The Cluster is being deployed.
      UPDATING: Adding or removing of a node to the cluster, any other cluster
        specific updates.
      DELETING: The Cluster is being deleted.
      REPAIRING: The Cluster is undergoing maintenance, for example: a failed
        node is getting replaced.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    UPDATING = 3
    DELETING = 4
    REPAIRING = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are a way to attach lightweight metadata to resources for
    filtering and querying resource data. No more than 64 user labels can be
    associated with each resource. Label keys and values can be no longer than
    63 characters, can only contain lowercase letters, numeric characters,
    underscores and dashes, where label keys must start with a letter and
    international characters are allowed. The empty string is a valid value.
    Labels are set on creation and updated like any other field. Specifically,
    to add a new label, you would need to provide all of the existing labels
    along with the new label. If you only provide a map with the new label,
    all of the old labels will be removed (probably not what is desired).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  management = _messages.BooleanField(3)
  name = _messages.StringField(4)
  nodeCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  nodeTypeId = _messages.StringField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  updateTime = _messages.StringField(8)


class Credentials(_messages.Message):
  r"""Credentials for a private cloud.

  Fields:
    password: Initial password.
    username: Initial username.
  """

  password = _messages.StringField(1)
  username = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Hcx(_messages.Message):
  r"""Describes HCX appliance.

  Fields:
    externalIp: External IP address of the appliance.
    fdqn: Fully qualified domain name of the appliance.
    internalIp: Internal IP address of the appliance.
    version: Version of the appliance.
  """

  externalIp = _messages.StringField(1)
  fdqn = _messages.StringField(2)
  internalIp = _messages.StringField(3)
  version = _messages.StringField(4)


class ListClustersResponse(_messages.Message):
  r"""Response message for VmwareEngine.ListClusters

  Fields:
    clusters: A list of private cloud clusters.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations that could not be reached.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListNodeTypesResponse(_messages.Message):
  r"""Response message for VmwareEngine.ListNodeTypes

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    nodeTypes: A list of Node Types.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  nodeTypes = _messages.MessageField('NodeType', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListPrivateCloudsResponse(_messages.Message):
  r"""Response message for VmwareEngine.ListPrivateClouds

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    privateClouds: A list of private clouds.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  privateClouds = _messages.MessageField('PrivateCloud', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ManagementCluster(_messages.Message):
  r"""Management cluster configuration.

  Fields:
    clusterId: Required. The user-provided identifier of the new `Cluster`.
    nodeCount: Required. Number of nodes in this cluster.
    nodeTypeId: Required. The canonical identifier of node types (`NodeType`)
      in this cluster. For example: standard-72.
  """

  clusterId = _messages.StringField(1)
  nodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nodeTypeId = _messages.StringField(3)


class NetworkConfig(_messages.Message):
  r"""Network configuration in the consumer project with which the peering has
  to be done.

  Fields:
    managementCidr: Required. Management CIDR used by VMware management
      appliances.
    network: Required. The relative resource name of the consumer VPC network
      this private cloud is attached to. Specify the name in the following
      form: `projects/{project}/global/networks/{network_id}` where
      `{project}` can either be a project number or a project ID.
    serviceNetwork: Output only. The relative resource name of the service VPC
      network this private cloud is attached to. The name is specified in the
      following form:
      `projects/{service_project_number}/global/networks/{network_id}`.
  """

  managementCidr = _messages.StringField(1)
  network = _messages.StringField(2)
  serviceNetwork = _messages.StringField(3)


class NodeType(_messages.Message):
  r"""Describes node type.

  Fields:
    diskSizeGb: Output only. The amount of storage available, defined in GB.
    displayName: Output only. The friendly name for this node type. For
      example: ve1-standard-72
    memoryGb: Output only. The amount of physical memory available, defined in
      GB.
    name: Output only. The resource name of this node type. Resource names are
      schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-proj/locations/us-west1-a/nodeTypes/standard-72`
    nodeTypeId: Output only. The canonical identifier of the node type
      (corresponds to the `NodeType`). For example: standard-72.
    virtualCpuCount: Output only. The total number of virtual CPUs in a single
      node.
  """

  diskSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  displayName = _messages.StringField(2)
  memoryGb = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  name = _messages.StringField(4)
  nodeTypeId = _messages.StringField(5)
  virtualCpuCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class Nsx(_messages.Message):
  r"""Describes NSX appliance.

  Fields:
    externalIp: External IP address of the appliance.
    fdqn: Fully qualified domain name of the appliance.
    internalIp: Internal IP address of the appliance.
    version: Version of the appliance.
  """

  externalIp = _messages.StringField(1)
  fdqn = _messages.StringField(2)
  internalIp = _messages.StringField(3)
  version = _messages.StringField(4)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created in RFC3339
      text format.
    endTime: Output only. The time the operation finished running in RFC3339
      text format.
    requestedCancellation: Output only. True if the user has requested
      cancellation of the operation; false otherwise. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class PrivateCloud(_messages.Message):
  r"""Private cloud resource.

  Enums:
    StateValueValuesEnum: Output only. State of the resource. New values may
      be added to this enum when appropriate.

  Messages:
    LabelsValue: Labels are a way to attach lightweight metadata to resources
      for filtering and querying resource data. No more than 64 user labels
      can be associated with each resource. Label keys and values can be no
      longer than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).

  Fields:
    createTime: Output only. Creation time of this resource in RFC3339 text
      format.
    deleteTime: Output only. Time the resource was marked as deleted, in
      RFC3339 text format.
    description: User-provided description for this private cloud.
    expireTime: Output only. Planned deletion time of this resource in RFC3339
      text format.
    hcx: Output only. HCX appliance.
    labels: Labels are a way to attach lightweight metadata to resources for
      filtering and querying resource data. No more than 64 user labels can be
      associated with each resource. Label keys and values can be no longer
      than 63 characters, can only contain lowercase letters, numeric
      characters, underscores and dashes, where label keys must start with a
      letter and international characters are allowed. The empty string is a
      valid value. Labels are set on creation and updated like any other
      field. Specifically, to add a new label, you would need to provide all
      of the existing labels along with the new label. If you only provide a
      map with the new label, all of the old labels will be removed (probably
      not what is desired).
    managementCluster: Input only. The management cluster for this private
      cloud. This field is required during creation of the private cloud to
      provide details for the default cluster. The following fields can't be
      changed after private cloud creation: `ManagementCluster.clusterId`,
      `ManagementCluster.nodeTypeId`,
      `ManagementCluster.nodeCustomVirtualCpuCount`.
    name: Output only. The resource name of this private cloud. Resource names
      are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
    networkConfig: Required. Network configuration of the private cloud.
      Caution: Do not remove VPC networks used by private clouds
      (`NetworkConfig.network`). Doing so removes your ability to access the
      private cloud.
    nsx: Output only. NSX appliance.
    state: Output only. State of the resource. New values may be added to this
      enum when appropriate.
    updateTime: Output only. Last update time of this resource in RFC3339 text
      format.
    vcenter: Output only. Vcenter appliance.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the resource. New values may be added to this
    enum when appropriate.

    Values:
      STATE_UNSPECIFIED: The default value. This value should never be used.
      ACTIVE: The private cloud is ready.
      CREATING: The private cloud is being created.
      UPDATING: The private cloud is being updated.
      FAILED: The private cloud is in failed state.
      DELETED: The private cloud is deleted.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    UPDATING = 3
    FAILED = 4
    DELETED = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are a way to attach lightweight metadata to resources for
    filtering and querying resource data. No more than 64 user labels can be
    associated with each resource. Label keys and values can be no longer than
    63 characters, can only contain lowercase letters, numeric characters,
    underscores and dashes, where label keys must start with a letter and
    international characters are allowed. The empty string is a valid value.
    Labels are set on creation and updated like any other field. Specifically,
    to add a new label, you would need to provide all of the existing labels
    along with the new label. If you only provide a map with the new label,
    all of the old labels will be removed (probably not what is desired).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deleteTime = _messages.StringField(2)
  description = _messages.StringField(3)
  expireTime = _messages.StringField(4)
  hcx = _messages.MessageField('Hcx', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  managementCluster = _messages.MessageField('ManagementCluster', 7)
  name = _messages.StringField(8)
  networkConfig = _messages.MessageField('NetworkConfig', 9)
  nsx = _messages.MessageField('Nsx', 10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  updateTime = _messages.StringField(12)
  vcenter = _messages.MessageField('Vcenter', 13)


class ResetNsxCredentialsRequest(_messages.Message):
  r"""Request message for VmwareEngine.ResetNsxCredentials

  Fields:
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check if
      original operation with the same request ID was received, and if so,
      will ignore the second request. This prevents clients from accidentally
      creating duplicate commitments. The request ID must be a valid UUID with
      the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class ResetVcenterCredentialsRequest(_messages.Message):
  r"""Request message for VmwareEngine.ResetVcenterCredentials

  Fields:
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check if
      original operation with the same request ID was received, and if so,
      will ignore the second request. This prevents clients from accidentally
      creating duplicate commitments. The request ID must be a valid UUID with
      the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UndeletePrivateCloudRequest(_messages.Message):
  r"""Request message for VmwareEngine.UndeletePrivateCloud

  Fields:
    requestId: Optional. The request ID must be a valid UUID with the
      exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class Vcenter(_messages.Message):
  r"""Describes vCenter appliance.

  Fields:
    externalIp: External IP address of the appliance.
    fdqn: Fully qualified domain name of the appliance.
    internalIp: Internal IP address of the appliance.
    version: Version of the appliance.
  """

  externalIp = _messages.StringField(1)
  fdqn = _messages.StringField(2)
  internalIp = _messages.StringField(3)
  version = _messages.StringField(4)


class VmwareengineProjectsLocationsGetRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class VmwareengineProjectsLocationsListRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class VmwareengineProjectsLocationsNodeTypesGetIamPolicyRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsNodeTypesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class VmwareengineProjectsLocationsNodeTypesGetRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsNodeTypesGetRequest object.

  Fields:
    name: Required. The resource name of the node type to retrieve. Resource
      names are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-proj/locations/us-west1-a/nodeTypes/standard-72`
  """

  name = _messages.StringField(1, required=True)


class VmwareengineProjectsLocationsNodeTypesListRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsNodeTypesListRequest object.

  Fields:
    filter: A filter expression that matches resources returned in the
      response. The expression must specify the field name, a comparison
      operator, and the value that you want to use for filtering. The value
      must be a string, a number, or a boolean. The comparison operator must
      be `=`, `!=`, `>`, or `<`. For example, if you are filtering a list of
      node types, you can exclude the ones named `standard-72` by specifying
      `name != "standard-72"`. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ``` (name =
      "standard-72") (virtual_cpu_count > 2) ``` By default, each expression
      is an `AND` expression. However, you can include `AND` and `OR`
      expressions explicitly. For example: ``` (name = "standard-96") AND
      (virtual_cpu_count > 2) OR (name = "standard-72") ```
    pageSize: The maximum number of node types to return in one page. The
      service may return fewer than this value. The maximum value is coerced
      to 50.
    pageToken: A page token, received from a previous `ListNodeTypes` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListNodeTypes` must match the call that provided
      the page token.
    parent: Required. The resource name of the location to be queried for node
      types. Resource names are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class VmwareengineProjectsLocationsNodeTypesSetIamPolicyRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsNodeTypesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class VmwareengineProjectsLocationsNodeTypesTestIamPermissionsRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsNodeTypesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class VmwareengineProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class VmwareengineProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class VmwareengineProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class VmwareengineProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class VmwareengineProjectsLocationsPrivateCloudsClustersCreateRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsClustersCreateRequest
  object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: Required. The user-provided identifier of the new `Cluster`.
      This identifier must be unique among clusters within the parent and
      becomes the final token in the name URI.
    parent: Required. The resource name of the private cloud to create a new
      cluster in. Resource names are schemeless URIs that follow the
      conventions in https://cloud.google.com/apis/design/resource_names. For
      example: `projects/my-project/locations/us-west1-a/privateClouds/my-
      cloud`
    requestId: Optional. The request ID must be a valid UUID with the
      exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. When true, the request is validated only, but not
      executed.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class VmwareengineProjectsLocationsPrivateCloudsClustersDeleteRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsClustersDeleteRequest
  object.

  Fields:
    name: Required. The resource name of the cluster to delete. Resource names
      are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-
      cloud/clusters/my-cluster`
    requestId: Optional. The request ID must be a valid UUID with the
      exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class VmwareengineProjectsLocationsPrivateCloudsClustersGetIamPolicyRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsClustersGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class VmwareengineProjectsLocationsPrivateCloudsClustersGetRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsClustersGetRequest object.

  Fields:
    name: Required. The cluster resource name to retrieve. Resource names are
      schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-
      cloud/clusters/my-cluster`
  """

  name = _messages.StringField(1, required=True)


class VmwareengineProjectsLocationsPrivateCloudsClustersListRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsClustersListRequest object.

  Fields:
    filter: A filter expression that matches resources returned in the
      response. The expression must specify the field name, a comparison
      operator, and the value that you want to use for filtering. The value
      must be a string, a number, or a boolean. The comparison operator must
      be `=`, `!=`, `>`, or `<`. For example, if you are filtering a list of
      clusters, you can exclude the ones named `example-cluster` by specifying
      `name != "example-cluster"`. You can also filter nested fields. For
      example, you could specify `autoscale_settings.cooldownPeriodMinutes =
      2` to include clusters only if they have given a cooldown period in
      autoscale policy. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ``` (name =
      "example-cluster") (nodeCount = "3") ``` By default, each expression is
      an `AND` expression. However, you can include `AND` and `OR` expressions
      explicitly. For example: ``` (name = "example-cluster-1") AND
      (createTime > "2021-04-12T08:15:10.40Z") OR (name = "example-cluster-2")
      ```
    orderBy: Sorts list results by a certain order. By default, returned
      results are ordered by `name` in ascending order. You can also sort
      results in descending order based on the `name` value using
      `orderBy="name desc"`. Currently, only ordering by `name` is supported.
    pageSize: The maximum number of clusters to return in one page. The
      service may return fewer than this value. The maximum value is coerced
      to 25.
    pageToken: A page token, received from a previous `ListClusters` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListClusters` must match the call that provided
      the page token.
    parent: Required. The resource name of the private cloud to query for
      clusters. Resource names are schemeless URIs that follow the conventions
      in https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class VmwareengineProjectsLocationsPrivateCloudsClustersPatchRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    name: Output only. The resource name of this cluster. Resource names are
      schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-
      cloud/clusters/my-cluster`
    requestId: Optional. The request ID must be a valid UUID with the
      exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the `Cluster` resource by the update. The fields
      specified in the `updateMask` are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
    validateOnly: Optional. When true, the request is validated only, but not
      executed.
  """

  cluster = _messages.MessageField('Cluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class VmwareengineProjectsLocationsPrivateCloudsClustersSetIamPolicyRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsClustersSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class VmwareengineProjectsLocationsPrivateCloudsClustersTestIamPermissionsRequest(_messages.Message):
  r"""A
  VmwareengineProjectsLocationsPrivateCloudsClustersTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class VmwareengineProjectsLocationsPrivateCloudsCreateRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsCreateRequest object.

  Fields:
    parent: Required. The resource name of the location to create the new
      private cloud in. Resource names are schemeless URIs that follow the
      conventions in https://cloud.google.com/apis/design/resource_names. For
      example: `projects/my-project/locations/us-west1-a`
    privateCloud: A PrivateCloud resource to be passed as the request body.
    privateCloudId: Required. The user-provided identifier of the private
      cloud to be created. This identifier must be unique among each
      `PrivateCloud` within the parent and becomes the final token in the name
      URI.
    requestId: Optional. The request ID must be a valid UUID with the
      exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. When true, the request is validated only, but not
      executed.
  """

  parent = _messages.StringField(1, required=True)
  privateCloud = _messages.MessageField('PrivateCloud', 2)
  privateCloudId = _messages.StringField(3)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class VmwareengineProjectsLocationsPrivateCloudsDeleteRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsDeleteRequest object.

  Fields:
    force: Optional. If set to true, cascade delete is enabled and all
      children of this private cloud resource are also deleted. When this flag
      is set to false, the private cloud will not be deleted if there are any
      children other than the management cluster. The management cluster is
      always deleted.
    name: Required. The resource name of the private cloud to delete. Resource
      names are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
    requestId: Optional. The request ID must be a valid UUID with the
      exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class VmwareengineProjectsLocationsPrivateCloudsGetIamPolicyRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class VmwareengineProjectsLocationsPrivateCloudsGetRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsGetRequest object.

  Fields:
    name: Required. The resource name of the private cloud to retrieve.
      Resource names are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
  """

  name = _messages.StringField(1, required=True)


class VmwareengineProjectsLocationsPrivateCloudsListRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsListRequest object.

  Fields:
    filter: A filter expression that matches resources returned in the
      response. The expression must specify the field name, a comparison
      operator, and the value that you want to use for filtering. The value
      must be a string, a number, or a boolean. The comparison operator must
      be `=`, `!=`, `>`, or `<`. For example, if you are filtering a list of
      private clouds, you can exclude the ones named `example-pc` by
      specifying `name != "example-pc"`. You can also filter nested fields.
      For example, you could specify `networkConfig.managementCidr =
      "192.168.0.0/24"` to include private clouds only if they have a matching
      address in their network configuration. To filter on multiple
      expressions, provide each separate expression within parentheses. For
      example: ``` (name = "example-pc") (createTime >
      "2021-04-12T08:15:10.40Z") ``` By default, each expression is an `AND`
      expression. However, you can include `AND` and `OR` expressions
      explicitly. For example: ``` (name = "private-cloud-1") AND (createTime
      > "2021-04-12T08:15:10.40Z") OR (name = "private-cloud-2") ```
    orderBy: Sorts list results by a certain order. By default, returned
      results are ordered by `name` in ascending order. You can also sort
      results in descending order based on the `name` value using
      `orderBy="name desc"`. Currently, only ordering by `name` is supported.
    pageSize: The maximum number of private clouds to return in one page. The
      service may return fewer than this value. The maximum value is coerced
      to 25.
    pageToken: A page token, received from a previous `ListPrivateClouds`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListPrivateClouds` must match the call
      that provided the page token.
    parent: Required. The resource name of the private cloud to be queried for
      clusters. Resource names are schemeless URIs that follow the conventions
      in https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class VmwareengineProjectsLocationsPrivateCloudsPatchRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsPatchRequest object.

  Fields:
    name: Output only. The resource name of this private cloud. Resource names
      are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
    privateCloud: A PrivateCloud resource to be passed as the request body.
    requestId: Optional. The request ID must be a valid UUID with the
      exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the `PrivateCloud` resource by the update. The fields
      specified in `updateMask` are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  privateCloud = _messages.MessageField('PrivateCloud', 2)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class VmwareengineProjectsLocationsPrivateCloudsResetNsxCredentialsRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsResetNsxCredentialsRequest
  object.

  Fields:
    privateCloud: Required. The resource name of the private cloud to reset
      credentials for. Resource names are schemeless URIs that follow the
      conventions in https://cloud.google.com/apis/design/resource_names. For
      example: `projects/my-project/locations/us-west1-a/privateClouds/my-
      cloud`
    resetNsxCredentialsRequest: A ResetNsxCredentialsRequest resource to be
      passed as the request body.
  """

  privateCloud = _messages.StringField(1, required=True)
  resetNsxCredentialsRequest = _messages.MessageField('ResetNsxCredentialsRequest', 2)


class VmwareengineProjectsLocationsPrivateCloudsResetVcenterCredentialsRequest(_messages.Message):
  r"""A
  VmwareengineProjectsLocationsPrivateCloudsResetVcenterCredentialsRequest
  object.

  Fields:
    privateCloud: Required. The resource name of the private cloud to reset
      credentials for. Resource names are schemeless URIs that follow the
      conventions in https://cloud.google.com/apis/design/resource_names. For
      example: `projects/my-project/locations/us-west1-a/privateClouds/my-
      cloud`
    resetVcenterCredentialsRequest: A ResetVcenterCredentialsRequest resource
      to be passed as the request body.
  """

  privateCloud = _messages.StringField(1, required=True)
  resetVcenterCredentialsRequest = _messages.MessageField('ResetVcenterCredentialsRequest', 2)


class VmwareengineProjectsLocationsPrivateCloudsSetIamPolicyRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class VmwareengineProjectsLocationsPrivateCloudsShowNsxCredentialsRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsShowNsxCredentialsRequest
  object.

  Fields:
    privateCloud: Required. The resource name of the private cloud to be
      queried for credentials. Resource names are schemeless URIs that follow
      the conventions in https://cloud.google.com/apis/design/resource_names.
      For example: `projects/my-project/locations/us-west1-a/privateClouds/my-
      cloud`
  """

  privateCloud = _messages.StringField(1, required=True)


class VmwareengineProjectsLocationsPrivateCloudsShowVcenterCredentialsRequest(_messages.Message):
  r"""A
  VmwareengineProjectsLocationsPrivateCloudsShowVcenterCredentialsRequest
  object.

  Fields:
    privateCloud: Required. The resource name of the private cloud to be
      queried for credentials. Resource names are schemeless URIs that follow
      the conventions in https://cloud.google.com/apis/design/resource_names.
      For example: `projects/my-project/locations/us-west1-a/privateClouds/my-
      cloud`
  """

  privateCloud = _messages.StringField(1, required=True)


class VmwareengineProjectsLocationsPrivateCloudsTestIamPermissionsRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class VmwareengineProjectsLocationsPrivateCloudsUndeleteRequest(_messages.Message):
  r"""A VmwareengineProjectsLocationsPrivateCloudsUndeleteRequest object.

  Fields:
    name: Required. The resource name of the private cloud marked for
      deletion. Resource names are schemeless URIs that follow the conventions
      in https://cloud.google.com/apis/design/resource_names. For example:
      `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
    undeletePrivateCloudRequest: A UndeletePrivateCloudRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  undeletePrivateCloudRequest = _messages.MessageField('UndeletePrivateCloudRequest', 2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
