"""Generated message classes for securitycenter version v1.

Security Command Center API provides access to temporal views of assets and
findings within an organization.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'securitycenter'


class Asset(_messages.Message):
  r"""Security Command Center representation of a Google Cloud resource. The
  Asset is a Security Command Center resource that captures information about
  a single Google Cloud resource. All modifications to an Asset are only
  within the context of Security Command Center and don't affect the
  referenced Google Cloud resource.

  Messages:
    ResourcePropertiesValue: Resource managed properties. These properties are
      managed and defined by the Google Cloud resource and cannot be modified
      by the user.

  Fields:
    canonicalName: The canonical name of the resource. It's either
      "organizations/{organization_id}/assets/{asset_id}",
      "folders/{folder_id}/assets/{asset_id}" or
      "projects/{project_number}/assets/{asset_id}", depending on the closest
      CRM ancestor of the resource.
    createTime: The time at which the asset was created in Security Command
      Center.
    iamPolicy: Cloud IAM Policy information associated with the Google Cloud
      resource described by the Security Command Center asset. This
      information is managed and defined by the Google Cloud resource and
      cannot be modified by the user.
    name: The relative resource name of this asset. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/assets/{asset_id}".
    resourceProperties: Resource managed properties. These properties are
      managed and defined by the Google Cloud resource and cannot be modified
      by the user.
    securityCenterProperties: Security Command Center managed properties.
      These properties are managed by Security Command Center and cannot be
      modified by the user.
    securityMarks: User specified security marks. These marks are entirely
      managed by the user and come from the SecurityMarks resource that
      belongs to the asset.
    updateTime: The time at which the asset was last updated or added in Cloud
      SCC.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourcePropertiesValue(_messages.Message):
    r"""Resource managed properties. These properties are managed and defined
    by the Google Cloud resource and cannot be modified by the user.

    Messages:
      AdditionalProperty: An additional property for a ResourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ResourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canonicalName = _messages.StringField(1)
  createTime = _messages.StringField(2)
  iamPolicy = _messages.MessageField('IamPolicy', 3)
  name = _messages.StringField(4)
  resourceProperties = _messages.MessageField('ResourcePropertiesValue', 5)
  securityCenterProperties = _messages.MessageField('SecurityCenterProperties', 6)
  securityMarks = _messages.MessageField('SecurityMarks', 7)
  updateTime = _messages.StringField(8)


class AssetDiscoveryConfig(_messages.Message):
  r"""The configuration used for Asset Discovery runs.

  Enums:
    InclusionModeValueValuesEnum: The mode to use for filtering asset
      discovery.

  Fields:
    folderIds: The folder ids to use for filtering asset discovery. It
      consists of only digits, e.g., 756619654966.
    inclusionMode: The mode to use for filtering asset discovery.
    projectIds: The project ids to use for filtering asset discovery.
  """

  class InclusionModeValueValuesEnum(_messages.Enum):
    r"""The mode to use for filtering asset discovery.

    Values:
      INCLUSION_MODE_UNSPECIFIED: Unspecified. Setting the mode with this
        value will disable inclusion/exclusion filtering for Asset Discovery.
      INCLUDE_ONLY: Asset Discovery will capture only the resources within the
        projects specified. All other resources will be ignored.
      EXCLUDE: Asset Discovery will ignore all resources under the projects
        specified. All other resources will be retrieved.
    """
    INCLUSION_MODE_UNSPECIFIED = 0
    INCLUDE_ONLY = 1
    EXCLUDE = 2

  folderIds = _messages.StringField(1, repeated=True)
  inclusionMode = _messages.EnumField('InclusionModeValueValuesEnum', 2)
  projectIds = _messages.StringField(3, repeated=True)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Finding(_messages.Message):
  r"""Security Command Center finding. A finding is a record of assessment
  data like security, risk, health, or privacy, that is ingested into Security
  Command Center for presentation, notification, analysis, policy testing, and
  enforcement. For example, a cross-site scripting (XSS) vulnerability in an
  App Engine application is a finding.

  Enums:
    FindingClassValueValuesEnum: The class of the finding.
    MuteValueValuesEnum: Indicates the mute state of a finding (either
      unspecified, muted, unmuted).
    SeverityValueValuesEnum: The severity of the finding. This field is
      managed by the source that writes the finding.
    StateValueValuesEnum: The state of the finding.

  Messages:
    SourcePropertiesValue: Source specific properties. These properties are
      managed by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.

  Fields:
    canonicalName: The canonical name of the finding. It's either "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}",
      "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
      "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
      depending on the closest CRM ancestor of the resource associated with
      the finding.
    category: The additional taxonomy group within findings from a given
      source. This field is immutable after creation time. Example:
      "XSS_FLASH_INJECTION"
    createTime: The time at which the finding was created in Security Command
      Center.
    eventTime: The time at which the event took place, or when an update to
      the finding occurred. For example, if the finding represents an open
      firewall it would capture the time the detector believes the firewall
      became open. The accuracy is determined by the detector. If the finding
      were to be resolved afterward, this time would reflect when the finding
      was resolved. Must not be set to a value greater than the current
      timestamp.
    externalUri: The URI that, if available, points to a web page outside of
      Security Command Center where additional information about the finding
      can be found. This field is guaranteed to be either empty or a well
      formed URL.
    findingClass: The class of the finding.
    indicator: Represents what's commonly known as an Indicator of compromise
      (IoC) in computer forensics. This is an artifact observed on a network
      or in an operating system that, with high confidence, indicates a
      computer intrusion. Reference:
      https://en.wikipedia.org/wiki/Indicator_of_compromise
    mute: Indicates the mute state of a finding (either unspecified, muted,
      unmuted).
    muteAnnotation: Records additional information about the mute operation
      e.g. mute config that muted the finding etc.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      s/{finding_id}"
    parent: The relative resource name of the source the finding belongs to.
      See: https://cloud.google.com/apis/design/resource_names#relative_resour
      ce_name This field is immutable after creation time. For example:
      "organizations/{organization_id}/sources/{source_id}"
    resourceName: For findings on Google Cloud resources, the full resource
      name of the Google Cloud resource this finding is for. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      When the finding is for a non-Google Cloud resource, the resourceName
      can be a customer or partner defined string. This field is immutable
      after creation time.
    securityMarks: Output only. User specified security marks. These marks are
      entirely managed by the user and come from the SecurityMarks resource
      that belongs to the finding.
    severity: The severity of the finding. This field is managed by the source
      that writes the finding.
    sourceProperties: Source specific properties. These properties are managed
      by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.
    state: The state of the finding.
  """

  class FindingClassValueValuesEnum(_messages.Enum):
    r"""The class of the finding.

    Values:
      FINDING_CLASS_UNSPECIFIED: Unspecified finding class.
      THREAT: Describes unwanted or malicious activity.
      VULNERABILITY: Describes a potential weakness in software that increases
        risk to Confidentiality & Integrity & Availability.
      MISCONFIGURATION: Describes a potential weakness in cloud resource/asset
        configuration that increases risk.
      OBSERVATION: Describes a security observation that is for informational
        purposes.
    """
    FINDING_CLASS_UNSPECIFIED = 0
    THREAT = 1
    VULNERABILITY = 2
    MISCONFIGURATION = 3
    OBSERVATION = 4

  class MuteValueValuesEnum(_messages.Enum):
    r"""Indicates the mute state of a finding (either unspecified, muted,
    unmuted).

    Values:
      MUTE_UNSPECIFIED: Unspecified i.e. the finding has never been
        muted/unmuted.
      MUTED: Finding has been muted.
      UNMUTED: Finding has been unmuted.
    """
    MUTE_UNSPECIFIED = 0
    MUTED = 1
    UNMUTED = 2

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the finding. This field is managed by the source that
    writes the finding.

    Values:
      SEVERITY_UNSPECIFIED: This value is used for findings when a source
        doesn't write a severity value.
      CRITICAL: Vulnerability: A critical vulnerability is easily discoverable
        by an external actor, exploitable, and results in the direct ability
        to execute arbitrary code, exfiltrate data, and otherwise gain
        additional access and privileges to cloud resources and workloads.
        Examples include publicly accessible unprotected user data, public SSH
        access with weak or no passwords, etc. Threat: Indicates a threat that
        is able to access, modify, or delete data or execute unauthorized code
        within existing resources.
      HIGH: Vulnerability: A high risk vulnerability can be easily discovered
        and exploited in combination with other vulnerabilities in order to
        gain direct access and the ability to execute arbitrary code,
        exfiltrate data, and otherwise gain additional access and privileges
        to cloud resources and workloads. An example is a database with weak
        or no passwords that is only accessible internally. This database
        could easily be compromised by an actor that had access to the
        internal network. Threat: Indicates a threat that is able to create
        new computational resources in an environment but not able to access
        data or execute code in existing resources.
      MEDIUM: Vulnerability: A medium risk vulnerability could be used by an
        actor to gain access to resources or privileges that enable them to
        eventually (through multiple steps or a complex exploit) gain access
        and the ability to execute arbitrary code or exfiltrate data. An
        example is a service account with access to more projects than it
        should have. If an actor gains access to the service account, they
        could potentially use that access to manipulate a project the service
        account was not intended to. Threat: Indicates a threat that is able
        to cause operational impact but may not access data or execute
        unauthorized code.
      LOW: Vulnerability: A low risk vulnerability hampers a security
        organization's ability to detect vulnerabilities or active threats in
        their deployment, or prevents the root cause investigation of security
        issues. An example is monitoring and logs being disabled for resource
        configurations and access. Threat: Indicates a threat that has
        obtained minimal access to an environment but is not able to access
        data, execute code, or create resources.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourcePropertiesValue(_messages.Message):
    r"""Source specific properties. These properties are managed by the source
    that writes the finding. The key names in the source_properties map must
    be between 1 and 255 characters, and must start with a letter and contain
    alphanumeric characters or underscores only.

    Messages:
      AdditionalProperty: An additional property for a SourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canonicalName = _messages.StringField(1)
  category = _messages.StringField(2)
  createTime = _messages.StringField(3)
  eventTime = _messages.StringField(4)
  externalUri = _messages.StringField(5)
  findingClass = _messages.EnumField('FindingClassValueValuesEnum', 6)
  indicator = _messages.MessageField('Indicator', 7)
  mute = _messages.EnumField('MuteValueValuesEnum', 8)
  muteAnnotation = _messages.StringField(9)
  name = _messages.StringField(10)
  parent = _messages.StringField(11)
  resourceName = _messages.StringField(12)
  securityMarks = _messages.MessageField('SecurityMarks', 13)
  severity = _messages.EnumField('SeverityValueValuesEnum', 14)
  sourceProperties = _messages.MessageField('SourcePropertiesValue', 15)
  state = _messages.EnumField('StateValueValuesEnum', 16)


class Folder(_messages.Message):
  r"""Message that contains the resource name and display name of a folder
  resource.

  Fields:
    resourceFolder: Full resource name of this folder. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceFolderDisplayName: The user defined display name for this folder.
  """

  resourceFolder = _messages.StringField(1)
  resourceFolderDisplayName = _messages.StringField(2)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudSecuritycenterV1MuteConfig(_messages.Message):
  r"""A mute config is a Cloud SCC resource that contains the configuration to
  mute create/update events of findings.

  Fields:
    createTime: Output only. The time at which the mute config was created.
      This field is set by the server and will be ignored if provided on
      config creation.
    description: A description of the mute config.
    displayName: Required. The human readable name to be displayed for the
      mute config.
    filter: Required. An expression that defines the filter to apply across
      create/update events of findings. While creating a filter string, be
      mindful of the scope in which the mute configuration is being created.
      E.g., If a filter contains project = X but is created under the project
      = Y scope, it might not match any findings. The following field and
      operator combinations are supported: * severity: `=`, `:` * category:
      `=`, `:` * resource_name: `=`, `:` * resource.project_name: `=`, `:` *
      resource.project_display_name: `=`, `:` *
      resource.folders.resource_folder: `=`, `:` * resource.parent_name: `=`,
      `:` * resource.parent_display_name: `=`, `:` * resource.type: `=`, `:` *
      finding_class: `=`, `:` * indicator.ip_addresses: `=`, `:` *
      indicator.domains: `=`, `:`
    name: The config id is a server generated unique identifier. This field
      will be ignored if provided on config creation. Format
      "organizations/{organization}/muteConfigs/{mute_config}"
      "folders/{folder}/muteConfigs/{mute_config}"
      "projects/{project}/muteConfigs/{mute_config}"
    updateTime: Output only. The most recent time at which the mute config was
      updated. This field is by the server and will be ignored if provided on
      config creation or update.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  filter = _messages.StringField(4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleCloudSecuritycenterV1NotificationMessage(_messages.Message):
  r"""Cloud SCC's Notification

  Fields:
    finding: If it's a Finding based notification config, this field will be
      populated.
    notificationConfigName: Name of the notification config that generated
      current notification.
    resource: The Cloud resource tied to this notification's Finding.
  """

  finding = _messages.MessageField('Finding', 1)
  notificationConfigName = _messages.StringField(2)
  resource = _messages.MessageField('GoogleCloudSecuritycenterV1Resource', 3)


class GoogleCloudSecuritycenterV1Resource(_messages.Message):
  r"""Information related to the Google Cloud resource.

  Fields:
    folders: Output only. Contains a Folder message for each folder in the
      assets ancestry. The first folder is the deepest nested folder, and the
      last folder is the folder directly under the Organization.
    name: The full resource name of the resource. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    parent: The full resource name of resource's parent.
    parentDisplayName: The human readable name of resource's parent.
    project: The full resource name of project that the resource belongs to.
    projectDisplayName: The human readable name of project that the resource
      belongs to.
  """

  folders = _messages.MessageField('Folder', 1, repeated=True)
  name = _messages.StringField(2)
  parent = _messages.StringField(3)
  parentDisplayName = _messages.StringField(4)
  project = _messages.StringField(5)
  projectDisplayName = _messages.StringField(6)


class GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse(_messages.Message):
  r"""Response of asset discovery run

  Enums:
    StateValueValuesEnum: The state of an asset discovery run.

  Fields:
    duration: The duration between asset discovery run start and end
    state: The state of an asset discovery run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of an asset discovery run.

    Values:
      STATE_UNSPECIFIED: Asset discovery run state was unspecified.
      COMPLETED: Asset discovery run completed successfully.
      SUPERSEDED: Asset discovery run was cancelled with tasks still pending,
        as another run for the same organization was started with a higher
        priority.
      TERMINATED: Asset discovery run was killed and terminated.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUPERSEDED = 2
    TERMINATED = 3

  duration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse(_messages.Message):
  r"""Response of asset discovery run

  Enums:
    StateValueValuesEnum: The state of an asset discovery run.

  Fields:
    duration: The duration between asset discovery run start and end
    state: The state of an asset discovery run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of an asset discovery run.

    Values:
      STATE_UNSPECIFIED: Asset discovery run state was unspecified.
      COMPLETED: Asset discovery run completed successfully.
      SUPERSEDED: Asset discovery run was cancelled with tasks still pending,
        as another run for the same organization was started with a higher
        priority.
      TERMINATED: Asset discovery run was killed and terminated.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUPERSEDED = 2
    TERMINATED = 3

  duration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudSecuritycenterV1p1beta1Finding(_messages.Message):
  r"""Security Command Center finding. A finding is a record of assessment
  data (security, risk, health or privacy) ingested into Security Command
  Center for presentation, notification, analysis, policy testing, and
  enforcement. For example, an XSS vulnerability in an App Engine application
  is a finding.

  Enums:
    SeverityValueValuesEnum: The severity of the finding. This field is
      managed by the source that writes the finding.
    StateValueValuesEnum: The state of the finding.

  Messages:
    SourcePropertiesValue: Source specific properties. These properties are
      managed by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.

  Fields:
    canonicalName: The canonical name of the finding. It's either "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}",
      "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
      "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
      depending on the closest CRM ancestor of the resource associated with
      the finding.
    category: The additional taxonomy group within findings from a given
      source. This field is immutable after creation time. Example:
      "XSS_FLASH_INJECTION"
    createTime: The time at which the finding was created in Security Command
      Center.
    eventTime: The time at which the event took place, or when an update to
      the finding occurred. For example, if the finding represents an open
      firewall it would capture the time the detector believes the firewall
      became open. The accuracy is determined by the detector. If the finding
      were to be resolved afterward, this time would reflect when the finding
      was resolved. Must not be set to a value greater than the current
      timestamp.
    externalUri: The URI that, if available, points to a web page outside of
      Security Command Center where additional information about the finding
      can be found. This field is guaranteed to be either empty or a well
      formed URL.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      s/{finding_id}"
    parent: The relative resource name of the source the finding belongs to.
      See: https://cloud.google.com/apis/design/resource_names#relative_resour
      ce_name This field is immutable after creation time. For example:
      "organizations/{organization_id}/sources/{source_id}"
    resourceName: For findings on Google Cloud resources, the full resource
      name of the Google Cloud resource this finding is for. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      When the finding is for a non-Google Cloud resource, the resourceName
      can be a customer or partner defined string. This field is immutable
      after creation time.
    securityMarks: Output only. User specified security marks. These marks are
      entirely managed by the user and come from the SecurityMarks resource
      that belongs to the finding.
    severity: The severity of the finding. This field is managed by the source
      that writes the finding.
    sourceProperties: Source specific properties. These properties are managed
      by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.
    state: The state of the finding.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the finding. This field is managed by the source that
    writes the finding.

    Values:
      SEVERITY_UNSPECIFIED: No severity specified. The default value.
      CRITICAL: Critical severity.
      HIGH: High severity.
      MEDIUM: Medium severity.
      LOW: Low severity.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourcePropertiesValue(_messages.Message):
    r"""Source specific properties. These properties are managed by the source
    that writes the finding. The key names in the source_properties map must
    be between 1 and 255 characters, and must start with a letter and contain
    alphanumeric characters or underscores only.

    Messages:
      AdditionalProperty: An additional property for a SourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canonicalName = _messages.StringField(1)
  category = _messages.StringField(2)
  createTime = _messages.StringField(3)
  eventTime = _messages.StringField(4)
  externalUri = _messages.StringField(5)
  name = _messages.StringField(6)
  parent = _messages.StringField(7)
  resourceName = _messages.StringField(8)
  securityMarks = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1SecurityMarks', 9)
  severity = _messages.EnumField('SeverityValueValuesEnum', 10)
  sourceProperties = _messages.MessageField('SourcePropertiesValue', 11)
  state = _messages.EnumField('StateValueValuesEnum', 12)


class GoogleCloudSecuritycenterV1p1beta1Folder(_messages.Message):
  r"""Message that contains the resource name and display name of a folder
  resource.

  Fields:
    resourceFolder: Full resource name of this folder. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceFolderDisplayName: The user defined display name for this folder.
  """

  resourceFolder = _messages.StringField(1)
  resourceFolderDisplayName = _messages.StringField(2)


class GoogleCloudSecuritycenterV1p1beta1NotificationMessage(_messages.Message):
  r"""Security Command Center's Notification

  Fields:
    finding: If it's a Finding based notification config, this field will be
      populated.
    notificationConfigName: Name of the notification config that generated
      current notification.
    resource: The Cloud resource tied to the notification.
  """

  finding = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1Finding', 1)
  notificationConfigName = _messages.StringField(2)
  resource = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1Resource', 3)


class GoogleCloudSecuritycenterV1p1beta1Resource(_messages.Message):
  r"""Information related to the Google Cloud resource.

  Fields:
    folders: Output only. Contains a Folder message for each folder in the
      assets ancestry. The first folder is the deepest nested folder, and the
      last folder is the folder directly under the Organization.
    name: The full resource name of the resource. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    parent: The full resource name of resource's parent.
    parentDisplayName: The human readable name of resource's parent.
    project: The full resource name of project that the resource belongs to.
    projectDisplayName: The human readable name of project that the resource
      belongs to.
  """

  folders = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1Folder', 1, repeated=True)
  name = _messages.StringField(2)
  parent = _messages.StringField(3)
  parentDisplayName = _messages.StringField(4)
  project = _messages.StringField(5)
  projectDisplayName = _messages.StringField(6)


class GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse(_messages.Message):
  r"""Response of asset discovery run

  Enums:
    StateValueValuesEnum: The state of an asset discovery run.

  Fields:
    duration: The duration between asset discovery run start and end
    state: The state of an asset discovery run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of an asset discovery run.

    Values:
      STATE_UNSPECIFIED: Asset discovery run state was unspecified.
      COMPLETED: Asset discovery run completed successfully.
      SUPERSEDED: Asset discovery run was cancelled with tasks still pending,
        as another run for the same organization was started with a higher
        priority.
      TERMINATED: Asset discovery run was killed and terminated.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUPERSEDED = 2
    TERMINATED = 3

  duration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudSecuritycenterV1p1beta1SecurityMarks(_messages.Message):
  r"""User specified security marks that are attached to the parent Security
  Command Center resource. Security marks are scoped within a Security Command
  Center organization -- they can be modified and viewed by all users who have
  proper permissions on the organization.

  Messages:
    MarksValue: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)

  Fields:
    canonicalName: The canonical name of the marks. Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks"
      "folders/{folder_id}/assets/{asset_id}/securityMarks"
      "projects/{project_number}/assets/{asset_id}/securityMarks" "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}/securityM
      arks" "folders/{folder_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks" "projects/{project_number}/sources/{source_id}/findings/{fin
      ding_id}/securityMarks"
    marks: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MarksValue(_messages.Message):
    r"""Mutable user specified security marks belonging to the parent
    resource. Constraints are as follows: * Keys and values are treated as
    case insensitive * Keys must be between 1 - 256 characters (inclusive) *
    Keys must be letters, numbers, underscores, or dashes * Values have
    leading and trailing whitespace trimmed, remaining characters must be
    between 1 - 4096 characters (inclusive)

    Messages:
      AdditionalProperty: An additional property for a MarksValue object.

    Fields:
      additionalProperties: Additional properties of type MarksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MarksValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canonicalName = _messages.StringField(1)
  marks = _messages.MessageField('MarksValue', 2)
  name = _messages.StringField(3)


class GroupAssetsRequest(_messages.Message):
  r"""Request message for grouping by assets.

  Fields:
    compareDuration: When compare_duration is set, the GroupResult's
      "state_change" property is updated to indicate whether the asset was
      added, removed, or remained present during the compare_duration period
      of time that precedes the read_time. This is the time between (read_time
      - compare_duration) and read_time. The state change value is derived
      based on the presence of the asset at the two points in time.
      Intermediate state changes between the two times don't affect the
      result. For example, the results aren't affected if the asset is removed
      and re-created again. Possible "state_change" values when
      compare_duration is specified: * "ADDED": indicates that the asset was
      not present at the start of compare_duration, but present at
      reference_time. * "REMOVED": indicates that the asset was present at the
      start of compare_duration, but not present at reference_time. *
      "ACTIVE": indicates that the asset was present at both the start and the
      end of the time period defined by compare_duration and reference_time.
      If compare_duration is not specified, then the only possible
      state_change is "UNUSED", which will be the state_change set for all
      assets present at read_time. If this field is set then `state_change`
      must be a specified field in `group_by`.
    filter: Expression that defines the filter to apply across assets. The
      expression is a list of zero or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are supported, and `OR` has higher
      precedence than `AND`. Restrictions have the form ` ` and may have a `-`
      character in front of them to indicate negation. The fields map to those
      defined in the Asset resource. Examples include: * name *
      security_center_properties.resource_name *
      resource_properties.a_property * security_marks.marks.marka The
      supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are: * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes. The following field and operator combinations are supported: *
      name: `=` * update_time: `=`, `>`, `<`, `>=`, `<=` Usage: This should be
      milliseconds since epoch or an RFC3339 string. Examples: `update_time =
      "2019-06-10T16:07:18-07:00"` `update_time = 1560208038000` *
      create_time: `=`, `>`, `<`, `>=`, `<=` Usage: This should be
      milliseconds since epoch or an RFC3339 string. Examples: `create_time =
      "2019-06-10T16:07:18-07:00"` `create_time = 1560208038000` *
      iam_policy.policy_blob: `=`, `:` * resource_properties: `=`, `:`, `>`,
      `<`, `>=`, `<=` * security_marks.marks: `=`, `:` *
      security_center_properties.resource_name: `=`, `:` *
      security_center_properties.resource_display_name: `=`, `:` *
      security_center_properties.resource_type: `=`, `:` *
      security_center_properties.resource_parent: `=`, `:` *
      security_center_properties.resource_parent_display_name: `=`, `:` *
      security_center_properties.resource_project: `=`, `:` *
      security_center_properties.resource_project_display_name: `=`, `:` *
      security_center_properties.resource_owners: `=`, `:` For example,
      `resource_properties.size = 100` is a valid filter string. Use a partial
      match on the empty string to filter based on a property existing:
      `resource_properties.my_property : ""` Use a negated partial match on
      the empty string to filter based on a property not existing:
      `-resource_properties.my_property : ""`
    groupBy: Required. Expression that defines what assets fields to use for
      grouping. The string value should follow SQL syntax: comma separated
      list of fields. For example: "security_center_properties.resource_projec
      t,security_center_properties.project". The following fields are
      supported when compare_duration is not set: *
      security_center_properties.resource_project *
      security_center_properties.resource_project_display_name *
      security_center_properties.resource_type *
      security_center_properties.resource_parent *
      security_center_properties.resource_parent_display_name The following
      fields are supported when compare_duration is set: *
      security_center_properties.resource_type *
      security_center_properties.resource_project_display_name *
      security_center_properties.resource_parent_display_name
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `GroupAssetsResponse`; indicates
      that this is a continuation of a prior `GroupAssets` call, and that the
      system should return the next page of data.
    readTime: Time used as a reference point when filtering assets. The filter
      is limited to assets existing at the supplied time and their values are
      those at that specific time. Absence of this field will default to the
      API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  filter = _messages.StringField(2)
  groupBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  readTime = _messages.StringField(6)


class GroupAssetsResponse(_messages.Message):
  r"""Response message for grouping by assets.

  Fields:
    groupByResults: Group results. There exists an element for each existing
      unique combination of property/values. The element contains a count for
      the number of times those specific property/values appear.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    readTime: Time used for executing the groupBy request.
    totalSize: The total number of results matching the query.
  """

  groupByResults = _messages.MessageField('GroupResult', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  readTime = _messages.StringField(3)
  totalSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GroupFindingsRequest(_messages.Message):
  r"""Request message for grouping by findings.

  Fields:
    compareDuration: When compare_duration is set, the GroupResult's
      "state_change" attribute is updated to indicate whether the finding had
      its state changed, the finding's state remained unchanged, or if the
      finding was added during the compare_duration period of time that
      precedes the read_time. This is the time between (read_time -
      compare_duration) and read_time. The state_change value is derived based
      on the presence and state of the finding at the two points in time.
      Intermediate state changes between the two times don't affect the
      result. For example, the results aren't affected if the finding is made
      inactive and then active again. Possible "state_change" values when
      compare_duration is specified: * "CHANGED": indicates that the finding
      was present and matched the given filter at the start of
      compare_duration, but changed its state at read_time. * "UNCHANGED":
      indicates that the finding was present and matched the given filter at
      the start of compare_duration and did not change state at read_time. *
      "ADDED": indicates that the finding did not match the given filter or
      was not present at the start of compare_duration, but was present at
      read_time. * "REMOVED": indicates that the finding was present and
      matched the filter at the start of compare_duration, but did not match
      the filter at read_time. If compare_duration is not specified, then the
      only possible state_change is "UNUSED", which will be the state_change
      set for all findings present at read_time. If this field is set then
      `state_change` must be a specified field in `group_by`.
    filter: Expression that defines the filter to apply across findings. The
      expression is a list of one or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are supported, and `OR` has higher
      precedence than `AND`. Restrictions have the form ` ` and may have a `-`
      character in front of them to indicate negation. Examples include: *
      name * source_properties.a_property * security_marks.marks.marka The
      supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are: * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes. The following field and operator combinations are supported: *
      name: `=` * parent: `=`, `:` * resource_name: `=`, `:` * state: `=`, `:`
      * category: `=`, `:` * external_uri: `=`, `:` * event_time: `=`, `>`,
      `<`, `>=`, `<=` Usage: This should be milliseconds since epoch or an
      RFC3339 string. Examples: `event_time = "2019-06-10T16:07:18-07:00"`
      `event_time = 1560208038000` * severity: `=`, `:` * workflow_state: `=`,
      `:` * security_marks.marks: `=`, `:` * source_properties: `=`, `:`, `>`,
      `<`, `>=`, `<=` For example, `source_properties.size = 100` is a valid
      filter string. Use a partial match on the empty string to filter based
      on a property existing: `source_properties.my_property : ""` Use a
      negated partial match on the empty string to filter based on a property
      not existing: `-source_properties.my_property : ""` * resource: *
      resource.name: `=`, `:` * resource.parent_name: `=`, `:` *
      resource.parent_display_name: `=`, `:` * resource.project_name: `=`, `:`
      * resource.project_display_name: `=`, `:` * resource.type: `=`, `:`
    groupBy: Required. Expression that defines what assets fields to use for
      grouping (including `state_change`). The string value should follow SQL
      syntax: comma separated list of fields. For example:
      "parent,resource_name". The following fields are supported: *
      resource_name * category * state * parent * severity The following
      fields are supported when compare_duration is set: * state_change
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `GroupFindingsResponse`;
      indicates that this is a continuation of a prior `GroupFindings` call,
      and that the system should return the next page of data.
    readTime: Time used as a reference point when filtering findings. The
      filter is limited to findings existing at the supplied time and their
      values are those at that specific time. Absence of this field will
      default to the API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  filter = _messages.StringField(2)
  groupBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  readTime = _messages.StringField(6)


class GroupFindingsResponse(_messages.Message):
  r"""Response message for group by findings.

  Fields:
    groupByResults: Group results. There exists an element for each existing
      unique combination of property/values. The element contains a count for
      the number of times those specific property/values appear.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    readTime: Time used for executing the groupBy request.
    totalSize: The total number of results matching the query.
  """

  groupByResults = _messages.MessageField('GroupResult', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  readTime = _messages.StringField(3)
  totalSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GroupResult(_messages.Message):
  r"""Result containing the properties and count of a groupBy request.

  Messages:
    PropertiesValue: Properties matching the groupBy fields in the request.

  Fields:
    count: Total count of resources for the given properties.
    properties: Properties matching the groupBy fields in the request.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Properties matching the groupBy fields in the request.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  count = _messages.IntegerField(1)
  properties = _messages.MessageField('PropertiesValue', 2)


class IamPolicy(_messages.Message):
  r"""Cloud IAM Policy information associated with the Google Cloud resource
  described by the Security Command Center asset. This information is managed
  and defined by the Google Cloud resource and cannot be modified by the user.

  Fields:
    policyBlob: The JSON representation of the Policy associated with the
      asset. See https://cloud.google.com/iam/reference/rest/v1/Policy for
      format details.
  """

  policyBlob = _messages.StringField(1)


class Indicator(_messages.Message):
  r"""Represents what's commonly known as an Indicator of compromise (IoC) in
  computer forensics. This is an artifact observed on a network or in an
  operating system that, with high confidence, indicates a computer intrusion.
  Reference: https://en.wikipedia.org/wiki/Indicator_of_compromise

  Fields:
    domains: List of domains associated to the Finding.
    ipAddresses: List of ip addresses associated to the Finding.
  """

  domains = _messages.StringField(1, repeated=True)
  ipAddresses = _messages.StringField(2, repeated=True)


class ListAssetsResponse(_messages.Message):
  r"""Response message for listing assets.

  Fields:
    listAssetsResults: Assets matching the list request.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    readTime: Time used for executing the list request.
    totalSize: The total number of assets matching the query.
  """

  listAssetsResults = _messages.MessageField('ListAssetsResult', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  readTime = _messages.StringField(3)
  totalSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ListAssetsResult(_messages.Message):
  r"""Result containing the Asset and its State.

  Enums:
    StateChangeValueValuesEnum: State change of the asset between the points
      in time.

  Fields:
    asset: Asset matching the search request.
    stateChange: State change of the asset between the points in time.
  """

  class StateChangeValueValuesEnum(_messages.Enum):
    r"""State change of the asset between the points in time.

    Values:
      UNUSED: State change is unused, this is the canonical default for this
        enum.
      ADDED: Asset was added between the points in time.
      REMOVED: Asset was removed between the points in time.
      ACTIVE: Asset was present at both point(s) in time.
    """
    UNUSED = 0
    ADDED = 1
    REMOVED = 2
    ACTIVE = 3

  asset = _messages.MessageField('Asset', 1)
  stateChange = _messages.EnumField('StateChangeValueValuesEnum', 2)


class ListFindingsResponse(_messages.Message):
  r"""Response message for listing findings.

  Fields:
    listFindingsResults: Findings matching the list request.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    readTime: Time used for executing the list request.
    totalSize: The total number of findings matching the query.
  """

  listFindingsResults = _messages.MessageField('ListFindingsResult', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  readTime = _messages.StringField(3)
  totalSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ListFindingsResult(_messages.Message):
  r"""Result containing the Finding and its StateChange.

  Enums:
    StateChangeValueValuesEnum: State change of the finding between the points
      in time.

  Fields:
    finding: Finding matching the search request.
    resource: Output only. Resource that is associated with this finding.
    stateChange: State change of the finding between the points in time.
  """

  class StateChangeValueValuesEnum(_messages.Enum):
    r"""State change of the finding between the points in time.

    Values:
      UNUSED: State change is unused, this is the canonical default for this
        enum.
      CHANGED: The finding has changed state in some way between the points in
        time and existed at both points.
      UNCHANGED: The finding has not changed state between the points in time
        and existed at both points.
      ADDED: The finding was created between the points in time.
      REMOVED: The finding at timestamp does not match the filter specified,
        but it did at timestamp - compare_duration.
    """
    UNUSED = 0
    CHANGED = 1
    UNCHANGED = 2
    ADDED = 3
    REMOVED = 4

  finding = _messages.MessageField('Finding', 1)
  resource = _messages.MessageField('Resource', 2)
  stateChange = _messages.EnumField('StateChangeValueValuesEnum', 3)


class ListMuteConfigsResponse(_messages.Message):
  r"""Response message for listing mute configs.

  Fields:
    muteConfigs: The mute configs from the specified parent.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  muteConfigs = _messages.MessageField('GoogleCloudSecuritycenterV1MuteConfig', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListNotificationConfigsResponse(_messages.Message):
  r"""Response message for listing notification configs.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    notificationConfigs: Notification configs belonging to the requested
      parent.
  """

  nextPageToken = _messages.StringField(1)
  notificationConfigs = _messages.MessageField('NotificationConfig', 2, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListSourcesResponse(_messages.Message):
  r"""Response message for listing sources.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
    sources: Sources belonging to the requested parent.
  """

  nextPageToken = _messages.StringField(1)
  sources = _messages.MessageField('Source', 2, repeated=True)


class NotificationConfig(_messages.Message):
  r"""Cloud Security Command Center (Cloud SCC) notification configs. A
  notification config is a Cloud SCC resource that contains the configuration
  to send notifications for create/update events of findings, assets and etc.

  Fields:
    description: The description of the notification config (max of 1024
      characters).
    name: The relative resource name of this notification config. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/notificationConfigs/notify_
      public_bucket".
    pubsubTopic: The Pub/Sub topic to send notifications to. Its format is
      "projects/[project_id]/topics/[topic]".
    serviceAccount: Output only. The service account that needs
      "pubsub.topics.publish" permission to publish to the Pub/Sub topic.
    streamingConfig: The config for triggering streaming-based notifications.
  """

  description = _messages.StringField(1)
  name = _messages.StringField(2)
  pubsubTopic = _messages.StringField(3)
  serviceAccount = _messages.StringField(4)
  streamingConfig = _messages.MessageField('StreamingConfig', 5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OrganizationSettings(_messages.Message):
  r"""User specified settings that are attached to the Security Command Center
  organization.

  Fields:
    assetDiscoveryConfig: The configuration used for Asset Discovery runs.
    enableAssetDiscovery: A flag that indicates if Asset Discovery should be
      enabled. If the flag is set to `true`, then discovery of assets will
      occur. If it is set to `false, all historical assets will remain, but
      discovery of future assets will not occur.
    name: The relative resource name of the settings. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/organizationSettings".
  """

  assetDiscoveryConfig = _messages.MessageField('AssetDiscoveryConfig', 1)
  enableAssetDiscovery = _messages.BooleanField(2)
  name = _messages.StringField(3)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Resource(_messages.Message):
  r"""Information related to the Google Cloud resource that is associated with
  this finding.

  Fields:
    folders: Contains a Folder message for each folder in the assets ancestry.
      The first folder is the deepest nested folder, and the last folder is
      the folder directly under the Organization.
    name: The full resource name of the resource. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    parentDisplayName: The human readable name of resource's parent.
    parentName: The full resource name of resource's parent.
    projectDisplayName: The human readable name of project that the resource
      belongs to.
    projectName: The full resource name of project that the resource belongs
      to.
  """

  folders = _messages.MessageField('Folder', 1, repeated=True)
  name = _messages.StringField(2)
  parentDisplayName = _messages.StringField(3)
  parentName = _messages.StringField(4)
  projectDisplayName = _messages.StringField(5)
  projectName = _messages.StringField(6)


class RunAssetDiscoveryRequest(_messages.Message):
  r"""Request message for running asset discovery for an organization."""


class SecurityCenterProperties(_messages.Message):
  r"""Security Command Center managed properties. These properties are managed
  by Security Command Center and cannot be modified by the user.

  Fields:
    folders: Contains a Folder message for each folder in the assets ancestry.
      The first folder is the deepest nested folder, and the last folder is
      the folder directly under the Organization.
    resourceDisplayName: The user defined display name for this resource.
    resourceName: The full resource name of the Google Cloud resource this
      asset represents. This field is immutable after create time. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceOwners: Owners of the Google Cloud resource.
    resourceParent: The full resource name of the immediate parent of the
      resource. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceParentDisplayName: The user defined display name for the parent of
      this resource.
    resourceProject: The full resource name of the project the resource
      belongs to. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceProjectDisplayName: The user defined display name for the project
      of this resource.
    resourceType: The type of the Google Cloud resource. Examples include:
      APPLICATION, PROJECT, and ORGANIZATION. This is a case insensitive field
      defined by Security Command Center and/or the producer of the resource
      and is immutable after create time.
  """

  folders = _messages.MessageField('Folder', 1, repeated=True)
  resourceDisplayName = _messages.StringField(2)
  resourceName = _messages.StringField(3)
  resourceOwners = _messages.StringField(4, repeated=True)
  resourceParent = _messages.StringField(5)
  resourceParentDisplayName = _messages.StringField(6)
  resourceProject = _messages.StringField(7)
  resourceProjectDisplayName = _messages.StringField(8)
  resourceType = _messages.StringField(9)


class SecurityMarks(_messages.Message):
  r"""User specified security marks that are attached to the parent Security
  Command Center resource. Security marks are scoped within a Security Command
  Center organization -- they can be modified and viewed by all users who have
  proper permissions on the organization.

  Messages:
    MarksValue: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)

  Fields:
    canonicalName: The canonical name of the marks. Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks"
      "folders/{folder_id}/assets/{asset_id}/securityMarks"
      "projects/{project_number}/assets/{asset_id}/securityMarks" "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}/securityM
      arks" "folders/{folder_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks" "projects/{project_number}/sources/{source_id}/findings/{fin
      ding_id}/securityMarks"
    marks: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MarksValue(_messages.Message):
    r"""Mutable user specified security marks belonging to the parent
    resource. Constraints are as follows: * Keys and values are treated as
    case insensitive * Keys must be between 1 - 256 characters (inclusive) *
    Keys must be letters, numbers, underscores, or dashes * Values have
    leading and trailing whitespace trimmed, remaining characters must be
    between 1 - 4096 characters (inclusive)

    Messages:
      AdditionalProperty: An additional property for a MarksValue object.

    Fields:
      additionalProperties: Additional properties of type MarksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MarksValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canonicalName = _messages.StringField(1)
  marks = _messages.MessageField('MarksValue', 2)
  name = _messages.StringField(3)


class SecuritycenterFoldersAssetsGroupRequest(_messages.Message):
  r"""A SecuritycenterFoldersAssetsGroupRequest object.

  Fields:
    groupAssetsRequest: A GroupAssetsRequest resource to be passed as the
      request body.
    parent: Required. Name of the organization to groupBy. Its format is
      "organizations/[organization_id], folders/[folder_id], or
      projects/[project_id]".
  """

  groupAssetsRequest = _messages.MessageField('GroupAssetsRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterFoldersAssetsListRequest(_messages.Message):
  r"""A SecuritycenterFoldersAssetsListRequest object.

  Fields:
    compareDuration: When compare_duration is set, the ListAssetsResult's
      "state_change" attribute is updated to indicate whether the asset was
      added, removed, or remained present during the compare_duration period
      of time that precedes the read_time. This is the time between (read_time
      - compare_duration) and read_time. The state_change value is derived
      based on the presence of the asset at the two points in time.
      Intermediate state changes between the two times don't affect the
      result. For example, the results aren't affected if the asset is removed
      and re-created again. Possible "state_change" values when
      compare_duration is specified: * "ADDED": indicates that the asset was
      not present at the start of compare_duration, but present at read_time.
      * "REMOVED": indicates that the asset was present at the start of
      compare_duration, but not present at read_time. * "ACTIVE": indicates
      that the asset was present at both the start and the end of the time
      period defined by compare_duration and read_time. If compare_duration is
      not specified, then the only possible state_change is "UNUSED", which
      will be the state_change set for all assets present at read_time.
    fieldMask: A field mask to specify the ListAssetsResult fields to be
      listed in the response. An empty field mask will list all fields.
    filter: Expression that defines the filter to apply across assets. The
      expression is a list of zero or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are supported, and `OR` has higher
      precedence than `AND`. Restrictions have the form ` ` and may have a `-`
      character in front of them to indicate negation. The fields map to those
      defined in the Asset resource. Examples include: * name *
      security_center_properties.resource_name *
      resource_properties.a_property * security_marks.marks.marka The
      supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are: * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes. The following are the allowed field and operator combinations: *
      name: `=` * update_time: `=`, `>`, `<`, `>=`, `<=` Usage: This should be
      milliseconds since epoch or an RFC3339 string. Examples: `update_time =
      "2019-06-10T16:07:18-07:00"` `update_time = 1560208038000` *
      create_time: `=`, `>`, `<`, `>=`, `<=` Usage: This should be
      milliseconds since epoch or an RFC3339 string. Examples: `create_time =
      "2019-06-10T16:07:18-07:00"` `create_time = 1560208038000` *
      iam_policy.policy_blob: `=`, `:` * resource_properties: `=`, `:`, `>`,
      `<`, `>=`, `<=` * security_marks.marks: `=`, `:` *
      security_center_properties.resource_name: `=`, `:` *
      security_center_properties.resource_display_name: `=`, `:` *
      security_center_properties.resource_type: `=`, `:` *
      security_center_properties.resource_parent: `=`, `:` *
      security_center_properties.resource_parent_display_name: `=`, `:` *
      security_center_properties.resource_project: `=`, `:` *
      security_center_properties.resource_project_display_name: `=`, `:` *
      security_center_properties.resource_owners: `=`, `:` For example,
      `resource_properties.size = 100` is a valid filter string. Use a partial
      match on the empty string to filter based on a property existing:
      `resource_properties.my_property : ""` Use a negated partial match on
      the empty string to filter based on a property not existing:
      `-resource_properties.my_property : ""`
    orderBy: Expression that defines what fields and order to use for sorting.
      The string value should follow SQL syntax: comma separated list of
      fields. For example: "name,resource_properties.a_property". The default
      sorting order is ascending. To specify descending order for a field, a
      suffix " desc" should be appended to the field name. For example: "name
      desc,resource_properties.a_property". Redundant space characters in the
      syntax are insignificant. "name desc,resource_properties.a_property" and
      " name desc , resource_properties.a_property " are equivalent. The
      following fields are supported: name update_time resource_properties
      security_marks.marks security_center_properties.resource_name
      security_center_properties.resource_display_name
      security_center_properties.resource_parent
      security_center_properties.resource_parent_display_name
      security_center_properties.resource_project
      security_center_properties.resource_project_display_name
      security_center_properties.resource_type
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListAssetsResponse`; indicates
      that this is a continuation of a prior `ListAssets` call, and that the
      system should return the next page of data.
    parent: Required. Name of the organization assets should belong to. Its
      format is "organizations/[organization_id], folders/[folder_id], or
      projects/[project_id]".
    readTime: Time used as a reference point when filtering assets. The filter
      is limited to assets existing at the supplied time and their values are
      those at that specific time. Absence of this field will default to the
      API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  fieldMask = _messages.StringField(2)
  filter = _messages.StringField(3)
  orderBy = _messages.StringField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  parent = _messages.StringField(7, required=True)
  readTime = _messages.StringField(8)


class SecuritycenterFoldersAssetsUpdateSecurityMarksRequest(_messages.Message):
  r"""A SecuritycenterFoldersAssetsUpdateSecurityMarksRequest object.

  Fields:
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
    securityMarks: A SecurityMarks resource to be passed as the request body.
    startTime: The time at which the updated SecurityMarks take effect. If not
      set uses current server time. Updates will be applied to the
      SecurityMarks that are active immediately preceding this time.
    updateMask: The FieldMask to use when updating the security marks
      resource. The field mask must not contain duplicate fields. If empty or
      set to "marks", all marks will be replaced. Individual marks can be
      updated using "marks.".
  """

  name = _messages.StringField(1, required=True)
  securityMarks = _messages.MessageField('SecurityMarks', 2)
  startTime = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SecuritycenterFoldersMuteConfigsCreateRequest(_messages.Message):
  r"""A SecuritycenterFoldersMuteConfigsCreateRequest object.

  Fields:
    googleCloudSecuritycenterV1MuteConfig: A
      GoogleCloudSecuritycenterV1MuteConfig resource to be passed as the
      request body.
    parent: Required. Resource name of the new mute configs's parent. Its
      format is "organizations/[organization_id]", "folders/[folder_id]", or
      "projects/[project_id]".
  """

  googleCloudSecuritycenterV1MuteConfig = _messages.MessageField('GoogleCloudSecuritycenterV1MuteConfig', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterFoldersMuteConfigsDeleteRequest(_messages.Message):
  r"""A SecuritycenterFoldersMuteConfigsDeleteRequest object.

  Fields:
    name: Required. Name of the mute config to delete. Its format is
      organizations/{organization}/muteConfigs/{config_id},
      folders/{folder}/muteConfigs/{config_id}, or
      projects/{project}/muteConfigs/{config_id}
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersMuteConfigsGetRequest(_messages.Message):
  r"""A SecuritycenterFoldersMuteConfigsGetRequest object.

  Fields:
    name: Required. Name of the mute config to retrieve. Its format is
      organizations/{organization}/muteConfigs/{config_id},
      folders/{folder}/muteConfigs/{config_id}, or
      projects/{project}/muteConfigs/{config_id}
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersMuteConfigsListRequest(_messages.Message):
  r"""A SecuritycenterFoldersMuteConfigsListRequest object.

  Fields:
    pageSize: The maximum number of configs to return. The service may return
      fewer than this value. If unspecified, at most 10 configs will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: A page token, received from a previous `ListMuteConfigs` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListMuteConfigs` must match the call that
      provided the page token.
    parent: Required. The parent, which owns the collection of mute configs.
      Its format is "organizations/[organization_id]", "folders/[folder_id]",
      "projects/[project_id]".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterFoldersMuteConfigsPatchRequest(_messages.Message):
  r"""A SecuritycenterFoldersMuteConfigsPatchRequest object.

  Fields:
    googleCloudSecuritycenterV1MuteConfig: A
      GoogleCloudSecuritycenterV1MuteConfig resource to be passed as the
      request body.
    name: The config id is a server generated unique identifier. This field
      will be ignored if provided on config creation. Format
      "organizations/{organization}/muteConfigs/{mute_config}"
      "folders/{folder}/muteConfigs/{mute_config}"
      "projects/{project}/muteConfigs/{mute_config}"
    updateMask: The list of fields to be updated. If empty all mutable fields
      will be updated.
  """

  googleCloudSecuritycenterV1MuteConfig = _messages.MessageField('GoogleCloudSecuritycenterV1MuteConfig', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterFoldersSourcesFindingsGroupRequest(_messages.Message):
  r"""A SecuritycenterFoldersSourcesFindingsGroupRequest object.

  Fields:
    groupFindingsRequest: A GroupFindingsRequest resource to be passed as the
      request body.
    parent: Required. Name of the source to groupBy. Its format is
      "organizations/[organization_id]/sources/[source_id]",
      folders/[folder_id]/sources/[source_id], or
      projects/[project_id]/sources/[source_id]. To groupBy across all sources
      provide a source_id of `-`. For example:
      organizations/{organization_id}/sources/-,
      folders/{folder_id}/sources/-, or projects/{project_id}/sources/-
  """

  groupFindingsRequest = _messages.MessageField('GroupFindingsRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterFoldersSourcesFindingsListRequest(_messages.Message):
  r"""A SecuritycenterFoldersSourcesFindingsListRequest object.

  Fields:
    compareDuration: When compare_duration is set, the ListFindingsResult's
      "state_change" attribute is updated to indicate whether the finding had
      its state changed, the finding's state remained unchanged, or if the
      finding was added in any state during the compare_duration period of
      time that precedes the read_time. This is the time between (read_time -
      compare_duration) and read_time. The state_change value is derived based
      on the presence and state of the finding at the two points in time.
      Intermediate state changes between the two times don't affect the
      result. For example, the results aren't affected if the finding is made
      inactive and then active again. Possible "state_change" values when
      compare_duration is specified: * "CHANGED": indicates that the finding
      was present and matched the given filter at the start of
      compare_duration, but changed its state at read_time. * "UNCHANGED":
      indicates that the finding was present and matched the given filter at
      the start of compare_duration and did not change state at read_time. *
      "ADDED": indicates that the finding did not match the given filter or
      was not present at the start of compare_duration, but was present at
      read_time. * "REMOVED": indicates that the finding was present and
      matched the filter at the start of compare_duration, but did not match
      the filter at read_time. If compare_duration is not specified, then the
      only possible state_change is "UNUSED", which will be the state_change
      set for all findings present at read_time.
    fieldMask: A field mask to specify the Finding fields to be listed in the
      response. An empty field mask will list all fields.
    filter: Expression that defines the filter to apply across findings. The
      expression is a list of one or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are supported, and `OR` has higher
      precedence than `AND`. Restrictions have the form ` ` and may have a `-`
      character in front of them to indicate negation. Examples include: *
      name * source_properties.a_property * security_marks.marks.marka The
      supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are: * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes. The following field and operator combinations are supported: *
      name: `=` * parent: `=`, `:` * resource_name: `=`, `:` * state: `=`, `:`
      * category: `=`, `:` * external_uri: `=`, `:` * event_time: `=`, `>`,
      `<`, `>=`, `<=` Usage: This should be milliseconds since epoch or an
      RFC3339 string. Examples: `event_time = "2019-06-10T16:07:18-07:00"`
      `event_time = 1560208038000` * severity: `=`, `:` * workflow_state: `=`,
      `:` * security_marks.marks: `=`, `:` * source_properties: `=`, `:`, `>`,
      `<`, `>=`, `<=` For example, `source_properties.size = 100` is a valid
      filter string. Use a partial match on the empty string to filter based
      on a property existing: `source_properties.my_property : ""` Use a
      negated partial match on the empty string to filter based on a property
      not existing: `-source_properties.my_property : ""` * resource: *
      resource.name: `=`, `:` * resource.parent_name: `=`, `:` *
      resource.parent_display_name: `=`, `:` * resource.project_name: `=`, `:`
      * resource.project_display_name: `=`, `:` * resource.type: `=`, `:` *
      resource.folders.resource_folder: `=`, `:`
    orderBy: Expression that defines what fields and order to use for sorting.
      The string value should follow SQL syntax: comma separated list of
      fields. For example: "name,resource_properties.a_property". The default
      sorting order is ascending. To specify descending order for a field, a
      suffix " desc" should be appended to the field name. For example: "name
      desc,source_properties.a_property". Redundant space characters in the
      syntax are insignificant. "name desc,source_properties.a_property" and "
      name desc , source_properties.a_property " are equivalent. The following
      fields are supported: name parent state category resource_name
      event_time source_properties security_marks.marks
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListFindingsResponse`;
      indicates that this is a continuation of a prior `ListFindings` call,
      and that the system should return the next page of data.
    parent: Required. Name of the source the findings belong to. Its format is
      "organizations/[organization_id]/sources/[source_id],
      folders/[folder_id]/sources/[source_id], or
      projects/[project_id]/sources/[source_id]". To list across all sources
      provide a source_id of `-`. For example:
      organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-
      or projects/{projects_id}/sources/-
    readTime: Time used as a reference point when filtering findings. The
      filter is limited to findings existing at the supplied time and their
      values are those at that specific time. Absence of this field will
      default to the API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  fieldMask = _messages.StringField(2)
  filter = _messages.StringField(3)
  orderBy = _messages.StringField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  parent = _messages.StringField(7, required=True)
  readTime = _messages.StringField(8)


class SecuritycenterFoldersSourcesFindingsPatchRequest(_messages.Message):
  r"""A SecuritycenterFoldersSourcesFindingsPatchRequest object.

  Fields:
    finding: A Finding resource to be passed as the request body.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      s/{finding_id}"
    updateMask: The FieldMask to use when updating the finding resource. This
      field should not be specified when creating a finding. When updating a
      finding, an empty mask is treated as updating all mutable fields and
      replacing source_properties. Individual source_properties can be
      added/updated by using "source_properties." in the field mask.
  """

  finding = _messages.MessageField('Finding', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterFoldersSourcesFindingsSetMuteRequest(_messages.Message):
  r"""A SecuritycenterFoldersSourcesFindingsSetMuteRequest object.

  Fields:
    name: Required. The relative resource name of the finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      /{finding_id}",
      "folders/{folder_id}/sources/{source_id}/finding/{finding_id}",
      "projects/{project_id}/sources/{source_id}/finding/{finding_id}".
    setMuteRequest: A SetMuteRequest resource to be passed as the request
      body.
  """

  name = _messages.StringField(1, required=True)
  setMuteRequest = _messages.MessageField('SetMuteRequest', 2)


class SecuritycenterFoldersSourcesFindingsSetStateRequest(_messages.Message):
  r"""A SecuritycenterFoldersSourcesFindingsSetStateRequest object.

  Fields:
    name: Required. The relative resource name of the finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      /{finding_id}".
    setFindingStateRequest: A SetFindingStateRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  setFindingStateRequest = _messages.MessageField('SetFindingStateRequest', 2)


class SecuritycenterFoldersSourcesFindingsUpdateSecurityMarksRequest(_messages.Message):
  r"""A SecuritycenterFoldersSourcesFindingsUpdateSecurityMarksRequest object.

  Fields:
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
    securityMarks: A SecurityMarks resource to be passed as the request body.
    startTime: The time at which the updated SecurityMarks take effect. If not
      set uses current server time. Updates will be applied to the
      SecurityMarks that are active immediately preceding this time.
    updateMask: The FieldMask to use when updating the security marks
      resource. The field mask must not contain duplicate fields. If empty or
      set to "marks", all marks will be replaced. Individual marks can be
      updated using "marks.".
  """

  name = _messages.StringField(1, required=True)
  securityMarks = _messages.MessageField('SecurityMarks', 2)
  startTime = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SecuritycenterFoldersSourcesListRequest(_messages.Message):
  r"""A SecuritycenterFoldersSourcesListRequest object.

  Fields:
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListSourcesResponse`; indicates
      that this is a continuation of a prior `ListSources` call, and that the
      system should return the next page of data.
    parent: Required. Resource name of the parent of sources to list. Its
      format should be "organizations/[organization_id], folders/[folder_id],
      or projects/[project_id]".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterOrganizationsAssetsGroupRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsAssetsGroupRequest object.

  Fields:
    groupAssetsRequest: A GroupAssetsRequest resource to be passed as the
      request body.
    parent: Required. Name of the organization to groupBy. Its format is
      "organizations/[organization_id], folders/[folder_id], or
      projects/[project_id]".
  """

  groupAssetsRequest = _messages.MessageField('GroupAssetsRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterOrganizationsAssetsListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsAssetsListRequest object.

  Fields:
    compareDuration: When compare_duration is set, the ListAssetsResult's
      "state_change" attribute is updated to indicate whether the asset was
      added, removed, or remained present during the compare_duration period
      of time that precedes the read_time. This is the time between (read_time
      - compare_duration) and read_time. The state_change value is derived
      based on the presence of the asset at the two points in time.
      Intermediate state changes between the two times don't affect the
      result. For example, the results aren't affected if the asset is removed
      and re-created again. Possible "state_change" values when
      compare_duration is specified: * "ADDED": indicates that the asset was
      not present at the start of compare_duration, but present at read_time.
      * "REMOVED": indicates that the asset was present at the start of
      compare_duration, but not present at read_time. * "ACTIVE": indicates
      that the asset was present at both the start and the end of the time
      period defined by compare_duration and read_time. If compare_duration is
      not specified, then the only possible state_change is "UNUSED", which
      will be the state_change set for all assets present at read_time.
    fieldMask: A field mask to specify the ListAssetsResult fields to be
      listed in the response. An empty field mask will list all fields.
    filter: Expression that defines the filter to apply across assets. The
      expression is a list of zero or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are supported, and `OR` has higher
      precedence than `AND`. Restrictions have the form ` ` and may have a `-`
      character in front of them to indicate negation. The fields map to those
      defined in the Asset resource. Examples include: * name *
      security_center_properties.resource_name *
      resource_properties.a_property * security_marks.marks.marka The
      supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are: * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes. The following are the allowed field and operator combinations: *
      name: `=` * update_time: `=`, `>`, `<`, `>=`, `<=` Usage: This should be
      milliseconds since epoch or an RFC3339 string. Examples: `update_time =
      "2019-06-10T16:07:18-07:00"` `update_time = 1560208038000` *
      create_time: `=`, `>`, `<`, `>=`, `<=` Usage: This should be
      milliseconds since epoch or an RFC3339 string. Examples: `create_time =
      "2019-06-10T16:07:18-07:00"` `create_time = 1560208038000` *
      iam_policy.policy_blob: `=`, `:` * resource_properties: `=`, `:`, `>`,
      `<`, `>=`, `<=` * security_marks.marks: `=`, `:` *
      security_center_properties.resource_name: `=`, `:` *
      security_center_properties.resource_display_name: `=`, `:` *
      security_center_properties.resource_type: `=`, `:` *
      security_center_properties.resource_parent: `=`, `:` *
      security_center_properties.resource_parent_display_name: `=`, `:` *
      security_center_properties.resource_project: `=`, `:` *
      security_center_properties.resource_project_display_name: `=`, `:` *
      security_center_properties.resource_owners: `=`, `:` For example,
      `resource_properties.size = 100` is a valid filter string. Use a partial
      match on the empty string to filter based on a property existing:
      `resource_properties.my_property : ""` Use a negated partial match on
      the empty string to filter based on a property not existing:
      `-resource_properties.my_property : ""`
    orderBy: Expression that defines what fields and order to use for sorting.
      The string value should follow SQL syntax: comma separated list of
      fields. For example: "name,resource_properties.a_property". The default
      sorting order is ascending. To specify descending order for a field, a
      suffix " desc" should be appended to the field name. For example: "name
      desc,resource_properties.a_property". Redundant space characters in the
      syntax are insignificant. "name desc,resource_properties.a_property" and
      " name desc , resource_properties.a_property " are equivalent. The
      following fields are supported: name update_time resource_properties
      security_marks.marks security_center_properties.resource_name
      security_center_properties.resource_display_name
      security_center_properties.resource_parent
      security_center_properties.resource_parent_display_name
      security_center_properties.resource_project
      security_center_properties.resource_project_display_name
      security_center_properties.resource_type
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListAssetsResponse`; indicates
      that this is a continuation of a prior `ListAssets` call, and that the
      system should return the next page of data.
    parent: Required. Name of the organization assets should belong to. Its
      format is "organizations/[organization_id], folders/[folder_id], or
      projects/[project_id]".
    readTime: Time used as a reference point when filtering assets. The filter
      is limited to assets existing at the supplied time and their values are
      those at that specific time. Absence of this field will default to the
      API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  fieldMask = _messages.StringField(2)
  filter = _messages.StringField(3)
  orderBy = _messages.StringField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  parent = _messages.StringField(7, required=True)
  readTime = _messages.StringField(8)


class SecuritycenterOrganizationsAssetsRunDiscoveryRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsAssetsRunDiscoveryRequest object.

  Fields:
    parent: Required. Name of the organization to run asset discovery for. Its
      format is "organizations/[organization_id]".
    runAssetDiscoveryRequest: A RunAssetDiscoveryRequest resource to be passed
      as the request body.
  """

  parent = _messages.StringField(1, required=True)
  runAssetDiscoveryRequest = _messages.MessageField('RunAssetDiscoveryRequest', 2)


class SecuritycenterOrganizationsAssetsUpdateSecurityMarksRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsAssetsUpdateSecurityMarksRequest object.

  Fields:
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
    securityMarks: A SecurityMarks resource to be passed as the request body.
    startTime: The time at which the updated SecurityMarks take effect. If not
      set uses current server time. Updates will be applied to the
      SecurityMarks that are active immediately preceding this time.
    updateMask: The FieldMask to use when updating the security marks
      resource. The field mask must not contain duplicate fields. If empty or
      set to "marks", all marks will be replaced. Individual marks can be
      updated using "marks.".
  """

  name = _messages.StringField(1, required=True)
  securityMarks = _messages.MessageField('SecurityMarks', 2)
  startTime = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SecuritycenterOrganizationsGetOrganizationSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetOrganizationSettingsRequest object.

  Fields:
    name: Required. Name of the organization to get organization settings for.
      Its format is "organizations/[organization_id]/organizationSettings".
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsMuteConfigsCreateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsMuteConfigsCreateRequest object.

  Fields:
    googleCloudSecuritycenterV1MuteConfig: A
      GoogleCloudSecuritycenterV1MuteConfig resource to be passed as the
      request body.
    parent: Required. Resource name of the new mute configs's parent. Its
      format is "organizations/[organization_id]", "folders/[folder_id]", or
      "projects/[project_id]".
  """

  googleCloudSecuritycenterV1MuteConfig = _messages.MessageField('GoogleCloudSecuritycenterV1MuteConfig', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterOrganizationsMuteConfigsDeleteRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsMuteConfigsDeleteRequest object.

  Fields:
    name: Required. Name of the mute config to delete. Its format is
      organizations/{organization}/muteConfigs/{config_id},
      folders/{folder}/muteConfigs/{config_id}, or
      projects/{project}/muteConfigs/{config_id}
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsMuteConfigsGetRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsMuteConfigsGetRequest object.

  Fields:
    name: Required. Name of the mute config to retrieve. Its format is
      organizations/{organization}/muteConfigs/{config_id},
      folders/{folder}/muteConfigs/{config_id}, or
      projects/{project}/muteConfigs/{config_id}
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsMuteConfigsListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsMuteConfigsListRequest object.

  Fields:
    pageSize: The maximum number of configs to return. The service may return
      fewer than this value. If unspecified, at most 10 configs will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: A page token, received from a previous `ListMuteConfigs` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListMuteConfigs` must match the call that
      provided the page token.
    parent: Required. The parent, which owns the collection of mute configs.
      Its format is "organizations/[organization_id]", "folders/[folder_id]",
      "projects/[project_id]".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterOrganizationsMuteConfigsPatchRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsMuteConfigsPatchRequest object.

  Fields:
    googleCloudSecuritycenterV1MuteConfig: A
      GoogleCloudSecuritycenterV1MuteConfig resource to be passed as the
      request body.
    name: The config id is a server generated unique identifier. This field
      will be ignored if provided on config creation. Format
      "organizations/{organization}/muteConfigs/{mute_config}"
      "folders/{folder}/muteConfigs/{mute_config}"
      "projects/{project}/muteConfigs/{mute_config}"
    updateMask: The list of fields to be updated. If empty all mutable fields
      will be updated.
  """

  googleCloudSecuritycenterV1MuteConfig = _messages.MessageField('GoogleCloudSecuritycenterV1MuteConfig', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsNotificationConfigsCreateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsNotificationConfigsCreateRequest object.

  Fields:
    configId: Required. Unique identifier provided by the client within the
      parent scope. It must be between 1 and 128 characters, and contains
      alphanumeric characters, underscores or hyphens only.
    notificationConfig: A NotificationConfig resource to be passed as the
      request body.
    parent: Required. Resource name of the new notification config's parent.
      Its format is "organizations/[organization_id]".
  """

  configId = _messages.StringField(1)
  notificationConfig = _messages.MessageField('NotificationConfig', 2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterOrganizationsNotificationConfigsDeleteRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsNotificationConfigsDeleteRequest object.

  Fields:
    name: Required. Name of the notification config to delete. Its format is
      "organizations/[organization_id]/notificationConfigs/[config_id]".
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsNotificationConfigsGetRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsNotificationConfigsGetRequest object.

  Fields:
    name: Required. Name of the notification config to get. Its format is
      "organizations/[organization_id]/notificationConfigs/[config_id]".
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsNotificationConfigsListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsNotificationConfigsListRequest object.

  Fields:
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last
      `ListNotificationConfigsResponse`; indicates that this is a continuation
      of a prior `ListNotificationConfigs` call, and that the system should
      return the next page of data.
    parent: Required. Name of the organization to list notification configs.
      Its format is "organizations/[organization_id]".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterOrganizationsNotificationConfigsPatchRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsNotificationConfigsPatchRequest object.

  Fields:
    name: The relative resource name of this notification config. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/notificationConfigs/notify_
      public_bucket".
    notificationConfig: A NotificationConfig resource to be passed as the
      request body.
    updateMask: The FieldMask to use when updating the notification config. If
      empty all mutable fields will be updated.
  """

  name = _messages.StringField(1, required=True)
  notificationConfig = _messages.MessageField('NotificationConfig', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsOperationsCancelRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsOperationsDeleteRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsOperationsGetRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsOperationsListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SecuritycenterOrganizationsSourcesCreateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesCreateRequest object.

  Fields:
    parent: Required. Resource name of the new source's parent. Its format
      should be "organizations/[organization_id]".
    source: A Source resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  source = _messages.MessageField('Source', 2)


class SecuritycenterOrganizationsSourcesFindingsCreateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsCreateRequest object.

  Fields:
    finding: A Finding resource to be passed as the request body.
    findingId: Required. Unique identifier provided by the client within the
      parent scope. It must be alphanumeric and less than or equal to 32
      characters and greater than 0 characters in length.
    parent: Required. Resource name of the new finding's parent. Its format
      should be "organizations/[organization_id]/sources/[source_id]".
  """

  finding = _messages.MessageField('Finding', 1)
  findingId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterOrganizationsSourcesFindingsGroupRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsGroupRequest object.

  Fields:
    groupFindingsRequest: A GroupFindingsRequest resource to be passed as the
      request body.
    parent: Required. Name of the source to groupBy. Its format is
      "organizations/[organization_id]/sources/[source_id]",
      folders/[folder_id]/sources/[source_id], or
      projects/[project_id]/sources/[source_id]. To groupBy across all sources
      provide a source_id of `-`. For example:
      organizations/{organization_id}/sources/-,
      folders/{folder_id}/sources/-, or projects/{project_id}/sources/-
  """

  groupFindingsRequest = _messages.MessageField('GroupFindingsRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterOrganizationsSourcesFindingsListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsListRequest object.

  Fields:
    compareDuration: When compare_duration is set, the ListFindingsResult's
      "state_change" attribute is updated to indicate whether the finding had
      its state changed, the finding's state remained unchanged, or if the
      finding was added in any state during the compare_duration period of
      time that precedes the read_time. This is the time between (read_time -
      compare_duration) and read_time. The state_change value is derived based
      on the presence and state of the finding at the two points in time.
      Intermediate state changes between the two times don't affect the
      result. For example, the results aren't affected if the finding is made
      inactive and then active again. Possible "state_change" values when
      compare_duration is specified: * "CHANGED": indicates that the finding
      was present and matched the given filter at the start of
      compare_duration, but changed its state at read_time. * "UNCHANGED":
      indicates that the finding was present and matched the given filter at
      the start of compare_duration and did not change state at read_time. *
      "ADDED": indicates that the finding did not match the given filter or
      was not present at the start of compare_duration, but was present at
      read_time. * "REMOVED": indicates that the finding was present and
      matched the filter at the start of compare_duration, but did not match
      the filter at read_time. If compare_duration is not specified, then the
      only possible state_change is "UNUSED", which will be the state_change
      set for all findings present at read_time.
    fieldMask: A field mask to specify the Finding fields to be listed in the
      response. An empty field mask will list all fields.
    filter: Expression that defines the filter to apply across findings. The
      expression is a list of one or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are supported, and `OR` has higher
      precedence than `AND`. Restrictions have the form ` ` and may have a `-`
      character in front of them to indicate negation. Examples include: *
      name * source_properties.a_property * security_marks.marks.marka The
      supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are: * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes. The following field and operator combinations are supported: *
      name: `=` * parent: `=`, `:` * resource_name: `=`, `:` * state: `=`, `:`
      * category: `=`, `:` * external_uri: `=`, `:` * event_time: `=`, `>`,
      `<`, `>=`, `<=` Usage: This should be milliseconds since epoch or an
      RFC3339 string. Examples: `event_time = "2019-06-10T16:07:18-07:00"`
      `event_time = 1560208038000` * severity: `=`, `:` * workflow_state: `=`,
      `:` * security_marks.marks: `=`, `:` * source_properties: `=`, `:`, `>`,
      `<`, `>=`, `<=` For example, `source_properties.size = 100` is a valid
      filter string. Use a partial match on the empty string to filter based
      on a property existing: `source_properties.my_property : ""` Use a
      negated partial match on the empty string to filter based on a property
      not existing: `-source_properties.my_property : ""` * resource: *
      resource.name: `=`, `:` * resource.parent_name: `=`, `:` *
      resource.parent_display_name: `=`, `:` * resource.project_name: `=`, `:`
      * resource.project_display_name: `=`, `:` * resource.type: `=`, `:` *
      resource.folders.resource_folder: `=`, `:`
    orderBy: Expression that defines what fields and order to use for sorting.
      The string value should follow SQL syntax: comma separated list of
      fields. For example: "name,resource_properties.a_property". The default
      sorting order is ascending. To specify descending order for a field, a
      suffix " desc" should be appended to the field name. For example: "name
      desc,source_properties.a_property". Redundant space characters in the
      syntax are insignificant. "name desc,source_properties.a_property" and "
      name desc , source_properties.a_property " are equivalent. The following
      fields are supported: name parent state category resource_name
      event_time source_properties security_marks.marks
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListFindingsResponse`;
      indicates that this is a continuation of a prior `ListFindings` call,
      and that the system should return the next page of data.
    parent: Required. Name of the source the findings belong to. Its format is
      "organizations/[organization_id]/sources/[source_id],
      folders/[folder_id]/sources/[source_id], or
      projects/[project_id]/sources/[source_id]". To list across all sources
      provide a source_id of `-`. For example:
      organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-
      or projects/{projects_id}/sources/-
    readTime: Time used as a reference point when filtering findings. The
      filter is limited to findings existing at the supplied time and their
      values are those at that specific time. Absence of this field will
      default to the API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  fieldMask = _messages.StringField(2)
  filter = _messages.StringField(3)
  orderBy = _messages.StringField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  parent = _messages.StringField(7, required=True)
  readTime = _messages.StringField(8)


class SecuritycenterOrganizationsSourcesFindingsPatchRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsPatchRequest object.

  Fields:
    finding: A Finding resource to be passed as the request body.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      s/{finding_id}"
    updateMask: The FieldMask to use when updating the finding resource. This
      field should not be specified when creating a finding. When updating a
      finding, an empty mask is treated as updating all mutable fields and
      replacing source_properties. Individual source_properties can be
      added/updated by using "source_properties." in the field mask.
  """

  finding = _messages.MessageField('Finding', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsSourcesFindingsSetMuteRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsSetMuteRequest object.

  Fields:
    name: Required. The relative resource name of the finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      /{finding_id}",
      "folders/{folder_id}/sources/{source_id}/finding/{finding_id}",
      "projects/{project_id}/sources/{source_id}/finding/{finding_id}".
    setMuteRequest: A SetMuteRequest resource to be passed as the request
      body.
  """

  name = _messages.StringField(1, required=True)
  setMuteRequest = _messages.MessageField('SetMuteRequest', 2)


class SecuritycenterOrganizationsSourcesFindingsSetStateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsSetStateRequest object.

  Fields:
    name: Required. The relative resource name of the finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      /{finding_id}".
    setFindingStateRequest: A SetFindingStateRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  setFindingStateRequest = _messages.MessageField('SetFindingStateRequest', 2)


class SecuritycenterOrganizationsSourcesFindingsUpdateSecurityMarksRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesFindingsUpdateSecurityMarksRequest
  object.

  Fields:
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
    securityMarks: A SecurityMarks resource to be passed as the request body.
    startTime: The time at which the updated SecurityMarks take effect. If not
      set uses current server time. Updates will be applied to the
      SecurityMarks that are active immediately preceding this time.
    updateMask: The FieldMask to use when updating the security marks
      resource. The field mask must not contain duplicate fields. If empty or
      set to "marks", all marks will be replaced. Individual marks can be
      updated using "marks.".
  """

  name = _messages.StringField(1, required=True)
  securityMarks = _messages.MessageField('SecurityMarks', 2)
  startTime = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SecuritycenterOrganizationsSourcesGetIamPolicyRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class SecuritycenterOrganizationsSourcesGetRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesGetRequest object.

  Fields:
    name: Required. Relative resource name of the source. Its format is
      "organizations/[organization_id]/source/[source_id]".
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsSourcesListRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesListRequest object.

  Fields:
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListSourcesResponse`; indicates
      that this is a continuation of a prior `ListSources` call, and that the
      system should return the next page of data.
    parent: Required. Resource name of the parent of sources to list. Its
      format should be "organizations/[organization_id], folders/[folder_id],
      or projects/[project_id]".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterOrganizationsSourcesPatchRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesPatchRequest object.

  Fields:
    name: The relative resource name of this source. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}"
    source: A Source resource to be passed as the request body.
    updateMask: The FieldMask to use when updating the source resource. If
      empty all mutable fields will be updated.
  """

  name = _messages.StringField(1, required=True)
  source = _messages.MessageField('Source', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsSourcesSetIamPolicyRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class SecuritycenterOrganizationsSourcesTestIamPermissionsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsSourcesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class SecuritycenterOrganizationsUpdateOrganizationSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsUpdateOrganizationSettingsRequest object.

  Fields:
    name: The relative resource name of the settings. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/organizationSettings".
    organizationSettings: A OrganizationSettings resource to be passed as the
      request body.
    updateMask: The FieldMask to use when updating the settings resource. If
      empty all mutable fields will be updated.
  """

  name = _messages.StringField(1, required=True)
  organizationSettings = _messages.MessageField('OrganizationSettings', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsAssetsGroupRequest(_messages.Message):
  r"""A SecuritycenterProjectsAssetsGroupRequest object.

  Fields:
    groupAssetsRequest: A GroupAssetsRequest resource to be passed as the
      request body.
    parent: Required. Name of the organization to groupBy. Its format is
      "organizations/[organization_id], folders/[folder_id], or
      projects/[project_id]".
  """

  groupAssetsRequest = _messages.MessageField('GroupAssetsRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterProjectsAssetsListRequest(_messages.Message):
  r"""A SecuritycenterProjectsAssetsListRequest object.

  Fields:
    compareDuration: When compare_duration is set, the ListAssetsResult's
      "state_change" attribute is updated to indicate whether the asset was
      added, removed, or remained present during the compare_duration period
      of time that precedes the read_time. This is the time between (read_time
      - compare_duration) and read_time. The state_change value is derived
      based on the presence of the asset at the two points in time.
      Intermediate state changes between the two times don't affect the
      result. For example, the results aren't affected if the asset is removed
      and re-created again. Possible "state_change" values when
      compare_duration is specified: * "ADDED": indicates that the asset was
      not present at the start of compare_duration, but present at read_time.
      * "REMOVED": indicates that the asset was present at the start of
      compare_duration, but not present at read_time. * "ACTIVE": indicates
      that the asset was present at both the start and the end of the time
      period defined by compare_duration and read_time. If compare_duration is
      not specified, then the only possible state_change is "UNUSED", which
      will be the state_change set for all assets present at read_time.
    fieldMask: A field mask to specify the ListAssetsResult fields to be
      listed in the response. An empty field mask will list all fields.
    filter: Expression that defines the filter to apply across assets. The
      expression is a list of zero or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are supported, and `OR` has higher
      precedence than `AND`. Restrictions have the form ` ` and may have a `-`
      character in front of them to indicate negation. The fields map to those
      defined in the Asset resource. Examples include: * name *
      security_center_properties.resource_name *
      resource_properties.a_property * security_marks.marks.marka The
      supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are: * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes. The following are the allowed field and operator combinations: *
      name: `=` * update_time: `=`, `>`, `<`, `>=`, `<=` Usage: This should be
      milliseconds since epoch or an RFC3339 string. Examples: `update_time =
      "2019-06-10T16:07:18-07:00"` `update_time = 1560208038000` *
      create_time: `=`, `>`, `<`, `>=`, `<=` Usage: This should be
      milliseconds since epoch or an RFC3339 string. Examples: `create_time =
      "2019-06-10T16:07:18-07:00"` `create_time = 1560208038000` *
      iam_policy.policy_blob: `=`, `:` * resource_properties: `=`, `:`, `>`,
      `<`, `>=`, `<=` * security_marks.marks: `=`, `:` *
      security_center_properties.resource_name: `=`, `:` *
      security_center_properties.resource_display_name: `=`, `:` *
      security_center_properties.resource_type: `=`, `:` *
      security_center_properties.resource_parent: `=`, `:` *
      security_center_properties.resource_parent_display_name: `=`, `:` *
      security_center_properties.resource_project: `=`, `:` *
      security_center_properties.resource_project_display_name: `=`, `:` *
      security_center_properties.resource_owners: `=`, `:` For example,
      `resource_properties.size = 100` is a valid filter string. Use a partial
      match on the empty string to filter based on a property existing:
      `resource_properties.my_property : ""` Use a negated partial match on
      the empty string to filter based on a property not existing:
      `-resource_properties.my_property : ""`
    orderBy: Expression that defines what fields and order to use for sorting.
      The string value should follow SQL syntax: comma separated list of
      fields. For example: "name,resource_properties.a_property". The default
      sorting order is ascending. To specify descending order for a field, a
      suffix " desc" should be appended to the field name. For example: "name
      desc,resource_properties.a_property". Redundant space characters in the
      syntax are insignificant. "name desc,resource_properties.a_property" and
      " name desc , resource_properties.a_property " are equivalent. The
      following fields are supported: name update_time resource_properties
      security_marks.marks security_center_properties.resource_name
      security_center_properties.resource_display_name
      security_center_properties.resource_parent
      security_center_properties.resource_parent_display_name
      security_center_properties.resource_project
      security_center_properties.resource_project_display_name
      security_center_properties.resource_type
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListAssetsResponse`; indicates
      that this is a continuation of a prior `ListAssets` call, and that the
      system should return the next page of data.
    parent: Required. Name of the organization assets should belong to. Its
      format is "organizations/[organization_id], folders/[folder_id], or
      projects/[project_id]".
    readTime: Time used as a reference point when filtering assets. The filter
      is limited to assets existing at the supplied time and their values are
      those at that specific time. Absence of this field will default to the
      API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  fieldMask = _messages.StringField(2)
  filter = _messages.StringField(3)
  orderBy = _messages.StringField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  parent = _messages.StringField(7, required=True)
  readTime = _messages.StringField(8)


class SecuritycenterProjectsAssetsUpdateSecurityMarksRequest(_messages.Message):
  r"""A SecuritycenterProjectsAssetsUpdateSecurityMarksRequest object.

  Fields:
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
    securityMarks: A SecurityMarks resource to be passed as the request body.
    startTime: The time at which the updated SecurityMarks take effect. If not
      set uses current server time. Updates will be applied to the
      SecurityMarks that are active immediately preceding this time.
    updateMask: The FieldMask to use when updating the security marks
      resource. The field mask must not contain duplicate fields. If empty or
      set to "marks", all marks will be replaced. Individual marks can be
      updated using "marks.".
  """

  name = _messages.StringField(1, required=True)
  securityMarks = _messages.MessageField('SecurityMarks', 2)
  startTime = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SecuritycenterProjectsMuteConfigsCreateRequest(_messages.Message):
  r"""A SecuritycenterProjectsMuteConfigsCreateRequest object.

  Fields:
    googleCloudSecuritycenterV1MuteConfig: A
      GoogleCloudSecuritycenterV1MuteConfig resource to be passed as the
      request body.
    parent: Required. Resource name of the new mute configs's parent. Its
      format is "organizations/[organization_id]", "folders/[folder_id]", or
      "projects/[project_id]".
  """

  googleCloudSecuritycenterV1MuteConfig = _messages.MessageField('GoogleCloudSecuritycenterV1MuteConfig', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterProjectsMuteConfigsDeleteRequest(_messages.Message):
  r"""A SecuritycenterProjectsMuteConfigsDeleteRequest object.

  Fields:
    name: Required. Name of the mute config to delete. Its format is
      organizations/{organization}/muteConfigs/{config_id},
      folders/{folder}/muteConfigs/{config_id}, or
      projects/{project}/muteConfigs/{config_id}
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsMuteConfigsGetRequest(_messages.Message):
  r"""A SecuritycenterProjectsMuteConfigsGetRequest object.

  Fields:
    name: Required. Name of the mute config to retrieve. Its format is
      organizations/{organization}/muteConfigs/{config_id},
      folders/{folder}/muteConfigs/{config_id}, or
      projects/{project}/muteConfigs/{config_id}
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsMuteConfigsListRequest(_messages.Message):
  r"""A SecuritycenterProjectsMuteConfigsListRequest object.

  Fields:
    pageSize: The maximum number of configs to return. The service may return
      fewer than this value. If unspecified, at most 10 configs will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: A page token, received from a previous `ListMuteConfigs` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListMuteConfigs` must match the call that
      provided the page token.
    parent: Required. The parent, which owns the collection of mute configs.
      Its format is "organizations/[organization_id]", "folders/[folder_id]",
      "projects/[project_id]".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycenterProjectsMuteConfigsPatchRequest(_messages.Message):
  r"""A SecuritycenterProjectsMuteConfigsPatchRequest object.

  Fields:
    googleCloudSecuritycenterV1MuteConfig: A
      GoogleCloudSecuritycenterV1MuteConfig resource to be passed as the
      request body.
    name: The config id is a server generated unique identifier. This field
      will be ignored if provided on config creation. Format
      "organizations/{organization}/muteConfigs/{mute_config}"
      "folders/{folder}/muteConfigs/{mute_config}"
      "projects/{project}/muteConfigs/{mute_config}"
    updateMask: The list of fields to be updated. If empty all mutable fields
      will be updated.
  """

  googleCloudSecuritycenterV1MuteConfig = _messages.MessageField('GoogleCloudSecuritycenterV1MuteConfig', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsSourcesFindingsGroupRequest(_messages.Message):
  r"""A SecuritycenterProjectsSourcesFindingsGroupRequest object.

  Fields:
    groupFindingsRequest: A GroupFindingsRequest resource to be passed as the
      request body.
    parent: Required. Name of the source to groupBy. Its format is
      "organizations/[organization_id]/sources/[source_id]",
      folders/[folder_id]/sources/[source_id], or
      projects/[project_id]/sources/[source_id]. To groupBy across all sources
      provide a source_id of `-`. For example:
      organizations/{organization_id}/sources/-,
      folders/{folder_id}/sources/-, or projects/{project_id}/sources/-
  """

  groupFindingsRequest = _messages.MessageField('GroupFindingsRequest', 1)
  parent = _messages.StringField(2, required=True)


class SecuritycenterProjectsSourcesFindingsListRequest(_messages.Message):
  r"""A SecuritycenterProjectsSourcesFindingsListRequest object.

  Fields:
    compareDuration: When compare_duration is set, the ListFindingsResult's
      "state_change" attribute is updated to indicate whether the finding had
      its state changed, the finding's state remained unchanged, or if the
      finding was added in any state during the compare_duration period of
      time that precedes the read_time. This is the time between (read_time -
      compare_duration) and read_time. The state_change value is derived based
      on the presence and state of the finding at the two points in time.
      Intermediate state changes between the two times don't affect the
      result. For example, the results aren't affected if the finding is made
      inactive and then active again. Possible "state_change" values when
      compare_duration is specified: * "CHANGED": indicates that the finding
      was present and matched the given filter at the start of
      compare_duration, but changed its state at read_time. * "UNCHANGED":
      indicates that the finding was present and matched the given filter at
      the start of compare_duration and did not change state at read_time. *
      "ADDED": indicates that the finding did not match the given filter or
      was not present at the start of compare_duration, but was present at
      read_time. * "REMOVED": indicates that the finding was present and
      matched the filter at the start of compare_duration, but did not match
      the filter at read_time. If compare_duration is not specified, then the
      only possible state_change is "UNUSED", which will be the state_change
      set for all findings present at read_time.
    fieldMask: A field mask to specify the Finding fields to be listed in the
      response. An empty field mask will list all fields.
    filter: Expression that defines the filter to apply across findings. The
      expression is a list of one or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are supported, and `OR` has higher
      precedence than `AND`. Restrictions have the form ` ` and may have a `-`
      character in front of them to indicate negation. Examples include: *
      name * source_properties.a_property * security_marks.marks.marka The
      supported operators are: * `=` for all value types. * `>`, `<`, `>=`,
      `<=` for integer values. * `:`, meaning substring matching, for strings.
      The supported value types are: * string literals in quotes. * integer
      literals without quotes. * boolean literals `true` and `false` without
      quotes. The following field and operator combinations are supported: *
      name: `=` * parent: `=`, `:` * resource_name: `=`, `:` * state: `=`, `:`
      * category: `=`, `:` * external_uri: `=`, `:` * event_time: `=`, `>`,
      `<`, `>=`, `<=` Usage: This should be milliseconds since epoch or an
      RFC3339 string. Examples: `event_time = "2019-06-10T16:07:18-07:00"`
      `event_time = 1560208038000` * severity: `=`, `:` * workflow_state: `=`,
      `:` * security_marks.marks: `=`, `:` * source_properties: `=`, `:`, `>`,
      `<`, `>=`, `<=` For example, `source_properties.size = 100` is a valid
      filter string. Use a partial match on the empty string to filter based
      on a property existing: `source_properties.my_property : ""` Use a
      negated partial match on the empty string to filter based on a property
      not existing: `-source_properties.my_property : ""` * resource: *
      resource.name: `=`, `:` * resource.parent_name: `=`, `:` *
      resource.parent_display_name: `=`, `:` * resource.project_name: `=`, `:`
      * resource.project_display_name: `=`, `:` * resource.type: `=`, `:` *
      resource.folders.resource_folder: `=`, `:`
    orderBy: Expression that defines what fields and order to use for sorting.
      The string value should follow SQL syntax: comma separated list of
      fields. For example: "name,resource_properties.a_property". The default
      sorting order is ascending. To specify descending order for a field, a
      suffix " desc" should be appended to the field name. For example: "name
      desc,source_properties.a_property". Redundant space characters in the
      syntax are insignificant. "name desc,source_properties.a_property" and "
      name desc , source_properties.a_property " are equivalent. The following
      fields are supported: name parent state category resource_name
      event_time source_properties security_marks.marks
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListFindingsResponse`;
      indicates that this is a continuation of a prior `ListFindings` call,
      and that the system should return the next page of data.
    parent: Required. Name of the source the findings belong to. Its format is
      "organizations/[organization_id]/sources/[source_id],
      folders/[folder_id]/sources/[source_id], or
      projects/[project_id]/sources/[source_id]". To list across all sources
      provide a source_id of `-`. For example:
      organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-
      or projects/{projects_id}/sources/-
    readTime: Time used as a reference point when filtering findings. The
      filter is limited to findings existing at the supplied time and their
      values are those at that specific time. Absence of this field will
      default to the API's version of NOW.
  """

  compareDuration = _messages.StringField(1)
  fieldMask = _messages.StringField(2)
  filter = _messages.StringField(3)
  orderBy = _messages.StringField(4)
  pageSize = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(6)
  parent = _messages.StringField(7, required=True)
  readTime = _messages.StringField(8)


class SecuritycenterProjectsSourcesFindingsPatchRequest(_messages.Message):
  r"""A SecuritycenterProjectsSourcesFindingsPatchRequest object.

  Fields:
    finding: A Finding resource to be passed as the request body.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      s/{finding_id}"
    updateMask: The FieldMask to use when updating the finding resource. This
      field should not be specified when creating a finding. When updating a
      finding, an empty mask is treated as updating all mutable fields and
      replacing source_properties. Individual source_properties can be
      added/updated by using "source_properties." in the field mask.
  """

  finding = _messages.MessageField('Finding', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsSourcesFindingsSetMuteRequest(_messages.Message):
  r"""A SecuritycenterProjectsSourcesFindingsSetMuteRequest object.

  Fields:
    name: Required. The relative resource name of the finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      /{finding_id}",
      "folders/{folder_id}/sources/{source_id}/finding/{finding_id}",
      "projects/{project_id}/sources/{source_id}/finding/{finding_id}".
    setMuteRequest: A SetMuteRequest resource to be passed as the request
      body.
  """

  name = _messages.StringField(1, required=True)
  setMuteRequest = _messages.MessageField('SetMuteRequest', 2)


class SecuritycenterProjectsSourcesFindingsSetStateRequest(_messages.Message):
  r"""A SecuritycenterProjectsSourcesFindingsSetStateRequest object.

  Fields:
    name: Required. The relative resource name of the finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      /{finding_id}".
    setFindingStateRequest: A SetFindingStateRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  setFindingStateRequest = _messages.MessageField('SetFindingStateRequest', 2)


class SecuritycenterProjectsSourcesFindingsUpdateSecurityMarksRequest(_messages.Message):
  r"""A SecuritycenterProjectsSourcesFindingsUpdateSecurityMarksRequest
  object.

  Fields:
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
    securityMarks: A SecurityMarks resource to be passed as the request body.
    startTime: The time at which the updated SecurityMarks take effect. If not
      set uses current server time. Updates will be applied to the
      SecurityMarks that are active immediately preceding this time.
    updateMask: The FieldMask to use when updating the security marks
      resource. The field mask must not contain duplicate fields. If empty or
      set to "marks", all marks will be replaced. Individual marks can be
      updated using "marks.".
  """

  name = _messages.StringField(1, required=True)
  securityMarks = _messages.MessageField('SecurityMarks', 2)
  startTime = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SecuritycenterProjectsSourcesListRequest(_messages.Message):
  r"""A SecuritycenterProjectsSourcesListRequest object.

  Fields:
    pageSize: The maximum number of results to return in a single response.
      Default is 10, minimum is 1, maximum is 1000.
    pageToken: The value returned by the last `ListSourcesResponse`; indicates
      that this is a continuation of a prior `ListSources` call, and that the
      system should return the next page of data.
    parent: Required. Resource name of the parent of sources to list. Its
      format should be "organizations/[organization_id], folders/[folder_id],
      or projects/[project_id]".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SetFindingStateRequest(_messages.Message):
  r"""Request message for updating a finding's state.

  Enums:
    StateValueValuesEnum: Required. The desired State of the finding.

  Fields:
    startTime: Required. The time at which the updated state takes effect.
    state: Required. The desired State of the finding.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Required. The desired State of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  startTime = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SetMuteRequest(_messages.Message):
  r"""Request message for updating a finding's mute status.

  Enums:
    MuteValueValuesEnum: Required. The desired state of the Mute.

  Fields:
    mute: Required. The desired state of the Mute.
  """

  class MuteValueValuesEnum(_messages.Enum):
    r"""Required. The desired state of the Mute.

    Values:
      MUTE_UNSPECIFIED: Unspecified i.e. the finding has never been
        muted/unmuted.
      MUTED: Finding has been muted.
      UNMUTED: Finding has been unmuted.
    """
    MUTE_UNSPECIFIED = 0
    MUTED = 1
    UNMUTED = 2

  mute = _messages.EnumField('MuteValueValuesEnum', 1)


class Source(_messages.Message):
  r"""Security Command Center finding source. A finding source is an entity or
  a mechanism that can produce a finding. A source is like a container of
  findings that come from the same scanner, logger, monitor, and other tools.

  Fields:
    canonicalName: The canonical name of the finding. It's either
      "organizations/{organization_id}/sources/{source_id}",
      "folders/{folder_id}/sources/{source_id}" or
      "projects/{project_number}/sources/{source_id}", depending on the
      closest CRM ancestor of the resource associated with the finding.
    description: The description of the source (max of 1024 characters).
      Example: "Web Security Scanner is a web security scanner for common
      vulnerabilities in App Engine applications. It can automatically scan
      and detect four common vulnerabilities, including cross-site-scripting
      (XSS), Flash injection, mixed content (HTTP in HTTPS), and outdated or
      insecure libraries."
    displayName: The source's display name. A source's display name must be
      unique amongst its siblings, for example, two sources with the same
      parent can't share the same display name. The display name must have a
      length between 1 and 64 characters (inclusive).
    name: The relative resource name of this source. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}"
  """

  canonicalName = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StreamingConfig(_messages.Message):
  r"""The config for streaming-based notifications, which send each event as
  soon as it is detected.

  Fields:
    filter: Expression that defines the filter to apply across create/update
      events of assets or findings as specified by the event type. The
      expression is a list of zero or more restrictions combined via logical
      operators `AND` and `OR`. Parentheses are supported, and `OR` has higher
      precedence than `AND`. Restrictions have the form ` ` and may have a `-`
      character in front of them to indicate negation. The fields map to those
      defined in the corresponding resource. The supported operators are: *
      `=` for all value types. * `>`, `<`, `>=`, `<=` for integer values. *
      `:`, meaning substring matching, for strings. The supported value types
      are: * string literals in quotes. * integer literals without quotes. *
      boolean literals `true` and `false` without quotes.
  """

  filter = _messages.StringField(1)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
