"""Generated client library for recaptchaenterprise version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.recaptchaenterprise.v1 import recaptchaenterprise_v1_messages as messages


class RecaptchaenterpriseV1(base_api.BaseApiClient):
  """Generated client library for service recaptchaenterprise version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://recaptchaenterprise.googleapis.com/'
  MTLS_BASE_URL = 'https://recaptchaenterprise.mtls.googleapis.com/'

  _PACKAGE = 'recaptchaenterprise'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'RecaptchaenterpriseV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new recaptchaenterprise handle."""
    url = url or self.BASE_URL
    super(RecaptchaenterpriseV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_assessments = self.ProjectsAssessmentsService(self)
    self.projects_keys = self.ProjectsKeysService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsAssessmentsService(base_api.BaseApiService):
    """Service class for the projects_assessments resource."""

    _NAME = 'projects_assessments'

    def __init__(self, client):
      super(RecaptchaenterpriseV1.ProjectsAssessmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Annotate(self, request, global_params=None):
      r"""Annotates a previously created Assessment to provide additional information on whether the event turned out to be authentic or fraudulent.

      Args:
        request: (RecaptchaenterpriseProjectsAssessmentsAnnotateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse) The response message.
      """
      config = self.GetMethodConfig('Annotate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Annotate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/assessments/{assessmentsId}:annotate',
        http_method='POST',
        method_id='recaptchaenterprise.projects.assessments.annotate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:annotate',
        request_field='googleCloudRecaptchaenterpriseV1AnnotateAssessmentRequest',
        request_type_name='RecaptchaenterpriseProjectsAssessmentsAnnotateRequest',
        response_type_name='GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates an Assessment of the likelihood an event is legitimate.

      Args:
        request: (RecaptchaenterpriseProjectsAssessmentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Assessment) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/assessments',
        http_method='POST',
        method_id='recaptchaenterprise.projects.assessments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/assessments',
        request_field='googleCloudRecaptchaenterpriseV1Assessment',
        request_type_name='RecaptchaenterpriseProjectsAssessmentsCreateRequest',
        response_type_name='GoogleCloudRecaptchaenterpriseV1Assessment',
        supports_download=False,
    )

  class ProjectsKeysService(base_api.BaseApiService):
    """Service class for the projects_keys resource."""

    _NAME = 'projects_keys'

    def __init__(self, client):
      super(RecaptchaenterpriseV1.ProjectsKeysService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new reCAPTCHA Enterprise key.

      Args:
        request: (RecaptchaenterpriseProjectsKeysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Key) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/keys',
        http_method='POST',
        method_id='recaptchaenterprise.projects.keys.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/keys',
        request_field='googleCloudRecaptchaenterpriseV1Key',
        request_type_name='RecaptchaenterpriseProjectsKeysCreateRequest',
        response_type_name='GoogleCloudRecaptchaenterpriseV1Key',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified key.

      Args:
        request: (RecaptchaenterpriseProjectsKeysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/keys/{keysId}',
        http_method='DELETE',
        method_id='recaptchaenterprise.projects.keys.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='RecaptchaenterpriseProjectsKeysDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified key.

      Args:
        request: (RecaptchaenterpriseProjectsKeysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Key) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/keys/{keysId}',
        http_method='GET',
        method_id='recaptchaenterprise.projects.keys.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='RecaptchaenterpriseProjectsKeysGetRequest',
        response_type_name='GoogleCloudRecaptchaenterpriseV1Key',
        supports_download=False,
    )

    def GetMetrics(self, request, global_params=None):
      r"""Get some aggregated metrics for a Key. This data can be used to build dashboards.

      Args:
        request: (RecaptchaenterpriseProjectsKeysGetMetricsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Metrics) The response message.
      """
      config = self.GetMethodConfig('GetMetrics')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetMetrics.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/keys/{keysId}/metrics',
        http_method='GET',
        method_id='recaptchaenterprise.projects.keys.getMetrics',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='RecaptchaenterpriseProjectsKeysGetMetricsRequest',
        response_type_name='GoogleCloudRecaptchaenterpriseV1Metrics',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of all keys that belong to a project.

      Args:
        request: (RecaptchaenterpriseProjectsKeysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1ListKeysResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/keys',
        http_method='GET',
        method_id='recaptchaenterprise.projects.keys.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/keys',
        request_field='',
        request_type_name='RecaptchaenterpriseProjectsKeysListRequest',
        response_type_name='GoogleCloudRecaptchaenterpriseV1ListKeysResponse',
        supports_download=False,
    )

    def Migrate(self, request, global_params=None):
      r"""Migrates an existing key from reCAPTCHA to reCAPTCHA Enterprise. Once a key is migrated, it can be used from either product. SiteVerify requests will be billed as CreateAssessment calls. You must be authenticated as one of the current owners of the reCAPTCHA Site Key, and your user must have the reCAPTCHA Enterprise Admin IAM role in the destination project.

      Args:
        request: (RecaptchaenterpriseProjectsKeysMigrateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Key) The response message.
      """
      config = self.GetMethodConfig('Migrate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Migrate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/keys/{keysId}:migrate',
        http_method='POST',
        method_id='recaptchaenterprise.projects.keys.migrate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:migrate',
        request_field='googleCloudRecaptchaenterpriseV1MigrateKeyRequest',
        request_type_name='RecaptchaenterpriseProjectsKeysMigrateRequest',
        response_type_name='GoogleCloudRecaptchaenterpriseV1Key',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified key.

      Args:
        request: (RecaptchaenterpriseProjectsKeysPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Key) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/keys/{keysId}',
        http_method='PATCH',
        method_id='recaptchaenterprise.projects.keys.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudRecaptchaenterpriseV1Key',
        request_type_name='RecaptchaenterpriseProjectsKeysPatchRequest',
        response_type_name='GoogleCloudRecaptchaenterpriseV1Key',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(RecaptchaenterpriseV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
