"""Generated message classes for securitycenter version v1beta2.

Security Command Center API provides access to temporal views of assets and
findings within an organization.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'securitycenter'


class Config(_messages.Message):
  r"""Configuration of a module.

  Enums:
    ModuleEnablementStateValueValuesEnum: The state of enablement for the
      module at its level of the resource hierarchy.

  Messages:
    ValueValue: The configuration value for the module. The absence of this
      field implies its inheritance from the parent.

  Fields:
    moduleEnablementState: The state of enablement for the module at its level
      of the resource hierarchy.
    value: The configuration value for the module. The absence of this field
      implies its inheritance from the parent.
  """

  class ModuleEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the module at its level of the resource
    hierarchy.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ValueValue(_messages.Message):
    r"""The configuration value for the module. The absence of this field
    implies its inheritance from the parent.

    Messages:
      AdditionalProperty: An additional property for a ValueValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ValueValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  moduleEnablementState = _messages.EnumField('ModuleEnablementStateValueValuesEnum', 1)
  value = _messages.MessageField('ValueValue', 2)


class ContainerThreatDetectionSettings(_messages.Message):
  r"""Resource capturing the settings for the Container Threat Detection
  service.

  Enums:
    ServiceEnablementStateValueValuesEnum: The state of enablement for the
      service at its level of the resource hierarchy. A DISABLED state will
      override all module enablement_states to DISABLED.

  Messages:
    ModulesValue: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.

  Fields:
    modules: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    serviceAccount: Output only. The service account used by Container Threat
      Detection for scanning. Service accounts are scoped at the project level
      meaning this field will be empty at any level above a project.
    serviceEnablementState: The state of enablement for the service at its
      level of the resource hierarchy. A DISABLED state will override all
      module enablement_states to DISABLED.
    updateTime: Output only. The time the settings were last updated.
  """

  class ServiceEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the service at its level of the resource
    hierarchy. A DISABLED state will override all module enablement_states to
    DISABLED.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ModulesValue(_messages.Message):
    r"""The configurations including the state of enablement for the service's
    different modules. The absence of a module in the map implies its
    configuration is inherited from its parent's.

    Messages:
      AdditionalProperty: An additional property for a ModulesValue object.

    Fields:
      additionalProperties: Additional properties of type ModulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ModulesValue object.

      Fields:
        key: Name of the additional property.
        value: A Config attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Config', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  modules = _messages.MessageField('ModulesValue', 1)
  name = _messages.StringField(2)
  serviceAccount = _messages.StringField(3)
  serviceEnablementState = _messages.EnumField('ServiceEnablementStateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class Details(_messages.Message):
  r"""Details of a subscription.

  Enums:
    TypeValueValuesEnum: The type of subscription

  Fields:
    endTime: The time the subscription has or will end.
    startTime: The time the subscription has or will start.
    type: The type of subscription
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of subscription

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      STANDARD: The standard subscription.
      TRIAL: The trial subscription.
      ALPHA: The alpha subscription.
    """
    TYPE_UNSPECIFIED = 0
    STANDARD = 1
    TRIAL = 2
    ALPHA = 3

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class EventThreatDetectionSettings(_messages.Message):
  r"""Resource capturing the settings for the Event Threat Detection service.

  Enums:
    ServiceEnablementStateValueValuesEnum: The state of enablement for the
      service at its level of the resource hierarchy. A DISABLED state will
      override all module enablement_states to DISABLED.

  Messages:
    ModulesValue: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.

  Fields:
    modules: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.
    name: The resource name of the EventThreatDetectionSettings. Formats: *
      organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
    serviceEnablementState: The state of enablement for the service at its
      level of the resource hierarchy. A DISABLED state will override all
      module enablement_states to DISABLED.
    updateTime: Output only. The time the settings were last updated.
  """

  class ServiceEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the service at its level of the resource
    hierarchy. A DISABLED state will override all module enablement_states to
    DISABLED.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ModulesValue(_messages.Message):
    r"""The configurations including the state of enablement for the service's
    different modules. The absence of a module in the map implies its
    configuration is inherited from its parent's.

    Messages:
      AdditionalProperty: An additional property for a ModulesValue object.

    Fields:
      additionalProperties: Additional properties of type ModulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ModulesValue object.

      Fields:
        key: Name of the additional property.
        value: A Config attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Config', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  modules = _messages.MessageField('ModulesValue', 1)
  name = _messages.StringField(2)
  serviceEnablementState = _messages.EnumField('ServiceEnablementStateValueValuesEnum', 3)
  updateTime = _messages.StringField(4)


class Finding(_messages.Message):
  r"""Security Command Center finding. A finding is a record of assessment
  data like security, risk, health, or privacy, that is ingested into Security
  Command Center for presentation, notification, analysis, policy testing, and
  enforcement. For example, a cross-site scripting (XSS) vulnerability in an
  App Engine application is a finding.

  Enums:
    StateValueValuesEnum: The state of the finding.

  Messages:
    SourcePropertiesValue: Source specific properties. These properties are
      managed by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.

  Fields:
    category: The additional taxonomy group within findings from a given
      source. This field is immutable after creation time. Example:
      "XSS_FLASH_INJECTION"
    createTime: The time at which the finding was created in Security Command
      Center.
    eventTime: The time at which the event took place, or when an update to
      the finding occurred. For example, if the finding represents an open
      firewall it would capture the time the detector believes the firewall
      became open. The accuracy is determined by the detector. If the finding
      were to be resolved afterward, this time would reflect when the finding
      was resolved.
    externalUri: The URI that, if available, points to a web page outside of
      Security Command Center where additional information about the finding
      can be found. This field is guaranteed to be either empty or a well
      formed URL.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      s/{finding_id}"
    parent: The relative resource name of the source the finding belongs to.
      See: https://cloud.google.com/apis/design/resource_names#relative_resour
      ce_name This field is immutable after creation time. For example:
      "organizations/{organization_id}/sources/{source_id}"
    resourceName: For findings on Google Cloud resources, the full resource
      name of the Google Cloud resource this finding is for. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      When the finding is for a non-Google Cloud resource, the resourceName
      can be a customer or partner defined string. This field is immutable
      after creation time.
    securityMarks: Output only. User specified security marks. These marks are
      entirely managed by the user and come from the SecurityMarks resource
      that belongs to the finding.
    sourceProperties: Source specific properties. These properties are managed
      by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.
    state: The state of the finding.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourcePropertiesValue(_messages.Message):
    r"""Source specific properties. These properties are managed by the source
    that writes the finding. The key names in the source_properties map must
    be between 1 and 255 characters, and must start with a letter and contain
    alphanumeric characters or underscores only.

    Messages:
      AdditionalProperty: An additional property for a SourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  category = _messages.StringField(1)
  createTime = _messages.StringField(2)
  eventTime = _messages.StringField(3)
  externalUri = _messages.StringField(4)
  name = _messages.StringField(5)
  parent = _messages.StringField(6)
  resourceName = _messages.StringField(7)
  securityMarks = _messages.MessageField('SecurityMarks', 8)
  sourceProperties = _messages.MessageField('SourcePropertiesValue', 9)
  state = _messages.EnumField('StateValueValuesEnum', 10)


class Folder(_messages.Message):
  r"""Message that contains the resource name and display name of a folder
  resource.

  Fields:
    resourceFolder: Full resource name of this folder. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceFolderDisplayName: The user defined display name for this folder.
  """

  resourceFolder = _messages.StringField(1)
  resourceFolderDisplayName = _messages.StringField(2)


class GoogleCloudSecuritycenterV1NotificationMessage(_messages.Message):
  r"""Cloud SCC's Notification

  Fields:
    finding: If it's a Finding based notification config, this field will be
      populated.
    notificationConfigName: Name of the notification config that generated
      current notification.
    resource: The Cloud resource tied to this notification's Finding.
  """

  finding = _messages.MessageField('Finding', 1)
  notificationConfigName = _messages.StringField(2)
  resource = _messages.MessageField('GoogleCloudSecuritycenterV1Resource', 3)


class GoogleCloudSecuritycenterV1Resource(_messages.Message):
  r"""Information related to the Google Cloud resource.

  Fields:
    folders: Output only. Contains a Folder message for each folder in the
      assets ancestry. The first folder is the deepest nested folder, and the
      last folder is the folder directly under the Organization.
    name: The full resource name of the resource. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    parent: The full resource name of resource's parent.
    parentDisplayName: The human readable name of resource's parent.
    project: The full resource name of project that the resource belongs to.
    projectDisplayName: The human readable name of project that the resource
      belongs to.
  """

  folders = _messages.MessageField('Folder', 1, repeated=True)
  name = _messages.StringField(2)
  parent = _messages.StringField(3)
  parentDisplayName = _messages.StringField(4)
  project = _messages.StringField(5)
  projectDisplayName = _messages.StringField(6)


class GoogleCloudSecuritycenterV1RunAssetDiscoveryResponse(_messages.Message):
  r"""Response of asset discovery run

  Enums:
    StateValueValuesEnum: The state of an asset discovery run.

  Fields:
    duration: The duration between asset discovery run start and end
    state: The state of an asset discovery run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of an asset discovery run.

    Values:
      STATE_UNSPECIFIED: Asset discovery run state was unspecified.
      COMPLETED: Asset discovery run completed successfully.
      SUPERSEDED: Asset discovery run was cancelled with tasks still pending,
        as another run for the same organization was started with a higher
        priority.
      TERMINATED: Asset discovery run was killed and terminated.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUPERSEDED = 2
    TERMINATED = 3

  duration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudSecuritycenterV1beta1RunAssetDiscoveryResponse(_messages.Message):
  r"""Response of asset discovery run

  Enums:
    StateValueValuesEnum: The state of an asset discovery run.

  Fields:
    duration: The duration between asset discovery run start and end
    state: The state of an asset discovery run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of an asset discovery run.

    Values:
      STATE_UNSPECIFIED: Asset discovery run state was unspecified.
      COMPLETED: Asset discovery run completed successfully.
      SUPERSEDED: Asset discovery run was cancelled with tasks still pending,
        as another run for the same organization was started with a higher
        priority.
      TERMINATED: Asset discovery run was killed and terminated.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUPERSEDED = 2
    TERMINATED = 3

  duration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudSecuritycenterV1p1beta1Finding(_messages.Message):
  r"""Security Command Center finding. A finding is a record of assessment
  data (security, risk, health or privacy) ingested into Security Command
  Center for presentation, notification, analysis, policy testing, and
  enforcement. For example, an XSS vulnerability in an App Engine application
  is a finding.

  Enums:
    SeverityValueValuesEnum: The severity of the finding. This field is
      managed by the source that writes the finding.
    StateValueValuesEnum: The state of the finding.

  Messages:
    SourcePropertiesValue: Source specific properties. These properties are
      managed by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.

  Fields:
    category: The additional taxonomy group within findings from a given
      source. This field is immutable after creation time. Example:
      "XSS_FLASH_INJECTION"
    createTime: The time at which the finding was created in Security Command
      Center.
    eventTime: The time at which the event took place, or when an update to
      the finding occurred. For example, if the finding represents an open
      firewall it would capture the time the detector believes the firewall
      became open. The accuracy is determined by the detector. If the finding
      were to be resolved afterward, this time would reflect when the finding
      was resolved.
    externalUri: The URI that, if available, points to a web page outside of
      Security Command Center where additional information about the finding
      can be found. This field is guaranteed to be either empty or a well
      formed URL.
    name: The relative resource name of this finding. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Example: "organizations/{organization_id}/sources/{source_id}/finding
      s/{finding_id}"
    parent: The relative resource name of the source the finding belongs to.
      See: https://cloud.google.com/apis/design/resource_names#relative_resour
      ce_name This field is immutable after creation time. For example:
      "organizations/{organization_id}/sources/{source_id}"
    resourceName: For findings on Google Cloud resources, the full resource
      name of the Google Cloud resource this finding is for. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      When the finding is for a non-Google Cloud resource, the resourceName
      can be a customer or partner defined string. This field is immutable
      after creation time.
    securityMarks: Output only. User specified security marks. These marks are
      entirely managed by the user and come from the SecurityMarks resource
      that belongs to the finding.
    severity: The severity of the finding. This field is managed by the source
      that writes the finding.
    sourceProperties: Source specific properties. These properties are managed
      by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.
    state: The state of the finding.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the finding. This field is managed by the source that
    writes the finding.

    Values:
      SEVERITY_UNSPECIFIED: No severity specified. The default value.
      CRITICAL: Critical severity.
      HIGH: High severity.
      MEDIUM: Medium severity.
      LOW: Low severity.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourcePropertiesValue(_messages.Message):
    r"""Source specific properties. These properties are managed by the source
    that writes the finding. The key names in the source_properties map must
    be between 1 and 255 characters, and must start with a letter and contain
    alphanumeric characters or underscores only.

    Messages:
      AdditionalProperty: An additional property for a SourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  category = _messages.StringField(1)
  createTime = _messages.StringField(2)
  eventTime = _messages.StringField(3)
  externalUri = _messages.StringField(4)
  name = _messages.StringField(5)
  parent = _messages.StringField(6)
  resourceName = _messages.StringField(7)
  securityMarks = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1SecurityMarks', 8)
  severity = _messages.EnumField('SeverityValueValuesEnum', 9)
  sourceProperties = _messages.MessageField('SourcePropertiesValue', 10)
  state = _messages.EnumField('StateValueValuesEnum', 11)


class GoogleCloudSecuritycenterV1p1beta1Folder(_messages.Message):
  r"""Message that contains the resource name and display name of a folder
  resource.

  Fields:
    resourceFolder: Full resource name of this folder. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    resourceFolderDisplayName: The user defined display name for this folder.
  """

  resourceFolder = _messages.StringField(1)
  resourceFolderDisplayName = _messages.StringField(2)


class GoogleCloudSecuritycenterV1p1beta1NotificationMessage(_messages.Message):
  r"""Security Command Center's Notification

  Fields:
    finding: If it's a Finding based notification config, this field will be
      populated.
    notificationConfigName: Name of the notification config that generated
      current notification.
    resource: The Cloud resource tied to the notification.
  """

  finding = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1Finding', 1)
  notificationConfigName = _messages.StringField(2)
  resource = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1Resource', 3)


class GoogleCloudSecuritycenterV1p1beta1Resource(_messages.Message):
  r"""Information related to the Google Cloud resource.

  Fields:
    folders: Output only. Contains a Folder message for each folder in the
      assets ancestry. The first folder is the deepest nested folder, and the
      last folder is the folder directly under the Organization.
    name: The full resource name of the resource. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
    parent: The full resource name of resource's parent.
    parentDisplayName: The human readable name of resource's parent.
    project: The full resource name of project that the resource belongs to.
    projectDisplayName: The human readable name of project that the resource
      belongs to.
  """

  folders = _messages.MessageField('GoogleCloudSecuritycenterV1p1beta1Folder', 1, repeated=True)
  name = _messages.StringField(2)
  parent = _messages.StringField(3)
  parentDisplayName = _messages.StringField(4)
  project = _messages.StringField(5)
  projectDisplayName = _messages.StringField(6)


class GoogleCloudSecuritycenterV1p1beta1RunAssetDiscoveryResponse(_messages.Message):
  r"""Response of asset discovery run

  Enums:
    StateValueValuesEnum: The state of an asset discovery run.

  Fields:
    duration: The duration between asset discovery run start and end
    state: The state of an asset discovery run.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of an asset discovery run.

    Values:
      STATE_UNSPECIFIED: Asset discovery run state was unspecified.
      COMPLETED: Asset discovery run completed successfully.
      SUPERSEDED: Asset discovery run was cancelled with tasks still pending,
        as another run for the same organization was started with a higher
        priority.
      TERMINATED: Asset discovery run was killed and terminated.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUPERSEDED = 2
    TERMINATED = 3

  duration = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudSecuritycenterV1p1beta1SecurityMarks(_messages.Message):
  r"""User specified security marks that are attached to the parent Security
  Command Center resource. Security marks are scoped within a Security Command
  Center organization -- they can be modified and viewed by all users who have
  proper permissions on the organization.

  Messages:
    MarksValue: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)

  Fields:
    marks: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MarksValue(_messages.Message):
    r"""Mutable user specified security marks belonging to the parent
    resource. Constraints are as follows: * Keys and values are treated as
    case insensitive * Keys must be between 1 - 256 characters (inclusive) *
    Keys must be letters, numbers, underscores, or dashes * Values have
    leading and trailing whitespace trimmed, remaining characters must be
    between 1 - 4096 characters (inclusive)

    Messages:
      AdditionalProperty: An additional property for a MarksValue object.

    Fields:
      additionalProperties: Additional properties of type MarksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MarksValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  marks = _messages.MessageField('MarksValue', 1)
  name = _messages.StringField(2)


class SecurityCenterSettings(_messages.Message):
  r"""Resource capturing the settings for Security Center.

  Fields:
    logSinkProject: The resource name of the project to send logs to. This
      project must be part of the organization this resource resides in. The
      format is `projects/{project_id}`. An empty value disables logging. This
      value is only referenced by services that support log sink. Please refer
      to the documentation for an updated list of compatible services.
    name: The resource name of the SecurityCenterSettings. Format:
      organizations/{organization}/securityCenterSettings
    orgServiceAccount: The organization level service account to be used for
      security center components.
  """

  logSinkProject = _messages.StringField(1)
  name = _messages.StringField(2)
  orgServiceAccount = _messages.StringField(3)


class SecurityHealthAnalyticsSettings(_messages.Message):
  r"""Resource capturing the settings for the Security Health Analytics
  service.

  Enums:
    ServiceEnablementStateValueValuesEnum: The state of enablement for the
      service at its level of the resource hierarchy. A DISABLED state will
      override all module enablement_states to DISABLED.

  Messages:
    ModulesValue: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.

  Fields:
    modules: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.
    name: The resource name of the SecurityHealthAnalyticsSettings. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
    serviceAccount: Output only. The service account used by Security Health
      Analytics detectors.
    serviceEnablementState: The state of enablement for the service at its
      level of the resource hierarchy. A DISABLED state will override all
      module enablement_states to DISABLED.
    updateTime: Output only. The time the settings were last updated.
  """

  class ServiceEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the service at its level of the resource
    hierarchy. A DISABLED state will override all module enablement_states to
    DISABLED.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ModulesValue(_messages.Message):
    r"""The configurations including the state of enablement for the service's
    different modules. The absence of a module in the map implies its
    configuration is inherited from its parent's.

    Messages:
      AdditionalProperty: An additional property for a ModulesValue object.

    Fields:
      additionalProperties: Additional properties of type ModulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ModulesValue object.

      Fields:
        key: Name of the additional property.
        value: A Config attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Config', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  modules = _messages.MessageField('ModulesValue', 1)
  name = _messages.StringField(2)
  serviceAccount = _messages.StringField(3)
  serviceEnablementState = _messages.EnumField('ServiceEnablementStateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class SecurityMarks(_messages.Message):
  r"""User specified security marks that are attached to the parent Security
  Command Center resource. Security marks are scoped within a Security Command
  Center organization -- they can be modified and viewed by all users who have
  proper permissions on the organization.

  Messages:
    MarksValue: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)

  Fields:
    marks: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MarksValue(_messages.Message):
    r"""Mutable user specified security marks belonging to the parent
    resource. Constraints are as follows: * Keys and values are treated as
    case insensitive * Keys must be between 1 - 256 characters (inclusive) *
    Keys must be letters, numbers, underscores, or dashes * Values have
    leading and trailing whitespace trimmed, remaining characters must be
    between 1 - 4096 characters (inclusive)

    Messages:
      AdditionalProperty: An additional property for a MarksValue object.

    Fields:
      additionalProperties: Additional properties of type MarksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MarksValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  marks = _messages.MessageField('MarksValue', 1)
  name = _messages.StringField(2)


class SecuritycenterFoldersContainerThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterFoldersContainerThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersEventThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterFoldersEventThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to calculate.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetContainerThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetEventThreatDetectionSettingsRequest object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to retrieve.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetSecurityHealthAnalyticsSettingsRequest object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      retrieve. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersGetWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersGetWebSecurityScannerSettingsRequest object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to retrieve.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersSecurityHealthAnalyticsSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterFoldersSecurityHealthAnalyticsSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      calculate. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterFoldersUpdateContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersUpdateContainerThreatDetectionSettingsRequest
  object.

  Fields:
    containerThreatDetectionSettings: A ContainerThreatDetectionSettings
      resource to be passed as the request body.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    updateMask: The list of fields to be updated.
  """

  containerThreatDetectionSettings = _messages.MessageField('ContainerThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterFoldersUpdateEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersUpdateEventThreatDetectionSettingsRequest object.

  Fields:
    eventThreatDetectionSettings: A EventThreatDetectionSettings resource to
      be passed as the request body.
    name: The resource name of the EventThreatDetectionSettings. Formats: *
      organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
    updateMask: The list of fields to be updated.
  """

  eventThreatDetectionSettings = _messages.MessageField('EventThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterFoldersUpdateSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersUpdateSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: The resource name of the SecurityHealthAnalyticsSettings. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
    securityHealthAnalyticsSettings: A SecurityHealthAnalyticsSettings
      resource to be passed as the request body.
    updateMask: The list of fields to be updated.
  """

  name = _messages.StringField(1, required=True)
  securityHealthAnalyticsSettings = _messages.MessageField('SecurityHealthAnalyticsSettings', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterFoldersUpdateWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterFoldersUpdateWebSecurityScannerSettingsRequest object.

  Fields:
    name: The resource name of the WebSecurityScannerSettings. Formats: *
      organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
    updateMask: The list of fields to be updated.
    webSecurityScannerSettings: A WebSecurityScannerSettings resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  webSecurityScannerSettings = _messages.MessageField('WebSecurityScannerSettings', 3)


class SecuritycenterFoldersWebSecurityScannerSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterFoldersWebSecurityScannerSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to calculate.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsContainerThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsContainerThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsEventThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsEventThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to calculate.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetContainerThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetEventThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to retrieve.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetSecurityCenterSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetSecurityCenterSettingsRequest object.

  Fields:
    name: Required. The name of the SecurityCenterSettings to retrieve.
      Format: organizations/{organization}/securityCenterSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      retrieve. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetSubscriptionRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetSubscriptionRequest object.

  Fields:
    name: Required. The name of the subscription to retrieve. Format:
      organizations/{organization}/subscription
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsGetWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsGetWebSecurityScannerSettingsRequest
  object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to retrieve.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsSecurityHealthAnalyticsSettingsCalculateRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsSecurityHealthAnalyticsSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      calculate. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterOrganizationsUpdateContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsUpdateContainerThreatDetectionSettingsRequest
  object.

  Fields:
    containerThreatDetectionSettings: A ContainerThreatDetectionSettings
      resource to be passed as the request body.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    updateMask: The list of fields to be updated.
  """

  containerThreatDetectionSettings = _messages.MessageField('ContainerThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsUpdateEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsUpdateEventThreatDetectionSettingsRequest
  object.

  Fields:
    eventThreatDetectionSettings: A EventThreatDetectionSettings resource to
      be passed as the request body.
    name: The resource name of the EventThreatDetectionSettings. Formats: *
      organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
    updateMask: The list of fields to be updated.
  """

  eventThreatDetectionSettings = _messages.MessageField('EventThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsUpdateSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A
  SecuritycenterOrganizationsUpdateSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: The resource name of the SecurityHealthAnalyticsSettings. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
    securityHealthAnalyticsSettings: A SecurityHealthAnalyticsSettings
      resource to be passed as the request body.
    updateMask: The list of fields to be updated.
  """

  name = _messages.StringField(1, required=True)
  securityHealthAnalyticsSettings = _messages.MessageField('SecurityHealthAnalyticsSettings', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterOrganizationsUpdateWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsUpdateWebSecurityScannerSettingsRequest
  object.

  Fields:
    name: The resource name of the WebSecurityScannerSettings. Formats: *
      organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
    updateMask: The list of fields to be updated.
    webSecurityScannerSettings: A WebSecurityScannerSettings resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  webSecurityScannerSettings = _messages.MessageField('WebSecurityScannerSettings', 3)


class SecuritycenterOrganizationsWebSecurityScannerSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterOrganizationsWebSecurityScannerSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to calculate.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsContainerThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsContainerThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsEventThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsEventThreatDetectionSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to calculate.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetContainerThreatDetectionSettingsRequest
  object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetEventThreatDetectionSettingsRequest object.

  Fields:
    name: Required. The name of the EventThreatDetectionSettings to retrieve.
      Formats: * organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      retrieve. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsGetWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsGetWebSecurityScannerSettingsRequest object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to retrieve.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsLocationsClustersContainerThreatDetectionSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsLocationsClustersContainerThreatDetectionSetting
  sCalculateRequest object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      calculate. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsLocationsClustersGetContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsLocationsClustersGetContainerThreatDetectionSett
  ingsRequest object.

  Fields:
    name: Required. The name of the ContainerThreatDetectionSettings to
      retrieve. Formats: *
      organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsLocationsClustersUpdateContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsLocationsClustersUpdateContainerThreatDetectionS
  ettingsRequest object.

  Fields:
    containerThreatDetectionSettings: A ContainerThreatDetectionSettings
      resource to be passed as the request body.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    updateMask: The list of fields to be updated.
  """

  containerThreatDetectionSettings = _messages.MessageField('ContainerThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsSecurityHealthAnalyticsSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsSecurityHealthAnalyticsSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the SecurityHealthAnalyticsSettings to
      calculate. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
  """

  name = _messages.StringField(1, required=True)


class SecuritycenterProjectsUpdateContainerThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsUpdateContainerThreatDetectionSettingsRequest
  object.

  Fields:
    containerThreatDetectionSettings: A ContainerThreatDetectionSettings
      resource to be passed as the request body.
    name: The resource name of the ContainerThreatDetectionSettings. Formats:
      * organizations/{organization}/containerThreatDetectionSettings *
      folders/{folder}/containerThreatDetectionSettings *
      projects/{project}/containerThreatDetectionSettings * projects/{project}
      /locations/{location}/clusters/{cluster}/containerThreatDetectionSetting
      s
    updateMask: The list of fields to be updated.
  """

  containerThreatDetectionSettings = _messages.MessageField('ContainerThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsUpdateEventThreatDetectionSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsUpdateEventThreatDetectionSettingsRequest
  object.

  Fields:
    eventThreatDetectionSettings: A EventThreatDetectionSettings resource to
      be passed as the request body.
    name: The resource name of the EventThreatDetectionSettings. Formats: *
      organizations/{organization}/eventThreatDetectionSettings *
      folders/{folder}/eventThreatDetectionSettings *
      projects/{project}/eventThreatDetectionSettings
    updateMask: The list of fields to be updated.
  """

  eventThreatDetectionSettings = _messages.MessageField('EventThreatDetectionSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsUpdateSecurityHealthAnalyticsSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsUpdateSecurityHealthAnalyticsSettingsRequest
  object.

  Fields:
    name: The resource name of the SecurityHealthAnalyticsSettings. Formats: *
      organizations/{organization}/securityHealthAnalyticsSettings *
      folders/{folder}/securityHealthAnalyticsSettings *
      projects/{project}/securityHealthAnalyticsSettings
    securityHealthAnalyticsSettings: A SecurityHealthAnalyticsSettings
      resource to be passed as the request body.
    updateMask: The list of fields to be updated.
  """

  name = _messages.StringField(1, required=True)
  securityHealthAnalyticsSettings = _messages.MessageField('SecurityHealthAnalyticsSettings', 2)
  updateMask = _messages.StringField(3)


class SecuritycenterProjectsUpdateWebSecurityScannerSettingsRequest(_messages.Message):
  r"""A SecuritycenterProjectsUpdateWebSecurityScannerSettingsRequest object.

  Fields:
    name: The resource name of the WebSecurityScannerSettings. Formats: *
      organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
    updateMask: The list of fields to be updated.
    webSecurityScannerSettings: A WebSecurityScannerSettings resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  webSecurityScannerSettings = _messages.MessageField('WebSecurityScannerSettings', 3)


class SecuritycenterProjectsWebSecurityScannerSettingsCalculateRequest(_messages.Message):
  r"""A SecuritycenterProjectsWebSecurityScannerSettingsCalculateRequest
  object.

  Fields:
    name: Required. The name of the WebSecurityScannerSettings to calculate.
      Formats: * organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
  """

  name = _messages.StringField(1, required=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Subscription(_messages.Message):
  r"""Resource capturing the state of an organization's subscription.

  Enums:
    TierValueValuesEnum: The tier of SCC features this organization currently
      has access to.

  Fields:
    details: The details of the most recent active subscription. If there has
      never been a subscription this will be empty.
    name: The resource name of the subscription. Format:
      organizations/{organization}/subscription
    tier: The tier of SCC features this organization currently has access to.
  """

  class TierValueValuesEnum(_messages.Enum):
    r"""The tier of SCC features this organization currently has access to.

    Values:
      TIER_UNSPECIFIED: Default value. This value is unused.
      STANDARD: The standard tier.
      PREMIUM: The premium tier.
    """
    TIER_UNSPECIFIED = 0
    STANDARD = 1
    PREMIUM = 2

  details = _messages.MessageField('Details', 1)
  name = _messages.StringField(2)
  tier = _messages.EnumField('TierValueValuesEnum', 3)


class WebSecurityScannerSettings(_messages.Message):
  r"""Resource capturing the settings for the Web Security Scanner service.

  Enums:
    ServiceEnablementStateValueValuesEnum: The state of enablement for the
      service at its level of the resource hierarchy. A DISABLED state will
      override all module enablement_states to DISABLED.

  Messages:
    ModulesValue: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.

  Fields:
    modules: The configurations including the state of enablement for the
      service's different modules. The absence of a module in the map implies
      its configuration is inherited from its parent's.
    name: The resource name of the WebSecurityScannerSettings. Formats: *
      organizations/{organization}/webSecurityScannerSettings *
      folders/{folder}/webSecurityScannerSettings *
      projects/{project}/webSecurityScannerSettings
    serviceEnablementState: The state of enablement for the service at its
      level of the resource hierarchy. A DISABLED state will override all
      module enablement_states to DISABLED.
    updateTime: Output only. The time the settings were last updated.
  """

  class ServiceEnablementStateValueValuesEnum(_messages.Enum):
    r"""The state of enablement for the service at its level of the resource
    hierarchy. A DISABLED state will override all module enablement_states to
    DISABLED.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      INHERITED: State is inherited from the parent resource.
      ENABLED: State is enabled.
      DISABLED: State is disabled.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    INHERITED = 1
    ENABLED = 2
    DISABLED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ModulesValue(_messages.Message):
    r"""The configurations including the state of enablement for the service's
    different modules. The absence of a module in the map implies its
    configuration is inherited from its parent's.

    Messages:
      AdditionalProperty: An additional property for a ModulesValue object.

    Fields:
      additionalProperties: Additional properties of type ModulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ModulesValue object.

      Fields:
        key: Name of the additional property.
        value: A Config attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Config', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  modules = _messages.MessageField('ModulesValue', 1)
  name = _messages.StringField(2)
  serviceEnablementState = _messages.EnumField('ServiceEnablementStateValueValuesEnum', 3)
  updateTime = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
