"""Generated message classes for run version v1.

Deploy and manage user provided container images that scale automatically
based on HTTP traffic.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'run'


class Addressable(_messages.Message):
  r"""Information for connecting over HTTP(s).

  Fields:
    url: A string attribute.
  """

  url = _messages.StringField(1)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class AuthorizedDomain(_messages.Message):
  r"""A domain that a user has been authorized to administer. To authorize use
  of a domain, verify ownership via [Webmaster
  Central](https://www.google.com/webmasters/verification/home).

  Fields:
    id: Relative name of the domain authorized for use. Example:
      `example.com`.
    name: Deprecated Read only. Full path to the `AuthorizedDomain` resource
      in the API. Example: `projects/myproject/authorizedDomains/example.com`.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    bindingId: A string attribute.
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  bindingId = _messages.StringField(1)
  condition = _messages.MessageField('Expr', 2)
  members = _messages.StringField(3, repeated=True)
  role = _messages.StringField(4)


class ConfigMapEnvSource(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  ConfigMapEnvSource selects a ConfigMap to populate the environment variables
  with. The contents of the target ConfigMap's Data field will represent the
  key-value pairs as environment variables.

  Fields:
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The ConfigMap to select from.
    optional: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Specify whether the ConfigMap must be defined
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  name = _messages.StringField(2)
  optional = _messages.BooleanField(3)


class ConfigMapKeySelector(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  Selects a key from a ConfigMap.

  Fields:
    key: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The key to select.
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The ConfigMap to select from.
    optional: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Specify whether the ConfigMap or its key must be
      defined
  """

  key = _messages.StringField(1)
  localObjectReference = _messages.MessageField('LocalObjectReference', 2)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class ConfigMapVolumeSource(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  Adapts a ConfigMap into a volume. The contents of the target ConfigMap's
  Data field will be presented in a volume as files using the keys in the Data
  field as the file names, unless the items element is populated with specific
  mappings of keys to paths.

  Fields:
    defaultMode: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported Mode bits to use on created files by default. Must
      be a value between 0 and 0777. Defaults to 0644. Directories within the
      path are not affected by this setting. This might be in conflict with
      other options that affect the file mode, like fsGroup, and the result
      can be other mode bits set.
    items: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported If unspecified, each key-value pair in the Data field
      of the referenced Secret will be projected into the volume as a file
      whose name is the key and content is the value. If specified, the listed
      keys will be projected into the specified paths, and unlisted keys will
      not be present. If a key is specified which is not present in the
      Secret, the volume setup will error unless it is marked optional.
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported Name of the config.
    optional: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Specify whether the Secret or its keys must be
      defined.
  """

  defaultMode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  items = _messages.MessageField('KeyToPath', 2, repeated=True)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class Configuration(_messages.Message):
  r"""Configuration represents the "floating HEAD" of a linear history of
  Revisions, and optionally how the containers those revisions reference are
  built. Users create new Revisions by updating the Configuration's spec. The
  "latest created" revision's name is available under status, as is the
  "latest ready" revision's name. See also: https://github.com/knative/serving
  /blob/master/docs/spec/overview.md#configuration

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1".
    kind: The kind of resource, in this case always "Configuration".
    metadata: Metadata associated with this Configuration, including name,
      namespace, labels, and annotations.
    spec: Spec holds the desired state of the Configuration (from the client).
    status: Status communicates the observed state of the Configuration (from
      the controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('ConfigurationSpec', 4)
  status = _messages.MessageField('ConfigurationStatus', 5)


class ConfigurationSpec(_messages.Message):
  r"""ConfigurationSpec holds the desired state of the Configuration (from the
  client).

  Fields:
    template: Template holds the latest specification for the Revision to be
      stamped out.
  """

  template = _messages.MessageField('RevisionTemplate', 1)


class ConfigurationStatus(_messages.Message):
  r"""ConfigurationStatus communicates the observed state of the Configuration
  (from the controller).

  Fields:
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world.
    latestCreatedRevisionName: LatestCreatedRevisionName is the last revision
      that was created from this Configuration. It might not be ready yet, for
      that use LatestReadyRevisionName.
    latestReadyRevisionName: LatestReadyRevisionName holds the name of the
      latest Revision stamped out from this Configuration that has had its
      "Ready" condition become "True".
    observedGeneration: ObservedGeneration is the 'Generation' of the
      Configuration that was last processed by the controller. The observed
      generation is updated even if the controller failed to process the spec
      and create the Revision. Clients polling for completed reconciliation
      should poll until observedGeneration = metadata.generation, and the
      Ready condition's status is True or False.
  """

  conditions = _messages.MessageField('GoogleCloudRunV1Condition', 1, repeated=True)
  latestCreatedRevisionName = _messages.StringField(2)
  latestReadyRevisionName = _messages.StringField(3)
  observedGeneration = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Container(_messages.Message):
  r"""A single application container. This specifies both the container to
  run, the command to run in the container and the arguments to supply to it.
  Note that additional arguments may be supplied by the system to the
  container at runtime.

  Fields:
    args: (Optional) Cloud Run fully managed: supported Cloud Run for Anthos:
      supported Arguments to the entrypoint. The docker image's CMD is used if
      this is not provided. Variable references $(VAR_NAME) are expanded using
      the container's environment. If a variable cannot be resolved, the
      reference in the input string will be unchanged. The $(VAR_NAME) syntax
      can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references
      will never be expanded, regardless of whether the variable exists or
      not. More info: https://kubernetes.io/docs/tasks/inject-data-
      application/define-command-argument-container/#running-a-command-in-a-
      shell
    command: A string attribute.
    env: (Optional) Cloud Run fully managed: supported Cloud Run for Anthos:
      supported List of environment variables to set in the container.
    envFrom: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported List of sources to populate environment variables in
      the container. The keys defined within a source must be a C_IDENTIFIER.
      All invalid keys will be reported as an event when the container is
      starting. When a key exists in multiple sources, the value associated
      with the last source will take precedence. Values defined by an Env with
      a duplicate key will take precedence. Cannot be updated.
    image: Cloud Run fully managed: only supports containers from Google
      Container Registry Cloud Run for Anthos: supported URL of the Container
      image. More info: https://kubernetes.io/docs/concepts/containers/images
    imagePullPolicy: (Optional) Cloud Run fully managed: not supported Cloud
      Run for Anthos: supported Image pull policy. One of Always, Never,
      IfNotPresent. Defaults to Always if :latest tag is specified, or
      IfNotPresent otherwise. More info:
      https://kubernetes.io/docs/concepts/containers/images#updating-images
    livenessProbe: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported Periodic probe of container liveness. Container
      will be restarted if the probe fails. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes
    name: (Optional) Name of the container specified as a DNS_LABEL.
    ports: (Optional) List of ports to expose from the container. Only a
      single port can be specified. The specified ports must be listening on
      all interfaces (0.0.0.0) within the container to be accessible. If
      omitted, a port number will be chosen and passed to the container
      through the PORT environment variable for the container to listen on.
    readinessProbe: (Optional) Cloud Run fully managed: not supported Cloud
      Run for Anthos: supported Periodic probe of container service readiness.
      Container will be removed from service endpoints if the probe fails.
      More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes
    resources: (Optional) Cloud Run fully managed: supported Cloud Run for
      Anthos: supported Compute Resources required by this container. More
      info: https://kubernetes.io/docs/concepts/storage/persistent-
      volumes#resources
    securityContext: (Optional) Cloud Run fully managed: not supported Cloud
      Run for Anthos: supported Security options the pod should run with. More
      info: https://kubernetes.io/docs/concepts/policy/security-context/ More
      info: https://kubernetes.io/docs/tasks/configure-pod-container/security-
      context/
    terminationMessagePath: (Optional) Cloud Run fully managed: not supported
      Cloud Run for Anthos: supported Path at which the file to which the
      container's termination message will be written is mounted into the
      container's filesystem. Message written is intended to be brief final
      status, such as an assertion failure message. Will be truncated by the
      node if greater than 4096 bytes. The total message length across all
      containers will be limited to 12kb. Defaults to /dev/termination-log.
    terminationMessagePolicy: (Optional) Cloud Run fully managed: not
      supported Cloud Run for Anthos: supported Indicate how the termination
      message should be populated. File will use the contents of
      terminationMessagePath to populate the container status message on both
      success and failure. FallbackToLogsOnError will use the last chunk of
      container log output if the termination message file is empty and the
      container exited with an error. The log output is limited to 2048 bytes
      or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
    volumeMounts: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported Pod volumes to mount into the container's
      filesystem.
    workingDir: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported Container's working directory. If not specified,
      the container runtime's default will be used, which might be configured
      in the container image.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('EnvVar', 3, repeated=True)
  envFrom = _messages.MessageField('EnvFromSource', 4, repeated=True)
  image = _messages.StringField(5)
  imagePullPolicy = _messages.StringField(6)
  livenessProbe = _messages.MessageField('Probe', 7)
  name = _messages.StringField(8)
  ports = _messages.MessageField('ContainerPort', 9, repeated=True)
  readinessProbe = _messages.MessageField('Probe', 10)
  resources = _messages.MessageField('ResourceRequirements', 11)
  securityContext = _messages.MessageField('SecurityContext', 12)
  terminationMessagePath = _messages.StringField(13)
  terminationMessagePolicy = _messages.StringField(14)
  volumeMounts = _messages.MessageField('VolumeMount', 15, repeated=True)
  workingDir = _messages.StringField(16)


class ContainerPort(_messages.Message):
  r"""ContainerPort represents a network port in a single container.

  Fields:
    containerPort: (Optional) Port number the container listens on. This must
      be a valid port number, 0 < x < 65536.
    name: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported If specified, used to specify which protocol to use.
      Allowed values are "http1" and "h2c".
    protocol: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Protocol for port. Must be "TCP". Defaults to "TCP".
  """

  containerPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  name = _messages.StringField(2)
  protocol = _messages.StringField(3)


class DomainMapping(_messages.Message):
  r"""Resource to hold the state and status of a user's domain mapping.

  Fields:
    apiVersion: The API version for this call such as
      "domains.cloudrun.com/v1".
    kind: The kind of resource, in this case "DomainMapping".
    metadata: Metadata associated with this BuildTemplate.
    spec: The spec for this DomainMapping.
    status: The current status of the DomainMapping.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('DomainMappingSpec', 4)
  status = _messages.MessageField('DomainMappingStatus', 5)


class DomainMappingSpec(_messages.Message):
  r"""The desired state of the Domain Mapping.

  Enums:
    CertificateModeValueValuesEnum: The mode of the certificate.

  Fields:
    certificateMode: The mode of the certificate.
    forceOverride: If set, the mapping will override any mapping set before
      this spec was set. It is recommended that the user leaves this empty to
      receive an error warning about a potential conflict and only set it once
      the respective UI has given such a warning.
    routeName: The name of the Knative Route that this DomainMapping applies
      to. The route must exist.
  """

  class CertificateModeValueValuesEnum(_messages.Enum):
    r"""The mode of the certificate.

    Values:
      CERTIFICATE_MODE_UNSPECIFIED: <no description>
      NONE: Do not provision an HTTPS certificate.
      AUTOMATIC: Automatically provisions an HTTPS certificate via GoogleCA or
        LetsEncrypt.
    """
    CERTIFICATE_MODE_UNSPECIFIED = 0
    NONE = 1
    AUTOMATIC = 2

  certificateMode = _messages.EnumField('CertificateModeValueValuesEnum', 1)
  forceOverride = _messages.BooleanField(2)
  routeName = _messages.StringField(3)


class DomainMappingStatus(_messages.Message):
  r"""The current state of the Domain Mapping.

  Fields:
    conditions: Array of observed DomainMappingConditions, indicating the
      current state of the DomainMapping.
    mappedRouteName: The name of the route that the mapping currently points
      to.
    observedGeneration: ObservedGeneration is the 'Generation' of the
      DomainMapping that was last processed by the controller. Clients polling
      for completed reconciliation should poll until observedGeneration =
      metadata.generation and the Ready condition's status is True or False.
    resourceRecords: The resource records required to configure this domain
      mapping. These records must be added to the domain's DNS configuration
      in order to serve the application via this domain mapping.
    url: Cloud Run fully managed: not supported Cloud Run on GKE: supported
      Holds the URL that will serve the traffic of the DomainMapping.
      +optional
  """

  conditions = _messages.MessageField('GoogleCloudRunV1Condition', 1, repeated=True)
  mappedRouteName = _messages.StringField(2)
  observedGeneration = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourceRecords = _messages.MessageField('ResourceRecord', 4, repeated=True)
  url = _messages.StringField(5)


class EnvFromSource(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  EnvFromSource represents the source of a set of ConfigMaps

  Fields:
    configMapRef: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported The ConfigMap to select from
    prefix: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported An optional identifier to prepend to each key in the
      ConfigMap. Must be a C_IDENTIFIER.
    secretRef: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported The Secret to select from
  """

  configMapRef = _messages.MessageField('ConfigMapEnvSource', 1)
  prefix = _messages.StringField(2)
  secretRef = _messages.MessageField('SecretEnvSource', 3)


class EnvVar(_messages.Message):
  r"""EnvVar represents an environment variable present in a Container.

  Fields:
    name: Name of the environment variable. Must be a C_IDENTIFIER.
    value: (Optional) Variable references $(VAR_NAME) are expanded using the
      previous defined environment variables in the container and any route
      environment variables. If a variable cannot be resolved, the reference
      in the input string will be unchanged. The $(VAR_NAME) syntax can be
      escaped with a double $$, ie: $$(VAR_NAME). Escaped references will
      never be expanded, regardless of whether the variable exists or not.
      Defaults to "".
    valueFrom: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Source for the environment variable's value. Cannot be
      used if value is not empty.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)
  valueFrom = _messages.MessageField('EnvVarSource', 3)


class EnvVarSource(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  EnvVarSource represents a source for the value of an EnvVar.

  Fields:
    configMapKeyRef: (Optional) Cloud Run fully managed: not supported Cloud
      Run for Anthos: supported Selects a key of a ConfigMap.
    secretKeyRef: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported Selects a key of a secret in the pod's namespace
  """

  configMapKeyRef = _messages.MessageField('ConfigMapKeySelector', 1)
  secretKeyRef = _messages.MessageField('SecretKeySelector', 2)


class ExecAction(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  ExecAction describes a "run in container" action.

  Fields:
    command: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Command is the command line to execute inside the
      container, the working directory for the command is root ('/') in the
      container's filesystem. The command is simply exec'd, it is not run
      inside a shell, so traditional shell instructions ('|', etc) won't work.
      To use a shell, you need to explicitly call out to that shell. Exit
      status of 0 is treated as live/healthy and non-zero is unhealthy.
  """

  command = _messages.StringField(1, repeated=True)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GoogleCloudRunV1Condition(_messages.Message):
  r"""Condition defines a generic condition for a Resource

  Fields:
    lastTransitionTime: Optional. Last time the condition transitioned from
      one status to another.
    message: Optional. Human readable message indicating details about the
      current status.
    reason: Optional. One-word CamelCase reason for the condition's last
      transition.
    severity: Optional. How to interpret failures of this condition, one of
      Error, Warning, Info
    status: Status of the condition, one of True, False, Unknown.
    type: type is used to communicate the status of the reconciliation
      process. See also: https://github.com/knative/serving/blob/master/docs/s
      pec/errors.md#error-conditions-and-reporting Types common to all
      resources include: * "Ready": True when the Resource is ready.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class HTTPGetAction(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  HTTPGetAction describes an action based on HTTP Get requests.

  Fields:
    host: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Host name to connect to, defaults to the pod IP. You
      probably want to set "Host" in httpHeaders instead.
    httpHeaders: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported Custom headers to set in the request. HTTP allows
      repeated headers.
    path: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Path to access on the HTTP server.
    scheme: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Scheme to use for connecting to the host. Defaults to
      HTTP.
  """

  host = _messages.StringField(1)
  httpHeaders = _messages.MessageField('HTTPHeader', 2, repeated=True)
  path = _messages.StringField(3)
  scheme = _messages.StringField(4)


class HTTPHeader(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  HTTPHeader describes a custom header to be used in HTTP probes

  Fields:
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The header field name
    value: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The header field value
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class KeyToPath(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  Maps a string key to a path within a volume.

  Fields:
    key: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The key to project.
    mode: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Mode bits to use on this file, must be a value between
      0000 and 0777. If not specified, the volume defaultMode will be used.
      This might be in conflict with other options that affect the file mode,
      like fsGroup, and the result can be other mode bits set.
    path: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The relative path of the file to map the key to. May not be an
      absolute path. May not contain the path element '..'. May not start with
      the string '..'.
  """

  key = _messages.StringField(1)
  mode = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  path = _messages.StringField(3)


class ListAuthorizedDomainsResponse(_messages.Message):
  r"""A list of Authorized Domains.

  Fields:
    domains: The authorized domains belonging to the user.
    nextPageToken: Continuation token for fetching the next page of results.
  """

  domains = _messages.MessageField('AuthorizedDomain', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListConfigurationsResponse(_messages.Message):
  r"""ListConfigurationsResponse is a list of Configuration resources.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1".
    items: List of Configurations.
    kind: The kind of this resource, in this case "ConfigurationList".
    metadata: Metadata associated with this Configuration list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Configuration', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListDomainMappingsResponse(_messages.Message):
  r"""ListDomainMappingsResponse is a list of DomainMapping resources.

  Fields:
    apiVersion: The API version for this call such as
      "domains.cloudrun.com/v1".
    items: List of DomainMappings.
    kind: The kind of this resource, in this case "DomainMappingList".
    metadata: Metadata associated with this DomainMapping list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('DomainMapping', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMeta(_messages.Message):
  r"""ListMeta describes metadata that synthetic resources must have,
  including lists and various status objects. A resource may have only one of
  {ObjectMeta, ListMeta}.

  Fields:
    continue_: continue may be set if the user set a limit on the number of
      items returned, and indicates that the server has more data available.
      The value is opaque and may be used to issue another request to the
      endpoint that served this list to retrieve the next set of available
      objects. Continuing a list may not be possible if the server
      configuration has changed or more than a few minutes have passed. The
      resourceVersion field returned when using this continue value will be
      identical to the value in the first response.
    resourceVersion: String that identifies the server's internal version of
      this object that can be used by clients to determine when objects have
      changed. Value must be treated as opaque by clients and passed
      unmodified back to the server. Populated by the system. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional
  """

  continue_ = _messages.StringField(1)
  resourceVersion = _messages.StringField(2)
  selfLink = _messages.StringField(3)


class ListRevisionsResponse(_messages.Message):
  r"""ListRevisionsResponse is a list of Revision resources.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1".
    items: List of Revisions.
    kind: The kind of this resource, in this case "RevisionList".
    metadata: Metadata associated with this revision list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Revision', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListRoutesResponse(_messages.Message):
  r"""ListRoutesResponse is a list of Route resources.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1".
    items: List of Routes.
    kind: The kind of this resource, in this case always "RouteList".
    metadata: Metadata associated with this Route list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Route', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListServicesResponse(_messages.Message):
  r"""A list of Service resources.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1".
    items: List of Services.
    kind: The kind of this resource, in this case "ServiceList".
    metadata: Metadata associated with this Service list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Service', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class LocalObjectReference(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  LocalObjectReference contains enough information to let you locate the
  referenced object inside the same namespace.

  Fields:
    name: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Name of the referent. More info:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/#names
  """

  name = _messages.StringField(1)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Namespace(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run on GKE: supported
  Namespace provides a scope for Names. Use of multiple namespaces is
  optional.

  Fields:
    metadata: Standard object's metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    spec: Spec defines the behavior of the Namespace. More info:
      https://git.k8s.io/community/contributors/devel/sig-architecture/api-
      conventions.md#spec-and-status
    status: Status describes the current status of a Namespace. More info:
      https://git.k8s.io/community/contributors/devel/sig-architecture/api-
      conventions.md#spec-and-status
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  spec = _messages.MessageField('NamespaceSpec', 2)
  status = _messages.MessageField('NamespaceStatus', 3)


class NamespaceSpec(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run on GKE: supported
  NamespaceSpec describes the attributes on a Namespace.

  Fields:
    finalizers: Finalizers is an opaque list of values that must be empty to
      permanently remove object from storage. More info:
      https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
  """

  finalizers = _messages.StringField(1, repeated=True)


class NamespaceStatus(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run on GKE: supported
  NamespaceStatus is information about the current status of a Namespace.

  Fields:
    phase: Phase is the current lifecycle phase of the namespace. More info:
      https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
  """

  phase = _messages.StringField(1)


class ObjectMeta(_messages.Message):
  r"""k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta is metadata that all
  persisted resources must have, which includes all objects users must create.

  Messages:
    AnnotationsValue: (Optional) Annotations is an unstructured key value map
      stored with a resource that may be set by external tools to store and
      retrieve arbitrary metadata. They are not queryable and should be
      preserved when modifying objects. More info:
      http://kubernetes.io/docs/user-guide/annotations
    LabelsValue: (Optional) Map of string keys and values that can be used to
      organize and categorize (scope and select) objects. May match selectors
      of replication controllers and routes. More info:
      http://kubernetes.io/docs/user-guide/labels

  Fields:
    annotations: (Optional) Annotations is an unstructured key value map
      stored with a resource that may be set by external tools to store and
      retrieve arbitrary metadata. They are not queryable and should be
      preserved when modifying objects. More info:
      http://kubernetes.io/docs/user-guide/annotations
    clusterName: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported The name of the cluster which the object belongs
      to. This is used to distinguish resources with same name and namespace
      in different clusters. This field is not set anywhere right now and
      apiserver is going to ignore it if set in create or update request.
    creationTimestamp: (Optional) CreationTimestamp is a timestamp
      representing the server time when this object was created. It is not
      guaranteed to be set in happens-before order across separate operations.
      Clients may not set this value. It is represented in RFC3339 form and is
      in UTC. Populated by the system. Read-only. Null for lists. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    deletionGracePeriodSeconds: (Optional) Cloud Run fully managed: not
      supported Cloud Run for Anthos: supported Number of seconds allowed for
      this object to gracefully terminate before it will be removed from the
      system. Only set when deletionTimestamp is also set. May only be
      shortened. Read-only.
    deletionTimestamp: (Optional) Cloud Run fully managed: not supported Cloud
      Run for Anthos: supported DeletionTimestamp is RFC 3339 date and time at
      which this resource will be deleted. This field is set by the server
      when a graceful deletion is requested by the user, and is not directly
      settable by a client. The resource is expected to be deleted (no longer
      visible from resource lists, and not reachable by name) after the time
      in this field, once the finalizers list is empty. As long as the
      finalizers list contains items, deletion is blocked. Once the
      deletionTimestamp is set, this value may not be unset or be set further
      into the future, although it may be shortened or the resource may be
      deleted prior to this time. For example, a user may request that a pod
      is deleted in 30 seconds. The Kubelet will react by sending a graceful
      termination signal to the containers in the pod. After that 30 seconds,
      the Kubelet will send a hard termination signal (SIGKILL) to the
      container and after cleanup, remove the pod from the API. In the
      presence of network partitions, this object may still exist after this
      timestamp, until an administrator or automated process can determine the
      resource is fully terminated. If not set, graceful deletion of the
      object has not been requested. Populated by the system when a graceful
      deletion is requested. Read-only. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    finalizers: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported Must be empty before the object is deleted from
      the registry. Each entry is an identifier for the responsible component
      that will remove the entry from the list. If the deletionTimestamp of
      the object is non-nil, entries in this list can only be removed.
      +patchStrategy=merge
    generateName: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported GenerateName is an optional prefix, used by the
      server, to generate a unique name ONLY IF the Name field has not been
      provided. If this field is used, the name returned to the client will be
      different than the name passed. This value will also be combined with a
      unique suffix. The provided value has the same validation rules as the
      Name field, and may be truncated by the length of the suffix required to
      make the value unique on the server. If this field is specified and the
      generated name exists, the server will NOT return a 409 - instead, it
      will either return 201 Created or 500 with Reason ServerTimeout
      indicating a unique name could not be found in the time allotted, and
      the client should retry (optionally after the time indicated in the
      Retry-After header). Applied only if Name is not specified. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#idempotency string generateName = 2;
    generation: (Optional) A sequence number representing a specific
      generation of the desired state. Populated by the system. Read-only.
    labels: (Optional) Map of string keys and values that can be used to
      organize and categorize (scope and select) objects. May match selectors
      of replication controllers and routes. More info:
      http://kubernetes.io/docs/user-guide/labels
    name: Name must be unique within a namespace, within a Cloud Run region.
      Is required when creating resources, although some resources may allow a
      client to request the generation of an appropriate name automatically.
      Name is primarily intended for creation idempotence and configuration
      definition. Cannot be updated. More info:
      http://kubernetes.io/docs/user-guide/identifiers#names +optional
    namespace: Namespace defines the space within each name must be unique,
      within a Cloud Run region. In Cloud Run the namespace must be equal to
      either the project ID or project number.
    ownerReferences: (Optional) Cloud Run fully managed: not supported Cloud
      Run for Anthos: supported List of objects that own this object. If ALL
      objects in the list have been deleted, this object will be garbage
      collected.
    resourceVersion: (Optional) An opaque value that represents the internal
      version of this object that can be used by clients to determine when
      objects have changed. May be used for optimistic concurrency, change
      detection, and the watch operation on a resource or set of resources.
      Clients must treat these values as opaque and passed unmodified back to
      the server. They may only be valid for a particular resource or set of
      resources. Populated by the system. Read-only. Value must be treated as
      opaque by clients. More info:
      https://git.k8s.io/community/contributors/devel/sig-architecture/api-
      conventions.md#concurrency-control-and-consistency
    selfLink: (Optional) SelfLink is a URL representing this object. Populated
      by the system. Read-only. string selfLink = 4;
    uid: (Optional) UID is the unique in time and space value for this object.
      It is typically generated by the server on successful creation of a
      resource and is not allowed to change on PUT operations. Populated by
      the system. Read-only. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""(Optional) Annotations is an unstructured key value map stored with a
    resource that may be set by external tools to store and retrieve arbitrary
    metadata. They are not queryable and should be preserved when modifying
    objects. More info: http://kubernetes.io/docs/user-guide/annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""(Optional) Map of string keys and values that can be used to organize
    and categorize (scope and select) objects. May match selectors of
    replication controllers and routes. More info:
    http://kubernetes.io/docs/user-guide/labels

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  clusterName = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  deletionGracePeriodSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  deletionTimestamp = _messages.StringField(5)
  finalizers = _messages.StringField(6, repeated=True)
  generateName = _messages.StringField(7)
  generation = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 9)
  name = _messages.StringField(10)
  namespace = _messages.StringField(11)
  ownerReferences = _messages.MessageField('OwnerReference', 12, repeated=True)
  resourceVersion = _messages.StringField(13)
  selfLink = _messages.StringField(14)
  uid = _messages.StringField(15)


class OwnerReference(_messages.Message):
  r"""OwnerReference contains enough information to let you identify an owning
  object. Currently, an owning object must be in the same namespace, so there
  is no namespace field.

  Fields:
    apiVersion: API version of the referent.
    blockOwnerDeletion: If true, AND if the owner has the "foregroundDeletion"
      finalizer, then the owner cannot be deleted from the key-value store
      until this reference is removed. Defaults to false. To set this field, a
      user needs "delete" permission of the owner, otherwise 422
      (Unprocessable Entity) will be returned. +optional
    controller: If true, this reference points to the managing controller.
      +optional
    kind: Kind of the referent. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#types-kinds
    name: Name of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#names
    uid: UID of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  apiVersion = _messages.StringField(1)
  blockOwnerDeletion = _messages.BooleanField(2)
  controller = _messages.BooleanField(3)
  kind = _messages.StringField(4)
  name = _messages.StringField(5)
  uid = _messages.StringField(6)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Probe(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  Probe describes a health check to be performed against a container to
  determine whether it is alive or ready to receive traffic.

  Fields:
    exec_: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported One and only one of the following should be specified.
      Exec specifies the action to take. A field inlined from the Handler
      message.
    failureThreshold: (Optional) Cloud Run fully managed: not supported Cloud
      Run for Anthos: supported Minimum consecutive failures for the probe to
      be considered failed after having succeeded. Defaults to 3. Minimum
      value is 1.
    httpGet: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported HTTPGet specifies the http request to perform. A field
      inlined from the Handler message.
    initialDelaySeconds: (Optional) Cloud Run fully managed: not supported
      Cloud Run for Anthos: supported Number of seconds after the container
      has started before liveness probes are initiated. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes
    periodSeconds: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported How often (in seconds) to perform the probe.
      Default to 10 seconds. Minimum value is 1.
    successThreshold: (Optional) Cloud Run fully managed: not supported Cloud
      Run for Anthos: supported Minimum consecutive successes for the probe to
      be considered successful after having failed. Defaults to 1. Must be 1
      for liveness. Minimum value is 1.
    tcpSocket: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported TCPSocket specifies an action involving a TCP port.
      TCP hooks not yet supported A field inlined from the Handler message.
    timeoutSeconds: (Optional) Cloud Run fully managed: not supported Cloud
      Run for Anthos: supported Number of seconds after which the probe times
      out. Defaults to 1 second. Minimum value is 1. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes
  """

  exec_ = _messages.MessageField('ExecAction', 1)
  failureThreshold = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  httpGet = _messages.MessageField('HTTPGetAction', 3)
  initialDelaySeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  periodSeconds = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  successThreshold = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  tcpSocket = _messages.MessageField('TCPSocketAction', 7)
  timeoutSeconds = _messages.IntegerField(8, variant=_messages.Variant.INT32)


class ResourceRecord(_messages.Message):
  r"""A DNS resource record.

  Enums:
    TypeValueValuesEnum: Resource record type. Example: `AAAA`.

  Fields:
    name: Relative name of the object affected by this record. Only applicable
      for `CNAME` records. Example: 'www'.
    rrdata: Data for this record. Values vary by record type, as defined in
      RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
    type: Resource record type. Example: `AAAA`.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Resource record type. Example: `AAAA`.

    Values:
      RECORD_TYPE_UNSPECIFIED: An unknown resource record.
      A: An A resource record. Data is an IPv4 address.
      AAAA: An AAAA resource record. Data is an IPv6 address.
      CNAME: A CNAME resource record. Data is a domain name to be aliased.
    """
    RECORD_TYPE_UNSPECIFIED = 0
    A = 1
    AAAA = 2
    CNAME = 3

  name = _messages.StringField(1)
  rrdata = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class ResourceRequirements(_messages.Message):
  r"""ResourceRequirements describes the compute resource requirements.

  Messages:
    LimitsValue: (Optional) Cloud Run fully managed: Only memory and CPU are
      supported. Note: The only supported values for CPU are '1', '2', and
      '4'. Setting 4 CPU requires at least 2Gi of memory. Cloud Run for
      Anthos: supported Limits describes the maximum amount of compute
      resources allowed. The values of the map is string form of the
      'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/maste
      r/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    RequestsValue: (Optional) Cloud Run fully managed: Only memory and CPU are
      supported. Note: The only supported values for CPU are '1' and '2'.
      Cloud Run for Anthos: supported Requests describes the minimum amount of
      compute resources required. If Requests is omitted for a container, it
      defaults to Limits if that is explicitly specified, otherwise to an
      implementation-defined value. The values of the map is string form of
      the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/m
      aster/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go

  Fields:
    limits: (Optional) Cloud Run fully managed: Only memory and CPU are
      supported. Note: The only supported values for CPU are '1', '2', and
      '4'. Setting 4 CPU requires at least 2Gi of memory. Cloud Run for
      Anthos: supported Limits describes the maximum amount of compute
      resources allowed. The values of the map is string form of the
      'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/maste
      r/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    requests: (Optional) Cloud Run fully managed: Only memory and CPU are
      supported. Note: The only supported values for CPU are '1' and '2'.
      Cloud Run for Anthos: supported Requests describes the minimum amount of
      compute resources required. If Requests is omitted for a container, it
      defaults to Limits if that is explicitly specified, otherwise to an
      implementation-defined value. The values of the map is string form of
      the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/m
      aster/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LimitsValue(_messages.Message):
    r"""(Optional) Cloud Run fully managed: Only memory and CPU are supported.
    Note: The only supported values for CPU are '1', '2', and '4'. Setting 4
    CPU requires at least 2Gi of memory. Cloud Run for Anthos: supported
    Limits describes the maximum amount of compute resources allowed. The
    values of the map is string form of the 'quantity' k8s type: https://githu
    b.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pk
    g/api/resource/quantity.go

    Messages:
      AdditionalProperty: An additional property for a LimitsValue object.

    Fields:
      additionalProperties: Additional properties of type LimitsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LimitsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestsValue(_messages.Message):
    r"""(Optional) Cloud Run fully managed: Only memory and CPU are supported.
    Note: The only supported values for CPU are '1' and '2'. Cloud Run for
    Anthos: supported Requests describes the minimum amount of compute
    resources required. If Requests is omitted for a container, it defaults to
    Limits if that is explicitly specified, otherwise to an implementation-
    defined value. The values of the map is string form of the 'quantity' k8s
    type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s
    .io/apimachinery/pkg/api/resource/quantity.go

    Messages:
      AdditionalProperty: An additional property for a RequestsValue object.

    Fields:
      additionalProperties: Additional properties of type RequestsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  limits = _messages.MessageField('LimitsValue', 1)
  requests = _messages.MessageField('RequestsValue', 2)


class Revision(_messages.Message):
  r"""Revision is an immutable snapshot of code and configuration. A revision
  references a container image. Revisions are created by updates to a
  Configuration. See also: https://github.com/knative/serving/blob/master/docs
  /spec/overview.md#revision

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1".
    kind: The kind of this resource, in this case "Revision".
    metadata: Metadata associated with this Revision, including name,
      namespace, labels, and annotations.
    spec: Spec holds the desired state of the Revision (from the client).
    status: Status communicates the observed state of the Revision (from the
      controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('RevisionSpec', 4)
  status = _messages.MessageField('RevisionStatus', 5)


class RevisionSpec(_messages.Message):
  r"""RevisionSpec holds the desired state of the Revision (from the client).

  Fields:
    containerConcurrency: (Optional) ContainerConcurrency specifies the
      maximum allowed in-flight (concurrent) requests per container instance
      of the Revision. Cloud Run fully managed: supported, defaults to 80
      Cloud Run for Anthos: supported, defaults to 0, which means concurrency
      to the application is not limited, and the system decides the target
      concurrency for the autoscaler.
    containers: Containers holds the single container that defines the unit of
      execution for this Revision. In the context of a Revision, we disallow a
      number of fields on this Container, including: name and lifecycle. In
      Cloud Run, only a single container may be provided. The runtime contract
      is documented here:
      https://github.com/knative/serving/blob/master/docs/runtime-contract.md
    serviceAccountName: Email address of the IAM service account associated
      with the revision of the service. The service account represents the
      identity of the running revision, and determines what permissions the
      revision has. If not provided, the revision will use the project's
      default service account.
    timeoutSeconds: TimeoutSeconds holds the max duration the instance is
      allowed for responding to a request. Cloud Run fully managed: defaults
      to 300 seconds (5 minutes). Maximum allowed value is 900 seconds (15
      minutes). Cloud Run for Anthos: defaults to 300 seconds (5 minutes).
      Maximum allowed value is configurable by the cluster operator.
    volumes: A Volume attribute.
  """

  containerConcurrency = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  containers = _messages.MessageField('Container', 2, repeated=True)
  serviceAccountName = _messages.StringField(3)
  timeoutSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  volumes = _messages.MessageField('Volume', 5, repeated=True)


class RevisionStatus(_messages.Message):
  r"""RevisionStatus communicates the observed state of the Revision (from the
  controller).

  Fields:
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world. As a Revision is being prepared, it will
      incrementally update conditions. Revision-specific conditions include: *
      "ResourcesAvailable": True when underlying resources have been
      provisioned. * "ContainerHealthy": True when the Revision readiness
      check completes. * "Active": True when the Revision may receive traffic.
    imageDigest: ImageDigest holds the resolved digest for the image specified
      within .Spec.Container.Image. The digest is resolved during the creation
      of Revision. This field holds the digest value regardless of whether a
      tag or digest was originally specified in the Container object.
    logUrl: Specifies the generated logging url for this particular revision
      based on the revision url template specified in the controller's config.
      +optional
    observedGeneration: ObservedGeneration is the 'Generation' of the Revision
      that was last processed by the controller. Clients polling for completed
      reconciliation should poll until observedGeneration =
      metadata.generation, and the Ready condition's status is True or False.
    serviceName: Not currently used by Cloud Run.
  """

  conditions = _messages.MessageField('GoogleCloudRunV1Condition', 1, repeated=True)
  imageDigest = _messages.StringField(2)
  logUrl = _messages.StringField(3)
  observedGeneration = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  serviceName = _messages.StringField(5)


class RevisionTemplate(_messages.Message):
  r"""RevisionTemplateSpec describes the data a revision should have when
  created from a template. Based on:
  https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190

  Fields:
    metadata: Optional metadata for this Revision, including labels and
      annotations. Name will be generated by the Configuration. The following
      annotation keys set properties of the created revision: *
      `autoscaling.knative.dev/minScale` sets the minimum number of instances.
      * `autoscaling.knative.dev/maxScale` sets the maximum number of
      instances. * `run.googleapis.com/cloudsql-instances` sets Cloud SQL
      connections. Multiple values should be comma separated. *
      `run.googleapis.com/vpc-access-connector` sets a Serverless VPC Access
      connector. * `run.googleapis.com/vpc-access-egress` sets VPC egress.
      Supported values are `all` and `private-ranges-only`.
    spec: RevisionSpec holds the desired state of the Revision (from the
      client).
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  spec = _messages.MessageField('RevisionSpec', 2)


class Route(_messages.Message):
  r"""Route is responsible for configuring ingress over a collection of
  Revisions. Some of the Revisions a Route distributes traffic over may be
  specified by referencing the Configuration responsible for creating them; in
  these cases the Route is additionally responsible for monitoring the
  Configuration for "latest ready" revision changes, and smoothly rolling out
  latest revisions. See also:
  https://github.com/knative/serving/blob/master/docs/spec/overview.md#route
  Cloud Run currently supports referencing a single Configuration to
  automatically deploy the "latest ready" Revision from that Configuration.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1".
    kind: The kind of this resource, in this case always "Route".
    metadata: Metadata associated with this Route, including name, namespace,
      labels, and annotations.
    spec: Spec holds the desired state of the Route (from the client).
    status: Status communicates the observed state of the Route (from the
      controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('RouteSpec', 4)
  status = _messages.MessageField('RouteStatus', 5)


class RouteSpec(_messages.Message):
  r"""RouteSpec holds the desired state of the Route (from the client).

  Fields:
    traffic: Traffic specifies how to distribute traffic over a collection of
      Knative Revisions and Configurations. Cloud Run currently supports a
      single configurationName.
  """

  traffic = _messages.MessageField('TrafficTarget', 1, repeated=True)


class RouteStatus(_messages.Message):
  r"""RouteStatus communicates the observed state of the Route (from the
  controller).

  Fields:
    address: Similar to url, information on where the service is available on
      HTTP.
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world.
    observedGeneration: ObservedGeneration is the 'Generation' of the Route
      that was last processed by the controller. Clients polling for completed
      reconciliation should poll until observedGeneration =
      metadata.generation and the Ready condition's status is True or False.
      Note that providing a trafficTarget that only has a configurationName
      will result in a Route that does not increment either its
      metadata.generation or its observedGeneration, as new "latest ready"
      revisions from the Configuration are processed without an update to the
      Route's spec.
    traffic: Traffic holds the configured traffic distribution. These entries
      will always contain RevisionName references. When ConfigurationName
      appears in the spec, this will hold the LatestReadyRevisionName that we
      last observed.
    url: URL holds the url that will distribute traffic over the provided
      traffic targets. It generally has the form: https://{route-
      hash}-{project-hash}-{cluster-level-suffix}.a.run.app
  """

  address = _messages.MessageField('Addressable', 1)
  conditions = _messages.MessageField('GoogleCloudRunV1Condition', 2, repeated=True)
  observedGeneration = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  traffic = _messages.MessageField('TrafficTarget', 4, repeated=True)
  url = _messages.StringField(5)


class RunApiV1NamespacesGetRequest(_messages.Message):
  r"""A RunApiV1NamespacesGetRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunApiV1NamespacesPatchRequest(_messages.Message):
  r"""A RunApiV1NamespacesPatchRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
    namespace: A Namespace resource to be passed as the request body.
    updateMask: Required. Indicates which fields in the provided namespace to
      update. This field is currently unused.
  """

  name = _messages.StringField(1, required=True)
  namespace = _messages.MessageField('Namespace', 2)
  updateMask = _messages.StringField(3)


class RunApiV1NamespacesSecretsCreateRequest(_messages.Message):
  r"""A RunApiV1NamespacesSecretsCreateRequest object.

  Fields:
    parent: Required. The project ID or project number in which this secret
      should be created.
    secret: A Secret resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  secret = _messages.MessageField('Secret', 2)


class RunApiV1NamespacesSecretsGetRequest(_messages.Message):
  r"""A RunApiV1NamespacesSecretsGetRequest object.

  Fields:
    name: Required. The name of the secret being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunApiV1NamespacesSecretsReplaceSecretRequest(_messages.Message):
  r"""A RunApiV1NamespacesSecretsReplaceSecretRequest object.

  Fields:
    name: Required. The name of the secret being retrieved. If needed, replace
      {namespace_id} with the project ID.
    secret: A Secret resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  secret = _messages.MessageField('Secret', 2)


class RunNamespacesAuthorizeddomainsListRequest(_messages.Message):
  r"""A RunNamespacesAuthorizeddomainsListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Project resource. Example:
      `projects/myproject`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class RunNamespacesConfigurationsGetRequest(_messages.Message):
  r"""A RunNamespacesConfigurationsGetRequest object.

  Fields:
    name: The name of the configuration to retrieve. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesConfigurationsListRequest(_messages.Message):
  r"""A RunNamespacesConfigurationsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the configurations should be listed. For
      Cloud Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesDomainmappingsCreateRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsCreateRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    parent: The namespace in which the domain mapping should be created. For
      Cloud Run (fully managed), replace {namespace_id} with the project ID or
      number.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesDomainmappingsDeleteRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the domain mapping to delete. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesDomainmappingsGetRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsGetRequest object.

  Fields:
    name: The name of the domain mapping to retrieve. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesDomainmappingsListRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the domain mappings should be listed. For
      Cloud Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesRevisionsDeleteRequest(_messages.Message):
  r"""A RunNamespacesRevisionsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the revision to delete. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesRevisionsGetRequest(_messages.Message):
  r"""A RunNamespacesRevisionsGetRequest object.

  Fields:
    name: The name of the revision to retrieve. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesRevisionsListRequest(_messages.Message):
  r"""A RunNamespacesRevisionsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the revisions should be listed. For Cloud
      Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesRoutesGetRequest(_messages.Message):
  r"""A RunNamespacesRoutesGetRequest object.

  Fields:
    name: The name of the route to retrieve. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesRoutesListRequest(_messages.Message):
  r"""A RunNamespacesRoutesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the routes should be listed. For Cloud
      Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesServicesCreateRequest(_messages.Message):
  r"""A RunNamespacesServicesCreateRequest object.

  Fields:
    parent: The namespace in which the service should be created. For Cloud
      Run (fully managed), replace {namespace_id} with the project ID or
      number.
    service: A Service resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class RunNamespacesServicesDeleteRequest(_messages.Message):
  r"""A RunNamespacesServicesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the service to delete. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesServicesGetRequest(_messages.Message):
  r"""A RunNamespacesServicesGetRequest object.

  Fields:
    name: The name of the service to retrieve. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesServicesListRequest(_messages.Message):
  r"""A RunNamespacesServicesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the services should be listed. For Cloud
      Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesServicesReplaceServiceRequest(_messages.Message):
  r"""A RunNamespacesServicesReplaceServiceRequest object.

  Fields:
    name: The name of the service being replaced. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
    service: A Service resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class RunProjectsAuthorizeddomainsListRequest(_messages.Message):
  r"""A RunProjectsAuthorizeddomainsListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Project resource. Example:
      `projects/myproject`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class RunProjectsLocationsAuthorizeddomainsListRequest(_messages.Message):
  r"""A RunProjectsLocationsAuthorizeddomainsListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Project resource. Example:
      `projects/myproject`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class RunProjectsLocationsConfigurationsGetRequest(_messages.Message):
  r"""A RunProjectsLocationsConfigurationsGetRequest object.

  Fields:
    name: The name of the configuration to retrieve. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsConfigurationsListRequest(_messages.Message):
  r"""A RunProjectsLocationsConfigurationsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the configurations should be listed. For
      Cloud Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsDomainmappingsCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsCreateRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    parent: The namespace in which the domain mapping should be created. For
      Cloud Run (fully managed), replace {namespace_id} with the project ID or
      number.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  parent = _messages.StringField(2, required=True)


class RunProjectsLocationsDomainmappingsDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the domain mapping to delete. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunProjectsLocationsDomainmappingsGetRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsGetRequest object.

  Fields:
    name: The name of the domain mapping to retrieve. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsDomainmappingsListRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the domain mappings should be listed. For
      Cloud Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsListRequest(_messages.Message):
  r"""A RunProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class RunProjectsLocationsNamespacesGetRequest(_messages.Message):
  r"""A RunProjectsLocationsNamespacesGetRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsNamespacesPatchRequest(_messages.Message):
  r"""A RunProjectsLocationsNamespacesPatchRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
    namespace: A Namespace resource to be passed as the request body.
    updateMask: Required. Indicates which fields in the provided namespace to
      update. This field is currently unused.
  """

  name = _messages.StringField(1, required=True)
  namespace = _messages.MessageField('Namespace', 2)
  updateMask = _messages.StringField(3)


class RunProjectsLocationsRevisionsDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsRevisionsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the revision to delete. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunProjectsLocationsRevisionsGetRequest(_messages.Message):
  r"""A RunProjectsLocationsRevisionsGetRequest object.

  Fields:
    name: The name of the revision to retrieve. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsRevisionsListRequest(_messages.Message):
  r"""A RunProjectsLocationsRevisionsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the revisions should be listed. For Cloud
      Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsRoutesGetRequest(_messages.Message):
  r"""A RunProjectsLocationsRoutesGetRequest object.

  Fields:
    name: The name of the route to retrieve. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsRoutesListRequest(_messages.Message):
  r"""A RunProjectsLocationsRoutesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the routes should be listed. For Cloud
      Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsSecretsCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsSecretsCreateRequest object.

  Fields:
    parent: Required. The project ID or project number in which this secret
      should be created.
    secret: A Secret resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  secret = _messages.MessageField('Secret', 2)


class RunProjectsLocationsSecretsGetRequest(_messages.Message):
  r"""A RunProjectsLocationsSecretsGetRequest object.

  Fields:
    name: Required. The name of the secret being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsSecretsReplaceSecretRequest(_messages.Message):
  r"""A RunProjectsLocationsSecretsReplaceSecretRequest object.

  Fields:
    name: Required. The name of the secret being retrieved. If needed, replace
      {namespace_id} with the project ID.
    secret: A Secret resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  secret = _messages.MessageField('Secret', 2)


class RunProjectsLocationsServicesCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesCreateRequest object.

  Fields:
    parent: The namespace in which the service should be created. For Cloud
      Run (fully managed), replace {namespace_id} with the project ID or
      number.
    service: A Service resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class RunProjectsLocationsServicesDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the service to delete. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunProjectsLocationsServicesGetIamPolicyRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class RunProjectsLocationsServicesGetRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesGetRequest object.

  Fields:
    name: The name of the service to retrieve. For Cloud Run (fully managed),
      replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsServicesListRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The namespace from which the services should be listed. For Cloud
      Run (fully managed), replace {namespace_id} with the project ID or
      number.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsServicesReplaceServiceRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesReplaceServiceRequest object.

  Fields:
    name: The name of the service being replaced. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
    service: A Service resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class RunProjectsLocationsServicesSetIamPolicyRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class RunProjectsLocationsServicesTestIamPermissionsRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Secret(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run on GKE: supported
  Secret holds secret data of a certain type. The total bytes of the values in
  the Data field must be less than MaxSecretSize bytes.

  Messages:
    DataValue: Data contains the secret data. Each key must consist of
      alphanumeric characters, '-', '_' or '.'. The serialized form of the
      secret data is a base64 encoded string, representing the arbitrary
      (possibly non-string) data value here. Described in
      https://tools.ietf.org/html/rfc4648#section-4
    StringDataValue: stringData allows specifying non-binary secret data in
      string form. It is provided as a write-only convenience method. All keys
      and values are merged into the data field on write, overwriting any
      existing values. It is never output when reading from the API.
      +k8s:conversion-gen=false

  Fields:
    data: Data contains the secret data. Each key must consist of alphanumeric
      characters, '-', '_' or '.'. The serialized form of the secret data is a
      base64 encoded string, representing the arbitrary (possibly non-string)
      data value here. Described in
      https://tools.ietf.org/html/rfc4648#section-4
    metadata: Standard object's metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    stringData: stringData allows specifying non-binary secret data in string
      form. It is provided as a write-only convenience method. All keys and
      values are merged into the data field on write, overwriting any existing
      values. It is never output when reading from the API. +k8s:conversion-
      gen=false
    type: Used to facilitate programmatic handling of secret data.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataValue(_messages.Message):
    r"""Data contains the secret data. Each key must consist of alphanumeric
    characters, '-', '_' or '.'. The serialized form of the secret data is a
    base64 encoded string, representing the arbitrary (possibly non-string)
    data value here. Described in
    https://tools.ietf.org/html/rfc4648#section-4

    Messages:
      AdditionalProperty: An additional property for a DataValue object.

    Fields:
      additionalProperties: Additional properties of type DataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataValue object.

      Fields:
        key: Name of the additional property.
        value: A byte attribute.
      """

      key = _messages.StringField(1)
      value = _messages.BytesField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StringDataValue(_messages.Message):
    r"""stringData allows specifying non-binary secret data in string form. It
    is provided as a write-only convenience method. All keys and values are
    merged into the data field on write, overwriting any existing values. It
    is never output when reading from the API. +k8s:conversion-gen=false

    Messages:
      AdditionalProperty: An additional property for a StringDataValue object.

    Fields:
      additionalProperties: Additional properties of type StringDataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StringDataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  data = _messages.MessageField('DataValue', 1)
  metadata = _messages.MessageField('ObjectMeta', 2)
  stringData = _messages.MessageField('StringDataValue', 3)
  type = _messages.StringField(4)


class SecretEnvSource(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  SecretEnvSource selects a Secret to populate the environment variables with.
  The contents of the target Secret's Data field will represent the key-value
  pairs as environment variables.

  Fields:
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The Secret to select from.
    optional: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Specify whether the Secret must be defined
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  name = _messages.StringField(2)
  optional = _messages.BooleanField(3)


class SecretKeySelector(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  SecretKeySelector selects a key of a Secret.

  Fields:
    key: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The key of the secret to select from. Must be a valid secret
      key.
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The name of the secret in the pod's namespace to select from.
    optional: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Specify whether the Secret or its key must be defined
  """

  key = _messages.StringField(1)
  localObjectReference = _messages.MessageField('LocalObjectReference', 2)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class SecretVolumeSource(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  The contents of the target Secret's Data field will be presented in a volume
  as files using the keys in the Data field as the file names.

  Fields:
    defaultMode: (Optional) Cloud Run fully managed: not supported Cloud Run
      for Anthos: supported Mode bits to use on created files by default. Must
      be a value between 0000 and 0777. Defaults to 0644. Directories within
      the path are not affected by this setting. This might be in conflict
      with other options that affect the file mode, like fsGroup, and the
      result can be other mode bits set. NOTE: This is an integer
      representation of the mode bits. So, the integer value should look
      exactly as the chmod numeric notation, i.e. Unix chmod "777" (a=rwx)
      should have the integer value 777.
    items: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported If unspecified, each key-value pair in the Data field
      of the referenced Secret will be projected into the volume as a file
      whose name is the key and content is the value. If specified, the listed
      keys will be projected into the specified paths, and unlisted keys will
      not be present. If a key is specified which is not present in the
      Secret, the volume setup will error unless it is marked optional.
    optional: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Specify whether the Secret or its keys must be
      defined.
    secretName: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported Name of the secret in the container's namespace to use.
  """

  defaultMode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  items = _messages.MessageField('KeyToPath', 2, repeated=True)
  optional = _messages.BooleanField(3)
  secretName = _messages.StringField(4)


class SecurityContext(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  SecurityContext holds security configuration that will be applied to a
  container. Some fields are present in both SecurityContext and
  PodSecurityContext. When both are set, the values in SecurityContext take
  precedence.

  Fields:
    runAsUser: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported The UID to run the entrypoint of the container
      process. Defaults to user specified in image metadata if unspecified.
      May also be set in PodSecurityContext. If set in both SecurityContext
      and PodSecurityContext, the value specified in SecurityContext takes
      precedence.
  """

  runAsUser = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class Service(_messages.Message):
  r"""Service acts as a top-level container that manages a set of Routes and
  Configurations which implement a network service. Service exists to provide
  a singular abstraction which can be access controlled, reasoned about, and
  which encapsulates software lifecycle decisions such as rollout policy and
  team resource ownership. Service acts only as an orchestrator of the
  underlying Routes and Configurations (much as a kubernetes Deployment
  orchestrates ReplicaSets). The Service's controller will track the statuses
  of its owned Configuration and Route, reflecting their statuses and
  conditions as its own. See also:
  https://github.com/knative/serving/blob/master/docs/spec/overview.md#service

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1".
    kind: The kind of resource, in this case "Service".
    metadata: Metadata associated with this Service, including name,
      namespace, labels, and annotations.
    spec: Spec holds the desired state of the Service (from the client).
    status: Status communicates the observed state of the Service (from the
      controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('ServiceSpec', 4)
  status = _messages.MessageField('ServiceStatus', 5)


class ServiceSpec(_messages.Message):
  r"""ServiceSpec holds the desired state of the Route (from the client),
  which is used to manipulate the underlying Route and Configuration(s).

  Fields:
    template: Template holds the latest specification for the Revision to be
      stamped out.
    traffic: Traffic specifies how to distribute traffic over a collection of
      Knative Revisions and Configurations.
  """

  template = _messages.MessageField('RevisionTemplate', 1)
  traffic = _messages.MessageField('TrafficTarget', 2, repeated=True)


class ServiceStatus(_messages.Message):
  r"""The current state of the Service. Output only.

  Fields:
    address: From RouteStatus. Similar to url, information on where the
      service is available on HTTP.
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world. Service-specific conditions include: *
      "ConfigurationsReady": true when the underlying Configuration is ready.
      * "RoutesReady": true when the underlying Route is ready. * "Ready":
      true when both the underlying Route and Configuration are ready.
    latestCreatedRevisionName: From ConfigurationStatus.
      LatestCreatedRevisionName is the last revision that was created from
      this Service's Configuration. It might not be ready yet, for that use
      LatestReadyRevisionName.
    latestReadyRevisionName: From ConfigurationStatus. LatestReadyRevisionName
      holds the name of the latest Revision stamped out from this Service's
      Configuration that has had its "Ready" condition become "True".
    observedGeneration: ObservedGeneration is the 'Generation' of the Route
      that was last processed by the controller. Clients polling for completed
      reconciliation should poll until observedGeneration =
      metadata.generation and the Ready condition's status is True or False.
    traffic: From RouteStatus. Traffic holds the configured traffic
      distribution. These entries will always contain RevisionName references.
      When ConfigurationName appears in the spec, this will hold the
      LatestReadyRevisionName that we last observed.
    url: From RouteStatus. URL holds the url that will distribute traffic over
      the provided traffic targets. It generally has the form https://{route-
      hash}-{project-hash}-{cluster-level-suffix}.a.run.app
  """

  address = _messages.MessageField('Addressable', 1)
  conditions = _messages.MessageField('GoogleCloudRunV1Condition', 2, repeated=True)
  latestCreatedRevisionName = _messages.StringField(3)
  latestReadyRevisionName = _messages.StringField(4)
  observedGeneration = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  traffic = _messages.MessageField('TrafficTarget', 6, repeated=True)
  url = _messages.StringField(7)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""Status is a return value for calls that don't return other objects

  Fields:
    code: Suggested HTTP return code for this status, 0 if not set. +optional
    details: Extended data associated with the reason. Each reason may define
      its own extended details. This field is optional and the data returned
      is not guaranteed to conform to any schema except that defined by the
      reason type. +optional
    message: A human-readable description of the status of this operation.
      +optional
    metadata: Standard list metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#types-kinds +optional
    reason: A machine-readable description of why this operation is in the
      "Failure" status. If this value is empty there is no information
      available. A Reason clarifies an HTTP status code but does not override
      it. +optional
    status: Status of the operation. One of: "Success" or "Failure". More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#spec-and-status +optional
  """

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('StatusDetails', 2)
  message = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  reason = _messages.StringField(5)
  status = _messages.StringField(6)


class StatusCause(_messages.Message):
  r"""StatusCause provides more information about an api.Status failure,
  including cases when multiple errors are encountered.

  Fields:
    field: The field of the resource that has caused this error, as named by
      its JSON serialization. May include dot and postfix notation for nested
      attributes. Arrays are zero-indexed. Fields may appear more than once in
      an array of causes due to fields having multiple errors. Optional.
      Examples: "name" - the field "name" on the current resource
      "items[0].name" - the field "name" on the first array entry in "items"
      +optional
    message: A human-readable description of the cause of the error. This
      field may be presented as-is to a reader. +optional
    reason: A machine-readable description of the cause of the error. If this
      value is empty there is no information available. +optional
  """

  field = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)


class StatusDetails(_messages.Message):
  r"""StatusDetails is a set of additional properties that MAY be set by the
  server to provide additional information about a response. The Reason field
  of a Status object defines what attributes will be set. Clients must ignore
  fields that do not match the defined type of each attribute, and should
  assume that any attribute may be empty, invalid, or under defined.

  Fields:
    causes: The Causes array includes more details associated with the
      StatusReason failure. Not all StatusReasons may provide detailed causes.
      +optional
    group: The group attribute of the resource associated with the status
      StatusReason. +optional
    kind: The kind attribute of the resource associated with the status
      StatusReason. On some operations may differ from the requested resource
      Kind. More info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#types-kinds +optional
    name: The name attribute of the resource associated with the status
      StatusReason (when there is a single name which can be described).
      +optional
    retryAfterSeconds: If specified, the time in seconds before the operation
      should be retried. Some errors may indicate the client must take an
      alternate action - for those errors this field may indicate how long to
      wait before taking the alternate action. +optional
    uid: UID of the resource. (when there is a single resource which can be
      described). More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids +optional
  """

  causes = _messages.MessageField('StatusCause', 1, repeated=True)
  group = _messages.StringField(2)
  kind = _messages.StringField(3)
  name = _messages.StringField(4)
  retryAfterSeconds = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  uid = _messages.StringField(6)


class TCPSocketAction(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  TCPSocketAction describes an action based on opening a socket

  Fields:
    host: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Optional: Host name to connect to, defaults to the pod
      IP.
    port: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported Number or name of the port to access on the container. Number
      must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. This
      field is currently limited to integer types only because of proto's
      inability to properly support the IntOrString golang type.
  """

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TrafficTarget(_messages.Message):
  r"""TrafficTarget holds a single entry of the routing table for a Route.

  Fields:
    configurationName: ConfigurationName of a configuration to whose latest
      revision we will send this portion of traffic. When the
      "status.latestReadyRevisionName" of the referenced configuration
      changes, we will automatically migrate traffic from the prior "latest
      ready" revision to the new one. This field is never set in Route's
      status, only its spec. This is mutually exclusive with RevisionName.
      Cloud Run currently supports a single ConfigurationName.
    latestRevision: LatestRevision may be optionally provided to indicate that
      the latest ready Revision of the Configuration should be used for this
      traffic target. When provided LatestRevision must be true if
      RevisionName is empty; it must be false when RevisionName is non-empty.
      +optional
    percent: Percent specifies percent of the traffic to this Revision or
      Configuration. This defaults to zero if unspecified. Cloud Run currently
      requires 100 percent for a single ConfigurationName TrafficTarget entry.
    revisionName: RevisionName of a specific revision to which to send this
      portion of traffic. This is mutually exclusive with ConfigurationName.
      Providing RevisionName in spec is not currently supported by Cloud Run.
    tag: Tag is optionally used to expose a dedicated url for referencing this
      target exclusively. +optional
    url: Output only. URL displays the URL for accessing tagged traffic
      targets. URL is displayed in status, and is disallowed on spec. URL must
      contain a scheme (e.g. http://) and a hostname, but may not contain
      anything else (e.g. basic auth, url path, etc. Not currently supported
      in Cloud Run.
  """

  configurationName = _messages.StringField(1)
  latestRevision = _messages.BooleanField(2)
  percent = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  revisionName = _messages.StringField(4)
  tag = _messages.StringField(5)
  url = _messages.StringField(6)


class Volume(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  Volume represents a named volume in a container.

  Fields:
    configMap: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported Volume's name.
    secret: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported
  """

  configMap = _messages.MessageField('ConfigMapVolumeSource', 1)
  name = _messages.StringField(2)
  secret = _messages.MessageField('SecretVolumeSource', 3)


class VolumeMount(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run for Anthos: supported
  VolumeMount describes a mounting of a Volume within a container.

  Fields:
    mountPath: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported Path within the container at which the volume should be
      mounted. Must not contain ':'.
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported This must match the Name of a Volume.
    readOnly: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Only true is accepted. Defaults to true.
    subPath: (Optional) Cloud Run fully managed: not supported Cloud Run for
      Anthos: supported Path within the volume from which the container's
      volume should be mounted. Defaults to "" (volume's root).
  """

  mountPath = _messages.StringField(1)
  name = _messages.StringField(2)
  readOnly = _messages.BooleanField(3)
  subPath = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    ListMeta, 'continue_', 'continue')
encoding.AddCustomJsonFieldMapping(
    Probe, 'exec_', 'exec')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
