"""Generated message classes for run version v1alpha1.

Deploy and manage user provided container images that scale automatically
based on HTTP traffic.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'run'


class Addressable(_messages.Message):
  r"""Information for connecting over HTTP(s).

  Fields:
    hostname: Deprecated - use url instead.
    url: A string attribute.
  """

  hostname = _messages.StringField(1)
  url = _messages.StringField(2)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices",           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:jose@example.com"               ]             },             {
  "log_type": "DATA_WRITE"             },             {
  "log_type": "ADMIN_READ"             }           ]         },         {
  "service": "sampleservice.googleapis.com",           "audit_log_configs": [
  {               "log_type": "DATA_READ"             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:aliya@example.com"               ]             }           ]         }
  ]     }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging,
  and aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:jose@example.com"           ]
  },         {           "log_type": "DATA_WRITE"         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  jose@example.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class AuthorizedDomain(_messages.Message):
  r"""A domain that a user has been authorized to administer. To authorize use
  of a domain, verify ownership via [Webmaster
  Central](https://www.google.com/webmasters/verification/home).

  Fields:
    id: Relative name of the domain authorized for use. Example:
      `example.com`.
    name: Read only. Full path to the `AuthorizedDomain` resource in the API.
      Example: `apps/myapp/authorizedDomains/example.com`.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding.  If the
      condition evaluates to `true`, then this binding applies to the current
      request.  If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding.  *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus    unique identifier) representing a service account that has been
      recently    deleted. For example,    `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`.    If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding.  * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique    identifier) representing a Google group
      that has been recently    deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If    the group is
      recovered, this value reverts to `group:{emailid}` and the    recovered
      group retains the role in the binding.   * `domain:{domain}`: The G
      Suite domain (primary) that represents all the    users of that domain.
      For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class Capabilities(_messages.Message):
  r"""Adds and removes POSIX capabilities from running containers.

  Fields:
    add: Added capabilities +optional
    drop: Removed capabilities +optional
  """

  add = _messages.StringField(1, repeated=True)
  drop = _messages.StringField(2, repeated=True)


class CloudAuditLogsSource(_messages.Message):
  r"""A CloudAuditLogsSource object.

  Fields:
    apiVersion: The API version for this call such as
      "events.cloud.google.com/v1alpha1".
    kind: The kind of resource, in this case "CloudAuditLogsSource".
    metadata: Metadata associated with this CloudAuditLogsSource.
    spec: Spec defines the desired state of the CloudAuditLogsSource.
    status: Status represents the current state of the CloudAuditLogsSource.
      This data may be out of date. +optional
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('CloudAuditLogsSourceSpec', 4)
  status = _messages.MessageField('CloudAuditLogsSourceStatus', 5)


class CloudAuditLogsSourceSpec(_messages.Message):
  r"""The desired state of the CloudAuditLogsSource.

  Fields:
    ceOverrides: CloudEventOverrides defines overrides to control the output
      format and modifications of the event sent to the sink. +optional
    methodName: Required. The method name at the service API. This must match
      "methodName" in Cloud Audit Logs. Regex or Wildcards (*) are not
      supported. Example: "google.cloud.bigquery.job.create".
    resourceName: Optional. The resource specification. This must match
      "methodName" in Cloud Audit Logs. Regex or Wildcards (*) are not
      supported. Example: "projects/my-project/jobs/foo".
    serviceAccountName: Optional. Email address of the IAM service account
      associated with the source. The service account represents the identity
      of the source, and determines what permissions the source has. If not
      provided, the source will use the project's default service account.
    serviceName: Required. The GCP service name. This must match "serviceName"
      in Cloud Audit Logs. Regex or Wildcards (*) are not supported. Example:
      "bigquery.googleapis.com".
    sink: Sink is a reference to an object that will resolve to a domain name
      or a URI directly to use as the sink.
  """

  ceOverrides = _messages.MessageField('CloudEventOverrides', 1)
  methodName = _messages.StringField(2)
  resourceName = _messages.StringField(3)
  serviceAccountName = _messages.StringField(4)
  serviceName = _messages.StringField(5)
  sink = _messages.MessageField('Destination', 6)


class CloudAuditLogsSourceStatus(_messages.Message):
  r"""CloudAuditLogsSourceStatus represents the current state of a
  CloudAuditLogsSource.

  Fields:
    conditions: Array of observed CloudAuditLogsSourceConditions, indicating
      the current state of the CloudAuditLogsSource.
    observedGeneration: ObservedGeneration is the 'Generation' of the
      CloudAuditLogsSource that was last processed by the controller.
    sinkUri: SinkURI is the current active sink URI that has been configured
      for the Source. +optional
  """

  conditions = _messages.MessageField('Condition', 1, repeated=True)
  observedGeneration = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sinkUri = _messages.StringField(3)


class CloudEventOverrides(_messages.Message):
  r"""CloudEventOverrides defines arguments for a Source that control the
  output format of the CloudEvents produced by the Source.

  Messages:
    ExtensionsValue: Extensions specify what attribute are added or overridden
      on the outbound event. Each `Extensions` key-value pair are set on the
      event as an attribute extension independently. +optional

  Fields:
    extensions: Extensions specify what attribute are added or overridden on
      the outbound event. Each `Extensions` key-value pair are set on the
      event as an attribute extension independently. +optional
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValue(_messages.Message):
    r"""Extensions specify what attribute are added or overridden on the
    outbound event. Each `Extensions` key-value pair are set on the event as
    an attribute extension independently. +optional

    Messages:
      AdditionalProperty: An additional property for a ExtensionsValue object.

    Fields:
      additionalProperties: Additional properties of type ExtensionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  extensions = _messages.MessageField('ExtensionsValue', 1)


class CloudPubSubSource(_messages.Message):
  r"""A CloudPubSubSource object.

  Fields:
    apiVersion: The API version for this call such as
      "events.cloud.google.com/v1alpha1".
    kind: The kind of resource, in this case "CloudPubSubSource".
    metadata: Metadata associated with this CloudPubSubSource.
    spec: Spec defines the desired state of the CloudPubSubSource.
    status: Status represents the current state of the CloudPubSubSource. This
      data may be out of date. +optional
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('CloudPubSubSourceSpec', 4)
  status = _messages.MessageField('CloudPubSubSourceStatus', 5)


class CloudPubSubSourceSpec(_messages.Message):
  r"""The desired state of the CloudPubSubSource.

  Fields:
    ackDeadline: AckDeadline is the default maximum time after a subscriber
      receives a message before the subscriber should acknowledge the message.
      Defaults to 30 seconds ('30s'). +optional
    ceOverrides: CloudEventOverrides defines overrides to control the output
      format and modifications of the event sent to the sink. +optional
    project: Project is the ID of the Google Cloud Project that the
      CloudPubSubSource Topic exists in. If omitted, defaults to same as the
      cluster. +optional
    pubsubSecret: CloudPubSubSourceSecret is the credential to use to create
      Topic / PullSubscription resources. If omitted, uses Secret.
    retainAckedMessages: RetainAckedMessages defines whether to retain
      acknowledged messages. If true, acknowledged messages will not be
      expunged until they fall out of the RetentionDuration window.
    retentionDuration: RetentionDuration defines how long to retain messages
      in backlog, from the time of publish. If RetainAckedMessages is true,
      this duration affects the retention of acknowledged messages, otherwise
      only unacknowledged messages are retained. Cannot be longer than 7 days
      or shorter than 10 minutes. Defaults to 7 days ('7d'). +optional
    secret: Secret is the credential to use to create the Scheduler Job. If
      not specified, defaults to: Name: google-cloud-key Key: key.json
      +optional
    sink: Sink is a reference to an object that will resolve to a domain name
      or a URI directly to use as the sink.
    topic: Topic is the ID of the CloudPubSubSource Topic to Subscribe to. It
      must be in the form of the unique identifier within the project, not the
      entire name. E.g. it must be 'laconia', not 'projects/my-
      proj/topics/laconia'.
  """

  ackDeadline = _messages.StringField(1)
  ceOverrides = _messages.MessageField('CloudEventOverrides', 2)
  project = _messages.StringField(3)
  pubsubSecret = _messages.MessageField('SecretKeySelector', 4)
  retainAckedMessages = _messages.BooleanField(5)
  retentionDuration = _messages.StringField(6)
  secret = _messages.MessageField('SecretKeySelector', 7)
  sink = _messages.MessageField('Destination', 8)
  topic = _messages.StringField(9)


class CloudPubSubSourceStatus(_messages.Message):
  r"""CloudPubSubSourceStatus represents the current state of a
  CloudPubSubSource.

  Fields:
    conditions: Array of observed CloudPubSubSourceConditions, indicating the
      current state of the CloudPubSubSource.
    observedGeneration: ObservedGeneration is the 'Generation' of the
      CloudPubSubSource that was last processed by the controller.
    sinkUri: SinkURI is the current active sink URI that has been configured
      for the Source. +optional
  """

  conditions = _messages.MessageField('Condition', 1, repeated=True)
  observedGeneration = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sinkUri = _messages.StringField(3)


class CloudSchedulerSource(_messages.Message):
  r"""The CloudSchedulerSource resource.

  Fields:
    apiVersion: The API version for this call such as
      "events.cloud.google.com/v1alpha1".
    kind: The kind of resource, in this case "CloudSchedulerSource".
    metadata: Metadata associated with this CloudSchedulerSource.
    spec: Spec defines the desired state of the CloudSchedulerSource.
    status: Status represents the current state of the CloudSchedulerSource.
      This data may be out of date.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('CloudSchedulerSourceSpec', 4)
  status = _messages.MessageField('CloudSchedulerSourceStatus', 5)


class CloudSchedulerSourceSpec(_messages.Message):
  r"""The desired state of the CloudSchedulerSource.

  Fields:
    ceOverrides: CloudEventOverrides defines overrides to control the output
      format and modifications of the event sent to the sink.
    data: Data to send in the payload of the Event.
    location: Location to create the Scheduler job in.
    project: Project is the ID of the Google Cloud Project that the
      CloudPubSubSource Topic exists in. If omitted, defaults to same as the
      cluster.
    pubsubSecret: CloudPubSubSourceSecret is the credential to use to create
      Topic / PullSubscription resources. If omitted, uses Secret.
    schedule: Schedule in cron format, for example: "* * * * *" would be run
      every minute.
    secret: Secret is the credential to use to create the Scheduler Job. If
      not specified, defaults to: Name: google-cloud-key Key: key.json
    sink: Sink is a reference to an object that will resolve to a domain name
      or a URI directly to use as the sink.
  """

  ceOverrides = _messages.MessageField('CloudEventOverrides', 1)
  data = _messages.StringField(2)
  location = _messages.StringField(3)
  project = _messages.StringField(4)
  pubsubSecret = _messages.MessageField('SecretKeySelector', 5)
  schedule = _messages.StringField(6)
  secret = _messages.MessageField('SecretKeySelector', 7)
  sink = _messages.MessageField('Destination', 8)


class CloudSchedulerSourceStatus(_messages.Message):
  r"""CloudSchedulerSourceStatus represents the current state of a
  CloudSchedulerSource.

  Fields:
    conditions: Array of observed CloudSchedulerSourceConditions, indicating
      the current state of the CloudSchedulerSource.
    observedGeneration: ObservedGeneration is the 'Generation' of the
      CloudSchedulerSource that was last processed by the controller.
    sinkUri: SinkURI is the current active sink URI that has been configured
      for the Source.
  """

  conditions = _messages.MessageField('Condition', 1, repeated=True)
  observedGeneration = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sinkUri = _messages.StringField(3)


class CloudStorageSource(_messages.Message):
  r"""The CloudStorageSource resource.

  Fields:
    apiVersion: The API version for this call such as
      "events.cloud.google.com/v1alpha1".
    kind: The kind of resource, in this case "CloudStorageSource".
    metadata: Metadata associated with this CloudStorageSource.
    spec: Spec defines the desired state of the CloudStorageSource.
    status: Status represents the current state of the CloudStorageSource.
      This data may be out of date.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('CloudStorageSourceSpec', 4)
  status = _messages.MessageField('CloudStorageSourceStatus', 5)


class CloudStorageSourceSpec(_messages.Message):
  r"""The desired state of the CloudStorageSource.

  Fields:
    bucket: Bucket to subscribe to.
    ceOverrides: CloudEventOverrides defines overrides to control the output
      format and modifications of the event sent to the sink.
    eventTypes: EventTypes to subscribe to. If unspecified, then subscribe to
      all events.
    objectNamePrefix: ObjectNamePrefix limits the notifications to objects
      with this prefix.
    payloadFormat: PayloadFormat specifies the contents of the message
      payload. See https://cloud.google.com/storage/docs/pubsub-
      notifications#payload.
    project: Project is the ID of the Google Cloud Project that the PubSub
      Topic exists in. If omitted, defaults to same as the cluster.
    pubsubSecret: PubSubSecret is the credential to use to create Topic /
      PullSubscription resources. If omitted, uses Secret.
    secret: Secret is the credential to use to create the Scheduler Job. If
      not specified, defaults to: Name: google-cloud-key Key: key.json
    serviceAccountName: ServiceAccountName holds the name of the Kubernetes
      service account as which the underlying K8s resources should be run. If
      unspecified this will default to the "default" service account for the
      namespace in which the GCS exists.
    sink: Sink is a reference to an object that will resolve to a domain name
      or a URI directly to use as the sink.
  """

  bucket = _messages.StringField(1)
  ceOverrides = _messages.MessageField('CloudEventOverrides', 2)
  eventTypes = _messages.StringField(3, repeated=True)
  objectNamePrefix = _messages.StringField(4)
  payloadFormat = _messages.StringField(5)
  project = _messages.StringField(6)
  pubsubSecret = _messages.MessageField('SecretKeySelector', 7)
  secret = _messages.MessageField('SecretKeySelector', 8)
  serviceAccountName = _messages.StringField(9)
  sink = _messages.MessageField('Destination', 10)


class CloudStorageSourceStatus(_messages.Message):
  r"""CloudStorageSourceStatus represents the current state of a
  CloudStorageSource.

  Fields:
    conditions: Array of observed CloudStorageSourceConditions, indicating the
      current state of the CloudStorageSource.
    observedGeneration: ObservedGeneration is the 'Generation' of the
      CloudStorageSource that was last processed by the controller.
    sinkUri: SinkURI is the current active sink URI that has been configured
      for the Source.
  """

  conditions = _messages.MessageField('Condition', 1, repeated=True)
  observedGeneration = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sinkUri = _messages.StringField(3)


class Condition(_messages.Message):
  r"""Condition defines a generic condition for a Resource

  Fields:
    lastTransitionTime: Optional. Last time the condition transitioned from
      one status to another.
    message: Optional. Human readable message indicating details about the
      current status.
    reason: Optional. One-word CamelCase reason for the condition's last
      transition.
    severity: Optional. How to interpret failures of this condition, one of
      Error, Warning, Info
    status: Status of the condition, one of True, False, Unknown.
    type: type is used to communicate the status of the reconciliation
      process. See also: https://github.com/knative/serving/blob/master/docs/s
      pec/errors.md#error-conditions-and-reporting Types common to all
      resources include: * "Ready": True when the Resource is ready.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class ConfigMapEnvSource(_messages.Message):
  r"""ConfigMapEnvSource selects a ConfigMap to populate the environment
  variables with.  The contents of the target ConfigMap's Data field will
  represent the key-value pairs as environment variables.

  Fields:
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported  Cloud Run for Anthos:
      supported  The ConfigMap to select from.
    optional: Cloud Run fully managed: not supported  Cloud Run for Anthos:
      supported  Specify whether the ConfigMap must be defined +optional
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  name = _messages.StringField(2)
  optional = _messages.BooleanField(3)


class ConfigMapKeySelector(_messages.Message):
  r"""Cloud Run fully managed: not supported  Cloud Run on GKE: supported
  Selects a key from a ConfigMap.

  Fields:
    key: Cloud Run fully managed: not supported  Cloud Run on GKE: supported
      The key to select.
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported  Cloud Run on GKE: supported
      The ConfigMap to select from.
    optional: Cloud Run fully managed: not supported  Cloud Run on GKE:
      supported  Specify whether the ConfigMap or its key must be defined
      +optional
  """

  key = _messages.StringField(1)
  localObjectReference = _messages.MessageField('LocalObjectReference', 2)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class ConfigMapVolumeSource(_messages.Message):
  r"""Adapts a ConfigMap into a volume. The contents of the target ConfigMap's
  Data field will be presented in a volume as files using the keys in the Data
  field as the file names, unless the items element is populated with specific
  mappings of keys to paths.

  Fields:
    defaultMode: Mode bits to use on created files by default. Must be a value
      between 0 and 0777. Defaults to 0644. Directories within the path are
      not affected by this setting. This might be in conflict with other
      options that affect the file mode, like fsGroup, and the result can be
      other mode bits set.
    items: If unspecified, each key-value pair in the Data field of the
      referenced Secret will be projected into the volume as a file whose name
      is the key and content is the value. If specified, the listed keys will
      be projected into the specified paths, and unlisted keys will not be
      present. If a key is specified which is not present in the Secret, the
      volume setup will error unless it is marked optional.
    name: Name of the config.
    optional: Specify whether the Secret or its keys must be defined.
  """

  defaultMode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  items = _messages.MessageField('KeyToPath', 2, repeated=True)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class Configuration(_messages.Message):
  r"""Configuration represents the "floating HEAD" of a linear history of
  Revisions, and optionally how the containers those revisions reference are
  built. Users create new Revisions by updating the Configuration's spec. The
  "latest created" revision's name is available under status, as is the
  "latest ready" revision's name. See also: https://github.com/knative/serving
  /blob/master/docs/spec/overview.md#configuration

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1alpha1".
    kind: The kind of resource, in this case always "Configuration".
    metadata: Metadata associated with this Configuration, including name,
      namespace, labels, and annotations.
    spec: Spec holds the desired state of the Configuration (from the client).
    status: Status communicates the observed state of the Configuration (from
      the controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('ConfigurationSpec', 4)
  status = _messages.MessageField('ConfigurationStatus', 5)


class ConfigurationCondition(_messages.Message):
  r"""ConfigurationCondition defines a readiness condition for a
  Configuration.

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human-readable message indicating details about last transition.
      +optional
    reason: One-word CamelCase reason for the condition's last transition.
      +optional
    severity: How to interpret failures of this condition, one of Error,
      Warning, Info +optional
    status: Status of the condition, one of True, False, Unknown.
    type: ConfigurationConditionType is used to communicate the status of the
      reconciliation process. See also: https://github.com/knative/serving/blo
      b/master/docs/spec/errors.md#error-conditions-and-reporting Types
      include:"Ready"
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class ConfigurationSpec(_messages.Message):
  r"""ConfigurationSpec holds the desired state of the Configuration (from the
  client).

  Fields:
    generation: Deprecated and not currently populated by Cloud Run. See
      metadata.generation instead, which is the sequence number containing the
      latest generation of the desired state.  Read-only.
    revisionTemplate: RevisionTemplate holds the latest specification for the
      Revision to be stamped out. The template references the container image,
      and may also include labels and annotations that should be attached to
      the Revision. To correlate a Revision, and/or to force a Revision to be
      created when the spec doesn't otherwise change, a nonce label may be
      provided in the template metadata. For more details, see:
      https://github.com/knative/serving/blob/master/docs/client-
      conventions.md#associate-modifications-with-revisions  Cloud Run does
      not currently support referencing a build that is responsible for
      materializing the container image from source.
    template: Template holds the latest specification for the Revision to be
      stamped out.
  """

  generation = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  revisionTemplate = _messages.MessageField('RevisionTemplate', 2)
  template = _messages.MessageField('RevisionTemplate', 3)


class ConfigurationStatus(_messages.Message):
  r"""ConfigurationStatus communicates the observed state of the Configuration
  (from the controller).

  Fields:
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world.
    latestCreatedRevisionName: LatestCreatedRevisionName is the last revision
      that was created from this Configuration. It might not be ready yet, for
      that use LatestReadyRevisionName.
    latestReadyRevisionName: LatestReadyRevisionName holds the name of the
      latest Revision stamped out from this Configuration that has had its
      "Ready" condition become "True".
    observedGeneration: ObservedGeneration is the 'Generation' of the
      Configuration that was last processed by the controller. The observed
      generation is updated even if the controller failed to process the spec
      and create the Revision.  Clients polling for completed reconciliation
      should poll until observedGeneration = metadata.generation, and the
      Ready condition's status is True or False.
  """

  conditions = _messages.MessageField('ConfigurationCondition', 1, repeated=True)
  latestCreatedRevisionName = _messages.StringField(2)
  latestReadyRevisionName = _messages.StringField(3)
  observedGeneration = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Container(_messages.Message):
  r"""A single application container. This specifies both the container to
  run, the command to run in the container and the arguments to supply to it.
  Note that additional arguments may be supplied by the system to the
  container at runtime.

  Fields:
    args: Arguments to the entrypoint. The docker image's CMD is used if this
      is not provided. Variable references $(VAR_NAME) are expanded using the
      container's environment. If a variable cannot be resolved, the reference
      in the input string will be unchanged. The $(VAR_NAME) syntax can be
      escaped with a double $$, ie: $$(VAR_NAME). Escaped references will
      never be expanded, regardless of whether the variable exists or not.
      Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-
      data-application/define-command-argument-container/#running-a-command-
      in-a-shell +optional
    command: Entrypoint array. Not executed within a shell. The docker image's
      ENTRYPOINT is used if this is not provided. Variable references
      $(VAR_NAME) are expanded using the container's environment. If a
      variable cannot be resolved, the reference in the input string will be
      unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie:
      $$(VAR_NAME). Escaped references will never be expanded, regardless of
      whether the variable exists or not. Cannot be updated. More info:
      https://kubernetes.io/docs/tasks/inject-data-application/define-command-
      argument-container/#running-a-command-in-a-shell +optional
    env: List of environment variables to set in the container. Cannot be
      updated. +optional
    envFrom: List of sources to populate environment variables in the
      container. The keys defined within a source must be a C_IDENTIFIER. All
      invalid keys will be reported as an event when the container is
      starting. When a key exists in multiple sources, the value associated
      with the last source will take precedence. Values defined by an Env with
      a duplicate key will take precedence. Cannot be updated. +optional
    image: Docker image name. More info:
      https://kubernetes.io/docs/concepts/containers/images
    imagePullPolicy: Image pull policy. One of Always, Never, IfNotPresent.
      Defaults to Always if :latest tag is specified, or IfNotPresent
      otherwise. Cannot be updated. More info:
      https://kubernetes.io/docs/concepts/containers/images#updating-images
      +optional
    lifecycle: Actions that the management system should take in response to
      container lifecycle events. Cannot be updated. +optional
    livenessProbe: Periodic probe of container liveness. Container will be
      restarted if the probe fails. Cannot be updated. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes +optional
    name: Name of the container specified as a DNS_LABEL. Each container must
      have a unique name (DNS_LABEL). Cannot be updated.
    ports: List of ports to expose from the container. Exposing a port here
      gives the system additional information about the network connections a
      container uses, but is primarily informational. Not specifying a port
      here DOES NOT prevent that port from being exposed. Any port which is
      listening on the default "0.0.0.0" address inside a container will be
      accessible from the network. Cannot be updated. +optional
    readinessProbe: Periodic probe of container service readiness. Container
      will be removed from service endpoints if the probe fails. Cannot be
      updated. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes +optional
    resources: Compute Resources required by this container. Cannot be
      updated. More info:
      https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
      +optional
    securityContext: Security options the pod should run with. More info:
      https://kubernetes.io/docs/concepts/policy/security-context/ More info:
      https://kubernetes.io/docs/tasks/configure-pod-container/security-
      context/ +optional
    stdin: Whether this container should allocate a buffer for stdin in the
      container runtime. If this is not set, reads from stdin in the container
      will always result in EOF. Default is false. +optional
    stdinOnce: Whether the container runtime should close the stdin channel
      after it has been opened by a single attach. When stdin is true the
      stdin stream will remain open across multiple attach sessions. If
      stdinOnce is set to true, stdin is opened on container start, is empty
      until the first client attaches to stdin, and then remains open and
      accepts data until the client disconnects, at which time stdin is closed
      and remains closed until the container is restarted. If this flag is
      false, a container processes that reads from stdin will never receive an
      EOF. Default is false +optional
    terminationMessagePath: Optional: Path at which the file to which the
      container's termination message will be written is mounted into the
      container's filesystem. Message written is intended to be brief final
      status, such as an assertion failure message. Will be truncated by the
      node if greater than 4096 bytes. The total message length across all
      containers will be limited to 12kb. Defaults to /dev/termination-log.
      Cannot be updated. +optional
    terminationMessagePolicy: Indicate how the termination message should be
      populated. File will use the contents of terminationMessagePath to
      populate the container status message on both success and failure.
      FallbackToLogsOnError will use the last chunk of container log output if
      the termination message file is empty and the container exited with an
      error. The log output is limited to 2048 bytes or 80 lines, whichever is
      smaller. Defaults to File. Cannot be updated. +optional
    tty: Whether this container should allocate a TTY for itself, also
      requires 'stdin' to be true. Default is false. +optional
    volumeDevices: volumeDevices is the list of block devices to be used by
      the container. This is an alpha feature and may change in the future.
      +optional
    volumeMounts: Pod volumes to mount into the container's filesystem. Cannot
      be updated. +optional
    workingDir: Container's working directory. If not specified, the container
      runtime's default will be used, which might be configured in the
      container image. Cannot be updated. +optional
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('EnvVar', 3, repeated=True)
  envFrom = _messages.MessageField('EnvFromSource', 4, repeated=True)
  image = _messages.StringField(5)
  imagePullPolicy = _messages.StringField(6)
  lifecycle = _messages.MessageField('Lifecycle', 7)
  livenessProbe = _messages.MessageField('Probe', 8)
  name = _messages.StringField(9)
  ports = _messages.MessageField('ContainerPort', 10, repeated=True)
  readinessProbe = _messages.MessageField('Probe', 11)
  resources = _messages.MessageField('ResourceRequirements', 12)
  securityContext = _messages.MessageField('SecurityContext', 13)
  stdin = _messages.BooleanField(14)
  stdinOnce = _messages.BooleanField(15)
  terminationMessagePath = _messages.StringField(16)
  terminationMessagePolicy = _messages.StringField(17)
  tty = _messages.BooleanField(18)
  volumeDevices = _messages.MessageField('VolumeDevice', 19, repeated=True)
  volumeMounts = _messages.MessageField('VolumeMount', 20, repeated=True)
  workingDir = _messages.StringField(21)


class ContainerPort(_messages.Message):
  r"""ContainerPort represents a network port in a single container.

  Fields:
    containerPort: Number of port to expose on the pod's IP address. This must
      be a valid port number, 0 < x < 65536.
    hostIP: What host IP to bind the external port to. +optional
    hostPort: Number of port to expose on the host. If specified, this must be
      a valid port number, 0 < x < 65536. If HostNetwork is specified, this
      must match ContainerPort. Most containers do not need this. +optional
    name: If specified, this must be an IANA_SVC_NAME and unique within the
      pod. Each named port in a pod must have a unique name. Name for the port
      that can be referred to by services. +optional
    protocol: Protocol for port. Must be UDP or TCP. Defaults to "TCP".
      +optional
  """

  containerPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  hostIP = _messages.StringField(2)
  hostPort = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  name = _messages.StringField(4)
  protocol = _messages.StringField(5)


class Destination(_messages.Message):
  r"""A Destination object.

  Fields:
    ref: ObjectReference points to an Addressable. + optional
    uri: URI is for direct URI Designations or used with the resulting URL
      from Addressable ObjectReference. If used with an ObjectReference, will
      be appended to the path of the resulting URL from the Addressable. +
      optional
  """

  ref = _messages.MessageField('ObjectReference', 1)
  uri = _messages.StringField(2)


class DomainMapping(_messages.Message):
  r"""Resource to hold the state and status of a user's domain mapping.

  Fields:
    apiVersion: The API version for this call such as
      "domains.cloudrun.com/v1alpha1".
    kind: The kind of resource, in this case "DomainMapping".
    metadata: Metadata associated with this BuildTemplate.
    spec: The spec for this DomainMapping.
    status: The current status of the DomainMapping.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('DomainMappingSpec', 4)
  status = _messages.MessageField('DomainMappingStatus', 5)


class DomainMappingCondition(_messages.Message):
  r"""DomainMappingCondition contains state information for a DomainMapping.

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human readable message indicating details about the current
      status. +optional
    reason: One-word CamelCase reason for the condition's current status.
      +optional
    severity: How to interpret failures of this condition, one of Error,
      Warning, Info +optional
    status: Status of the condition, one of True, False, Unknown.
    type: Type of domain mapping condition.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class DomainMappingSpec(_messages.Message):
  r"""The desired state of the Domain Mapping.

  Enums:
    CertificateModeValueValuesEnum: The mode of the certificate.

  Fields:
    certificateMode: The mode of the certificate.
    forceOverride: If set, the mapping will override any mapping set before
      this spec was set. It is recommended that the user leaves this empty to
      receive an error warning about a potential conflict and only set it once
      the respective UI has given such a warning.
    routeName: The name of the Knative Route that this DomainMapping applies
      to. The route must exist.
  """

  class CertificateModeValueValuesEnum(_messages.Enum):
    r"""The mode of the certificate.

    Values:
      CERTIFICATE_MODE_UNSPECIFIED: <no description>
      NONE: Do not provision an HTTPS certificate.
      AUTOMATIC: Automatically provisions an HTTPS certificate via GoogleCA or
        LetsEncrypt.
    """
    CERTIFICATE_MODE_UNSPECIFIED = 0
    NONE = 1
    AUTOMATIC = 2

  certificateMode = _messages.EnumField('CertificateModeValueValuesEnum', 1)
  forceOverride = _messages.BooleanField(2)
  routeName = _messages.StringField(3)


class DomainMappingStatus(_messages.Message):
  r"""The current state of the Domain Mapping.

  Fields:
    conditions: Array of observed DomainMappingConditions, indicating the
      current state of the DomainMapping.
    mappedRouteName: The name of the route that the mapping currently points
      to.
    observedGeneration: ObservedGeneration is the 'Generation' of the
      DomainMapping that was last processed by the controller.  Clients
      polling for completed reconciliation should poll until
      observedGeneration = metadata.generation and the Ready condition's
      status is True or False.
    resourceRecords: The resource records required to configure this domain
      mapping. These records must be added to the domain's DNS configuration
      in order to serve the application via this domain mapping.
    url: Cloud Run fully managed: not supported  Cloud Run on GKE: supported
      Holds the URL that will serve the traffic of the DomainMapping.
      +optional
  """

  conditions = _messages.MessageField('DomainMappingCondition', 1, repeated=True)
  mappedRouteName = _messages.StringField(2)
  observedGeneration = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourceRecords = _messages.MessageField('ResourceRecord', 4, repeated=True)
  url = _messages.StringField(5)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class EnvFromSource(_messages.Message):
  r"""EnvFromSource represents the source of a set of ConfigMaps

  Fields:
    configMapRef: The ConfigMap to select from +optional
    prefix: An optional identifier to prepend to each key in the ConfigMap.
      Must be a C_IDENTIFIER. +optional
    secretRef: The Secret to select from +optional
  """

  configMapRef = _messages.MessageField('ConfigMapEnvSource', 1)
  prefix = _messages.StringField(2)
  secretRef = _messages.MessageField('SecretEnvSource', 3)


class EnvVar(_messages.Message):
  r"""EnvVar represents an environment variable present in a Container.

  Fields:
    name: Name of the environment variable. Must be a C_IDENTIFIER.
    value: Variable references $(VAR_NAME) are expanded using the previous
      defined environment variables in the container and any route environment
      variables. If a variable cannot be resolved, the reference in the input
      string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
      double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
      regardless of whether the variable exists or not. Defaults to "".
      +optional
    valueFrom: Cloud Run fully managed: not supported  Cloud Run on GKE:
      supported  Source for the environment variable's value. Cannot be used
      if value is not empty. +optional
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)
  valueFrom = _messages.MessageField('EnvVarSource', 3)


class EnvVarSource(_messages.Message):
  r"""Cloud Run fully managed: not supported  Cloud Run on GKE: supported
  EnvVarSource represents a source for the value of an EnvVar.

  Fields:
    configMapKeyRef: Cloud Run fully managed: not supported  Cloud Run on GKE:
      supported  Selects a key of a ConfigMap. +optional
    secretKeyRef: Cloud Run fully managed: not supported  Cloud Run on GKE:
      supported  Selects a key of a secret in the pod's namespace +optional
  """

  configMapKeyRef = _messages.MessageField('ConfigMapKeySelector', 1)
  secretKeyRef = _messages.MessageField('SecretKeySelector', 2)


class ExecAction(_messages.Message):
  r"""ExecAction describes a "run in container" action.

  Fields:
    command: Command is the command line to execute inside the container, the
      working directory for the command  is root ('/') in the container's
      filesystem. The command is simply exec'd, it is not run inside a shell,
      so traditional shell instructions ('|', etc) won't work. To use a shell,
      you need to explicitly call out to that shell. Exit status of 0 is
      treated as live/healthy and non-zero is unhealthy. +optional
  """

  command = _messages.StringField(1)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.  Example (Comparison):
  title: "Summary size limit"     description: "Determines if a summary is
  less than 100 chars"     expression: "document.summary.size() < 100"
  Example (Equality):      title: "Requestor is owner"     description:
  "Determines if requestor is the document owner"     expression:
  "document.owner == request.auth.claims.email"  Example (Logic):      title:
  "Public documents"     description: "Determine whether the document should
  be publicly visible"     expression: "document.type != 'private' &&
  document.type != 'internal'"  Example (Data Manipulation):      title:
  "Notification string"     description: "Create a notification string with a
  timestamp."     expression: "'New message received at ' +
  string(document.create_time)"  The exact variables and functions that may be
  referenced within an expression are determined by the service that evaluates
  it. See the service documentation for additional information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class HTTPGetAction(_messages.Message):
  r"""HTTPGetAction describes an action based on HTTP Get requests.

  Fields:
    host: Host name to connect to, defaults to the pod IP. You probably want
      to set "Host" in httpHeaders instead. +optional
    httpHeaders: Custom headers to set in the request. HTTP allows repeated
      headers. +optional
    path: Path to access on the HTTP server. +optional
    port: Name or number of the port to access on the container. Number must
      be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    scheme: Scheme to use for connecting to the host. Defaults to HTTP.
      +optional
  """

  host = _messages.StringField(1)
  httpHeaders = _messages.MessageField('HTTPHeader', 2, repeated=True)
  path = _messages.StringField(3)
  port = _messages.MessageField('IntOrString', 4)
  scheme = _messages.StringField(5)


class HTTPHeader(_messages.Message):
  r"""HTTPHeader describes a custom header to be used in HTTP probes

  Fields:
    name: The header field name
    value: The header field value
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class Handler(_messages.Message):
  r"""Handler defines a specific action that should be taken

  Fields:
    exec_: One and only one of the following should be specified. Exec
      specifies the action to take. +optional
    httpGet: HTTPGet specifies the http request to perform. +optional
    tcpSocket: TCPSocket specifies an action involving a TCP port. TCP hooks
      not yet supported
  """

  exec_ = _messages.MessageField('ExecAction', 1)
  httpGet = _messages.MessageField('HTTPGetAction', 2)
  tcpSocket = _messages.MessageField('TCPSocketAction', 3)


class IntOrString(_messages.Message):
  r"""IntOrString is a type that can hold an int32 or a string.  When used in
  JSON or YAML marshalling and unmarshalling, it produces or consumes the
  inner type.  This allows you to have, for example, a JSON field that can
  accept a name or number.

  Fields:
    intVal: The int value.
    strVal: The string value.
    type: The type of the value.
  """

  intVal = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  strVal = _messages.StringField(2)
  type = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class KeyToPath(_messages.Message):
  r"""Maps a string key to a path within a volume.

  Fields:
    key: The key to project.
    mode: Mode bits to use on this file, must be a value between 0 and 0777.
      If not specified, the volume defaultMode will be used. This might be in
      conflict with other options that affect the file mode, like fsGroup, and
      the result can be other mode bits set. +optional
    path: The relative path of the file to map the key to. May not be an
      absolute path. May not contain the path element '..'. May not start with
      the string '..'.
  """

  key = _messages.StringField(1)
  mode = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  path = _messages.StringField(3)


class Lifecycle(_messages.Message):
  r"""Lifecycle describes actions that the management system should take in
  response to container lifecycle events. For the PostStart and PreStop
  lifecycle handlers, management of the container blocks until the action is
  complete, unless the container process fails, in which case the handler is
  aborted.

  Fields:
    postStart: PostStart is called immediately after a container is created.
      If the handler fails, the container is terminated and restarted
      according to its restart policy. Other management of the container
      blocks until the hook completes. More info:
      https://kubernetes.io/docs/concepts/containers/container-lifecycle-
      hooks/#container-hooks +optional
    preStop: PreStop is called immediately before a container is terminated.
      The container is terminated after the handler completes. The reason for
      termination is passed to the handler. Regardless of the outcome of the
      handler, the container is eventually terminated. Other management of the
      container blocks until the hook completes. More info:
      https://kubernetes.io/docs/concepts/containers/container-lifecycle-
      hooks/#container-hooks +optional
  """

  postStart = _messages.MessageField('Handler', 1)
  preStop = _messages.MessageField('Handler', 2)


class ListAuthorizedDomainsResponse(_messages.Message):
  r"""A list of Authorized Domains.

  Fields:
    domains: The authorized domains belonging to the user.
    nextPageToken: Continuation token for fetching the next page of results.
  """

  domains = _messages.MessageField('AuthorizedDomain', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListCloudAuditLogsSourcesResponse(_messages.Message):
  r"""ListCloudAuditLogsSourcesResponse is a list of CloudAuditLogsSource
  resources.

  Fields:
    apiVersion: The API version for this call such as
      "events.cloud.google.com/v1alpha1".
    items: List of CloudAuditLogsSources.
    kind: The kind of this resource, in this case "CloudAuditLogsSourceList".
    metadata: Metadata associated with this CloudAuditLogsSource list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('CloudAuditLogsSource', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListCloudPubSubSourcesResponse(_messages.Message):
  r"""ListCloudPubSubSourcesResponse is a list of CloudPubSubSource resources.

  Fields:
    apiVersion: The API version for this call such as
      "events.cloud.google.com/v1alpha1".
    items: List of CloudPubSubSources.
    kind: The kind of this resource, in this case "CloudPubSubSourceList".
    metadata: Metadata associated with this CloudPubSubSource list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('CloudPubSubSource', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListCloudSchedulerSourcesResponse(_messages.Message):
  r"""ListCloudSchedulerSourcesResponse is a list of CloudSchedulerSource
  resources.

  Fields:
    apiVersion: The API version for this call such as
      "events.cloud.google.com/v1alpha1".
    items: List of CloudSchedulerSources.
    kind: The kind of this resource, in this case "CloudSchedulerSourceList".
    metadata: Metadata associated with this CloudSchedulerSource list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('CloudSchedulerSource', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListCloudStorageSourcesResponse(_messages.Message):
  r"""ListCloudStorageSourcesResponse is a list of CloudStorageSource
  resources.

  Fields:
    apiVersion: The API version for this call such as
      "events.cloud.google.com/v1alpha1".
    items: List of CloudStorageSources.
    kind: The kind of this resource, in this case "CloudStorageSourceList".
    metadata: Metadata associated with this CloudStorageSource list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('CloudStorageSource', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListConfigurationsResponse(_messages.Message):
  r"""ListConfigurationsResponse is a list of Configuration resources.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1alpha1".
    items: List of Configurations.
    kind: The kind of this resource, in this case "ConfigurationList".
    metadata: Metadata associated with this Configuration list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Configuration', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListDomainMappingsResponse(_messages.Message):
  r"""ListDomainMappingsResponse is a list of DomainMapping resources.

  Fields:
    apiVersion: The API version for this call such as
      "domains.cloudrun.com/v1alpha1".
    items: List of DomainMappings.
    kind: The kind of this resource, in this case "DomainMappingList".
    metadata: Metadata associated with this DomainMapping list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('DomainMapping', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMeta(_messages.Message):
  r"""ListMeta describes metadata that synthetic resources must have,
  including lists and various status objects. A resource may have only one of
  {ObjectMeta, ListMeta}.

  Fields:
    continue_: continue may be set if the user set a limit on the number of
      items returned, and indicates that the server has more data available.
      The value is opaque and may be used to issue another request to the
      endpoint that served this list to retrieve the next set of available
      objects. Continuing a list may not be possible if the server
      configuration has changed or more than a few minutes have passed. The
      resourceVersion field returned when using this continue value will be
      identical to the value in the first response.
    resourceVersion: String that identifies the server's internal version of
      this object that can be used by clients to determine when objects have
      changed. Value must be treated as opaque by clients and passed
      unmodified back to the server. Populated by the system. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional
  """

  continue_ = _messages.StringField(1)
  resourceVersion = _messages.StringField(2)
  selfLink = _messages.StringField(3)


class ListRevisionsResponse(_messages.Message):
  r"""ListRevisionsResponse is a list of Revision resources.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1alpha1".
    items: List of Revisions.
    kind: The kind of this resource, in this case "RevisionList".
    metadata: Metadata associated with this revision list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Revision', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListRoutesResponse(_messages.Message):
  r"""ListRoutesResponse is a list of Route resources.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1alpha1".
    items: List of Routes.
    kind: The kind of this resource, in this case always "RouteList".
    metadata: Metadata associated with this Route list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Route', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListServicesResponse(_messages.Message):
  r"""A list of Service resources.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1alpha1".
    items: List of Services.
    kind: The kind of this resource, in this case "ServiceList".
    metadata: Metadata associated with this Service list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Service', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListTriggersResponse(_messages.Message):
  r"""ListTriggersResponse is a list of Trigger resources.

  Fields:
    apiVersion: The API version for this call such as
      "eventing.knative.dev/v1alpha1".
    items: List of Triggers.
    kind: The kind of this resource, in this case "TriggerList".
    metadata: Metadata associated with this Trigger list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Trigger', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class LocalObjectReference(_messages.Message):
  r"""LocalObjectReference contains enough information to let you locate the
  referenced object inside the same namespace.

  Fields:
    name: Name of the referent. More info:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/#names
  """

  name = _messages.StringField(1)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ObjectMeta(_messages.Message):
  r"""ObjectMeta is metadata that all persisted resources must have, which
  includes all objects users must create.

  Messages:
    AnnotationsValue: Annotations is an unstructured key value map stored with
      a resource that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. More info: http://kubernetes.io/docs/user-
      guide/annotations +optional
    LabelsValue: Map of string keys and values that can be used to organize
      and categorize (scope and select) objects. May match selectors of
      replication controllers and routes. More info:
      http://kubernetes.io/docs/user-guide/labels +optional

  Fields:
    annotations: Annotations is an unstructured key value map stored with a
      resource that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. More info: http://kubernetes.io/docs/user-
      guide/annotations +optional
    clusterName: Not currently supported by Cloud Run.  The name of the
      cluster which the object belongs to. This is used to distinguish
      resources with same name and namespace in different clusters. This field
      is not set anywhere right now and apiserver is going to ignore it if set
      in create or update request. +optional
    creationTimestamp: CreationTimestamp is a timestamp representing the
      server time when this object was created. It is not guaranteed to be set
      in happens-before order across separate operations. Clients may not set
      this value. It is represented in RFC3339 form and is in UTC.  Populated
      by the system. Read-only. Null for lists. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    deletionGracePeriodSeconds: Not currently supported by Cloud Run.  Number
      of seconds allowed for this object to gracefully terminate before it
      will be removed from the system. Only set when deletionTimestamp is also
      set. May only be shortened. Read-only. +optional
    deletionTimestamp: DeletionTimestamp is RFC 3339 date and time at which
      this resource will be deleted. This field is set by the server when a
      graceful deletion is requested by the user, and is not directly settable
      by a client. The resource is expected to be deleted (no longer visible
      from resource lists, and not reachable by name) after the time in this
      field, once the finalizers list is empty. As long as the finalizers list
      contains items, deletion is blocked. Once the deletionTimestamp is set,
      this value may not be unset or be set further into the future, although
      it may be shortened or the resource may be deleted prior to this time.
      For example, a user may request that a pod is deleted in 30 seconds. The
      Kubelet will react by sending a graceful termination signal to the
      containers in the pod. After that 30 seconds, the Kubelet will send a
      hard termination signal (SIGKILL) to the container and after cleanup,
      remove the pod from the API. In the presence of network partitions, this
      object may still exist after this timestamp, until an administrator or
      automated process can determine the resource is fully terminated. If not
      set, graceful deletion of the object has not been requested.  Populated
      by the system when a graceful deletion is requested. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    finalizers: Not currently supported by Cloud Run.  Must be empty before
      the object is deleted from the registry. Each entry is an identifier for
      the responsible component that will remove the entry from the list. If
      the deletionTimestamp of the object is non-nil, entries in this list can
      only be removed. +optional +patchStrategy=merge
    generateName: Not currently supported by Cloud Run.  GenerateName is an
      optional prefix, used by the server, to generate a unique name ONLY IF
      the Name field has not been provided. If this field is used, the name
      returned to the client will be different than the name passed. This
      value will also be combined with a unique suffix. The provided value has
      the same validation rules as the Name field, and may be truncated by the
      length of the suffix required to make the value unique on the server.
      If this field is specified and the generated name exists, the server
      will NOT return a 409 - instead, it will either return 201 Created or
      500 with Reason ServerTimeout indicating a unique name could not be
      found in the time allotted, and the client should retry (optionally
      after the time indicated in the Retry-After header).  Applied only if
      Name is not specified. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#idempotency +optional  string generateName = 2;
    generation: A sequence number representing a specific generation of the
      desired state. Populated by the system. Read-only. +optional
    labels: Map of string keys and values that can be used to organize and
      categorize (scope and select) objects. May match selectors of
      replication controllers and routes. More info:
      http://kubernetes.io/docs/user-guide/labels +optional
    name: Name must be unique within a namespace, within a Cloud Run region.
      Is required when creating resources, although some resources may allow a
      client to request the generation of an appropriate name automatically.
      Name is primarily intended for creation idempotence and configuration
      definition. Cannot be updated. More info:
      http://kubernetes.io/docs/user-guide/identifiers#names +optional
    namespace: Namespace defines the space within each name must be unique,
      within a Cloud Run region. In Cloud Run the namespace must be equal to
      either the project ID or project number.
    ownerReferences: List of objects that own this object. If ALL objects in
      the list have been deleted, this object will be garbage collected.
      +optional
    resourceVersion: An opaque value that represents the internal version of
      this object that can be used by clients to determine when objects have
      changed. May be used for optimistic concurrency, change detection, and
      the watch operation on a resource or set of resources. Clients must
      treat these values as opaque and passed unmodified back to the server.
      They may only be valid for a particular resource or set of resources.
      Populated by the system. Read-only. Value must be treated as opaque by
      clients and . More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional  string selfLink = 4;
    uid: UID is the unique in time and space value for this object. It is
      typically generated by the server on successful creation of a resource
      and is not allowed to change on PUT operations.  Populated by the
      system. Read-only. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids +optional
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations is an unstructured key value map stored with a resource
    that may be set by external tools to store and retrieve arbitrary
    metadata. They are not queryable and should be preserved when modifying
    objects. More info: http://kubernetes.io/docs/user-guide/annotations
    +optional

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Map of string keys and values that can be used to organize and
    categorize (scope and select) objects. May match selectors of replication
    controllers and routes. More info: http://kubernetes.io/docs/user-
    guide/labels +optional

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  clusterName = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  deletionGracePeriodSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  deletionTimestamp = _messages.StringField(5)
  finalizers = _messages.StringField(6, repeated=True)
  generateName = _messages.StringField(7)
  generation = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 9)
  name = _messages.StringField(10)
  namespace = _messages.StringField(11)
  ownerReferences = _messages.MessageField('OwnerReference', 12, repeated=True)
  resourceVersion = _messages.StringField(13)
  selfLink = _messages.StringField(14)
  uid = _messages.StringField(15)


class ObjectReference(_messages.Message):
  r"""ObjectReference contains enough information to let you inspect or modify
  the referred object.

  Fields:
    apiVersion: API version of the referent. +optional
    fieldPath: If referring to a piece of an object instead of an entire
      object, this string should contain a valid JSON/Go field access
      statement, such as desiredState.manifest.containers[2]. For example, if
      the object reference is to a container within a pod, this would take on
      a value like: "spec.containers{name}" (where "name" refers to the name
      of the container that triggered the event) or if no container name is
      specified "spec.containers[2]" (container with index 2 in this pod).
      This syntax is chosen only to have some well-defined way of referencing
      a part of an object.
    kind: Kind of the referent. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#types-kinds +optional
    name: Name of the referent. More info:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/#names +optional
    namespace: Namespace of the referent. More info:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/namespaces/ +optional
    resourceVersion: Specific resourceVersion to which this reference is made,
      if any. More info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#concurrency-control-and-consistency +optional
    uid: UID of the referent. More info:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/#uids +optional
  """

  apiVersion = _messages.StringField(1)
  fieldPath = _messages.StringField(2)
  kind = _messages.StringField(3)
  name = _messages.StringField(4)
  namespace = _messages.StringField(5)
  resourceVersion = _messages.StringField(6)
  uid = _messages.StringField(7)


class OwnerReference(_messages.Message):
  r"""OwnerReference contains enough information to let you identify an owning
  object. Currently, an owning object must be in the same namespace, so there
  is no namespace field.

  Fields:
    apiVersion: API version of the referent.
    blockOwnerDeletion: If true, AND if the owner has the "foregroundDeletion"
      finalizer, then the owner cannot be deleted from the key-value store
      until this reference is removed. Defaults to false. To set this field, a
      user needs "delete" permission of the owner, otherwise 422
      (Unprocessable Entity) will be returned. +optional
    controller: If true, this reference points to the managing controller.
      +optional
    kind: Kind of the referent. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#types-kinds
    name: Name of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#names
    uid: UID of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  apiVersion = _messages.StringField(1)
  blockOwnerDeletion = _messages.BooleanField(2)
  controller = _messages.BooleanField(3)
  kind = _messages.StringField(4)
  name = _messages.StringField(5)
  uid = _messages.StringField(6)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.   A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role.  For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies).  **JSON example:**      {       "bindings": [         {
  "role": "roles/resourcemanager.organizationAdmin",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/resourcemanager.organizationViewer",           "members": [
  "user:eve@example.com"           ],           "condition": {
  "title": "expirable access",             "description": "Does not grant
  access after Sep 2020",             "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",           }         }       ],
  "etag": "BwWWja0YfJA=",       "version": 3     }  **YAML example:**
  bindings:     - members:       - user:mike@example.com       -
  group:admins@example.com       - domain:google.com       -
  serviceAccount:my-project-id@appspot.gserviceaccount.com       role:
  roles/resourcemanager.organizationAdmin     - members:       -
  user:eve@example.com       role: roles/resourcemanager.organizationViewer
  condition:         title: expirable access         description: Does not
  grant access after Sep 2020         expression: request.time <
  timestamp('2020-10-01T00:00:00.000Z')     - etag: BwWWja0YfJA=     -
  version: 3  For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy.  Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected.  Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations:  * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy   that includes conditions  **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost.  If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset.  To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Probe(_messages.Message):
  r"""Probe describes a health check to be performed against a container to
  determine whether it is alive or ready to receive traffic.

  Fields:
    failureThreshold: Minimum consecutive failures for the probe to be
      considered failed after having succeeded. Defaults to 3. Minimum value
      is 1. +optional
    handler: The action taken to determine the health of a container
    initialDelaySeconds: Number of seconds after the container has started
      before liveness probes are initiated. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes +optional
    periodSeconds: How often (in seconds) to perform the probe. Default to 10
      seconds. Minimum value is 1. +optional
    successThreshold: Minimum consecutive successes for the probe to be
      considered successful after having failed. Defaults to 1. Must be 1 for
      liveness. Minimum value is 1. +optional
    timeoutSeconds: Number of seconds after which the probe times out.
      Defaults to 1 second. Minimum value is 1. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes +optional
  """

  failureThreshold = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  handler = _messages.MessageField('Handler', 2)
  initialDelaySeconds = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  periodSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  successThreshold = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  timeoutSeconds = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class Quantity(_messages.Message):
  r"""The view model of a single quantity, e.g. "800 MiB". Corresponds to http
  s://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachi
  nery/pkg/api/resource/generated.proto

  Fields:
    string: Stringified version of the quantity, e.g., "800 MiB".
  """

  string = _messages.StringField(1)


class ResourceRecord(_messages.Message):
  r"""A DNS resource record.

  Enums:
    TypeValueValuesEnum: Resource record type. Example: `AAAA`.

  Fields:
    name: Relative name of the object affected by this record. Only applicable
      for `CNAME` records. Example: 'www'.
    rrdata: Data for this record. Values vary by record type, as defined in
      RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
    type: Resource record type. Example: `AAAA`.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Resource record type. Example: `AAAA`.

    Values:
      RECORD_TYPE_UNSPECIFIED: An unknown resource record.
      A: An A resource record. Data is an IPv4 address.
      AAAA: An AAAA resource record. Data is an IPv6 address.
      CNAME: A CNAME resource record. Data is a domain name to be aliased.
    """
    RECORD_TYPE_UNSPECIFIED = 0
    A = 1
    AAAA = 2
    CNAME = 3

  name = _messages.StringField(1)
  rrdata = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class ResourceRequirements(_messages.Message):
  r"""ResourceRequirements describes the compute resource requirements.

  Messages:
    LimitsValue: Limits describes the maximum amount of compute resources
      allowed. The values of the map is string form of the 'quantity' k8s
      type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k
      8s.io/apimachinery/pkg/api/resource/quantity.go
    LimitsInMapValue: Limits describes the maximum amount of compute resources
      allowed. This is a temporary field created to migrate away from the
      map<string, Quantity> limits field. This is done to become compliant
      with k8s style API. This field is deprecated in favor of limits field.
    RequestsValue: Requests describes the minimum amount of compute resources
      required. If Requests is omitted for a container, it defaults to Limits
      if that is explicitly specified, otherwise to an implementation-defined
      value. The values of the map is string form of the 'quantity' k8s type:
      https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/
      apimachinery/pkg/api/resource/quantity.go
    RequestsInMapValue: Requests describes the minimum amount of compute
      resources required. If Requests is omitted for a container, it defaults
      to Limits if that is explicitly specified, otherwise to an
      implementation-defined value. This is a temporary field created to
      migrate away from the map<string, Quantity> requests field. This is done
      to become compliant with k8s style API. This field is deprecated in
      favor of requests field.

  Fields:
    limits: Limits describes the maximum amount of compute resources allowed.
      The values of the map is string form of the 'quantity' k8s type: https:/
      /github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimach
      inery/pkg/api/resource/quantity.go
    limitsInMap: Limits describes the maximum amount of compute resources
      allowed. This is a temporary field created to migrate away from the
      map<string, Quantity> limits field. This is done to become compliant
      with k8s style API. This field is deprecated in favor of limits field.
    requests: Requests describes the minimum amount of compute resources
      required. If Requests is omitted for a container, it defaults to Limits
      if that is explicitly specified, otherwise to an implementation-defined
      value. The values of the map is string form of the 'quantity' k8s type:
      https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/
      apimachinery/pkg/api/resource/quantity.go
    requestsInMap: Requests describes the minimum amount of compute resources
      required. If Requests is omitted for a container, it defaults to Limits
      if that is explicitly specified, otherwise to an implementation-defined
      value. This is a temporary field created to migrate away from the
      map<string, Quantity> requests field. This is done to become compliant
      with k8s style API. This field is deprecated in favor of requests field.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LimitsInMapValue(_messages.Message):
    r"""Limits describes the maximum amount of compute resources allowed. This
    is a temporary field created to migrate away from the map<string,
    Quantity> limits field. This is done to become compliant with k8s style
    API. This field is deprecated in favor of limits field.

    Messages:
      AdditionalProperty: An additional property for a LimitsInMapValue
        object.

    Fields:
      additionalProperties: Additional properties of type LimitsInMapValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LimitsInMapValue object.

      Fields:
        key: Name of the additional property.
        value: A Quantity attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Quantity', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LimitsValue(_messages.Message):
    r"""Limits describes the maximum amount of compute resources allowed. The
    values of the map is string form of the 'quantity' k8s type: https://githu
    b.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pk
    g/api/resource/quantity.go

    Messages:
      AdditionalProperty: An additional property for a LimitsValue object.

    Fields:
      additionalProperties: Additional properties of type LimitsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LimitsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestsInMapValue(_messages.Message):
    r"""Requests describes the minimum amount of compute resources required.
    If Requests is omitted for a container, it defaults to Limits if that is
    explicitly specified, otherwise to an implementation-defined value. This
    is a temporary field created to migrate away from the map<string,
    Quantity> requests field. This is done to become compliant with k8s style
    API. This field is deprecated in favor of requests field.

    Messages:
      AdditionalProperty: An additional property for a RequestsInMapValue
        object.

    Fields:
      additionalProperties: Additional properties of type RequestsInMapValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestsInMapValue object.

      Fields:
        key: Name of the additional property.
        value: A Quantity attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Quantity', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestsValue(_messages.Message):
    r"""Requests describes the minimum amount of compute resources required.
    If Requests is omitted for a container, it defaults to Limits if that is
    explicitly specified, otherwise to an implementation-defined value. The
    values of the map is string form of the 'quantity' k8s type: https://githu
    b.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pk
    g/api/resource/quantity.go

    Messages:
      AdditionalProperty: An additional property for a RequestsValue object.

    Fields:
      additionalProperties: Additional properties of type RequestsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  limits = _messages.MessageField('LimitsValue', 1)
  limitsInMap = _messages.MessageField('LimitsInMapValue', 2)
  requests = _messages.MessageField('RequestsValue', 3)
  requestsInMap = _messages.MessageField('RequestsInMapValue', 4)


class Revision(_messages.Message):
  r"""Revision is an immutable snapshot of code and configuration.  A revision
  references a container image. Revisions are created by updates to a
  Configuration.  Cloud Run does not currently support referencing a build
  that is responsible for materializing the container image from source.  See
  also: https://github.com/knative/serving/blob/master/docs/spec/overview.md#r
  evision

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1alpha1".
    kind: The kind of this resource, in this case "Revision".
    metadata: Metadata associated with this Revision, including name,
      namespace, labels, and annotations.
    spec: Spec holds the desired state of the Revision (from the client).
    status: Status communicates the observed state of the Revision (from the
      controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('RevisionSpec', 4)
  status = _messages.MessageField('RevisionStatus', 5)


class RevisionCondition(_messages.Message):
  r"""RevisionCondition defines a readiness condition for a Revision.

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human readable message indicating details about the current
      status. +optional
    reason: One-word CamelCase reason for the condition's last transition.
      +optional
    severity: How to interpret failures of this condition, one of Error,
      Warning, Info +optional
    status: Status of the condition, one of True, False, Unknown.
    type: RevisionConditionType is used to communicate the status of the
      reconciliation process. See also: https://github.com/knative/serving/blo
      b/master/docs/spec/errors.md#error-conditions-and-reporting Types
      include:  * "Ready": True when the Revision is ready. *
      "ResourcesAvailable": True when underlying resources have been
      provisioned. * "ContainerHealthy": True when the Revision readiness
      check completes. * "Active": True when the Revision may receive traffic.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class RevisionSpec(_messages.Message):
  r"""RevisionSpec holds the desired state of the Revision (from the client).

  Enums:
    ServingStateValueValuesEnum: ServingState holds a value describing the
      state the resources are in for this Revision. Users must not specify
      this when creating a revision. It is expected that the system will
      manipulate this based on routability and load.  Populated by the system.
      Read-only.

  Fields:
    concurrencyModel: ConcurrencyModel specifies the desired concurrency model
      (Single or Multi) for the Revision. Defaults to Multi. Deprecated in
      favor of ContainerConcurrency. +optional
    container: Container defines the unit of execution for this Revision. In
      the context of a Revision, we disallow a number of the fields of this
      Container, including: name, ports, and volumeMounts. The runtime
      contract is documented here:
      https://github.com/knative/serving/blob/master/docs/runtime-contract.md
    containerConcurrency: (Optional)  ContainerConcurrency specifies the
      maximum allowed in-flight (concurrent) requests per container instance
      of the Revision.  Cloud Run fully managed: supported, defaults to 80
      Cloud Run on GKE: supported, defaults to 0, which means concurrency to
      the application is not limited, and the system decides the target
      concurrency for the autoscaler.
    containers: Containers holds the single container that defines the unit of
      execution for this Revision. In the context of a Revision, we disallow a
      number of fields on this Container, including: name and lifecycle. In
      Cloud Run, only a single container may be provided.
    generation: Deprecated and not currently populated by Cloud Run. See
      metadata.generation instead, which is the sequence number containing the
      latest generation of the desired state.  Read-only.
    serviceAccountName: Email address of the IAM service account associated
      with the revision of the service. The service account represents the
      identity of the running revision, and determines what permissions the
      revision has. If not provided, the revision will use the project's
      default service account.
    servingState: ServingState holds a value describing the state the
      resources are in for this Revision. Users must not specify this when
      creating a revision. It is expected that the system will manipulate this
      based on routability and load.  Populated by the system. Read-only.
    timeoutSeconds: TimeoutSeconds holds the max duration the instance is
      allowed for responding to a request. Not currently used by Cloud Run.
    volumes: A Volume attribute.
  """

  class ServingStateValueValuesEnum(_messages.Enum):
    r"""ServingState holds a value describing the state the resources are in
    for this Revision. Users must not specify this when creating a revision.
    It is expected that the system will manipulate this based on routability
    and load.  Populated by the system. Read-only.

    Values:
      REVISION_SERVING_STATE_UNSPECIFIED: The revision serving state hasn't
        been specified.
      ACTIVE: The revision is ready to serve traffic.
      RESERVE: The revision is not currently serving traffic, but could be
        made to serve traffic quickly. Not currently used by Cloud Run.
      RETIRED: The revision has been decommissioned and is not needed to serve
        traffic anymore. A Revision may be brought out of retirement, but it
        may take longer than it would from a "Reserve" state.
    """
    REVISION_SERVING_STATE_UNSPECIFIED = 0
    ACTIVE = 1
    RESERVE = 2
    RETIRED = 3

  concurrencyModel = _messages.StringField(1)
  container = _messages.MessageField('Container', 2)
  containerConcurrency = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  containers = _messages.MessageField('Container', 4, repeated=True)
  generation = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  serviceAccountName = _messages.StringField(6)
  servingState = _messages.EnumField('ServingStateValueValuesEnum', 7)
  timeoutSeconds = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  volumes = _messages.MessageField('Volume', 9, repeated=True)


class RevisionStatus(_messages.Message):
  r"""RevisionStatus communicates the observed state of the Revision (from the
  controller).

  Fields:
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world.  As a Revision is being prepared, it will
      incrementally update conditions "ResourcesAvailable",
      "ContainerHealthy", and "Active", which contribute to the overall
      "Ready" condition.
    imageDigest: ImageDigest holds the resolved digest for the image specified
      within .Spec.Container.Image. The digest is resolved during the creation
      of Revision. This field holds the digest value regardless of whether a
      tag or digest was originally specified in the Container object.
    logUrl: Specifies the generated logging url for this particular revision
      based on the revision url template specified in the controller's config.
      +optional
    observedGeneration: ObservedGeneration is the 'Generation' of the Revision
      that was last processed by the controller.  Clients polling for
      completed reconciliation should poll until observedGeneration =
      metadata.generation, and the Ready condition's status is True or False.
    serviceName: Not currently used by Cloud Run.
  """

  conditions = _messages.MessageField('RevisionCondition', 1, repeated=True)
  imageDigest = _messages.StringField(2)
  logUrl = _messages.StringField(3)
  observedGeneration = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  serviceName = _messages.StringField(5)


class RevisionTemplate(_messages.Message):
  r"""RevisionTemplateSpec describes the data a revision should have when
  created from a template. Based on:
  https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190

  Fields:
    metadata: Optional metadata for this Revision, including labels and
      annotations. Name will be generated by the Configuration. To set minimum
      instances for this revision, use the "autoscaling.knative.dev/minScale"
      annotation key. (Cloud Run on GKE only). To set maximum instances for
      this revision, use the "autoscaling.knative.dev/maxScale" annotation
      key. To set Cloud SQL connections for the revision, use the
      "run.googleapis.com/cloudsql-instances" annotation key. Values should be
      comma separated.
    spec: RevisionSpec holds the desired state of the Revision (from the
      client).
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  spec = _messages.MessageField('RevisionSpec', 2)


class Route(_messages.Message):
  r"""Route is responsible for configuring ingress over a collection of
  Revisions. Some of the Revisions a Route distributes traffic over may be
  specified by referencing the Configuration responsible for creating them; in
  these cases the Route is additionally responsible for monitoring the
  Configuration for "latest ready" revision changes, and smoothly rolling out
  latest revisions. See also:
  https://github.com/knative/serving/blob/master/docs/spec/overview.md#route
  Cloud Run currently supports referencing a single Configuration to
  automatically deploy the "latest ready" Revision from that Configuration.

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1alpha1".
    kind: The kind of this resource, in this case always "Route".
    metadata: Metadata associated with this Route, including name, namespace,
      labels, and annotations.
    spec: Spec holds the desired state of the Route (from the client).
    status: Status communicates the observed state of the Route (from the
      controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('RouteSpec', 4)
  status = _messages.MessageField('RouteStatus', 5)


class RouteCondition(_messages.Message):
  r"""RouteCondition defines a readiness condition for a Route.

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human-readable message indicating details about last transition.
      +optional
    reason: One-word CamelCase reason for the condition's last transition.
      +optional
    severity: How to interpret failures of this condition, one of Error,
      Warning, Info +optional
    status: Status of the condition, one of "True", "False", "Unknown".
    type: RouteConditionType is used to communicate the status of the
      reconciliation process. See also: https://github.com/knative/serving/blo
      b/master/docs/spec/errors.md#error-conditions-and-reporting Types
      include: "Ready".
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class RouteSpec(_messages.Message):
  r"""RouteSpec holds the desired state of the Route (from the client).

  Fields:
    generation: Deprecated and not currently populated by Cloud Run. See
      metadata.generation instead, which is the sequence number containing the
      latest generation of the desired state.  Read-only.
    traffic: Traffic specifies how to distribute traffic over a collection of
      Knative Revisions and Configurations. Cloud Run currently supports a
      single configurationName.
  """

  generation = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  traffic = _messages.MessageField('TrafficTarget', 2, repeated=True)


class RouteStatus(_messages.Message):
  r"""RouteStatus communicates the observed state of the Route (from the
  controller).

  Fields:
    address: Similar to url, information on where the service is available on
      HTTP.
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world.
    domain: Deprecated - use url instead. Domain holds the top-level domain
      that will distribute traffic over the provided targets.
    domainInternal: Deprecated - use address instead. For Cloud Run,
      identifical to domain.
    observedGeneration: ObservedGeneration is the 'Generation' of the Route
      that was last processed by the controller.  Clients polling for
      completed reconciliation should poll until observedGeneration =
      metadata.generation and the Ready condition's status is True or False.
      Note that providing a trafficTarget that only has a configurationName
      will result in a Route that does not increment either its
      metadata.generation or its observedGeneration, as new "latest ready"
      revisions from the Configuration are processed without an update to the
      Route's spec.
    traffic: Traffic holds the configured traffic distribution. These entries
      will always contain RevisionName references. When ConfigurationName
      appears in the spec, this will hold the LatestReadyRevisionName that we
      last observed.
    url: URL holds the url that will distribute traffic over the provided
      traffic targets. It generally has the form https://{route-
      hash}-{project-hash}-{cluster-level-suffix}.a.run.app
  """

  address = _messages.MessageField('Addressable', 1)
  conditions = _messages.MessageField('RouteCondition', 2, repeated=True)
  domain = _messages.StringField(3)
  domainInternal = _messages.StringField(4)
  observedGeneration = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  traffic = _messages.MessageField('TrafficTarget', 6, repeated=True)
  url = _messages.StringField(7)


class RunNamespacesAuthorizeddomainsListRequest(_messages.Message):
  r"""A RunNamespacesAuthorizeddomainsListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Application resource. Example: `apps/myapp`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class RunNamespacesCloudauditlogssourcesCreateRequest(_messages.Message):
  r"""A RunNamespacesCloudauditlogssourcesCreateRequest object.

  Fields:
    cloudAuditLogsSource: A CloudAuditLogsSource resource to be passed as the
      request body.
    parent: The project ID or project number in which this
      cloudauditlogssource should be created.
  """

  cloudAuditLogsSource = _messages.MessageField('CloudAuditLogsSource', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesCloudauditlogssourcesDeleteRequest(_messages.Message):
  r"""A RunNamespacesCloudauditlogssourcesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the cloudauditlogssource being deleted. If needed,
      replace {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesCloudauditlogssourcesGetRequest(_messages.Message):
  r"""A RunNamespacesCloudauditlogssourcesGetRequest object.

  Fields:
    name: The name of the cloudauditlogssource being retrieved. If needed,
      replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesCloudauditlogssourcesListRequest(_messages.Message):
  r"""A RunNamespacesCloudauditlogssourcesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the
      cloudauditlogssources should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesCloudpubsubsourcesCreateRequest(_messages.Message):
  r"""A RunNamespacesCloudpubsubsourcesCreateRequest object.

  Fields:
    cloudPubSubSource: A CloudPubSubSource resource to be passed as the
      request body.
    parent: The project ID or project number in which this cloudpubsubsource
      should be created.
  """

  cloudPubSubSource = _messages.MessageField('CloudPubSubSource', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesCloudpubsubsourcesDeleteRequest(_messages.Message):
  r"""A RunNamespacesCloudpubsubsourcesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the cloudpubsubsource being deleted. If needed, replace
      {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesCloudpubsubsourcesGetRequest(_messages.Message):
  r"""A RunNamespacesCloudpubsubsourcesGetRequest object.

  Fields:
    name: The name of the cloudpubsubsource being retrieved. If needed,
      replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesCloudpubsubsourcesListRequest(_messages.Message):
  r"""A RunNamespacesCloudpubsubsourcesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the cloudpubsubsources
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesCloudschedulersourcesCreateRequest(_messages.Message):
  r"""A RunNamespacesCloudschedulersourcesCreateRequest object.

  Fields:
    cloudSchedulerSource: A CloudSchedulerSource resource to be passed as the
      request body.
    parent: Required. The project ID or project number in which this
      cloudschedulersource should be created.
  """

  cloudSchedulerSource = _messages.MessageField('CloudSchedulerSource', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesCloudschedulersourcesDeleteRequest(_messages.Message):
  r"""A RunNamespacesCloudschedulersourcesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: Required. The name of the cloudschedulersource being deleted. If
      needed, replace {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesCloudschedulersourcesGetRequest(_messages.Message):
  r"""A RunNamespacesCloudschedulersourcesGetRequest object.

  Fields:
    name: Required. The name of the cloudschedulersource being retrieved. If
      needed, replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesCloudschedulersourcesListRequest(_messages.Message):
  r"""A RunNamespacesCloudschedulersourcesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: Required. The project ID or project number from which the
      cloudschedulersources should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesCloudschedulersourcesReplaceCloudSchedulerSourceRequest(_messages.Message):
  r"""A RunNamespacesCloudschedulersourcesReplaceCloudSchedulerSourceRequest
  object.

  Fields:
    cloudSchedulerSource: A CloudSchedulerSource resource to be passed as the
      request body.
    name: Required. The name of the cloudschedulersource being retrieved. If
      needed, replace {namespace_id} with the project ID.
  """

  cloudSchedulerSource = _messages.MessageField('CloudSchedulerSource', 1)
  name = _messages.StringField(2, required=True)


class RunNamespacesCloudstoragesourcesCreateRequest(_messages.Message):
  r"""A RunNamespacesCloudstoragesourcesCreateRequest object.

  Fields:
    cloudStorageSource: A CloudStorageSource resource to be passed as the
      request body.
    parent: Required. The project ID or project number in which this
      cloudstoragesource should be created.
  """

  cloudStorageSource = _messages.MessageField('CloudStorageSource', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesCloudstoragesourcesDeleteRequest(_messages.Message):
  r"""A RunNamespacesCloudstoragesourcesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: Required. The name of the cloudstoragesource being deleted. If
      needed, replace {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesCloudstoragesourcesGetRequest(_messages.Message):
  r"""A RunNamespacesCloudstoragesourcesGetRequest object.

  Fields:
    name: Required. The name of the cloudstoragesource being retrieved. If
      needed, replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesCloudstoragesourcesListRequest(_messages.Message):
  r"""A RunNamespacesCloudstoragesourcesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: Required. The project ID or project number from which the
      cloudstoragesources should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesCloudstoragesourcesReplaceCloudStorageSourceRequest(_messages.Message):
  r"""A RunNamespacesCloudstoragesourcesReplaceCloudStorageSourceRequest
  object.

  Fields:
    cloudStorageSource: A CloudStorageSource resource to be passed as the
      request body.
    name: Required. The name of the cloudstoragesource being retrieved. If
      needed, replace {namespace_id} with the project ID.
  """

  cloudStorageSource = _messages.MessageField('CloudStorageSource', 1)
  name = _messages.StringField(2, required=True)


class RunNamespacesConfigurationsGetRequest(_messages.Message):
  r"""A RunNamespacesConfigurationsGetRequest object.

  Fields:
    name: The name of the configuration being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesConfigurationsListRequest(_messages.Message):
  r"""A RunNamespacesConfigurationsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the configurations
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesDomainmappingsCreateRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsCreateRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    parent: The project ID or project number in which this domain mapping
      should be created.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesDomainmappingsDeleteRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the domain mapping being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunNamespacesDomainmappingsGetRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsGetRequest object.

  Fields:
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesDomainmappingsListRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the domain mappings
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesRevisionsDeleteRequest(_messages.Message):
  r"""A RunNamespacesRevisionsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the revision being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunNamespacesRevisionsGetRequest(_messages.Message):
  r"""A RunNamespacesRevisionsGetRequest object.

  Fields:
    name: The name of the revision being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesRevisionsListRequest(_messages.Message):
  r"""A RunNamespacesRevisionsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the revisions should
      be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesRoutesGetRequest(_messages.Message):
  r"""A RunNamespacesRoutesGetRequest object.

  Fields:
    name: The name of the route being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesRoutesListRequest(_messages.Message):
  r"""A RunNamespacesRoutesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the routes should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesServicesCreateRequest(_messages.Message):
  r"""A RunNamespacesServicesCreateRequest object.

  Fields:
    parent: The project ID or project number in which this service should be
      created.
    service: A Service resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class RunNamespacesServicesDeleteRequest(_messages.Message):
  r"""A RunNamespacesServicesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the service being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunNamespacesServicesGetRequest(_messages.Message):
  r"""A RunNamespacesServicesGetRequest object.

  Fields:
    name: The name of the service being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesServicesListRequest(_messages.Message):
  r"""A RunNamespacesServicesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the services should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesServicesReplaceServiceRequest(_messages.Message):
  r"""A RunNamespacesServicesReplaceServiceRequest object.

  Fields:
    name: The name of the service being replaced. If needed, replace
      {namespace_id} with the project ID.
    service: A Service resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class RunNamespacesTriggersCreateRequest(_messages.Message):
  r"""A RunNamespacesTriggersCreateRequest object.

  Fields:
    parent: The project ID or project number in which this trigger should be
      created.
    trigger: A Trigger resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  trigger = _messages.MessageField('Trigger', 2)


class RunNamespacesTriggersDeleteRequest(_messages.Message):
  r"""A RunNamespacesTriggersDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the trigger being deleted. If needed, replace
      {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesTriggersGetRequest(_messages.Message):
  r"""A RunNamespacesTriggersGetRequest object.

  Fields:
    name: The name of the trigger being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesTriggersListRequest(_messages.Message):
  r"""A RunNamespacesTriggersListRequest object.

  Fields:
    continue_: Optional. Encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the triggers should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsAuthorizeddomainsListRequest(_messages.Message):
  r"""A RunProjectsLocationsAuthorizeddomainsListRequest object.

  Fields:
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    parent: Name of the parent Application resource. Example: `apps/myapp`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class RunProjectsLocationsCloudauditlogssourcesCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudauditlogssourcesCreateRequest object.

  Fields:
    cloudAuditLogsSource: A CloudAuditLogsSource resource to be passed as the
      request body.
    parent: The project ID or project number in which this
      cloudauditlogssource should be created.
  """

  cloudAuditLogsSource = _messages.MessageField('CloudAuditLogsSource', 1)
  parent = _messages.StringField(2, required=True)


class RunProjectsLocationsCloudauditlogssourcesDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudauditlogssourcesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the cloudauditlogssource being deleted. If needed,
      replace {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunProjectsLocationsCloudauditlogssourcesGetRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudauditlogssourcesGetRequest object.

  Fields:
    name: The name of the cloudauditlogssource being retrieved. If needed,
      replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsCloudauditlogssourcesListRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudauditlogssourcesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the
      cloudauditlogssources should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsCloudpubsubsourcesCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudpubsubsourcesCreateRequest object.

  Fields:
    cloudPubSubSource: A CloudPubSubSource resource to be passed as the
      request body.
    parent: The project ID or project number in which this cloudpubsubsource
      should be created.
  """

  cloudPubSubSource = _messages.MessageField('CloudPubSubSource', 1)
  parent = _messages.StringField(2, required=True)


class RunProjectsLocationsCloudpubsubsourcesDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudpubsubsourcesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the cloudpubsubsource being deleted. If needed, replace
      {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunProjectsLocationsCloudpubsubsourcesGetRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudpubsubsourcesGetRequest object.

  Fields:
    name: The name of the cloudpubsubsource being retrieved. If needed,
      replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsCloudpubsubsourcesListRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudpubsubsourcesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the cloudpubsubsources
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsCloudschedulersourcesCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudschedulersourcesCreateRequest object.

  Fields:
    cloudSchedulerSource: A CloudSchedulerSource resource to be passed as the
      request body.
    parent: Required. The project ID or project number in which this
      cloudschedulersource should be created.
  """

  cloudSchedulerSource = _messages.MessageField('CloudSchedulerSource', 1)
  parent = _messages.StringField(2, required=True)


class RunProjectsLocationsCloudschedulersourcesDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudschedulersourcesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: Required. The name of the cloudschedulersource being deleted. If
      needed, replace {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunProjectsLocationsCloudschedulersourcesGetRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudschedulersourcesGetRequest object.

  Fields:
    name: Required. The name of the cloudschedulersource being retrieved. If
      needed, replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsCloudschedulersourcesListRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudschedulersourcesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: Required. The project ID or project number from which the
      cloudschedulersources should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsCloudschedulersourcesReplaceCloudSchedulerSourceRequest(_messages.Message):
  r"""A
  RunProjectsLocationsCloudschedulersourcesReplaceCloudSchedulerSourceRequest
  object.

  Fields:
    cloudSchedulerSource: A CloudSchedulerSource resource to be passed as the
      request body.
    name: Required. The name of the cloudschedulersource being retrieved. If
      needed, replace {namespace_id} with the project ID.
  """

  cloudSchedulerSource = _messages.MessageField('CloudSchedulerSource', 1)
  name = _messages.StringField(2, required=True)


class RunProjectsLocationsCloudstoragesourcesCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudstoragesourcesCreateRequest object.

  Fields:
    cloudStorageSource: A CloudStorageSource resource to be passed as the
      request body.
    parent: Required. The project ID or project number in which this
      cloudstoragesource should be created.
  """

  cloudStorageSource = _messages.MessageField('CloudStorageSource', 1)
  parent = _messages.StringField(2, required=True)


class RunProjectsLocationsCloudstoragesourcesDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudstoragesourcesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: Required. The name of the cloudstoragesource being deleted. If
      needed, replace {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunProjectsLocationsCloudstoragesourcesGetRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudstoragesourcesGetRequest object.

  Fields:
    name: Required. The name of the cloudstoragesource being retrieved. If
      needed, replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsCloudstoragesourcesListRequest(_messages.Message):
  r"""A RunProjectsLocationsCloudstoragesourcesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: Required. The project ID or project number from which the
      cloudstoragesources should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsCloudstoragesourcesReplaceCloudStorageSourceRequest(_messages.Message):
  r"""A
  RunProjectsLocationsCloudstoragesourcesReplaceCloudStorageSourceRequest
  object.

  Fields:
    cloudStorageSource: A CloudStorageSource resource to be passed as the
      request body.
    name: Required. The name of the cloudstoragesource being retrieved. If
      needed, replace {namespace_id} with the project ID.
  """

  cloudStorageSource = _messages.MessageField('CloudStorageSource', 1)
  name = _messages.StringField(2, required=True)


class RunProjectsLocationsConfigurationsGetRequest(_messages.Message):
  r"""A RunProjectsLocationsConfigurationsGetRequest object.

  Fields:
    name: The name of the configuration being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsConfigurationsListRequest(_messages.Message):
  r"""A RunProjectsLocationsConfigurationsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the configurations
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsDomainmappingsCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsCreateRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    parent: The project ID or project number in which this domain mapping
      should be created.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  parent = _messages.StringField(2, required=True)


class RunProjectsLocationsDomainmappingsDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the domain mapping being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunProjectsLocationsDomainmappingsGetRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsGetRequest object.

  Fields:
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsDomainmappingsListRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the domain mappings
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsListRequest(_messages.Message):
  r"""A RunProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class RunProjectsLocationsRevisionsDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsRevisionsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the revision being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunProjectsLocationsRevisionsGetRequest(_messages.Message):
  r"""A RunProjectsLocationsRevisionsGetRequest object.

  Fields:
    name: The name of the revision being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsRevisionsListRequest(_messages.Message):
  r"""A RunProjectsLocationsRevisionsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the revisions should
      be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsRoutesGetRequest(_messages.Message):
  r"""A RunProjectsLocationsRoutesGetRequest object.

  Fields:
    name: The name of the route being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsRoutesListRequest(_messages.Message):
  r"""A RunProjectsLocationsRoutesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the routes should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsServicesCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesCreateRequest object.

  Fields:
    parent: The project ID or project number in which this service should be
      created.
    service: A Service resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class RunProjectsLocationsServicesDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the service being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunProjectsLocationsServicesGetIamPolicyRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.  To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class RunProjectsLocationsServicesGetRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesGetRequest object.

  Fields:
    name: The name of the service being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsServicesListRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the services should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsServicesReplaceServiceRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesReplaceServiceRequest object.

  Fields:
    name: The name of the service being replaced. If needed, replace
      {namespace_id} with the project ID.
    service: A Service resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class RunProjectsLocationsServicesSetIamPolicyRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class RunProjectsLocationsServicesTestIamPermissionsRequest(_messages.Message):
  r"""A RunProjectsLocationsServicesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class RunProjectsLocationsTriggersCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsTriggersCreateRequest object.

  Fields:
    parent: The project ID or project number in which this trigger should be
      created.
    trigger: A Trigger resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  trigger = _messages.MessageField('Trigger', 2)


class RunProjectsLocationsTriggersDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsTriggersDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the trigger being deleted. If needed, replace
      {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunProjectsLocationsTriggersGetRequest(_messages.Message):
  r"""A RunProjectsLocationsTriggersGetRequest object.

  Fields:
    name: The name of the trigger being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsTriggersListRequest(_messages.Message):
  r"""A RunProjectsLocationsTriggersListRequest object.

  Fields:
    continue_: Optional. Encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the triggers should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class SELinuxOptions(_messages.Message):
  r"""SELinuxOptions are the labels to be applied to the container

  Fields:
    level: Level is SELinux level label that applies to the container.
      +optional
    role: Role is a SELinux role label that applies to the container.
      +optional
    type: Type is a SELinux type label that applies to the container.
      +optional
    user: User is a SELinux user label that applies to the container.
      +optional
  """

  level = _messages.StringField(1)
  role = _messages.StringField(2)
  type = _messages.StringField(3)
  user = _messages.StringField(4)


class SecretEnvSource(_messages.Message):
  r"""SecretEnvSource selects a Secret to populate the environment variables
  with.  The contents of the target Secret's Data field will represent the
  key-value pairs as environment variables.

  Fields:
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported  Cloud Run for Anthos:
      supported  The Secret to select from.
    optional: Cloud Run fully managed: not supported  Cloud Run for Anthos:
      supported  Specify whether the Secret must be defined +optional
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  name = _messages.StringField(2)
  optional = _messages.BooleanField(3)


class SecretKeySelector(_messages.Message):
  r"""Cloud Run fully managed: not supported  Cloud Run on GKE: supported
  SecretKeySelector selects a key of a Secret.

  Fields:
    key: Cloud Run fully managed: not supported  Cloud Run on GKE: supported
      The key of the secret to select from.  Must be a valid secret key.
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported  Cloud Run on GKE: supported
      The name of the secret in the pod's namespace to select from.
    optional: Cloud Run fully managed: not supported  Cloud Run on GKE:
      supported  Specify whether the Secret or its key must be defined
      +optional
  """

  key = _messages.StringField(1)
  localObjectReference = _messages.MessageField('LocalObjectReference', 2)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class SecretVolumeSource(_messages.Message):
  r"""The contents of the target Secret's Data field will be presented in a
  volume as files using the keys in the Data field as the file names.

  Fields:
    defaultMode: Mode bits to use on created files by default. Must be a value
      between 0 and 0777. Defaults to 0644. Directories within the path are
      not affected by this setting. This might be in conflict with other
      options that affect the file mode, like fsGroup, and the result can be
      other mode bits set.
    items: If unspecified, each key-value pair in the Data field of the
      referenced Secret will be projected into the volume as a file whose name
      is the key and content is the value. If specified, the listed keys will
      be projected into the specified paths, and unlisted keys will not be
      present. If a key is specified which is not present in the Secret, the
      volume setup will error unless it is marked optional.
    optional: Specify whether the Secret or its keys must be defined.
    secretName: Name of the secret in the container's namespace to use.
  """

  defaultMode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  items = _messages.MessageField('KeyToPath', 2, repeated=True)
  optional = _messages.BooleanField(3)
  secretName = _messages.StringField(4)


class SecurityContext(_messages.Message):
  r"""SecurityContext holds security configuration that will be applied to a
  container. Some fields are present in both SecurityContext and
  PodSecurityContext.  When both are set, the values in SecurityContext take
  precedence.

  Fields:
    allowPrivilegeEscalation: AllowPrivilegeEscalation controls whether a
      process can gain more privileges than its parent process. This bool
      directly controls if the no_new_privs flag will be set on the container
      process. AllowPrivilegeEscalation is true always when the container is:
      1) run as Privileged 2) has CAP_SYS_ADMIN +optional
    capabilities: The capabilities to add/drop when running containers.
      Defaults to the default set of capabilities granted by the container
      runtime. +optional
    privileged: Run container in privileged mode. Processes in privileged
      containers are essentially equivalent to root on the host. Defaults to
      false. +optional
    readOnlyRootFilesystem: Whether this container has a read-only root
      filesystem. Default is false. +optional
    runAsGroup: The GID to run the entrypoint of the container process. Uses
      runtime default if unset. May also be set in PodSecurityContext.  If set
      in both SecurityContext and PodSecurityContext, the value specified in
      SecurityContext takes precedence. +optional
    runAsNonRoot: Indicates that the container must run as a non-root user. If
      true, the Kubelet will validate the image at runtime to ensure that it
      does not run as UID 0 (root) and fail to start the container if it does.
      If unset or false, no such validation will be performed. May also be set
      in PodSecurityContext.  If set in both SecurityContext and
      PodSecurityContext, the value specified in SecurityContext takes
      precedence. +optional
    runAsUser: The UID to run the entrypoint of the container process.
      Defaults to user specified in image metadata if unspecified. May also be
      set in PodSecurityContext.  If set in both SecurityContext and
      PodSecurityContext, the value specified in SecurityContext takes
      precedence. +optional
    seLinuxOptions: The SELinux context to be applied to the container. If
      unspecified, the container runtime will allocate a random SELinux
      context for each container.  May also be set in PodSecurityContext.  If
      set in both SecurityContext and PodSecurityContext, the value specified
      in SecurityContext takes precedence. +optional
  """

  allowPrivilegeEscalation = _messages.BooleanField(1)
  capabilities = _messages.MessageField('Capabilities', 2)
  privileged = _messages.BooleanField(3)
  readOnlyRootFilesystem = _messages.BooleanField(4)
  runAsGroup = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  runAsNonRoot = _messages.BooleanField(6)
  runAsUser = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  seLinuxOptions = _messages.MessageField('SELinuxOptions', 8)


class Service(_messages.Message):
  r"""Service acts as a top-level container that manages a set of Routes and
  Configurations which implement a network service. Service exists to provide
  a singular abstraction which can be access controlled, reasoned about, and
  which encapsulates software lifecycle decisions such as rollout policy and
  team resource ownership. Service acts only as an orchestrator of the
  underlying Routes and Configurations (much as a kubernetes Deployment
  orchestrates ReplicaSets).  The Service's controller will track the statuses
  of its owned Configuration and Route, reflecting their statuses and
  conditions as its own.  See also:
  https://github.com/knative/serving/blob/master/docs/spec/overview.md#service

  Fields:
    apiVersion: The API version for this call such as
      "serving.knative.dev/v1alpha1".
    kind: The kind of resource, in this case "Service".
    metadata: Metadata associated with this Service, including name,
      namespace, labels, and annotations.
    spec: Spec holds the desired state of the Service (from the client).
    status: Status communicates the observed state of the Service (from the
      controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('ServiceSpec', 4)
  status = _messages.MessageField('ServiceStatus', 5)


class ServiceCondition(_messages.Message):
  r"""ServiceCondition defines a readiness condition for a Service.

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human-readable message indicating details about last transition.
      +optional
    reason: One-word CamelCase reason for the condition's last transition.
      +optional
    severity: How to interpret failures of this condition, one of Error,
      Warning, Info +optional
    status: Status of the condition, one of True, False, Unknown.
    type: ServiceConditionType is used to communicate the status of the
      reconciliation process. See also: https://github.com/knative/serving/blo
      b/master/docs/spec/errors.md#error-conditions-and-reporting  Types
      include: "Ready", "ConfigurationsReady", and "RoutesReady". "Ready" will
      be true when the underlying Route and Configuration are ready.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class ServiceSpec(_messages.Message):
  r"""ServiceSpec holds the desired state of the Route (from the client),
  which is used to manipulate the underlying Route and Configuration(s).

  Fields:
    generation: Deprecated and not currently populated by Cloud Run. See
      metadata.generation instead, which is the sequence number containing the
      latest generation of the desired state.  Read-only.
    manual: Manual contains the options for configuring a manual service. See
      ServiceSpec for more details.  Not currently supported by Cloud Run.
    pinned: Pins this service to a specific revision name. The revision must
      be owned by the configuration provided.  Deprecated and not supported by
      Cloud Run. +optional
    release: Release enables gradual promotion of new revisions by allowing
      traffic to be split between two revisions. This type replaces the
      deprecated Pinned type.  Not currently supported by Cloud Run.
    runLatest: RunLatest defines a simple Service. It will automatically
      configure a route that keeps the latest ready revision from the supplied
      configuration running. +optional
    template: Template holds the latest specification for the Revision to be
      stamped out.
    traffic: Traffic specifies how to distribute traffic over a collection of
      Knative Revisions and Configurations.
  """

  generation = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  manual = _messages.MessageField('ServiceSpecManualType', 2)
  pinned = _messages.MessageField('ServiceSpecPinnedType', 3)
  release = _messages.MessageField('ServiceSpecReleaseType', 4)
  runLatest = _messages.MessageField('ServiceSpecRunLatest', 5)
  template = _messages.MessageField('RevisionTemplate', 6)
  traffic = _messages.MessageField('TrafficTarget', 7, repeated=True)


class ServiceSpecManualType(_messages.Message):
  r"""ServiceSpecManualType contains the options for configuring a manual
  service. See ServiceSpec for more details.  Not currently supported by Cloud
  Run.
  """



class ServiceSpecPinnedType(_messages.Message):
  r"""ServiceSpecPinnedType Pins this service to a specific revision name. The
  revision must be owned by the configuration provided.  Deprecated and not
  supported by Cloud Run.

  Fields:
    configuration: The configuration for this service.
    revisionName: The revision name to pin this service to until changed to a
      different service type.
  """

  configuration = _messages.MessageField('ConfigurationSpec', 1)
  revisionName = _messages.StringField(2)


class ServiceSpecReleaseType(_messages.Message):
  r"""ServiceSpecReleaseType contains the options for slowly releasing
  revisions. See ServiceSpec for more details.  Not currently supported by
  Cloud Run.

  Fields:
    configuration: The configuration for this service. All revisions from this
      service must come from a single configuration.
    revisions: Revisions is an ordered list of 1 or 2 revisions. The first is
      the current revision, and the second is the candidate revision. If a
      single revision is provided, traffic will be pinned at that revision.
      "@latest" is a shortcut for usage that refers to the latest created
      revision by the configuration.
    rolloutPercent: RolloutPercent is the percent of traffic that should be
      sent to the candidate revision, i.e. the 2nd revision in the revisions
      list. Valid values are between 0 and 99 inclusive.
  """

  configuration = _messages.MessageField('ConfigurationSpec', 1)
  revisions = _messages.StringField(2, repeated=True)
  rolloutPercent = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ServiceSpecRunLatest(_messages.Message):
  r"""ServiceSpecRunLatest contains the options for always having a route to
  the latest configuration. See ServiceSpec for more details.

  Fields:
    configuration: The configuration for this service.
  """

  configuration = _messages.MessageField('ConfigurationSpec', 1)


class ServiceStatus(_messages.Message):
  r"""The current state of the Service. Output only.

  Fields:
    address: From RouteStatus. Similar to url, information on where the
      service is available on HTTP.
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world.
    domain: From RouteStatus. Domain holds the top-level domain that will
      distribute traffic over the provided targets. It generally has the form
      https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
    latestCreatedRevisionName: From ConfigurationStatus.
      LatestCreatedRevisionName is the last revision that was created from
      this Service's Configuration. It might not be ready yet, for that use
      LatestReadyRevisionName.
    latestReadyRevisionName: From ConfigurationStatus. LatestReadyRevisionName
      holds the name of the latest Revision stamped out from this Service's
      Configuration that has had its "Ready" condition become "True".
    observedGeneration: ObservedGeneration is the 'Generation' of the Route
      that was last processed by the controller.  Clients polling for
      completed reconciliation should poll until observedGeneration =
      metadata.generation and the Ready condition's status is True or False.
    traffic: From RouteStatus. Traffic holds the configured traffic
      distribution. These entries will always contain RevisionName references.
      When ConfigurationName appears in the spec, this will hold the
      LatestReadyRevisionName that we last observed.
    url: From RouteStatus. URL holds the url that will distribute traffic over
      the provided traffic targets. It generally has the form https://{route-
      hash}-{project-hash}-{cluster-level-suffix}.a.run.app
  """

  address = _messages.MessageField('Addressable', 1)
  conditions = _messages.MessageField('ServiceCondition', 2, repeated=True)
  domain = _messages.StringField(3)
  latestCreatedRevisionName = _messages.StringField(4)
  latestReadyRevisionName = _messages.StringField(5)
  observedGeneration = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  traffic = _messages.MessageField('TrafficTarget', 7, repeated=True)
  url = _messages.StringField(8)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used:  `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  alt = _messages.EnumField('AltValueValuesEnum', 2, default='json')
  callback = _messages.StringField(3)
  fields = _messages.StringField(4)
  key = _messages.StringField(5)
  prettyPrint = _messages.BooleanField(6, default=True)
  quotaUser = _messages.StringField(7)
  trace = _messages.StringField(8)
  uploadType = _messages.StringField(9)
  upload_protocol = _messages.StringField(10)


class TCPSocketAction(_messages.Message):
  r"""TCPSocketAction describes an action based on opening a socket

  Fields:
    host: Optional: Host name to connect to, defaults to the pod IP. +optional
    port: Number or name of the port to access on the container. Number must
      be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
  """

  host = _messages.StringField(1)
  port = _messages.MessageField('IntOrString', 2)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TrafficTarget(_messages.Message):
  r"""TrafficTarget holds a single entry of the routing table for a Route.

  Fields:
    configurationName: ConfigurationName of a configuration to whose latest
      revision we will send this portion of traffic. When the
      "status.latestReadyRevisionName" of the referenced configuration
      changes, we will automatically migrate traffic from the prior "latest
      ready" revision to the new one. This field is never set in Route's
      status, only its spec. This is mutually exclusive with RevisionName.
      Cloud Run currently supports a single ConfigurationName.
    latestRevision: LatestRevision may be optionally provided to indicate that
      the latest ready Revision of the Configuration should be used for this
      traffic target. When provided LatestRevision must be true if
      RevisionName is empty; it must be false when RevisionName is non-empty.
      +optional
    name: Name is optionally used to expose a dedicated hostname for
      referencing this target exclusively.  Not currently supported by Cloud
      Run. +optional
    percent: Percent specifies percent of the traffic to this Revision or
      Configuration. This defaults to zero if unspecified.  Cloud Run
      currently requires 100 percent for a single ConfigurationName
      TrafficTarget entry.
    revisionName: RevisionName of a specific revision to which to send this
      portion of traffic. This is mutually exclusive with ConfigurationName.
      Providing RevisionName in spec is not currently supported by Cloud Run.
    tag: Tag is optionally used to expose a dedicated url for referencing this
      target exclusively.  Not currently supported in Cloud Run. +optional
    url: Output only. URL displays the URL for accessing named traffic
      targets. URL is displayed in status, and is disallowed on spec. URL must
      contain a scheme (e.g. http://) and a hostname, but may not contain
      anything else (e.g. basic auth, url path, etc.  Not currently supported
      in Cloud Run.
  """

  configurationName = _messages.StringField(1)
  latestRevision = _messages.BooleanField(2)
  name = _messages.StringField(3)
  percent = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  revisionName = _messages.StringField(5)
  tag = _messages.StringField(6)
  url = _messages.StringField(7)


class Trigger(_messages.Message):
  r"""A Trigger object.

  Fields:
    apiVersion: The API version for this call such as
      "eventing.knative.dev/v1alpha1".
    kind: The kind of resource, in this case "Trigger".
    metadata: Metadata associated with this Trigger.
    spec: Spec defines the desired state of the Trigger.
    status: Optional. Status represents the current state of the Trigger. This
      data may be out of date.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('TriggerSpec', 4)
  status = _messages.MessageField('TriggerStatus', 5)


class TriggerCondition(_messages.Message):
  r"""TriggerCondition contains state information for an Trigger.

  Fields:
    lastTransitionTime: Optional. Last time the condition transitioned from
      one status to another.
    message: Optional. Human readable message indicating details about the
      current status.
    reason: Optional. One-word CamelCase reason for the condition's current
      status.
    severity: Optional. How to interpret failures of this condition, one of
      Error, Warning, Info
    status: Status of the condition, one of True, False, Unknown.
    type: Type of Trigger condition.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class TriggerFilter(_messages.Message):
  r"""A TriggerFilter object.

  Messages:
    AttributesValue: Optional. Attributes filters events by exact match on
      event context attributes. Each key in the map is compared with the
      equivalent key in the event context. An event passes the filter if all
      values are equal to the specified values.  Nested context attributes are
      not supported as keys. Only string values are supported. Note that this
      field is optional in knative. In fully managed, 'type' attribute is
      required due to different broker implementation.

  Fields:
    attributes: Optional. Attributes filters events by exact match on event
      context attributes. Each key in the map is compared with the equivalent
      key in the event context. An event passes the filter if all values are
      equal to the specified values.  Nested context attributes are not
      supported as keys. Only string values are supported. Note that this
      field is optional in knative. In fully managed, 'type' attribute is
      required due to different broker implementation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Optional. Attributes filters events by exact match on event context
    attributes. Each key in the map is compared with the equivalent key in the
    event context. An event passes the filter if all values are equal to the
    specified values.  Nested context attributes are not supported as keys.
    Only string values are supported. Note that this field is optional in
    knative. In fully managed, 'type' attribute is required due to different
    broker implementation.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributes = _messages.MessageField('AttributesValue', 1)


class TriggerSpec(_messages.Message):
  r"""The desired state of the Trigger.

  Fields:
    broker: Broker is the broker that this trigger receives events from. If
      not specified, will default to 'default'.  Not currently supported by
      Cloud Run.
    filter: Optional. Filter is the filter to apply against all events from
      the Broker. Only events that pass this filter will be sent to the
      Subscriber. Note that filter is optional in knative and is only required
      in fully managed due to different broker implementation.
    subscriber: Sink is the addressable that will receive events.
  """

  broker = _messages.StringField(1)
  filter = _messages.MessageField('TriggerFilter', 2)
  subscriber = _messages.MessageField('Destination', 3)


class TriggerStatus(_messages.Message):
  r"""TriggerStatus represents the current state of a Trigger.

  Fields:
    conditions: Array of observed TriggerConditions, indicating the current
      state of the Trigger.
    observedGeneration: ObservedGeneration is the 'Generation' of the Trigger
      that was last processed by the controller.
    subscriberUri: SubscriberURI is the resolved URI of the receiver for this
      Trigger.
  """

  conditions = _messages.MessageField('TriggerCondition', 1, repeated=True)
  observedGeneration = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  subscriberUri = _messages.StringField(3)


class Volume(_messages.Message):
  r"""Volume represents a named volume in a container.

  Fields:
    configMap: A ConfigMapVolumeSource attribute.
    name: Volume's name.
    secret: A SecretVolumeSource attribute.
  """

  configMap = _messages.MessageField('ConfigMapVolumeSource', 1)
  name = _messages.StringField(2)
  secret = _messages.MessageField('SecretVolumeSource', 3)


class VolumeDevice(_messages.Message):
  r"""volumeDevice describes a mapping of a raw block device within a
  container.

  Fields:
    devicePath: devicePath is the path inside of the container that the device
      will be mapped to.
    name: name must match the name of a persistentVolumeClaim in the pod
  """

  devicePath = _messages.StringField(1)
  name = _messages.StringField(2)


class VolumeMount(_messages.Message):
  r"""VolumeMount describes a mounting of a Volume within a container.

  Fields:
    mountPath: Path within the container at which the volume should be
      mounted.  Must not contain ':'.
    mountPropagation: mountPropagation determines how mounts are propagated
      from the host to container and the other way around. When not set,
      MountPropagationHostToContainer is used. This field is beta in 1.10.
      +optional
    name: This must match the Name of a Volume.
    readOnly: Mounted read-only if true, read-write otherwise (false or
      unspecified). Defaults to false. +optional
    subPath: Path within the volume from which the container's volume should
      be mounted. Defaults to "" (volume's root). +optional
  """

  mountPath = _messages.StringField(1)
  mountPropagation = _messages.StringField(2)
  name = _messages.StringField(3)
  readOnly = _messages.BooleanField(4)
  subPath = _messages.StringField(5)


encoding.AddCustomJsonFieldMapping(
    Handler, 'exec_', 'exec')
encoding.AddCustomJsonFieldMapping(
    ListMeta, 'continue_', 'continue')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
