"""Generated message classes for containeranalysis version v1alpha1.

An implementation of the Grafeas API, which stores, and enables querying and
retrieval of critical metadata about all of your software artifacts.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'containeranalysis'


class Artifact(_messages.Message):
  r"""Artifact describes a build product.

  Fields:
    checksum: Hash or checksum value of a binary, or Docker Registry 2.0
      digest of a container.
    id: Artifact ID, if any; for container images, this will be a URL by
      digest like gcr.io/projectID/imagename@sha256:123456
    name: Name of the artifact. This may be the path to a binary or jar file,
      or in the case of a container build, the name used to push the container
      image to Google Container Registry, as presented to `docker push`.  This
      field is deprecated in favor of the plural `names` field; it continues
      to exist here to allow existing BuildProvenance serialized to json in
      google.devtools.containeranalysis.v1alpha1.BuildDetails.provenance_bytes
      to deserialize back into proto.
    names: Related artifact names. This may be the path to a binary or jar
      file, or in the case of a container build, the name used to push the
      container image to Google Container Registry, as presented to `docker
      push`. Note that a single Artifact ID can have multiple names, for
      example if two tags are applied to one image.
  """

  checksum = _messages.StringField(1)
  id = _messages.StringField(2)
  name = _messages.StringField(3)
  names = _messages.StringField(4, repeated=True)


class Attestation(_messages.Message):
  r"""Occurrence that represents a single "attestation".  The authenticity of
  an Attestation can be verified using the attached signature. If the verifier
  trusts the public key of the signer, then verifying the signature is
  sufficient to establish trust.  In this circumstance, the
  AttestationAuthority to which this Attestation is attached is primarily
  useful for look-up (how to find this Attestation if you already know the
  Authority and artifact to be verified) and intent (which authority was this
  attestation intended to sign for).

  Fields:
    pgpSignedAttestation: A PgpSignedAttestation attribute.
  """

  pgpSignedAttestation = _messages.MessageField('PgpSignedAttestation', 1)


class AttestationAuthority(_messages.Message):
  r"""Note kind that represents a logical attestation "role" or "authority".
  For example, an organization might have one `AttestationAuthority` for "QA"
  and one for "build".  This Note is intended to act strictly as a grouping
  mechanism for the attached Occurrences (Attestations).  This grouping
  mechanism also provides a security boundary, since IAM ACLs gate the ability
  for a principle to attach an Occurrence to a given Note.  It also provides a
  single point of lookup to find all attached Attestation Occurrences, even if
  they don't all live in the same project.

  Fields:
    hint: A AttestationAuthorityHint attribute.
  """

  hint = _messages.MessageField('AttestationAuthorityHint', 1)


class AttestationAuthorityHint(_messages.Message):
  r"""This submessage provides human-readable hints about the purpose of the
  AttestationAuthority.  Because the name of a Note acts as its resource
  reference, it is important to disambiguate the canonical name of the Note
  (which might be a UUID for security purposes) from "readable" names more
  suitable for debug output.  Note that these hints should NOT be used to look
  up AttestationAuthorities in security sensitive contexts, such as when
  looking up Attestations to verify.

  Fields:
    humanReadableName: The human readable name of this Attestation Authority,
      for example "qa".
  """

  humanReadableName = _messages.StringField(1)


class Basis(_messages.Message):
  r"""Basis describes the base image portion (Note) of the DockerImage
  relationship.  Linked occurrences are derived from this or an equivalent
  image via:   FROM <Basis.resource_url> Or an equivalent reference, e.g. a
  tag of the resource_url.

  Fields:
    fingerprint: The fingerprint of the base image.
    resourceUrl: The resource_url for the resource representing the basis of
      associated occurrence images.
  """

  fingerprint = _messages.MessageField('Fingerprint', 1)
  resourceUrl = _messages.StringField(2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding.  If the
      condition evaluates to `true`, then this binding applies to the current
      request.  If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding.  *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus    unique identifier) representing a service account that has been
      recently    deleted. For example,    `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`.    If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding.  * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique    identifier) representing a Google group
      that has been recently    deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If    the group is
      recovered, this value reverts to `group:{emailid}` and the    recovered
      group retains the role in the binding.   * `domain:{domain}`: The G
      Suite domain (primary) that represents all the    users of that domain.
      For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class BuildDetails(_messages.Message):
  r"""Message encapsulating build provenance details.

  Fields:
    provenance: The actual provenance
    provenanceBytes: Serialized JSON representation of the provenance, used in
      generating the `BuildSignature` in the corresponding Result. After
      verifying the signature, `provenance_bytes` can be unmarshalled and
      compared to the provenance to confirm that it is unchanged. A
      base64-encoded string representation of the provenance bytes is used for
      the signature in order to interoperate with openssl which expects this
      format for signature verification.  The serialized form is captured both
      to avoid ambiguity in how the provenance is marshalled to json as well
      to prevent incompatibilities with future changes.
  """

  provenance = _messages.MessageField('BuildProvenance', 1)
  provenanceBytes = _messages.StringField(2)


class BuildProvenance(_messages.Message):
  r"""Provenance of a build. Contains all information needed to verify the
  full details about the build from source to completion.

  Messages:
    BuildOptionsValue: Special options applied to this build. This is a catch-
      all field where build providers can enter any desired additional
      details.

  Fields:
    buildOptions: Special options applied to this build. This is a catch-all
      field where build providers can enter any desired additional details.
    builderVersion: Version string of the builder at the time this build was
      executed.
    builtArtifacts: Output of the build.
    commands: Commands requested by the build.
    createTime: Time at which the build was created.
    creator: E-mail address of the user who initiated this build. Note that
      this was the user's e-mail address at the time the build was initiated;
      this address may not represent the same end-user for all time.
    finishTime: Time at which execution of the build was finished.
    id: Unique identifier of the build.
    logsBucket: Google Cloud Storage bucket where logs were written.
    projectId: ID of the project.
    sourceProvenance: Details of the Source input to the build.
    startTime: Time at which execution of the build was started.
    triggerId: Trigger identifier if the build was triggered automatically;
      empty if not.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BuildOptionsValue(_messages.Message):
    r"""Special options applied to this build. This is a catch-all field where
    build providers can enter any desired additional details.

    Messages:
      AdditionalProperty: An additional property for a BuildOptionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type BuildOptionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BuildOptionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  buildOptions = _messages.MessageField('BuildOptionsValue', 1)
  builderVersion = _messages.StringField(2)
  builtArtifacts = _messages.MessageField('Artifact', 3, repeated=True)
  commands = _messages.MessageField('Command', 4, repeated=True)
  createTime = _messages.StringField(5)
  creator = _messages.StringField(6)
  finishTime = _messages.StringField(7)
  id = _messages.StringField(8)
  logsBucket = _messages.StringField(9)
  projectId = _messages.StringField(10)
  sourceProvenance = _messages.MessageField('Source', 11)
  startTime = _messages.StringField(12)
  triggerId = _messages.StringField(13)


class BuildSignature(_messages.Message):
  r"""Message encapsulating the signature of the verified build.

  Enums:
    KeyTypeValueValuesEnum: The type of the key, either stored in `public_key`
      or referenced in `key_id`

  Fields:
    keyId: An Id for the key used to sign. This could be either an Id for the
      key stored in `public_key` (such as the Id or fingerprint for a PGP key,
      or the CN for a cert), or a reference to an external key (such as a
      reference to a key in Cloud Key Management Service).
    keyType: The type of the key, either stored in `public_key` or referenced
      in `key_id`
    publicKey: Public key of the builder which can be used to verify that the
      related findings are valid and unchanged. If `key_type` is empty, this
      defaults to PEM encoded public keys.  This field may be empty if
      `key_id` references an external key.  For Cloud Build based signatures,
      this is a PEM encoded public key. To verify the Cloud Build signature,
      place the contents of this field into a file (public.pem). The signature
      field is base64-decoded into its binary representation in signature.bin,
      and the provenance bytes from `BuildDetails` are base64-decoded into a
      binary representation in signed.bin. OpenSSL can then verify the
      signature: `openssl sha256 -verify public.pem -signature signature.bin
      signed.bin`
    signature: Signature of the related `BuildProvenance`, encoded in a base64
      string.
  """

  class KeyTypeValueValuesEnum(_messages.Enum):
    r"""The type of the key, either stored in `public_key` or referenced in
    `key_id`

    Values:
      KEY_TYPE_UNSPECIFIED: `KeyType` is not set.
      PGP_ASCII_ARMORED: `PGP ASCII Armored` public key.
      PKIX_PEM: `PKIX PEM` public key.
    """
    KEY_TYPE_UNSPECIFIED = 0
    PGP_ASCII_ARMORED = 1
    PKIX_PEM = 2

  keyId = _messages.StringField(1)
  keyType = _messages.EnumField('KeyTypeValueValuesEnum', 2)
  publicKey = _messages.StringField(3)
  signature = _messages.StringField(4)


class BuildType(_messages.Message):
  r"""Note holding the version of the provider's builder and the signature of
  the provenance message in linked BuildDetails.

  Fields:
    builderVersion: Version of the builder which produced this Note.
    signature: Signature of the build in Occurrences pointing to the Note
      containing this `BuilderDetails`.
  """

  builderVersion = _messages.StringField(1)
  signature = _messages.MessageField('BuildSignature', 2)


class Command(_messages.Message):
  r"""Command describes a step performed as part of the build pipeline.

  Fields:
    args: Command-line arguments used when executing this Command.
    dir: Working directory (relative to project source root) used when running
      this Command.
    env: Environment variables set before running this Command.
    id: Optional unique identifier for this Command, used in wait_for to
      reference this Command as a dependency.
    name: Name of the command, as presented on the command line, or if the
      command is packaged as a Docker container, as presented to `docker
      pull`.
    waitFor: The ID(s) of the Command(s) that this Command depends on.
  """

  args = _messages.StringField(1, repeated=True)
  dir = _messages.StringField(2)
  env = _messages.StringField(3, repeated=True)
  id = _messages.StringField(4)
  name = _messages.StringField(5)
  waitFor = _messages.StringField(6, repeated=True)


class ContaineranalysisProjectsNotesCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesCreateRequest object.

  Fields:
    name: The name of the project. Should be of the form
      "providers/{provider_id}". @Deprecated
    note: A Note resource to be passed as the request body.
    noteId: The ID to use for this note.
    parent: This field contains the project Id for example:
      "projects/{project_id}
  """

  name = _messages.StringField(1)
  note = _messages.MessageField('Note', 2)
  noteId = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ContaineranalysisProjectsNotesDeleteRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesDeleteRequest object.

  Fields:
    name: The name of the note in the form of
      "providers/{provider_id}/notes/{NOTE_ID}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsNotesGetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProjectsNotesGetRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesGetRequest object.

  Fields:
    name: The name of the note in the form of
      "providers/{provider_id}/notes/{NOTE_ID}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsNotesListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name field will contain the project Id for example:
      "providers/{provider_id} @Deprecated
    pageSize: Number of notes to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: This field contains the project Id for example:
      "projects/{PROJECT_ID}".
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ContaineranalysisProjectsNotesOccurrencesListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesOccurrencesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name field will contain the note name for example:
      "provider/{provider_id}/notes/{note_id}"
    pageSize: Number of notes to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ContaineranalysisProjectsNotesPatchRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesPatchRequest object.

  Fields:
    name: The name of the note. Should be of the form
      "projects/{provider_id}/notes/{note_id}".
    note: A Note resource to be passed as the request body.
    updateMask: The fields to update.
  """

  name = _messages.StringField(1, required=True)
  note = _messages.MessageField('Note', 2)
  updateMask = _messages.StringField(3)


class ContaineranalysisProjectsNotesSetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProjectsNotesTestIamPermissionsRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ContaineranalysisProjectsOccurrencesCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesCreateRequest object.

  Fields:
    name: The name of the project.  Should be of the form
      "projects/{project_id}". @Deprecated
    occurrence: A Occurrence resource to be passed as the request body.
    parent: This field contains the project Id for example:
      "projects/{project_id}"
  """

  name = _messages.StringField(1)
  occurrence = _messages.MessageField('Occurrence', 2)
  parent = _messages.StringField(3, required=True)


class ContaineranalysisProjectsOccurrencesDeleteRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesDeleteRequest object.

  Fields:
    name: The name of the occurrence in the form of
      "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesGetNotesRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetNotesRequest object.

  Fields:
    name: The name of the occurrence in the form
      "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetRequest object.

  Fields:
    name: The name of the occurrence of the form
      "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetVulnerabilitySummaryRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetVulnerabilitySummaryRequest
  object.

  Fields:
    filter: The filter expression.
    parent: This contains the project Id for example: projects/{project_id}
  """

  filter = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesListRequest object.

  Enums:
    KindValueValuesEnum: The kind of occurrences to filter on.

  Fields:
    filter: The filter expression.
    kind: The kind of occurrences to filter on.
    name: The name field contains the project Id. For example:
      "projects/{project_id} @Deprecated
    pageSize: Number of occurrences to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: This contains the project Id for example: projects/{project_id}.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The kind of occurrences to filter on.

    Values:
      KIND_UNSPECIFIED: <no description>
      PACKAGE_VULNERABILITY: <no description>
      BUILD_DETAILS: <no description>
      IMAGE_BASIS: <no description>
      PACKAGE_MANAGER: <no description>
      DEPLOYABLE: <no description>
      DISCOVERY: <no description>
      ATTESTATION_AUTHORITY: <no description>
      UPGRADE: <no description>
    """
    KIND_UNSPECIFIED = 0
    PACKAGE_VULNERABILITY = 1
    BUILD_DETAILS = 2
    IMAGE_BASIS = 3
    PACKAGE_MANAGER = 4
    DEPLOYABLE = 5
    DISCOVERY = 6
    ATTESTATION_AUTHORITY = 7
    UPGRADE = 8

  filter = _messages.StringField(1)
  kind = _messages.EnumField('KindValueValuesEnum', 2)
  name = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  parent = _messages.StringField(6, required=True)


class ContaineranalysisProjectsOccurrencesPatchRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesPatchRequest object.

  Fields:
    name: The name of the occurrence. Should be of the form
      "projects/{project_id}/occurrences/{OCCURRENCE_ID}".
    occurrence: A Occurrence resource to be passed as the request body.
    updateMask: The fields to update.
  """

  name = _messages.StringField(1, required=True)
  occurrence = _messages.MessageField('Occurrence', 2)
  updateMask = _messages.StringField(3)


class ContaineranalysisProjectsOccurrencesSetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ContaineranalysisProjectsOperationsCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOperationsCreateRequest object.

  Fields:
    createOperationRequest: A CreateOperationRequest resource to be passed as
      the request body.
    parent: The project Id that this operation should be created under.
  """

  createOperationRequest = _messages.MessageField('CreateOperationRequest', 1)
  parent = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOperationsPatchRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOperationsPatchRequest object.

  Fields:
    name: The name of the Operation. Should be of the form
      "projects/{provider_id}/operations/{operation_id}".
    updateOperationRequest: A UpdateOperationRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  updateOperationRequest = _messages.MessageField('UpdateOperationRequest', 2)


class ContaineranalysisProjectsScanConfigsGetRequest(_messages.Message):
  r"""A ContaineranalysisProjectsScanConfigsGetRequest object.

  Fields:
    name: The name of the ScanConfig in the form
      projects/{project_id}/scanConfigs/{scan_config_id}
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsScanConfigsListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsScanConfigsListRequest object.

  Fields:
    filter: The filter expression.
    pageSize: The number of items to return.
    pageToken: The page token to use for the next request.
    parent: This containers the project Id i.e.: projects/{project_id}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ContaineranalysisProjectsScanConfigsPatchRequest(_messages.Message):
  r"""A ContaineranalysisProjectsScanConfigsPatchRequest object.

  Fields:
    name: The scan config to update of the form
      projects/{project_id}/scanConfigs/{scan_config_id}.
    scanConfig: A ScanConfig resource to be passed as the request body.
    updateMask: The fields to update.
  """

  name = _messages.StringField(1, required=True)
  scanConfig = _messages.MessageField('ScanConfig', 2)
  updateMask = _messages.StringField(3)


class ContaineranalysisProvidersNotesCreateRequest(_messages.Message):
  r"""A ContaineranalysisProvidersNotesCreateRequest object.

  Fields:
    name: The name of the project. Should be of the form
      "providers/{provider_id}". @Deprecated
    note: A Note resource to be passed as the request body.
    noteId: The ID to use for this note.
    parent: This field contains the project Id for example:
      "projects/{project_id}
  """

  name = _messages.StringField(1, required=True)
  note = _messages.MessageField('Note', 2)
  noteId = _messages.StringField(3)
  parent = _messages.StringField(4)


class ContaineranalysisProvidersNotesDeleteRequest(_messages.Message):
  r"""A ContaineranalysisProvidersNotesDeleteRequest object.

  Fields:
    name: The name of the note in the form of
      "providers/{provider_id}/notes/{NOTE_ID}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProvidersNotesGetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProvidersNotesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProvidersNotesGetRequest(_messages.Message):
  r"""A ContaineranalysisProvidersNotesGetRequest object.

  Fields:
    name: The name of the note in the form of
      "providers/{provider_id}/notes/{NOTE_ID}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProvidersNotesListRequest(_messages.Message):
  r"""A ContaineranalysisProvidersNotesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name field will contain the project Id for example:
      "providers/{provider_id} @Deprecated
    pageSize: Number of notes to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: This field contains the project Id for example:
      "projects/{PROJECT_ID}".
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5)


class ContaineranalysisProvidersNotesOccurrencesListRequest(_messages.Message):
  r"""A ContaineranalysisProvidersNotesOccurrencesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name field will contain the note name for example:
      "provider/{provider_id}/notes/{note_id}"
    pageSize: Number of notes to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ContaineranalysisProvidersNotesPatchRequest(_messages.Message):
  r"""A ContaineranalysisProvidersNotesPatchRequest object.

  Fields:
    name: The name of the note. Should be of the form
      "projects/{provider_id}/notes/{note_id}".
    note: A Note resource to be passed as the request body.
    updateMask: The fields to update.
  """

  name = _messages.StringField(1, required=True)
  note = _messages.MessageField('Note', 2)
  updateMask = _messages.StringField(3)


class ContaineranalysisProvidersNotesSetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProvidersNotesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProvidersNotesTestIamPermissionsRequest(_messages.Message):
  r"""A ContaineranalysisProvidersNotesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CreateOperationRequest(_messages.Message):
  r"""Request for creating an operation

  Fields:
    operation: The operation to create.
    operationId: The ID to use for this operation.
  """

  operation = _messages.MessageField('Operation', 1)
  operationId = _messages.StringField(2)


class Deployable(_messages.Message):
  r"""An artifact that can be deployed in some runtime.

  Fields:
    resourceUri: Resource URI for the artifact being deployed.
  """

  resourceUri = _messages.StringField(1, repeated=True)


class Deployment(_messages.Message):
  r"""The period during which some deployable was active in a runtime.

  Enums:
    PlatformValueValuesEnum: Platform hosting this deployment.

  Fields:
    address: Address of the runtime element hosting this deployment.
    config: Configuration used to create this deployment.
    deployTime: Beginning of the lifetime of this deployment.
    platform: Platform hosting this deployment.
    resourceUri: Output only. Resource URI for the artifact being deployed
      taken from the deployable field with the same name.
    undeployTime: End of the lifetime of this deployment.
    userEmail: Identity of the user that triggered this deployment.
  """

  class PlatformValueValuesEnum(_messages.Enum):
    r"""Platform hosting this deployment.

    Values:
      PLATFORM_UNSPECIFIED: Unknown
      GKE: Google Container Engine
      FLEX: Google App Engine: Flexible Environment
      CUSTOM: Custom user-defined platform
    """
    PLATFORM_UNSPECIFIED = 0
    GKE = 1
    FLEX = 2
    CUSTOM = 3

  address = _messages.StringField(1)
  config = _messages.StringField(2)
  deployTime = _messages.StringField(3)
  platform = _messages.EnumField('PlatformValueValuesEnum', 4)
  resourceUri = _messages.StringField(5, repeated=True)
  undeployTime = _messages.StringField(6)
  userEmail = _messages.StringField(7)


class Derived(_messages.Message):
  r"""Derived describes the derived image portion (Occurrence) of the
  DockerImage relationship.  This image would be produced from a Dockerfile
  with FROM <DockerImage.Basis in attached Note>.

  Fields:
    baseResourceUrl: Output only. This contains the base image URL for the
      derived image occurrence.
    distance: Output only. The number of layers by which this image differs
      from the associated image basis.
    fingerprint: The fingerprint of the derived image.
    layerInfo: This contains layer-specific metadata, if populated it has
      length "distance" and is ordered with [distance] being the layer
      immediately following the base image and [1] being the final layer.
  """

  baseResourceUrl = _messages.StringField(1)
  distance = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  fingerprint = _messages.MessageField('Fingerprint', 3)
  layerInfo = _messages.MessageField('Layer', 4, repeated=True)


class Detail(_messages.Message):
  r"""Identifies all occurrences of this vulnerability in the package for a
  specific distro/location For example: glibc in cpe:/o:debian:debian_linux:8
  for versions 2.1 - 2.2

  Fields:
    cpeUri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/)
      in which the vulnerability manifests.  Examples include distro or
      storage location for vulnerable jar. This field can be used as a filter
      in list requests.
    description: A vendor-specific description of this note.
    fixedLocation: The fix for this specific package version.
    isObsolete: Whether this Detail is obsolete. Occurrences are expected not
      to point to obsolete details.
    maxAffectedVersion: The max version of the package in which the
      vulnerability exists.
    minAffectedVersion: The min version of the package in which the
      vulnerability exists.
    package: The name of the package where the vulnerability was found. This
      field can be used as a filter in list requests.
    packageType: The type of package; whether native or non native(ruby gems,
      node.js packages etc)
    severityName: The severity (eg: distro assigned severity) for this
      vulnerability.
  """

  cpeUri = _messages.StringField(1)
  description = _messages.StringField(2)
  fixedLocation = _messages.MessageField('VulnerabilityLocation', 3)
  isObsolete = _messages.BooleanField(4)
  maxAffectedVersion = _messages.MessageField('Version', 5)
  minAffectedVersion = _messages.MessageField('Version', 6)
  package = _messages.StringField(7)
  packageType = _messages.StringField(8)
  severityName = _messages.StringField(9)


class Discovered(_messages.Message):
  r"""Provides information about the scan status of a discovered resource.

  Enums:
    AnalysisStatusValueValuesEnum: The status of discovery for the resource.
    ContinuousAnalysisValueValuesEnum: Whether the resource is continuously
      analyzed.

  Fields:
    analysisStatus: The status of discovery for the resource.
    analysisStatusError: When an error is encountered this will contain a
      LocalizedMessage under details to show to the user. The LocalizedMessage
      output only and populated by the API.
    continuousAnalysis: Whether the resource is continuously analyzed.
    cpe: The CPE of the resource being scanned.
    operation: Output only. An operation that indicates the status of the
      current scan. This field is deprecated, do not use.
  """

  class AnalysisStatusValueValuesEnum(_messages.Enum):
    r"""The status of discovery for the resource.

    Values:
      ANALYSIS_STATUS_UNSPECIFIED: Unknown
      PENDING: Resource is known but no action has been taken yet.
      SCANNING: Resource is being analyzed.
      FINISHED_SUCCESS: Analysis has finished successfully.
      FINISHED_FAILED: Analysis has finished unsuccessfully, the analysis
        itself is in a bad state.
      FINISHED_UNSUPPORTED: The resource is known not to be supported.
    """
    ANALYSIS_STATUS_UNSPECIFIED = 0
    PENDING = 1
    SCANNING = 2
    FINISHED_SUCCESS = 3
    FINISHED_FAILED = 4
    FINISHED_UNSUPPORTED = 5

  class ContinuousAnalysisValueValuesEnum(_messages.Enum):
    r"""Whether the resource is continuously analyzed.

    Values:
      CONTINUOUS_ANALYSIS_UNSPECIFIED: Unknown
      ACTIVE: The resource is continuously analyzed.
      INACTIVE: The resource is ignored for continuous analysis.
    """
    CONTINUOUS_ANALYSIS_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  analysisStatus = _messages.EnumField('AnalysisStatusValueValuesEnum', 1)
  analysisStatusError = _messages.MessageField('Status', 2)
  continuousAnalysis = _messages.EnumField('ContinuousAnalysisValueValuesEnum', 3)
  cpe = _messages.StringField(4)
  operation = _messages.MessageField('Operation', 5)


class Discovery(_messages.Message):
  r"""A note that indicates a type of analysis a provider would perform. This
  note exists in a provider's project. A `Discovery` occurrence is created in
  a consumer's project at the start of analysis. The occurrence's operation
  will indicate the status of the analysis. Absence of an occurrence linked to
  this note for a resource indicates that analysis hasn't started.

  Enums:
    AnalysisKindValueValuesEnum: The kind of analysis that is handled by this
      discovery.

  Fields:
    analysisKind: The kind of analysis that is handled by this discovery.
  """

  class AnalysisKindValueValuesEnum(_messages.Enum):
    r"""The kind of analysis that is handled by this discovery.

    Values:
      KIND_UNSPECIFIED: Unknown
      PACKAGE_VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD_DETAILS: The note and occurrence assert build provenance.
      IMAGE_BASIS: This represents an image basis relationship.
      PACKAGE_MANAGER: This represents a package installed via a package
        manager.
      DEPLOYABLE: The note and occurrence track deployment events.
      DISCOVERY: The note and occurrence track the initial discovery status of
        a resource.
      ATTESTATION_AUTHORITY: This represents a logical "role" that can attest
        to artifacts.
      UPGRADE: This represents an available software upgrade.
    """
    KIND_UNSPECIFIED = 0
    PACKAGE_VULNERABILITY = 1
    BUILD_DETAILS = 2
    IMAGE_BASIS = 3
    PACKAGE_MANAGER = 4
    DEPLOYABLE = 5
    DISCOVERY = 6
    ATTESTATION_AUTHORITY = 7
    UPGRADE = 8

  analysisKind = _messages.EnumField('AnalysisKindValueValuesEnum', 1)


class Distribution(_messages.Message):
  r"""This represents a particular channel of distribution for a given
  package. e.g. Debian's jessie-backports dpkg mirror

  Enums:
    ArchitectureValueValuesEnum: The CPU architecture for which packages in
      this distribution channel were built

  Fields:
    architecture: The CPU architecture for which packages in this distribution
      channel were built
    cpeUri: The cpe_uri in [cpe format](https://cpe.mitre.org/specification/)
      denoting the package manager version distributing a package.
    description: The distribution channel-specific description of this
      package.
    latestVersion: The latest available version of this package in this
      distribution channel.
    maintainer: A freeform string denoting the maintainer of this package.
    url: The distribution channel-specific homepage for this package.
  """

  class ArchitectureValueValuesEnum(_messages.Enum):
    r"""The CPU architecture for which packages in this distribution channel
    were built

    Values:
      ARCHITECTURE_UNSPECIFIED: Unknown architecture
      X86: X86 architecture
      X64: X64 architecture
    """
    ARCHITECTURE_UNSPECIFIED = 0
    X86 = 1
    X64 = 2

  architecture = _messages.EnumField('ArchitectureValueValuesEnum', 1)
  cpeUri = _messages.StringField(2)
  description = _messages.StringField(3)
  latestVersion = _messages.MessageField('Version', 4)
  maintainer = _messages.StringField(5)
  url = _messages.StringField(6)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.  Example (Comparison):
  title: "Summary size limit"     description: "Determines if a summary is
  less than 100 chars"     expression: "document.summary.size() < 100"
  Example (Equality):      title: "Requestor is owner"     description:
  "Determines if requestor is the document owner"     expression:
  "document.owner == request.auth.claims.email"  Example (Logic):      title:
  "Public documents"     description: "Determine whether the document should
  be publicly visible"     expression: "document.type != 'private' &&
  document.type != 'internal'"  Example (Data Manipulation):      title:
  "Notification string"     description: "Create a notification string with a
  timestamp."     expression: "'New message received at ' +
  string(document.create_time)"  The exact variables and functions that may be
  referenced within an expression are determined by the service that evaluates
  it. See the service documentation for additional information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FileHashes(_messages.Message):
  r"""Container message for hashes of byte content of files, used in Source
  messages to verify integrity of source input to the build.

  Fields:
    fileHash: Collection of file hashes.
  """

  fileHash = _messages.MessageField('Hash', 1, repeated=True)


class Fingerprint(_messages.Message):
  r"""A set of properties that uniquely identify a given Docker image.

  Fields:
    v1Name: The layer-id of the final layer in the Docker image's v1
      representation. This field can be used as a filter in list requests.
    v2Blob: The ordered list of v2 blobs that represent a given image.
    v2Name: Output only. The name of the image's v2 blobs computed via:
      [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1])
      Only the name of the final blob is kept. This field can be used as a
      filter in list requests.
  """

  v1Name = _messages.StringField(1)
  v2Blob = _messages.StringField(2, repeated=True)
  v2Name = _messages.StringField(3)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.  To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GetVulnzOccurrencesSummaryResponse(_messages.Message):
  r"""A summary of how many vulnz occurrences there are per severity type.
  counts by groups, or if we should have different summary messages like this.

  Fields:
    counts: A map of how many occurrences were found for each severity.
  """

  counts = _messages.MessageField('SeverityCount', 1, repeated=True)


class GoogleDevtoolsContaineranalysisV1alpha1AliasContext(_messages.Message):
  r"""An alias to a repo revision.

  Enums:
    KindValueValuesEnum: The alias kind.

  Fields:
    kind: The alias kind.
    name: The alias name.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      KIND_UNSPECIFIED: Unknown.
      FIXED: Git tag.
      MOVABLE: Git branch.
      OTHER: Used to specify non-standard aliases. For example, if a Git repo
        has a ref named "refs/foo/bar".
    """
    KIND_UNSPECIFIED = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  name = _messages.StringField(2)


class GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContext(_messages.Message):
  r"""A CloudRepoSourceContext denotes a particular revision in a Google Cloud
  Source Repo.

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    repoId: The ID of the repo.
    revisionId: A revision ID.
  """

  aliasContext = _messages.MessageField('GoogleDevtoolsContaineranalysisV1alpha1AliasContext', 1)
  repoId = _messages.MessageField('GoogleDevtoolsContaineranalysisV1alpha1RepoId', 2)
  revisionId = _messages.StringField(3)


class GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContext(_messages.Message):
  r"""A SourceContext referring to a Gerrit project.

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    gerritProject: The full project name within the host. Projects may be
      nested, so "project/subproject" is a valid project name. The "repo name"
      is the hostURI/project.
    hostUri: The URI of a running Gerrit instance.
    revisionId: A revision (commit) ID.
  """

  aliasContext = _messages.MessageField('GoogleDevtoolsContaineranalysisV1alpha1AliasContext', 1)
  gerritProject = _messages.StringField(2)
  hostUri = _messages.StringField(3)
  revisionId = _messages.StringField(4)


class GoogleDevtoolsContaineranalysisV1alpha1GitSourceContext(_messages.Message):
  r"""A GitSourceContext denotes a particular revision in a third party Git
  repository (e.g., GitHub).

  Fields:
    revisionId: Required. Git commit hash.
    url: Git repository URL.
  """

  revisionId = _messages.StringField(1)
  url = _messages.StringField(2)


class GoogleDevtoolsContaineranalysisV1alpha1OperationMetadata(_messages.Message):
  r"""Metadata for all operations used and required for all operations that
  created by Container Analysis Providers

  Fields:
    createTime: Output only. The time this operation was created.
    endTime: Output only. The time that this operation was marked completed or
      failed.
  """

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)


class GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoId(_messages.Message):
  r"""Selects a repo using a Google Cloud Platform project ID (e.g., winged-
  cargo-31) and a repo name within that project.

  Fields:
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  projectId = _messages.StringField(1)
  repoName = _messages.StringField(2)


class GoogleDevtoolsContaineranalysisV1alpha1RepoId(_messages.Message):
  r"""A unique identifier for a Cloud Repo.

  Fields:
    projectRepoId: A combination of a project ID and a repo name.
    uid: A server-assigned, globally unique identifier.
  """

  projectRepoId = _messages.MessageField('GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoId', 1)
  uid = _messages.StringField(2)


class GoogleDevtoolsContaineranalysisV1alpha1SourceContext(_messages.Message):
  r"""A SourceContext is a reference to a tree of files. A SourceContext
  together with a path point to a unique revision of a single file or
  directory.

  Messages:
    LabelsValue: Labels with user defined metadata.

  Fields:
    cloudRepo: A SourceContext referring to a revision in a Google Cloud
      Source Repo.
    gerrit: A SourceContext referring to a Gerrit project.
    git: A SourceContext referring to any third party Git repo (e.g., GitHub).
    labels: Labels with user defined metadata.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels with user defined metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cloudRepo = _messages.MessageField('GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContext', 1)
  gerrit = _messages.MessageField('GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContext', 2)
  git = _messages.MessageField('GoogleDevtoolsContaineranalysisV1alpha1GitSourceContext', 3)
  labels = _messages.MessageField('LabelsValue', 4)


class Hash(_messages.Message):
  r"""Container message for hash values.

  Enums:
    TypeValueValuesEnum: The type of hash that was performed.

  Fields:
    type: The type of hash that was performed.
    value: The hash value.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of hash that was performed.

    Values:
      NONE: No hash requested.
      SHA256: A sha256 hash.
    """
    NONE = 0
    SHA256 = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)
  value = _messages.BytesField(2)


class Installation(_messages.Message):
  r"""This represents how a particular software package may be installed on a
  system.

  Fields:
    location: All of the places within the filesystem versions of this package
      have been found.
    name: Output only. The name of the installed package.
  """

  location = _messages.MessageField('Location', 1, repeated=True)
  name = _messages.StringField(2)


class Layer(_messages.Message):
  r"""Layer holds metadata specific to a layer of a Docker image.

  Enums:
    DirectiveValueValuesEnum: The recovered Dockerfile directive used to
      construct this layer.

  Fields:
    arguments: The recovered arguments to the Dockerfile directive.
    directive: The recovered Dockerfile directive used to construct this
      layer.
  """

  class DirectiveValueValuesEnum(_messages.Enum):
    r"""The recovered Dockerfile directive used to construct this layer.

    Values:
      DIRECTIVE_UNSPECIFIED: Default value for unsupported/missing directive
      MAINTAINER: https://docs.docker.com/engine/reference/builder/
      RUN: https://docs.docker.com/engine/reference/builder/
      CMD: https://docs.docker.com/engine/reference/builder/
      LABEL: https://docs.docker.com/engine/reference/builder/
      EXPOSE: https://docs.docker.com/engine/reference/builder/
      ENV: https://docs.docker.com/engine/reference/builder/
      ADD: https://docs.docker.com/engine/reference/builder/
      COPY: https://docs.docker.com/reference/builder/#copy
      ENTRYPOINT: https://docs.docker.com/engine/reference/builder/
      VOLUME: https://docs.docker.com/engine/reference/builder/
      USER: https://docs.docker.com/engine/reference/builder/
      WORKDIR: https://docs.docker.com/engine/reference/builder/
      ARG: https://docs.docker.com/engine/reference/builder/
      ONBUILD: https://docs.docker.com/engine/reference/builder/
      STOPSIGNAL: https://docs.docker.com/engine/reference/builder/
      HEALTHCHECK: https://docs.docker.com/engine/reference/builder/
      SHELL: https://docs.docker.com/engine/reference/builder/
    """
    DIRECTIVE_UNSPECIFIED = 0
    MAINTAINER = 1
    RUN = 2
    CMD = 3
    LABEL = 4
    EXPOSE = 5
    ENV = 6
    ADD = 7
    COPY = 8
    ENTRYPOINT = 9
    VOLUME = 10
    USER = 11
    WORKDIR = 12
    ARG = 13
    ONBUILD = 14
    STOPSIGNAL = 15
    HEALTHCHECK = 16
    SHELL = 17

  arguments = _messages.StringField(1)
  directive = _messages.EnumField('DirectiveValueValuesEnum', 2)


class ListNoteOccurrencesResponse(_messages.Message):
  r"""Response including listed occurrences for a note.

  Fields:
    nextPageToken: Token to receive the next page of notes.
    occurrences: The occurrences attached to the specified note.
  """

  nextPageToken = _messages.StringField(1)
  occurrences = _messages.MessageField('Occurrence', 2, repeated=True)


class ListNotesResponse(_messages.Message):
  r"""Response including listed notes.

  Fields:
    nextPageToken: The next pagination token in the list response. It should
      be used as page_token for the following request. An empty value means no
      more result.
    notes: The occurrences requested
  """

  nextPageToken = _messages.StringField(1)
  notes = _messages.MessageField('Note', 2, repeated=True)


class ListOccurrencesResponse(_messages.Message):
  r"""Response including listed active occurrences.

  Fields:
    nextPageToken: The next pagination token in the list response. It should
      be used as `page_token` for the following request. An empty value means
      no more results.
    occurrences: The occurrences requested.
  """

  nextPageToken = _messages.StringField(1)
  occurrences = _messages.MessageField('Occurrence', 2, repeated=True)


class ListScanConfigsResponse(_messages.Message):
  r"""A list of scan configs for the project.

  Fields:
    nextPageToken: A page token to pass in order to get more scan configs.
    scanConfigs: The set of scan configs.
  """

  nextPageToken = _messages.StringField(1)
  scanConfigs = _messages.MessageField('ScanConfig', 2, repeated=True)


class Location(_messages.Message):
  r"""An occurrence of a particular package installation found within a
  system's filesystem. e.g. glibc was found in /var/lib/dpkg/status

  Fields:
    cpeUri: The cpe_uri in [cpe format](https://cpe.mitre.org/specification/)
      denoting the package manager version distributing a package.
    path: The path from which we gathered that this package/version is
      installed.
    version: The version installed at this location.
  """

  cpeUri = _messages.StringField(1)
  path = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class Note(_messages.Message):
  r"""Provides a detailed description of a `Note`.

  Enums:
    KindValueValuesEnum: Output only. This explicitly denotes which kind of
      note is specified. This field can be used as a filter in list requests.

  Fields:
    attestationAuthority: A note describing an attestation role.
    baseImage: A note describing a base image.
    buildType: Build provenance type for a verifiable build.
    createTime: Output only. The time this note was created. This field can be
      used as a filter in list requests.
    deployable: A note describing something that can be deployed.
    discovery: A note describing a provider/analysis type.
    expirationTime: Time of expiration for this note, null if note does not
      expire.
    kind: Output only. This explicitly denotes which kind of note is
      specified. This field can be used as a filter in list requests.
    longDescription: A detailed description of this `Note`.
    name: The name of the note in the form
      "projects/{provider_project_id}/notes/{NOTE_ID}"
    package: A note describing a package hosted by various package managers.
    relatedUrl: URLs associated with this note
    shortDescription: A one sentence description of this `Note`.
    updateTime: Output only. The time this note was last updated. This field
      can be used as a filter in list requests.
    upgrade: A note describing an upgrade.
    vulnerabilityType: A package vulnerability type of note.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Output only. This explicitly denotes which kind of note is specified.
    This field can be used as a filter in list requests.

    Values:
      KIND_UNSPECIFIED: Unknown
      PACKAGE_VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD_DETAILS: The note and occurrence assert build provenance.
      IMAGE_BASIS: This represents an image basis relationship.
      PACKAGE_MANAGER: This represents a package installed via a package
        manager.
      DEPLOYABLE: The note and occurrence track deployment events.
      DISCOVERY: The note and occurrence track the initial discovery status of
        a resource.
      ATTESTATION_AUTHORITY: This represents a logical "role" that can attest
        to artifacts.
      UPGRADE: This represents an available software upgrade.
    """
    KIND_UNSPECIFIED = 0
    PACKAGE_VULNERABILITY = 1
    BUILD_DETAILS = 2
    IMAGE_BASIS = 3
    PACKAGE_MANAGER = 4
    DEPLOYABLE = 5
    DISCOVERY = 6
    ATTESTATION_AUTHORITY = 7
    UPGRADE = 8

  attestationAuthority = _messages.MessageField('AttestationAuthority', 1)
  baseImage = _messages.MessageField('Basis', 2)
  buildType = _messages.MessageField('BuildType', 3)
  createTime = _messages.StringField(4)
  deployable = _messages.MessageField('Deployable', 5)
  discovery = _messages.MessageField('Discovery', 6)
  expirationTime = _messages.StringField(7)
  kind = _messages.EnumField('KindValueValuesEnum', 8)
  longDescription = _messages.StringField(9)
  name = _messages.StringField(10)
  package = _messages.MessageField('Package', 11)
  relatedUrl = _messages.MessageField('RelatedUrl', 12, repeated=True)
  shortDescription = _messages.StringField(13)
  updateTime = _messages.StringField(14)
  upgrade = _messages.MessageField('UpgradeNote', 15)
  vulnerabilityType = _messages.MessageField('VulnerabilityType', 16)


class Occurrence(_messages.Message):
  r"""`Occurrence` includes information about analysis occurrences for an
  image.

  Enums:
    KindValueValuesEnum: Output only. This explicitly denotes which of the
      `Occurrence` details are specified. This field can be used as a filter
      in list requests.

  Fields:
    attestation: Describes an attestation of an artifact.
    buildDetails: Build details for a verifiable build.
    createTime: Output only. The time this `Occurrence` was created.
    deployment: Describes the deployment of an artifact on a runtime.
    derivedImage: Describes how this resource derives from the basis in the
      associated note.
    discovered: Describes the initial scan status for this resource.
    installation: Describes the installation of a package on the linked
      resource.
    kind: Output only. This explicitly denotes which of the `Occurrence`
      details are specified. This field can be used as a filter in list
      requests.
    name: Output only. The name of the `Occurrence` in the form
      "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
    noteName: An analysis note associated with this image, in the form
      "providers/{provider_id}/notes/{NOTE_ID}" This field can be used as a
      filter in list requests.
    remediation: A description of actions that can be taken to remedy the
      `Note`
    resource:  The resource for which the `Occurrence` applies.
    resourceUrl: The unique URL of the image or the container for which the
      `Occurrence` applies. For example,
      https://gcr.io/project/image@sha256:foo This field can be used as a
      filter in list requests.
    updateTime: Output only. The time this `Occurrence` was last updated.
    upgrade: Describes an upgrade.
    vulnerabilityDetails: Details of a security vulnerability note.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Output only. This explicitly denotes which of the `Occurrence` details
    are specified. This field can be used as a filter in list requests.

    Values:
      KIND_UNSPECIFIED: Unknown
      PACKAGE_VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD_DETAILS: The note and occurrence assert build provenance.
      IMAGE_BASIS: This represents an image basis relationship.
      PACKAGE_MANAGER: This represents a package installed via a package
        manager.
      DEPLOYABLE: The note and occurrence track deployment events.
      DISCOVERY: The note and occurrence track the initial discovery status of
        a resource.
      ATTESTATION_AUTHORITY: This represents a logical "role" that can attest
        to artifacts.
      UPGRADE: This represents an available software upgrade.
    """
    KIND_UNSPECIFIED = 0
    PACKAGE_VULNERABILITY = 1
    BUILD_DETAILS = 2
    IMAGE_BASIS = 3
    PACKAGE_MANAGER = 4
    DEPLOYABLE = 5
    DISCOVERY = 6
    ATTESTATION_AUTHORITY = 7
    UPGRADE = 8

  attestation = _messages.MessageField('Attestation', 1)
  buildDetails = _messages.MessageField('BuildDetails', 2)
  createTime = _messages.StringField(3)
  deployment = _messages.MessageField('Deployment', 4)
  derivedImage = _messages.MessageField('Derived', 5)
  discovered = _messages.MessageField('Discovered', 6)
  installation = _messages.MessageField('Installation', 7)
  kind = _messages.EnumField('KindValueValuesEnum', 8)
  name = _messages.StringField(9)
  noteName = _messages.StringField(10)
  remediation = _messages.StringField(11)
  resource = _messages.MessageField('Resource', 12)
  resourceUrl = _messages.StringField(13)
  updateTime = _messages.StringField(14)
  upgrade = _messages.MessageField('UpgradeOccurrence', 15)
  vulnerabilityDetails = _messages.MessageField('VulnerabilityDetails', 16)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Package(_messages.Message):
  r"""This represents a particular package that is distributed over various
  channels. e.g. glibc (aka libc6) is distributed by many, at various
  versions.

  Fields:
    distribution: The various channels by which a package is distributed.
    name: The name of the package.
  """

  distribution = _messages.MessageField('Distribution', 1, repeated=True)
  name = _messages.StringField(2)


class PackageIssue(_messages.Message):
  r"""This message wraps a location affected by a vulnerability and its
  associated fix (if one is available).

  Fields:
    affectedLocation: The location of the vulnerability.
    fixedLocation: The location of the available fix for vulnerability.
    severityName: A string attribute.
  """

  affectedLocation = _messages.MessageField('VulnerabilityLocation', 1)
  fixedLocation = _messages.MessageField('VulnerabilityLocation', 2)
  severityName = _messages.StringField(3)


class PgpSignedAttestation(_messages.Message):
  r"""An attestation wrapper with a PGP-compatible signature. This message
  only supports `ATTACHED` signatures, where the payload that is signed is
  included alongside the signature itself in the same file.

  Enums:
    ContentTypeValueValuesEnum: Type (for example schema) of the attestation
      payload that was signed. The verifier must ensure that the provided type
      is one that the verifier supports, and that the attestation payload is a
      valid instantiation of that type (for example by validating a JSON
      schema).

  Fields:
    contentType: Type (for example schema) of the attestation payload that was
      signed. The verifier must ensure that the provided type is one that the
      verifier supports, and that the attestation payload is a valid
      instantiation of that type (for example by validating a JSON schema).
    pgpKeyId: The cryptographic fingerprint of the key used to generate the
      signature, as output by, e.g. `gpg --list-keys`. This should be the
      version 4, full 160-bit fingerprint, expressed as a 40 character
      hexadecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2
      for details. Implementations may choose to acknowledge "LONG", "SHORT",
      or other abbreviated key IDs, but only the full fingerprint is
      guaranteed to work. In gpg, the full fingerprint can be retrieved from
      the `fpr` field returned when calling --list-keys with --with-colons.
      For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \
      --list-keys attester@example.com tru::1:1513631572:0:3:1:5
      pub:...<SNIP>... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB:
      ``` Above, the fingerprint is
      `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
    signature: The raw content of the signature, as output by GNU Privacy
      Guard (GPG) or equivalent.  Since this message only supports attached
      signatures, the payload that was signed must be attached. While the
      signature format supported is dependent on the verification
      implementation, currently only ASCII-armored (`--armor` to gpg), non-
      clearsigned (`--sign` rather than `--clearsign` to gpg) are supported.
      Concretely, `gpg --sign --armor --output=signature.gpg payload.json`
      will create the signature content expected in this field in
      `signature.gpg` for the `payload.json` attestation payload.
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Type (for example schema) of the attestation payload that was signed.
    The verifier must ensure that the provided type is one that the verifier
    supports, and that the attestation payload is a valid instantiation of
    that type (for example by validating a JSON schema).

    Values:
      CONTENT_TYPE_UNSPECIFIED: `ContentType` is not set.
      SIMPLE_SIGNING_JSON: Atomic format attestation signature. See https://gi
        thub.com/containers/image/blob/8a5d2f82a6e3263290c8e0276c3e0f64e77723e
        7/docs/atomic-signature.md The payload extracted from `signature` is a
        JSON blob conforming to the linked schema.
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    SIMPLE_SIGNING_JSON = 1

  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 1)
  pgpKeyId = _messages.StringField(2)
  signature = _messages.StringField(3)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.   A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role.  For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies).  **JSON example:**      {       "bindings": [         {
  "role": "roles/resourcemanager.organizationAdmin",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/resourcemanager.organizationViewer",           "members": [
  "user:eve@example.com"           ],           "condition": {
  "title": "expirable access",             "description": "Does not grant
  access after Sep 2020",             "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",           }         }       ],
  "etag": "BwWWja0YfJA=",       "version": 3     }  **YAML example:**
  bindings:     - members:       - user:mike@example.com       -
  group:admins@example.com       - domain:google.com       -
  serviceAccount:my-project-id@appspot.gserviceaccount.com       role:
  roles/resourcemanager.organizationAdmin     - members:       -
  user:eve@example.com       role: roles/resourcemanager.organizationViewer
  condition:         title: expirable access         description: Does not
  grant access after Sep 2020         expression: request.time <
  timestamp('2020-10-01T00:00:00.000Z')     - etag: BwWWja0YfJA=     -
  version: 3  For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy.  Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected.  Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations:  * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy   that includes conditions  **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost.  If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset.  To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class RelatedUrl(_messages.Message):
  r"""Metadata for any related URL information

  Fields:
    label: Label to describe usage of the URL
    url: Specific URL to associate with the note
  """

  label = _messages.StringField(1)
  url = _messages.StringField(2)


class RepoSource(_messages.Message):
  r"""RepoSource describes the location of the source in a Google Cloud Source
  Repository.

  Fields:
    branchName: Name of the branch to build.
    commitSha: Explicit commit SHA to build.
    projectId: ID of the project that owns the repo.
    repoName: Name of the repo.
    tagName: Name of the tag to build.
  """

  branchName = _messages.StringField(1)
  commitSha = _messages.StringField(2)
  projectId = _messages.StringField(3)
  repoName = _messages.StringField(4)
  tagName = _messages.StringField(5)


class Resource(_messages.Message):
  r""" Resource is an entity that can have metadata. E.g., a Docker image.

  Fields:
    contentHash: The hash of the resource content. E.g., the Docker digest.
    name: The name of the resource. E.g., the name of a Docker image -
      "Debian".
    uri: The unique URI of the resource. E.g.,
      "https://gcr.io/project/image@sha256:foo" for a Docker image.
  """

  contentHash = _messages.MessageField('Hash', 1)
  name = _messages.StringField(2)
  uri = _messages.StringField(3)


class ScanConfig(_messages.Message):
  r"""Indicates various scans and whether they are turned on or off.

  Fields:
    createTime: Output only. The time this scan config was created.
    description: Output only. A human-readable description of what the
      `ScanConfig` does.
    enabled: Indicates whether the Scan is enabled.
    name: Output only. The name of the ScanConfig in the form
      "projects/{project_id}/scanConfigs/{scan_config_id}".
    updateTime: Output only. The time this scan config was last updated.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  enabled = _messages.BooleanField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class SeverityCount(_messages.Message):
  r"""The number of occurrences created for a specific severity.

  Enums:
    SeverityValueValuesEnum: The severity of the occurrences.

  Fields:
    count: The number of occurrences with the severity.
    severity: The severity of the occurrences.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the occurrences.

    Values:
      SEVERITY_UNSPECIFIED: Unknown Impact
      MINIMAL: Minimal Impact
      LOW: Low Impact
      MEDIUM: Medium Impact
      HIGH: High Impact
      CRITICAL: Critical Impact
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  count = _messages.IntegerField(1)
  severity = _messages.EnumField('SeverityValueValuesEnum', 2)


class Source(_messages.Message):
  r"""Source describes the location of the source used for the build.

  Messages:
    FileHashesValue: Hash(es) of the build source, which can be used to verify
      that the original source integrity was maintained in the build.  The
      keys to this map are file paths used as build source and the values
      contain the hash values for those files.  If the build source came in a
      single package such as a gzipped tarfile (.tar.gz), the FileHash will be
      for the single path to that file.

  Fields:
    additionalContexts: If provided, some of the source code used for the
      build may be found in these locations, in the case where the source
      repository had multiple remotes or submodules. This list will not
      include the context specified in the context field.
    artifactStorageSource: If provided, the input binary artifacts for the
      build came from this location.
    context: If provided, the source code used for the build came from this
      location.
    fileHashes: Hash(es) of the build source, which can be used to verify that
      the original source integrity was maintained in the build.  The keys to
      this map are file paths used as build source and the values contain the
      hash values for those files.  If the build source came in a single
      package such as a gzipped tarfile (.tar.gz), the FileHash will be for
      the single path to that file.
    repoSource: If provided, get source from this location in a Cloud Repo.
    storageSource: If provided, get the source from this location in in Google
      Cloud Storage.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FileHashesValue(_messages.Message):
    r"""Hash(es) of the build source, which can be used to verify that the
    original source integrity was maintained in the build.  The keys to this
    map are file paths used as build source and the values contain the hash
    values for those files.  If the build source came in a single package such
    as a gzipped tarfile (.tar.gz), the FileHash will be for the single path
    to that file.

    Messages:
      AdditionalProperty: An additional property for a FileHashesValue object.

    Fields:
      additionalProperties: Additional properties of type FileHashesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FileHashesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileHashes attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileHashes', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContexts = _messages.MessageField('GoogleDevtoolsContaineranalysisV1alpha1SourceContext', 1, repeated=True)
  artifactStorageSource = _messages.MessageField('StorageSource', 2)
  context = _messages.MessageField('GoogleDevtoolsContaineranalysisV1alpha1SourceContext', 3)
  fileHashes = _messages.MessageField('FileHashesValue', 4)
  repoSource = _messages.MessageField('RepoSource', 5)
  storageSource = _messages.MessageField('StorageSource', 6)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StorageSource(_messages.Message):
  r"""StorageSource describes the location of the source in an archive file in
  Google Cloud Storage.

  Fields:
    bucket: Google Cloud Storage bucket containing source (see [Bucket Name
      Requirements] (https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).
    generation: Google Cloud Storage generation for the object.
    object: Google Cloud Storage object containing source.
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UpdateOperationRequest(_messages.Message):
  r"""Request for updating an existing operation

  Fields:
    operation: The operation to create.
    updateMask: The fields to update.
  """

  operation = _messages.MessageField('Operation', 1)
  updateMask = _messages.StringField(2)


class UpgradeDistribution(_messages.Message):
  r"""The Upgrade Distribution represents metadata about the Upgrade for each
  operating system (CPE). Some distributions have additional metadata around
  updates, classifying them into various categories and severities.

  Fields:
    classification: The operating system classification of this Upgrade, as
      specified by the upstream operating system upgrade feed.
    cpeUri: Required - The specific operating system this metadata applies to.
      See https://cpe.mitre.org/specification/.
    cve: The cve that would be resolved by this upgrade.
    severity: The severity as specified by the upstream operating system.
  """

  classification = _messages.StringField(1)
  cpeUri = _messages.StringField(2)
  cve = _messages.StringField(3, repeated=True)
  severity = _messages.StringField(4)


class UpgradeNote(_messages.Message):
  r"""An Upgrade Note represents a potential upgrade of a package to a given
  version. For each package version combination (i.e. bash 4.0, bash 4.1, bash
  4.1.2), there will be a Upgrade Note.

  Fields:
    distributions: Metadata about the upgrade for each specific operating
      system.
    package: Required - The package this Upgrade is for.
    version: Required - The version of the package in machine + human readable
      form.
  """

  distributions = _messages.MessageField('UpgradeDistribution', 1, repeated=True)
  package = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class UpgradeOccurrence(_messages.Message):
  r"""An Upgrade Occurrence represents that a specific resource_url could
  install a specific upgrade. This presence is supplied via local sources
  (i.e. it is present in the mirror and the running system has noticed its
  availability).

  Fields:
    distribution: Metadata about the upgrade for available for the specific
      operating system for the resource_url. This allows efficient filtering,
      as well as making it easier to use the occurrence.
    package: Required - The package this Upgrade is for.
    parsedVersion: Required - The version of the package in a machine + human
      readable form.
  """

  distribution = _messages.MessageField('UpgradeDistribution', 1)
  package = _messages.StringField(2)
  parsedVersion = _messages.MessageField('Version', 3)


class Version(_messages.Message):
  r"""Version contains structured information about the version of the
  package. For a discussion of this in Debian/Ubuntu:
  http://serverfault.com/questions/604541/debian-packages-version-convention
  For a discussion of this in Redhat/Fedora/Centos:
  http://blog.jasonantman.com/2014/07/how-yum-and-rpm-compare-versions/

  Enums:
    KindValueValuesEnum: Distinguish between sentinel MIN/MAX versions and
      normal versions. If kind is not NORMAL, then the other fields are
      ignored.

  Fields:
    epoch: Used to correct mistakes in the version numbering scheme.
    kind: Distinguish between sentinel MIN/MAX versions and normal versions.
      If kind is not NORMAL, then the other fields are ignored.
    name: The main part of the version name.
    revision: The iteration of the package build from the above version.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Distinguish between sentinel MIN/MAX versions and normal versions. If
    kind is not NORMAL, then the other fields are ignored.

    Values:
      NORMAL: A standard package version, defined by the other fields.
      MINIMUM: A special version representing negative infinity, other fields
        are ignored.
      MAXIMUM: A special version representing positive infinity, other fields
        are ignored.
    """
    NORMAL = 0
    MINIMUM = 1
    MAXIMUM = 2

  epoch = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  kind = _messages.EnumField('KindValueValuesEnum', 2)
  name = _messages.StringField(3)
  revision = _messages.StringField(4)


class VulnerabilityDetails(_messages.Message):
  r"""Used by Occurrence to point to where the vulnerability exists and how to
  fix it.

  Enums:
    EffectiveSeverityValueValuesEnum: The distro assigned severity for this
      vulnerability when that is available and note provider assigned severity
      when distro has not yet assigned a severity for this vulnerability.
    SeverityValueValuesEnum: Output only. The note provider assigned Severity
      of the vulnerability.

  Fields:
    cvssScore: Output only. The CVSS score of this vulnerability. CVSS score
      is on a scale of 0-10 where 0 indicates low severity and 10 indicates
      high severity.
    effectiveSeverity: The distro assigned severity for this vulnerability
      when that is available and note provider assigned severity when distro
      has not yet assigned a severity for this vulnerability.
    packageIssue: The set of affected locations and their fixes (if available)
      within the associated resource.
    severity: Output only. The note provider assigned Severity of the
      vulnerability.
    type: The type of package; whether native or non native(ruby gems, node.js
      packages etc)
  """

  class EffectiveSeverityValueValuesEnum(_messages.Enum):
    r"""The distro assigned severity for this vulnerability when that is
    available and note provider assigned severity when distro has not yet
    assigned a severity for this vulnerability.

    Values:
      SEVERITY_UNSPECIFIED: Unknown Impact
      MINIMAL: Minimal Impact
      LOW: Low Impact
      MEDIUM: Medium Impact
      HIGH: High Impact
      CRITICAL: Critical Impact
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Output only. The note provider assigned Severity of the vulnerability.

    Values:
      SEVERITY_UNSPECIFIED: Unknown Impact
      MINIMAL: Minimal Impact
      LOW: Low Impact
      MEDIUM: Medium Impact
      HIGH: High Impact
      CRITICAL: Critical Impact
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  cvssScore = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  effectiveSeverity = _messages.EnumField('EffectiveSeverityValueValuesEnum', 2)
  packageIssue = _messages.MessageField('PackageIssue', 3, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 4)
  type = _messages.StringField(5)


class VulnerabilityLocation(_messages.Message):
  r"""The location of the vulnerability

  Fields:
    cpeUri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/)
      format. Examples include distro or storage location for vulnerable jar.
      This field can be used as a filter in list requests.
    package: The package being described.
    version: The version of the package being described. This field can be
      used as a filter in list requests.
  """

  cpeUri = _messages.StringField(1)
  package = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class VulnerabilityType(_messages.Message):
  r"""VulnerabilityType provides metadata about a security vulnerability.

  Enums:
    SeverityValueValuesEnum: Note provider assigned impact of the
      vulnerability

  Fields:
    cvssScore: The CVSS score for this Vulnerability.
    details: All information about the package to specifically identify this
      vulnerability. One entry per (version range and cpe_uri) the package
      vulnerability has manifested in.
    severity: Note provider assigned impact of the vulnerability
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Note provider assigned impact of the vulnerability

    Values:
      SEVERITY_UNSPECIFIED: Unknown Impact
      MINIMAL: Minimal Impact
      LOW: Low Impact
      MEDIUM: Medium Impact
      HIGH: High Impact
      CRITICAL: Critical Impact
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  cvssScore = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  details = _messages.MessageField('Detail', 2, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
