"""Generated message classes for pubsublite version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'pubsublite'


class Cursor(_messages.Message):
  r"""A cursor that describes the position of a message within a topic
  partition.

  Fields:
    offset: The offset of a message within a topic partition. Must be greater
      than or equal 0.
  """

  offset = _messages.IntegerField(1)


class DeliveryConfig(_messages.Message):
  r"""The settings for a subscription's message delivery.

  Enums:
    DeliveryRequirementValueValuesEnum: The DeliveryRequirement for this
      subscription.

  Fields:
    deliveryRequirement: The DeliveryRequirement for this subscription.
  """

  class DeliveryRequirementValueValuesEnum(_messages.Enum):
    r"""The DeliveryRequirement for this subscription.

    Values:
      DELIVERY_REQUIREMENT_UNSPECIFIED: Default value. This value is unused.
      DELIVER_IMMEDIATELY: The server does not wait for a published message to
        be successfully written to storage before delivering it to
        subscribers. As such, a subscriber may receive a message for which the
        write to storage failed. If the subscriber re-reads the offset of that
        message later on (e.g., after a `Seek` operation), there may be a gap
        at that offset. Even if not re-reading messages, the delivery of
        messages for which the write to storage fails may be inconsistent
        across subscriptions, with some receiving the message (e.g., those
        connected at the time the message is published) and others not
        receiving it (e.g., those disconnected at publish time). Note that
        offsets are never reused, so even if DELIVER_IMMEDIATELY is used,
        subscribers will not receive different messages when re-reading, they
        will just see gaps. EXAMPLE:   (0) Topic 'topic1' is created with a
        single partition.   (1) Two subscriptions 'sub1' and 'sub2' are
        created on topic1. sub1       has 'DELIVER_IMMEDIATELY', sub2 has
        'DELIVER_AFTER_STORED'.   (2) A stream is opened for sub1 but not
        sub2.   (3) A stream is opened for a publisher client using pub1.
        (4) pub1 successfully publishes m0 at offset 0 and m0 is delivered to
        sub1.   (5) pub1 publishes m1 at offset 1 and m1 is delivered to sub1
        but the       write to storage fails (their stream then breaks).   (6)
        A stream is reopened for pub1.   (6) pub1 successfully publishes m2 at
        offset 2 and m2 is delivered to       sub1.   (some time elapses...)
        (7) A stream is opened for sub2 and it receives m0 and m2 but not m1.
        (8) sub1 seeks to offset 1 but only receives m2 and not m1.
      DELIVER_AFTER_STORED: The server will not deliver a published message to
        subscribers until the message has been successfully written to
        storage. This will result in higher end-to-end latency, but consistent
        delivery.
    """
    DELIVERY_REQUIREMENT_UNSPECIFIED = 0
    DELIVER_IMMEDIATELY = 1
    DELIVER_AFTER_STORED = 2

  deliveryRequirement = _messages.EnumField('DeliveryRequirementValueValuesEnum', 1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ListPartitionCursorsResponse(_messages.Message):
  r"""Response for ListPartitionCursors

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    partitionCursors: The partition cursors from this request.
  """

  nextPageToken = _messages.StringField(1)
  partitionCursors = _messages.MessageField('PartitionCursor', 2, repeated=True)


class ListSubscriptionsResponse(_messages.Message):
  r"""Response for ListSubscriptions.

  Fields:
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page of results. If this field is omitted, there are no more
      results.
    subscriptions: The list of subscriptions in the requested parent. The
      order of the subscriptions is unspecified.
  """

  nextPageToken = _messages.StringField(1)
  subscriptions = _messages.MessageField('Subscription', 2, repeated=True)


class ListTopicSubscriptionsResponse(_messages.Message):
  r"""Response for ListTopicSubscriptions.

  Fields:
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page of results. If this field is omitted, there are no more
      results.
    subscriptions: The names of subscriptions attached to the topic. The order
      of the subscriptions is unspecified.
  """

  nextPageToken = _messages.StringField(1)
  subscriptions = _messages.StringField(2, repeated=True)


class ListTopicsResponse(_messages.Message):
  r"""Response for ListTopics.

  Fields:
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page of results. If this field is omitted, there are no more
      results.
    topics: The list of topic in the requested parent. The order of the topics
      is unspecified.
  """

  nextPageToken = _messages.StringField(1)
  topics = _messages.MessageField('Topic', 2, repeated=True)


class PartitionConfig(_messages.Message):
  r"""The settings for a topic's partitions.

  Fields:
    count: The number of partitions in the topic. Must be at least 1.
    scale: Every partition in the topic is allocated throughput equivalent to
      `scale` times the standard partition throughput (4 MiB/s). This is also
      reflected in the cost of this topic; a topic with `scale` of 2 and count
      of 10 is charged for 20 partitions. This value must be in the range
      [1,4].
  """

  count = _messages.IntegerField(1)
  scale = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class PartitionCursor(_messages.Message):
  r"""A pair of a Cursor and the partition it is for.

  Fields:
    cursor: The value of the cursor.
    partition: The partition this is for.
  """

  cursor = _messages.MessageField('Cursor', 1)
  partition = _messages.IntegerField(2)


class PubsubliteAdminProjectsLocationsSubscriptionsCreateRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsSubscriptionsCreateRequest object.

  Fields:
    parent: Required. The parent location in which to create the subscription.
      Structured like `projects/{project_number}/locations/{location}`.
    subscription: A Subscription resource to be passed as the request body.
    subscriptionId: Required. The ID to use for the subscription, which will
      become the final component of the subscription's name.  This value is
      structured like: `my-sub-name`.
  """

  parent = _messages.StringField(1, required=True)
  subscription = _messages.MessageField('Subscription', 2)
  subscriptionId = _messages.StringField(3)


class PubsubliteAdminProjectsLocationsSubscriptionsDeleteRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsSubscriptionsDeleteRequest object.

  Fields:
    name: Required. The name of the subscription to delete.
  """

  name = _messages.StringField(1, required=True)


class PubsubliteAdminProjectsLocationsSubscriptionsGetRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsSubscriptionsGetRequest object.

  Fields:
    name: Required. The name of the subscription whose configuration to
      return.
  """

  name = _messages.StringField(1, required=True)


class PubsubliteAdminProjectsLocationsSubscriptionsListRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsSubscriptionsListRequest object.

  Fields:
    pageSize: The maximum number of subscriptions to return. The service may
      return fewer than this value. If unset or zero, all subscriptions for
      the parent will be returned.
    pageToken: A page token, received from a previous `ListSubscriptions`
      call. Provide this to retrieve the subsequent page.  When paginating,
      all other parameters provided to `ListSubscriptions` must match the call
      that provided the page token.
    parent: Required. The parent whose subscriptions are to be listed.
      Structured like `projects/{project_number}/locations/{location}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PubsubliteAdminProjectsLocationsSubscriptionsPatchRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsSubscriptionsPatchRequest object.

  Fields:
    name: The name of the subscription. Structured like: projects/{project_num
      ber}/locations/{location}/subscriptions/{subscription_id}
    subscription: A Subscription resource to be passed as the request body.
    updateMask: Required. A mask specifying the subscription fields to change.
  """

  name = _messages.StringField(1, required=True)
  subscription = _messages.MessageField('Subscription', 2)
  updateMask = _messages.StringField(3)


class PubsubliteAdminProjectsLocationsTopicsCreateRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsTopicsCreateRequest object.

  Fields:
    parent: Required. The parent location in which to create the topic.
      Structured like `projects/{project_number}/locations/{location}`.
    topic: A Topic resource to be passed as the request body.
    topicId: Required. The ID to use for the topic, which will become the
      final component of the topic's name.  This value is structured like:
      `my-topic-name`.
  """

  parent = _messages.StringField(1, required=True)
  topic = _messages.MessageField('Topic', 2)
  topicId = _messages.StringField(3)


class PubsubliteAdminProjectsLocationsTopicsDeleteRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsTopicsDeleteRequest object.

  Fields:
    name: Required. The name of the topic to delete.
  """

  name = _messages.StringField(1, required=True)


class PubsubliteAdminProjectsLocationsTopicsGetPartitionsRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsTopicsGetPartitionsRequest object.

  Fields:
    name: Required. The topic whose partition information to return.
  """

  name = _messages.StringField(1, required=True)


class PubsubliteAdminProjectsLocationsTopicsGetRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsTopicsGetRequest object.

  Fields:
    name: Required. The name of the topic whose configuration to return.
  """

  name = _messages.StringField(1, required=True)


class PubsubliteAdminProjectsLocationsTopicsListRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsTopicsListRequest object.

  Fields:
    pageSize: The maximum number of topics to return. The service may return
      fewer than this value. If unset or zero, all topics for the parent will
      be returned.
    pageToken: A page token, received from a previous `ListTopics` call.
      Provide this to retrieve the subsequent page.  When paginating, all
      other parameters provided to `ListTopics` must match the call that
      provided the page token.
    parent: Required. The parent whose topics are to be listed. Structured
      like `projects/{project_number}/locations/{location}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PubsubliteAdminProjectsLocationsTopicsPatchRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsTopicsPatchRequest object.

  Fields:
    name: The name of the topic. Structured like:
      projects/{project_number}/locations/{location}/topics/{topic_id}
    topic: A Topic resource to be passed as the request body.
    updateMask: Required. A mask specifying the topic fields to change.
  """

  name = _messages.StringField(1, required=True)
  topic = _messages.MessageField('Topic', 2)
  updateMask = _messages.StringField(3)


class PubsubliteAdminProjectsLocationsTopicsSubscriptionsListRequest(_messages.Message):
  r"""A PubsubliteAdminProjectsLocationsTopicsSubscriptionsListRequest object.

  Fields:
    name: Required. The name of the topic whose subscriptions to list.
    pageSize: The maximum number of subscriptions to return. The service may
      return fewer than this value. If unset or zero, all subscriptions for
      the given topic will be returned.
    pageToken: A page token, received from a previous `ListTopicSubscriptions`
      call. Provide this to retrieve the subsequent page.  When paginating,
      all other parameters provided to `ListTopicSubscriptions` must match the
      call that provided the page token.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class PubsubliteCursorProjectsLocationsSubscriptionsCursorsListRequest(_messages.Message):
  r"""A PubsubliteCursorProjectsLocationsSubscriptionsCursorsListRequest
  object.

  Fields:
    pageSize: The maximum number of cursors to return. The service may return
      fewer than this value. If unset or zero, all cursors for the parent will
      be returned.
    pageToken: A page token, received from a previous `ListPartitionCursors`
      call. Provide this to retrieve the subsequent page.  When paginating,
      all other parameters provided to `ListPartitionCursors` must match the
      call that provided the page token.
    parent: Required. The subscription for which to retrieve cursors.
      Structured like `projects/{project_number}/locations/{location}/subscrip
      tions/{subscription_id}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class RetentionConfig(_messages.Message):
  r"""The settings for a topic's message retention.

  Fields:
    perPartitionBytes: The provisioned storage, in bytes, per partition. If
      the number of bytes stored in any of the topic's partitions grows beyond
      this value, older messages will be dropped to make room for newer ones,
      regardless of the value of `period`.
    period: How long a published message is retained. If unset, messages will
      be retained as long as the bytes retained for each partition is below
      `per_partition_bytes`.
  """

  perPartitionBytes = _messages.IntegerField(1)
  period = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Subscription(_messages.Message):
  r"""Metadata about a subscription resource.

  Fields:
    deliveryConfig: The settings for this subscription's message delivery.
    name: The name of the subscription. Structured like: projects/{project_num
      ber}/locations/{location}/subscriptions/{subscription_id}
    topic: The name of the topic this subscription is attached to. Structured
      like: projects/{project_number}/locations/{location}/topics/{topic_id}
  """

  deliveryConfig = _messages.MessageField('DeliveryConfig', 1)
  name = _messages.StringField(2)
  topic = _messages.StringField(3)


class Topic(_messages.Message):
  r"""Metadata about a topic resource.

  Fields:
    name: The name of the topic. Structured like:
      projects/{project_number}/locations/{location}/topics/{topic_id}
    partitionConfig: The settings for this topic's partitions.
    retentionConfig: The settings for this topic's message retention.
  """

  name = _messages.StringField(1)
  partitionConfig = _messages.MessageField('PartitionConfig', 2)
  retentionConfig = _messages.MessageField('RetentionConfig', 3)


class TopicPartitions(_messages.Message):
  r"""Response for GetTopicPartitions.

  Fields:
    partitionCount: The number of partitions in the topic.
  """

  partitionCount = _messages.IntegerField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
