"""Generated client library for sqladmin version v1beta4."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.sqladmin.v1beta4 import sqladmin_v1beta4_messages as messages


class SqladminV1beta4(base_api.BaseApiClient):
  """Generated client library for service sqladmin version v1beta4."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://www.googleapis.com/sql/v1beta4/'

  _PACKAGE = u'sqladmin'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/sqlservice.admin']
  _VERSION = u'v1beta4'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'SqladminV1beta4'
  _URL_VERSION = u'v1beta4'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new sqladmin handle."""
    url = url or self.BASE_URL
    super(SqladminV1beta4, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.backupRuns = self.BackupRunsService(self)
    self.databases = self.DatabasesService(self)
    self.flags = self.FlagsService(self)
    self.instances = self.InstancesService(self)
    self.operations = self.OperationsService(self)
    self.sslCerts = self.SslCertsService(self)
    self.tiers = self.TiersService(self)
    self.users = self.UsersService(self)

  class BackupRunsService(base_api.BaseApiService):
    """Service class for the backupRuns resource."""

    _NAME = u'backupRuns'

    def __init__(self, client):
      super(SqladminV1beta4.BackupRunsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the backup taken by a backup run.

      Args:
        request: (SqlBackupRunsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'sql.backupRuns.delete',
        ordered_params=[u'project', u'instance', u'id'],
        path_params=[u'id', u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/backupRuns/{id}',
        request_field='',
        request_type_name=u'SqlBackupRunsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a resource containing information about a backup run.

      Args:
        request: (SqlBackupRunsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackupRun) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.backupRuns.get',
        ordered_params=[u'project', u'instance', u'id'],
        path_params=[u'id', u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/backupRuns/{id}',
        request_field='',
        request_type_name=u'SqlBackupRunsGetRequest',
        response_type_name=u'BackupRun',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new backup run on demand. This method is applicable only to Second Generation instances.

      Args:
        request: (SqlBackupRunsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.backupRuns.insert',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/backupRuns',
        request_field=u'backupRun',
        request_type_name=u'SqlBackupRunsInsertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all backup runs associated with a given instance and configuration in the reverse chronological order of the enqueued time.

      Args:
        request: (SqlBackupRunsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackupRunsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.backupRuns.list',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[u'maxResults', u'pageToken'],
        relative_path=u'projects/{project}/instances/{instance}/backupRuns',
        request_field='',
        request_type_name=u'SqlBackupRunsListRequest',
        response_type_name=u'BackupRunsListResponse',
        supports_download=False,
    )

  class DatabasesService(base_api.BaseApiService):
    """Service class for the databases resource."""

    _NAME = u'databases'

    def __init__(self, client):
      super(SqladminV1beta4.DatabasesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes a database from a Cloud SQL instance.

      Args:
        request: (SqlDatabasesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'sql.databases.delete',
        ordered_params=[u'project', u'instance', u'database'],
        path_params=[u'database', u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/databases/{database}',
        request_field='',
        request_type_name=u'SqlDatabasesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a resource containing information about a database inside a Cloud SQL instance.

      Args:
        request: (SqlDatabasesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Database) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.databases.get',
        ordered_params=[u'project', u'instance', u'database'],
        path_params=[u'database', u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/databases/{database}',
        request_field='',
        request_type_name=u'SqlDatabasesGetRequest',
        response_type_name=u'Database',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Inserts a resource containing information about a database inside a Cloud SQL instance.

      Args:
        request: (Database) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.databases.insert',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/databases',
        request_field='<request>',
        request_type_name=u'Database',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists databases in the specified Cloud SQL instance.

      Args:
        request: (SqlDatabasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DatabasesListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.databases.list',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/databases',
        request_field='',
        request_type_name=u'SqlDatabasesListRequest',
        response_type_name=u'DatabasesListResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a resource containing information about a database inside a Cloud SQL instance. This method supports patch semantics.

      Args:
        request: (SqlDatabasesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'sql.databases.patch',
        ordered_params=[u'project', u'instance', u'database'],
        path_params=[u'database', u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/databases/{database}',
        request_field=u'databaseResource',
        request_type_name=u'SqlDatabasesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a resource containing information about a database inside a Cloud SQL instance.

      Args:
        request: (SqlDatabasesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'sql.databases.update',
        ordered_params=[u'project', u'instance', u'database'],
        path_params=[u'database', u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/databases/{database}',
        request_field=u'databaseResource',
        request_type_name=u'SqlDatabasesUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class FlagsService(base_api.BaseApiService):
    """Service class for the flags resource."""

    _NAME = u'flags'

    def __init__(self, client):
      super(SqladminV1beta4.FlagsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List all available database flags for Google Cloud SQL instances.

      Args:
        request: (SqlFlagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FlagsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.flags.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'databaseVersion'],
        relative_path=u'flags',
        request_field='',
        request_type_name=u'SqlFlagsListRequest',
        response_type_name=u'FlagsListResponse',
        supports_download=False,
    )

  class InstancesService(base_api.BaseApiService):
    """Service class for the instances resource."""

    _NAME = u'instances'

    def __init__(self, client):
      super(SqladminV1beta4.InstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddServerCa(self, request, global_params=None):
      r"""Add a new trusted Certificate Authority (CA) version for the specified instance. Required to prepare for a certificate rotation. If a CA version was previously added but never used in a certificate rotation, this operation replaces that version. There can not be more than one CA version waiting to be rotated in.

      Args:
        request: (SqlInstancesAddServerCaRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddServerCa')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddServerCa.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.addServerCa',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/addServerCa',
        request_field='',
        request_type_name=u'SqlInstancesAddServerCaRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Clone(self, request, global_params=None):
      r"""Creates a Cloud SQL instance as a clone of the source instance. The API is not ready for Second Generation instances yet.

      Args:
        request: (SqlInstancesCloneRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Clone')
      return self._RunMethod(
          config, request, global_params=global_params)

    Clone.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.clone',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/clone',
        request_field=u'instancesCloneRequest',
        request_type_name=u'SqlInstancesCloneRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a Cloud SQL instance.

      Args:
        request: (SqlInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'sql.instances.delete',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}',
        request_field='',
        request_type_name=u'SqlInstancesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def DemoteMaster(self, request, global_params=None):
      r"""Reserved for future use.

      Args:
        request: (SqlInstancesDemoteMasterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DemoteMaster')
      return self._RunMethod(
          config, request, global_params=global_params)

    DemoteMaster.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.demoteMaster',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/demoteMaster',
        request_field=u'instancesDemoteMasterRequest',
        request_type_name=u'SqlInstancesDemoteMasterRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Exports data from a Cloud SQL instance to a Google Cloud Storage bucket as a MySQL dump file.

      Args:
        request: (SqlInstancesExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.export',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/export',
        request_field=u'instancesExportRequest',
        request_type_name=u'SqlInstancesExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Failover(self, request, global_params=None):
      r"""Failover the instance to its failover replica instance.

      Args:
        request: (SqlInstancesFailoverRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Failover')
      return self._RunMethod(
          config, request, global_params=global_params)

    Failover.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.failover',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/failover',
        request_field=u'instancesFailoverRequest',
        request_type_name=u'SqlInstancesFailoverRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a resource containing information about a Cloud SQL instance.

      Args:
        request: (SqlInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DatabaseInstance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.instances.get',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}',
        request_field='',
        request_type_name=u'SqlInstancesGetRequest',
        response_type_name=u'DatabaseInstance',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Imports data into a Cloud SQL instance from a MySQL dump file in Google Cloud Storage.

      Args:
        request: (SqlInstancesImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.import',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/import',
        request_field=u'instancesImportRequest',
        request_type_name=u'SqlInstancesImportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new Cloud SQL instance.

      Args:
        request: (DatabaseInstance) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.insert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances',
        request_field='<request>',
        request_type_name=u'DatabaseInstance',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists instances under a given project in the alphabetical order of the instance name.

      Args:
        request: (SqlInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstancesListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.instances.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[u'filter', u'maxResults', u'pageToken'],
        relative_path=u'projects/{project}/instances',
        request_field='',
        request_type_name=u'SqlInstancesListRequest',
        response_type_name=u'InstancesListResponse',
        supports_download=False,
    )

    def ListServerCas(self, request, global_params=None):
      r"""Lists all of the trusted Certificate Authorities (CAs) for the specified instance. There can be up to three CAs listed: the CA that was used to sign the certificate that is currently in use, a CA that has been added but not yet used to sign a certificate, and a CA used to sign a certificate that has previously rotated out.

      Args:
        request: (SqlInstancesListServerCasRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstancesListServerCasResponse) The response message.
      """
      config = self.GetMethodConfig('ListServerCas')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListServerCas.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.instances.listServerCas',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/listServerCas',
        request_field='',
        request_type_name=u'SqlInstancesListServerCasRequest',
        response_type_name=u'InstancesListServerCasResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates settings of a Cloud SQL instance. Caution: This is not a partial update, so you must include values for all the settings that you want to retain. For partial updates, use patch.. This method supports patch semantics.

      Args:
        request: (SqlInstancesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'sql.instances.patch',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}',
        request_field=u'databaseInstance',
        request_type_name=u'SqlInstancesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def PromoteReplica(self, request, global_params=None):
      r"""Promotes the read replica instance to be a stand-alone Cloud SQL instance.

      Args:
        request: (SqlInstancesPromoteReplicaRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PromoteReplica')
      return self._RunMethod(
          config, request, global_params=global_params)

    PromoteReplica.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.promoteReplica',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/promoteReplica',
        request_field='',
        request_type_name=u'SqlInstancesPromoteReplicaRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def ResetSslConfig(self, request, global_params=None):
      r"""Deletes all client certificates and generates a new server SSL certificate for the instance. The changes will not take effect until the instance is restarted. Existing instances without a server certificate will need to call this once to set a server certificate.

      Args:
        request: (SqlInstancesResetSslConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResetSslConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResetSslConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.resetSslConfig',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/resetSslConfig',
        request_field='',
        request_type_name=u'SqlInstancesResetSslConfigRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Restart(self, request, global_params=None):
      r"""Restarts a Cloud SQL instance.

      Args:
        request: (SqlInstancesRestartRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Restart')
      return self._RunMethod(
          config, request, global_params=global_params)

    Restart.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.restart',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/restart',
        request_field='',
        request_type_name=u'SqlInstancesRestartRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def RestoreBackup(self, request, global_params=None):
      r"""Restores a backup of a Cloud SQL instance.

      Args:
        request: (SqlInstancesRestoreBackupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RestoreBackup')
      return self._RunMethod(
          config, request, global_params=global_params)

    RestoreBackup.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.restoreBackup',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/restoreBackup',
        request_field=u'instancesRestoreBackupRequest',
        request_type_name=u'SqlInstancesRestoreBackupRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def RotateServerCa(self, request, global_params=None):
      r"""Rotates the server certificate to one signed by the Certificate Authority (CA) version previously added with the addServerCA method.

      Args:
        request: (SqlInstancesRotateServerCaRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RotateServerCa')
      return self._RunMethod(
          config, request, global_params=global_params)

    RotateServerCa.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.rotateServerCa',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/rotateServerCa',
        request_field=u'instancesRotateServerCaRequest',
        request_type_name=u'SqlInstancesRotateServerCaRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def StartReplica(self, request, global_params=None):
      r"""Starts the replication in the read replica instance.

      Args:
        request: (SqlInstancesStartReplicaRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartReplica')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartReplica.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.startReplica',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/startReplica',
        request_field='',
        request_type_name=u'SqlInstancesStartReplicaRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def StopReplica(self, request, global_params=None):
      r"""Stops the replication in the read replica instance.

      Args:
        request: (SqlInstancesStopReplicaRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StopReplica')
      return self._RunMethod(
          config, request, global_params=global_params)

    StopReplica.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.stopReplica',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/stopReplica',
        request_field='',
        request_type_name=u'SqlInstancesStopReplicaRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TruncateLog(self, request, global_params=None):
      r"""Truncate MySQL general and slow query log tables.

      Args:
        request: (SqlInstancesTruncateLogRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('TruncateLog')
      return self._RunMethod(
          config, request, global_params=global_params)

    TruncateLog.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.instances.truncateLog',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/truncateLog',
        request_field=u'instancesTruncateLogRequest',
        request_type_name=u'SqlInstancesTruncateLogRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates settings of a Cloud SQL instance. Caution: This is not a partial update, so you must include values for all the settings that you want to retain. For partial updates, use patch.

      Args:
        request: (SqlInstancesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'sql.instances.update',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}',
        request_field=u'databaseInstance',
        request_type_name=u'SqlInstancesUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(SqladminV1beta4.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Retrieves an instance operation that has been performed on an instance.

      Args:
        request: (SqlOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.operations.get',
        ordered_params=[u'project', u'operation'],
        path_params=[u'operation', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/operations/{operation}',
        request_field='',
        request_type_name=u'SqlOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all instance operations that have been performed on the given Cloud SQL instance in the reverse chronological order of the start time.

      Args:
        request: (SqlOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.operations.list',
        ordered_params=[u'project', u'instance'],
        path_params=[u'project'],
        query_params=[u'instance', u'maxResults', u'pageToken'],
        relative_path=u'projects/{project}/operations',
        request_field='',
        request_type_name=u'SqlOperationsListRequest',
        response_type_name=u'OperationsListResponse',
        supports_download=False,
    )

  class SslCertsService(base_api.BaseApiService):
    """Service class for the sslCerts resource."""

    _NAME = u'sslCerts'

    def __init__(self, client):
      super(SqladminV1beta4.SslCertsService, self).__init__(client)
      self._upload_configs = {
          }

    def CreateEphemeral(self, request, global_params=None):
      r"""Generates a short-lived X509 certificate containing the provided public key and signed by a private key specific to the target instance. Users may use the certificate to authenticate as themselves when connecting to the database.

      Args:
        request: (SqlSslCertsCreateEphemeralRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCert) The response message.
      """
      config = self.GetMethodConfig('CreateEphemeral')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateEphemeral.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.sslCerts.createEphemeral',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/createEphemeral',
        request_field=u'sslCertsCreateEphemeralRequest',
        request_type_name=u'SqlSslCertsCreateEphemeralRequest',
        response_type_name=u'SslCert',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the SSL certificate. The change will not take effect until the instance is restarted.

      Args:
        request: (SqlSslCertsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'sql.sslCerts.delete',
        ordered_params=[u'project', u'instance', u'sha1Fingerprint'],
        path_params=[u'instance', u'project', u'sha1Fingerprint'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}',
        request_field='',
        request_type_name=u'SqlSslCertsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a particular SSL certificate. Does not include the private key (required for usage). The private key must be saved from the response to initial creation.

      Args:
        request: (SqlSslCertsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCert) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.sslCerts.get',
        ordered_params=[u'project', u'instance', u'sha1Fingerprint'],
        path_params=[u'instance', u'project', u'sha1Fingerprint'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}',
        request_field='',
        request_type_name=u'SqlSslCertsGetRequest',
        response_type_name=u'SslCert',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an SSL certificate and returns it along with the private key and server certificate authority. The new certificate will not be usable until the instance is restarted.

      Args:
        request: (SqlSslCertsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertsInsertResponse) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.sslCerts.insert',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/sslCerts',
        request_field=u'sslCertsInsertRequest',
        request_type_name=u'SqlSslCertsInsertRequest',
        response_type_name=u'SslCertsInsertResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all of the current SSL certificates for the instance.

      Args:
        request: (SqlSslCertsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.sslCerts.list',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/sslCerts',
        request_field='',
        request_type_name=u'SqlSslCertsListRequest',
        response_type_name=u'SslCertsListResponse',
        supports_download=False,
    )

  class TiersService(base_api.BaseApiService):
    """Service class for the tiers resource."""

    _NAME = u'tiers'

    def __init__(self, client):
      super(SqladminV1beta4.TiersService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all available service tiers for Google Cloud SQL, for example D1, D2. For related information, see Pricing.

      Args:
        request: (SqlTiersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TiersListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.tiers.list',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[],
        relative_path=u'projects/{project}/tiers',
        request_field='',
        request_type_name=u'SqlTiersListRequest',
        response_type_name=u'TiersListResponse',
        supports_download=False,
    )

  class UsersService(base_api.BaseApiService):
    """Service class for the users resource."""

    _NAME = u'users'

    def __init__(self, client):
      super(SqladminV1beta4.UsersService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes a user from a Cloud SQL instance.

      Args:
        request: (SqlUsersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'sql.users.delete',
        ordered_params=[u'project', u'instance', u'host', u'name'],
        path_params=[u'instance', u'project'],
        query_params=[u'host', u'name'],
        relative_path=u'projects/{project}/instances/{instance}/users',
        request_field='',
        request_type_name=u'SqlUsersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new user in a Cloud SQL instance.

      Args:
        request: (User) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'sql.users.insert',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/users',
        request_field='<request>',
        request_type_name=u'User',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists users in the specified Cloud SQL instance.

      Args:
        request: (SqlUsersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UsersListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'sql.users.list',
        ordered_params=[u'project', u'instance'],
        path_params=[u'instance', u'project'],
        query_params=[],
        relative_path=u'projects/{project}/instances/{instance}/users',
        request_field='',
        request_type_name=u'SqlUsersListRequest',
        response_type_name=u'UsersListResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an existing user in a Cloud SQL instance.

      Args:
        request: (SqlUsersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'sql.users.update',
        ordered_params=[u'project', u'instance', u'host', u'name'],
        path_params=[u'instance', u'project'],
        query_params=[u'host', u'name'],
        relative_path=u'projects/{project}/instances/{instance}/users',
        request_field=u'user',
        request_type_name=u'SqlUsersUpdateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )
