"""Generated client library for containeranalysis version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.containeranalysis.v1alpha1 import containeranalysis_v1alpha1_messages as messages


class ContaineranalysisV1alpha1(base_api.BaseApiClient):
  """Generated client library for service containeranalysis version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://containeranalysis.googleapis.com/'

  _PACKAGE = u'containeranalysis'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ContaineranalysisV1alpha1'
  _URL_VERSION = u'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new containeranalysis handle."""
    url = url or self.BASE_URL
    super(ContaineranalysisV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_notes_occurrences = self.ProjectsNotesOccurrencesService(self)
    self.projects_notes = self.ProjectsNotesService(self)
    self.projects_occurrences = self.ProjectsOccurrencesService(self)
    self.projects_operations = self.ProjectsOperationsService(self)
    self.projects_scan_configs = self.ProjectsScanConfigsService(self)
    self.projects = self.ProjectsService(self)
    self.providers_notes_occurrences = self.ProvidersNotesOccurrencesService(self)
    self.providers_notes = self.ProvidersNotesService(self)
    self.providers = self.ProvidersService(self)

  class ProjectsNotesOccurrencesService(base_api.BaseApiService):
    """Service class for the projects_notes_occurrences resource."""

    _NAME = u'projects_notes_occurrences'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsNotesOccurrencesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists `Occurrences` referencing the specified `Note`. Use this method to.
get all occurrences referencing your `Note` across all your customer
projects.

      Args:
        request: (ContaineranalysisProjectsNotesOccurrencesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNoteOccurrencesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}/occurrences',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.notes.occurrences.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+name}/occurrences',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsNotesOccurrencesListRequest',
        response_type_name=u'ListNoteOccurrencesResponse',
        supports_download=False,
    )

  class ProjectsNotesService(base_api.BaseApiService):
    """Service class for the projects_notes resource."""

    _NAME = u'projects_notes'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsNotesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new `Note`.

      Args:
        request: (ContaineranalysisProjectsNotesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.notes.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'name', u'noteId'],
        relative_path=u'v1alpha1/{+parent}/notes',
        request_field=u'note',
        request_type_name=u'ContaineranalysisProjectsNotesCreateRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the given `Note` from the system.

      Args:
        request: (ContaineranalysisProjectsNotesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}',
        http_method=u'DELETE',
        method_id=u'containeranalysis.projects.notes.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsNotesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the requested `Note`.

      Args:
        request: (ContaineranalysisProjectsNotesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.notes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsNotesGetRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a note or an `Occurrence` resource.
Requires `containeranalysis.notes.setIamPolicy` or
`containeranalysis.occurrences.setIamPolicy` permission if the resource is
a note or occurrence, respectively.
Attempting to call this method on a resource without the required
permission will result in a `PERMISSION_DENIED` error. Attempting to call
this method on a non-existent resource will result in a `NOT_FOUND` error
if the user has list permission on the project, or a `PERMISSION_DENIED`
error otherwise. The resource takes the following formats:
`projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for occurrences and
projects/{PROJECT_ID}/notes/{NOTE_ID} for notes

      Args:
        request: (ContaineranalysisProjectsNotesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.notes.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'ContaineranalysisProjectsNotesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all `Notes` for a given project.

      Args:
        request: (ContaineranalysisProjectsNotesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNotesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.notes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'name', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/notes',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsNotesListRequest',
        response_type_name=u'ListNotesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing `Note`.

      Args:
        request: (ContaineranalysisProjectsNotesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}',
        http_method=u'PATCH',
        method_id=u'containeranalysis.projects.notes.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'note',
        request_type_name=u'ContaineranalysisProjectsNotesPatchRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified `Note` or `Occurrence`.
Requires `containeranalysis.notes.setIamPolicy` or
`containeranalysis.occurrences.setIamPolicy` permission if the resource is
a `Note` or an `Occurrence`, respectively.
Attempting to call this method without these permissions will result in a `
`PERMISSION_DENIED` error.
Attempting to call this method on a non-existent resource will result in a
`NOT_FOUND` error if the user has `containeranalysis.notes.list` permission
on a `Note` or `containeranalysis.occurrences.list` on an `Occurrence`, or
a `PERMISSION_DENIED` error otherwise. The resource takes the following
formats: `projects/{projectid}/occurrences/{occurrenceid}` for occurrences
and projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProjectsNotesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.notes.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'ContaineranalysisProjectsNotesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the permissions that a caller has on the specified note or.
occurrence resource. Requires list permission on the project (for example,
"storage.objects.list" on the containing bucket for testing permission of
an object). Attempting to call this method on a non-existent resource will
result in a `NOT_FOUND` error if the user has list permission on the
project, or a `PERMISSION_DENIED` error otherwise. The resource takes the
following formats: `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for
`Occurrences` and `projects/{PROJECT_ID}/notes/{NOTE_ID}` for `Notes`

      Args:
        request: (ContaineranalysisProjectsNotesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/notes/{notesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.notes.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'ContaineranalysisProjectsNotesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsOccurrencesService(base_api.BaseApiService):
    """Service class for the projects_occurrences resource."""

    _NAME = u'projects_occurrences'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsOccurrencesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new `Occurrence`. Use this method to create `Occurrences`.
for a resource.

      Args:
        request: (ContaineranalysisProjectsOccurrencesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Occurrence) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.occurrences.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'name'],
        relative_path=u'v1alpha1/{+parent}/occurrences',
        request_field=u'occurrence',
        request_type_name=u'ContaineranalysisProjectsOccurrencesCreateRequest',
        response_type_name=u'Occurrence',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the given `Occurrence` from the system. Use this when.
an `Occurrence` is no longer applicable for the given resource.

      Args:
        request: (ContaineranalysisProjectsOccurrencesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}',
        http_method=u'DELETE',
        method_id=u'containeranalysis.projects.occurrences.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsOccurrencesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the requested `Occurrence`.

      Args:
        request: (ContaineranalysisProjectsOccurrencesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Occurrence) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.occurrences.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsOccurrencesGetRequest',
        response_type_name=u'Occurrence',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a note or an `Occurrence` resource.
Requires `containeranalysis.notes.setIamPolicy` or
`containeranalysis.occurrences.setIamPolicy` permission if the resource is
a note or occurrence, respectively.
Attempting to call this method on a resource without the required
permission will result in a `PERMISSION_DENIED` error. Attempting to call
this method on a non-existent resource will result in a `NOT_FOUND` error
if the user has list permission on the project, or a `PERMISSION_DENIED`
error otherwise. The resource takes the following formats:
`projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for occurrences and
projects/{PROJECT_ID}/notes/{NOTE_ID} for notes

      Args:
        request: (ContaineranalysisProjectsOccurrencesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.occurrences.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'ContaineranalysisProjectsOccurrencesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def GetNotes(self, request, global_params=None):
      r"""Gets the `Note` attached to the given `Occurrence`.

      Args:
        request: (ContaineranalysisProjectsOccurrencesGetNotesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('GetNotes')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetNotes.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}/notes',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.occurrences.getNotes',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}/notes',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsOccurrencesGetNotesRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def GetVulnerabilitySummary(self, request, global_params=None):
      r"""Gets a summary of the number and severity of occurrences.

      Args:
        request: (ContaineranalysisProjectsOccurrencesGetVulnerabilitySummaryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetVulnzOccurrencesSummaryResponse) The response message.
      """
      config = self.GetMethodConfig('GetVulnerabilitySummary')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetVulnerabilitySummary.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences:vulnerabilitySummary',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.occurrences.getVulnerabilitySummary',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter'],
        relative_path=u'v1alpha1/{+parent}/occurrences:vulnerabilitySummary',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsOccurrencesGetVulnerabilitySummaryRequest',
        response_type_name=u'GetVulnzOccurrencesSummaryResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists active `Occurrences` for a given project matching the filters.

      Args:
        request: (ContaineranalysisProjectsOccurrencesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOccurrencesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.occurrences.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'kind', u'name', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/occurrences',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsOccurrencesListRequest',
        response_type_name=u'ListOccurrencesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing occurrence.

      Args:
        request: (ContaineranalysisProjectsOccurrencesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Occurrence) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}',
        http_method=u'PATCH',
        method_id=u'containeranalysis.projects.occurrences.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'occurrence',
        request_type_name=u'ContaineranalysisProjectsOccurrencesPatchRequest',
        response_type_name=u'Occurrence',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified `Note` or `Occurrence`.
Requires `containeranalysis.notes.setIamPolicy` or
`containeranalysis.occurrences.setIamPolicy` permission if the resource is
a `Note` or an `Occurrence`, respectively.
Attempting to call this method without these permissions will result in a `
`PERMISSION_DENIED` error.
Attempting to call this method on a non-existent resource will result in a
`NOT_FOUND` error if the user has `containeranalysis.notes.list` permission
on a `Note` or `containeranalysis.occurrences.list` on an `Occurrence`, or
a `PERMISSION_DENIED` error otherwise. The resource takes the following
formats: `projects/{projectid}/occurrences/{occurrenceid}` for occurrences
and projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProjectsOccurrencesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.occurrences.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'ContaineranalysisProjectsOccurrencesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the permissions that a caller has on the specified note or.
occurrence resource. Requires list permission on the project (for example,
"storage.objects.list" on the containing bucket for testing permission of
an object). Attempting to call this method on a non-existent resource will
result in a `NOT_FOUND` error if the user has list permission on the
project, or a `PERMISSION_DENIED` error otherwise. The resource takes the
following formats: `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for
`Occurrences` and `projects/{PROJECT_ID}/notes/{NOTE_ID}` for `Notes`

      Args:
        request: (ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/occurrences/{occurrencesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.occurrences.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsOperationsService(base_api.BaseApiService):
    """Service class for the projects_operations resource."""

    _NAME = u'projects_operations'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new `Operation`.

      Args:
        request: (ContaineranalysisProjectsOperationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/operations',
        http_method=u'POST',
        method_id=u'containeranalysis.projects.operations.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/operations',
        request_field=u'createOperationRequest',
        request_type_name=u'ContaineranalysisProjectsOperationsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing operation returns an error if operation.
 does not exist. The only valid operations are to update mark the done bit
change the result.

      Args:
        request: (ContaineranalysisProjectsOperationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/operations/{operationsId}',
        http_method=u'PATCH',
        method_id=u'containeranalysis.projects.operations.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'updateOperationRequest',
        request_type_name=u'ContaineranalysisProjectsOperationsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsScanConfigsService(base_api.BaseApiService):
    """Service class for the projects_scan_configs resource."""

    _NAME = u'projects_scan_configs'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsScanConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a specific scan configuration for a project.

      Args:
        request: (ContaineranalysisProjectsScanConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScanConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/scan_configs/{scan_configsId}',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.scan_configs.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsScanConfigsGetRequest',
        response_type_name=u'ScanConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists scan configurations for a project.

      Args:
        request: (ContaineranalysisProjectsScanConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListScanConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/scan_configs',
        http_method=u'GET',
        method_id=u'containeranalysis.projects.scan_configs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/scan_configs',
        request_field='',
        request_type_name=u'ContaineranalysisProjectsScanConfigsListRequest',
        response_type_name=u'ListScanConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the scan configuration to a new value.

      Args:
        request: (ContaineranalysisProjectsScanConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScanConfig) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/scan_configs/{scan_configsId}',
        http_method=u'PATCH',
        method_id=u'containeranalysis.projects.scan_configs.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'scanConfig',
        request_type_name=u'ContaineranalysisProjectsScanConfigsPatchRequest',
        response_type_name=u'ScanConfig',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProvidersNotesOccurrencesService(base_api.BaseApiService):
    """Service class for the providers_notes_occurrences resource."""

    _NAME = u'providers_notes_occurrences'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProvidersNotesOccurrencesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists `Occurrences` referencing the specified `Note`. Use this method to.
get all occurrences referencing your `Note` across all your customer
projects.

      Args:
        request: (ContaineranalysisProvidersNotesOccurrencesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNoteOccurrencesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}/occurrences',
        http_method=u'GET',
        method_id=u'containeranalysis.providers.notes.occurrences.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+name}/occurrences',
        request_field='',
        request_type_name=u'ContaineranalysisProvidersNotesOccurrencesListRequest',
        response_type_name=u'ListNoteOccurrencesResponse',
        supports_download=False,
    )

  class ProvidersNotesService(base_api.BaseApiService):
    """Service class for the providers_notes resource."""

    _NAME = u'providers_notes'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProvidersNotesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new `Note`.

      Args:
        request: (ContaineranalysisProvidersNotesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes',
        http_method=u'POST',
        method_id=u'containeranalysis.providers.notes.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'noteId', u'parent'],
        relative_path=u'v1alpha1/{+name}/notes',
        request_field=u'note',
        request_type_name=u'ContaineranalysisProvidersNotesCreateRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the given `Note` from the system.

      Args:
        request: (ContaineranalysisProvidersNotesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}',
        http_method=u'DELETE',
        method_id=u'containeranalysis.providers.notes.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProvidersNotesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the requested `Note`.

      Args:
        request: (ContaineranalysisProvidersNotesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}',
        http_method=u'GET',
        method_id=u'containeranalysis.providers.notes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ContaineranalysisProvidersNotesGetRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a note or an `Occurrence` resource.
Requires `containeranalysis.notes.setIamPolicy` or
`containeranalysis.occurrences.setIamPolicy` permission if the resource is
a note or occurrence, respectively.
Attempting to call this method on a resource without the required
permission will result in a `PERMISSION_DENIED` error. Attempting to call
this method on a non-existent resource will result in a `NOT_FOUND` error
if the user has list permission on the project, or a `PERMISSION_DENIED`
error otherwise. The resource takes the following formats:
`projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for occurrences and
projects/{PROJECT_ID}/notes/{NOTE_ID} for notes

      Args:
        request: (ContaineranalysisProvidersNotesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.providers.notes.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'ContaineranalysisProvidersNotesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all `Notes` for a given project.

      Args:
        request: (ContaineranalysisProvidersNotesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNotesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes',
        http_method=u'GET',
        method_id=u'containeranalysis.providers.notes.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken', u'parent'],
        relative_path=u'v1alpha1/{+name}/notes',
        request_field='',
        request_type_name=u'ContaineranalysisProvidersNotesListRequest',
        response_type_name=u'ListNotesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing `Note`.

      Args:
        request: (ContaineranalysisProvidersNotesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Note) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}',
        http_method=u'PATCH',
        method_id=u'containeranalysis.providers.notes.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'note',
        request_type_name=u'ContaineranalysisProvidersNotesPatchRequest',
        response_type_name=u'Note',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified `Note` or `Occurrence`.
Requires `containeranalysis.notes.setIamPolicy` or
`containeranalysis.occurrences.setIamPolicy` permission if the resource is
a `Note` or an `Occurrence`, respectively.
Attempting to call this method without these permissions will result in a `
`PERMISSION_DENIED` error.
Attempting to call this method on a non-existent resource will result in a
`NOT_FOUND` error if the user has `containeranalysis.notes.list` permission
on a `Note` or `containeranalysis.occurrences.list` on an `Occurrence`, or
a `PERMISSION_DENIED` error otherwise. The resource takes the following
formats: `projects/{projectid}/occurrences/{occurrenceid}` for occurrences
and projects/{projectid}/notes/{noteid} for notes

      Args:
        request: (ContaineranalysisProvidersNotesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'containeranalysis.providers.notes.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'ContaineranalysisProvidersNotesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the permissions that a caller has on the specified note or.
occurrence resource. Requires list permission on the project (for example,
"storage.objects.list" on the containing bucket for testing permission of
an object). Attempting to call this method on a non-existent resource will
result in a `NOT_FOUND` error if the user has list permission on the
project, or a `PERMISSION_DENIED` error otherwise. The resource takes the
following formats: `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for
`Occurrences` and `projects/{PROJECT_ID}/notes/{NOTE_ID}` for `Notes`

      Args:
        request: (ContaineranalysisProvidersNotesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/providers/{providersId}/notes/{notesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'containeranalysis.providers.notes.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'ContaineranalysisProvidersNotesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProvidersService(base_api.BaseApiService):
    """Service class for the providers resource."""

    _NAME = u'providers'

    def __init__(self, client):
      super(ContaineranalysisV1alpha1.ProvidersService, self).__init__(client)
      self._upload_configs = {
          }
