import LongformPage from 'components/longform-page'

export default function TermsOfUsePage() {
  return (
    <LongformPage
      alert={
        <p>
          These Terms of Use apply to the Waypoint Url Service as hosted by
          HashiCorp. If you do not feel comfortable accepting the terms, you may
          disable the URL service or self-host the URL service.{' '}
          <a href="/docs/url">Learn more here</a>.
        </p>
      }
      title="Terms of Use"
    >
      <p>
        Please read these Terms of Use (“Agreement”) carefully before using the
        Services offered by HashiCorp, Inc. (“Company”). You may not use the
        Website or Services if you do not unconditionally agree to this
        Agreement. You represent that: (i) if you are an individual, you are of
        legal age to form a binding contract (and at least 13 years of age or
        older) or have a parent’s permission to do so; (ii) if you are entering
        into this Agreement on behalf of an entity (e.g., a corporation), you
        are an authorized to bind the entity to this Agreement and agree to this
        Agreement on the entity’s behalf; (iii) all registration information you
        submit is accurate and truthful and you will maintain its accuracy; and
        (iv) you are legally permitted to use and access the Services and take
        full responsibility for the selection and use of and access to the
        Services. This Agreement is void where prohibited by law, and the right
        to access the Services is revoked in such jurisdictions.
      </p>
      <p>
        <strong>1. ACCESS TO THE SERVICES.</strong>
        The <a href="https://waypointproject.io">waypointproject.io</a> website
        and domain name and any other linked pages, features, content, or
        application services (the “Website”) and any related services (such as
        the Waypoint URL Service, as described more fully on the Website)
        offered by HashiCorp (the “Services”) are owned and operated by Company.
        Company may change, suspend or discontinue the Website or Services at
        any time, including the availability of any feature, database, or
        Content. Company may, in its sole discretion, modify this Agreement at
        any time by posting a notice on the Website, or by sending you a notice.
        Your use of the Services following such notification constitutes your
        acceptance of the terms and conditions of this Agreement as modified.
      </p>
      <p>
        <strong>2. SERVICES CONTENT.</strong> The Services and the “Content”
        (which includes, without limitation website URLs, applications or other
        information linked to by the website URLs, text, graphics, articles,
        photographs, images, and/or illustrations) may only be used in
        accordance with the terms of this Agreement. You warrant that you
        possess all rights necessary to provide such Content to Company and to
        grant Company the rights to use such information in connection with the
        Services.
      </p>
      <p>
        <strong>3. RESTRICTIONS.</strong> You warrant and agree that you will
        not contribute any Content or otherwise use the Services in a manner
        that (i) violates the intellectual property rights or proprietary
        rights, rights of publicity or privacy, or other rights of any third
        party; (ii) violates any law or regulation; (iii) is harmful,
        fraudulent, deceptive, threatening, abusive, harassing, defamatory,
        vulgar, obscene, libelous, or otherwise objectionable; (iv) involves
        commercial activities and/or sales without Company’s prior written
        consent such as contests, barter, advertising, or pyramid schemes; (v)
        impersonates any person or entity, including without limitation any
        employee or representative of Company; or (vi) contains a virus, trojan
        horse, worm, time bomb, or other harmful computer code, file, program,
        or automated software, devices, or other processes to “crawl,” “scrape,”
        or “spider” any portion of the Services or is intended to violate the
        security of any computer network, crack passwords or security encryption
        codes. Company reserves the right in its sole discretion to remove any
        Content from the Services at any time, for any reason. You remain solely
        responsible for all Content that you upload, post, email, transmit, or
        otherwise disseminate using the Services.
      </p>
      <p>
        <strong>4. WARRANTY DISCLAIMER.</strong>  THE SERVICES, CONTENT, WEBSITE
        AND ANY SOFTWARE ARE PROVIDED ON AN “AS IS” BASIS, WITHOUT WARRANTIES OF
        ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION,
        IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
        NON-INFRINGEMENT, OR THAT USE OF THE SERVICES WILL BE UNINTERRUPTED OR
        ERROR-FREE. SOME STATES DO NOT ALLOW LIMITATIONS ON HOW LONG AN IMPLIED
        WARRANTY LASTS, SO THE ABOVE LIMITATIONS MAY NOT APPLY TO YOU.
      </p>
      <p>
        <strong>5. PRIVACY POLICY.</strong> For information regarding Company’s
        treatment of personally identifiable information, please review
        Company’s current Privacy Policy at 
        <a href="https://www.hashicorp.com/privacy">
          hashicorp.com/privacy
        </a>{' '}
        which is hereby incorporated by reference; your acceptance of this
        Agreement constitutes your agreement to be bound by Company’s Privacy
        Policy. If you believe that we might have any information from or about
        a child under 13, please contact us at privacy@hashicorp.com
      </p>
      <p>
        <strong>6. INDEMNITY.</strong> You will indemnify and hold Company, its
        parents, subsidiaries, affiliates, officers, and employees harmless
        (including, without limitation, from all damages, liabilities,
        settlements, costs and attorneys’ fees) from any claim or demand made by
        any third party arising from your access or use of the Services, your
        violation of this Agreement, or any infringement by you or other party
        using your account of any intellectual property or other right of any
        person or entity.
      </p>
      <p>
        <strong>7. LIMITATION OF LIABILITY.</strong> TO THE FULLEST EXTENT
        ALLOWED BY APPLICABLE LAW, IN NO EVENT SHALL COMPANY OR ITS SUPPLIERS,
        OR THEIR RESPECTIVE OFFICERS, DIRECTORS, EMPLOYEES, OR AGENTS BE LIABLE
        WITH RESPECT TO THE WEBSITE OR THE SERVICES UNDER ANY CONTRACT,
        NEGLIGENCE, TORT, STRICT LIABILITY OR OTHER LEGAL OR EQUITABLE THEORY
        (I) FOR ANY AMOUNT IN THE AGGREGATE IN EXCESS OF $1000; (II) FOR ANY
        INDIRECT, INCIDENTAL, PUNITIVE, OR CONSEQUENTIAL DAMAGES OF ANY KIND
        WHATSOEVER; (III) FOR DATA LOSS OR COST OF PROCUREMENT OF SUBSTITUTE
        GOODS OR SERVICES; OR (IV) FOR ANY MATTER BEYOND COMPANY’S REASONABLE
        CONTROL. SOME STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF
        INCIDENTAL OR CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS AND
        EXCLUSIONS MAY NOT APPLY TO YOU.
      </p>
      <p>
        <strong>8. TERMINATION.</strong> This Agreement shall remain in full
        force and effect while you use the Services. You may terminate your use
        of the Services at any time. Company may terminate or suspend your
        access to the Services or your membership at any time, for any reason,
        and without warning, which may result in the forfeiture and destruction
        of all information associated with your membership. All provisions of
        this Agreement which, by their nature, should survive termination, shall
        survive termination, including, without limitation, ownership
        provisions, warranty disclaimers, and limitations of liability.
      </p>
      <p>
        <strong>9. MISCELLANEOUS.</strong> The failure of either party to
        exercise any right provided for herein shall not be deemed a waiver of
        any further rights hereunder. Company shall not be liable for any
        failure to perform its obligations hereunder where such failure results
        from any cause beyond Company’s reasonable control, including, without
        limitation, mechanical, electronic or communications failure or
        degradation (including “line-noise” interference). If any provision of
        this Agreement is found unenforceable or invalid, that provision shall
        be limited or eliminated to the minimum extent necessary so that this
        Agreement shall otherwise remain in full force and effect and
        enforceable. This Agreement is not assignable, transferable or
        sublicensable by you except with Company’s prior written consent.
        Company may transfer, assign or delegate this Agreement and its rights
        and obligations without consent. Both parties agree that this Agreement
        is the complete and exclusive statement of the mutual understanding of
        the parties and supersedes and cancels all previous written and oral
        agreements, communications and other understandings relating to the
        subject matter of this Agreement. No agency, partnership, joint venture,
        or employment is created as a result of this Agreement and you have no
        authority to bind Company in any respect. You and Company agree there
        are no third-party beneficiaries intended under this Agreement.
      </p>
      <p>
        <strong>10. GOVERNING LAW.</strong> This Agreement shall be governed by
        and construed in accordance with the laws of the State of California
        without regard to the conflict of laws provisions thereof. For all
        purposes of this Agreement, the parties consent to exclusive
        jurisdiction and venue in the United States Federal Courts located in
        the Northern District of California.
      </p>
      <p>
        <strong>11. COPYRIGHT DISPUTE POLICY.</strong> Please refer to the 
        <a href="/copyright-policy">Copyright Policy.</a>
      </p>
    </LongformPage>
  )
}
