// Code generated by gen.zsh; DO NOT EDIT

package unidata

// Emoji groups.
const (
	EmojiSmileysAndEmotion = EmojiGroup(iota)
	EmojiPeopleAndBody
	EmojiComponent
	EmojiAnimalsAndNature
	EmojiFoodAndDrink
	EmojiTravelAndPlaces
	EmojiActivities
	EmojiObjects
	EmojiSymbols
	EmojiFlags
)

// EmojiGroups is a list of all emoji groups.
var EmojiGroups = map[EmojiGroup]struct {
	Name      string
	Subgroups []EmojiSubgroup
}{
	EmojiSmileysAndEmotion: {"Smileys & Emotion", []EmojiSubgroup{
		EmojiFaceSmiling, EmojiFaceAffection, EmojiFaceTongue, EmojiFaceHand, EmojiFaceNeutralSkeptical,
		EmojiFaceSleepy, EmojiFaceUnwell, EmojiFaceHat, EmojiFaceGlasses, EmojiFaceConcerned,
		EmojiFaceNegative, EmojiFaceCostume, EmojiCatFace, EmojiMonkeyFace, EmojiHeart, EmojiEmotion}},
	EmojiPeopleAndBody: {"People & Body", []EmojiSubgroup{
		EmojiHandFingersOpen, EmojiHandFingersPartial, EmojiHandSingleFinger, EmojiHandFingersClosed,
		EmojiHands, EmojiHandProp, EmojiBodyParts, EmojiPerson, EmojiPersonGesture, EmojiPersonRole,
		EmojiPersonFantasy, EmojiPersonActivity, EmojiPersonSport, EmojiPersonResting, EmojiFamily,
		EmojiPersonSymbol}},
	EmojiComponent: {"Component", []EmojiSubgroup{
		EmojiSkinTone, EmojiHairStyle}},
	EmojiAnimalsAndNature: {"Animals & Nature", []EmojiSubgroup{
		EmojiAnimalMammal, EmojiAnimalBird, EmojiAnimalAmphibian, EmojiAnimalReptile, EmojiAnimalMarine,
		EmojiAnimalBug, EmojiPlantFlower, EmojiPlantOther}},
	EmojiFoodAndDrink: {"Food & Drink", []EmojiSubgroup{
		EmojiFoodFruit, EmojiFoodVegetable, EmojiFoodPrepared, EmojiFoodAsian, EmojiFoodSweet, EmojiDrink,
		EmojiDishware}},
	EmojiTravelAndPlaces: {"Travel & Places", []EmojiSubgroup{
		EmojiPlaceMap, EmojiPlaceGeographic, EmojiPlaceBuilding, EmojiPlaceReligious, EmojiPlaceOther,
		EmojiTransportGround, EmojiTransportWater, EmojiTransportAir, EmojiHotel, EmojiTime,
		EmojiSkyAndweather}},
	EmojiActivities: {"Activities", []EmojiSubgroup{
		EmojiEvent, EmojiAwardMedal, EmojiSport, EmojiGame, EmojiArtsAndcrafts}},
	EmojiObjects: {"Objects", []EmojiSubgroup{
		EmojiClothing, EmojiSound, EmojiMusic, EmojiMusicalInstrument, EmojiPhone, EmojiComputer,
		EmojiLightAndvideo, EmojiBookPaper, EmojiMoney, EmojiMail, EmojiWriting, EmojiOffice, EmojiLock,
		EmojiTool, EmojiScience, EmojiMedical, EmojiHousehold, EmojiOtherObject}},
	EmojiSymbols: {"Symbols", []EmojiSubgroup{
		EmojiTransportSign, EmojiWarning, EmojiArrow, EmojiReligion, EmojiZodiac, EmojiAvSymbol,
		EmojiGender, EmojiMath, EmojiPunctuation, EmojiCurrency, EmojiOtherSymbol, EmojiKeycap,
		EmojiAlphanum, EmojiGeometric}},
	EmojiFlags: {"Flags", []EmojiSubgroup{
		EmojiFlag, EmojiCountryFlag, EmojiSubdivisionFlag}},
}

// Emoji subgroups.
const (
	EmojiFaceSmiling = EmojiSubgroup(iota)
	EmojiFaceAffection
	EmojiFaceTongue
	EmojiFaceHand
	EmojiFaceNeutralSkeptical
	EmojiFaceSleepy
	EmojiFaceUnwell
	EmojiFaceHat
	EmojiFaceGlasses
	EmojiFaceConcerned
	EmojiFaceNegative
	EmojiFaceCostume
	EmojiCatFace
	EmojiMonkeyFace
	EmojiHeart
	EmojiEmotion
	EmojiHandFingersOpen
	EmojiHandFingersPartial
	EmojiHandSingleFinger
	EmojiHandFingersClosed
	EmojiHands
	EmojiHandProp
	EmojiBodyParts
	EmojiPerson
	EmojiPersonGesture
	EmojiPersonRole
	EmojiPersonFantasy
	EmojiPersonActivity
	EmojiPersonSport
	EmojiPersonResting
	EmojiFamily
	EmojiPersonSymbol
	EmojiSkinTone
	EmojiHairStyle
	EmojiAnimalMammal
	EmojiAnimalBird
	EmojiAnimalAmphibian
	EmojiAnimalReptile
	EmojiAnimalMarine
	EmojiAnimalBug
	EmojiPlantFlower
	EmojiPlantOther
	EmojiFoodFruit
	EmojiFoodVegetable
	EmojiFoodPrepared
	EmojiFoodAsian
	EmojiFoodSweet
	EmojiDrink
	EmojiDishware
	EmojiPlaceMap
	EmojiPlaceGeographic
	EmojiPlaceBuilding
	EmojiPlaceReligious
	EmojiPlaceOther
	EmojiTransportGround
	EmojiTransportWater
	EmojiTransportAir
	EmojiHotel
	EmojiTime
	EmojiSkyAndweather
	EmojiEvent
	EmojiAwardMedal
	EmojiSport
	EmojiGame
	EmojiArtsAndcrafts
	EmojiClothing
	EmojiSound
	EmojiMusic
	EmojiMusicalInstrument
	EmojiPhone
	EmojiComputer
	EmojiLightAndvideo
	EmojiBookPaper
	EmojiMoney
	EmojiMail
	EmojiWriting
	EmojiOffice
	EmojiLock
	EmojiTool
	EmojiScience
	EmojiMedical
	EmojiHousehold
	EmojiOtherObject
	EmojiTransportSign
	EmojiWarning
	EmojiArrow
	EmojiReligion
	EmojiZodiac
	EmojiAvSymbol
	EmojiGender
	EmojiMath
	EmojiPunctuation
	EmojiCurrency
	EmojiOtherSymbol
	EmojiKeycap
	EmojiAlphanum
	EmojiGeometric
	EmojiFlag
	EmojiCountryFlag
	EmojiSubdivisionFlag
)

// EmojiSubgroups is a list of all emoji subgroups.
var EmojiSubgroups = map[EmojiSubgroup]struct {
	Group EmojiGroup
	Name  string
}{
	EmojiFaceSmiling:          {EmojiSmileysAndEmotion, "face-smiling"},
	EmojiFaceAffection:        {EmojiSmileysAndEmotion, "face-affection"},
	EmojiFaceTongue:           {EmojiSmileysAndEmotion, "face-tongue"},
	EmojiFaceHand:             {EmojiSmileysAndEmotion, "face-hand"},
	EmojiFaceNeutralSkeptical: {EmojiSmileysAndEmotion, "face-neutral-skeptical"},
	EmojiFaceSleepy:           {EmojiSmileysAndEmotion, "face-sleepy"},
	EmojiFaceUnwell:           {EmojiSmileysAndEmotion, "face-unwell"},
	EmojiFaceHat:              {EmojiSmileysAndEmotion, "face-hat"},
	EmojiFaceGlasses:          {EmojiSmileysAndEmotion, "face-glasses"},
	EmojiFaceConcerned:        {EmojiSmileysAndEmotion, "face-concerned"},
	EmojiFaceNegative:         {EmojiSmileysAndEmotion, "face-negative"},
	EmojiFaceCostume:          {EmojiSmileysAndEmotion, "face-costume"},
	EmojiCatFace:              {EmojiSmileysAndEmotion, "cat-face"},
	EmojiMonkeyFace:           {EmojiSmileysAndEmotion, "monkey-face"},
	EmojiHeart:                {EmojiSmileysAndEmotion, "heart"},
	EmojiEmotion:              {EmojiSmileysAndEmotion, "emotion"},
	EmojiHandFingersOpen:      {EmojiPeopleAndBody, "hand-fingers-open"},
	EmojiHandFingersPartial:   {EmojiPeopleAndBody, "hand-fingers-partial"},
	EmojiHandSingleFinger:     {EmojiPeopleAndBody, "hand-single-finger"},
	EmojiHandFingersClosed:    {EmojiPeopleAndBody, "hand-fingers-closed"},
	EmojiHands:                {EmojiPeopleAndBody, "hands"},
	EmojiHandProp:             {EmojiPeopleAndBody, "hand-prop"},
	EmojiBodyParts:            {EmojiPeopleAndBody, "body-parts"},
	EmojiPerson:               {EmojiPeopleAndBody, "person"},
	EmojiPersonGesture:        {EmojiPeopleAndBody, "person-gesture"},
	EmojiPersonRole:           {EmojiPeopleAndBody, "person-role"},
	EmojiPersonFantasy:        {EmojiPeopleAndBody, "person-fantasy"},
	EmojiPersonActivity:       {EmojiPeopleAndBody, "person-activity"},
	EmojiPersonSport:          {EmojiPeopleAndBody, "person-sport"},
	EmojiPersonResting:        {EmojiPeopleAndBody, "person-resting"},
	EmojiFamily:               {EmojiPeopleAndBody, "family"},
	EmojiPersonSymbol:         {EmojiPeopleAndBody, "person-symbol"},
	EmojiSkinTone:             {EmojiComponent, "skin-tone"},
	EmojiHairStyle:            {EmojiComponent, "hair-style"},
	EmojiAnimalMammal:         {EmojiAnimalsAndNature, "animal-mammal"},
	EmojiAnimalBird:           {EmojiAnimalsAndNature, "animal-bird"},
	EmojiAnimalAmphibian:      {EmojiAnimalsAndNature, "animal-amphibian"},
	EmojiAnimalReptile:        {EmojiAnimalsAndNature, "animal-reptile"},
	EmojiAnimalMarine:         {EmojiAnimalsAndNature, "animal-marine"},
	EmojiAnimalBug:            {EmojiAnimalsAndNature, "animal-bug"},
	EmojiPlantFlower:          {EmojiAnimalsAndNature, "plant-flower"},
	EmojiPlantOther:           {EmojiAnimalsAndNature, "plant-other"},
	EmojiFoodFruit:            {EmojiFoodAndDrink, "food-fruit"},
	EmojiFoodVegetable:        {EmojiFoodAndDrink, "food-vegetable"},
	EmojiFoodPrepared:         {EmojiFoodAndDrink, "food-prepared"},
	EmojiFoodAsian:            {EmojiFoodAndDrink, "food-asian"},
	EmojiFoodSweet:            {EmojiFoodAndDrink, "food-sweet"},
	EmojiDrink:                {EmojiFoodAndDrink, "drink"},
	EmojiDishware:             {EmojiFoodAndDrink, "dishware"},
	EmojiPlaceMap:             {EmojiTravelAndPlaces, "place-map"},
	EmojiPlaceGeographic:      {EmojiTravelAndPlaces, "place-geographic"},
	EmojiPlaceBuilding:        {EmojiTravelAndPlaces, "place-building"},
	EmojiPlaceReligious:       {EmojiTravelAndPlaces, "place-religious"},
	EmojiPlaceOther:           {EmojiTravelAndPlaces, "place-other"},
	EmojiTransportGround:      {EmojiTravelAndPlaces, "transport-ground"},
	EmojiTransportWater:       {EmojiTravelAndPlaces, "transport-water"},
	EmojiTransportAir:         {EmojiTravelAndPlaces, "transport-air"},
	EmojiHotel:                {EmojiTravelAndPlaces, "hotel"},
	EmojiTime:                 {EmojiTravelAndPlaces, "time"},
	EmojiSkyAndweather:        {EmojiTravelAndPlaces, "sky & weather"},
	EmojiEvent:                {EmojiActivities, "event"},
	EmojiAwardMedal:           {EmojiActivities, "award-medal"},
	EmojiSport:                {EmojiActivities, "sport"},
	EmojiGame:                 {EmojiActivities, "game"},
	EmojiArtsAndcrafts:        {EmojiActivities, "arts & crafts"},
	EmojiClothing:             {EmojiObjects, "clothing"},
	EmojiSound:                {EmojiObjects, "sound"},
	EmojiMusic:                {EmojiObjects, "music"},
	EmojiMusicalInstrument:    {EmojiObjects, "musical-instrument"},
	EmojiPhone:                {EmojiObjects, "phone"},
	EmojiComputer:             {EmojiObjects, "computer"},
	EmojiLightAndvideo:        {EmojiObjects, "light & video"},
	EmojiBookPaper:            {EmojiObjects, "book-paper"},
	EmojiMoney:                {EmojiObjects, "money"},
	EmojiMail:                 {EmojiObjects, "mail"},
	EmojiWriting:              {EmojiObjects, "writing"},
	EmojiOffice:               {EmojiObjects, "office"},
	EmojiLock:                 {EmojiObjects, "lock"},
	EmojiTool:                 {EmojiObjects, "tool"},
	EmojiScience:              {EmojiObjects, "science"},
	EmojiMedical:              {EmojiObjects, "medical"},
	EmojiHousehold:            {EmojiObjects, "household"},
	EmojiOtherObject:          {EmojiObjects, "other-object"},
	EmojiTransportSign:        {EmojiSymbols, "transport-sign"},
	EmojiWarning:              {EmojiSymbols, "warning"},
	EmojiArrow:                {EmojiSymbols, "arrow"},
	EmojiReligion:             {EmojiSymbols, "religion"},
	EmojiZodiac:               {EmojiSymbols, "zodiac"},
	EmojiAvSymbol:             {EmojiSymbols, "av-symbol"},
	EmojiGender:               {EmojiSymbols, "gender"},
	EmojiMath:                 {EmojiSymbols, "math"},
	EmojiPunctuation:          {EmojiSymbols, "punctuation"},
	EmojiCurrency:             {EmojiSymbols, "currency"},
	EmojiOtherSymbol:          {EmojiSymbols, "other-symbol"},
	EmojiKeycap:               {EmojiSymbols, "keycap"},
	EmojiAlphanum:             {EmojiSymbols, "alphanum"},
	EmojiGeometric:            {EmojiSymbols, "geometric"},
	EmojiFlag:                 {EmojiFlags, "flag"},
	EmojiCountryFlag:          {EmojiFlags, "country-flag"},
	EmojiSubdivisionFlag:      {EmojiFlags, "subdivision-flag"},
}

var Emojis = []Emoji{
	{[]rune{0x1f600}, "grinning face", 0, 0, []string{"cheerful", "cheery", "face", "grin", "grinning", "happy", "laugh", "nice", "smile", "smiling", "teeth"}, false, 0},
	{[]rune{0x1f603}, "grinning face with big eyes", 0, 0, []string{"awesome", "big", "eyes", "face", "grin", "grinning", "happy", "mouth", "open", "smile", "smiling", "teeth", "yay"}, false, 0},
	{[]rune{0x1f604}, "grinning face with smiling eyes", 0, 0, []string{"eye", "eyes", "face", "grin", "grinning", "happy", "laugh", "lol", "mouth", "open", "smile", "smiling"}, false, 0},
	{[]rune{0x1f601}, "beaming face with smiling eyes", 0, 0, []string{"beaming", "eye", "eyes", "face", "grin", "grinning", "happy", "nice", "smile", "smiling", "teeth"}, false, 0},
	{[]rune{0x1f606}, "grinning squinting face", 0, 0, []string{"closed", "eyes", "face", "grinning", "haha", "hahaha", "happy", "laugh", "lol", "mouth", "open", "rofl", "smile", "smiling", "squinting"}, false, 0},
	{[]rune{0x1f605}, "grinning face with sweat", 0, 0, []string{"cold", "dejected", "excited", "face", "grinning", "mouth", "nervous", "open", "smile", "smiling", "stress", "stressed", "sweat"}, false, 0},
	{[]rune{0x1f923}, "rolling on the floor laughing", 0, 0, []string{"crying", "face", "floor", "funny", "haha", "happy", "hehe", "hilarious", "joy", "laugh", "lmao", "lol", "rofl", "roflmao", "rolling", "tear"}, false, 0},
	{[]rune{0x1f602}, "face with tears of joy", 0, 0, []string{"crying", "face", "feels", "funny", "haha", "happy", "hehe", "hilarious", "joy", "laugh", "lmao", "lol", "rofl", "roflmao", "tear"}, false, 0},
	{[]rune{0x1f642}, "slightly smiling face", 0, 0, []string{"face", "happy", "slightly", "smile", "smiling"}, false, 0},
	{[]rune{0x1f643}, "upside-down face", 0, 0, []string{"face", "hehe", "smile", "upside-down"}, false, 0},
	{[]rune{0x1fae0}, "melting face", 0, 0, []string{"disappear", "dissolve", "embarrassed", "face", "haha", "heat", "hot", "liquid", "lol", "melt", "melting", "sarcasm", "sarcastic"}, false, 0},
	{[]rune{0x1f609}, "winking face", 0, 0, []string{"face", "flirt", "heartbreaker", "sexy", "slide", "tease", "wink", "winking", "winks"}, false, 0},
	{[]rune{0x1f60a}, "smiling face with smiling eyes", 0, 0, []string{"blush", "eye", "eyes", "face", "glad", "satisfied", "smile", "smiling"}, false, 0},
	{[]rune{0x1f607}, "smiling face with halo", 0, 0, []string{"angel", "angelic", "angels", "blessed", "face", "fairy", "fairytale", "fantasy", "halo", "happy", "innocent", "peaceful", "smile", "smiling", "spirit", "tale"}, false, 0},
	{[]rune{0x1f970}, "smiling face with hearts", 0, 1, []string{"3", "adore", "crush", "face", "heart", "hearts", "ily", "love", "romance", "smile", "smiling", "you"}, false, 0},
	{[]rune{0x1f60d}, "smiling face with heart-eyes", 0, 1, []string{"143", "bae", "eye", "face", "feels", "heart-eyes", "hearts", "ily", "kisses", "love", "romance", "romantic", "smile", "xoxo"}, false, 0},
	{[]rune{0x1f929}, "star-struck", 0, 1, []string{"excited", "eyes", "face", "grinning", "smile", "star", "star-struck", "starry-eyed", "wow"}, false, 0},
	{[]rune{0x1f618}, "face blowing a kiss", 0, 1, []string{"adorbs", "bae", "blowing", "face", "flirt", "heart", "ily", "kiss", "love", "lover", "miss", "muah", "romantic", "smooch", "xoxo", "you"}, false, 0},
	{[]rune{0x1f617}, "kissing face", 0, 1, []string{"143", "date", "dating", "face", "flirt", "ily", "kiss", "love", "smooch", "smooches", "xoxo", "you"}, false, 0},
	{[]rune{0x263a, 0xfe0f}, "smiling face", 0, 1, []string{"face", "happy", "outlined", "relaxed", "smile", "smiling"}, false, 0},
	{[]rune{0x1f61a}, "kissing face with closed eyes", 0, 1, []string{"143", "bae", "blush", "closed", "date", "dating", "eye", "eyes", "face", "flirt", "ily", "kisses", "kissing", "smooches", "xoxo"}, false, 0},
	{[]rune{0x1f619}, "kissing face with smiling eyes", 0, 1, []string{"143", "closed", "date", "dating", "eye", "eyes", "face", "flirt", "ily", "kiss", "kisses", "kissing", "love", "night", "smile", "smiling"}, false, 0},
	{[]rune{0x1f972}, "smiling face with tear", 0, 1, []string{"face", "glad", "grateful", "happy", "joy", "pain", "proud", "relieved", "smile", "smiley", "smiling", "tear", "touched"}, false, 0},
	{[]rune{0x1f60b}, "face savoring food", 0, 2, []string{"delicious", "eat", "face", "food", "full", "hungry", "savor", "smile", "smiling", "tasty", "um", "yum", "yummy"}, false, 0},
	{[]rune{0x1f61b}, "face with tongue", 0, 2, []string{"awesome", "cool", "face", "nice", "party", "stuck-out", "sweet", "tongue"}, false, 0},
	{[]rune{0x1f61c}, "winking face with tongue", 0, 2, []string{"crazy", "epic", "eye", "face", "funny", "joke", "loopy", "nutty", "party", "stuck-out", "tongue", "wacky", "weirdo", "wink", "winking", "yolo"}, false, 0},
	{[]rune{0x1f92a}, "zany face", 0, 2, []string{"crazy", "eye", "eyes", "face", "goofy", "large", "small", "zany"}, false, 0},
	{[]rune{0x1f61d}, "squinting face with tongue", 0, 2, []string{"closed", "eye", "eyes", "face", "gross", "horrible", "omg", "squinting", "stuck-out", "taste", "tongue", "whatever", "yolo"}, false, 0},
	{[]rune{0x1f911}, "money-mouth face", 0, 2, []string{"face", "money", "money-mouth", "mouth", "paid"}, false, 0},
	{[]rune{0x1f917}, "smiling face with open hands", 0, 3, []string{"face", "hands", "hug", "hugging", "open", "smiling"}, false, 0},
	{[]rune{0x1f92d}, "face with hand over mouth", 0, 3, []string{"face", "giggle", "giggling", "hand", "mouth", "oops", "realization", "secret", "shock", "sudden", "surprise", "whoops"}, false, 0},
	{[]rune{0x1fae2}, "face with open eyes and hand over mouth", 0, 3, []string{"amazement", "awe", "disbelief", "embarrass", "eyes", "face", "gasp", "hand", "mouth", "omg", "open", "over", "quiet", "scared", "shock", "surprise"}, false, 0},
	{[]rune{0x1fae3}, "face with peeking eye", 0, 3, []string{"captivated", "embarrass", "eye", "face", "hide", "hiding", "peek", "peeking", "peep", "scared", "shy", "stare"}, false, 0},
	{[]rune{0x1f92b}, "shushing face", 0, 3, []string{"face", "quiet", "shh", "shush", "shushing"}, false, 0},
	{[]rune{0x1f914}, "thinking face", 0, 3, []string{"chin", "consider", "face", "hmm", "ponder", "pondering", "thinking", "wondering"}, false, 0},
	{[]rune{0x1fae1}, "saluting face", 0, 3, []string{"face", "good", "luck", "ma’am", "OK", "respect", "salute", "saluting", "sir", "troops", "yes"}, false, 0},
	{[]rune{0x1f910}, "zipper-mouth face", 0, 4, []string{"face", "keep", "mouth", "quiet", "secret", "shut", "zip", "zipper", "zipper-mouth"}, false, 0},
	{[]rune{0x1f928}, "face with raised eyebrow", 0, 4, []string{"disapproval", "disbelief", "distrust", "emoji", "eyebrow", "face", "hmm", "mild", "raised", "skeptic", "skeptical", "skepticism", "surprise", "what"}, false, 0},
	{[]rune{0x1f610}, "neutral face", 0, 4, []string{"awkward", "blank", "deadpan", "expressionless", "face", "fine", "jealous", "meh", "neutral", "oh", "shade", "straight", "unamused", "unhappy", "unimpressed", "whatever"}, false, 0},
	{[]rune{0x1f611}, "expressionless face", 0, 4, []string{"awkward", "dead", "expressionless", "face", "fine", "inexpressive", "jealous", "meh", "not", "oh", "omg", "straight", "uh", "unhappy", "unimpressed", "whatever"}, false, 0},
	{[]rune{0x1f636}, "face without mouth", 0, 4, []string{"awkward", "blank", "expressionless", "face", "mouth", "mouthless", "mute", "quiet", "secret", "silence", "silent", "speechless"}, false, 0},
	{[]rune{0x1fae5}, "dotted line face", 0, 4, []string{"depressed", "disappear", "dotted", "face", "hidden", "hide", "introvert", "invisible", "line", "meh", "whatever", "wtv"}, false, 0},
	{[]rune{0x1f636, 0x1f32b, 0xfe0f}, "face in clouds", 0, 4, []string{"absentminded", "clouds", "face", "fog", "head"}, false, 0},
	{[]rune{0x1f60f}, "smirking face", 0, 4, []string{"boss", "dapper", "face", "flirt", "homie", "kidding", "leer", "shade", "slick", "sly", "smirk", "smug", "snicker", "suave", "suspicious", "swag"}, false, 0},
	{[]rune{0x1f612}, "unamused face", 0, 4, []string{"...", "bored", "face", "fine", "jealous", "jel", "jelly", "pissed", "smh", "ugh", "uhh", "unamused", "unhappy", "weird", "whatever"}, false, 0},
	{[]rune{0x1f644}, "face with rolling eyes", 0, 4, []string{"eyeroll", "eyes", "face", "rolling", "shade", "ugh", "whatever"}, false, 0},
	{[]rune{0x1f62c}, "grimacing face", 0, 4, []string{"awk", "awkward", "dentist", "face", "grimace", "grimacing", "grinning", "smile", "smiling"}, false, 0},
	{[]rune{0x1f62e, 0x1f4a8}, "face exhaling", 0, 4, []string{"blow", "blowing", "exhale", "exhaling", "exhausted", "face", "gasp", "groan", "relief", "sigh", "smiley", "smoke", "whisper", "whistle"}, false, 0},
	{[]rune{0x1f925}, "lying face", 0, 4, []string{"face", "liar", "lie", "lying", "pinocchio"}, false, 0},
	{[]rune{0x1fae8}, "shaking face", 0, 4, []string{"crazy", "daze", "earthquake", "face", "omg", "panic", "shaking", "shock", "surprise", "vibrate", "whoa", "wow"}, false, 0},
	{[]rune{0x1f642, 0x2194, 0xfe0f}, "head shaking horizontally", 0, 4, []string{"head", "horizontally", "no", "shake", "shaking"}, false, 0},
	{[]rune{0x1f642, 0x2195, 0xfe0f}, "head shaking vertically", 0, 4, []string{"head", "nod", "shaking", "vertically", "yes"}, false, 0},
	{[]rune{0x1f60c}, "relieved face", 0, 5, []string{"calm", "face", "peace", "relief", "relieved", "zen"}, false, 0},
	{[]rune{0x1f614}, "pensive face", 0, 5, []string{"awful", "bored", "dejected", "died", "disappointed", "face", "losing", "lost", "pensive", "sad", "sucks"}, false, 0},
	{[]rune{0x1f62a}, "sleepy face", 0, 5, []string{"crying", "face", "good", "night", "sad", "sleep", "sleeping", "sleepy", "tired"}, false, 0},
	{[]rune{0x1f924}, "drooling face", 0, 5, []string{"drooling", "face"}, false, 0},
	{[]rune{0x1f634}, "sleeping face", 0, 5, []string{"bed", "bedtime", "face", "good", "goodnight", "nap", "night", "sleep", "sleeping", "tired", "whatever", "yawn", "zzz"}, false, 0},
	{[]rune{0x1fae9}, "face with bags under eyes", 0, 5, []string{"bags", "bored", "exhausted", "eyes", "face", "fatigued", "late", "sleepy", "tired", "weary"}, false, 0},
	{[]rune{0x1f637}, "face with medical mask", 0, 6, []string{"cold", "dentist", "dermatologist", "doctor", "dr", "face", "germs", "mask", "medical", "medicine", "sick"}, false, 0},
	{[]rune{0x1f912}, "face with thermometer", 0, 6, []string{"face", "ill", "sick", "thermometer"}, false, 0},
	{[]rune{0x1f915}, "face with head-bandage", 0, 6, []string{"bandage", "face", "head-bandage", "hurt", "injury", "ouch"}, false, 0},
	{[]rune{0x1f922}, "nauseated face", 0, 6, []string{"face", "gross", "nasty", "nauseated", "sick", "vomit"}, false, 0},
	{[]rune{0x1f92e}, "face vomiting", 0, 6, []string{"barf", "ew", "face", "gross", "puke", "sick", "spew", "throw", "up", "vomit", "vomiting"}, false, 0},
	{[]rune{0x1f927}, "sneezing face", 0, 6, []string{"face", "fever", "flu", "gesundheit", "sick", "sneeze", "sneezing"}, false, 0},
	{[]rune{0x1f975}, "hot face", 0, 6, []string{"dying", "face", "feverish", "heat", "hot", "panting", "red-faced", "stroke", "sweating", "tongue"}, false, 0},
	{[]rune{0x1f976}, "cold face", 0, 6, []string{"blue", "blue-faced", "cold", "face", "freezing", "frostbite", "icicles", "subzero", "teeth"}, false, 0},
	{[]rune{0x1f974}, "woozy face", 0, 6, []string{"dizzy", "drunk", "eyes", "face", "intoxicated", "mouth", "tipsy", "uneven", "wavy", "woozy"}, false, 0},
	{[]rune{0x1f635}, "face with crossed-out eyes", 0, 6, []string{"crossed-out", "dead", "dizzy", "eyes", "face", "feels", "knocked", "out", "sick", "tired"}, false, 0},
	{[]rune{0x1f635, 0x1f4ab}, "face with spiral eyes", 0, 6, []string{"confused", "dizzy", "eyes", "face", "hypnotized", "omg", "smiley", "spiral", "trouble", "whoa", "woah", "woozy"}, false, 0},
	{[]rune{0x1f92f}, "exploding head", 0, 6, []string{"blown", "explode", "exploding", "head", "mind", "mindblown", "no", "shocked", "way"}, false, 0},
	{[]rune{0x1f920}, "cowboy hat face", 0, 7, []string{"cowboy", "cowgirl", "face", "hat"}, false, 0},
	{[]rune{0x1f973}, "partying face", 0, 7, []string{"bday", "birthday", "celebrate", "celebration", "excited", "face", "happy", "hat", "hooray", "horn", "party", "partying"}, false, 0},
	{[]rune{0x1f978}, "disguised face", 0, 7, []string{"disguise", "eyebrow", "face", "glasses", "incognito", "moustache", "mustache", "nose", "person", "spy", "tache", "tash"}, false, 0},
	{[]rune{0x1f60e}, "smiling face with sunglasses", 0, 8, []string{"awesome", "beach", "bright", "bro", "chilling", "cool", "face", "rad", "relaxed", "shades", "slay", "smile", "style", "sunglasses", "swag", "win"}, false, 0},
	{[]rune{0x1f913}, "nerd face", 0, 8, []string{"brainy", "clever", "expert", "face", "geek", "gifted", "glasses", "intelligent", "nerd", "smart"}, false, 0},
	{[]rune{0x1f9d0}, "face with monocle", 0, 8, []string{"classy", "face", "fancy", "monocle", "rich", "stuffy", "wealthy"}, false, 0},
	{[]rune{0x1f615}, "confused face", 0, 9, []string{"befuddled", "confused", "confusing", "dunno", "face", "frown", "hm", "meh", "not", "sad", "sorry", "sure"}, false, 0},
	{[]rune{0x1fae4}, "face with diagonal mouth", 0, 9, []string{"confused", "confusion", "diagonal", "disappointed", "doubt", "doubtful", "face", "frustrated", "frustration", "meh", "mouth", "skeptical", "unsure", "whatever", "wtv"}, false, 0},
	{[]rune{0x1f61f}, "worried face", 0, 9, []string{"anxious", "butterflies", "face", "nerves", "nervous", "sad", "stress", "stressed", "surprised", "worried", "worry"}, false, 0},
	{[]rune{0x1f641}, "slightly frowning face", 0, 9, []string{"face", "frown", "frowning", "sad", "slightly"}, false, 0},
	{[]rune{0x2639, 0xfe0f}, "frowning face", 0, 9, []string{"face", "frown", "frowning", "sad"}, false, 0},
	{[]rune{0x1f62e}, "face with open mouth", 0, 9, []string{"believe", "face", "forgot", "mouth", "omg", "open", "shocked", "surprised", "sympathy", "unbelievable", "unreal", "whoa", "wow", "you"}, false, 0},
	{[]rune{0x1f62f}, "hushed face", 0, 9, []string{"epic", "face", "hushed", "omg", "stunned", "surprised", "whoa", "woah"}, false, 0},
	{[]rune{0x1f632}, "astonished face", 0, 9, []string{"astonished", "cost", "face", "no", "omg", "shocked", "totally", "way"}, false, 0},
	{[]rune{0x1f633}, "flushed face", 0, 9, []string{"amazed", "awkward", "crazy", "dazed", "dead", "disbelief", "embarrassed", "face", "flushed", "geez", "heat", "hot", "impressed", "jeez", "what", "wow"}, false, 0},
	{[]rune{0x1faea}, "distorted face", 0, 9, []string{"anxiety", "bloated", "panic", "shocked", "surprised", "vulnerable"}, false, 0},
	{[]rune{0x1f97a}, "pleading face", 0, 9, []string{"begging", "big", "eyes", "face", "mercy", "not", "pleading", "please", "pretty", "puppy", "sad", "why"}, false, 0},
	{[]rune{0x1f979}, "face holding back tears", 0, 9, []string{"admiration", "aww", "back", "cry", "embarrassed", "face", "feelings", "grateful", "gratitude", "holding", "joy", "please", "proud", "resist", "sad", "tears"}, false, 0},
	{[]rune{0x1f626}, "frowning face with open mouth", 0, 9, []string{"caught", "face", "frown", "frowning", "guard", "mouth", "open", "scared", "scary", "surprise", "what", "wow"}, false, 0},
	{[]rune{0x1f627}, "anguished face", 0, 9, []string{"anguished", "face", "forgot", "scared", "scary", "stressed", "surprise", "unhappy", "what", "wow"}, false, 0},
	{[]rune{0x1f628}, "fearful face", 0, 9, []string{"afraid", "anxious", "blame", "face", "fear", "fearful", "scared", "worried"}, false, 0},
	{[]rune{0x1f630}, "anxious face with sweat", 0, 9, []string{"anxious", "blue", "cold", "eek", "face", "mouth", "nervous", "open", "rushed", "scared", "sweat", "yikes"}, false, 0},
	{[]rune{0x1f625}, "sad but relieved face", 0, 9, []string{"anxious", "call", "close", "complicated", "disappointed", "face", "not", "relieved", "sad", "sweat", "time", "whew"}, false, 0},
	{[]rune{0x1f622}, "crying face", 0, 9, []string{"awful", "cry", "crying", "face", "feels", "miss", "sad", "tear", "triste", "unhappy"}, false, 0},
	{[]rune{0x1f62d}, "loudly crying face", 0, 9, []string{"bawling", "cry", "crying", "face", "loudly", "sad", "sob", "tear", "tears", "unhappy"}, false, 0},
	{[]rune{0x1f631}, "face screaming in fear", 0, 9, []string{"epic", "face", "fear", "fearful", "munch", "scared", "scream", "screamer", "screaming", "shocked", "surprised", "woah"}, false, 0},
	{[]rune{0x1f616}, "confounded face", 0, 9, []string{"annoyed", "confounded", "confused", "cringe", "distraught", "face", "feels", "frustrated", "mad", "sad"}, false, 0},
	{[]rune{0x1f623}, "persevering face", 0, 9, []string{"concentrate", "concentration", "face", "focus", "headache", "persevere", "persevering"}, false, 0},
	{[]rune{0x1f61e}, "disappointed face", 0, 9, []string{"awful", "blame", "dejected", "disappointed", "face", "fail", "losing", "sad", "unhappy"}, false, 0},
	{[]rune{0x1f613}, "downcast face with sweat", 0, 9, []string{"close", "cold", "downcast", "face", "feels", "headache", "nervous", "sad", "scared", "sweat", "yikes"}, false, 0},
	{[]rune{0x1f629}, "weary face", 0, 9, []string{"crying", "face", "fail", "feels", "hungry", "mad", "nooo", "sad", "sleepy", "tired", "unhappy", "weary"}, false, 0},
	{[]rune{0x1f62b}, "tired face", 0, 9, []string{"cost", "face", "feels", "nap", "sad", "sneeze", "tired"}, false, 0},
	{[]rune{0x1f971}, "yawning face", 0, 9, []string{"bedtime", "bored", "face", "goodnight", "nap", "night", "sleep", "sleepy", "tired", "whatever", "yawn", "yawning", "zzz"}, false, 0},
	{[]rune{0x1f624}, "face with steam from nose", 0, 10, []string{"anger", "angry", "face", "feels", "fume", "fuming", "furious", "fury", "mad", "nose", "steam", "triumph", "unhappy", "won"}, false, 0},
	{[]rune{0x1f621}, "enraged face", 0, 10, []string{"anger", "angry", "enraged", "face", "feels", "mad", "maddening", "pouting", "rage", "red", "shade", "unhappy", "upset"}, false, 0},
	{[]rune{0x1f620}, "angry face", 0, 10, []string{"anger", "angry", "blame", "face", "feels", "frustrated", "mad", "maddening", "rage", "shade", "unhappy", "upset"}, false, 0},
	{[]rune{0x1f92c}, "face with symbols on mouth", 0, 10, []string{"censor", "cursing", "cussing", "face", "mad", "mouth", "pissed", "swearing", "symbols"}, false, 0},
	{[]rune{0x1f608}, "smiling face with horns", 0, 10, []string{"demon", "devil", "evil", "face", "fairy", "fairytale", "fantasy", "horns", "purple", "shade", "smile", "smiling", "tale"}, false, 0},
	{[]rune{0x1f47f}, "angry face with horns", 0, 10, []string{"angry", "demon", "devil", "evil", "face", "fairy", "fairytale", "fantasy", "horns", "imp", "mischievous", "purple", "shade", "tale"}, false, 0},
	{[]rune{0x1f480}, "skull", 0, 10, []string{"body", "dead", "death", "face", "fairy", "fairytale", "i’m", "lmao", "monster", "skull", "tale", "yolo"}, false, 0},
	{[]rune{0x2620, 0xfe0f}, "skull and crossbones", 0, 10, []string{"bone", "crossbones", "dead", "death", "face", "monster", "skull"}, false, 0},
	{[]rune{0x1f4a9}, "pile of poo", 0, 11, []string{"bs", "comic", "doo", "dung", "face", "fml", "monster", "pile", "poo", "poop", "smelly", "smh", "stink", "stinks", "stinky", "turd"}, false, 0},
	{[]rune{0x1f921}, "clown face", 0, 11, []string{"clown", "face"}, false, 0},
	{[]rune{0x1f479}, "ogre", 0, 11, []string{"creature", "devil", "face", "fairy", "fairytale", "fantasy", "mask", "monster", "ogre", "scary", "tale"}, false, 0},
	{[]rune{0x1f47a}, "goblin", 0, 11, []string{"angry", "creature", "face", "fairy", "fairytale", "fantasy", "goblin", "mask", "mean", "monster", "tale"}, false, 0},
	{[]rune{0x1f47b}, "ghost", 0, 11, []string{"boo", "creature", "excited", "face", "fairy", "fairytale", "fantasy", "ghost", "halloween", "haunting", "monster", "scary", "silly", "tale"}, false, 0},
	{[]rune{0x1f47d}, "alien", 0, 11, []string{"alien", "creature", "extraterrestrial", "face", "fairy", "fairytale", "fantasy", "monster", "space", "tale", "ufo"}, false, 0},
	{[]rune{0x1f47e}, "alien monster", 0, 11, []string{"alien", "creature", "extraterrestrial", "face", "fairy", "fairytale", "fantasy", "game", "gamer", "games", "monster", "pixelated", "space", "tale", "ufo"}, false, 0},
	{[]rune{0x1f916}, "robot", 0, 11, []string{"face", "monster", "robot"}, false, 0},
	{[]rune{0x1f63a}, "grinning cat", 0, 12, []string{"animal", "cat", "face", "grinning", "mouth", "open", "smile", "smiling"}, false, 0},
	{[]rune{0x1f638}, "grinning cat with smiling eyes", 0, 12, []string{"animal", "cat", "eye", "eyes", "face", "grin", "grinning", "smile", "smiling"}, false, 0},
	{[]rune{0x1f639}, "cat with tears of joy", 0, 12, []string{"animal", "cat", "face", "joy", "laugh", "laughing", "lol", "tear", "tears"}, false, 0},
	{[]rune{0x1f63b}, "smiling cat with heart-eyes", 0, 12, []string{"animal", "cat", "eye", "face", "heart", "heart-eyes", "love", "smile", "smiling"}, false, 0},
	{[]rune{0x1f63c}, "cat with wry smile", 0, 12, []string{"animal", "cat", "face", "ironic", "smile", "wry"}, false, 0},
	{[]rune{0x1f63d}, "kissing cat", 0, 12, []string{"animal", "cat", "closed", "eye", "eyes", "face", "kiss", "kissing"}, false, 0},
	{[]rune{0x1f640}, "weary cat", 0, 12, []string{"animal", "cat", "face", "oh", "surprised", "weary"}, false, 0},
	{[]rune{0x1f63f}, "crying cat", 0, 12, []string{"animal", "cat", "cry", "crying", "face", "sad", "tear"}, false, 0},
	{[]rune{0x1f63e}, "pouting cat", 0, 12, []string{"animal", "cat", "face", "pouting"}, false, 0},
	{[]rune{0x1f648}, "see-no-evil monkey", 0, 13, []string{"embarrassed", "evil", "face", "forbidden", "forgot", "gesture", "hide", "monkey", "no", "omg", "prohibited", "scared", "secret", "smh", "watch"}, false, 0},
	{[]rune{0x1f649}, "hear-no-evil monkey", 0, 13, []string{"animal", "ears", "evil", "face", "forbidden", "gesture", "hear", "listen", "monkey", "no", "not", "prohibited", "secret", "shh", "tmi"}, false, 0},
	{[]rune{0x1f64a}, "speak-no-evil monkey", 0, 13, []string{"animal", "evil", "face", "forbidden", "gesture", "monkey", "no", "not", "oops", "prohibited", "quiet", "secret", "speak", "stealth"}, false, 0},
	{[]rune{0x1f48c}, "love letter", 0, 14, []string{"heart", "letter", "love", "mail", "romance", "valentine"}, false, 0},
	{[]rune{0x1f498}, "heart with arrow", 0, 14, []string{"143", "adorbs", "arrow", "cupid", "date", "emotion", "heart", "ily", "love", "romance", "valentine"}, false, 0},
	{[]rune{0x1f49d}, "heart with ribbon", 0, 14, []string{"143", "anniversary", "emotion", "heart", "ily", "kisses", "ribbon", "valentine", "xoxo"}, false, 0},
	{[]rune{0x1f496}, "sparkling heart", 0, 14, []string{"143", "emotion", "excited", "good", "heart", "ily", "kisses", "morning", "night", "sparkle", "sparkling", "xoxo"}, false, 0},
	{[]rune{0x1f497}, "growing heart", 0, 14, []string{"143", "emotion", "excited", "growing", "heart", "heartpulse", "ily", "kisses", "muah", "nervous", "pulse", "xoxo"}, false, 0},
	{[]rune{0x1f493}, "beating heart", 0, 14, []string{"143", "beating", "cardio", "emotion", "heart", "heartbeat", "ily", "love", "pulsating", "pulse"}, false, 0},
	{[]rune{0x1f49e}, "revolving hearts", 0, 14, []string{"143", "adorbs", "anniversary", "emotion", "heart", "hearts", "revolving"}, false, 0},
	{[]rune{0x1f495}, "two hearts", 0, 14, []string{"143", "anniversary", "date", "dating", "emotion", "heart", "hearts", "ily", "kisses", "love", "loving", "two", "xoxo"}, false, 0},
	{[]rune{0x1f49f}, "heart decoration", 0, 14, []string{"143", "decoration", "emotion", "heart", "hearth", "purple", "white"}, false, 0},
	{[]rune{0x2763, 0xfe0f}, "heart exclamation", 0, 14, []string{"exclamation", "heart", "heavy", "mark", "punctuation"}, false, 0},
	{[]rune{0x1f494}, "broken heart", 0, 14, []string{"break", "broken", "crushed", "emotion", "heart", "heartbroken", "lonely", "sad"}, false, 0},
	{[]rune{0x2764, 0xfe0f, 0x1f525}, "heart on fire", 0, 14, []string{"burn", "fire", "heart", "love", "lust", "sacred"}, false, 0},
	{[]rune{0x2764, 0xfe0f, 0x1fa79}, "mending heart", 0, 14, []string{"healthier", "heart", "improving", "mending", "recovering", "recuperating", "well"}, false, 0},
	{[]rune{0x2764, 0xfe0f}, "red heart", 0, 14, []string{"emotion", "heart", "love", "red"}, false, 0},
	{[]rune{0x1fa77}, "pink heart", 0, 14, []string{"143", "adorable", "cute", "emotion", "heart", "ily", "like", "love", "pink", "special", "sweet"}, false, 0},
	{[]rune{0x1f9e1}, "orange heart", 0, 14, []string{"143", "heart", "orange"}, false, 0},
	{[]rune{0x1f49b}, "yellow heart", 0, 14, []string{"143", "cardiac", "emotion", "heart", "ily", "love", "yellow"}, false, 0},
	{[]rune{0x1f49a}, "green heart", 0, 14, []string{"143", "emotion", "green", "heart", "ily", "love", "romantic"}, false, 0},
	{[]rune{0x1f499}, "blue heart", 0, 14, []string{"143", "blue", "emotion", "heart", "ily", "love", "romance"}, false, 0},
	{[]rune{0x1fa75}, "light blue heart", 0, 14, []string{"143", "blue", "cute", "cyan", "emotion", "heart", "ily", "light", "like", "love", "sky", "special", "teal"}, false, 0},
	{[]rune{0x1f49c}, "purple heart", 0, 14, []string{"143", "bestest", "emotion", "heart", "ily", "love", "purple"}, false, 0},
	{[]rune{0x1f90e}, "brown heart", 0, 14, []string{"143", "brown", "heart"}, false, 0},
	{[]rune{0x1f5a4}, "black heart", 0, 14, []string{"black", "evil", "heart", "wicked"}, false, 0},
	{[]rune{0x1fa76}, "grey heart", 0, 14, []string{"143", "emotion", "gray", "grey", "heart", "ily", "love", "silver", "slate", "special"}, false, 0},
	{[]rune{0x1f90d}, "white heart", 0, 14, []string{"143", "heart", "white"}, false, 0},
	{[]rune{0x1f48b}, "kiss mark", 0, 15, []string{"dating", "emotion", "heart", "kiss", "kissing", "lips", "mark", "romance", "sexy"}, false, 0},
	{[]rune{0x1f4af}, "hundred points", 0, 15, []string{"100", "a+", "agree", "clearly", "definitely", "faithful", "fleek", "full", "hundred", "keep", "perfect", "point", "score", "TRUE", "truth", "yup"}, false, 0},
	{[]rune{0x1f4a2}, "anger symbol", 0, 15, []string{"anger", "angry", "comic", "mad", "symbol", "upset"}, false, 0},
	{[]rune{0x1faef}, "fight cloud", 0, 15, []string{"argument", "brawl", "debate", "disagreement", "fight", "ruckus", "wrestle"}, false, 0},
	{[]rune{0x1f4a5}, "collision", 0, 15, []string{"bomb", "boom", "collide", "collision", "comic", "explode"}, false, 0},
	{[]rune{0x1f4ab}, "dizzy", 0, 15, []string{"comic", "dizzy", "shining", "shooting", "star", "stars"}, false, 0},
	{[]rune{0x1f4a6}, "sweat droplets", 0, 15, []string{"comic", "drip", "droplet", "droplets", "drops", "splashing", "squirt", "sweat", "water", "wet", "work", "workout"}, false, 0},
	{[]rune{0x1f4a8}, "dashing away", 0, 15, []string{"away", "cloud", "comic", "dash", "dashing", "fart", "fast", "go", "gone", "gotta", "running", "smoke"}, false, 0},
	{[]rune{0x1f573, 0xfe0f}, "hole", 0, 15, []string{"hole"}, false, 0},
	{[]rune{0x1f4ac}, "speech balloon", 0, 15, []string{"balloon", "bubble", "comic", "dialog", "message", "sms", "speech", "talk", "text", "typing"}, false, 0},
	{[]rune{0x1f441, 0xfe0f, 0x1f5e8, 0xfe0f}, "eye in speech bubble", 0, 15, []string{"balloon", "bubble", "eye", "speech", "witness"}, false, 0},
	{[]rune{0x1f5e8, 0xfe0f}, "left speech bubble", 0, 15, []string{"balloon", "bubble", "dialog", "left", "speech"}, false, 0},
	{[]rune{0x1f5ef, 0xfe0f}, "right anger bubble", 0, 15, []string{"anger", "angry", "balloon", "bubble", "mad", "right"}, false, 0},
	{[]rune{0x1f4ad}, "thought balloon", 0, 15, []string{"balloon", "bubble", "cartoon", "cloud", "comic", "daydream", "decisions", "dream", "idea", "invent", "invention", "realize", "think", "thoughts", "wonder"}, false, 0},
	{[]rune{0x1f4a4}, "ZZZ", 0, 15, []string{"comic", "good", "goodnight", "night", "sleep", "sleeping", "sleepy", "tired", "zzz"}, false, 0},
	{[]rune{0x1f44b}, "waving hand", 1, 16, []string{"bye", "cya", "g2g", "greetings", "gtg", "hand", "hello", "hey", "hi", "later", "outtie", "ttfn", "ttyl", "wave", "yo", "you"}, true, 0},
	{[]rune{0x1f91a}, "raised back of hand", 1, 16, []string{"back", "backhand", "hand", "raised"}, true, 0},
	{[]rune{0x1f590, 0xfe0f}, "hand with fingers splayed", 1, 16, []string{"finger", "fingers", "hand", "raised", "splayed", "stop"}, true, 0},
	{[]rune{0x270b}, "raised hand", 1, 16, []string{"5", "five", "hand", "high", "raised", "stop"}, true, 0},
	{[]rune{0x1f596}, "vulcan salute", 1, 16, []string{"finger", "hand", "hands", "salute", "Vulcan"}, true, 0},
	{[]rune{0x1faf1}, "rightwards hand", 1, 16, []string{"hand", "handshake", "hold", "reach", "right", "rightward", "rightwards", "shake"}, true, 0},
	{[]rune{0x1faf2}, "leftwards hand", 1, 16, []string{"hand", "handshake", "hold", "left", "leftward", "leftwards", "reach", "shake"}, true, 0},
	{[]rune{0x1faf3}, "palm down hand", 1, 16, []string{"dismiss", "down", "drop", "dropped", "hand", "palm", "pick", "shoo", "up"}, true, 0},
	{[]rune{0x1faf4}, "palm up hand", 1, 16, []string{"beckon", "catch", "come", "hand", "hold", "know", "lift", "me", "offer", "palm", "tell"}, true, 0},
	{[]rune{0x1faf7}, "leftwards pushing hand", 1, 16, []string{"block", "five", "halt", "hand", "high", "hold", "leftward", "leftwards", "pause", "push", "pushing", "refuse", "slap", "stop", "wait"}, true, 0},
	{[]rune{0x1faf8}, "rightwards pushing hand", 1, 16, []string{"block", "five", "halt", "hand", "high", "hold", "pause", "push", "pushing", "refuse", "rightward", "rightwards", "slap", "stop", "wait"}, true, 0},
	{[]rune{0x1f44c}, "OK hand", 1, 17, []string{"awesome", "bet", "dope", "fleek", "fosho", "got", "gotcha", "hand", "legit", "OK", "okay", "pinch", "rad", "sure", "sweet", "three"}, true, 0},
	{[]rune{0x1f90c}, "pinched fingers", 1, 17, []string{"fingers", "gesture", "hand", "hold", "huh", "interrogation", "patience", "pinched", "relax", "sarcastic", "ugh", "what", "zip"}, true, 0},
	{[]rune{0x1f90f}, "pinching hand", 1, 17, []string{"amount", "bit", "fingers", "hand", "little", "pinching", "small", "sort"}, true, 0},
	{[]rune{0x270c, 0xfe0f}, "victory hand", 1, 17, []string{"hand", "peace", "v", "victory"}, true, 0},
	{[]rune{0x1f91e}, "crossed fingers", 1, 17, []string{"cross", "crossed", "finger", "fingers", "hand", "luck"}, true, 0},
	{[]rune{0x1faf0}, "hand with index finger and thumb crossed", 1, 17, []string{"<3", "crossed", "expensive", "finger", "hand", "heart", "index", "love", "money", "snap", "thumb"}, true, 0},
	{[]rune{0x1f91f}, "love-you gesture", 1, 17, []string{"fingers", "gesture", "hand", "ILY", "love", "love-you", "three", "you"}, true, 0},
	{[]rune{0x1f918}, "sign of the horns", 1, 17, []string{"finger", "hand", "horns", "rock-on", "sign"}, true, 0},
	{[]rune{0x1f919}, "call me hand", 1, 17, []string{"call", "hand", "hang", "loose", "me", "Shaka"}, true, 0},
	{[]rune{0x1f448}, "backhand index pointing left", 1, 18, []string{"backhand", "finger", "hand", "index", "left", "point", "pointing"}, true, 0},
	{[]rune{0x1f449}, "backhand index pointing right", 1, 18, []string{"backhand", "finger", "hand", "index", "point", "pointing", "right"}, true, 0},
	{[]rune{0x1f446}, "backhand index pointing up", 1, 18, []string{"backhand", "finger", "hand", "index", "point", "pointing", "up"}, true, 0},
	{[]rune{0x1f595}, "middle finger", 1, 18, []string{"finger", "hand", "middle"}, true, 0},
	{[]rune{0x1f447}, "backhand index pointing down", 1, 18, []string{"backhand", "down", "finger", "hand", "index", "point", "pointing"}, true, 0},
	{[]rune{0x261d, 0xfe0f}, "index pointing up", 1, 18, []string{"finger", "hand", "index", "point", "pointing", "this", "up"}, true, 0},
	{[]rune{0x1faf5}, "index pointing at the viewer", 1, 18, []string{"at", "finger", "hand", "index", "pointing", "poke", "viewer", "you"}, true, 0},
	{[]rune{0x1f44d}, "thumbs up", 1, 19, []string{"+1", "good", "hand", "like", "thumb", "up", "yes"}, true, 0},
	{[]rune{0x1f44e}, "thumbs down", 1, 19, []string{"-1", "bad", "dislike", "down", "good", "hand", "no", "nope", "thumb", "thumbs"}, true, 0},
	{[]rune{0x270a}, "raised fist", 1, 19, []string{"clenched", "fist", "hand", "punch", "raised", "solidarity"}, true, 0},
	{[]rune{0x1f44a}, "oncoming fist", 1, 19, []string{"absolutely", "agree", "boom", "bro", "bruh", "bump", "clenched", "correct", "fist", "hand", "knuckle", "oncoming", "pound", "punch", "rock", "ttyl"}, true, 0},
	{[]rune{0x1f91b}, "left-facing fist", 1, 19, []string{"fist", "left-facing", "leftwards"}, true, 0},
	{[]rune{0x1f91c}, "right-facing fist", 1, 19, []string{"fist", "right-facing", "rightwards"}, true, 0},
	{[]rune{0x1f44f}, "clapping hands", 1, 20, []string{"applause", "approval", "awesome", "clap", "congrats", "congratulations", "excited", "good", "great", "hand", "homie", "job", "nice", "prayed", "well", "yay"}, true, 0},
	{[]rune{0x1f64c}, "raising hands", 1, 20, []string{"celebration", "gesture", "hand", "hands", "hooray", "praise", "raised", "raising"}, true, 0},
	{[]rune{0x1faf6}, "heart hands", 1, 20, []string{"<3", "hands", "heart", "love", "you"}, true, 0},
	{[]rune{0x1f450}, "open hands", 1, 20, []string{"hand", "hands", "hug", "jazz", "open", "swerve"}, true, 0},
	{[]rune{0x1f932}, "palms up together", 1, 20, []string{"cupped", "dua", "hands", "palms", "pray", "prayer", "together", "up", "wish"}, true, 0},
	{[]rune{0x1f91d}, "handshake", 1, 20, []string{"agreement", "deal", "hand", "handshake", "meeting", "shake"}, true, 0},
	{[]rune{0x1f64f}, "folded hands", 1, 20, []string{"appreciate", "ask", "beg", "blessed", "bow", "cmon", "five", "folded", "gesture", "hand", "high", "please", "pray", "thanks", "thx"}, true, 0},
	{[]rune{0x270d, 0xfe0f}, "writing hand", 1, 21, []string{"hand", "write", "writing"}, true, 0},
	{[]rune{0x1f485}, "nail polish", 1, 21, []string{"bored", "care", "cosmetics", "done", "makeup", "manicure", "nail", "polish", "whatever"}, true, 0},
	{[]rune{0x1f933}, "selfie", 1, 21, []string{"camera", "phone", "selfie"}, true, 0},
	{[]rune{0x1f4aa}, "flexed biceps", 1, 22, []string{"arm", "beast", "bench", "biceps", "bodybuilder", "bro", "curls", "flex", "gains", "gym", "jacked", "muscle", "press", "ripped", "strong", "weightlift"}, true, 0},
	{[]rune{0x1f9be}, "mechanical arm", 1, 22, []string{"accessibility", "arm", "mechanical", "prosthetic"}, false, 0},
	{[]rune{0x1f9bf}, "mechanical leg", 1, 22, []string{"accessibility", "leg", "mechanical", "prosthetic"}, false, 0},
	{[]rune{0x1f9b5}, "leg", 1, 22, []string{"bent", "foot", "kick", "knee", "leg", "limb"}, true, 0},
	{[]rune{0x1f9b6}, "foot", 1, 22, []string{"ankle", "feet", "foot", "kick", "stomp"}, true, 0},
	{[]rune{0x1f442}, "ear", 1, 22, []string{"body", "ear", "ears", "hear", "hearing", "listen", "listening", "sound"}, true, 0},
	{[]rune{0x1f9bb}, "ear with hearing aid", 1, 22, []string{"accessibility", "aid", "ear", "hard", "hearing"}, true, 0},
	{[]rune{0x1f443}, "nose", 1, 22, []string{"body", "nose", "noses", "nosey", "odor", "smell", "smells"}, true, 0},
	{[]rune{0x1f9e0}, "brain", 1, 22, []string{"brain", "intelligent", "smart"}, false, 0},
	{[]rune{0x1fac0}, "anatomical heart", 1, 22, []string{"anatomical", "beat", "cardiology", "heart", "heartbeat", "organ", "pulse", "real", "red"}, false, 0},
	{[]rune{0x1fac1}, "lungs", 1, 22, []string{"breath", "breathe", "exhalation", "inhalation", "lung", "lungs", "organ", "respiration"}, false, 0},
	{[]rune{0x1f9b7}, "tooth", 1, 22, []string{"dentist", "pearly", "teeth", "tooth", "white"}, false, 0},
	{[]rune{0x1f9b4}, "bone", 1, 22, []string{"bone", "bones", "dog", "skeleton", "wishbone"}, false, 0},
	{[]rune{0x1f440}, "eyes", 1, 22, []string{"body", "eye", "eyes", "face", "googly", "look", "looking", "omg", "peep", "see", "seeing"}, false, 0},
	{[]rune{0x1f441, 0xfe0f}, "eye", 1, 22, []string{"1", "body", "eye", "one"}, false, 0},
	{[]rune{0x1f445}, "tongue", 1, 22, []string{"body", "lick", "slurp", "tongue"}, false, 0},
	{[]rune{0x1f444}, "mouth", 1, 22, []string{"beauty", "body", "kiss", "kissing", "lips", "lipstick", "mouth"}, false, 0},
	{[]rune{0x1fae6}, "biting lip", 1, 22, []string{"anxious", "bite", "biting", "fear", "flirt", "flirting", "kiss", "lip", "lipstick", "nervous", "sexy", "uncomfortable", "worried", "worry"}, false, 0},
	{[]rune{0x1f476}, "baby", 1, 23, []string{"babies", "baby", "children", "goo", "infant", "newborn", "pregnant", "young"}, true, 0},
	{[]rune{0x1f9d2}, "child", 1, 23, []string{"bright-eyed", "child", "grandchild", "kid", "young", "younger"}, true, 0},
	{[]rune{0x1f466}, "boy", 1, 23, []string{"boy", "bright-eyed", "child", "grandson", "kid", "son", "young", "younger"}, true, 0},
	{[]rune{0x1f467}, "girl", 1, 23, []string{"bright-eyed", "child", "daughter", "girl", "granddaughter", "kid", "Virgo", "young", "younger", "zodiac"}, true, 0},
	{[]rune{0x1f9d1}, "person", 1, 23, []string{"adult", "person"}, true, 2},
	{[]rune{0x1f471}, "person: blond hair", 1, 23, []string{"blond", "blond-haired", "human", "person"}, true, 1},
	{[]rune{0x1f9d4}, "person: beard", 1, 23, []string{"beard", "bearded", "person", "whiskers"}, true, 1},
	{[]rune{0x1f9d1, 0x1f9b0}, "person: red hair", 1, 23, []string(nil), true, 2},
	{[]rune{0x1f9d1, 0x1f9b1}, "person: curly hair", 1, 23, []string(nil), true, 2},
	{[]rune{0x1f9d1, 0x1f9b3}, "person: white hair", 1, 23, []string(nil), true, 2},
	{[]rune{0x1f9d1, 0x1f9b2}, "person: bald", 1, 23, []string(nil), true, 2},
	{[]rune{0x1f9d3}, "older person", 1, 23, []string{"adult", "elderly", "grandparent", "old", "person", "wise"}, true, 0},
	{[]rune{0x1f474}, "old man", 1, 23, []string{"adult", "bald", "elderly", "gramps", "grandfather", "grandpa", "man", "old", "wise"}, true, 0},
	{[]rune{0x1f475}, "old woman", 1, 23, []string{"adult", "elderly", "grandma", "grandmother", "granny", "lady", "old", "wise", "woman"}, true, 0},
	{[]rune{0x1f64d}, "person frowning", 1, 24, []string{"annoyed", "disappointed", "disgruntled", "disturbed", "frown", "frowning", "frustrated", "gesture", "irritated", "person", "upset"}, true, 1},
	{[]rune{0x1f64e}, "person pouting", 1, 24, []string{"disappointed", "downtrodden", "frown", "grimace", "person", "pouting", "scowl", "sulk", "upset", "whine"}, true, 1},
	{[]rune{0x1f645}, "person gesturing NO", 1, 24, []string{"forbidden", "gesture", "hand", "NO", "not", "person", "prohibit"}, true, 1},
	{[]rune{0x1f646}, "person gesturing OK", 1, 24, []string{"exercise", "gesture", "gesturing", "hand", "OK", "omg", "person"}, true, 1},
	{[]rune{0x1f481}, "person tipping hand", 1, 24, []string{"fetch", "flick", "flip", "gossip", "hand", "person", "sarcasm", "sarcastic", "sassy", "seriously", "tipping", "whatever"}, true, 1},
	{[]rune{0x1f64b}, "person raising hand", 1, 24, []string{"gesture", "hand", "here", "know", "me", "person", "pick", "question", "raise", "raising"}, true, 1},
	{[]rune{0x1f9cf}, "deaf person", 1, 24, []string{"accessibility", "deaf", "ear", "gesture", "hear", "person"}, true, 1},
	{[]rune{0x1f647}, "person bowing", 1, 24, []string{"apology", "ask", "beg", "bow", "bowing", "favor", "forgive", "gesture", "meditate", "meditation", "person", "pity", "regret", "sorry"}, true, 1},
	{[]rune{0x1f926}, "person facepalming", 1, 24, []string{"again", "bewilder", "disbelief", "exasperation", "facepalm", "no", "not", "oh", "omg", "person", "shock", "smh"}, true, 1},
	{[]rune{0x1f937}, "person shrugging", 1, 24, []string{"doubt", "dunno", "guess", "idk", "ignorance", "indifference", "knows", "maybe", "person", "shrug", "shrugging", "whatever", "who"}, true, 1},
	{[]rune{0x1f9d1, 0x2695, 0xfe0f}, "health worker", 1, 25, []string{"doctor", "health", "healthcare", "nurse", "therapist", "worker"}, true, 2},
	{[]rune{0x1f9d1, 0x1f393}, "student", 1, 25, []string{"graduate", "student"}, true, 2},
	{[]rune{0x1f9d1, 0x1f3eb}, "teacher", 1, 25, []string{"instructor", "lecturer", "professor", "teacher"}, true, 2},
	{[]rune{0x1f9d1, 0x2696, 0xfe0f}, "judge", 1, 25, []string{"judge", "justice", "law", "scales"}, true, 2},
	{[]rune{0x1f9d1, 0x1f33e}, "farmer", 1, 25, []string{"farmer", "gardener", "rancher"}, true, 2},
	{[]rune{0x1f9d1, 0x1f373}, "cook", 1, 25, []string{"chef", "cook"}, true, 2},
	{[]rune{0x1f9d1, 0x1f527}, "mechanic", 1, 25, []string{"electrician", "mechanic", "plumber", "tradesperson"}, true, 2},
	{[]rune{0x1f9d1, 0x1f3ed}, "factory worker", 1, 25, []string{"assembly", "factory", "industrial", "worker"}, true, 2},
	{[]rune{0x1f9d1, 0x1f4bc}, "office worker", 1, 25, []string{"architect", "business", "manager", "office", "white-collar", "worker"}, true, 2},
	{[]rune{0x1f9d1, 0x1f52c}, "scientist", 1, 25, []string{"biologist", "chemist", "engineer", "mathematician", "physicist", "scientist"}, true, 2},
	{[]rune{0x1f9d1, 0x1f4bb}, "technologist", 1, 25, []string{"coder", "computer", "developer", "inventor", "software", "technologist"}, true, 2},
	{[]rune{0x1f9d1, 0x1f3a4}, "singer", 1, 25, []string{"actor", "entertainer", "rock", "rockstar", "singer", "star"}, true, 2},
	{[]rune{0x1f9d1, 0x1f3a8}, "artist", 1, 25, []string{"artist", "palette"}, true, 2},
	{[]rune{0x1f9d1, 0x2708, 0xfe0f}, "pilot", 1, 25, []string{"pilot", "plane"}, true, 2},
	{[]rune{0x1f9d1, 0x1f680}, "astronaut", 1, 25, []string{"astronaut", "rocket", "space"}, true, 2},
	{[]rune{0x1f9d1, 0x1f692}, "firefighter", 1, 25, []string{"fire", "firefighter", "firetruck"}, true, 2},
	{[]rune{0x1f46e}, "police officer", 1, 25, []string{"apprehend", "arrest", "citation", "cop", "law", "officer", "over", "police", "pulled", "undercover"}, true, 1},
	{[]rune{0x1f575, 0xfe0f}, "detective", 1, 25, []string{"detective", "sleuth", "spy"}, true, 1},
	{[]rune{0x1f482}, "guard", 1, 25, []string{"buckingham", "guard", "helmet", "london", "palace"}, true, 1},
	{[]rune{0x1f977}, "ninja", 1, 25, []string{"assassin", "fight", "fighter", "hidden", "ninja", "person", "secret", "skills", "sly", "soldier", "stealth", "war"}, true, 0},
	{[]rune{0x1f477}, "construction worker", 1, 25, []string{"build", "construction", "fix", "hardhat", "hat", "man", "person", "rebuild", "remodel", "repair", "work", "worker"}, true, 1},
	{[]rune{0x1fac5}, "person with crown", 1, 25, []string{"crown", "monarch", "noble", "person", "regal", "royal", "royalty"}, true, 0},
	{[]rune{0x1f934}, "prince", 1, 25, []string{"crown", "fairy", "fairytale", "fantasy", "king", "prince", "royal", "royalty", "tale"}, true, 0},
	{[]rune{0x1f478}, "princess", 1, 25, []string{"crown", "fairy", "fairytale", "fantasy", "princess", "queen", "royal", "royalty", "tale"}, true, 0},
	{[]rune{0x1f473}, "person wearing turban", 1, 25, []string{"person", "turban", "wearing"}, true, 1},
	{[]rune{0x1f472}, "person with skullcap", 1, 25, []string{"cap", "Chinese", "gua", "guapi", "hat", "mao", "person", "pi", "skullcap"}, true, 0},
	{[]rune{0x1f9d5}, "woman with headscarf", 1, 25, []string{"bandana", "head", "headscarf", "hijab", "kerchief", "mantilla", "tichel", "woman"}, true, 0},
	{[]rune{0x1f935}, "person in tuxedo", 1, 25, []string{"formal", "person", "tuxedo", "wedding"}, true, 1},
	{[]rune{0x1f470}, "person with veil", 1, 25, []string{"person", "veil", "wedding"}, true, 1},
	{[]rune{0x1f930}, "pregnant woman", 1, 25, []string{"pregnant", "woman"}, true, 0},
	{[]rune{0x1fac3}, "pregnant man", 1, 25, []string{"belly", "bloated", "full", "man", "overeat", "pregnant"}, true, 0},
	{[]rune{0x1fac4}, "pregnant person", 1, 25, []string{"belly", "bloated", "full", "overeat", "person", "pregnant", "stuffed"}, true, 0},
	{[]rune{0x1f931}, "breast-feeding", 1, 25, []string{"baby", "breast", "breast-feeding", "feeding", "mom", "mother", "nursing", "woman"}, true, 0},
	{[]rune{0x1f9d1, 0x1f37c}, "person feeding baby", 1, 25, []string{"baby", "feed", "feeding", "nanny", "newborn", "nursing", "parent"}, true, 2},
	{[]rune{0x1f47c}, "baby angel", 1, 26, []string{"angel", "baby", "church", "face", "fairy", "fairytale", "fantasy", "tale"}, true, 0},
	{[]rune{0x1f385}, "Santa Claus", 1, 26, []string{"celebration", "Christmas", "claus", "fairy", "fantasy", "father", "holiday", "merry", "santa", "tale", "xmas"}, true, 0},
	{[]rune{0x1f936}, "Mrs. Claus", 1, 26, []string{"celebration", "Christmas", "claus", "fairy", "fantasy", "holiday", "merry", "mother", "Mrs", "santa", "tale", "xmas"}, true, 0},
	{[]rune{0x1f9d1, 0x1f384}, "Mx Claus", 1, 26, []string{"celebration", "Christmas", "claus", "fairy", "fantasy", "holiday", "merry", "Mx", "santa", "tale", "xmas"}, true, 2},
	{[]rune{0x1f9b8}, "superhero", 1, 26, []string{"good", "hero", "superhero", "superpower"}, true, 1},
	{[]rune{0x1f9b9}, "supervillain", 1, 26, []string{"bad", "criminal", "evil", "superpower", "supervillain", "villain"}, true, 1},
	{[]rune{0x1f9d9}, "mage", 1, 26, []string{"fantasy", "mage", "magic", "play", "sorcerer", "sorceress", "sorcery", "spell", "summon", "witch", "wizard"}, true, 1},
	{[]rune{0x1f9da}, "fairy", 1, 26, []string{"fairy", "fairytale", "fantasy", "myth", "person", "pixie", "tale", "wings"}, true, 1},
	{[]rune{0x1f9db}, "vampire", 1, 26, []string{"blood", "Dracula", "fangs", "halloween", "scary", "supernatural", "teeth", "undead", "vampire"}, true, 1},
	{[]rune{0x1f9dc}, "merperson", 1, 26, []string{"creature", "fairytale", "folklore", "merperson", "ocean", "sea", "siren", "trident"}, true, 1},
	{[]rune{0x1f9dd}, "elf", 1, 26, []string{"elf", "elves", "enchantment", "fantasy", "folklore", "magic", "magical", "myth"}, true, 1},
	{[]rune{0x1f9de}, "genie", 1, 26, []string{"djinn", "fantasy", "genie", "jinn", "lamp", "myth", "rub", "wishes"}, false, 1},
	{[]rune{0x1f9df}, "zombie", 1, 26, []string{"apocalypse", "dead", "halloween", "horror", "scary", "undead", "walking", "zombie"}, false, 1},
	{[]rune{0x1f9cc}, "troll", 1, 26, []string{"fairy", "fantasy", "monster", "tale", "troll", "trolling"}, false, 0},
	{[]rune{0x1fac8}, "hairy creature", 1, 26, []string{"bigfoot", "cryptid", "forest", "giant", "hairy", "sasquatch", "woodwose", "yeti"}, false, 0},
	{[]rune{0x1f486}, "person getting massage", 1, 27, []string{"face", "getting", "headache", "massage", "person", "relax", "relaxing", "salon", "soothe", "spa", "tension", "therapy", "treatment"}, true, 1},
	{[]rune{0x1f487}, "person getting haircut", 1, 27, []string{"barber", "beauty", "chop", "cosmetology", "cut", "groom", "hair", "haircut", "parlor", "person", "shears", "style"}, true, 1},
	{[]rune{0x1f6b6}, "person walking", 1, 27, []string{"amble", "gait", "hike", "man", "pace", "pedestrian", "person", "stride", "stroll", "walk", "walking"}, true, 1},
	{[]rune{0x1f6b6, 0x27a1, 0xfe0f}, "person walking facing right", 1, 27, []string(nil), true, 0},
	{[]rune{0x1f9cd}, "person standing", 1, 27, []string{"person", "stand", "standing"}, true, 1},
	{[]rune{0x1f9ce}, "person kneeling", 1, 27, []string{"kneel", "kneeling", "knees", "person"}, true, 1},
	{[]rune{0x1f9ce, 0x27a1, 0xfe0f}, "person kneeling facing right", 1, 27, []string(nil), true, 0},
	{[]rune{0x1f9d1, 0x1f9af}, "person with white cane", 1, 27, []string{"accessibility", "blind", "cane", "person", "probing", "white"}, true, 2},
	{[]rune{0x1f9d1, 0x1f9af, 0x27a1, 0xfe0f}, "person with white cane facing right", 1, 27, []string(nil), true, 2},
	{[]rune{0x1f9d1, 0x1f9bc}, "person in motorized wheelchair", 1, 27, []string{"accessibility", "motorized", "person", "wheelchair"}, true, 2},
	{[]rune{0x1f9d1, 0x1f9bc, 0x27a1, 0xfe0f}, "person in motorized wheelchair facing right", 1, 27, []string(nil), true, 2},
	{[]rune{0x1f9d1, 0x1f9bd}, "person in manual wheelchair", 1, 27, []string{"accessibility", "manual", "person", "wheelchair"}, true, 2},
	{[]rune{0x1f9d1, 0x1f9bd, 0x27a1, 0xfe0f}, "person in manual wheelchair facing right", 1, 27, []string(nil), true, 2},
	{[]rune{0x1f3c3}, "person running", 1, 27, []string{"fast", "hurry", "marathon", "move", "person", "quick", "race", "racing", "run", "rush", "speed"}, true, 1},
	{[]rune{0x1f3c3, 0x27a1, 0xfe0f}, "person running facing right", 1, 27, []string(nil), true, 0},
	{[]rune{0x1f9d1, 0x1fa70}, "ballet dancer", 1, 27, []string{"ballet", "dancer"}, true, 2},
	{[]rune{0x1f483}, "woman dancing", 1, 27, []string{"dance", "dancer", "dancing", "elegant", "festive", "flair", "flamenco", "groove", "let’s", "salsa", "tango", "woman"}, true, 0},
	{[]rune{0x1f57a}, "man dancing", 1, 27, []string{"dance", "dancer", "dancing", "elegant", "festive", "flair", "flamenco", "groove", "let’s", "man", "salsa", "tango"}, true, 0},
	{[]rune{0x1f574, 0xfe0f}, "person in suit levitating", 1, 27, []string{"business", "levitating", "person", "suit"}, true, 0},
	{[]rune{0x1f46f}, "people with bunny ears", 1, 27, []string{"bestie", "bff", "bunny", "counterpart", "dancer", "double", "ear", "identical", "pair", "party", "partying", "people", "soulmate", "twin", "twinsies"}, true, 1},
	{[]rune{0x1f9d6}, "person in steamy room", 1, 27, []string{"day", "luxurious", "pamper", "person", "relax", "room", "sauna", "spa", "steam", "steambath", "unwind"}, true, 1},
	{[]rune{0x1f9d7}, "person climbing", 1, 27, []string{"climb", "climber", "climbing", "mountain", "person", "rock", "scale", "up"}, true, 1},
	{[]rune{0x1f93a}, "person fencing", 1, 28, []string{"fencer", "fencing", "person", "sword"}, false, 0},
	{[]rune{0x1f3c7}, "horse racing", 1, 28, []string{"horse", "jockey", "racehorse", "racing", "riding", "sport"}, true, 0},
	{[]rune{0x26f7, 0xfe0f}, "skier", 1, 28, []string{"ski", "skier", "snow"}, false, 0},
	{[]rune{0x1f3c2}, "snowboarder", 1, 28, []string{"ski", "snow", "snowboard", "snowboarder", "sport"}, true, 0},
	{[]rune{0x1f3cc, 0xfe0f}, "person golfing", 1, 28, []string{"ball", "birdie", "caddy", "driving", "golf", "golfing", "green", "person", "pga", "putt", "range", "tee"}, true, 1},
	{[]rune{0x1f3c4}, "person surfing", 1, 28, []string{"beach", "ocean", "person", "sport", "surf", "surfer", "surfing", "swell", "waves"}, true, 1},
	{[]rune{0x1f6a3}, "person rowing boat", 1, 28, []string{"boat", "canoe", "cruise", "fishing", "lake", "oar", "paddle", "person", "raft", "river", "row", "rowboat", "rowing"}, true, 1},
	{[]rune{0x1f3ca}, "person swimming", 1, 28, []string{"freestyle", "person", "sport", "swim", "swimmer", "swimming", "triathlon"}, true, 1},
	{[]rune{0x26f9, 0xfe0f}, "person bouncing ball", 1, 28, []string{"athletic", "ball", "basketball", "bouncing", "championship", "dribble", "net", "person", "player", "throw"}, true, 1},
	{[]rune{0x1f3cb, 0xfe0f}, "person lifting weights", 1, 28, []string{"barbell", "bodybuilder", "deadlift", "lifter", "lifting", "person", "powerlifting", "weight", "weightlifter", "weights", "workout"}, true, 1},
	{[]rune{0x1f6b4}, "person biking", 1, 28, []string{"bicycle", "bicyclist", "bike", "biking", "cycle", "cyclist", "person", "riding", "sport"}, true, 1},
	{[]rune{0x1f6b5}, "person mountain biking", 1, 28, []string{"bicycle", "bicyclist", "bike", "biking", "cycle", "cyclist", "mountain", "person", "riding", "sport"}, true, 1},
	{[]rune{0x1f938}, "person cartwheeling", 1, 28, []string{"active", "cartwheel", "cartwheeling", "excited", "flip", "gymnastics", "happy", "person", "somersault"}, true, 1},
	{[]rune{0x1f93c}, "people wrestling", 1, 28, []string{"combat", "duel", "grapple", "people", "ring", "tournament", "wrestle", "wrestling"}, true, 1},
	{[]rune{0x1f93d}, "person playing water polo", 1, 28, []string{"person", "playing", "polo", "sport", "swimming", "water", "waterpolo"}, true, 1},
	{[]rune{0x1f93e}, "person playing handball", 1, 28, []string{"athletics", "ball", "catch", "chuck", "handball", "hurl", "lob", "person", "pitch", "playing", "sport", "throw", "toss"}, true, 1},
	{[]rune{0x1f939}, "person juggling", 1, 28, []string{"act", "balance", "balancing", "handle", "juggle", "juggling", "manage", "multitask", "person", "skill"}, true, 1},
	{[]rune{0x1f9d8}, "person in lotus position", 1, 29, []string{"cross", "legged", "legs", "lotus", "meditation", "peace", "person", "position", "relax", "serenity", "yoga", "yogi", "zen"}, true, 1},
	{[]rune{0x1f6c0}, "person taking bath", 1, 29, []string{"bath", "bathtub", "person", "taking", "tub"}, true, 0},
	{[]rune{0x1f6cc}, "person in bed", 1, 29, []string{"bed", "bedtime", "good", "goodnight", "hotel", "nap", "night", "person", "sleep", "tired", "zzz"}, true, 0},
	{[]rune{0x1f9d1, 0x1f91d, 0x1f9d1}, "people holding hands", 1, 30, []string{"bae", "bestie", "bff", "couple", "dating", "flirt", "friends", "hand", "hold", "people", "twins"}, true, 2},
	{[]rune{0x1f46d}, "women holding hands", 1, 30, []string{"bae", "bestie", "bff", "couple", "dating", "flirt", "friends", "girls", "hand", "hold", "sisters", "twins", "women"}, true, 0},
	{[]rune{0x1f46b}, "woman and man holding hands", 1, 30, []string{"bae", "bestie", "bff", "couple", "dating", "flirt", "friends", "hand", "hold", "man", "twins", "woman"}, true, 0},
	{[]rune{0x1f46c}, "men holding hands", 1, 30, []string{"bae", "bestie", "bff", "boys", "brothers", "couple", "dating", "flirt", "friends", "hand", "hold", "men", "twins"}, true, 0},
	{[]rune{0x1f48f}, "kiss", 1, 30, []string{"anniversary", "babe", "bae", "couple", "date", "dating", "heart", "kiss", "love", "mwah", "person", "romance", "together", "xoxo"}, true, 0},
	{[]rune{0x1f491}, "couple with heart", 1, 30, []string{"anniversary", "babe", "bae", "couple", "dating", "heart", "kiss", "love", "person", "relationship", "romance", "together", "you"}, true, 0},
	{[]rune{0x1f5e3, 0xfe0f}, "speaking head", 1, 31, []string{"face", "head", "silhouette", "speak", "speaking"}, false, 0},
	{[]rune{0x1f464}, "bust in silhouette", 1, 31, []string{"bust", "mysterious", "shadow", "silhouette"}, false, 0},
	{[]rune{0x1f465}, "busts in silhouette", 1, 31, []string{"bff", "bust", "busts", "everyone", "friend", "friends", "people", "silhouette"}, false, 0},
	{[]rune{0x1fac2}, "people hugging", 1, 31, []string{"comfort", "embrace", "farewell", "friendship", "goodbye", "hello", "hug", "hugging", "love", "people", "thanks"}, false, 0},
	{[]rune{0x1f46a}, "family", 1, 31, []string{"child", "family"}, false, 0},
	{[]rune{0x1f9d1, 0x1f9d1, 0x1f9d2}, "family: adult, adult, child", 1, 31, []string{"adult", "child", "family"}, false, 2},
	{[]rune{0x1f9d1, 0x1f9d1, 0x1f9d2, 0x1f9d2}, "family: adult, adult, child, child", 1, 31, []string{"adult", "child", "family"}, false, 2},
	{[]rune{0x1f9d1, 0x1f9d2}, "family: adult, child", 1, 31, []string{"adult", "child", "family"}, false, 2},
	{[]rune{0x1f9d1, 0x1f9d2, 0x1f9d2}, "family: adult, child, child", 1, 31, []string{"adult", "child", "family"}, false, 2},
	{[]rune{0x1f463}, "footprints", 1, 31, []string{"barefoot", "clothing", "footprint", "footprints", "omw", "print", "walk"}, false, 0},
	{[]rune{0x1fac6}, "fingerprint", 1, 31, []string{"clue", "crime", "detective", "fingerprint", "forensics", "identity", "mystery", "print", "safety", "trace"}, false, 0},
	{[]rune{0x1f435}, "monkey face", 3, 34, []string{"animal", "banana", "face", "monkey"}, false, 0},
	{[]rune{0x1f412}, "monkey", 3, 34, []string{"animal", "banana", "monkey"}, false, 0},
	{[]rune{0x1f98d}, "gorilla", 3, 34, []string{"animal", "gorilla"}, false, 0},
	{[]rune{0x1f9a7}, "orangutan", 3, 34, []string{"animal", "ape", "monkey", "orangutan"}, false, 0},
	{[]rune{0x1f436}, "dog face", 3, 34, []string{"adorbs", "animal", "dog", "face", "pet", "puppies", "puppy"}, false, 0},
	{[]rune{0x1f415}, "dog", 3, 34, []string{"animal", "animals", "dog", "dogs", "pet"}, false, 0},
	{[]rune{0x1f9ae}, "guide dog", 3, 34, []string{"accessibility", "animal", "blind", "dog", "guide"}, false, 0},
	{[]rune{0x1f415, 0x1f9ba}, "service dog", 3, 34, []string{"accessibility", "animal", "assistance", "dog", "service"}, false, 0},
	{[]rune{0x1f429}, "poodle", 3, 34, []string{"animal", "dog", "fluffy", "poodle"}, false, 0},
	{[]rune{0x1f43a}, "wolf", 3, 34, []string{"animal", "face", "wolf"}, false, 0},
	{[]rune{0x1f98a}, "fox", 3, 34, []string{"animal", "face", "fox"}, false, 0},
	{[]rune{0x1f99d}, "raccoon", 3, 34, []string{"animal", "curious", "raccoon", "sly"}, false, 0},
	{[]rune{0x1f431}, "cat face", 3, 34, []string{"animal", "cat", "face", "kitten", "kitty", "pet"}, false, 0},
	{[]rune{0x1f408}, "cat", 3, 34, []string{"animal", "animals", "cat", "cats", "kitten", "pet"}, false, 0},
	{[]rune{0x1f408, 0x2b1b}, "black cat", 3, 34, []string{"animal", "black", "cat", "feline", "halloween", "meow", "unlucky"}, false, 0},
	{[]rune{0x1f981}, "lion", 3, 34, []string{"alpha", "animal", "face", "Leo", "lion", "mane", "order", "rawr", "roar", "safari", "strong", "zodiac"}, false, 0},
	{[]rune{0x1f42f}, "tiger face", 3, 34, []string{"animal", "big", "cat", "face", "predator", "tiger"}, false, 0},
	{[]rune{0x1f405}, "tiger", 3, 34, []string{"animal", "big", "cat", "predator", "tiger", "zoo"}, false, 0},
	{[]rune{0x1f406}, "leopard", 3, 34, []string{"animal", "big", "cat", "leopard", "predator", "zoo"}, false, 0},
	{[]rune{0x1f434}, "horse face", 3, 34, []string{"animal", "dressage", "equine", "face", "farm", "horse", "horses"}, false, 0},
	{[]rune{0x1face}, "moose", 3, 34, []string{"alces", "animal", "antlers", "elk", "mammal", "moose"}, false, 0},
	{[]rune{0x1facf}, "donkey", 3, 34, []string{"animal", "ass", "burro", "donkey", "hinny", "mammal", "mule", "stubborn"}, false, 0},
	{[]rune{0x1f40e}, "horse", 3, 34, []string{"animal", "equestrian", "farm", "horse", "racehorse", "racing"}, false, 0},
	{[]rune{0x1f984}, "unicorn", 3, 34, []string{"face", "unicorn"}, false, 0},
	{[]rune{0x1f993}, "zebra", 3, 34, []string{"animal", "stripe", "zebra"}, false, 0},
	{[]rune{0x1f98c}, "deer", 3, 34, []string{"animal", "deer"}, false, 0},
	{[]rune{0x1f9ac}, "bison", 3, 34, []string{"animal", "bison", "buffalo", "herd", "wisent"}, false, 0},
	{[]rune{0x1f42e}, "cow face", 3, 34, []string{"animal", "cow", "face", "farm", "milk", "moo"}, false, 0},
	{[]rune{0x1f402}, "ox", 3, 34, []string{"animal", "animals", "bull", "farm", "ox", "Taurus", "zodiac"}, false, 0},
	{[]rune{0x1f403}, "water buffalo", 3, 34, []string{"animal", "buffalo", "water", "zoo"}, false, 0},
	{[]rune{0x1f404}, "cow", 3, 34, []string{"animal", "animals", "cow", "farm", "milk", "moo"}, false, 0},
	{[]rune{0x1f437}, "pig face", 3, 34, []string{"animal", "bacon", "face", "farm", "pig", "pork"}, false, 0},
	{[]rune{0x1f416}, "pig", 3, 34, []string{"animal", "bacon", "farm", "pig", "pork", "sow"}, false, 0},
	{[]rune{0x1f417}, "boar", 3, 34, []string{"animal", "boar", "pig"}, false, 0},
	{[]rune{0x1f43d}, "pig nose", 3, 34, []string{"animal", "face", "farm", "nose", "pig", "smell", "snout"}, false, 0},
	{[]rune{0x1f40f}, "ram", 3, 34, []string{"animal", "Aries", "horns", "male", "ram", "sheep", "zodiac", "zoo"}, false, 0},
	{[]rune{0x1f411}, "ewe", 3, 34, []string{"animal", "baa", "ewe", "farm", "female", "fluffy", "lamb", "sheep", "wool"}, false, 0},
	{[]rune{0x1f410}, "goat", 3, 34, []string{"animal", "Capricorn", "farm", "goat", "milk", "zodiac"}, false, 0},
	{[]rune{0x1f42a}, "camel", 3, 34, []string{"animal", "camel", "desert", "dromedary", "hump", "one"}, false, 0},
	{[]rune{0x1f42b}, "two-hump camel", 3, 34, []string{"animal", "bactrian", "camel", "desert", "hump", "two", "two-hump"}, false, 0},
	{[]rune{0x1f999}, "llama", 3, 34, []string{"alpaca", "animal", "guanaco", "llama", "vicuña", "wool"}, false, 0},
	{[]rune{0x1f992}, "giraffe", 3, 34, []string{"animal", "giraffe", "spots"}, false, 0},
	{[]rune{0x1f418}, "elephant", 3, 34, []string{"animal", "elephant"}, false, 0},
	{[]rune{0x1f9a3}, "mammoth", 3, 34, []string{"animal", "extinction", "large", "mammoth", "tusk", "wooly"}, false, 0},
	{[]rune{0x1f98f}, "rhinoceros", 3, 34, []string{"animal", "rhinoceros"}, false, 0},
	{[]rune{0x1f99b}, "hippopotamus", 3, 34, []string{"animal", "hippo", "hippopotamus"}, false, 0},
	{[]rune{0x1f42d}, "mouse face", 3, 34, []string{"animal", "face", "mouse"}, false, 0},
	{[]rune{0x1f401}, "mouse", 3, 34, []string{"animal", "animals", "mouse"}, false, 0},
	{[]rune{0x1f400}, "rat", 3, 34, []string{"animal", "rat"}, false, 0},
	{[]rune{0x1f439}, "hamster", 3, 34, []string{"animal", "face", "hamster", "pet"}, false, 0},
	{[]rune{0x1f430}, "rabbit face", 3, 34, []string{"animal", "bunny", "face", "pet", "rabbit"}, false, 0},
	{[]rune{0x1f407}, "rabbit", 3, 34, []string{"animal", "bunny", "pet", "rabbit"}, false, 0},
	{[]rune{0x1f43f, 0xfe0f}, "chipmunk", 3, 34, []string{"animal", "chipmunk", "squirrel"}, false, 0},
	{[]rune{0x1f9ab}, "beaver", 3, 34, []string{"animal", "beaver", "dam", "teeth"}, false, 0},
	{[]rune{0x1f994}, "hedgehog", 3, 34, []string{"animal", "hedgehog", "spiny"}, false, 0},
	{[]rune{0x1f987}, "bat", 3, 34, []string{"animal", "bat", "vampire"}, false, 0},
	{[]rune{0x1f43b}, "bear", 3, 34, []string{"animal", "bear", "face", "grizzly", "growl", "honey"}, false, 0},
	{[]rune{0x1f43b, 0x2744, 0xfe0f}, "polar bear", 3, 34, []string{"animal", "arctic", "bear", "polar", "white"}, false, 0},
	{[]rune{0x1f428}, "koala", 3, 34, []string{"animal", "australia", "bear", "down", "face", "koala", "marsupial", "under"}, false, 0},
	{[]rune{0x1f43c}, "panda", 3, 34, []string{"animal", "bamboo", "face", "panda"}, false, 0},
	{[]rune{0x1f9a5}, "sloth", 3, 34, []string{"lazy", "sloth", "slow"}, false, 0},
	{[]rune{0x1f9a6}, "otter", 3, 34, []string{"animal", "fishing", "otter", "playful"}, false, 0},
	{[]rune{0x1f9a8}, "skunk", 3, 34, []string{"animal", "skunk", "stink"}, false, 0},
	{[]rune{0x1f998}, "kangaroo", 3, 34, []string{"animal", "joey", "jump", "kangaroo", "marsupial"}, false, 0},
	{[]rune{0x1f9a1}, "badger", 3, 34, []string{"animal", "badger", "honey", "pester"}, false, 0},
	{[]rune{0x1f43e}, "paw prints", 3, 34, []string{"feet", "paw", "paws", "print", "prints"}, false, 0},
	{[]rune{0x1f983}, "turkey", 3, 35, []string{"bird", "gobble", "thanksgiving", "turkey"}, false, 0},
	{[]rune{0x1f414}, "chicken", 3, 35, []string{"animal", "bird", "chicken", "ornithology"}, false, 0},
	{[]rune{0x1f413}, "rooster", 3, 35, []string{"animal", "bird", "ornithology", "rooster"}, false, 0},
	{[]rune{0x1f423}, "hatching chick", 3, 35, []string{"animal", "baby", "bird", "chick", "egg", "hatching"}, false, 0},
	{[]rune{0x1f424}, "baby chick", 3, 35, []string{"animal", "baby", "bird", "chick", "ornithology"}, false, 0},
	{[]rune{0x1f425}, "front-facing baby chick", 3, 35, []string{"animal", "baby", "bird", "chick", "front-facing", "newborn", "ornithology"}, false, 0},
	{[]rune{0x1f426}, "bird", 3, 35, []string{"animal", "bird", "ornithology"}, false, 0},
	{[]rune{0x1f427}, "penguin", 3, 35, []string{"animal", "antarctica", "bird", "ornithology", "penguin"}, false, 0},
	{[]rune{0x1f54a, 0xfe0f}, "dove", 3, 35, []string{"bird", "dove", "fly", "ornithology", "peace"}, false, 0},
	{[]rune{0x1f985}, "eagle", 3, 35, []string{"animal", "bird", "eagle", "ornithology"}, false, 0},
	{[]rune{0x1f986}, "duck", 3, 35, []string{"animal", "bird", "duck", "ornithology"}, false, 0},
	{[]rune{0x1f9a2}, "swan", 3, 35, []string{"animal", "bird", "cygnet", "duckling", "ornithology", "swan", "ugly"}, false, 0},
	{[]rune{0x1f989}, "owl", 3, 35, []string{"animal", "bird", "ornithology", "owl", "wise"}, false, 0},
	{[]rune{0x1f9a4}, "dodo", 3, 35, []string{"animal", "bird", "dodo", "extinction", "large", "ornithology"}, false, 0},
	{[]rune{0x1fab6}, "feather", 3, 35, []string{"bird", "feather", "flight", "light", "plumage"}, false, 0},
	{[]rune{0x1f9a9}, "flamingo", 3, 35, []string{"animal", "bird", "flamboyant", "flamingo", "ornithology", "tropical"}, false, 0},
	{[]rune{0x1f99a}, "peacock", 3, 35, []string{"animal", "bird", "colorful", "ornithology", "ostentatious", "peacock", "peahen", "pretty", "proud"}, false, 0},
	{[]rune{0x1f99c}, "parrot", 3, 35, []string{"animal", "bird", "ornithology", "parrot", "pirate", "talk"}, false, 0},
	{[]rune{0x1fabd}, "wing", 3, 35, []string{"angelic", "ascend", "aviation", "bird", "fly", "flying", "heavenly", "mythology", "soar", "wing"}, false, 0},
	{[]rune{0x1f426, 0x2b1b}, "black bird", 3, 35, []string{"animal", "beak", "bird", "black", "caw", "corvid", "crow", "ornithology", "raven", "rook"}, false, 0},
	{[]rune{0x1fabf}, "goose", 3, 35, []string{"animal", "bird", "duck", "flock", "fowl", "gaggle", "gander", "geese", "goose", "honk", "ornithology", "silly"}, false, 0},
	{[]rune{0x1f426, 0x1f525}, "phoenix", 3, 35, []string{"ascend", "ascension", "emerge", "fantasy", "firebird", "glory", "immortal", "phoenix", "rebirth", "reincarnation", "reinvent", "renewal", "revival", "revive", "rise", "transform"}, false, 0},
	{[]rune{0x1f438}, "frog", 3, 36, []string{"animal", "face", "frog"}, false, 0},
	{[]rune{0x1f40a}, "crocodile", 3, 37, []string{"animal", "crocodile", "zoo"}, false, 0},
	{[]rune{0x1f422}, "turtle", 3, 37, []string{"animal", "terrapin", "tortoise", "turtle"}, false, 0},
	{[]rune{0x1f98e}, "lizard", 3, 37, []string{"animal", "lizard", "reptile"}, false, 0},
	{[]rune{0x1f40d}, "snake", 3, 37, []string{"animal", "bearer", "Ophiuchus", "serpent", "snake", "zodiac"}, false, 0},
	{[]rune{0x1f432}, "dragon face", 3, 37, []string{"animal", "dragon", "face", "fairy", "fairytale", "tale"}, false, 0},
	{[]rune{0x1f409}, "dragon", 3, 37, []string{"animal", "dragon", "fairy", "fairytale", "knights", "tale"}, false, 0},
	{[]rune{0x1f995}, "sauropod", 3, 37, []string{"brachiosaurus", "brontosaurus", "dinosaur", "diplodocus", "sauropod"}, false, 0},
	{[]rune{0x1f996}, "T-Rex", 3, 37, []string{"dinosaur", "Rex", "T", "T-Rex", "Tyrannosaurus"}, false, 0},
	{[]rune{0x1f433}, "spouting whale", 3, 38, []string{"animal", "beach", "face", "ocean", "spouting", "whale"}, false, 0},
	{[]rune{0x1f40b}, "whale", 3, 38, []string{"animal", "beach", "ocean", "whale"}, false, 0},
	{[]rune{0x1f42c}, "dolphin", 3, 38, []string{"animal", "beach", "dolphin", "flipper", "ocean"}, false, 0},
	{[]rune{0x1facd}, "orca", 3, 38, []string{"marine", "ocean", "whale"}, false, 0},
	{[]rune{0x1f9ad}, "seal", 3, 38, []string{"animal", "lion", "ocean", "sea", "seal"}, false, 0},
	{[]rune{0x1f41f}, "fish", 3, 38, []string{"animal", "dinner", "fish", "fishes", "fishing", "Pisces", "zodiac"}, false, 0},
	{[]rune{0x1f420}, "tropical fish", 3, 38, []string{"animal", "fish", "fishes", "tropical"}, false, 0},
	{[]rune{0x1f421}, "blowfish", 3, 38, []string{"animal", "blowfish", "fish"}, false, 0},
	{[]rune{0x1f988}, "shark", 3, 38, []string{"animal", "fish", "shark"}, false, 0},
	{[]rune{0x1f419}, "octopus", 3, 38, []string{"animal", "creature", "ocean", "octopus"}, false, 0},
	{[]rune{0x1f41a}, "spiral shell", 3, 38, []string{"animal", "beach", "conch", "sea", "shell", "spiral"}, false, 0},
	{[]rune{0x1fab8}, "coral", 3, 38, []string{"change", "climate", "coral", "ocean", "reef", "sea"}, false, 0},
	{[]rune{0x1fabc}, "jellyfish", 3, 38, []string{"animal", "aquarium", "burn", "invertebrate", "jelly", "jellyfish", "life", "marine", "ocean", "ouch", "plankton", "sea", "sting", "stinger", "tentacles"}, false, 0},
	{[]rune{0x1f980}, "crab", 3, 38, []string{"Cancer", "crab", "zodiac"}, false, 0},
	{[]rune{0x1f99e}, "lobster", 3, 38, []string{"animal", "bisque", "claws", "lobster", "seafood"}, false, 0},
	{[]rune{0x1f990}, "shrimp", 3, 38, []string{"food", "shellfish", "shrimp", "small"}, false, 0},
	{[]rune{0x1f991}, "squid", 3, 38, []string{"animal", "food", "mollusk", "squid"}, false, 0},
	{[]rune{0x1f9aa}, "oyster", 3, 38, []string{"diving", "oyster", "pearl"}, false, 0},
	{[]rune{0x1f40c}, "snail", 3, 39, []string{"animal", "escargot", "garden", "nature", "slug", "snail"}, false, 0},
	{[]rune{0x1f98b}, "butterfly", 3, 39, []string{"butterfly", "insect", "pretty"}, false, 0},
	{[]rune{0x1f41b}, "bug", 3, 39, []string{"animal", "bug", "garden", "insect"}, false, 0},
	{[]rune{0x1f41c}, "ant", 3, 39, []string{"animal", "ant", "garden", "insect"}, false, 0},
	{[]rune{0x1f41d}, "honeybee", 3, 39, []string{"animal", "bee", "bumblebee", "honey", "honeybee", "insect", "nature", "spring"}, false, 0},
	{[]rune{0x1fab2}, "beetle", 3, 39, []string{"animal", "beetle", "bug", "insect"}, false, 0},
	{[]rune{0x1f41e}, "lady beetle", 3, 39, []string{"animal", "beetle", "garden", "insect", "lady", "ladybird", "ladybug", "nature"}, false, 0},
	{[]rune{0x1f997}, "cricket", 3, 39, []string{"animal", "bug", "cricket", "grasshopper", "insect", "Orthoptera"}, false, 0},
	{[]rune{0x1fab3}, "cockroach", 3, 39, []string{"animal", "cockroach", "insect", "pest", "roach"}, false, 0},
	{[]rune{0x1f577, 0xfe0f}, "spider", 3, 39, []string{"animal", "insect", "spider"}, false, 0},
	{[]rune{0x1f578, 0xfe0f}, "spider web", 3, 39, []string{"spider", "web"}, false, 0},
	{[]rune{0x1f982}, "scorpion", 3, 39, []string{"Scorpio", "scorpion", "Scorpius", "zodiac"}, false, 0},
	{[]rune{0x1f99f}, "mosquito", 3, 39, []string{"bite", "disease", "fever", "insect", "malaria", "mosquito", "pest", "virus"}, false, 0},
	{[]rune{0x1fab0}, "fly", 3, 39, []string{"animal", "disease", "fly", "insect", "maggot", "pest", "rotting"}, false, 0},
	{[]rune{0x1fab1}, "worm", 3, 39, []string{"animal", "annelid", "earthworm", "parasite", "worm"}, false, 0},
	{[]rune{0x1f9a0}, "microbe", 3, 39, []string{"amoeba", "bacteria", "microbe", "science", "virus"}, false, 0},
	{[]rune{0x1f490}, "bouquet", 3, 40, []string{"anniversary", "birthday", "bouquet", "date", "flower", "love", "plant", "romance"}, false, 0},
	{[]rune{0x1f338}, "cherry blossom", 3, 40, []string{"blossom", "cherry", "flower", "plant", "spring", "springtime"}, false, 0},
	{[]rune{0x1f4ae}, "white flower", 3, 40, []string{"flower", "white"}, false, 0},
	{[]rune{0x1fab7}, "lotus", 3, 40, []string{"beauty", "Buddhism", "calm", "flower", "Hinduism", "lotus", "peace", "purity", "serenity"}, false, 0},
	{[]rune{0x1f3f5, 0xfe0f}, "rosette", 3, 40, []string{"plant", "rosette"}, false, 0},
	{[]rune{0x1f339}, "rose", 3, 40, []string{"beauty", "elegant", "flower", "love", "plant", "red", "rose", "valentine"}, false, 0},
	{[]rune{0x1f940}, "wilted flower", 3, 40, []string{"dying", "flower", "wilted"}, false, 0},
	{[]rune{0x1f33a}, "hibiscus", 3, 40, []string{"flower", "hibiscus", "plant"}, false, 0},
	{[]rune{0x1f33b}, "sunflower", 3, 40, []string{"flower", "outdoors", "plant", "sun", "sunflower"}, false, 0},
	{[]rune{0x1f33c}, "blossom", 3, 40, []string{"blossom", "buttercup", "dandelion", "flower", "plant"}, false, 0},
	{[]rune{0x1f337}, "tulip", 3, 40, []string{"blossom", "flower", "growth", "plant", "tulip"}, false, 0},
	{[]rune{0x1fabb}, "hyacinth", 3, 40, []string{"bloom", "bluebonnet", "flower", "hyacinth", "indigo", "lavender", "lilac", "lupine", "plant", "purple", "shrub", "snapdragon", "spring", "violet"}, false, 0},
	{[]rune{0x1f331}, "seedling", 3, 41, []string{"plant", "sapling", "seedling", "sprout", "young"}, false, 0},
	{[]rune{0x1fab4}, "potted plant", 3, 41, []string{"decor", "grow", "house", "nurturing", "plant", "pot", "potted"}, false, 0},
	{[]rune{0x1f332}, "evergreen tree", 3, 41, []string{"christmas", "evergreen", "forest", "pine", "tree"}, false, 0},
	{[]rune{0x1f333}, "deciduous tree", 3, 41, []string{"deciduous", "forest", "green", "habitat", "shedding", "tree"}, false, 0},
	{[]rune{0x1f334}, "palm tree", 3, 41, []string{"beach", "palm", "plant", "tree", "tropical"}, false, 0},
	{[]rune{0x1f335}, "cactus", 3, 41, []string{"cactus", "desert", "drought", "nature", "plant"}, false, 0},
	{[]rune{0x1f33e}, "sheaf of rice", 3, 41, []string{"ear", "grain", "grains", "plant", "rice", "sheaf"}, false, 0},
	{[]rune{0x1f33f}, "herb", 3, 41, []string{"herb", "leaf", "plant"}, false, 0},
	{[]rune{0x2618, 0xfe0f}, "shamrock", 3, 41, []string{"irish", "plant", "shamrock"}, false, 0},
	{[]rune{0x1f340}, "four leaf clover", 3, 41, []string{"4", "clover", "four", "four-leaf", "irish", "leaf", "lucky", "plant"}, false, 0},
	{[]rune{0x1f341}, "maple leaf", 3, 41, []string{"falling", "leaf", "maple"}, false, 0},
	{[]rune{0x1f342}, "fallen leaf", 3, 41, []string{"autumn", "fall", "fallen", "falling", "leaf"}, false, 0},
	{[]rune{0x1f343}, "leaf fluttering in wind", 3, 41, []string{"blow", "flutter", "fluttering", "leaf", "wind"}, false, 0},
	{[]rune{0x1fab9}, "empty nest", 3, 41, []string{"branch", "empty", "home", "nest", "nesting"}, false, 0},
	{[]rune{0x1faba}, "nest with eggs", 3, 41, []string{"bird", "branch", "egg", "eggs", "nest", "nesting"}, false, 0},
	{[]rune{0x1f344}, "mushroom", 3, 41, []string{"fungus", "mushroom", "toadstool"}, false, 0},
	{[]rune{0x1fabe}, "leafless tree", 3, 41, []string{"bare", "barren", "branches", "dead", "drought", "leafless", "tree", "trunk", "winter", "wood"}, false, 0},
	{[]rune{0x1f347}, "grapes", 4, 42, []string{"Dionysus", "fruit", "grape", "grapes"}, false, 0},
	{[]rune{0x1f348}, "melon", 4, 42, []string{"cantaloupe", "fruit", "melon"}, false, 0},
	{[]rune{0x1f349}, "watermelon", 4, 42, []string{"fruit", "watermelon"}, false, 0},
	{[]rune{0x1f34a}, "tangerine", 4, 42, []string{"c", "citrus", "fruit", "nectarine", "orange", "tangerine", "vitamin"}, false, 0},
	{[]rune{0x1f34b}, "lemon", 4, 42, []string{"citrus", "fruit", "lemon", "sour"}, false, 0},
	{[]rune{0x1f34b, 0x1f7e9}, "lime", 4, 42, []string{"acidity", "citrus", "cocktail", "fruit", "garnish", "key", "lime", "margarita", "mojito", "refreshing", "salsa", "sour", "tangy", "tequila", "tropical", "zest"}, false, 0},
	{[]rune{0x1f34c}, "banana", 4, 42, []string{"banana", "fruit", "potassium"}, false, 0},
	{[]rune{0x1f34d}, "pineapple", 4, 42, []string{"colada", "fruit", "pina", "pineapple", "tropical"}, false, 0},
	{[]rune{0x1f96d}, "mango", 4, 42, []string{"food", "fruit", "mango", "tropical"}, false, 0},
	{[]rune{0x1f34e}, "red apple", 4, 42, []string{"apple", "diet", "food", "fruit", "health", "red", "ripe"}, false, 0},
	{[]rune{0x1f34f}, "green apple", 4, 42, []string{"apple", "fruit", "green"}, false, 0},
	{[]rune{0x1f350}, "pear", 4, 42, []string{"fruit", "pear"}, false, 0},
	{[]rune{0x1f351}, "peach", 4, 42, []string{"fruit", "peach"}, false, 0},
	{[]rune{0x1f352}, "cherries", 4, 42, []string{"berries", "cherries", "cherry", "fruit", "red"}, false, 0},
	{[]rune{0x1f353}, "strawberry", 4, 42, []string{"berry", "fruit", "strawberry"}, false, 0},
	{[]rune{0x1fad0}, "blueberries", 4, 42, []string{"berries", "berry", "bilberry", "blue", "blueberries", "blueberry", "food", "fruit"}, false, 0},
	{[]rune{0x1f95d}, "kiwi fruit", 4, 42, []string{"food", "fruit", "kiwi"}, false, 0},
	{[]rune{0x1f345}, "tomato", 4, 42, []string{"food", "fruit", "tomato", "vegetable"}, false, 0},
	{[]rune{0x1fad2}, "olive", 4, 42, []string{"food", "olive"}, false, 0},
	{[]rune{0x1f965}, "coconut", 4, 42, []string{"coconut", "colada", "palm", "piña"}, false, 0},
	{[]rune{0x1f951}, "avocado", 4, 43, []string{"avocado", "food", "fruit"}, false, 0},
	{[]rune{0x1f346}, "eggplant", 4, 43, []string{"aubergine", "eggplant", "vegetable"}, false, 0},
	{[]rune{0x1f954}, "potato", 4, 43, []string{"food", "potato", "vegetable"}, false, 0},
	{[]rune{0x1f955}, "carrot", 4, 43, []string{"carrot", "food", "vegetable"}, false, 0},
	{[]rune{0x1f33d}, "ear of corn", 4, 43, []string{"corn", "crops", "ear", "farm", "maize", "maze"}, false, 0},
	{[]rune{0x1f336, 0xfe0f}, "hot pepper", 4, 43, []string{"hot", "pepper"}, false, 0},
	{[]rune{0x1fad1}, "bell pepper", 4, 43, []string{"bell", "capsicum", "food", "pepper", "vegetable"}, false, 0},
	{[]rune{0x1f952}, "cucumber", 4, 43, []string{"cucumber", "food", "pickle", "vegetable"}, false, 0},
	{[]rune{0x1f96c}, "leafy green", 4, 43, []string{"bok", "burgers", "cabbage", "choy", "green", "kale", "leafy", "lettuce", "salad"}, false, 0},
	{[]rune{0x1f966}, "broccoli", 4, 43, []string{"broccoli", "cabbage", "wild"}, false, 0},
	{[]rune{0x1f9c4}, "garlic", 4, 43, []string{"flavoring", "garlic"}, false, 0},
	{[]rune{0x1f9c5}, "onion", 4, 43, []string{"flavoring", "onion"}, false, 0},
	{[]rune{0x1f95c}, "peanuts", 4, 43, []string{"food", "nut", "peanut", "peanuts", "vegetable"}, false, 0},
	{[]rune{0x1fad8}, "beans", 4, 43, []string{"beans", "food", "kidney", "legume", "small"}, false, 0},
	{[]rune{0x1f330}, "chestnut", 4, 43, []string{"almond", "chestnut", "plant"}, false, 0},
	{[]rune{0x1fada}, "ginger root", 4, 43, []string{"beer", "ginger", "health", "herb", "natural", "root", "spice"}, false, 0},
	{[]rune{0x1fadb}, "pea pod", 4, 43, []string{"beans", "beanstalk", "edamame", "legume", "pea", "pod", "soybean", "vegetable", "veggie"}, false, 0},
	{[]rune{0x1f344, 0x1f7eb}, "brown mushroom", 4, 43, []string{"food", "fungi", "fungus", "mushroom", "nature", "pizza", "portobello", "shiitake", "shroom", "spore", "sprout", "toppings", "truffle", "vegetable", "vegetarian", "veggie"}, false, 0},
	{[]rune{0x1fadc}, "root vegetable", 4, 43, []string{"beet", "food", "garden", "radish", "root", "salad", "turnip", "vegetable", "vegetarian"}, false, 0},
	{[]rune{0x1f35e}, "bread", 4, 44, []string{"bread", "carbs", "food", "grain", "loaf", "restaurant", "toast", "wheat"}, false, 0},
	{[]rune{0x1f950}, "croissant", 4, 44, []string{"bread", "breakfast", "crescent", "croissant", "food", "french", "roll"}, false, 0},
	{[]rune{0x1f956}, "baguette bread", 4, 44, []string{"baguette", "bread", "food", "french"}, false, 0},
	{[]rune{0x1fad3}, "flatbread", 4, 44, []string{"arepa", "bread", "flatbread", "food", "gordita", "lavash", "naan", "pita"}, false, 0},
	{[]rune{0x1f968}, "pretzel", 4, 44, []string{"convoluted", "pretzel", "twisted"}, false, 0},
	{[]rune{0x1f96f}, "bagel", 4, 44, []string{"bagel", "bakery", "bread", "breakfast", "schmear"}, false, 0},
	{[]rune{0x1f95e}, "pancakes", 4, 44, []string{"breakfast", "crêpe", "food", "hotcake", "pancake", "pancakes"}, false, 0},
	{[]rune{0x1f9c7}, "waffle", 4, 44, []string{"breakfast", "indecisive", "iron", "waffle"}, false, 0},
	{[]rune{0x1f9c0}, "cheese wedge", 4, 44, []string{"cheese", "wedge"}, false, 0},
	{[]rune{0x1f356}, "meat on bone", 4, 44, []string{"bone", "meat"}, false, 0},
	{[]rune{0x1f357}, "poultry leg", 4, 44, []string{"bone", "chicken", "drumstick", "hungry", "leg", "poultry", "turkey"}, false, 0},
	{[]rune{0x1f969}, "cut of meat", 4, 44, []string{"chop", "cut", "lambchop", "meat", "porkchop", "red", "steak"}, false, 0},
	{[]rune{0x1f953}, "bacon", 4, 44, []string{"bacon", "breakfast", "food", "meat"}, false, 0},
	{[]rune{0x1f354}, "hamburger", 4, 44, []string{"burger", "eat", "fast", "food", "hamburger", "hungry"}, false, 0},
	{[]rune{0x1f35f}, "french fries", 4, 44, []string{"fast", "food", "french", "fries"}, false, 0},
	{[]rune{0x1f355}, "pizza", 4, 44, []string{"cheese", "food", "hungry", "pepperoni", "pizza", "slice"}, false, 0},
	{[]rune{0x1f32d}, "hot dog", 4, 44, []string{"dog", "frankfurter", "hot", "hotdog", "sausage"}, false, 0},
	{[]rune{0x1f96a}, "sandwich", 4, 44, []string{"bread", "sandwich"}, false, 0},
	{[]rune{0x1f32e}, "taco", 4, 44, []string{"mexican", "taco"}, false, 0},
	{[]rune{0x1f32f}, "burrito", 4, 44, []string{"burrito", "mexican", "wrap"}, false, 0},
	{[]rune{0x1fad4}, "tamale", 4, 44, []string{"food", "mexican", "pamonha", "tamale", "wrapped"}, false, 0},
	{[]rune{0x1f959}, "stuffed flatbread", 4, 44, []string{"falafel", "flatbread", "food", "gyro", "kebab", "stuffed"}, false, 0},
	{[]rune{0x1f9c6}, "falafel", 4, 44, []string{"chickpea", "falafel", "meatball"}, false, 0},
	{[]rune{0x1f95a}, "egg", 4, 44, []string{"breakfast", "egg", "food"}, false, 0},
	{[]rune{0x1f373}, "cooking", 4, 44, []string{"breakfast", "cooking", "easy", "egg", "fry", "frying", "over", "pan", "restaurant", "side", "sunny", "up"}, false, 0},
	{[]rune{0x1f958}, "shallow pan of food", 4, 44, []string{"casserole", "food", "paella", "pan", "shallow"}, false, 0},
	{[]rune{0x1f372}, "pot of food", 4, 44, []string{"food", "pot", "soup", "stew"}, false, 0},
	{[]rune{0x1fad5}, "fondue", 4, 44, []string{"cheese", "chocolate", "fondue", "food", "melted", "pot", "ski"}, false, 0},
	{[]rune{0x1f963}, "bowl with spoon", 4, 44, []string{"bowl", "breakfast", "cereal", "congee", "oatmeal", "porridge", "spoon"}, false, 0},
	{[]rune{0x1f957}, "green salad", 4, 44, []string{"food", "green", "salad"}, false, 0},
	{[]rune{0x1f37f}, "popcorn", 4, 44, []string{"corn", "movie", "pop", "popcorn"}, false, 0},
	{[]rune{0x1f9c8}, "butter", 4, 44, []string{"butter", "dairy"}, false, 0},
	{[]rune{0x1f9c2}, "salt", 4, 44, []string{"condiment", "flavor", "mad", "salt", "salty", "shaker", "taste", "upset"}, false, 0},
	{[]rune{0x1f96b}, "canned food", 4, 44, []string{"can", "canned", "food"}, false, 0},
	{[]rune{0x1f371}, "bento box", 4, 45, []string{"bento", "box", "food"}, false, 0},
	{[]rune{0x1f358}, "rice cracker", 4, 45, []string{"cracker", "food", "rice"}, false, 0},
	{[]rune{0x1f359}, "rice ball", 4, 45, []string{"ball", "food", "Japanese", "rice"}, false, 0},
	{[]rune{0x1f35a}, "cooked rice", 4, 45, []string{"cooked", "food", "rice"}, false, 0},
	{[]rune{0x1f35b}, "curry rice", 4, 45, []string{"curry", "food", "rice"}, false, 0},
	{[]rune{0x1f35c}, "steaming bowl", 4, 45, []string{"bowl", "chopsticks", "food", "noodle", "pho", "ramen", "soup", "steaming"}, false, 0},
	{[]rune{0x1f35d}, "spaghetti", 4, 45, []string{"food", "meatballs", "pasta", "restaurant", "spaghetti"}, false, 0},
	{[]rune{0x1f360}, "roasted sweet potato", 4, 45, []string{"food", "potato", "roasted", "sweet"}, false, 0},
	{[]rune{0x1f362}, "oden", 4, 45, []string{"food", "kebab", "oden", "restaurant", "seafood", "skewer", "stick"}, false, 0},
	{[]rune{0x1f363}, "sushi", 4, 45, []string{"food", "sushi"}, false, 0},
	{[]rune{0x1f364}, "fried shrimp", 4, 45, []string{"fried", "prawn", "shrimp", "tempura"}, false, 0},
	{[]rune{0x1f365}, "fish cake with swirl", 4, 45, []string{"cake", "fish", "food", "pastry", "restaurant", "swirl"}, false, 0},
	{[]rune{0x1f96e}, "moon cake", 4, 45, []string{"autumn", "cake", "festival", "moon", "yuèbǐng"}, false, 0},
	{[]rune{0x1f361}, "dango", 4, 45, []string{"dango", "dessert", "Japanese", "skewer", "stick", "sweet"}, false, 0},
	{[]rune{0x1f95f}, "dumpling", 4, 45, []string{"dumpling", "empanada", "gyōza", "jiaozi", "pierogi", "potsticker"}, false, 0},
	{[]rune{0x1f960}, "fortune cookie", 4, 45, []string{"cookie", "fortune", "prophecy"}, false, 0},
	{[]rune{0x1f961}, "takeout box", 4, 45, []string{"box", "chopsticks", "delivery", "food", "oyster", "pail", "takeout"}, false, 0},
	{[]rune{0x1f366}, "soft ice cream", 4, 46, []string{"cream", "dessert", "food", "ice", "icecream", "restaurant", "serve", "soft", "sweet"}, false, 0},
	{[]rune{0x1f367}, "shaved ice", 4, 46, []string{"dessert", "ice", "restaurant", "shaved", "sweet"}, false, 0},
	{[]rune{0x1f368}, "ice cream", 4, 46, []string{"cream", "dessert", "food", "ice", "restaurant", "sweet"}, false, 0},
	{[]rune{0x1f369}, "doughnut", 4, 46, []string{"breakfast", "dessert", "donut", "doughnut", "food", "sweet"}, false, 0},
	{[]rune{0x1f36a}, "cookie", 4, 46, []string{"chip", "chocolate", "cookie", "dessert", "sweet"}, false, 0},
	{[]rune{0x1f382}, "birthday cake", 4, 46, []string{"bday", "birthday", "cake", "celebration", "dessert", "happy", "pastry", "sweet"}, false, 0},
	{[]rune{0x1f370}, "shortcake", 4, 46, []string{"cake", "dessert", "pastry", "shortcake", "slice", "sweet"}, false, 0},
	{[]rune{0x1f9c1}, "cupcake", 4, 46, []string{"bakery", "cupcake", "dessert", "sprinkles", "sugar", "sweet", "treat"}, false, 0},
	{[]rune{0x1f967}, "pie", 4, 46, []string{"apple", "filling", "fruit", "meat", "pastry", "pie", "pumpkin", "slice"}, false, 0},
	{[]rune{0x1f36b}, "chocolate bar", 4, 46, []string{"bar", "candy", "chocolate", "dessert", "halloween", "sweet", "tooth"}, false, 0},
	{[]rune{0x1f36c}, "candy", 4, 46, []string{"candy", "cavities", "dessert", "halloween", "restaurant", "sweet", "tooth", "wrapper"}, false, 0},
	{[]rune{0x1f36d}, "lollipop", 4, 46, []string{"candy", "dessert", "food", "lollipop", "restaurant", "sweet"}, false, 0},
	{[]rune{0x1f36e}, "custard", 4, 46, []string{"custard", "dessert", "pudding", "sweet"}, false, 0},
	{[]rune{0x1f36f}, "honey pot", 4, 46, []string{"barrel", "bear", "food", "honey", "honeypot", "jar", "pot", "sweet"}, false, 0},
	{[]rune{0x1f37c}, "baby bottle", 4, 47, []string{"babies", "baby", "birth", "born", "bottle", "drink", "infant", "milk", "newborn"}, false, 0},
	{[]rune{0x1f95b}, "glass of milk", 4, 47, []string{"drink", "glass", "milk"}, false, 0},
	{[]rune{0x2615}, "hot beverage", 4, 47, []string{"beverage", "cafe", "caffeine", "chai", "coffee", "drink", "hot", "morning", "steaming", "tea"}, false, 0},
	{[]rune{0x1fad6}, "teapot", 4, 47, []string{"brew", "drink", "food", "pot", "tea", "teapot"}, false, 0},
	{[]rune{0x1f375}, "teacup without handle", 4, 47, []string{"beverage", "cup", "drink", "handle", "oolong", "tea", "teacup"}, false, 0},
	{[]rune{0x1f376}, "sake", 4, 47, []string{"bar", "beverage", "bottle", "cup", "drink", "restaurant", "sake"}, false, 0},
	{[]rune{0x1f37e}, "bottle with popping cork", 4, 47, []string{"bar", "bottle", "cork", "drink", "popping"}, false, 0},
	{[]rune{0x1f377}, "wine glass", 4, 47, []string{"alcohol", "bar", "beverage", "booze", "club", "drink", "drinking", "drinks", "glass", "restaurant", "wine"}, false, 0},
	{[]rune{0x1f378}, "cocktail glass", 4, 47, []string{"alcohol", "bar", "booze", "club", "cocktail", "drink", "drinking", "drinks", "glass", "mad", "martini", "men"}, false, 0},
	{[]rune{0x1f379}, "tropical drink", 4, 47, []string{"alcohol", "bar", "booze", "club", "cocktail", "drink", "drinking", "drinks", "drunk", "mai", "party", "tai", "tropical", "tropics"}, false, 0},
	{[]rune{0x1f37a}, "beer mug", 4, 47, []string{"alcohol", "ale", "bar", "beer", "booze", "drink", "drinking", "drinks", "mug", "octoberfest", "oktoberfest", "pint", "stein", "summer"}, false, 0},
	{[]rune{0x1f37b}, "clinking beer mugs", 4, 47, []string{"alcohol", "bar", "beer", "booze", "bottoms", "cheers", "clink", "clinking", "drinking", "drinks", "mugs"}, false, 0},
	{[]rune{0x1f942}, "clinking glasses", 4, 47, []string{"celebrate", "clink", "clinking", "drink", "glass", "glasses"}, false, 0},
	{[]rune{0x1f943}, "tumbler glass", 4, 47, []string{"glass", "liquor", "scotch", "shot", "tumbler", "whiskey", "whisky"}, false, 0},
	{[]rune{0x1fad7}, "pouring liquid", 4, 47, []string{"accident", "drink", "empty", "glass", "liquid", "oops", "pour", "pouring", "spill", "water"}, false, 0},
	{[]rune{0x1f964}, "cup with straw", 4, 47, []string{"cup", "drink", "juice", "malt", "soda", "soft", "straw", "water"}, false, 0},
	{[]rune{0x1f9cb}, "bubble tea", 4, 47, []string{"boba", "bubble", "food", "milk", "pearl", "tea"}, false, 0},
	{[]rune{0x1f9c3}, "beverage box", 4, 47, []string{"beverage", "box", "juice", "straw", "sweet"}, false, 0},
	{[]rune{0x1f9c9}, "mate", 4, 47, []string{"drink", "mate"}, false, 0},
	{[]rune{0x1f9ca}, "ice", 4, 47, []string{"cold", "cube", "ice", "iceberg"}, false, 0},
	{[]rune{0x1f962}, "chopsticks", 4, 48, []string{"chopsticks", "hashi", "jeotgarak", "kuaizi"}, false, 0},
	{[]rune{0x1f37d, 0xfe0f}, "fork and knife with plate", 4, 48, []string{"cooking", "dinner", "eat", "fork", "knife", "plate"}, false, 0},
	{[]rune{0x1f374}, "fork and knife", 4, 48, []string{"breakfast", "breaky", "cooking", "cutlery", "delicious", "dinner", "eat", "feed", "food", "fork", "hungry", "knife", "lunch", "restaurant", "yum", "yummy"}, false, 0},
	{[]rune{0x1f944}, "spoon", 4, 48, []string{"eat", "spoon", "tableware"}, false, 0},
	{[]rune{0x1f52a}, "kitchen knife", 4, 48, []string{"chef", "cooking", "hocho", "kitchen", "knife", "tool", "weapon"}, false, 0},
	{[]rune{0x1fad9}, "jar", 4, 48, []string{"condiment", "container", "empty", "jar", "nothing", "sauce", "store"}, false, 0},
	{[]rune{0x1f3fa}, "amphora", 4, 48, []string{"amphora", "Aquarius", "cooking", "drink", "jug", "tool", "weapon", "zodiac"}, false, 0},
	{[]rune{0x1f30d}, "globe showing Europe-Africa", 5, 49, []string{"Africa", "earth", "Europe", "Europe-Africa", "globe", "showing", "world"}, false, 0},
	{[]rune{0x1f30e}, "globe showing Americas", 5, 49, []string{"Americas", "earth", "globe", "showing", "world"}, false, 0},
	{[]rune{0x1f30f}, "globe showing Asia-Australia", 5, 49, []string{"Asia", "Asia-Australia", "Australia", "earth", "globe", "showing", "world"}, false, 0},
	{[]rune{0x1f310}, "globe with meridians", 5, 49, []string{"earth", "globe", "internet", "meridians", "web", "world", "worldwide"}, false, 0},
	{[]rune{0x1f5fa, 0xfe0f}, "world map", 5, 49, []string{"map", "world"}, false, 0},
	{[]rune{0x1f5fe}, "map of Japan", 5, 49, []string{"Japan", "map"}, false, 0},
	{[]rune{0x1f9ed}, "compass", 5, 49, []string{"compass", "direction", "magnetic", "navigation", "orienteering"}, false, 0},
	{[]rune{0x1f3d4, 0xfe0f}, "snow-capped mountain", 5, 50, []string{"cold", "mountain", "snow", "snow-capped"}, false, 0},
	{[]rune{0x26f0, 0xfe0f}, "mountain", 5, 50, []string{"mountain"}, false, 0},
	{[]rune{0x1f6d8}, "landslide", 5, 50, []string{"avalanche", "danger", "disaster", "earthquake", "mountain", "mudslide", "rocks"}, false, 0},
	{[]rune{0x1f30b}, "volcano", 5, 50, []string{"eruption", "mountain", "nature", "volcano"}, false, 0},
	{[]rune{0x1f5fb}, "mount fuji", 5, 50, []string{"fuji", "mount", "mountain", "nature"}, false, 0},
	{[]rune{0x1f3d5, 0xfe0f}, "camping", 5, 50, []string{"camping"}, false, 0},
	{[]rune{0x1f3d6, 0xfe0f}, "beach with umbrella", 5, 50, []string{"beach", "umbrella"}, false, 0},
	{[]rune{0x1f3dc, 0xfe0f}, "desert", 5, 50, []string{"desert"}, false, 0},
	{[]rune{0x1f3dd, 0xfe0f}, "desert island", 5, 50, []string{"desert", "island"}, false, 0},
	{[]rune{0x1f3de, 0xfe0f}, "national park", 5, 50, []string{"national", "park"}, false, 0},
	{[]rune{0x1f3df, 0xfe0f}, "stadium", 5, 51, []string{"stadium"}, false, 0},
	{[]rune{0x1f3db, 0xfe0f}, "classical building", 5, 51, []string{"building", "classical"}, false, 0},
	{[]rune{0x1f3d7, 0xfe0f}, "building construction", 5, 51, []string{"building", "construction", "crane"}, false, 0},
	{[]rune{0x1f9f1}, "brick", 5, 51, []string{"brick", "bricks", "clay", "mortar", "wall"}, false, 0},
	{[]rune{0x1faa8}, "rock", 5, 51, []string{"boulder", "heavy", "rock", "solid", "stone", "tough"}, false, 0},
	{[]rune{0x1fab5}, "wood", 5, 51, []string{"log", "lumber", "timber", "wood"}, false, 0},
	{[]rune{0x1f6d6}, "hut", 5, 51, []string{"home", "house", "hut", "roundhouse", "shelter", "yurt"}, false, 0},
	{[]rune{0x1f3d8, 0xfe0f}, "houses", 5, 51, []string{"house", "houses"}, false, 0},
	{[]rune{0x1f3da, 0xfe0f}, "derelict house", 5, 51, []string{"derelict", "home", "house"}, false, 0},
	{[]rune{0x1f3e0}, "house", 5, 51, []string{"building", "country", "heart", "home", "house", "ranch", "settle", "simple", "suburban", "suburbia", "where"}, false, 0},
	{[]rune{0x1f3e1}, "house with garden", 5, 51, []string{"building", "country", "garden", "heart", "home", "house", "ranch", "settle", "simple", "suburban", "suburbia", "where"}, false, 0},
	{[]rune{0x1f3e2}, "office building", 5, 51, []string{"building", "city", "cubical", "job", "office"}, false, 0},
	{[]rune{0x1f3e3}, "Japanese post office", 5, 51, []string{"building", "Japanese", "office", "post"}, false, 0},
	{[]rune{0x1f3e4}, "post office", 5, 51, []string{"building", "European", "office", "post"}, false, 0},
	{[]rune{0x1f3e5}, "hospital", 5, 51, []string{"building", "doctor", "hospital", "medicine"}, false, 0},
	{[]rune{0x1f3e6}, "bank", 5, 51, []string{"bank", "building"}, false, 0},
	{[]rune{0x1f3e8}, "hotel", 5, 51, []string{"building", "hotel"}, false, 0},
	{[]rune{0x1f3e9}, "love hotel", 5, 51, []string{"building", "hotel", "love"}, false, 0},
	{[]rune{0x1f3ea}, "convenience store", 5, 51, []string{"24", "building", "convenience", "hours", "store"}, false, 0},
	{[]rune{0x1f3eb}, "school", 5, 51, []string{"building", "school"}, false, 0},
	{[]rune{0x1f3ec}, "department store", 5, 51, []string{"building", "department", "store"}, false, 0},
	{[]rune{0x1f3ed}, "factory", 5, 51, []string{"building", "factory"}, false, 0},
	{[]rune{0x1f3ef}, "Japanese castle", 5, 51, []string{"building", "castle", "Japanese"}, false, 0},
	{[]rune{0x1f3f0}, "castle", 5, 51, []string{"building", "castle", "European"}, false, 0},
	{[]rune{0x1f492}, "wedding", 5, 51, []string{"chapel", "hitched", "nuptials", "romance", "wedding"}, false, 0},
	{[]rune{0x1f5fc}, "Tokyo tower", 5, 51, []string{"Tokyo", "tower"}, false, 0},
	{[]rune{0x1f5fd}, "Statue of Liberty", 5, 51, []string{"liberty", "Liberty", "new", "ny", "nyc", "statue", "Statue", "york"}, false, 0},
	{[]rune{0x26ea}, "church", 5, 52, []string{"bless", "chapel", "Christian", "church", "cross", "religion"}, false, 0},
	{[]rune{0x1f54c}, "mosque", 5, 52, []string{"islam", "masjid", "mosque", "Muslim", "religion"}, false, 0},
	{[]rune{0x1f6d5}, "hindu temple", 5, 52, []string{"hindu", "temple"}, false, 0},
	{[]rune{0x1f54d}, "synagogue", 5, 52, []string{"Jew", "Jewish", "judaism", "religion", "synagogue", "temple"}, false, 0},
	{[]rune{0x26e9, 0xfe0f}, "shinto shrine", 5, 52, []string{"religion", "shinto", "shrine"}, false, 0},
	{[]rune{0x1f54b}, "kaaba", 5, 52, []string{"hajj", "islam", "kaaba", "Muslim", "religion", "umrah"}, false, 0},
	{[]rune{0x26f2}, "fountain", 5, 53, []string{"fountain"}, false, 0},
	{[]rune{0x26fa}, "tent", 5, 53, []string{"camping", "tent"}, false, 0},
	{[]rune{0x1f301}, "foggy", 5, 53, []string{"fog", "foggy"}, false, 0},
	{[]rune{0x1f303}, "night with stars", 5, 53, []string{"night", "star", "stars"}, false, 0},
	{[]rune{0x1f3d9, 0xfe0f}, "cityscape", 5, 53, []string{"city", "cityscape"}, false, 0},
	{[]rune{0x1f304}, "sunrise over mountains", 5, 53, []string{"morning", "mountains", "over", "sun", "sunrise"}, false, 0},
	{[]rune{0x1f305}, "sunrise", 5, 53, []string{"morning", "nature", "sun", "sunrise"}, false, 0},
	{[]rune{0x1f306}, "cityscape at dusk", 5, 53, []string{"at", "building", "city", "cityscape", "dusk", "evening", "landscape", "sun", "sunset"}, false, 0},
	{[]rune{0x1f307}, "sunset", 5, 53, []string{"building", "dusk", "sun", "sunset"}, false, 0},
	{[]rune{0x1f309}, "bridge at night", 5, 53, []string{"at", "bridge", "night"}, false, 0},
	{[]rune{0x2668, 0xfe0f}, "hot springs", 5, 53, []string{"hot", "hotsprings", "springs", "steaming"}, false, 0},
	{[]rune{0x1f3a0}, "carousel horse", 5, 53, []string{"carousel", "entertainment", "horse"}, false, 0},
	{[]rune{0x1f6dd}, "playground slide", 5, 53, []string{"amusement", "park", "play", "playground", "playing", "slide", "sliding", "theme"}, false, 0},
	{[]rune{0x1f3a1}, "ferris wheel", 5, 53, []string{"amusement", "ferris", "park", "theme", "wheel"}, false, 0},
	{[]rune{0x1f3a2}, "roller coaster", 5, 53, []string{"amusement", "coaster", "park", "roller", "theme"}, false, 0},
	{[]rune{0x1f488}, "barber pole", 5, 53, []string{"barber", "cut", "fresh", "haircut", "pole", "shave"}, false, 0},
	{[]rune{0x1f3aa}, "circus tent", 5, 53, []string{"circus", "tent"}, false, 0},
	{[]rune{0x1f682}, "locomotive", 5, 54, []string{"caboose", "engine", "locomotive", "railway", "steam", "train", "trains", "travel"}, false, 0},
	{[]rune{0x1f683}, "railway car", 5, 54, []string{"car", "electric", "railway", "train", "tram", "travel", "trolleybus"}, false, 0},
	{[]rune{0x1f684}, "high-speed train", 5, 54, []string{"high-speed", "railway", "shinkansen", "speed", "train"}, false, 0},
	{[]rune{0x1f685}, "bullet train", 5, 54, []string{"bullet", "high-speed", "nose", "railway", "shinkansen", "speed", "train", "travel"}, false, 0},
	{[]rune{0x1f686}, "train", 5, 54, []string{"arrived", "choo", "railway", "train"}, false, 0},
	{[]rune{0x1f687}, "metro", 5, 54, []string{"metro", "subway", "travel"}, false, 0},
	{[]rune{0x1f688}, "light rail", 5, 54, []string{"arrived", "light", "monorail", "rail", "railway"}, false, 0},
	{[]rune{0x1f689}, "station", 5, 54, []string{"railway", "station", "train"}, false, 0},
	{[]rune{0x1f68a}, "tram", 5, 54, []string{"tram", "trolleybus"}, false, 0},
	{[]rune{0x1f69d}, "monorail", 5, 54, []string{"monorail", "vehicle"}, false, 0},
	{[]rune{0x1f69e}, "mountain railway", 5, 54, []string{"car", "mountain", "railway", "trip"}, false, 0},
	{[]rune{0x1f68b}, "tram car", 5, 54, []string{"bus", "car", "tram", "trolley", "trolleybus"}, false, 0},
	{[]rune{0x1f68c}, "bus", 5, 54, []string{"bus", "school", "vehicle"}, false, 0},
	{[]rune{0x1f68d}, "oncoming bus", 5, 54, []string{"bus", "cars", "oncoming"}, false, 0},
	{[]rune{0x1f68e}, "trolleybus", 5, 54, []string{"bus", "tram", "trolley", "trolleybus"}, false, 0},
	{[]rune{0x1f690}, "minibus", 5, 54, []string{"bus", "drive", "minibus", "van", "vehicle"}, false, 0},
	{[]rune{0x1f691}, "ambulance", 5, 54, []string{"ambulance", "emergency", "vehicle"}, false, 0},
	{[]rune{0x1f692}, "fire engine", 5, 54, []string{"engine", "fire", "truck"}, false, 0},
	{[]rune{0x1f693}, "police car", 5, 54, []string{"5–0", "car", "cops", "patrol", "police"}, false, 0},
	{[]rune{0x1f694}, "oncoming police car", 5, 54, []string{"car", "oncoming", "police"}, false, 0},
	{[]rune{0x1f695}, "taxi", 5, 54, []string{"cab", "cabbie", "car", "drive", "taxi", "vehicle", "yellow"}, false, 0},
	{[]rune{0x1f696}, "oncoming taxi", 5, 54, []string{"cab", "cabbie", "cars", "drove", "hail", "oncoming", "taxi", "yellow"}, false, 0},
	{[]rune{0x1f697}, "automobile", 5, 54, []string{"automobile", "car", "driving", "vehicle"}, false, 0},
	{[]rune{0x1f698}, "oncoming automobile", 5, 54, []string{"automobile", "car", "cars", "drove", "oncoming", "vehicle"}, false, 0},
	{[]rune{0x1f699}, "sport utility vehicle", 5, 54, []string{"car", "drive", "recreational", "sport", "sportutility", "utility", "vehicle"}, false, 0},
	{[]rune{0x1f6fb}, "pickup truck", 5, 54, []string{"automobile", "car", "flatbed", "pick-up", "pickup", "transportation", "truck"}, false, 0},
	{[]rune{0x1f69a}, "delivery truck", 5, 54, []string{"car", "delivery", "drive", "truck", "vehicle"}, false, 0},
	{[]rune{0x1f69b}, "articulated lorry", 5, 54, []string{"articulated", "car", "drive", "lorry", "move", "semi", "truck", "vehicle"}, false, 0},
	{[]rune{0x1f69c}, "tractor", 5, 54, []string{"tractor", "vehicle"}, false, 0},
	{[]rune{0x1f3ce, 0xfe0f}, "racing car", 5, 54, []string{"car", "racing", "zoom"}, false, 0},
	{[]rune{0x1f3cd, 0xfe0f}, "motorcycle", 5, 54, []string{"motorcycle", "racing"}, false, 0},
	{[]rune{0x1f6f5}, "motor scooter", 5, 54, []string{"motor", "scooter"}, false, 0},
	{[]rune{0x1f9bd}, "manual wheelchair", 5, 54, []string{"accessibility", "manual", "wheelchair"}, false, 0},
	{[]rune{0x1f9bc}, "motorized wheelchair", 5, 54, []string{"accessibility", "motorized", "wheelchair"}, false, 0},
	{[]rune{0x1f6fa}, "auto rickshaw", 5, 54, []string{"auto", "rickshaw", "tuk"}, false, 0},
	{[]rune{0x1f6b2}, "bicycle", 5, 54, []string{"bicycle", "bike", "class", "cycle", "cycling", "cyclist", "gang", "ride", "spin", "spinning"}, false, 0},
	{[]rune{0x1f6f4}, "kick scooter", 5, 54, []string{"kick", "scooter"}, false, 0},
	{[]rune{0x1f6f9}, "skateboard", 5, 54, []string{"board", "skate", "skateboard", "skater", "wheels"}, false, 0},
	{[]rune{0x1f6fc}, "roller skate", 5, 54, []string{"blades", "roller", "skate", "skates", "sport"}, false, 0},
	{[]rune{0x1f68f}, "bus stop", 5, 54, []string{"bus", "busstop", "stop"}, false, 0},
	{[]rune{0x1f6e3, 0xfe0f}, "motorway", 5, 54, []string{"highway", "motorway", "road"}, false, 0},
	{[]rune{0x1f6e4, 0xfe0f}, "railway track", 5, 54, []string{"railway", "track", "train"}, false, 0},
	{[]rune{0x1f6e2, 0xfe0f}, "oil drum", 5, 54, []string{"drum", "oil"}, false, 0},
	{[]rune{0x26fd}, "fuel pump", 5, 54, []string{"diesel", "fuel", "fuelpump", "gas", "gasoline", "pump", "station"}, false, 0},
	{[]rune{0x1f6de}, "wheel", 5, 54, []string{"car", "circle", "tire", "turn", "vehicle", "wheel"}, false, 0},
	{[]rune{0x1f6a8}, "police car light", 5, 54, []string{"alarm", "alert", "beacon", "car", "emergency", "light", "police", "revolving", "siren"}, false, 0},
	{[]rune{0x1f6a5}, "horizontal traffic light", 5, 54, []string{"horizontal", "intersection", "light", "signal", "stop", "stoplight", "traffic"}, false, 0},
	{[]rune{0x1f6a6}, "vertical traffic light", 5, 54, []string{"drove", "intersection", "light", "signal", "stop", "stoplight", "traffic", "vertical"}, false, 0},
	{[]rune{0x1f6d1}, "stop sign", 5, 54, []string{"octagonal", "sign", "stop"}, false, 0},
	{[]rune{0x1f6a7}, "construction", 5, 54, []string{"barrier", "construction"}, false, 0},
	{[]rune{0x2693}, "anchor", 5, 55, []string{"anchor", "ship", "tool"}, false, 0},
	{[]rune{0x1f6df}, "ring buoy", 5, 55, []string{"buoy", "float", "life", "lifesaver", "preserver", "rescue", "ring", "safety", "save", "saver", "swim"}, false, 0},
	{[]rune{0x26f5}, "sailboat", 5, 55, []string{"boat", "resort", "sailboat", "sailing", "sea", "yacht"}, false, 0},
	{[]rune{0x1f6f6}, "canoe", 5, 55, []string{"boat", "canoe"}, false, 0},
	{[]rune{0x1f6a4}, "speedboat", 5, 55, []string{"billionaire", "boat", "lake", "luxury", "millionaire", "speedboat", "summer", "travel"}, false, 0},
	{[]rune{0x1f6f3, 0xfe0f}, "passenger ship", 5, 55, []string{"passenger", "ship"}, false, 0},
	{[]rune{0x26f4, 0xfe0f}, "ferry", 5, 55, []string{"boat", "ferry", "passenger"}, false, 0},
	{[]rune{0x1f6e5, 0xfe0f}, "motor boat", 5, 55, []string{"boat", "motor", "motorboat"}, false, 0},
	{[]rune{0x1f6a2}, "ship", 5, 55, []string{"boat", "passenger", "ship", "travel"}, false, 0},
	{[]rune{0x2708, 0xfe0f}, "airplane", 5, 56, []string{"aeroplane", "airplane", "fly", "flying", "jet", "plane", "travel"}, false, 0},
	{[]rune{0x1f6e9, 0xfe0f}, "small airplane", 5, 56, []string{"aeroplane", "airplane", "plane", "small"}, false, 0},
	{[]rune{0x1f6eb}, "airplane departure", 5, 56, []string{"aeroplane", "airplane", "check-in", "departure", "departures", "plane"}, false, 0},
	{[]rune{0x1f6ec}, "airplane arrival", 5, 56, []string{"aeroplane", "airplane", "arrival", "arrivals", "arriving", "landing", "plane"}, false, 0},
	{[]rune{0x1fa82}, "parachute", 5, 56, []string{"hang-glide", "parachute", "parasail", "skydive"}, false, 0},
	{[]rune{0x1f4ba}, "seat", 5, 56, []string{"chair", "seat"}, false, 0},
	{[]rune{0x1f681}, "helicopter", 5, 56, []string{"copter", "helicopter", "roflcopter", "travel", "vehicle"}, false, 0},
	{[]rune{0x1f69f}, "suspension railway", 5, 56, []string{"railway", "suspension"}, false, 0},
	{[]rune{0x1f6a0}, "mountain cableway", 5, 56, []string{"cable", "cableway", "gondola", "lift", "mountain", "ski"}, false, 0},
	{[]rune{0x1f6a1}, "aerial tramway", 5, 56, []string{"aerial", "cable", "car", "gondola", "ropeway", "tramway"}, false, 0},
	{[]rune{0x1f6f0, 0xfe0f}, "satellite", 5, 56, []string{"satellite", "space"}, false, 0},
	{[]rune{0x1f680}, "rocket", 5, 56, []string{"launch", "rocket", "rockets", "space", "travel"}, false, 0},
	{[]rune{0x1f6f8}, "flying saucer", 5, 56, []string{"aliens", "extra", "flying", "saucer", "terrestrial", "UFO"}, false, 0},
	{[]rune{0x1f6ce, 0xfe0f}, "bellhop bell", 5, 57, []string{"bell", "bellhop", "hotel"}, false, 0},
	{[]rune{0x1f9f3}, "luggage", 5, 57, []string{"bag", "luggage", "packing", "roller", "suitcase", "travel"}, false, 0},
	{[]rune{0x231b}, "hourglass done", 5, 58, []string{"done", "hourglass", "sand", "time", "timer"}, false, 0},
	{[]rune{0x23f3}, "hourglass not done", 5, 58, []string{"done", "flowing", "hourglass", "hours", "not", "sand", "timer", "waiting", "yolo"}, false, 0},
	{[]rune{0x231a}, "watch", 5, 58, []string{"clock", "time", "watch"}, false, 0},
	{[]rune{0x23f0}, "alarm clock", 5, 58, []string{"alarm", "clock", "hours", "hrs", "late", "time", "waiting"}, false, 0},
	{[]rune{0x23f1, 0xfe0f}, "stopwatch", 5, 58, []string{"clock", "stopwatch", "time"}, false, 0},
	{[]rune{0x23f2, 0xfe0f}, "timer clock", 5, 58, []string{"clock", "timer"}, false, 0},
	{[]rune{0x1f570, 0xfe0f}, "mantelpiece clock", 5, 58, []string{"clock", "mantelpiece", "time"}, false, 0},
	{[]rune{0x1f55b}, "twelve o’clock", 5, 58, []string{"12", "12:00", "clock", "o’clock", "time", "twelve"}, false, 0},
	{[]rune{0x1f567}, "twelve-thirty", 5, 58, []string{"12", "12:30", "30", "clock", "thirty", "time", "twelve", "twelve-thirty"}, false, 0},
	{[]rune{0x1f550}, "one o’clock", 5, 58, []string{"1", "1:00", "clock", "o’clock", "one", "time"}, false, 0},
	{[]rune{0x1f55c}, "one-thirty", 5, 58, []string{"1", "1:30", "30", "clock", "one", "one-thirty", "thirty", "time"}, false, 0},
	{[]rune{0x1f551}, "two o’clock", 5, 58, []string{"2", "2:00", "clock", "o’clock", "time", "two"}, false, 0},
	{[]rune{0x1f55d}, "two-thirty", 5, 58, []string{"2", "2:30", "30", "clock", "thirty", "time", "two", "two-thirty"}, false, 0},
	{[]rune{0x1f552}, "three o’clock", 5, 58, []string{"3", "3:00", "clock", "o’clock", "three", "time"}, false, 0},
	{[]rune{0x1f55e}, "three-thirty", 5, 58, []string{"3", "3:30", "30", "clock", "thirty", "three", "three-thirty", "time"}, false, 0},
	{[]rune{0x1f553}, "four o’clock", 5, 58, []string{"4", "4:00", "clock", "four", "o’clock", "time"}, false, 0},
	{[]rune{0x1f55f}, "four-thirty", 5, 58, []string{"30", "4", "4:30", "clock", "four", "four-thirty", "thirty", "time"}, false, 0},
	{[]rune{0x1f554}, "five o’clock", 5, 58, []string{"5", "5:00", "clock", "five", "o’clock", "time"}, false, 0},
	{[]rune{0x1f560}, "five-thirty", 5, 58, []string{"30", "5", "5:30", "clock", "five", "five-thirty", "thirty", "time"}, false, 0},
	{[]rune{0x1f555}, "six o’clock", 5, 58, []string{"6", "6:00", "clock", "o’clock", "six", "time"}, false, 0},
	{[]rune{0x1f561}, "six-thirty", 5, 58, []string{"30", "6", "6:30", "clock", "six", "six-thirty", "thirty"}, false, 0},
	{[]rune{0x1f556}, "seven o’clock", 5, 58, []string{"0", "7", "7:00", "clock", "o’clock", "seven"}, false, 0},
	{[]rune{0x1f562}, "seven-thirty", 5, 58, []string{"30", "7", "7:30", "clock", "seven", "seven-thirty", "thirty"}, false, 0},
	{[]rune{0x1f557}, "eight o’clock", 5, 58, []string{"8", "8:00", "clock", "eight", "o’clock", "time"}, false, 0},
	{[]rune{0x1f563}, "eight-thirty", 5, 58, []string{"30", "8", "8:30", "clock", "eight", "eight-thirty", "thirty", "time"}, false, 0},
	{[]rune{0x1f558}, "nine o’clock", 5, 58, []string{"9", "9:00", "clock", "nine", "o’clock", "time"}, false, 0},
	{[]rune{0x1f564}, "nine-thirty", 5, 58, []string{"30", "9", "9:30", "clock", "nine", "nine-thirty", "thirty", "time"}, false, 0},
	{[]rune{0x1f559}, "ten o’clock", 5, 58, []string{"0", "10", "10:00", "clock", "o’clock", "ten"}, false, 0},
	{[]rune{0x1f565}, "ten-thirty", 5, 58, []string{"10", "10:30", "30", "clock", "ten", "ten-thirty", "thirty", "time"}, false, 0},
	{[]rune{0x1f55a}, "eleven o’clock", 5, 58, []string{"11", "11:00", "clock", "eleven", "o’clock", "time"}, false, 0},
	{[]rune{0x1f566}, "eleven-thirty", 5, 58, []string{"11", "11:30", "30", "clock", "eleven", "eleven-thirty", "thirty", "time"}, false, 0},
	{[]rune{0x1f311}, "new moon", 5, 59, []string{"dark", "moon", "new", "space"}, false, 0},
	{[]rune{0x1f312}, "waxing crescent moon", 5, 59, []string{"crescent", "dreams", "moon", "space", "waxing"}, false, 0},
	{[]rune{0x1f313}, "first quarter moon", 5, 59, []string{"first", "moon", "quarter", "space"}, false, 0},
	{[]rune{0x1f314}, "waxing gibbous moon", 5, 59, []string{"gibbous", "moon", "space", "waxing"}, false, 0},
	{[]rune{0x1f315}, "full moon", 5, 59, []string{"full", "moon", "space"}, false, 0},
	{[]rune{0x1f316}, "waning gibbous moon", 5, 59, []string{"gibbous", "moon", "space", "waning"}, false, 0},
	{[]rune{0x1f317}, "last quarter moon", 5, 59, []string{"last", "moon", "quarter", "space"}, false, 0},
	{[]rune{0x1f318}, "waning crescent moon", 5, 59, []string{"crescent", "moon", "space", "waning"}, false, 0},
	{[]rune{0x1f319}, "crescent moon", 5, 59, []string{"crescent", "moon", "ramadan", "space"}, false, 0},
	{[]rune{0x1f31a}, "new moon face", 5, 59, []string{"face", "moon", "new", "space"}, false, 0},
	{[]rune{0x1f31b}, "first quarter moon face", 5, 59, []string{"face", "first", "moon", "quarter", "space"}, false, 0},
	{[]rune{0x1f31c}, "last quarter moon face", 5, 59, []string{"dreams", "face", "last", "moon", "quarter"}, false, 0},
	{[]rune{0x1f321, 0xfe0f}, "thermometer", 5, 59, []string{"thermometer", "weather"}, false, 0},
	{[]rune{0x2600, 0xfe0f}, "sun", 5, 59, []string{"bright", "rays", "space", "sun", "sunny", "weather"}, false, 0},
	{[]rune{0x1f31d}, "full moon face", 5, 59, []string{"bright", "face", "full", "moon"}, false, 0},
	{[]rune{0x1f31e}, "sun with face", 5, 59, []string{"beach", "bright", "day", "face", "heat", "shine", "sun", "sunny", "sunshine", "weather"}, false, 0},
	{[]rune{0x1fa90}, "ringed planet", 5, 59, []string{"planet", "ringed", "saturn", "saturnine"}, false, 0},
	{[]rune{0x2b50}, "star", 5, 59, []string{"astronomy", "medium", "star", "stars", "white"}, false, 0},
	{[]rune{0x1f31f}, "glowing star", 5, 59, []string{"glittery", "glow", "glowing", "night", "shining", "sparkle", "star", "win"}, false, 0},
	{[]rune{0x1f320}, "shooting star", 5, 59, []string{"falling", "night", "shooting", "space", "star"}, false, 0},
	{[]rune{0x1f30c}, "milky way", 5, 59, []string{"milky", "space", "way"}, false, 0},
	{[]rune{0x2601, 0xfe0f}, "cloud", 5, 59, []string{"cloud", "weather"}, false, 0},
	{[]rune{0x26c5}, "sun behind cloud", 5, 59, []string{"behind", "cloud", "cloudy", "sun", "weather"}, false, 0},
	{[]rune{0x26c8, 0xfe0f}, "cloud with lightning and rain", 5, 59, []string{"cloud", "lightning", "rain", "thunder", "thunderstorm"}, false, 0},
	{[]rune{0x1f324, 0xfe0f}, "sun behind small cloud", 5, 59, []string{"behind", "cloud", "sun", "weather"}, false, 0},
	{[]rune{0x1f325, 0xfe0f}, "sun behind large cloud", 5, 59, []string{"behind", "cloud", "sun", "weather"}, false, 0},
	{[]rune{0x1f326, 0xfe0f}, "sun behind rain cloud", 5, 59, []string{"behind", "cloud", "rain", "sun", "weather"}, false, 0},
	{[]rune{0x1f327, 0xfe0f}, "cloud with rain", 5, 59, []string{"cloud", "rain", "weather"}, false, 0},
	{[]rune{0x1f328, 0xfe0f}, "cloud with snow", 5, 59, []string{"cloud", "cold", "snow", "weather"}, false, 0},
	{[]rune{0x1f329, 0xfe0f}, "cloud with lightning", 5, 59, []string{"cloud", "lightning", "weather"}, false, 0},
	{[]rune{0x1f32a, 0xfe0f}, "tornado", 5, 59, []string{"cloud", "tornado", "weather", "whirlwind"}, false, 0},
	{[]rune{0x1f32b, 0xfe0f}, "fog", 5, 59, []string{"cloud", "fog", "weather"}, false, 0},
	{[]rune{0x1f32c, 0xfe0f}, "wind face", 5, 59, []string{"blow", "cloud", "face", "wind"}, false, 0},
	{[]rune{0x1f300}, "cyclone", 5, 59, []string{"cyclone", "dizzy", "hurricane", "twister", "typhoon", "weather"}, false, 0},
	{[]rune{0x1f308}, "rainbow", 5, 59, []string{"gay", "genderqueer", "glbt", "glbtq", "lesbian", "lgbt", "lgbtq", "lgbtqia", "nature", "pride", "queer", "rain", "rainbow", "trans", "transgender", "weather"}, false, 0},
	{[]rune{0x1f302}, "closed umbrella", 5, 59, []string{"closed", "clothing", "rain", "umbrella"}, false, 0},
	{[]rune{0x2602, 0xfe0f}, "umbrella", 5, 59, []string{"clothing", "rain", "umbrella"}, false, 0},
	{[]rune{0x2614}, "umbrella with rain drops", 5, 59, []string{"clothing", "drop", "drops", "rain", "umbrella", "weather"}, false, 0},
	{[]rune{0x26f1, 0xfe0f}, "umbrella on ground", 5, 59, []string{"ground", "rain", "sun", "umbrella"}, false, 0},
	{[]rune{0x26a1}, "high voltage", 5, 59, []string{"danger", "electric", "electricity", "high", "lightning", "nature", "thunder", "thunderbolt", "voltage", "zap"}, false, 0},
	{[]rune{0x2744, 0xfe0f}, "snowflake", 5, 59, []string{"cold", "snow", "snowflake", "weather"}, false, 0},
	{[]rune{0x2603, 0xfe0f}, "snowman", 5, 59, []string{"cold", "man", "snow", "snowman"}, false, 0},
	{[]rune{0x26c4}, "snowman without snow", 5, 59, []string{"cold", "man", "snow", "snowman"}, false, 0},
	{[]rune{0x2604, 0xfe0f}, "comet", 5, 59, []string{"comet", "space"}, false, 0},
	{[]rune{0x1f525}, "fire", 5, 59, []string{"af", "burn", "fire", "flame", "hot", "lit", "litaf", "tool"}, false, 0},
	{[]rune{0x1f4a7}, "droplet", 5, 59, []string{"cold", "comic", "drop", "droplet", "nature", "sad", "sweat", "tear", "water", "weather"}, false, 0},
	{[]rune{0x1f30a}, "water wave", 5, 59, []string{"nature", "ocean", "surf", "surfer", "surfing", "water", "wave"}, false, 0},
	{[]rune{0x1f383}, "jack-o-lantern", 6, 60, []string{"celebration", "halloween", "jack", "jack-o-lantern", "lantern", "pumpkin"}, false, 0},
	{[]rune{0x1f384}, "Christmas tree", 6, 60, []string{"celebration", "Christmas", "tree"}, false, 0},
	{[]rune{0x1f386}, "fireworks", 6, 60, []string{"boom", "celebration", "entertainment", "fireworks", "yolo"}, false, 0},
	{[]rune{0x1f387}, "sparkler", 6, 60, []string{"boom", "celebration", "fireworks", "sparkle", "sparkler"}, false, 0},
	{[]rune{0x1f9e8}, "firecracker", 6, 60, []string{"dynamite", "explosive", "fire", "firecracker", "fireworks", "light", "pop", "popping", "spark"}, false, 0},
	{[]rune{0x2728}, "sparkles", 6, 60, []string{"*", "magic", "sparkle", "sparkles", "star"}, false, 0},
	{[]rune{0x1f388}, "balloon", 6, 60, []string{"balloon", "birthday", "celebrate", "celebration"}, false, 0},
	{[]rune{0x1f389}, "party popper", 6, 60, []string{"awesome", "birthday", "celebrate", "celebration", "excited", "hooray", "party", "popper", "tada", "woohoo"}, false, 0},
	{[]rune{0x1f38a}, "confetti ball", 6, 60, []string{"ball", "celebrate", "celebration", "confetti", "party", "woohoo"}, false, 0},
	{[]rune{0x1f38b}, "tanabata tree", 6, 60, []string{"banner", "celebration", "Japanese", "tanabata", "tree"}, false, 0},
	{[]rune{0x1f38d}, "pine decoration", 6, 60, []string{"bamboo", "celebration", "decoration", "Japanese", "pine", "plant"}, false, 0},
	{[]rune{0x1f38e}, "Japanese dolls", 6, 60, []string{"celebration", "doll", "dolls", "festival", "Japanese"}, false, 0},
	{[]rune{0x1f38f}, "carp streamer", 6, 60, []string{"carp", "celebration", "streamer"}, false, 0},
	{[]rune{0x1f390}, "wind chime", 6, 60, []string{"bell", "celebration", "chime", "wind"}, false, 0},
	{[]rune{0x1f391}, "moon viewing ceremony", 6, 60, []string{"celebration", "ceremony", "moon", "viewing"}, false, 0},
	{[]rune{0x1f9e7}, "red envelope", 6, 60, []string{"envelope", "gift", "good", "hóngbāo", "lai", "luck", "money", "red", "see"}, false, 0},
	{[]rune{0x1f380}, "ribbon", 6, 60, []string{"celebration", "ribbon"}, false, 0},
	{[]rune{0x1f381}, "wrapped gift", 6, 60, []string{"birthday", "bow", "box", "celebration", "christmas", "gift", "present", "surprise", "wrapped"}, false, 0},
	{[]rune{0x1f397, 0xfe0f}, "reminder ribbon", 6, 60, []string{"celebration", "reminder", "ribbon"}, false, 0},
	{[]rune{0x1f39f, 0xfe0f}, "admission tickets", 6, 60, []string{"admission", "ticket", "tickets"}, false, 0},
	{[]rune{0x1f3ab}, "ticket", 6, 60, []string{"admission", "stub", "ticket"}, false, 0},
	{[]rune{0x1f396, 0xfe0f}, "military medal", 6, 61, []string{"award", "celebration", "medal", "military"}, false, 0},
	{[]rune{0x1f3c6}, "trophy", 6, 61, []string{"champion", "champs", "prize", "slay", "sport", "trophy", "victory", "win", "winning"}, false, 0},
	{[]rune{0x1f3c5}, "sports medal", 6, 61, []string{"award", "gold", "medal", "sports", "winner"}, false, 0},
	{[]rune{0x1f947}, "1st place medal", 6, 61, []string{"1st", "first", "gold", "medal", "place"}, false, 0},
	{[]rune{0x1f948}, "2nd place medal", 6, 61, []string{"2nd", "medal", "place", "second", "silver"}, false, 0},
	{[]rune{0x1f949}, "3rd place medal", 6, 61, []string{"3rd", "bronze", "medal", "place", "third"}, false, 0},
	{[]rune{0x26bd}, "soccer ball", 6, 62, []string{"ball", "football", "futbol", "soccer", "sport"}, false, 0},
	{[]rune{0x26be}, "baseball", 6, 62, []string{"ball", "baseball", "sport"}, false, 0},
	{[]rune{0x1f94e}, "softball", 6, 62, []string{"ball", "glove", "softball", "sports", "underarm"}, false, 0},
	{[]rune{0x1f3c0}, "basketball", 6, 62, []string{"ball", "basketball", "hoop", "sport"}, false, 0},
	{[]rune{0x1f3d0}, "volleyball", 6, 62, []string{"ball", "game", "volleyball"}, false, 0},
	{[]rune{0x1f3c8}, "american football", 6, 62, []string{"american", "ball", "bowl", "football", "sport", "super"}, false, 0},
	{[]rune{0x1f3c9}, "rugby football", 6, 62, []string{"ball", "football", "rugby", "sport"}, false, 0},
	{[]rune{0x1f3be}, "tennis", 6, 62, []string{"ball", "racquet", "sport", "tennis"}, false, 0},
	{[]rune{0x1f94f}, "flying disc", 6, 62, []string{"disc", "flying", "ultimate"}, false, 0},
	{[]rune{0x1f3b3}, "bowling", 6, 62, []string{"ball", "bowling", "game", "sport", "strike"}, false, 0},
	{[]rune{0x1f3cf}, "cricket game", 6, 62, []string{"ball", "bat", "cricket", "game"}, false, 0},
	{[]rune{0x1f3d1}, "field hockey", 6, 62, []string{"ball", "field", "game", "hockey", "stick"}, false, 0},
	{[]rune{0x1f3d2}, "ice hockey", 6, 62, []string{"game", "hockey", "ice", "puck", "stick"}, false, 0},
	{[]rune{0x1f94d}, "lacrosse", 6, 62, []string{"ball", "goal", "lacrosse", "sports", "stick"}, false, 0},
	{[]rune{0x1f3d3}, "ping pong", 6, 62, []string{"ball", "bat", "game", "paddle", "ping", "pingpong", "pong", "table", "tennis"}, false, 0},
	{[]rune{0x1f3f8}, "badminton", 6, 62, []string{"badminton", "birdie", "game", "racquet", "shuttlecock"}, false, 0},
	{[]rune{0x1f94a}, "boxing glove", 6, 62, []string{"boxing", "glove"}, false, 0},
	{[]rune{0x1f94b}, "martial arts uniform", 6, 62, []string{"arts", "judo", "karate", "martial", "taekwondo", "uniform"}, false, 0},
	{[]rune{0x1f945}, "goal net", 6, 62, []string{"goal", "net"}, false, 0},
	{[]rune{0x26f3}, "flag in hole", 6, 62, []string{"flag", "golf", "hole", "sport"}, false, 0},
	{[]rune{0x26f8, 0xfe0f}, "ice skate", 6, 62, []string{"ice", "skate", "skating"}, false, 0},
	{[]rune{0x1f3a3}, "fishing pole", 6, 62, []string{"entertainment", "fish", "fishing", "pole", "sport"}, false, 0},
	{[]rune{0x1f93f}, "diving mask", 6, 62, []string{"diving", "mask", "scuba", "snorkeling"}, false, 0},
	{[]rune{0x1f3bd}, "running shirt", 6, 62, []string{"athletics", "running", "sash", "shirt"}, false, 0},
	{[]rune{0x1f3bf}, "skis", 6, 62, []string{"ski", "skis", "snow", "sport"}, false, 0},
	{[]rune{0x1f6f7}, "sled", 6, 62, []string{"luge", "sled", "sledge", "sleigh", "snow", "toboggan"}, false, 0},
	{[]rune{0x1f94c}, "curling stone", 6, 62, []string{"curling", "game", "rock", "stone"}, false, 0},
	{[]rune{0x1f3af}, "bullseye", 6, 63, []string{"bull", "bullseye", "dart", "direct", "entertainment", "game", "hit", "target"}, false, 0},
	{[]rune{0x1fa80}, "yo-yo", 6, 63, []string{"fluctuate", "toy", "yo-yo"}, false, 0},
	{[]rune{0x1fa81}, "kite", 6, 63, []string{"fly", "kite", "soar"}, false, 0},
	{[]rune{0x1f52b}, "water pistol", 6, 63, []string{"gun", "handgun", "pistol", "revolver", "tool", "water", "weapon"}, false, 0},
	{[]rune{0x1f3b1}, "pool 8 ball", 6, 63, []string{"8", "8ball", "ball", "billiard", "eight", "game", "pool"}, false, 0},
	{[]rune{0x1f52e}, "crystal ball", 6, 63, []string{"ball", "crystal", "fairy", "fairytale", "fantasy", "fortune", "future", "magic", "tale", "tool"}, false, 0},
	{[]rune{0x1fa84}, "magic wand", 6, 63, []string{"magic", "magician", "wand", "witch", "wizard"}, false, 0},
	{[]rune{0x1f3ae}, "video game", 6, 63, []string{"controller", "entertainment", "game", "video"}, false, 0},
	{[]rune{0x1f579, 0xfe0f}, "joystick", 6, 63, []string{"game", "joystick", "video", "videogame"}, false, 0},
	{[]rune{0x1f3b0}, "slot machine", 6, 63, []string{"casino", "gamble", "gambling", "game", "machine", "slot", "slots"}, false, 0},
	{[]rune{0x1f3b2}, "game die", 6, 63, []string{"dice", "die", "entertainment", "game"}, false, 0},
	{[]rune{0x1f9e9}, "puzzle piece", 6, 63, []string{"clue", "interlocking", "jigsaw", "piece", "puzzle"}, false, 0},
	{[]rune{0x1f9f8}, "teddy bear", 6, 63, []string{"bear", "plaything", "plush", "stuffed", "teddy", "toy"}, false, 0},
	{[]rune{0x1fa85}, "piñata", 6, 63, []string{"candy", "celebrate", "celebration", "cinco", "de", "festive", "mayo", "party", "pinada", "pinata", "piñata"}, false, 0},
	{[]rune{0x1faa9}, "mirror ball", 6, 63, []string{"ball", "dance", "disco", "glitter", "mirror", "party"}, false, 0},
	{[]rune{0x1fa86}, "nesting dolls", 6, 63, []string{"babooshka", "baboushka", "babushka", "doll", "dolls", "matryoshka", "nesting", "russia"}, false, 0},
	{[]rune{0x2660, 0xfe0f}, "spade suit", 6, 63, []string{"card", "game", "spade", "suit"}, false, 0},
	{[]rune{0x2665, 0xfe0f}, "heart suit", 6, 63, []string{"card", "emotion", "game", "heart", "hearts", "suit"}, false, 0},
	{[]rune{0x2666, 0xfe0f}, "diamond suit", 6, 63, []string{"card", "diamond", "game", "suit"}, false, 0},
	{[]rune{0x2663, 0xfe0f}, "club suit", 6, 63, []string{"card", "club", "clubs", "game", "suit"}, false, 0},
	{[]rune{0x265f, 0xfe0f}, "chess pawn", 6, 63, []string{"chess", "dupe", "expendable", "pawn"}, false, 0},
	{[]rune{0x1f0cf}, "joker", 6, 63, []string{"card", "game", "joker", "wildcard"}, false, 0},
	{[]rune{0x1f004}, "mahjong red dragon", 6, 63, []string{"dragon", "game", "mahjong", "red"}, false, 0},
	{[]rune{0x1f3b4}, "flower playing cards", 6, 63, []string{"card", "cards", "flower", "game", "Japanese", "playing"}, false, 0},
	{[]rune{0x1f3ad}, "performing arts", 6, 64, []string{"actor", "actress", "art", "arts", "entertainment", "mask", "performing", "theater", "theatre", "thespian"}, false, 0},
	{[]rune{0x1f5bc, 0xfe0f}, "framed picture", 6, 64, []string{"art", "frame", "framed", "museum", "painting", "picture"}, false, 0},
	{[]rune{0x1f3a8}, "artist palette", 6, 64, []string{"art", "artist", "artsy", "arty", "colorful", "creative", "entertainment", "museum", "painter", "painting", "palette"}, false, 0},
	{[]rune{0x1f9f5}, "thread", 6, 64, []string{"needle", "sewing", "spool", "string", "thread"}, false, 0},
	{[]rune{0x1faa1}, "sewing needle", 6, 64, []string{"embroidery", "needle", "sew", "sewing", "stitches", "sutures", "tailoring", "thread"}, false, 0},
	{[]rune{0x1f9f6}, "yarn", 6, 64, []string{"ball", "crochet", "knit", "yarn"}, false, 0},
	{[]rune{0x1faa2}, "knot", 6, 64, []string{"cord", "knot", "rope", "tangled", "tie", "twine", "twist"}, false, 0},
	{[]rune{0x1f453}, "glasses", 7, 65, []string{"clothing", "eye", "eyeglasses", "eyewear", "glasses"}, false, 0},
	{[]rune{0x1f576, 0xfe0f}, "sunglasses", 7, 65, []string{"dark", "eye", "eyewear", "glasses", "sunglasses"}, false, 0},
	{[]rune{0x1f97d}, "goggles", 7, 65, []string{"dive", "eye", "goggles", "protection", "scuba", "swimming", "welding"}, false, 0},
	{[]rune{0x1f97c}, "lab coat", 7, 65, []string{"clothes", "coat", "doctor", "dr", "experiment", "jacket", "lab", "scientist", "white"}, false, 0},
	{[]rune{0x1f9ba}, "safety vest", 7, 65, []string{"emergency", "safety", "vest"}, false, 0},
	{[]rune{0x1f454}, "necktie", 7, 65, []string{"clothing", "employed", "necktie", "serious", "shirt", "tie"}, false, 0},
	{[]rune{0x1f455}, "t-shirt", 7, 65, []string{"blue", "casual", "clothes", "clothing", "collar", "dressed", "shirt", "shopping", "t-shirt", "tshirt", "weekend"}, false, 0},
	{[]rune{0x1f456}, "jeans", 7, 65, []string{"blue", "casual", "clothes", "clothing", "denim", "dressed", "jeans", "pants", "shopping", "trousers", "weekend"}, false, 0},
	{[]rune{0x1f9e3}, "scarf", 7, 65, []string{"bundle", "cold", "neck", "scarf", "up"}, false, 0},
	{[]rune{0x1f9e4}, "gloves", 7, 65, []string{"gloves", "hand"}, false, 0},
	{[]rune{0x1f9e5}, "coat", 7, 65, []string{"brr", "bundle", "coat", "cold", "jacket", "up"}, false, 0},
	{[]rune{0x1f9e6}, "socks", 7, 65, []string{"socks", "stocking"}, false, 0},
	{[]rune{0x1f457}, "dress", 7, 65, []string{"clothes", "clothing", "dress", "dressed", "fancy", "shopping"}, false, 0},
	{[]rune{0x1f458}, "kimono", 7, 65, []string{"clothing", "comfortable", "kimono"}, false, 0},
	{[]rune{0x1f97b}, "sari", 7, 65, []string{"clothing", "dress", "sari"}, false, 0},
	{[]rune{0x1fa71}, "one-piece swimsuit", 7, 65, []string{"bathing", "one-piece", "suit", "swimsuit"}, false, 0},
	{[]rune{0x1fa72}, "briefs", 7, 65, []string{"bathing", "briefs", "one-piece", "suit", "swimsuit", "underwear"}, false, 0},
	{[]rune{0x1fa73}, "shorts", 7, 65, []string{"bathing", "pants", "shorts", "suit", "swimsuit", "underwear"}, false, 0},
	{[]rune{0x1f459}, "bikini", 7, 65, []string{"bathing", "beach", "bikini", "clothing", "pool", "suit", "swim"}, false, 0},
	{[]rune{0x1f45a}, "woman’s clothes", 7, 65, []string{"blouse", "clothes", "clothing", "collar", "dress", "dressed", "lady", "shirt", "shopping", "woman", "woman’s"}, false, 0},
	{[]rune{0x1faad}, "folding hand fan", 7, 65, []string{"clack", "clap", "cool", "cooling", "dance", "fan", "flirt", "flutter", "folding", "hand", "hot", "shy"}, false, 0},
	{[]rune{0x1f45b}, "purse", 7, 65, []string{"clothes", "clothing", "coin", "dress", "fancy", "handbag", "purse", "shopping"}, false, 0},
	{[]rune{0x1f45c}, "handbag", 7, 65, []string{"bag", "clothes", "clothing", "dress", "handbag", "lady", "purse", "shopping"}, false, 0},
	{[]rune{0x1f45d}, "clutch bag", 7, 65, []string{"bag", "clothes", "clothing", "clutch", "dress", "handbag", "pouch", "purse"}, false, 0},
	{[]rune{0x1f6cd, 0xfe0f}, "shopping bags", 7, 65, []string{"bag", "bags", "hotel", "shopping"}, false, 0},
	{[]rune{0x1f392}, "backpack", 7, 65, []string{"backpack", "backpacking", "bag", "bookbag", "education", "rucksack", "satchel", "school"}, false, 0},
	{[]rune{0x1fa74}, "thong sandal", 7, 65, []string{"beach", "flip", "flop", "sandal", "sandals", "shoe", "thong", "thongs", "zōri"}, false, 0},
	{[]rune{0x1f45e}, "man’s shoe", 7, 65, []string{"brown", "clothes", "clothing", "feet", "foot", "kick", "man", "man’s", "shoe", "shoes", "shopping"}, false, 0},
	{[]rune{0x1f45f}, "running shoe", 7, 65, []string{"athletic", "clothes", "clothing", "fast", "kick", "running", "shoe", "shoes", "shopping", "sneaker", "tennis"}, false, 0},
	{[]rune{0x1f97e}, "hiking boot", 7, 65, []string{"backpacking", "boot", "brown", "camping", "hiking", "outdoors", "shoe"}, false, 0},
	{[]rune{0x1f97f}, "flat shoe", 7, 65, []string{"ballet", "comfy", "flat", "flats", "shoe", "slip-on", "slipper"}, false, 0},
	{[]rune{0x1f460}, "high-heeled shoe", 7, 65, []string{"clothes", "clothing", "dress", "fashion", "heel", "heels", "high-heeled", "shoe", "shoes", "shopping", "stiletto", "woman"}, false, 0},
	{[]rune{0x1f461}, "woman’s sandal", 7, 65, []string{"clothing", "sandal", "shoe", "woman", "woman’s"}, false, 0},
	{[]rune{0x1fa70}, "ballet shoes", 7, 65, []string{"ballet", "dance", "shoes"}, false, 0},
	{[]rune{0x1f462}, "woman’s boot", 7, 65, []string{"boot", "clothes", "clothing", "dress", "shoe", "shoes", "shopping", "woman", "woman’s"}, false, 0},
	{[]rune{0x1faae}, "hair pick", 7, 65, []string{"Afro", "comb", "groom", "hair", "pick"}, false, 0},
	{[]rune{0x1f451}, "crown", 7, 65, []string{"clothing", "crown", "family", "king", "medieval", "queen", "royal", "royalty", "win"}, false, 0},
	{[]rune{0x1f452}, "woman’s hat", 7, 65, []string{"clothes", "clothing", "garden", "hat", "hats", "party", "woman", "woman’s"}, false, 0},
	{[]rune{0x1f3a9}, "top hat", 7, 65, []string{"clothes", "clothing", "fancy", "formal", "hat", "magic", "top", "tophat"}, false, 0},
	{[]rune{0x1f393}, "graduation cap", 7, 65, []string{"cap", "celebration", "clothing", "education", "graduation", "hat", "scholar"}, false, 0},
	{[]rune{0x1f9e2}, "billed cap", 7, 65, []string{"baseball", "bent", "billed", "cap", "dad", "hat"}, false, 0},
	{[]rune{0x1fa96}, "military helmet", 7, 65, []string{"army", "helmet", "military", "soldier", "war", "warrior"}, false, 0},
	{[]rune{0x26d1, 0xfe0f}, "rescue worker’s helmet", 7, 65, []string{"aid", "cross", "face", "hat", "helmet", "rescue", "worker’s"}, false, 0},
	{[]rune{0x1f4ff}, "prayer beads", 7, 65, []string{"beads", "clothing", "necklace", "prayer", "religion"}, false, 0},
	{[]rune{0x1f484}, "lipstick", 7, 65, []string{"cosmetics", "date", "lipstick", "makeup"}, false, 0},
	{[]rune{0x1f48d}, "ring", 7, 65, []string{"diamond", "engaged", "engagement", "married", "ring", "romance", "shiny", "sparkling", "wedding"}, false, 0},
	{[]rune{0x1f48e}, "gem stone", 7, 65, []string{"diamond", "engagement", "gem", "jewel", "money", "romance", "stone", "wedding"}, false, 0},
	{[]rune{0x1f507}, "muted speaker", 7, 66, []string{"mute", "muted", "quiet", "silent", "sound", "speaker"}, false, 0},
	{[]rune{0x1f508}, "speaker low volume", 7, 66, []string{"low", "soft", "sound", "speaker", "volume"}, false, 0},
	{[]rune{0x1f509}, "speaker medium volume", 7, 66, []string{"medium", "sound", "speaker", "volume"}, false, 0},
	{[]rune{0x1f50a}, "speaker high volume", 7, 66, []string{"high", "loud", "music", "sound", "speaker", "volume"}, false, 0},
	{[]rune{0x1f4e2}, "loudspeaker", 7, 66, []string{"address", "communication", "loud", "loudspeaker", "public", "sound"}, false, 0},
	{[]rune{0x1f4e3}, "megaphone", 7, 66, []string{"cheering", "megaphone", "sound"}, false, 0},
	{[]rune{0x1f4ef}, "postal horn", 7, 66, []string{"horn", "post", "postal"}, false, 0},
	{[]rune{0x1f514}, "bell", 7, 66, []string{"bell", "break", "church", "sound"}, false, 0},
	{[]rune{0x1f515}, "bell with slash", 7, 66, []string{"bell", "forbidden", "mute", "no", "not", "prohibited", "quiet", "silent", "slash", "sound"}, false, 0},
	{[]rune{0x1f3bc}, "musical score", 7, 67, []string{"music", "musical", "note", "score"}, false, 0},
	{[]rune{0x1f3b5}, "musical note", 7, 67, []string{"music", "musical", "note", "sound"}, false, 0},
	{[]rune{0x1f3b6}, "musical notes", 7, 67, []string{"music", "musical", "note", "notes", "sound"}, false, 0},
	{[]rune{0x1f399, 0xfe0f}, "studio microphone", 7, 67, []string{"mic", "microphone", "music", "studio"}, false, 0},
	{[]rune{0x1f39a, 0xfe0f}, "level slider", 7, 67, []string{"level", "music", "slider"}, false, 0},
	{[]rune{0x1f39b, 0xfe0f}, "control knobs", 7, 67, []string{"control", "knobs", "music"}, false, 0},
	{[]rune{0x1f3a4}, "microphone", 7, 67, []string{"karaoke", "mic", "microphone", "music", "sing", "sound"}, false, 0},
	{[]rune{0x1f3a7}, "headphone", 7, 67, []string{"earbud", "headphone", "sound"}, false, 0},
	{[]rune{0x1f4fb}, "radio", 7, 67, []string{"entertainment", "radio", "tbt", "video"}, false, 0},
	{[]rune{0x1f3b7}, "saxophone", 7, 68, []string{"instrument", "music", "sax", "saxophone"}, false, 0},
	{[]rune{0x1f3ba}, "trumpet", 7, 68, []string{"instrument", "music", "trumpet"}, false, 0},
	{[]rune{0x1fa8a}, "trombone", 7, 68, []string{"brass", "instrument", "jazz", "music", "sad", "slide"}, false, 0},
	{[]rune{0x1fa97}, "accordion", 7, 68, []string{"accordion", "box", "concertina", "instrument", "music", "squeeze", "squeezebox"}, false, 0},
	{[]rune{0x1f3b8}, "guitar", 7, 68, []string{"guitar", "instrument", "music", "strat"}, false, 0},
	{[]rune{0x1f3b9}, "musical keyboard", 7, 68, []string{"instrument", "keyboard", "music", "musical", "piano"}, false, 0},
	{[]rune{0x1f3bb}, "violin", 7, 68, []string{"instrument", "music", "violin"}, false, 0},
	{[]rune{0x1fa95}, "banjo", 7, 68, []string{"banjo", "music", "stringed"}, false, 0},
	{[]rune{0x1f941}, "drum", 7, 68, []string{"drum", "drumsticks", "music"}, false, 0},
	{[]rune{0x1fa98}, "long drum", 7, 68, []string{"beat", "conga", "drum", "instrument", "long", "rhythm"}, false, 0},
	{[]rune{0x1fa87}, "maracas", 7, 68, []string{"cha", "dance", "instrument", "maracas", "music", "party", "percussion", "rattle", "shake", "shaker"}, false, 0},
	{[]rune{0x1fa88}, "flute", 7, 68, []string{"band", "fife", "flautist", "flute", "instrument", "marching", "music", "orchestra", "piccolo", "pipe", "recorder", "woodwind"}, false, 0},
	{[]rune{0x1fa89}, "harp", 7, 68, []string{"cupid", "harp", "instrument", "love", "music", "orchestra"}, false, 0},
	{[]rune{0x1f4f1}, "mobile phone", 7, 69, []string{"cell", "communication", "mobile", "phone", "telephone"}, false, 0},
	{[]rune{0x1f4f2}, "mobile phone with arrow", 7, 69, []string{"arrow", "build", "call", "cell", "communication", "mobile", "phone", "receive", "telephone"}, false, 0},
	{[]rune{0x260e, 0xfe0f}, "telephone", 7, 69, []string{"phone", "telephone"}, false, 0},
	{[]rune{0x1f4de}, "telephone receiver", 7, 69, []string{"communication", "phone", "receiver", "telephone", "voip"}, false, 0},
	{[]rune{0x1f4df}, "pager", 7, 69, []string{"communication", "pager"}, false, 0},
	{[]rune{0x1f4e0}, "fax machine", 7, 69, []string{"communication", "fax", "machine"}, false, 0},
	{[]rune{0x1f50b}, "battery", 7, 70, []string{"battery"}, false, 0},
	{[]rune{0x1faab}, "low battery", 7, 70, []string{"battery", "drained", "electronic", "energy", "low", "power"}, false, 0},
	{[]rune{0x1f50c}, "electric plug", 7, 70, []string{"electric", "electricity", "plug"}, false, 0},
	{[]rune{0x1f4bb}, "laptop", 7, 70, []string{"computer", "laptop", "office", "pc", "personal"}, false, 0},
	{[]rune{0x1f5a5, 0xfe0f}, "desktop computer", 7, 70, []string{"computer", "desktop", "monitor"}, false, 0},
	{[]rune{0x1f5a8, 0xfe0f}, "printer", 7, 70, []string{"computer", "printer"}, false, 0},
	{[]rune{0x2328, 0xfe0f}, "keyboard", 7, 70, []string{"computer", "keyboard"}, false, 0},
	{[]rune{0x1f5b1, 0xfe0f}, "computer mouse", 7, 70, []string{"computer", "mouse"}, false, 0},
	{[]rune{0x1f5b2, 0xfe0f}, "trackball", 7, 70, []string{"computer", "trackball"}, false, 0},
	{[]rune{0x1f4bd}, "computer disk", 7, 70, []string{"computer", "disk", "minidisk", "optical"}, false, 0},
	{[]rune{0x1f4be}, "floppy disk", 7, 70, []string{"computer", "disk", "floppy"}, false, 0},
	{[]rune{0x1f4bf}, "optical disk", 7, 70, []string{"blu-ray", "CD", "computer", "disk", "dvd", "optical"}, false, 0},
	{[]rune{0x1f4c0}, "dvd", 7, 70, []string{"Blu-ray", "cd", "computer", "disk", "DVD", "optical"}, false, 0},
	{[]rune{0x1f9ee}, "abacus", 7, 70, []string{"abacus", "calculation", "calculator"}, false, 0},
	{[]rune{0x1f3a5}, "movie camera", 7, 71, []string{"bollywood", "camera", "cinema", "film", "hollywood", "movie", "record"}, false, 0},
	{[]rune{0x1f39e, 0xfe0f}, "film frames", 7, 71, []string{"cinema", "film", "frames", "movie"}, false, 0},
	{[]rune{0x1f4fd, 0xfe0f}, "film projector", 7, 71, []string{"cinema", "film", "movie", "projector", "video"}, false, 0},
	{[]rune{0x1f3ac}, "clapper board", 7, 71, []string{"action", "board", "clapper", "movie"}, false, 0},
	{[]rune{0x1f4fa}, "television", 7, 71, []string{"television", "tv", "video"}, false, 0},
	{[]rune{0x1f4f7}, "camera", 7, 71, []string{"camera", "photo", "selfie", "snap", "tbt", "trip", "video"}, false, 0},
	{[]rune{0x1f4f8}, "camera with flash", 7, 71, []string{"camera", "flash", "video"}, false, 0},
	{[]rune{0x1f4f9}, "video camera", 7, 71, []string{"camcorder", "camera", "tbt", "video"}, false, 0},
	{[]rune{0x1f4fc}, "videocassette", 7, 71, []string{"old", "school", "tape", "vcr", "vhs", "video", "videocassette"}, false, 0},
	{[]rune{0x1f50d}, "magnifying glass tilted left", 7, 71, []string{"glass", "lab", "left", "left-pointing", "magnifying", "science", "search", "tilted", "tool"}, false, 0},
	{[]rune{0x1f50e}, "magnifying glass tilted right", 7, 71, []string{"contact", "glass", "lab", "magnifying", "right", "right-pointing", "science", "search", "tilted", "tool"}, false, 0},
	{[]rune{0x1f56f, 0xfe0f}, "candle", 7, 71, []string{"candle", "light"}, false, 0},
	{[]rune{0x1f4a1}, "light bulb", 7, 71, []string{"bulb", "comic", "electric", "idea", "light"}, false, 0},
	{[]rune{0x1f526}, "flashlight", 7, 71, []string{"electric", "flashlight", "light", "tool", "torch"}, false, 0},
	{[]rune{0x1f3ee}, "red paper lantern", 7, 71, []string{"bar", "lantern", "light", "paper", "red", "restaurant"}, false, 0},
	{[]rune{0x1fa94}, "diya lamp", 7, 71, []string{"diya", "lamp", "light", "oil"}, false, 0},
	{[]rune{0x1f4d4}, "notebook with decorative cover", 7, 72, []string{"book", "cover", "decorated", "decorative", "education", "notebook", "school", "writing"}, false, 0},
	{[]rune{0x1f4d5}, "closed book", 7, 72, []string{"book", "closed", "education"}, false, 0},
	{[]rune{0x1f4d6}, "open book", 7, 72, []string{"book", "education", "fantasy", "knowledge", "library", "novels", "open", "reading"}, false, 0},
	{[]rune{0x1f4d7}, "green book", 7, 72, []string{"book", "education", "fantasy", "green", "library", "reading"}, false, 0},
	{[]rune{0x1f4d8}, "blue book", 7, 72, []string{"blue", "book", "education", "fantasy", "library", "reading"}, false, 0},
	{[]rune{0x1f4d9}, "orange book", 7, 72, []string{"book", "education", "fantasy", "library", "orange", "reading"}, false, 0},
	{[]rune{0x1f4da}, "books", 7, 72, []string{"book", "books", "education", "fantasy", "knowledge", "library", "novels", "reading", "school", "study"}, false, 0},
	{[]rune{0x1f4d3}, "notebook", 7, 72, []string{"notebook"}, false, 0},
	{[]rune{0x1f4d2}, "ledger", 7, 72, []string{"ledger", "notebook"}, false, 0},
	{[]rune{0x1f4c3}, "page with curl", 7, 72, []string{"curl", "document", "page", "paper"}, false, 0},
	{[]rune{0x1f4dc}, "scroll", 7, 72, []string{"paper", "scroll"}, false, 0},
	{[]rune{0x1f4c4}, "page facing up", 7, 72, []string{"document", "facing", "page", "paper", "up"}, false, 0},
	{[]rune{0x1f4f0}, "newspaper", 7, 72, []string{"communication", "news", "newspaper", "paper"}, false, 0},
	{[]rune{0x1f5de, 0xfe0f}, "rolled-up newspaper", 7, 72, []string{"news", "newspaper", "paper", "rolled", "rolled-up"}, false, 0},
	{[]rune{0x1f4d1}, "bookmark tabs", 7, 72, []string{"bookmark", "mark", "marker", "tabs"}, false, 0},
	{[]rune{0x1f516}, "bookmark", 7, 72, []string{"bookmark", "mark"}, false, 0},
	{[]rune{0x1f3f7, 0xfe0f}, "label", 7, 72, []string{"label", "tag"}, false, 0},
	{[]rune{0x1fa99}, "coin", 7, 73, []string{"coin", "dollar", "euro", "gold", "metal", "money", "rich", "silver", "treasure"}, false, 0},
	{[]rune{0x1f4b0}, "money bag", 7, 73, []string{"bag", "bank", "bet", "billion", "cash", "cost", "dollar", "gold", "million", "money", "moneybag", "paid", "paying", "pot", "rich", "win"}, false, 0},
	{[]rune{0x1fa8e}, "treasure chest", 7, 73, []string{"gem", "gold", "jewels", "loot", "money", "prize", "silver", "valuables", "wealth"}, false, 0},
	{[]rune{0x1f4b4}, "yen banknote", 7, 73, []string{"bank", "banknote", "bill", "currency", "money", "note", "yen"}, false, 0},
	{[]rune{0x1f4b5}, "dollar banknote", 7, 73, []string{"bank", "banknote", "bill", "currency", "dollar", "money", "note"}, false, 0},
	{[]rune{0x1f4b6}, "euro banknote", 7, 73, []string{"100", "bank", "banknote", "bill", "currency", "euro", "money", "note", "rich"}, false, 0},
	{[]rune{0x1f4b7}, "pound banknote", 7, 73, []string{"bank", "banknote", "bill", "billion", "cash", "currency", "money", "note", "pound", "pounds"}, false, 0},
	{[]rune{0x1f4b8}, "money with wings", 7, 73, []string{"bank", "banknote", "bill", "billion", "cash", "dollar", "fly", "million", "money", "note", "pay", "wings"}, false, 0},
	{[]rune{0x1f4b3}, "credit card", 7, 73, []string{"bank", "card", "cash", "charge", "credit", "money", "pay"}, false, 0},
	{[]rune{0x1f9fe}, "receipt", 7, 73, []string{"accounting", "bookkeeping", "evidence", "invoice", "proof", "receipt"}, false, 0},
	{[]rune{0x1f4b9}, "chart increasing with yen", 7, 73, []string{"bank", "chart", "currency", "graph", "growth", "increasing", "market", "money", "rise", "trend", "upward", "yen"}, false, 0},
	{[]rune{0x2709, 0xfe0f}, "envelope", 7, 74, []string{"e-mail", "email", "envelope", "letter"}, false, 0},
	{[]rune{0x1f4e7}, "e-mail", 7, 74, []string{"e-mail", "email", "letter", "mail"}, false, 0},
	{[]rune{0x1f4e8}, "incoming envelope", 7, 74, []string{"delivering", "e-mail", "email", "envelope", "incoming", "letter", "mail", "receive", "sent"}, false, 0},
	{[]rune{0x1f4e9}, "envelope with arrow", 7, 74, []string{"arrow", "communication", "down", "e-mail", "email", "envelope", "letter", "mail", "outgoing", "send", "sent"}, false, 0},
	{[]rune{0x1f4e4}, "outbox tray", 7, 74, []string{"box", "email", "letter", "mail", "outbox", "sent", "tray"}, false, 0},
	{[]rune{0x1f4e5}, "inbox tray", 7, 74, []string{"box", "email", "inbox", "letter", "mail", "receive", "tray", "zero"}, false, 0},
	{[]rune{0x1f4e6}, "package", 7, 74, []string{"box", "communication", "delivery", "package", "parcel", "shipping"}, false, 0},
	{[]rune{0x1f4eb}, "closed mailbox with raised flag", 7, 74, []string{"closed", "communication", "flag", "mail", "mailbox", "postbox", "raised"}, false, 0},
	{[]rune{0x1f4ea}, "closed mailbox with lowered flag", 7, 74, []string{"closed", "flag", "lowered", "mail", "mailbox", "postbox"}, false, 0},
	{[]rune{0x1f4ec}, "open mailbox with raised flag", 7, 74, []string{"flag", "mail", "mailbox", "open", "postbox", "raised"}, false, 0},
	{[]rune{0x1f4ed}, "open mailbox with lowered flag", 7, 74, []string{"flag", "lowered", "mail", "mailbox", "open", "postbox"}, false, 0},
	{[]rune{0x1f4ee}, "postbox", 7, 74, []string{"mail", "mailbox", "postbox"}, false, 0},
	{[]rune{0x1f5f3, 0xfe0f}, "ballot box with ballot", 7, 74, []string{"ballot", "box"}, false, 0},
	{[]rune{0x270f, 0xfe0f}, "pencil", 7, 75, []string{"pencil"}, false, 0},
	{[]rune{0x2712, 0xfe0f}, "black nib", 7, 75, []string{"black", "nib", "pen"}, false, 0},
	{[]rune{0x1f58b, 0xfe0f}, "fountain pen", 7, 75, []string{"fountain", "pen"}, false, 0},
	{[]rune{0x1f58a, 0xfe0f}, "pen", 7, 75, []string{"ballpoint", "pen"}, false, 0},
	{[]rune{0x1f58c, 0xfe0f}, "paintbrush", 7, 75, []string{"paintbrush", "painting"}, false, 0},
	{[]rune{0x1f58d, 0xfe0f}, "crayon", 7, 75, []string{"crayon"}, false, 0},
	{[]rune{0x1f4dd}, "memo", 7, 75, []string{"communication", "media", "memo", "notes", "pencil"}, false, 0},
	{[]rune{0x1f4bc}, "briefcase", 7, 76, []string{"briefcase", "office"}, false, 0},
	{[]rune{0x1f4c1}, "file folder", 7, 76, []string{"file", "folder"}, false, 0},
	{[]rune{0x1f4c2}, "open file folder", 7, 76, []string{"file", "folder", "open"}, false, 0},
	{[]rune{0x1f5c2, 0xfe0f}, "card index dividers", 7, 76, []string{"card", "dividers", "index"}, false, 0},
	{[]rune{0x1f4c5}, "calendar", 7, 76, []string{"calendar", "date"}, false, 0},
	{[]rune{0x1f4c6}, "tear-off calendar", 7, 76, []string{"calendar", "tear-off"}, false, 0},
	{[]rune{0x1f5d2, 0xfe0f}, "spiral notepad", 7, 76, []string{"note", "notepad", "pad", "spiral"}, false, 0},
	{[]rune{0x1f5d3, 0xfe0f}, "spiral calendar", 7, 76, []string{"calendar", "pad", "spiral"}, false, 0},
	{[]rune{0x1f4c7}, "card index", 7, 76, []string{"card", "index", "old", "rolodex", "school"}, false, 0},
	{[]rune{0x1f4c8}, "chart increasing", 7, 76, []string{"chart", "data", "graph", "growth", "increasing", "right", "trend", "up", "upward"}, false, 0},
	{[]rune{0x1f4c9}, "chart decreasing", 7, 76, []string{"chart", "data", "decreasing", "down", "downward", "graph", "negative", "trend"}, false, 0},
	{[]rune{0x1f4ca}, "bar chart", 7, 76, []string{"bar", "chart", "data", "graph"}, false, 0},
	{[]rune{0x1f4cb}, "clipboard", 7, 76, []string{"clipboard", "do", "list", "notes"}, false, 0},
	{[]rune{0x1f4cc}, "pushpin", 7, 76, []string{"collage", "pin", "pushpin"}, false, 0},
	{[]rune{0x1f4cd}, "round pushpin", 7, 76, []string{"location", "map", "pin", "pushpin", "round"}, false, 0},
	{[]rune{0x1f4ce}, "paperclip", 7, 76, []string{"paperclip"}, false, 0},
	{[]rune{0x1f587, 0xfe0f}, "linked paperclips", 7, 76, []string{"link", "linked", "paperclip", "paperclips"}, false, 0},
	{[]rune{0x1f4cf}, "straight ruler", 7, 76, []string{"angle", "edge", "math", "ruler", "straight", "straightedge"}, false, 0},
	{[]rune{0x1f4d0}, "triangular ruler", 7, 76, []string{"angle", "math", "rule", "ruler", "set", "slide", "triangle", "triangular"}, false, 0},
	{[]rune{0x2702, 0xfe0f}, "scissors", 7, 76, []string{"cut", "cutting", "paper", "scissors", "tool"}, false, 0},
	{[]rune{0x1f5c3, 0xfe0f}, "card file box", 7, 76, []string{"box", "card", "file"}, false, 0},
	{[]rune{0x1f5c4, 0xfe0f}, "file cabinet", 7, 76, []string{"cabinet", "file", "filing", "paper"}, false, 0},
	{[]rune{0x1f5d1, 0xfe0f}, "wastebasket", 7, 76, []string{"can", "garbage", "trash", "waste", "wastebasket"}, false, 0},
	{[]rune{0x1f512}, "locked", 7, 77, []string{"closed", "lock", "locked", "private"}, false, 0},
	{[]rune{0x1f513}, "unlocked", 7, 77, []string{"cracked", "lock", "open", "unlock", "unlocked"}, false, 0},
	{[]rune{0x1f50f}, "locked with pen", 7, 77, []string{"ink", "lock", "locked", "nib", "pen", "privacy"}, false, 0},
	{[]rune{0x1f510}, "locked with key", 7, 77, []string{"bike", "closed", "key", "lock", "locked", "secure"}, false, 0},
	{[]rune{0x1f511}, "key", 7, 77, []string{"key", "keys", "lock", "major", "password", "unlock"}, false, 0},
	{[]rune{0x1f5dd, 0xfe0f}, "old key", 7, 77, []string{"clue", "key", "lock", "old"}, false, 0},
	{[]rune{0x1f528}, "hammer", 7, 78, []string{"hammer", "home", "improvement", "repairs", "tool"}, false, 0},
	{[]rune{0x1fa93}, "axe", 7, 78, []string{"ax", "axe", "chop", "hatchet", "split", "wood"}, false, 0},
	{[]rune{0x26cf, 0xfe0f}, "pick", 7, 78, []string{"hammer", "mining", "pick", "tool"}, false, 0},
	{[]rune{0x2692, 0xfe0f}, "hammer and pick", 7, 78, []string{"hammer", "pick", "tool"}, false, 0},
	{[]rune{0x1f6e0, 0xfe0f}, "hammer and wrench", 7, 78, []string{"hammer", "spanner", "tool", "wrench"}, false, 0},
	{[]rune{0x1f5e1, 0xfe0f}, "dagger", 7, 78, []string{"dagger", "knife", "weapon"}, false, 0},
	{[]rune{0x2694, 0xfe0f}, "crossed swords", 7, 78, []string{"crossed", "swords", "weapon"}, false, 0},
	{[]rune{0x1f4a3}, "bomb", 7, 78, []string{"bomb", "boom", "comic", "dangerous", "explosion", "hot"}, false, 0},
	{[]rune{0x1fa83}, "boomerang", 7, 78, []string{"boomerang", "rebound", "repercussion", "weapon"}, false, 0},
	{[]rune{0x1f3f9}, "bow and arrow", 7, 78, []string{"archer", "archery", "arrow", "bow", "Sagittarius", "tool", "weapon", "zodiac"}, false, 0},
	{[]rune{0x1f6e1, 0xfe0f}, "shield", 7, 78, []string{"shield", "weapon"}, false, 0},
	{[]rune{0x1fa9a}, "carpentry saw", 7, 78, []string{"carpenter", "carpentry", "cut", "lumber", "saw", "tool", "trim"}, false, 0},
	{[]rune{0x1f527}, "wrench", 7, 78, []string{"home", "improvement", "spanner", "tool", "wrench"}, false, 0},
	{[]rune{0x1fa9b}, "screwdriver", 7, 78, []string{"flathead", "handy", "screw", "screwdriver", "tool"}, false, 0},
	{[]rune{0x1f529}, "nut and bolt", 7, 78, []string{"bolt", "home", "improvement", "nut", "tool"}, false, 0},
	{[]rune{0x2699, 0xfe0f}, "gear", 7, 78, []string{"cog", "cogwheel", "gear", "tool"}, false, 0},
	{[]rune{0x1f5dc, 0xfe0f}, "clamp", 7, 78, []string{"clamp", "compress", "tool", "vice"}, false, 0},
	{[]rune{0x2696, 0xfe0f}, "balance scale", 7, 78, []string{"balance", "justice", "Libra", "scale", "scales", "tool", "weight", "zodiac"}, false, 0},
	{[]rune{0x1f9af}, "white cane", 7, 78, []string{"accessibility", "blind", "cane", "probing", "white"}, false, 0},
	{[]rune{0x1f517}, "link", 7, 78, []string{"link", "links"}, false, 0},
	{[]rune{0x26d3, 0xfe0f, 0x1f4a5}, "broken chain", 7, 78, []string{"break", "breaking", "broken", "chain", "cuffs", "freedom"}, false, 0},
	{[]rune{0x26d3, 0xfe0f}, "chains", 7, 78, []string{"chain", "chains"}, false, 0},
	{[]rune{0x1fa9d}, "hook", 7, 78, []string{"catch", "crook", "curve", "ensnare", "hook", "point", "selling"}, false, 0},
	{[]rune{0x1f9f0}, "toolbox", 7, 78, []string{"box", "chest", "mechanic", "red", "tool", "toolbox"}, false, 0},
	{[]rune{0x1f9f2}, "magnet", 7, 78, []string{"attraction", "horseshoe", "magnet", "magnetic", "negative", "positive", "shape", "u"}, false, 0},
	{[]rune{0x1fa9c}, "ladder", 7, 78, []string{"climb", "ladder", "rung", "step"}, false, 0},
	{[]rune{0x1fa8f}, "shovel", 7, 78, []string{"bury", "dig", "garden", "hole", "plant", "scoop", "shovel", "snow", "spade"}, false, 0},
	{[]rune{0x2697, 0xfe0f}, "alembic", 7, 79, []string{"alembic", "chemistry", "tool"}, false, 0},
	{[]rune{0x1f9ea}, "test tube", 7, 79, []string{"chemist", "chemistry", "experiment", "lab", "science", "test", "tube"}, false, 0},
	{[]rune{0x1f9eb}, "petri dish", 7, 79, []string{"bacteria", "biologist", "biology", "culture", "dish", "lab", "petri"}, false, 0},
	{[]rune{0x1f9ec}, "dna", 7, 79, []string{"biologist", "dna", "evolution", "gene", "genetics", "life"}, false, 0},
	{[]rune{0x1f52c}, "microscope", 7, 79, []string{"experiment", "lab", "microscope", "science", "tool"}, false, 0},
	{[]rune{0x1f52d}, "telescope", 7, 79, []string{"contact", "extraterrestrial", "science", "telescope", "tool"}, false, 0},
	{[]rune{0x1f4e1}, "satellite antenna", 7, 79, []string{"aliens", "antenna", "contact", "dish", "satellite", "science"}, false, 0},
	{[]rune{0x1f489}, "syringe", 7, 80, []string{"doctor", "flu", "medicine", "needle", "shot", "sick", "syringe", "tool", "vaccination"}, false, 0},
	{[]rune{0x1fa78}, "drop of blood", 7, 80, []string{"bleed", "blood", "donation", "drop", "injury", "medicine", "menstruation"}, false, 0},
	{[]rune{0x1f48a}, "pill", 7, 80, []string{"doctor", "drugs", "medicated", "medicine", "pill", "pills", "sick", "vitamin"}, false, 0},
	{[]rune{0x1fa79}, "adhesive bandage", 7, 80, []string{"adhesive", "bandage"}, false, 0},
	{[]rune{0x1fa7c}, "crutch", 7, 80, []string{"aid", "cane", "crutch", "disability", "help", "hurt", "injured", "mobility", "stick"}, false, 0},
	{[]rune{0x1fa7a}, "stethoscope", 7, 80, []string{"doctor", "heart", "medicine", "stethoscope"}, false, 0},
	{[]rune{0x1fa7b}, "x-ray", 7, 80, []string{"bones", "doctor", "medical", "skeleton", "skull", "x-ray", "xray"}, false, 0},
	{[]rune{0x1f6aa}, "door", 7, 81, []string{"back", "closet", "door", "front"}, false, 0},
	{[]rune{0x1f6d7}, "elevator", 7, 81, []string{"accessibility", "elevator", "hoist", "lift"}, false, 0},
	{[]rune{0x1fa9e}, "mirror", 7, 81, []string{"makeup", "mirror", "reflection", "reflector", "speculum"}, false, 0},
	{[]rune{0x1fa9f}, "window", 7, 81, []string{"air", "frame", "fresh", "opening", "transparent", "view", "window"}, false, 0},
	{[]rune{0x1f6cf, 0xfe0f}, "bed", 7, 81, []string{"bed", "hotel", "sleep"}, false, 0},
	{[]rune{0x1f6cb, 0xfe0f}, "couch and lamp", 7, 81, []string{"couch", "hotel", "lamp"}, false, 0},
	{[]rune{0x1fa91}, "chair", 7, 81, []string{"chair", "seat", "sit"}, false, 0},
	{[]rune{0x1f6bd}, "toilet", 7, 81, []string{"bathroom", "toilet"}, false, 0},
	{[]rune{0x1faa0}, "plunger", 7, 81, []string{"cup", "force", "plumber", "plunger", "poop", "suction", "toilet"}, false, 0},
	{[]rune{0x1f6bf}, "shower", 7, 81, []string{"shower", "water"}, false, 0},
	{[]rune{0x1f6c1}, "bathtub", 7, 81, []string{"bath", "bathtub"}, false, 0},
	{[]rune{0x1faa4}, "mouse trap", 7, 81, []string{"bait", "cheese", "lure", "mouse", "mousetrap", "snare", "trap"}, false, 0},
	{[]rune{0x1fa92}, "razor", 7, 81, []string{"razor", "sharp", "shave"}, false, 0},
	{[]rune{0x1f9f4}, "lotion bottle", 7, 81, []string{"bottle", "lotion", "moisturizer", "shampoo", "sunscreen"}, false, 0},
	{[]rune{0x1f9f7}, "safety pin", 7, 81, []string{"diaper", "pin", "punk", "rock", "safety"}, false, 0},
	{[]rune{0x1f9f9}, "broom", 7, 81, []string{"broom", "cleaning", "sweeping", "witch"}, false, 0},
	{[]rune{0x1f9fa}, "basket", 7, 81, []string{"basket", "farming", "laundry", "picnic"}, false, 0},
	{[]rune{0x1f9fb}, "roll of paper", 7, 81, []string{"paper", "roll", "toilet", "towels"}, false, 0},
	{[]rune{0x1faa3}, "bucket", 7, 81, []string{"bucket", "cask", "pail", "vat"}, false, 0},
	{[]rune{0x1f9fc}, "soap", 7, 81, []string{"bar", "bathing", "clean", "cleaning", "lather", "soap", "soapdish"}, false, 0},
	{[]rune{0x1fae7}, "bubbles", 7, 81, []string{"bubble", "bubbles", "burp", "clean", "floating", "pearl", "soap", "underwater"}, false, 0},
	{[]rune{0x1faa5}, "toothbrush", 7, 81, []string{"bathroom", "brush", "clean", "dental", "hygiene", "teeth", "toiletry", "toothbrush"}, false, 0},
	{[]rune{0x1f9fd}, "sponge", 7, 81, []string{"absorbing", "cleaning", "porous", "soak", "sponge"}, false, 0},
	{[]rune{0x1f9ef}, "fire extinguisher", 7, 81, []string{"extinguish", "extinguisher", "fire", "quench"}, false, 0},
	{[]rune{0x1f6d2}, "shopping cart", 7, 81, []string{"cart", "shopping", "trolley"}, false, 0},
	{[]rune{0x1f6ac}, "cigarette", 7, 82, []string{"cigarette", "smoking"}, false, 0},
	{[]rune{0x26b0, 0xfe0f}, "coffin", 7, 82, []string{"coffin", "dead", "death", "vampire"}, false, 0},
	{[]rune{0x1faa6}, "headstone", 7, 82, []string{"cemetery", "dead", "grave", "graveyard", "headstone", "memorial", "rip", "tomb", "tombstone"}, false, 0},
	{[]rune{0x26b1, 0xfe0f}, "funeral urn", 7, 82, []string{"ashes", "death", "funeral", "urn"}, false, 0},
	{[]rune{0x1f9ff}, "nazar amulet", 7, 82, []string{"amulet", "bead", "blue", "charm", "evil-eye", "nazar", "talisman"}, false, 0},
	{[]rune{0x1faac}, "hamsa", 7, 82, []string{"amulet", "Fatima", "fortune", "guide", "hamsa", "hand", "Mary", "Miriam", "palm", "protect", "protection"}, false, 0},
	{[]rune{0x1f5ff}, "moai", 7, 82, []string{"face", "moai", "moyai", "statue", "stoneface", "travel"}, false, 0},
	{[]rune{0x1faa7}, "placard", 7, 82, []string{"card", "demonstration", "notice", "picket", "placard", "plaque", "protest", "sign"}, false, 0},
	{[]rune{0x1faaa}, "identification card", 7, 82, []string{"card", "credentials", "document", "ID", "identification", "license", "security"}, false, 0},
	{[]rune{0x1f3e7}, "ATM sign", 8, 83, []string{"ATM", "automated", "bank", "cash", "money", "sign", "teller"}, false, 0},
	{[]rune{0x1f6ae}, "litter in bin sign", 8, 83, []string{"bin", "litter", "litterbin", "sign"}, false, 0},
	{[]rune{0x1f6b0}, "potable water", 8, 83, []string{"drinking", "potable", "water"}, false, 0},
	{[]rune{0x267f}, "wheelchair symbol", 8, 83, []string{"access", "handicap", "symbol", "wheelchair"}, false, 0},
	{[]rune{0x1f6b9}, "men’s room", 8, 83, []string{"bathroom", "lavatory", "man", "men’s", "restroom", "room", "toilet", "WC"}, false, 0},
	{[]rune{0x1f6ba}, "women’s room", 8, 83, []string{"bathroom", "lavatory", "restroom", "room", "toilet", "WC", "woman", "women’s"}, false, 0},
	{[]rune{0x1f6bb}, "restroom", 8, 83, []string{"bathroom", "lavatory", "restroom", "toilet", "WC"}, false, 0},
	{[]rune{0x1f6bc}, "baby symbol", 8, 83, []string{"baby", "changing", "symbol"}, false, 0},
	{[]rune{0x1f6be}, "water closet", 8, 83, []string{"bathroom", "closet", "lavatory", "restroom", "toilet", "water", "WC"}, false, 0},
	{[]rune{0x1f6c2}, "passport control", 8, 83, []string{"control", "passport"}, false, 0},
	{[]rune{0x1f6c3}, "customs", 8, 83, []string{"customs", "packing"}, false, 0},
	{[]rune{0x1f6c4}, "baggage claim", 8, 83, []string{"arrived", "baggage", "bags", "case", "checked", "claim", "journey", "packing", "plane", "ready", "travel", "trip"}, false, 0},
	{[]rune{0x1f6c5}, "left luggage", 8, 83, []string{"baggage", "case", "left", "locker", "luggage"}, false, 0},
	{[]rune{0x26a0, 0xfe0f}, "warning", 8, 84, []string{"caution", "warning"}, false, 0},
	{[]rune{0x1f6b8}, "children crossing", 8, 84, []string{"child", "children", "crossing", "pedestrian", "traffic"}, false, 0},
	{[]rune{0x26d4}, "no entry", 8, 84, []string{"do", "entry", "fail", "forbidden", "no", "not", "pass", "prohibited", "traffic"}, false, 0},
	{[]rune{0x1f6ab}, "prohibited", 8, 84, []string{"entry", "forbidden", "no", "not", "prohibited", "smoke"}, false, 0},
	{[]rune{0x1f6b3}, "no bicycles", 8, 84, []string{"bicycle", "bicycles", "bike", "forbidden", "no", "not", "prohibited"}, false, 0},
	{[]rune{0x1f6ad}, "no smoking", 8, 84, []string{"forbidden", "no", "not", "prohibited", "smoke", "smoking"}, false, 0},
	{[]rune{0x1f6af}, "no littering", 8, 84, []string{"forbidden", "litter", "littering", "no", "not", "prohibited"}, false, 0},
	{[]rune{0x1f6b1}, "non-potable water", 8, 84, []string{"dry", "non-drinking", "non-potable", "prohibited", "water"}, false, 0},
	{[]rune{0x1f6b7}, "no pedestrians", 8, 84, []string{"forbidden", "no", "not", "pedestrian", "pedestrians", "prohibited"}, false, 0},
	{[]rune{0x1f4f5}, "no mobile phones", 8, 84, []string{"cell", "forbidden", "mobile", "no", "not", "phone", "phones", "prohibited", "telephone"}, false, 0},
	{[]rune{0x1f51e}, "no one under eighteen", 8, 84, []string{"18", "age", "eighteen", "forbidden", "no", "not", "one", "prohibited", "restriction", "underage"}, false, 0},
	{[]rune{0x2622, 0xfe0f}, "radioactive", 8, 84, []string{"radioactive", "sign"}, false, 0},
	{[]rune{0x2623, 0xfe0f}, "biohazard", 8, 84, []string{"biohazard", "sign"}, false, 0},
	{[]rune{0x2b06, 0xfe0f}, "up arrow", 8, 85, []string{"arrow", "cardinal", "direction", "north", "up"}, false, 0},
	{[]rune{0x2197, 0xfe0f}, "up-right arrow", 8, 85, []string{"arrow", "direction", "intercardinal", "northeast", "up-right"}, false, 0},
	{[]rune{0x27a1, 0xfe0f}, "right arrow", 8, 85, []string{"arrow", "cardinal", "direction", "east", "right"}, false, 0},
	{[]rune{0x2198, 0xfe0f}, "down-right arrow", 8, 85, []string{"arrow", "direction", "down-right", "intercardinal", "southeast"}, false, 0},
	{[]rune{0x2b07, 0xfe0f}, "down arrow", 8, 85, []string{"arrow", "cardinal", "direction", "down", "south"}, false, 0},
	{[]rune{0x2199, 0xfe0f}, "down-left arrow", 8, 85, []string{"arrow", "direction", "down-left", "intercardinal", "southwest"}, false, 0},
	{[]rune{0x2b05, 0xfe0f}, "left arrow", 8, 85, []string{"arrow", "cardinal", "direction", "left", "west"}, false, 0},
	{[]rune{0x2196, 0xfe0f}, "up-left arrow", 8, 85, []string{"arrow", "direction", "intercardinal", "northwest", "up-left"}, false, 0},
	{[]rune{0x2195, 0xfe0f}, "up-down arrow", 8, 85, []string{"arrow", "up-down"}, false, 0},
	{[]rune{0x2194, 0xfe0f}, "left-right arrow", 8, 85, []string{"arrow", "left-right"}, false, 0},
	{[]rune{0x21a9, 0xfe0f}, "right arrow curving left", 8, 85, []string{"arrow", "curving", "left", "right"}, false, 0},
	{[]rune{0x21aa, 0xfe0f}, "left arrow curving right", 8, 85, []string{"arrow", "curving", "left", "right"}, false, 0},
	{[]rune{0x2934, 0xfe0f}, "right arrow curving up", 8, 85, []string{"arrow", "curving", "right", "up"}, false, 0},
	{[]rune{0x2935, 0xfe0f}, "right arrow curving down", 8, 85, []string{"arrow", "curving", "down", "right"}, false, 0},
	{[]rune{0x1f503}, "clockwise vertical arrows", 8, 85, []string{"arrow", "arrows", "clockwise", "refresh", "reload", "vertical"}, false, 0},
	{[]rune{0x1f504}, "counterclockwise arrows button", 8, 85, []string{"again", "anticlockwise", "arrow", "arrows", "button", "counterclockwise", "deja", "refresh", "rewindershins", "vu"}, false, 0},
	{[]rune{0x1f519}, "BACK arrow", 8, 85, []string{"arrow", "BACK"}, false, 0},
	{[]rune{0x1f51a}, "END arrow", 8, 85, []string{"arrow", "END"}, false, 0},
	{[]rune{0x1f51b}, "ON! arrow", 8, 85, []string{"arrow", "mark", "ON!"}, false, 0},
	{[]rune{0x1f51c}, "SOON arrow", 8, 85, []string{"arrow", "brb", "omw", "SOON"}, false, 0},
	{[]rune{0x1f51d}, "TOP arrow", 8, 85, []string{"arrow", "homie", "TOP", "up"}, false, 0},
	{[]rune{0x1f6d0}, "place of worship", 8, 86, []string{"place", "pray", "religion", "worship"}, false, 0},
	{[]rune{0x269b, 0xfe0f}, "atom symbol", 8, 86, []string{"atheist", "atom", "symbol"}, false, 0},
	{[]rune{0x1f549, 0xfe0f}, "om", 8, 86, []string{"Hindu", "om", "religion"}, false, 0},
	{[]rune{0x2721, 0xfe0f}, "star of David", 8, 86, []string{"David", "Jew", "Jewish", "judaism", "religion", "star"}, false, 0},
	{[]rune{0x2638, 0xfe0f}, "wheel of dharma", 8, 86, []string{"Buddhist", "dharma", "religion", "wheel"}, false, 0},
	{[]rune{0x262f, 0xfe0f}, "yin yang", 8, 86, []string{"difficult", "lives", "religion", "tao", "taoist", "total", "yang", "yin", "yinyang"}, false, 0},
	{[]rune{0x271d, 0xfe0f}, "latin cross", 8, 86, []string{"christ", "Christian", "cross", "latin", "religion"}, false, 0},
	{[]rune{0x2626, 0xfe0f}, "orthodox cross", 8, 86, []string{"Christian", "cross", "orthodox", "religion"}, false, 0},
	{[]rune{0x262a, 0xfe0f}, "star and crescent", 8, 86, []string{"crescent", "islam", "Muslim", "ramadan", "religion", "star"}, false, 0},
	{[]rune{0x262e, 0xfe0f}, "peace symbol", 8, 86, []string{"healing", "peace", "peaceful", "symbol"}, false, 0},
	{[]rune{0x1f54e}, "menorah", 8, 86, []string{"candelabrum", "candlestick", "hanukkah", "jewish", "judaism", "menorah", "religion"}, false, 0},
	{[]rune{0x1f52f}, "dotted six-pointed star", 8, 86, []string{"dotted", "fortune", "jewish", "judaism", "six-pointed", "star"}, false, 0},
	{[]rune{0x1faaf}, "khanda", 8, 86, []string{"Deg", "Fateh", "Khalsa", "Khanda", "religion", "Sikh", "Sikhism", "Tegh"}, false, 0},
	{[]rune{0x2648}, "Aries", 8, 87, []string{"Aries", "horoscope", "ram", "zodiac"}, false, 0},
	{[]rune{0x2649}, "Taurus", 8, 87, []string{"bull", "horoscope", "ox", "Taurus", "zodiac"}, false, 0},
	{[]rune{0x264a}, "Gemini", 8, 87, []string{"Gemini", "horoscope", "twins", "zodiac"}, false, 0},
	{[]rune{0x264b}, "Cancer", 8, 87, []string{"Cancer", "crab", "horoscope", "zodiac"}, false, 0},
	{[]rune{0x264c}, "Leo", 8, 87, []string{"horoscope", "Leo", "lion", "zodiac"}, false, 0},
	{[]rune{0x264d}, "Virgo", 8, 87, []string{"horoscope", "Virgo", "zodiac"}, false, 0},
	{[]rune{0x264e}, "Libra", 8, 87, []string{"balance", "horoscope", "justice", "Libra", "scales", "zodiac"}, false, 0},
	{[]rune{0x264f}, "Scorpio", 8, 87, []string{"horoscope", "Scorpio", "scorpion", "Scorpius", "zodiac"}, false, 0},
	{[]rune{0x2650}, "Sagittarius", 8, 87, []string{"archer", "horoscope", "Sagittarius", "zodiac"}, false, 0},
	{[]rune{0x2651}, "Capricorn", 8, 87, []string{"Capricorn", "goat", "horoscope", "zodiac"}, false, 0},
	{[]rune{0x2652}, "Aquarius", 8, 87, []string{"Aquarius", "bearer", "horoscope", "water", "zodiac"}, false, 0},
	{[]rune{0x2653}, "Pisces", 8, 87, []string{"fish", "horoscope", "Pisces", "zodiac"}, false, 0},
	{[]rune{0x26ce}, "Ophiuchus", 8, 87, []string{"bearer", "Ophiuchus", "serpent", "snake", "zodiac"}, false, 0},
	{[]rune{0x1f500}, "shuffle tracks button", 8, 88, []string{"arrow", "button", "crossed", "shuffle", "tracks"}, false, 0},
	{[]rune{0x1f501}, "repeat button", 8, 88, []string{"arrow", "button", "clockwise", "repeat"}, false, 0},
	{[]rune{0x1f502}, "repeat single button", 8, 88, []string{"arrow", "button", "clockwise", "once", "repeat", "single"}, false, 0},
	{[]rune{0x25b6, 0xfe0f}, "play button", 8, 88, []string{"arrow", "button", "play", "right", "triangle"}, false, 0},
	{[]rune{0x23e9}, "fast-forward button", 8, 88, []string{"arrow", "button", "double", "fast", "fast-forward", "forward"}, false, 0},
	{[]rune{0x23ed, 0xfe0f}, "next track button", 8, 88, []string{"arrow", "button", "next", "scene", "track", "triangle"}, false, 0},
	{[]rune{0x23ef, 0xfe0f}, "play or pause button", 8, 88, []string{"arrow", "button", "pause", "play", "right", "triangle"}, false, 0},
	{[]rune{0x25c0, 0xfe0f}, "reverse button", 8, 88, []string{"arrow", "button", "left", "reverse", "triangle"}, false, 0},
	{[]rune{0x23ea}, "fast reverse button", 8, 88, []string{"arrow", "button", "double", "fast", "reverse", "rewind"}, false, 0},
	{[]rune{0x23ee, 0xfe0f}, "last track button", 8, 88, []string{"arrow", "button", "last", "previous", "scene", "track", "triangle"}, false, 0},
	{[]rune{0x1f53c}, "upwards button", 8, 88, []string{"arrow", "button", "red", "up", "upwards"}, false, 0},
	{[]rune{0x23eb}, "fast up button", 8, 88, []string{"arrow", "button", "double", "fast", "up"}, false, 0},
	{[]rune{0x1f53d}, "downwards button", 8, 88, []string{"arrow", "button", "down", "downwards", "red"}, false, 0},
	{[]rune{0x23ec}, "fast down button", 8, 88, []string{"arrow", "button", "double", "down", "fast"}, false, 0},
	{[]rune{0x23f8, 0xfe0f}, "pause button", 8, 88, []string{"bar", "button", "double", "pause", "vertical"}, false, 0},
	{[]rune{0x23f9, 0xfe0f}, "stop button", 8, 88, []string{"button", "square", "stop"}, false, 0},
	{[]rune{0x23fa, 0xfe0f}, "record button", 8, 88, []string{"button", "circle", "record"}, false, 0},
	{[]rune{0x23cf, 0xfe0f}, "eject button", 8, 88, []string{"button", "eject"}, false, 0},
	{[]rune{0x1f3a6}, "cinema", 8, 88, []string{"camera", "cinema", "film", "movie"}, false, 0},
	{[]rune{0x1f505}, "dim button", 8, 88, []string{"brightness", "button", "dim", "low"}, false, 0},
	{[]rune{0x1f506}, "bright button", 8, 88, []string{"bright", "brightness", "button", "light"}, false, 0},
	{[]rune{0x1f4f6}, "antenna bars", 8, 88, []string{"antenna", "bar", "bars", "cell", "communication", "mobile", "phone", "signal", "telephone"}, false, 0},
	{[]rune{0x1f6dc}, "wireless", 8, 88, []string{"broadband", "computer", "connectivity", "hotspot", "internet", "network", "router", "smartphone", "wi-fi", "wifi", "wireless", "wlan"}, false, 0},
	{[]rune{0x1f4f3}, "vibration mode", 8, 88, []string{"cell", "communication", "mobile", "mode", "phone", "telephone", "vibration"}, false, 0},
	{[]rune{0x1f4f4}, "mobile phone off", 8, 88, []string{"cell", "mobile", "off", "phone", "telephone"}, false, 0},
	{[]rune{0x26a7, 0xfe0f}, "transgender symbol", 8, 89, []string{"symbol", "transgender"}, false, 0},
	{[]rune{0x2716, 0xfe0f}, "multiply", 8, 90, []string{"×", "cancel", "multiplication", "multiply", "sign", "x"}, false, 0},
	{[]rune{0x2795}, "plus", 8, 90, []string{"+", "plus"}, false, 0},
	{[]rune{0x2796}, "minus", 8, 90, []string{"-", "−", "heavy", "math", "minus", "sign"}, false, 0},
	{[]rune{0x2797}, "divide", 8, 90, []string{"÷", "divide", "division", "heavy", "math", "sign"}, false, 0},
	{[]rune{0x1f7f0}, "heavy equals sign", 8, 90, []string{"answer", "equal", "equality", "equals", "heavy", "math", "sign"}, false, 0},
	{[]rune{0x267e, 0xfe0f}, "infinity", 8, 90, []string{"forever", "infinity", "unbounded", "universal"}, false, 0},
	{[]rune{0x203c, 0xfe0f}, "double exclamation mark", 8, 91, []string{"!", "!!", "bangbang", "double", "exclamation", "mark", "punctuation"}, false, 0},
	{[]rune{0x2049, 0xfe0f}, "exclamation question mark", 8, 91, []string{"!", "!?", "?", "exclamation", "interrobang", "mark", "punctuation", "question"}, false, 0},
	{[]rune{0x2753}, "red question mark", 8, 91, []string{"?", "mark", "punctuation", "question", "red"}, false, 0},
	{[]rune{0x2754}, "white question mark", 8, 91, []string{"?", "mark", "outlined", "punctuation", "question", "white"}, false, 0},
	{[]rune{0x2755}, "white exclamation mark", 8, 91, []string{"!", "exclamation", "mark", "outlined", "punctuation", "white"}, false, 0},
	{[]rune{0x2757}, "red exclamation mark", 8, 91, []string{"!", "exclamation", "mark", "punctuation", "red"}, false, 0},
	{[]rune{0x3030, 0xfe0f}, "wavy dash", 8, 91, []string{"dash", "punctuation", "wavy"}, false, 0},
	{[]rune{0x1f4b1}, "currency exchange", 8, 92, []string{"bank", "currency", "exchange", "money"}, false, 0},
	{[]rune{0x1f4b2}, "heavy dollar sign", 8, 92, []string{"billion", "cash", "charge", "currency", "dollar", "heavy", "million", "money", "pay", "sign"}, false, 0},
	{[]rune{0x2695, 0xfe0f}, "medical symbol", 8, 93, []string{"aesculapius", "medical", "medicine", "staff", "symbol"}, false, 0},
	{[]rune{0x267b, 0xfe0f}, "recycling symbol", 8, 93, []string{"recycle", "recycling", "symbol"}, false, 0},
	{[]rune{0x269c, 0xfe0f}, "fleur-de-lis", 8, 93, []string{"fleur-de-lis", "knights"}, false, 0},
	{[]rune{0x1f531}, "trident emblem", 8, 93, []string{"anchor", "emblem", "poseidon", "ship", "tool", "trident"}, false, 0},
	{[]rune{0x1f4db}, "name badge", 8, 93, []string{"badge", "name"}, false, 0},
	{[]rune{0x1f530}, "Japanese symbol for beginner", 8, 93, []string{"beginner", "chevron", "green", "Japanese", "leaf", "symbol", "tool", "yellow"}, false, 0},
	{[]rune{0x2b55}, "hollow red circle", 8, 93, []string{"circle", "heavy", "hollow", "large", "o", "red"}, false, 0},
	{[]rune{0x2705}, "check mark button", 8, 93, []string{"✓", "button", "check", "checked", "checkmark", "complete", "completed", "done", "fixed", "mark", "tick"}, false, 0},
	{[]rune{0x2611, 0xfe0f}, "check box with check", 8, 93, []string{"✓", "ballot", "box", "check", "checked", "done", "off", "tick"}, false, 0},
	{[]rune{0x2714, 0xfe0f}, "check mark", 8, 93, []string{"✓", "check", "checked", "checkmark", "done", "heavy", "mark", "tick"}, false, 0},
	{[]rune{0x274c}, "cross mark", 8, 93, []string{"×", "cancel", "cross", "mark", "multiplication", "multiply", "x"}, false, 0},
	{[]rune{0x274e}, "cross mark button", 8, 93, []string{"×", "button", "cross", "mark", "multiplication", "multiply", "square", "x"}, false, 0},
	{[]rune{0x27b0}, "curly loop", 8, 93, []string{"curl", "curly", "loop"}, false, 0},
	{[]rune{0x27bf}, "double curly loop", 8, 93, []string{"curl", "curly", "double", "loop"}, false, 0},
	{[]rune{0x303d, 0xfe0f}, "part alternation mark", 8, 93, []string{"alternation", "mark", "part"}, false, 0},
	{[]rune{0x2733, 0xfe0f}, "eight-spoked asterisk", 8, 93, []string{"*", "asterisk", "eight-spoked"}, false, 0},
	{[]rune{0x2734, 0xfe0f}, "eight-pointed star", 8, 93, []string{"*", "eight-pointed", "star"}, false, 0},
	{[]rune{0x2747, 0xfe0f}, "sparkle", 8, 93, []string{"*", "sparkle"}, false, 0},
	{[]rune{0xa9, 0xfe0f}, "copyright", 8, 93, []string{"C", "copyright"}, false, 0},
	{[]rune{0xae, 0xfe0f}, "registered", 8, 93, []string{"R", "registered"}, false, 0},
	{[]rune{0x2122, 0xfe0f}, "trade mark", 8, 93, []string{"mark", "TM", "trade", "trademark"}, false, 0},
	{[]rune{0x1fadf}, "splatter", 8, 93, []string{"drip", "holi", "ink", "liquid", "mess", "paint", "spill", "splatter", "stain"}, false, 0},
	{[]rune{0x23, 0xfe0f, 0x20e3}, "keycap: #", 8, 94, []string(nil), false, 0},
	{[]rune{0x2a, 0xfe0f, 0x20e3}, "keycap: *", 8, 94, []string(nil), false, 0},
	{[]rune{0x30, 0xfe0f, 0x20e3}, "keycap: 0", 8, 94, []string{"0", "keycap", "zero"}, false, 0},
	{[]rune{0x31, 0xfe0f, 0x20e3}, "keycap: 1", 8, 94, []string{"1", "keycap", "one"}, false, 0},
	{[]rune{0x32, 0xfe0f, 0x20e3}, "keycap: 2", 8, 94, []string{"2", "keycap", "two"}, false, 0},
	{[]rune{0x33, 0xfe0f, 0x20e3}, "keycap: 3", 8, 94, []string{"3", "keycap", "three"}, false, 0},
	{[]rune{0x34, 0xfe0f, 0x20e3}, "keycap: 4", 8, 94, []string{"4", "four", "keycap"}, false, 0},
	{[]rune{0x35, 0xfe0f, 0x20e3}, "keycap: 5", 8, 94, []string{"5", "five", "keycap"}, false, 0},
	{[]rune{0x36, 0xfe0f, 0x20e3}, "keycap: 6", 8, 94, []string{"6", "keycap", "six"}, false, 0},
	{[]rune{0x37, 0xfe0f, 0x20e3}, "keycap: 7", 8, 94, []string{"7", "keycap", "seven"}, false, 0},
	{[]rune{0x38, 0xfe0f, 0x20e3}, "keycap: 8", 8, 94, []string{"8", "eight", "keycap"}, false, 0},
	{[]rune{0x39, 0xfe0f, 0x20e3}, "keycap: 9", 8, 94, []string{"9", "keycap", "nine"}, false, 0},
	{[]rune{0x1f51f}, "keycap: 10", 8, 94, []string(nil), false, 0},
	{[]rune{0x1f520}, "input latin uppercase", 8, 95, []string{"ABCD", "input", "latin", "letters", "uppercase"}, false, 0},
	{[]rune{0x1f521}, "input latin lowercase", 8, 95, []string{"abcd", "input", "latin", "letters", "lowercase"}, false, 0},
	{[]rune{0x1f522}, "input numbers", 8, 95, []string{"1234", "input", "numbers"}, false, 0},
	{[]rune{0x1f523}, "input symbols", 8, 95, []string{"&", "%", "♪", "〒", "input", "symbols"}, false, 0},
	{[]rune{0x1f524}, "input latin letters", 8, 95, []string{"abc", "alphabet", "input", "latin", "letters"}, false, 0},
	{[]rune{0x1f170, 0xfe0f}, "A button (blood type)", 8, 95, []string{"blood", "button", "type"}, false, 0},
	{[]rune{0x1f18e}, "AB button (blood type)", 8, 95, []string{"AB", "blood", "button", "type"}, false, 0},
	{[]rune{0x1f171, 0xfe0f}, "B button (blood type)", 8, 95, []string{"B", "blood", "button", "type"}, false, 0},
	{[]rune{0x1f191}, "CL button", 8, 95, []string{"button", "CL"}, false, 0},
	{[]rune{0x1f192}, "COOL button", 8, 95, []string{"button", "COOL"}, false, 0},
	{[]rune{0x1f193}, "FREE button", 8, 95, []string{"button", "FREE"}, false, 0},
	{[]rune{0x2139, 0xfe0f}, "information", 8, 95, []string{"I", "information"}, false, 0},
	{[]rune{0x1f194}, "ID button", 8, 95, []string{"button", "ID", "identity"}, false, 0},
	{[]rune{0x24c2, 0xfe0f}, "circled M", 8, 95, []string{"circle", "circled", "M"}, false, 0},
	{[]rune{0x1f195}, "NEW button", 8, 95, []string{"button", "NEW"}, false, 0},
	{[]rune{0x1f196}, "NG button", 8, 95, []string{"button", "NG"}, false, 0},
	{[]rune{0x1f17e, 0xfe0f}, "O button (blood type)", 8, 95, []string{"blood", "button", "O", "type"}, false, 0},
	{[]rune{0x1f197}, "OK button", 8, 95, []string{"button", "OK", "okay"}, false, 0},
	{[]rune{0x1f17f, 0xfe0f}, "P button", 8, 95, []string{"button", "P", "parking"}, false, 0},
	{[]rune{0x1f198}, "SOS button", 8, 95, []string{"button", "help", "SOS"}, false, 0},
	{[]rune{0x1f199}, "UP! button", 8, 95, []string{"button", "mark", "UP", "UP!"}, false, 0},
	{[]rune{0x1f19a}, "VS button", 8, 95, []string{"button", "versus", "VS"}, false, 0},
	{[]rune{0x1f201}, "Japanese “here” button", 8, 95, []string{"button", "here", "Japanese", "katakana"}, false, 0},
	{[]rune{0x1f202, 0xfe0f}, "Japanese “service charge” button", 8, 95, []string{"button", "charge", "Japanese", "katakana", "service"}, false, 0},
	{[]rune{0x1f237, 0xfe0f}, "Japanese “monthly amount” button", 8, 95, []string{"amount", "button", "ideograph", "Japanese", "monthly"}, false, 0},
	{[]rune{0x1f236}, "Japanese “not free of charge” button", 8, 95, []string{"button", "charge", "free", "ideograph", "Japanese", "not"}, false, 0},
	{[]rune{0x1f22f}, "Japanese “reserved” button", 8, 95, []string{"button", "ideograph", "Japanese", "reserved"}, false, 0},
	{[]rune{0x1f250}, "Japanese “bargain” button", 8, 95, []string{"bargain", "button", "ideograph", "Japanese"}, false, 0},
	{[]rune{0x1f239}, "Japanese “discount” button", 8, 95, []string{"button", "discount", "ideograph", "Japanese"}, false, 0},
	{[]rune{0x1f21a}, "Japanese “free of charge” button", 8, 95, []string{"button", "charge", "free", "ideograph", "Japanese"}, false, 0},
	{[]rune{0x1f232}, "Japanese “prohibited” button", 8, 95, []string{"button", "ideograph", "Japanese", "prohibited"}, false, 0},
	{[]rune{0x1f251}, "Japanese “acceptable” button", 8, 95, []string{"acceptable", "button", "ideograph", "Japanese"}, false, 0},
	{[]rune{0x1f238}, "Japanese “application” button", 8, 95, []string{"application", "button", "ideograph", "Japanese"}, false, 0},
	{[]rune{0x1f234}, "Japanese “passing grade” button", 8, 95, []string{"button", "grade", "ideograph", "Japanese", "passing"}, false, 0},
	{[]rune{0x1f233}, "Japanese “vacancy” button", 8, 95, []string{"button", "ideograph", "Japanese", "vacancy"}, false, 0},
	{[]rune{0x3297, 0xfe0f}, "Japanese “congratulations” button", 8, 95, []string{"button", "congratulations", "ideograph", "Japanese"}, false, 0},
	{[]rune{0x3299, 0xfe0f}, "Japanese “secret” button", 8, 95, []string{"button", "ideograph", "Japanese", "secret"}, false, 0},
	{[]rune{0x1f23a}, "Japanese “open for business” button", 8, 95, []string{"business", "button", "ideograph", "Japanese", "open"}, false, 0},
	{[]rune{0x1f235}, "Japanese “no vacancy” button", 8, 95, []string{"button", "ideograph", "Japanese", "no", "vacancy"}, false, 0},
	{[]rune{0x1f534}, "red circle", 8, 96, []string{"circle", "geometric", "red"}, false, 0},
	{[]rune{0x1f7e0}, "orange circle", 8, 96, []string{"circle", "orange"}, false, 0},
	{[]rune{0x1f7e1}, "yellow circle", 8, 96, []string{"circle", "yellow"}, false, 0},
	{[]rune{0x1f7e2}, "green circle", 8, 96, []string{"circle", "green"}, false, 0},
	{[]rune{0x1f535}, "blue circle", 8, 96, []string{"blue", "circle", "geometric"}, false, 0},
	{[]rune{0x1f7e3}, "purple circle", 8, 96, []string{"circle", "purple"}, false, 0},
	{[]rune{0x1f7e4}, "brown circle", 8, 96, []string{"brown", "circle"}, false, 0},
	{[]rune{0x26ab}, "black circle", 8, 96, []string{"black", "circle", "geometric"}, false, 0},
	{[]rune{0x26aa}, "white circle", 8, 96, []string{"circle", "geometric", "white"}, false, 0},
	{[]rune{0x1f7e5}, "red square", 8, 96, []string{"card", "penalty", "red", "square"}, false, 0},
	{[]rune{0x1f7e7}, "orange square", 8, 96, []string{"orange", "square"}, false, 0},
	{[]rune{0x1f7e8}, "yellow square", 8, 96, []string{"card", "penalty", "square", "yellow"}, false, 0},
	{[]rune{0x1f7e9}, "green square", 8, 96, []string{"green", "square"}, false, 0},
	{[]rune{0x1f7e6}, "blue square", 8, 96, []string{"blue", "square"}, false, 0},
	{[]rune{0x1f7ea}, "purple square", 8, 96, []string{"purple", "square"}, false, 0},
	{[]rune{0x1f7eb}, "brown square", 8, 96, []string{"brown", "square"}, false, 0},
	{[]rune{0x2b1b}, "black large square", 8, 96, []string{"black", "geometric", "large", "square"}, false, 0},
	{[]rune{0x2b1c}, "white large square", 8, 96, []string{"geometric", "large", "square", "white"}, false, 0},
	{[]rune{0x25fc, 0xfe0f}, "black medium square", 8, 96, []string{"black", "geometric", "medium", "square"}, false, 0},
	{[]rune{0x25fb, 0xfe0f}, "white medium square", 8, 96, []string{"geometric", "medium", "square", "white"}, false, 0},
	{[]rune{0x25fe}, "black medium-small square", 8, 96, []string{"black", "geometric", "medium-small", "square"}, false, 0},
	{[]rune{0x25fd}, "white medium-small square", 8, 96, []string{"geometric", "medium-small", "square", "white"}, false, 0},
	{[]rune{0x25aa, 0xfe0f}, "black small square", 8, 96, []string{"black", "geometric", "small", "square"}, false, 0},
	{[]rune{0x25ab, 0xfe0f}, "white small square", 8, 96, []string{"geometric", "small", "square", "white"}, false, 0},
	{[]rune{0x1f536}, "large orange diamond", 8, 96, []string{"diamond", "geometric", "large", "orange"}, false, 0},
	{[]rune{0x1f537}, "large blue diamond", 8, 96, []string{"blue", "diamond", "geometric", "large"}, false, 0},
	{[]rune{0x1f538}, "small orange diamond", 8, 96, []string{"diamond", "geometric", "orange", "small"}, false, 0},
	{[]rune{0x1f539}, "small blue diamond", 8, 96, []string{"blue", "diamond", "geometric", "small"}, false, 0},
	{[]rune{0x1f53a}, "red triangle pointed up", 8, 96, []string{"geometric", "pointed", "red", "triangle", "up"}, false, 0},
	{[]rune{0x1f53b}, "red triangle pointed down", 8, 96, []string{"down", "geometric", "pointed", "red", "triangle"}, false, 0},
	{[]rune{0x1f4a0}, "diamond with a dot", 8, 96, []string{"comic", "diamond", "dot", "geometric"}, false, 0},
	{[]rune{0x1f518}, "radio button", 8, 96, []string{"button", "geometric", "radio"}, false, 0},
	{[]rune{0x1f533}, "white square button", 8, 96, []string{"button", "geometric", "outlined", "square", "white"}, false, 0},
	{[]rune{0x1f532}, "black square button", 8, 96, []string{"black", "button", "geometric", "square"}, false, 0},
	{[]rune{0x1f3c1}, "chequered flag", 9, 97, []string{"checkered", "chequered", "finish", "flag", "flags", "game", "race", "racing", "sport", "win"}, false, 0},
	{[]rune{0x1f6a9}, "triangular flag", 9, 97, []string{"construction", "flag", "golf", "post", "triangular"}, false, 0},
	{[]rune{0x1f38c}, "crossed flags", 9, 97, []string{"celebration", "cross", "crossed", "flags", "Japanese"}, false, 0},
	{[]rune{0x1f3f4}, "black flag", 9, 97, []string{"black", "flag", "waving"}, false, 0},
	{[]rune{0x1f3f3, 0xfe0f}, "white flag", 9, 97, []string{"flag", "waving", "white"}, false, 0},
	{[]rune{0x1f3f3, 0xfe0f, 0x1f308}, "rainbow flag", 9, 97, []string{"bisexual", "flag", "gay", "genderqueer", "glbt", "glbtq", "lesbian", "lgbt", "lgbtq", "lgbtqia", "pride", "queer", "rainbow", "trans", "transgender"}, false, 0},
	{[]rune{0x1f3f3, 0xfe0f, 0x26a7, 0xfe0f}, "transgender flag", 9, 97, []string{"blue", "flag", "light", "pink", "transgender", "white"}, false, 0},
	{[]rune{0x1f3f4, 0x2620, 0xfe0f}, "pirate flag", 9, 97, []string{"flag", "Jolly", "pirate", "plunder", "Roger", "treasure"}, false, 0},
	{[]rune{0x1f1e6, 0x1f1e8}, "flag: Ascension Island", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1e9}, "flag: Andorra", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1ea}, "flag: United Arab Emirates", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1eb}, "flag: Afghanistan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1ec}, "flag: Antigua & Barbuda", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1ee}, "flag: Anguilla", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1f1}, "flag: Albania", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1f2}, "flag: Armenia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1f4}, "flag: Angola", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1f6}, "flag: Antarctica", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1f7}, "flag: Argentina", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1f8}, "flag: American Samoa", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1f9}, "flag: Austria", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1fa}, "flag: Australia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1fc}, "flag: Aruba", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1fd}, "flag: Åland Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e6, 0x1f1ff}, "flag: Azerbaijan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1e6}, "flag: Bosnia & Herzegovina", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1e7}, "flag: Barbados", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1e9}, "flag: Bangladesh", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1ea}, "flag: Belgium", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1eb}, "flag: Burkina Faso", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1ec}, "flag: Bulgaria", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1ed}, "flag: Bahrain", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1ee}, "flag: Burundi", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1ef}, "flag: Benin", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1f1}, "flag: St. Barthélemy", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1f2}, "flag: Bermuda", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1f3}, "flag: Brunei", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1f4}, "flag: Bolivia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1f6}, "flag: Caribbean Netherlands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1f7}, "flag: Brazil", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1f8}, "flag: Bahamas", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1f9}, "flag: Bhutan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1fb}, "flag: Bouvet Island", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1fc}, "flag: Botswana", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1fe}, "flag: Belarus", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e7, 0x1f1ff}, "flag: Belize", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1e6}, "flag: Canada", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1e8}, "flag: Cocos (Keeling) Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1e9}, "flag: Congo - Kinshasa", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1eb}, "flag: Central African Republic", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1ec}, "flag: Congo - Brazzaville", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1ed}, "flag: Switzerland", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1ee}, "flag: Côte d’Ivoire", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1f0}, "flag: Cook Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1f1}, "flag: Chile", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1f2}, "flag: Cameroon", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1f3}, "flag: China", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1f4}, "flag: Colombia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1f5}, "flag: Clipperton Island", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1f6}, "flag: Sark", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1f7}, "flag: Costa Rica", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1fa}, "flag: Cuba", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1fb}, "flag: Cape Verde", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1fc}, "flag: Curaçao", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1fd}, "flag: Christmas Island", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1fe}, "flag: Cyprus", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e8, 0x1f1ff}, "flag: Czechia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e9, 0x1f1ea}, "flag: Germany", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e9, 0x1f1ec}, "flag: Diego Garcia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e9, 0x1f1ef}, "flag: Djibouti", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e9, 0x1f1f0}, "flag: Denmark", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e9, 0x1f1f2}, "flag: Dominica", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e9, 0x1f1f4}, "flag: Dominican Republic", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1e9, 0x1f1ff}, "flag: Algeria", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ea, 0x1f1e6}, "flag: Ceuta & Melilla", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ea, 0x1f1e8}, "flag: Ecuador", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ea, 0x1f1ea}, "flag: Estonia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ea, 0x1f1ec}, "flag: Egypt", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ea, 0x1f1ed}, "flag: Western Sahara", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ea, 0x1f1f7}, "flag: Eritrea", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ea, 0x1f1f8}, "flag: Spain", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ea, 0x1f1f9}, "flag: Ethiopia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ea, 0x1f1fa}, "flag: European Union", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1eb, 0x1f1ee}, "flag: Finland", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1eb, 0x1f1ef}, "flag: Fiji", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1eb, 0x1f1f0}, "flag: Falkland Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1eb, 0x1f1f2}, "flag: Micronesia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1eb, 0x1f1f4}, "flag: Faroe Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1eb, 0x1f1f7}, "flag: France", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1e6}, "flag: Gabon", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1e7}, "flag: United Kingdom", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1e9}, "flag: Grenada", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1ea}, "flag: Georgia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1eb}, "flag: French Guiana", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1ec}, "flag: Guernsey", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1ed}, "flag: Ghana", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1ee}, "flag: Gibraltar", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1f1}, "flag: Greenland", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1f2}, "flag: Gambia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1f3}, "flag: Guinea", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1f5}, "flag: Guadeloupe", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1f6}, "flag: Equatorial Guinea", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1f7}, "flag: Greece", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1f8}, "flag: South Georgia & South Sandwich Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1f9}, "flag: Guatemala", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1fa}, "flag: Guam", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1fc}, "flag: Guinea-Bissau", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ec, 0x1f1fe}, "flag: Guyana", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ed, 0x1f1f0}, "flag: Hong Kong SAR China", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ed, 0x1f1f2}, "flag: Heard & McDonald Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ed, 0x1f1f3}, "flag: Honduras", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ed, 0x1f1f7}, "flag: Croatia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ed, 0x1f1f9}, "flag: Haiti", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ed, 0x1f1fa}, "flag: Hungary", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1e8}, "flag: Canary Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1e9}, "flag: Indonesia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1ea}, "flag: Ireland", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1f1}, "flag: Israel", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1f2}, "flag: Isle of Man", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1f3}, "flag: India", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1f4}, "flag: British Indian Ocean Territory", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1f6}, "flag: Iraq", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1f7}, "flag: Iran", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1f8}, "flag: Iceland", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ee, 0x1f1f9}, "flag: Italy", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ef, 0x1f1ea}, "flag: Jersey", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ef, 0x1f1f2}, "flag: Jamaica", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ef, 0x1f1f4}, "flag: Jordan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ef, 0x1f1f5}, "flag: Japan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1ea}, "flag: Kenya", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1ec}, "flag: Kyrgyzstan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1ed}, "flag: Cambodia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1ee}, "flag: Kiribati", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1f2}, "flag: Comoros", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1f3}, "flag: St. Kitts & Nevis", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1f5}, "flag: North Korea", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1f7}, "flag: South Korea", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1fc}, "flag: Kuwait", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1fe}, "flag: Cayman Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f0, 0x1f1ff}, "flag: Kazakhstan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1e6}, "flag: Laos", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1e7}, "flag: Lebanon", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1e8}, "flag: St. Lucia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1ee}, "flag: Liechtenstein", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1f0}, "flag: Sri Lanka", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1f7}, "flag: Liberia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1f8}, "flag: Lesotho", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1f9}, "flag: Lithuania", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1fa}, "flag: Luxembourg", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1fb}, "flag: Latvia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f1, 0x1f1fe}, "flag: Libya", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1e6}, "flag: Morocco", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1e8}, "flag: Monaco", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1e9}, "flag: Moldova", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1ea}, "flag: Montenegro", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1eb}, "flag: St. Martin", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1ec}, "flag: Madagascar", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1ed}, "flag: Marshall Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f0}, "flag: North Macedonia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f1}, "flag: Mali", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f2}, "flag: Myanmar (Burma)", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f3}, "flag: Mongolia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f4}, "flag: Macao SAR China", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f5}, "flag: Northern Mariana Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f6}, "flag: Martinique", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f7}, "flag: Mauritania", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f8}, "flag: Montserrat", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1f9}, "flag: Malta", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1fa}, "flag: Mauritius", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1fb}, "flag: Maldives", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1fc}, "flag: Malawi", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1fd}, "flag: Mexico", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1fe}, "flag: Malaysia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f2, 0x1f1ff}, "flag: Mozambique", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1e6}, "flag: Namibia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1e8}, "flag: New Caledonia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1ea}, "flag: Niger", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1eb}, "flag: Norfolk Island", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1ec}, "flag: Nigeria", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1ee}, "flag: Nicaragua", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1f1}, "flag: Netherlands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1f4}, "flag: Norway", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1f5}, "flag: Nepal", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1f7}, "flag: Nauru", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1fa}, "flag: Niue", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f3, 0x1f1ff}, "flag: New Zealand", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f4, 0x1f1f2}, "flag: Oman", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1e6}, "flag: Panama", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1ea}, "flag: Peru", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1eb}, "flag: French Polynesia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1ec}, "flag: Papua New Guinea", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1ed}, "flag: Philippines", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1f0}, "flag: Pakistan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1f1}, "flag: Poland", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1f2}, "flag: St. Pierre & Miquelon", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1f3}, "flag: Pitcairn Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1f7}, "flag: Puerto Rico", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1f8}, "flag: Palestinian Territories", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1f9}, "flag: Portugal", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1fc}, "flag: Palau", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f5, 0x1f1fe}, "flag: Paraguay", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f6, 0x1f1e6}, "flag: Qatar", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f7, 0x1f1ea}, "flag: Réunion", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f7, 0x1f1f4}, "flag: Romania", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f7, 0x1f1f8}, "flag: Serbia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f7, 0x1f1fa}, "flag: Russia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f7, 0x1f1fc}, "flag: Rwanda", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1e6}, "flag: Saudi Arabia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1e7}, "flag: Solomon Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1e8}, "flag: Seychelles", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1e9}, "flag: Sudan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1ea}, "flag: Sweden", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1ec}, "flag: Singapore", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1ed}, "flag: St. Helena", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1ee}, "flag: Slovenia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1ef}, "flag: Svalbard & Jan Mayen", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1f0}, "flag: Slovakia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1f1}, "flag: Sierra Leone", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1f2}, "flag: San Marino", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1f3}, "flag: Senegal", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1f4}, "flag: Somalia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1f7}, "flag: Suriname", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1f8}, "flag: South Sudan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1f9}, "flag: São Tomé & Príncipe", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1fb}, "flag: El Salvador", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1fd}, "flag: Sint Maarten", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1fe}, "flag: Syria", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f8, 0x1f1ff}, "flag: Eswatini", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1e6}, "flag: Tristan da Cunha", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1e8}, "flag: Turks & Caicos Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1e9}, "flag: Chad", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1eb}, "flag: French Southern Territories", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1ec}, "flag: Togo", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1ed}, "flag: Thailand", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1ef}, "flag: Tajikistan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1f0}, "flag: Tokelau", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1f1}, "flag: Timor-Leste", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1f2}, "flag: Turkmenistan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1f3}, "flag: Tunisia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1f4}, "flag: Tonga", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1f7}, "flag: Türkiye", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1f9}, "flag: Trinidad & Tobago", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1fb}, "flag: Tuvalu", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1fc}, "flag: Taiwan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1f9, 0x1f1ff}, "flag: Tanzania", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fa, 0x1f1e6}, "flag: Ukraine", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fa, 0x1f1ec}, "flag: Uganda", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fa, 0x1f1f2}, "flag: U.S. Outlying Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fa, 0x1f1f3}, "flag: United Nations", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fa, 0x1f1f8}, "flag: United States", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fa, 0x1f1fe}, "flag: Uruguay", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fa, 0x1f1ff}, "flag: Uzbekistan", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fb, 0x1f1e6}, "flag: Vatican City", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fb, 0x1f1e8}, "flag: St. Vincent & Grenadines", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fb, 0x1f1ea}, "flag: Venezuela", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fb, 0x1f1ec}, "flag: British Virgin Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fb, 0x1f1ee}, "flag: U.S. Virgin Islands", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fb, 0x1f1f3}, "flag: Vietnam", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fb, 0x1f1fa}, "flag: Vanuatu", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fc, 0x1f1eb}, "flag: Wallis & Futuna", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fc, 0x1f1f8}, "flag: Samoa", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fd, 0x1f1f0}, "flag: Kosovo", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fe, 0x1f1ea}, "flag: Yemen", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1fe, 0x1f1f9}, "flag: Mayotte", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ff, 0x1f1e6}, "flag: South Africa", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ff, 0x1f1f2}, "flag: Zambia", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f1ff, 0x1f1fc}, "flag: Zimbabwe", 9, 98, []string(nil), false, 0},
	{[]rune{0x1f3f4, 0xe0067, 0xe0062, 0xe0065, 0xe006e, 0xe0067, 0xe007f}, "flag: England", 9, 99, []string(nil), false, 0},
	{[]rune{0x1f3f4, 0xe0067, 0xe0062, 0xe0073, 0xe0063, 0xe0074, 0xe007f}, "flag: Scotland", 9, 99, []string(nil), false, 0},
	{[]rune{0x1f3f4, 0xe0067, 0xe0062, 0xe0077, 0xe006c, 0xe0073, 0xe007f}, "flag: Wales", 9, 99, []string(nil), false, 0},
}
