# Language-specific Packages

`Trivy` automatically detects the following files in the container and scans vulnerabilities in the application dependencies.

| Language | File                                            | Dev dependencies |
| ---------| ------------------------------------------------| -----------------|
| Ruby     | Gemfile.lock                                    | included         |
| Python   | Pipfile.lock                                    | excluded         |
|          | poetry.lock                                     | included         |
| PHP      | composer.lock                                   | excluded         |
| Node.js  | package-lock.json                               | excluded         |
|          | yarn.lock                                       | included         |
| .NET     | packages.lock.json                              | included         |
| Java     | JAR/WAR/EAR (`*.jar`, `*.war`, and `*.ear`)[^1] | included         |
| Go       | Binaries built by Go[^2]                        | excluded         |
|          | go.sum                                          | included         |


The path of these files does not matter.

Example: [Dockerfile](https://github.com/aquasecurity/trivy-ci-test/blob/main/Dockerfile)

[^1]: It requires the Internet access
[^2]: UPX-compressed binaries don't work
