import React from "react"
import styled from "styled-components"
import { AnalyticsType } from "./analytics"
import HeaderBar from "./HeaderBar"
import OverviewTable from "./OverviewTable"
import { OverviewTableBulkActions } from "./OverviewTableBulkActions"
import { OverviewTableDisplayOptions } from "./OverviewTableDisplayOptions"
import { ResourceNameFilter } from "./ResourceNameFilter"
import StarredResourceBar, {
  starredResourcePropsFromView,
} from "./StarredResourceBar"
import { Color, SizeUnit, Width, ZIndex } from "./style-helpers"

type OverviewTablePaneProps = {
  view: Proto.webviewView
  isSocketConnected: boolean
}

let OverviewTablePaneStyle = styled.div`
  display: flex;
  flex-direction: column;
  width: 100%;
  height: 100vh;
  background-color: ${Color.gray20};
`

const OverviewTableStickyNav = styled.div`
  background-color: ${Color.gray20};
  position: sticky;
  top: 0;
  z-index: ${ZIndex.TableStickyHeader};
`

const OverviewTableMenu = styled.section`
  display: flex;
  flex-direction: row;
  align-items: center;
  margin-left: auto;
  margin-right: auto;
  /* Max and min width are based on fixed table layout and column widths */
  max-width: 2000px;
  min-width: 1400px;

  @media screen and (max-width: 2200px) {
    margin-left: ${SizeUnit(1 / 2)};
    margin-right: ${SizeUnit(1 / 2)};
  }
`

const OverviewTableResourceNameFilter = styled(ResourceNameFilter)`
  margin-left: ${SizeUnit(1 / 2)};
  margin-right: ${SizeUnit(1 / 2)};
  min-width: ${Width.sidebarDefault}px;
`

export default function OverviewTablePane(props: OverviewTablePaneProps) {
  return (
    <OverviewTablePaneStyle>
      <OverviewTableStickyNav>
        <HeaderBar
          view={props.view}
          currentPage={AnalyticsType.Grid}
          isSocketConnected={props.isSocketConnected}
        />
        <StarredResourceBar {...starredResourcePropsFromView(props.view, "")} />
        <OverviewTableMenu aria-label="Resource menu">
          <OverviewTableResourceNameFilter />
          <OverviewTableBulkActions uiButtons={props.view.uiButtons} />
          <OverviewTableDisplayOptions resources={props.view.uiResources} />
        </OverviewTableMenu>
      </OverviewTableStickyNav>
      <OverviewTable view={props.view} />
    </OverviewTablePaneStyle>
  )
}
