//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright 2020 The Tilt Dev Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by deepcopy-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Cluster) DeepCopyInto(out *Cluster) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Cluster.
func (in *Cluster) DeepCopy() *Cluster {
	if in == nil {
		return nil
	}
	out := new(Cluster)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Cluster) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterConnection) DeepCopyInto(out *ClusterConnection) {
	*out = *in
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(KubernetesClusterConnection)
		**out = **in
	}
	if in.Docker != nil {
		in, out := &in.Docker, &out.Docker
		*out = new(DockerClusterConnection)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterConnection.
func (in *ClusterConnection) DeepCopy() *ClusterConnection {
	if in == nil {
		return nil
	}
	out := new(ClusterConnection)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterConnectionStatus) DeepCopyInto(out *ClusterConnectionStatus) {
	*out = *in
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(KubernetesClusterConnectionStatus)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterConnectionStatus.
func (in *ClusterConnectionStatus) DeepCopy() *ClusterConnectionStatus {
	if in == nil {
		return nil
	}
	out := new(ClusterConnectionStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterList) DeepCopyInto(out *ClusterList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Cluster, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterList.
func (in *ClusterList) DeepCopy() *ClusterList {
	if in == nil {
		return nil
	}
	out := new(ClusterList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSpec) DeepCopyInto(out *ClusterSpec) {
	*out = *in
	if in.Connection != nil {
		in, out := &in.Connection, &out.Connection
		*out = new(ClusterConnection)
		(*in).DeepCopyInto(*out)
	}
	if in.DefaultRegistry != nil {
		in, out := &in.DefaultRegistry, &out.DefaultRegistry
		*out = new(RegistryHosting)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSpec.
func (in *ClusterSpec) DeepCopy() *ClusterSpec {
	if in == nil {
		return nil
	}
	out := new(ClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterStatus) DeepCopyInto(out *ClusterStatus) {
	*out = *in
	if in.ConnectedAt != nil {
		in, out := &in.ConnectedAt, &out.ConnectedAt
		*out = (*in).DeepCopy()
	}
	if in.Registry != nil {
		in, out := &in.Registry, &out.Registry
		*out = new(RegistryHosting)
		**out = **in
	}
	if in.Connection != nil {
		in, out := &in.Connection, &out.Connection
		*out = new(ClusterConnectionStatus)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterStatus.
func (in *ClusterStatus) DeepCopy() *ClusterStatus {
	if in == nil {
		return nil
	}
	out := new(ClusterStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Cmd) DeepCopyInto(out *Cmd) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Cmd.
func (in *Cmd) DeepCopy() *Cmd {
	if in == nil {
		return nil
	}
	out := new(Cmd)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Cmd) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdImage) DeepCopyInto(out *CmdImage) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdImage.
func (in *CmdImage) DeepCopy() *CmdImage {
	if in == nil {
		return nil
	}
	out := new(CmdImage)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CmdImage) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdImageList) DeepCopyInto(out *CmdImageList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CmdImage, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdImageList.
func (in *CmdImageList) DeepCopy() *CmdImageList {
	if in == nil {
		return nil
	}
	out := new(CmdImageList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CmdImageList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdImageSpec) DeepCopyInto(out *CmdImageSpec) {
	*out = *in
	if in.Args != nil {
		in, out := &in.Args, &out.Args
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ImageMaps != nil {
		in, out := &in.ImageMaps, &out.ImageMaps
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdImageSpec.
func (in *CmdImageSpec) DeepCopy() *CmdImageSpec {
	if in == nil {
		return nil
	}
	out := new(CmdImageSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdImageStateBuilding) DeepCopyInto(out *CmdImageStateBuilding) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdImageStateBuilding.
func (in *CmdImageStateBuilding) DeepCopy() *CmdImageStateBuilding {
	if in == nil {
		return nil
	}
	out := new(CmdImageStateBuilding)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdImageStateCompleted) DeepCopyInto(out *CmdImageStateCompleted) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	in.FinishedAt.DeepCopyInto(&out.FinishedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdImageStateCompleted.
func (in *CmdImageStateCompleted) DeepCopy() *CmdImageStateCompleted {
	if in == nil {
		return nil
	}
	out := new(CmdImageStateCompleted)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdImageStateWaiting) DeepCopyInto(out *CmdImageStateWaiting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdImageStateWaiting.
func (in *CmdImageStateWaiting) DeepCopy() *CmdImageStateWaiting {
	if in == nil {
		return nil
	}
	out := new(CmdImageStateWaiting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdImageStatus) DeepCopyInto(out *CmdImageStatus) {
	*out = *in
	if in.Waiting != nil {
		in, out := &in.Waiting, &out.Waiting
		*out = new(CmdImageStateWaiting)
		**out = **in
	}
	if in.Building != nil {
		in, out := &in.Building, &out.Building
		*out = new(CmdImageStateBuilding)
		(*in).DeepCopyInto(*out)
	}
	if in.Completed != nil {
		in, out := &in.Completed, &out.Completed
		*out = new(CmdImageStateCompleted)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdImageStatus.
func (in *CmdImageStatus) DeepCopy() *CmdImageStatus {
	if in == nil {
		return nil
	}
	out := new(CmdImageStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdList) DeepCopyInto(out *CmdList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Cmd, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdList.
func (in *CmdList) DeepCopy() *CmdList {
	if in == nil {
		return nil
	}
	out := new(CmdList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CmdList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdSpec) DeepCopyInto(out *CmdSpec) {
	*out = *in
	if in.Args != nil {
		in, out := &in.Args, &out.Args
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ReadinessProbe != nil {
		in, out := &in.ReadinessProbe, &out.ReadinessProbe
		*out = new(Probe)
		(*in).DeepCopyInto(*out)
	}
	if in.RestartOn != nil {
		in, out := &in.RestartOn, &out.RestartOn
		*out = new(RestartOnSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.StartOn != nil {
		in, out := &in.StartOn, &out.StartOn
		*out = new(StartOnSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.DisableSource != nil {
		in, out := &in.DisableSource, &out.DisableSource
		*out = new(DisableSource)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdSpec.
func (in *CmdSpec) DeepCopy() *CmdSpec {
	if in == nil {
		return nil
	}
	out := new(CmdSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdStateRunning) DeepCopyInto(out *CmdStateRunning) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdStateRunning.
func (in *CmdStateRunning) DeepCopy() *CmdStateRunning {
	if in == nil {
		return nil
	}
	out := new(CmdStateRunning)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdStateTerminated) DeepCopyInto(out *CmdStateTerminated) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	in.FinishedAt.DeepCopyInto(&out.FinishedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdStateTerminated.
func (in *CmdStateTerminated) DeepCopy() *CmdStateTerminated {
	if in == nil {
		return nil
	}
	out := new(CmdStateTerminated)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdStateWaiting) DeepCopyInto(out *CmdStateWaiting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdStateWaiting.
func (in *CmdStateWaiting) DeepCopy() *CmdStateWaiting {
	if in == nil {
		return nil
	}
	out := new(CmdStateWaiting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CmdStatus) DeepCopyInto(out *CmdStatus) {
	*out = *in
	if in.Waiting != nil {
		in, out := &in.Waiting, &out.Waiting
		*out = new(CmdStateWaiting)
		**out = **in
	}
	if in.Running != nil {
		in, out := &in.Running, &out.Running
		*out = new(CmdStateRunning)
		(*in).DeepCopyInto(*out)
	}
	if in.Terminated != nil {
		in, out := &in.Terminated, &out.Terminated
		*out = new(CmdStateTerminated)
		(*in).DeepCopyInto(*out)
	}
	if in.DisableStatus != nil {
		in, out := &in.DisableStatus, &out.DisableStatus
		*out = new(DisableStatus)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CmdStatus.
func (in *CmdStatus) DeepCopy() *CmdStatus {
	if in == nil {
		return nil
	}
	out := new(CmdStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConfigMap) DeepCopyInto(out *ConfigMap) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	if in.Data != nil {
		in, out := &in.Data, &out.Data
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConfigMap.
func (in *ConfigMap) DeepCopy() *ConfigMap {
	if in == nil {
		return nil
	}
	out := new(ConfigMap)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ConfigMap) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConfigMapDisableSource) DeepCopyInto(out *ConfigMapDisableSource) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConfigMapDisableSource.
func (in *ConfigMapDisableSource) DeepCopy() *ConfigMapDisableSource {
	if in == nil {
		return nil
	}
	out := new(ConfigMapDisableSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConfigMapList) DeepCopyInto(out *ConfigMapList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ConfigMap, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConfigMapList.
func (in *ConfigMapList) DeepCopy() *ConfigMapList {
	if in == nil {
		return nil
	}
	out := new(ConfigMapList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ConfigMapList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConfigMapStateSource) DeepCopyInto(out *ConfigMapStateSource) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConfigMapStateSource.
func (in *ConfigMapStateSource) DeepCopy() *ConfigMapStateSource {
	if in == nil {
		return nil
	}
	out := new(ConfigMapStateSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Container) DeepCopyInto(out *Container) {
	*out = *in
	in.State.DeepCopyInto(&out.State)
	if in.Ports != nil {
		in, out := &in.Ports, &out.Ports
		*out = make([]int32, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Container.
func (in *Container) DeepCopy() *Container {
	if in == nil {
		return nil
	}
	out := new(Container)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ContainerLogStreamStatus) DeepCopyInto(out *ContainerLogStreamStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ContainerLogStreamStatus.
func (in *ContainerLogStreamStatus) DeepCopy() *ContainerLogStreamStatus {
	if in == nil {
		return nil
	}
	out := new(ContainerLogStreamStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ContainerState) DeepCopyInto(out *ContainerState) {
	*out = *in
	if in.Waiting != nil {
		in, out := &in.Waiting, &out.Waiting
		*out = new(ContainerStateWaiting)
		**out = **in
	}
	if in.Running != nil {
		in, out := &in.Running, &out.Running
		*out = new(ContainerStateRunning)
		(*in).DeepCopyInto(*out)
	}
	if in.Terminated != nil {
		in, out := &in.Terminated, &out.Terminated
		*out = new(ContainerStateTerminated)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ContainerState.
func (in *ContainerState) DeepCopy() *ContainerState {
	if in == nil {
		return nil
	}
	out := new(ContainerState)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ContainerStateRunning) DeepCopyInto(out *ContainerStateRunning) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ContainerStateRunning.
func (in *ContainerStateRunning) DeepCopy() *ContainerStateRunning {
	if in == nil {
		return nil
	}
	out := new(ContainerStateRunning)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ContainerStateTerminated) DeepCopyInto(out *ContainerStateTerminated) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	in.FinishedAt.DeepCopyInto(&out.FinishedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ContainerStateTerminated.
func (in *ContainerStateTerminated) DeepCopy() *ContainerStateTerminated {
	if in == nil {
		return nil
	}
	out := new(ContainerStateTerminated)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ContainerStateWaiting) DeepCopyInto(out *ContainerStateWaiting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ContainerStateWaiting.
func (in *ContainerStateWaiting) DeepCopy() *ContainerStateWaiting {
	if in == nil {
		return nil
	}
	out := new(ContainerStateWaiting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DisableResourceStatus) DeepCopyInto(out *DisableResourceStatus) {
	*out = *in
	if in.Sources != nil {
		in, out := &in.Sources, &out.Sources
		*out = make([]DisableSource, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DisableResourceStatus.
func (in *DisableResourceStatus) DeepCopy() *DisableResourceStatus {
	if in == nil {
		return nil
	}
	out := new(DisableResourceStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DisableSource) DeepCopyInto(out *DisableSource) {
	*out = *in
	if in.ConfigMap != nil {
		in, out := &in.ConfigMap, &out.ConfigMap
		*out = new(ConfigMapDisableSource)
		**out = **in
	}
	if in.EveryConfigMap != nil {
		in, out := &in.EveryConfigMap, &out.EveryConfigMap
		*out = make([]ConfigMapDisableSource, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DisableSource.
func (in *DisableSource) DeepCopy() *DisableSource {
	if in == nil {
		return nil
	}
	out := new(DisableSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DisableStatus) DeepCopyInto(out *DisableStatus) {
	*out = *in
	in.LastUpdateTime.DeepCopyInto(&out.LastUpdateTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DisableStatus.
func (in *DisableStatus) DeepCopy() *DisableStatus {
	if in == nil {
		return nil
	}
	out := new(DisableStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerClusterConnection) DeepCopyInto(out *DockerClusterConnection) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerClusterConnection.
func (in *DockerClusterConnection) DeepCopy() *DockerClusterConnection {
	if in == nil {
		return nil
	}
	out := new(DockerClusterConnection)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerComposeLogStream) DeepCopyInto(out *DockerComposeLogStream) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerComposeLogStream.
func (in *DockerComposeLogStream) DeepCopy() *DockerComposeLogStream {
	if in == nil {
		return nil
	}
	out := new(DockerComposeLogStream)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DockerComposeLogStream) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerComposeLogStreamList) DeepCopyInto(out *DockerComposeLogStreamList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DockerComposeLogStream, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerComposeLogStreamList.
func (in *DockerComposeLogStreamList) DeepCopy() *DockerComposeLogStreamList {
	if in == nil {
		return nil
	}
	out := new(DockerComposeLogStreamList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DockerComposeLogStreamList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerComposeLogStreamSpec) DeepCopyInto(out *DockerComposeLogStreamSpec) {
	*out = *in
	in.Project.DeepCopyInto(&out.Project)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerComposeLogStreamSpec.
func (in *DockerComposeLogStreamSpec) DeepCopy() *DockerComposeLogStreamSpec {
	if in == nil {
		return nil
	}
	out := new(DockerComposeLogStreamSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerComposeLogStreamStatus) DeepCopyInto(out *DockerComposeLogStreamStatus) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerComposeLogStreamStatus.
func (in *DockerComposeLogStreamStatus) DeepCopy() *DockerComposeLogStreamStatus {
	if in == nil {
		return nil
	}
	out := new(DockerComposeLogStreamStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerComposeProject) DeepCopyInto(out *DockerComposeProject) {
	*out = *in
	if in.ConfigPaths != nil {
		in, out := &in.ConfigPaths, &out.ConfigPaths
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerComposeProject.
func (in *DockerComposeProject) DeepCopy() *DockerComposeProject {
	if in == nil {
		return nil
	}
	out := new(DockerComposeProject)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerComposeService) DeepCopyInto(out *DockerComposeService) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerComposeService.
func (in *DockerComposeService) DeepCopy() *DockerComposeService {
	if in == nil {
		return nil
	}
	out := new(DockerComposeService)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DockerComposeService) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerComposeServiceList) DeepCopyInto(out *DockerComposeServiceList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DockerComposeService, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerComposeServiceList.
func (in *DockerComposeServiceList) DeepCopy() *DockerComposeServiceList {
	if in == nil {
		return nil
	}
	out := new(DockerComposeServiceList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DockerComposeServiceList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerComposeServiceSpec) DeepCopyInto(out *DockerComposeServiceSpec) {
	*out = *in
	in.Project.DeepCopyInto(&out.Project)
	if in.ImageMaps != nil {
		in, out := &in.ImageMaps, &out.ImageMaps
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.DisableSource != nil {
		in, out := &in.DisableSource, &out.DisableSource
		*out = new(DisableSource)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerComposeServiceSpec.
func (in *DockerComposeServiceSpec) DeepCopy() *DockerComposeServiceSpec {
	if in == nil {
		return nil
	}
	out := new(DockerComposeServiceSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerComposeServiceStatus) DeepCopyInto(out *DockerComposeServiceStatus) {
	*out = *in
	if in.DisableStatus != nil {
		in, out := &in.DisableStatus, &out.DisableStatus
		*out = new(DisableStatus)
		(*in).DeepCopyInto(*out)
	}
	if in.PortBindings != nil {
		in, out := &in.PortBindings, &out.PortBindings
		*out = make([]DockerPortBinding, len(*in))
		copy(*out, *in)
	}
	if in.ContainerState != nil {
		in, out := &in.ContainerState, &out.ContainerState
		*out = new(DockerContainerState)
		(*in).DeepCopyInto(*out)
	}
	in.LastApplyStartTime.DeepCopyInto(&out.LastApplyStartTime)
	in.LastApplyFinishTime.DeepCopyInto(&out.LastApplyFinishTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerComposeServiceStatus.
func (in *DockerComposeServiceStatus) DeepCopy() *DockerComposeServiceStatus {
	if in == nil {
		return nil
	}
	out := new(DockerComposeServiceStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerContainerState) DeepCopyInto(out *DockerContainerState) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	in.FinishedAt.DeepCopyInto(&out.FinishedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerContainerState.
func (in *DockerContainerState) DeepCopy() *DockerContainerState {
	if in == nil {
		return nil
	}
	out := new(DockerContainerState)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerImage) DeepCopyInto(out *DockerImage) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerImage.
func (in *DockerImage) DeepCopy() *DockerImage {
	if in == nil {
		return nil
	}
	out := new(DockerImage)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DockerImage) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerImageList) DeepCopyInto(out *DockerImageList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DockerImage, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerImageList.
func (in *DockerImageList) DeepCopy() *DockerImageList {
	if in == nil {
		return nil
	}
	out := new(DockerImageList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DockerImageList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerImageSpec) DeepCopyInto(out *DockerImageSpec) {
	*out = *in
	if in.ContextIgnores != nil {
		in, out := &in.ContextIgnores, &out.ContextIgnores
		*out = make([]IgnoreDef, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Args != nil {
		in, out := &in.Args, &out.Args
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SSHAgentConfigs != nil {
		in, out := &in.SSHAgentConfigs, &out.SSHAgentConfigs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.CacheFrom != nil {
		in, out := &in.CacheFrom, &out.CacheFrom
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ExtraTags != nil {
		in, out := &in.ExtraTags, &out.ExtraTags
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ImageMaps != nil {
		in, out := &in.ImageMaps, &out.ImageMaps
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerImageSpec.
func (in *DockerImageSpec) DeepCopy() *DockerImageSpec {
	if in == nil {
		return nil
	}
	out := new(DockerImageSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerImageStageStatus) DeepCopyInto(out *DockerImageStageStatus) {
	*out = *in
	if in.StartedAt != nil {
		in, out := &in.StartedAt, &out.StartedAt
		*out = (*in).DeepCopy()
	}
	if in.FinishedAt != nil {
		in, out := &in.FinishedAt, &out.FinishedAt
		*out = (*in).DeepCopy()
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerImageStageStatus.
func (in *DockerImageStageStatus) DeepCopy() *DockerImageStageStatus {
	if in == nil {
		return nil
	}
	out := new(DockerImageStageStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerImageStateBuilding) DeepCopyInto(out *DockerImageStateBuilding) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerImageStateBuilding.
func (in *DockerImageStateBuilding) DeepCopy() *DockerImageStateBuilding {
	if in == nil {
		return nil
	}
	out := new(DockerImageStateBuilding)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerImageStateCompleted) DeepCopyInto(out *DockerImageStateCompleted) {
	*out = *in
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	in.FinishedAt.DeepCopyInto(&out.FinishedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerImageStateCompleted.
func (in *DockerImageStateCompleted) DeepCopy() *DockerImageStateCompleted {
	if in == nil {
		return nil
	}
	out := new(DockerImageStateCompleted)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerImageStateWaiting) DeepCopyInto(out *DockerImageStateWaiting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerImageStateWaiting.
func (in *DockerImageStateWaiting) DeepCopy() *DockerImageStateWaiting {
	if in == nil {
		return nil
	}
	out := new(DockerImageStateWaiting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerImageStatus) DeepCopyInto(out *DockerImageStatus) {
	*out = *in
	if in.Waiting != nil {
		in, out := &in.Waiting, &out.Waiting
		*out = new(DockerImageStateWaiting)
		**out = **in
	}
	if in.Building != nil {
		in, out := &in.Building, &out.Building
		*out = new(DockerImageStateBuilding)
		(*in).DeepCopyInto(*out)
	}
	if in.Completed != nil {
		in, out := &in.Completed, &out.Completed
		*out = new(DockerImageStateCompleted)
		(*in).DeepCopyInto(*out)
	}
	if in.StageStatuses != nil {
		in, out := &in.StageStatuses, &out.StageStatuses
		*out = make([]DockerImageStageStatus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerImageStatus.
func (in *DockerImageStatus) DeepCopy() *DockerImageStatus {
	if in == nil {
		return nil
	}
	out := new(DockerImageStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerPortBinding) DeepCopyInto(out *DockerPortBinding) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerPortBinding.
func (in *DockerPortBinding) DeepCopy() *DockerPortBinding {
	if in == nil {
		return nil
	}
	out := new(DockerPortBinding)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExecAction) DeepCopyInto(out *ExecAction) {
	*out = *in
	if in.Command != nil {
		in, out := &in.Command, &out.Command
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExecAction.
func (in *ExecAction) DeepCopy() *ExecAction {
	if in == nil {
		return nil
	}
	out := new(ExecAction)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Extension) DeepCopyInto(out *Extension) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Extension.
func (in *Extension) DeepCopy() *Extension {
	if in == nil {
		return nil
	}
	out := new(Extension)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Extension) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtensionList) DeepCopyInto(out *ExtensionList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Extension, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtensionList.
func (in *ExtensionList) DeepCopy() *ExtensionList {
	if in == nil {
		return nil
	}
	out := new(ExtensionList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ExtensionList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtensionRepo) DeepCopyInto(out *ExtensionRepo) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtensionRepo.
func (in *ExtensionRepo) DeepCopy() *ExtensionRepo {
	if in == nil {
		return nil
	}
	out := new(ExtensionRepo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ExtensionRepo) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtensionRepoList) DeepCopyInto(out *ExtensionRepoList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ExtensionRepo, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtensionRepoList.
func (in *ExtensionRepoList) DeepCopy() *ExtensionRepoList {
	if in == nil {
		return nil
	}
	out := new(ExtensionRepoList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ExtensionRepoList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtensionRepoSpec) DeepCopyInto(out *ExtensionRepoSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtensionRepoSpec.
func (in *ExtensionRepoSpec) DeepCopy() *ExtensionRepoSpec {
	if in == nil {
		return nil
	}
	out := new(ExtensionRepoSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtensionRepoStatus) DeepCopyInto(out *ExtensionRepoStatus) {
	*out = *in
	in.LastFetchedAt.DeepCopyInto(&out.LastFetchedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtensionRepoStatus.
func (in *ExtensionRepoStatus) DeepCopy() *ExtensionRepoStatus {
	if in == nil {
		return nil
	}
	out := new(ExtensionRepoStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtensionSpec) DeepCopyInto(out *ExtensionSpec) {
	*out = *in
	if in.Args != nil {
		in, out := &in.Args, &out.Args
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtensionSpec.
func (in *ExtensionSpec) DeepCopy() *ExtensionSpec {
	if in == nil {
		return nil
	}
	out := new(ExtensionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExtensionStatus) DeepCopyInto(out *ExtensionStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExtensionStatus.
func (in *ExtensionStatus) DeepCopy() *ExtensionStatus {
	if in == nil {
		return nil
	}
	out := new(ExtensionStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FileEvent) DeepCopyInto(out *FileEvent) {
	*out = *in
	in.Time.DeepCopyInto(&out.Time)
	if in.SeenFiles != nil {
		in, out := &in.SeenFiles, &out.SeenFiles
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FileEvent.
func (in *FileEvent) DeepCopy() *FileEvent {
	if in == nil {
		return nil
	}
	out := new(FileEvent)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FileWatch) DeepCopyInto(out *FileWatch) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FileWatch.
func (in *FileWatch) DeepCopy() *FileWatch {
	if in == nil {
		return nil
	}
	out := new(FileWatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *FileWatch) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FileWatchList) DeepCopyInto(out *FileWatchList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]FileWatch, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FileWatchList.
func (in *FileWatchList) DeepCopy() *FileWatchList {
	if in == nil {
		return nil
	}
	out := new(FileWatchList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *FileWatchList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FileWatchSpec) DeepCopyInto(out *FileWatchSpec) {
	*out = *in
	if in.WatchedPaths != nil {
		in, out := &in.WatchedPaths, &out.WatchedPaths
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Ignores != nil {
		in, out := &in.Ignores, &out.Ignores
		*out = make([]IgnoreDef, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DisableSource != nil {
		in, out := &in.DisableSource, &out.DisableSource
		*out = new(DisableSource)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FileWatchSpec.
func (in *FileWatchSpec) DeepCopy() *FileWatchSpec {
	if in == nil {
		return nil
	}
	out := new(FileWatchSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FileWatchStatus) DeepCopyInto(out *FileWatchStatus) {
	*out = *in
	in.MonitorStartTime.DeepCopyInto(&out.MonitorStartTime)
	in.LastEventTime.DeepCopyInto(&out.LastEventTime)
	if in.FileEvents != nil {
		in, out := &in.FileEvents, &out.FileEvents
		*out = make([]FileEvent, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DisableStatus != nil {
		in, out := &in.DisableStatus, &out.DisableStatus
		*out = new(DisableStatus)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FileWatchStatus.
func (in *FileWatchStatus) DeepCopy() *FileWatchStatus {
	if in == nil {
		return nil
	}
	out := new(FileWatchStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Forward) DeepCopyInto(out *Forward) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Forward.
func (in *Forward) DeepCopy() *Forward {
	if in == nil {
		return nil
	}
	out := new(Forward)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ForwardStatus) DeepCopyInto(out *ForwardStatus) {
	*out = *in
	if in.Addresses != nil {
		in, out := &in.Addresses, &out.Addresses
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ForwardStatus.
func (in *ForwardStatus) DeepCopy() *ForwardStatus {
	if in == nil {
		return nil
	}
	out := new(ForwardStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPGetAction) DeepCopyInto(out *HTTPGetAction) {
	*out = *in
	if in.HTTPHeaders != nil {
		in, out := &in.HTTPHeaders, &out.HTTPHeaders
		*out = make([]HTTPHeader, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPGetAction.
func (in *HTTPGetAction) DeepCopy() *HTTPGetAction {
	if in == nil {
		return nil
	}
	out := new(HTTPGetAction)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPHeader) DeepCopyInto(out *HTTPHeader) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPHeader.
func (in *HTTPHeader) DeepCopy() *HTTPHeader {
	if in == nil {
		return nil
	}
	out := new(HTTPHeader)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Handler) DeepCopyInto(out *Handler) {
	*out = *in
	if in.Exec != nil {
		in, out := &in.Exec, &out.Exec
		*out = new(ExecAction)
		(*in).DeepCopyInto(*out)
	}
	if in.HTTPGet != nil {
		in, out := &in.HTTPGet, &out.HTTPGet
		*out = new(HTTPGetAction)
		(*in).DeepCopyInto(*out)
	}
	if in.TCPSocket != nil {
		in, out := &in.TCPSocket, &out.TCPSocket
		*out = new(TCPSocketAction)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Handler.
func (in *Handler) DeepCopy() *Handler {
	if in == nil {
		return nil
	}
	out := new(Handler)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IgnoreDef) DeepCopyInto(out *IgnoreDef) {
	*out = *in
	if in.Patterns != nil {
		in, out := &in.Patterns, &out.Patterns
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IgnoreDef.
func (in *IgnoreDef) DeepCopy() *IgnoreDef {
	if in == nil {
		return nil
	}
	out := new(IgnoreDef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageMap) DeepCopyInto(out *ImageMap) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageMap.
func (in *ImageMap) DeepCopy() *ImageMap {
	if in == nil {
		return nil
	}
	out := new(ImageMap)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ImageMap) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageMapList) DeepCopyInto(out *ImageMapList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ImageMap, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageMapList.
func (in *ImageMapList) DeepCopy() *ImageMapList {
	if in == nil {
		return nil
	}
	out := new(ImageMapList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ImageMapList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageMapOverrideArgs) DeepCopyInto(out *ImageMapOverrideArgs) {
	*out = *in
	if in.Args != nil {
		in, out := &in.Args, &out.Args
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageMapOverrideArgs.
func (in *ImageMapOverrideArgs) DeepCopy() *ImageMapOverrideArgs {
	if in == nil {
		return nil
	}
	out := new(ImageMapOverrideArgs)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageMapOverrideCommand) DeepCopyInto(out *ImageMapOverrideCommand) {
	*out = *in
	if in.Command != nil {
		in, out := &in.Command, &out.Command
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageMapOverrideCommand.
func (in *ImageMapOverrideCommand) DeepCopy() *ImageMapOverrideCommand {
	if in == nil {
		return nil
	}
	out := new(ImageMapOverrideCommand)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageMapSpec) DeepCopyInto(out *ImageMapSpec) {
	*out = *in
	if in.OverrideCommand != nil {
		in, out := &in.OverrideCommand, &out.OverrideCommand
		*out = new(ImageMapOverrideCommand)
		(*in).DeepCopyInto(*out)
	}
	if in.OverrideArgs != nil {
		in, out := &in.OverrideArgs, &out.OverrideArgs
		*out = new(ImageMapOverrideArgs)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageMapSpec.
func (in *ImageMapSpec) DeepCopy() *ImageMapSpec {
	if in == nil {
		return nil
	}
	out := new(ImageMapSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageMapStatus) DeepCopyInto(out *ImageMapStatus) {
	*out = *in
	if in.BuildStartTime != nil {
		in, out := &in.BuildStartTime, &out.BuildStartTime
		*out = (*in).DeepCopy()
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageMapStatus.
func (in *ImageMapStatus) DeepCopy() *ImageMapStatus {
	if in == nil {
		return nil
	}
	out := new(ImageMapStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesApply) DeepCopyInto(out *KubernetesApply) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesApply.
func (in *KubernetesApply) DeepCopy() *KubernetesApply {
	if in == nil {
		return nil
	}
	out := new(KubernetesApply)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KubernetesApply) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesApplyCmd) DeepCopyInto(out *KubernetesApplyCmd) {
	*out = *in
	if in.Args != nil {
		in, out := &in.Args, &out.Args
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesApplyCmd.
func (in *KubernetesApplyCmd) DeepCopy() *KubernetesApplyCmd {
	if in == nil {
		return nil
	}
	out := new(KubernetesApplyCmd)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesApplyList) DeepCopyInto(out *KubernetesApplyList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]KubernetesApply, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesApplyList.
func (in *KubernetesApplyList) DeepCopy() *KubernetesApplyList {
	if in == nil {
		return nil
	}
	out := new(KubernetesApplyList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KubernetesApplyList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesApplySpec) DeepCopyInto(out *KubernetesApplySpec) {
	*out = *in
	if in.ImageMaps != nil {
		in, out := &in.ImageMaps, &out.ImageMaps
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ImageLocators != nil {
		in, out := &in.ImageLocators, &out.ImageLocators
		*out = make([]KubernetesImageLocator, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	out.Timeout = in.Timeout
	if in.KubernetesDiscoveryTemplateSpec != nil {
		in, out := &in.KubernetesDiscoveryTemplateSpec, &out.KubernetesDiscoveryTemplateSpec
		*out = new(KubernetesDiscoveryTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.PortForwardTemplateSpec != nil {
		in, out := &in.PortForwardTemplateSpec, &out.PortForwardTemplateSpec
		*out = new(PortForwardTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.PodLogStreamTemplateSpec != nil {
		in, out := &in.PodLogStreamTemplateSpec, &out.PodLogStreamTemplateSpec
		*out = new(PodLogStreamTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.DisableSource != nil {
		in, out := &in.DisableSource, &out.DisableSource
		*out = new(DisableSource)
		(*in).DeepCopyInto(*out)
	}
	if in.ApplyCmd != nil {
		in, out := &in.ApplyCmd, &out.ApplyCmd
		*out = new(KubernetesApplyCmd)
		(*in).DeepCopyInto(*out)
	}
	if in.RestartOn != nil {
		in, out := &in.RestartOn, &out.RestartOn
		*out = new(RestartOnSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.DeleteCmd != nil {
		in, out := &in.DeleteCmd, &out.DeleteCmd
		*out = new(KubernetesApplyCmd)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesApplySpec.
func (in *KubernetesApplySpec) DeepCopy() *KubernetesApplySpec {
	if in == nil {
		return nil
	}
	out := new(KubernetesApplySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesApplyStatus) DeepCopyInto(out *KubernetesApplyStatus) {
	*out = *in
	in.LastApplyTime.DeepCopyInto(&out.LastApplyTime)
	in.LastApplyStartTime.DeepCopyInto(&out.LastApplyStartTime)
	if in.DisableStatus != nil {
		in, out := &in.DisableStatus, &out.DisableStatus
		*out = new(DisableStatus)
		(*in).DeepCopyInto(*out)
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]v1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesApplyStatus.
func (in *KubernetesApplyStatus) DeepCopy() *KubernetesApplyStatus {
	if in == nil {
		return nil
	}
	out := new(KubernetesApplyStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesClusterConnection) DeepCopyInto(out *KubernetesClusterConnection) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesClusterConnection.
func (in *KubernetesClusterConnection) DeepCopy() *KubernetesClusterConnection {
	if in == nil {
		return nil
	}
	out := new(KubernetesClusterConnection)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesClusterConnectionStatus) DeepCopyInto(out *KubernetesClusterConnectionStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesClusterConnectionStatus.
func (in *KubernetesClusterConnectionStatus) DeepCopy() *KubernetesClusterConnectionStatus {
	if in == nil {
		return nil
	}
	out := new(KubernetesClusterConnectionStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesDiscovery) DeepCopyInto(out *KubernetesDiscovery) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesDiscovery.
func (in *KubernetesDiscovery) DeepCopy() *KubernetesDiscovery {
	if in == nil {
		return nil
	}
	out := new(KubernetesDiscovery)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KubernetesDiscovery) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesDiscoveryList) DeepCopyInto(out *KubernetesDiscoveryList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]KubernetesDiscovery, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesDiscoveryList.
func (in *KubernetesDiscoveryList) DeepCopy() *KubernetesDiscoveryList {
	if in == nil {
		return nil
	}
	out := new(KubernetesDiscoveryList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KubernetesDiscoveryList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesDiscoverySpec) DeepCopyInto(out *KubernetesDiscoverySpec) {
	*out = *in
	if in.Watches != nil {
		in, out := &in.Watches, &out.Watches
		*out = make([]KubernetesWatchRef, len(*in))
		copy(*out, *in)
	}
	if in.ExtraSelectors != nil {
		in, out := &in.ExtraSelectors, &out.ExtraSelectors
		*out = make([]v1.LabelSelector, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.PortForwardTemplateSpec != nil {
		in, out := &in.PortForwardTemplateSpec, &out.PortForwardTemplateSpec
		*out = new(PortForwardTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.PodLogStreamTemplateSpec != nil {
		in, out := &in.PodLogStreamTemplateSpec, &out.PodLogStreamTemplateSpec
		*out = new(PodLogStreamTemplateSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesDiscoverySpec.
func (in *KubernetesDiscoverySpec) DeepCopy() *KubernetesDiscoverySpec {
	if in == nil {
		return nil
	}
	out := new(KubernetesDiscoverySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesDiscoveryStateRunning) DeepCopyInto(out *KubernetesDiscoveryStateRunning) {
	*out = *in
	in.StartTime.DeepCopyInto(&out.StartTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesDiscoveryStateRunning.
func (in *KubernetesDiscoveryStateRunning) DeepCopy() *KubernetesDiscoveryStateRunning {
	if in == nil {
		return nil
	}
	out := new(KubernetesDiscoveryStateRunning)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesDiscoveryStateWaiting) DeepCopyInto(out *KubernetesDiscoveryStateWaiting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesDiscoveryStateWaiting.
func (in *KubernetesDiscoveryStateWaiting) DeepCopy() *KubernetesDiscoveryStateWaiting {
	if in == nil {
		return nil
	}
	out := new(KubernetesDiscoveryStateWaiting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesDiscoveryStatus) DeepCopyInto(out *KubernetesDiscoveryStatus) {
	*out = *in
	in.MonitorStartTime.DeepCopyInto(&out.MonitorStartTime)
	if in.Pods != nil {
		in, out := &in.Pods, &out.Pods
		*out = make([]Pod, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Waiting != nil {
		in, out := &in.Waiting, &out.Waiting
		*out = new(KubernetesDiscoveryStateWaiting)
		**out = **in
	}
	if in.Running != nil {
		in, out := &in.Running, &out.Running
		*out = new(KubernetesDiscoveryStateRunning)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesDiscoveryStatus.
func (in *KubernetesDiscoveryStatus) DeepCopy() *KubernetesDiscoveryStatus {
	if in == nil {
		return nil
	}
	out := new(KubernetesDiscoveryStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesDiscoveryTemplateSpec) DeepCopyInto(out *KubernetesDiscoveryTemplateSpec) {
	*out = *in
	if in.ExtraSelectors != nil {
		in, out := &in.ExtraSelectors, &out.ExtraSelectors
		*out = make([]v1.LabelSelector, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesDiscoveryTemplateSpec.
func (in *KubernetesDiscoveryTemplateSpec) DeepCopy() *KubernetesDiscoveryTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(KubernetesDiscoveryTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesImageLocator) DeepCopyInto(out *KubernetesImageLocator) {
	*out = *in
	out.ObjectSelector = in.ObjectSelector
	if in.Object != nil {
		in, out := &in.Object, &out.Object
		*out = new(KubernetesImageObjectDescriptor)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesImageLocator.
func (in *KubernetesImageLocator) DeepCopy() *KubernetesImageLocator {
	if in == nil {
		return nil
	}
	out := new(KubernetesImageLocator)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesImageObjectDescriptor) DeepCopyInto(out *KubernetesImageObjectDescriptor) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesImageObjectDescriptor.
func (in *KubernetesImageObjectDescriptor) DeepCopy() *KubernetesImageObjectDescriptor {
	if in == nil {
		return nil
	}
	out := new(KubernetesImageObjectDescriptor)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesWatchRef) DeepCopyInto(out *KubernetesWatchRef) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesWatchRef.
func (in *KubernetesWatchRef) DeepCopy() *KubernetesWatchRef {
	if in == nil {
		return nil
	}
	out := new(KubernetesWatchRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdate) DeepCopyInto(out *LiveUpdate) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdate.
func (in *LiveUpdate) DeepCopy() *LiveUpdate {
	if in == nil {
		return nil
	}
	out := new(LiveUpdate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *LiveUpdate) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateContainerStateWaiting) DeepCopyInto(out *LiveUpdateContainerStateWaiting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateContainerStateWaiting.
func (in *LiveUpdateContainerStateWaiting) DeepCopy() *LiveUpdateContainerStateWaiting {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateContainerStateWaiting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateContainerStatus) DeepCopyInto(out *LiveUpdateContainerStatus) {
	*out = *in
	in.LastFileTimeSynced.DeepCopyInto(&out.LastFileTimeSynced)
	if in.Waiting != nil {
		in, out := &in.Waiting, &out.Waiting
		*out = new(LiveUpdateContainerStateWaiting)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateContainerStatus.
func (in *LiveUpdateContainerStatus) DeepCopy() *LiveUpdateContainerStatus {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateContainerStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateDockerComposeSelector) DeepCopyInto(out *LiveUpdateDockerComposeSelector) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateDockerComposeSelector.
func (in *LiveUpdateDockerComposeSelector) DeepCopy() *LiveUpdateDockerComposeSelector {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateDockerComposeSelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateExec) DeepCopyInto(out *LiveUpdateExec) {
	*out = *in
	if in.Args != nil {
		in, out := &in.Args, &out.Args
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.TriggerPaths != nil {
		in, out := &in.TriggerPaths, &out.TriggerPaths
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateExec.
func (in *LiveUpdateExec) DeepCopy() *LiveUpdateExec {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateExec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateKubernetesSelector) DeepCopyInto(out *LiveUpdateKubernetesSelector) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateKubernetesSelector.
func (in *LiveUpdateKubernetesSelector) DeepCopy() *LiveUpdateKubernetesSelector {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateKubernetesSelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateList) DeepCopyInto(out *LiveUpdateList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]LiveUpdate, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateList.
func (in *LiveUpdateList) DeepCopy() *LiveUpdateList {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *LiveUpdateList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateSelector) DeepCopyInto(out *LiveUpdateSelector) {
	*out = *in
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(LiveUpdateKubernetesSelector)
		**out = **in
	}
	if in.DockerCompose != nil {
		in, out := &in.DockerCompose, &out.DockerCompose
		*out = new(LiveUpdateDockerComposeSelector)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateSelector.
func (in *LiveUpdateSelector) DeepCopy() *LiveUpdateSelector {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateSelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateSource) DeepCopyInto(out *LiveUpdateSource) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateSource.
func (in *LiveUpdateSource) DeepCopy() *LiveUpdateSource {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateSpec) DeepCopyInto(out *LiveUpdateSpec) {
	*out = *in
	in.Selector.DeepCopyInto(&out.Selector)
	if in.Sources != nil {
		in, out := &in.Sources, &out.Sources
		*out = make([]LiveUpdateSource, len(*in))
		copy(*out, *in)
	}
	if in.StopPaths != nil {
		in, out := &in.StopPaths, &out.StopPaths
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Syncs != nil {
		in, out := &in.Syncs, &out.Syncs
		*out = make([]LiveUpdateSync, len(*in))
		copy(*out, *in)
	}
	if in.Execs != nil {
		in, out := &in.Execs, &out.Execs
		*out = make([]LiveUpdateExec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateSpec.
func (in *LiveUpdateSpec) DeepCopy() *LiveUpdateSpec {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateStateFailed) DeepCopyInto(out *LiveUpdateStateFailed) {
	*out = *in
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateStateFailed.
func (in *LiveUpdateStateFailed) DeepCopy() *LiveUpdateStateFailed {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateStateFailed)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateStatus) DeepCopyInto(out *LiveUpdateStatus) {
	*out = *in
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]LiveUpdateContainerStatus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Failed != nil {
		in, out := &in.Failed, &out.Failed
		*out = new(LiveUpdateStateFailed)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateStatus.
func (in *LiveUpdateStatus) DeepCopy() *LiveUpdateStatus {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LiveUpdateSync) DeepCopyInto(out *LiveUpdateSync) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LiveUpdateSync.
func (in *LiveUpdateSync) DeepCopy() *LiveUpdateSync {
	if in == nil {
		return nil
	}
	out := new(LiveUpdateSync)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectSelector) DeepCopyInto(out *ObjectSelector) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectSelector.
func (in *ObjectSelector) DeepCopy() *ObjectSelector {
	if in == nil {
		return nil
	}
	out := new(ObjectSelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Pod) DeepCopyInto(out *Pod) {
	*out = *in
	in.CreatedAt.DeepCopyInto(&out.CreatedAt)
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]PodCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]Container, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]Container, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Errors != nil {
		in, out := &in.Errors, &out.Errors
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Owner != nil {
		in, out := &in.Owner, &out.Owner
		*out = new(PodOwner)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Pod.
func (in *Pod) DeepCopy() *Pod {
	if in == nil {
		return nil
	}
	out := new(Pod)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodCondition) DeepCopyInto(out *PodCondition) {
	*out = *in
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodCondition.
func (in *PodCondition) DeepCopy() *PodCondition {
	if in == nil {
		return nil
	}
	out := new(PodCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodLogStream) DeepCopyInto(out *PodLogStream) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodLogStream.
func (in *PodLogStream) DeepCopy() *PodLogStream {
	if in == nil {
		return nil
	}
	out := new(PodLogStream)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *PodLogStream) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodLogStreamList) DeepCopyInto(out *PodLogStreamList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]PodLogStream, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodLogStreamList.
func (in *PodLogStreamList) DeepCopy() *PodLogStreamList {
	if in == nil {
		return nil
	}
	out := new(PodLogStreamList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *PodLogStreamList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodLogStreamSpec) DeepCopyInto(out *PodLogStreamSpec) {
	*out = *in
	if in.SinceTime != nil {
		in, out := &in.SinceTime, &out.SinceTime
		*out = (*in).DeepCopy()
	}
	if in.OnlyContainers != nil {
		in, out := &in.OnlyContainers, &out.OnlyContainers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.IgnoreContainers != nil {
		in, out := &in.IgnoreContainers, &out.IgnoreContainers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodLogStreamSpec.
func (in *PodLogStreamSpec) DeepCopy() *PodLogStreamSpec {
	if in == nil {
		return nil
	}
	out := new(PodLogStreamSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodLogStreamStatus) DeepCopyInto(out *PodLogStreamStatus) {
	*out = *in
	if in.ContainerStatuses != nil {
		in, out := &in.ContainerStatuses, &out.ContainerStatuses
		*out = make([]ContainerLogStreamStatus, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodLogStreamStatus.
func (in *PodLogStreamStatus) DeepCopy() *PodLogStreamStatus {
	if in == nil {
		return nil
	}
	out := new(PodLogStreamStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodLogStreamTemplateSpec) DeepCopyInto(out *PodLogStreamTemplateSpec) {
	*out = *in
	if in.SinceTime != nil {
		in, out := &in.SinceTime, &out.SinceTime
		*out = (*in).DeepCopy()
	}
	if in.OnlyContainers != nil {
		in, out := &in.OnlyContainers, &out.OnlyContainers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.IgnoreContainers != nil {
		in, out := &in.IgnoreContainers, &out.IgnoreContainers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodLogStreamTemplateSpec.
func (in *PodLogStreamTemplateSpec) DeepCopy() *PodLogStreamTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(PodLogStreamTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodOwner) DeepCopyInto(out *PodOwner) {
	*out = *in
	in.CreationTimestamp.DeepCopyInto(&out.CreationTimestamp)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodOwner.
func (in *PodOwner) DeepCopy() *PodOwner {
	if in == nil {
		return nil
	}
	out := new(PodOwner)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PortForward) DeepCopyInto(out *PortForward) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PortForward.
func (in *PortForward) DeepCopy() *PortForward {
	if in == nil {
		return nil
	}
	out := new(PortForward)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *PortForward) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PortForwardList) DeepCopyInto(out *PortForwardList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]PortForward, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PortForwardList.
func (in *PortForwardList) DeepCopy() *PortForwardList {
	if in == nil {
		return nil
	}
	out := new(PortForwardList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *PortForwardList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PortForwardSpec) DeepCopyInto(out *PortForwardSpec) {
	*out = *in
	if in.Forwards != nil {
		in, out := &in.Forwards, &out.Forwards
		*out = make([]Forward, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PortForwardSpec.
func (in *PortForwardSpec) DeepCopy() *PortForwardSpec {
	if in == nil {
		return nil
	}
	out := new(PortForwardSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PortForwardStatus) DeepCopyInto(out *PortForwardStatus) {
	*out = *in
	if in.ForwardStatuses != nil {
		in, out := &in.ForwardStatuses, &out.ForwardStatuses
		*out = make([]ForwardStatus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PortForwardStatus.
func (in *PortForwardStatus) DeepCopy() *PortForwardStatus {
	if in == nil {
		return nil
	}
	out := new(PortForwardStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PortForwardTemplateSpec) DeepCopyInto(out *PortForwardTemplateSpec) {
	*out = *in
	if in.Forwards != nil {
		in, out := &in.Forwards, &out.Forwards
		*out = make([]Forward, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PortForwardTemplateSpec.
func (in *PortForwardTemplateSpec) DeepCopy() *PortForwardTemplateSpec {
	if in == nil {
		return nil
	}
	out := new(PortForwardTemplateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Probe) DeepCopyInto(out *Probe) {
	*out = *in
	in.Handler.DeepCopyInto(&out.Handler)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Probe.
func (in *Probe) DeepCopy() *Probe {
	if in == nil {
		return nil
	}
	out := new(Probe)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RegistryHosting) DeepCopyInto(out *RegistryHosting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RegistryHosting.
func (in *RegistryHosting) DeepCopy() *RegistryHosting {
	if in == nil {
		return nil
	}
	out := new(RegistryHosting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RestartOnSpec) DeepCopyInto(out *RestartOnSpec) {
	*out = *in
	if in.FileWatches != nil {
		in, out := &in.FileWatches, &out.FileWatches
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.UIButtons != nil {
		in, out := &in.UIButtons, &out.UIButtons
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RestartOnSpec.
func (in *RestartOnSpec) DeepCopy() *RestartOnSpec {
	if in == nil {
		return nil
	}
	out := new(RestartOnSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Session) DeepCopyInto(out *Session) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Session.
func (in *Session) DeepCopy() *Session {
	if in == nil {
		return nil
	}
	out := new(Session)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Session) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SessionCISpec) DeepCopyInto(out *SessionCISpec) {
	*out = *in
	if in.K8sGracePeriod != nil {
		in, out := &in.K8sGracePeriod, &out.K8sGracePeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.Timeout != nil {
		in, out := &in.Timeout, &out.Timeout
		*out = new(v1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SessionCISpec.
func (in *SessionCISpec) DeepCopy() *SessionCISpec {
	if in == nil {
		return nil
	}
	out := new(SessionCISpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SessionList) DeepCopyInto(out *SessionList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Session, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SessionList.
func (in *SessionList) DeepCopy() *SessionList {
	if in == nil {
		return nil
	}
	out := new(SessionList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SessionList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SessionSpec) DeepCopyInto(out *SessionSpec) {
	*out = *in
	if in.CI != nil {
		in, out := &in.CI, &out.CI
		*out = new(SessionCISpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SessionSpec.
func (in *SessionSpec) DeepCopy() *SessionSpec {
	if in == nil {
		return nil
	}
	out := new(SessionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SessionStatus) DeepCopyInto(out *SessionStatus) {
	*out = *in
	in.StartTime.DeepCopyInto(&out.StartTime)
	if in.Targets != nil {
		in, out := &in.Targets, &out.Targets
		*out = make([]Target, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SessionStatus.
func (in *SessionStatus) DeepCopy() *SessionStatus {
	if in == nil {
		return nil
	}
	out := new(SessionStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StartOnSpec) DeepCopyInto(out *StartOnSpec) {
	*out = *in
	in.StartAfter.DeepCopyInto(&out.StartAfter)
	if in.UIButtons != nil {
		in, out := &in.UIButtons, &out.UIButtons
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StartOnSpec.
func (in *StartOnSpec) DeepCopy() *StartOnSpec {
	if in == nil {
		return nil
	}
	out := new(StartOnSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StateSource) DeepCopyInto(out *StateSource) {
	*out = *in
	if in.ConfigMap != nil {
		in, out := &in.ConfigMap, &out.ConfigMap
		*out = new(ConfigMapStateSource)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StateSource.
func (in *StateSource) DeepCopy() *StateSource {
	if in == nil {
		return nil
	}
	out := new(StateSource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StopOnSpec) DeepCopyInto(out *StopOnSpec) {
	*out = *in
	if in.UIButtons != nil {
		in, out := &in.UIButtons, &out.UIButtons
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StopOnSpec.
func (in *StopOnSpec) DeepCopy() *StopOnSpec {
	if in == nil {
		return nil
	}
	out := new(StopOnSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TCPSocketAction) DeepCopyInto(out *TCPSocketAction) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TCPSocketAction.
func (in *TCPSocketAction) DeepCopy() *TCPSocketAction {
	if in == nil {
		return nil
	}
	out := new(TCPSocketAction)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Target) DeepCopyInto(out *Target) {
	*out = *in
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	in.State.DeepCopyInto(&out.State)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Target.
func (in *Target) DeepCopy() *Target {
	if in == nil {
		return nil
	}
	out := new(Target)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TargetState) DeepCopyInto(out *TargetState) {
	*out = *in
	if in.Waiting != nil {
		in, out := &in.Waiting, &out.Waiting
		*out = new(TargetStateWaiting)
		**out = **in
	}
	if in.Active != nil {
		in, out := &in.Active, &out.Active
		*out = new(TargetStateActive)
		(*in).DeepCopyInto(*out)
	}
	if in.Terminated != nil {
		in, out := &in.Terminated, &out.Terminated
		*out = new(TargetStateTerminated)
		(*in).DeepCopyInto(*out)
	}
	if in.Disabled != nil {
		in, out := &in.Disabled, &out.Disabled
		*out = new(TargetStateDisabled)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TargetState.
func (in *TargetState) DeepCopy() *TargetState {
	if in == nil {
		return nil
	}
	out := new(TargetState)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TargetStateActive) DeepCopyInto(out *TargetStateActive) {
	*out = *in
	in.StartTime.DeepCopyInto(&out.StartTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TargetStateActive.
func (in *TargetStateActive) DeepCopy() *TargetStateActive {
	if in == nil {
		return nil
	}
	out := new(TargetStateActive)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TargetStateDisabled) DeepCopyInto(out *TargetStateDisabled) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TargetStateDisabled.
func (in *TargetStateDisabled) DeepCopy() *TargetStateDisabled {
	if in == nil {
		return nil
	}
	out := new(TargetStateDisabled)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TargetStateTerminated) DeepCopyInto(out *TargetStateTerminated) {
	*out = *in
	in.StartTime.DeepCopyInto(&out.StartTime)
	in.FinishTime.DeepCopyInto(&out.FinishTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TargetStateTerminated.
func (in *TargetStateTerminated) DeepCopy() *TargetStateTerminated {
	if in == nil {
		return nil
	}
	out := new(TargetStateTerminated)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TargetStateWaiting) DeepCopyInto(out *TargetStateWaiting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TargetStateWaiting.
func (in *TargetStateWaiting) DeepCopy() *TargetStateWaiting {
	if in == nil {
		return nil
	}
	out := new(TargetStateWaiting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TiltBuild) DeepCopyInto(out *TiltBuild) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TiltBuild.
func (in *TiltBuild) DeepCopy() *TiltBuild {
	if in == nil {
		return nil
	}
	out := new(TiltBuild)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Tiltfile) DeepCopyInto(out *Tiltfile) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Tiltfile.
func (in *Tiltfile) DeepCopy() *Tiltfile {
	if in == nil {
		return nil
	}
	out := new(Tiltfile)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Tiltfile) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TiltfileList) DeepCopyInto(out *TiltfileList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Tiltfile, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TiltfileList.
func (in *TiltfileList) DeepCopy() *TiltfileList {
	if in == nil {
		return nil
	}
	out := new(TiltfileList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TiltfileList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TiltfileSpec) DeepCopyInto(out *TiltfileSpec) {
	*out = *in
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.RestartOn != nil {
		in, out := &in.RestartOn, &out.RestartOn
		*out = new(RestartOnSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Args != nil {
		in, out := &in.Args, &out.Args
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.StopOn != nil {
		in, out := &in.StopOn, &out.StopOn
		*out = new(StopOnSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TiltfileSpec.
func (in *TiltfileSpec) DeepCopy() *TiltfileSpec {
	if in == nil {
		return nil
	}
	out := new(TiltfileSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TiltfileStateRunning) DeepCopyInto(out *TiltfileStateRunning) {
	*out = *in
	if in.Reasons != nil {
		in, out := &in.Reasons, &out.Reasons
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TiltfileStateRunning.
func (in *TiltfileStateRunning) DeepCopy() *TiltfileStateRunning {
	if in == nil {
		return nil
	}
	out := new(TiltfileStateRunning)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TiltfileStateTerminated) DeepCopyInto(out *TiltfileStateTerminated) {
	*out = *in
	if in.Reasons != nil {
		in, out := &in.Reasons, &out.Reasons
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	in.StartedAt.DeepCopyInto(&out.StartedAt)
	in.FinishedAt.DeepCopyInto(&out.FinishedAt)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TiltfileStateTerminated.
func (in *TiltfileStateTerminated) DeepCopy() *TiltfileStateTerminated {
	if in == nil {
		return nil
	}
	out := new(TiltfileStateTerminated)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TiltfileStateWaiting) DeepCopyInto(out *TiltfileStateWaiting) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TiltfileStateWaiting.
func (in *TiltfileStateWaiting) DeepCopy() *TiltfileStateWaiting {
	if in == nil {
		return nil
	}
	out := new(TiltfileStateWaiting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TiltfileStatus) DeepCopyInto(out *TiltfileStatus) {
	*out = *in
	if in.Waiting != nil {
		in, out := &in.Waiting, &out.Waiting
		*out = new(TiltfileStateWaiting)
		**out = **in
	}
	if in.Running != nil {
		in, out := &in.Running, &out.Running
		*out = new(TiltfileStateRunning)
		(*in).DeepCopyInto(*out)
	}
	if in.Terminated != nil {
		in, out := &in.Terminated, &out.Terminated
		*out = new(TiltfileStateTerminated)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TiltfileStatus.
func (in *TiltfileStatus) DeepCopy() *TiltfileStatus {
	if in == nil {
		return nil
	}
	out := new(TiltfileStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ToggleButton) DeepCopyInto(out *ToggleButton) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ToggleButton.
func (in *ToggleButton) DeepCopy() *ToggleButton {
	if in == nil {
		return nil
	}
	out := new(ToggleButton)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ToggleButton) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ToggleButtonList) DeepCopyInto(out *ToggleButtonList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ToggleButton, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ToggleButtonList.
func (in *ToggleButtonList) DeepCopy() *ToggleButtonList {
	if in == nil {
		return nil
	}
	out := new(ToggleButtonList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ToggleButtonList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ToggleButtonSpec) DeepCopyInto(out *ToggleButtonSpec) {
	*out = *in
	out.Location = in.Location
	out.On = in.On
	out.Off = in.Off
	in.StateSource.DeepCopyInto(&out.StateSource)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ToggleButtonSpec.
func (in *ToggleButtonSpec) DeepCopy() *ToggleButtonSpec {
	if in == nil {
		return nil
	}
	out := new(ToggleButtonSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ToggleButtonStateSpec) DeepCopyInto(out *ToggleButtonStateSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ToggleButtonStateSpec.
func (in *ToggleButtonStateSpec) DeepCopy() *ToggleButtonStateSpec {
	if in == nil {
		return nil
	}
	out := new(ToggleButtonStateSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ToggleButtonStatus) DeepCopyInto(out *ToggleButtonStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ToggleButtonStatus.
func (in *ToggleButtonStatus) DeepCopy() *ToggleButtonStatus {
	if in == nil {
		return nil
	}
	out := new(ToggleButtonStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIBoolInputSpec) DeepCopyInto(out *UIBoolInputSpec) {
	*out = *in
	if in.TrueString != nil {
		in, out := &in.TrueString, &out.TrueString
		*out = new(string)
		**out = **in
	}
	if in.FalseString != nil {
		in, out := &in.FalseString, &out.FalseString
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIBoolInputSpec.
func (in *UIBoolInputSpec) DeepCopy() *UIBoolInputSpec {
	if in == nil {
		return nil
	}
	out := new(UIBoolInputSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIBoolInputStatus) DeepCopyInto(out *UIBoolInputStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIBoolInputStatus.
func (in *UIBoolInputStatus) DeepCopy() *UIBoolInputStatus {
	if in == nil {
		return nil
	}
	out := new(UIBoolInputStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIBuildRunning) DeepCopyInto(out *UIBuildRunning) {
	*out = *in
	in.StartTime.DeepCopyInto(&out.StartTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIBuildRunning.
func (in *UIBuildRunning) DeepCopy() *UIBuildRunning {
	if in == nil {
		return nil
	}
	out := new(UIBuildRunning)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIBuildTerminated) DeepCopyInto(out *UIBuildTerminated) {
	*out = *in
	if in.Warnings != nil {
		in, out := &in.Warnings, &out.Warnings
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	in.StartTime.DeepCopyInto(&out.StartTime)
	in.FinishTime.DeepCopyInto(&out.FinishTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIBuildTerminated.
func (in *UIBuildTerminated) DeepCopy() *UIBuildTerminated {
	if in == nil {
		return nil
	}
	out := new(UIBuildTerminated)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIButton) DeepCopyInto(out *UIButton) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIButton.
func (in *UIButton) DeepCopy() *UIButton {
	if in == nil {
		return nil
	}
	out := new(UIButton)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *UIButton) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIButtonList) DeepCopyInto(out *UIButtonList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]UIButton, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIButtonList.
func (in *UIButtonList) DeepCopy() *UIButtonList {
	if in == nil {
		return nil
	}
	out := new(UIButtonList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *UIButtonList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIButtonSpec) DeepCopyInto(out *UIButtonSpec) {
	*out = *in
	out.Location = in.Location
	if in.Inputs != nil {
		in, out := &in.Inputs, &out.Inputs
		*out = make([]UIInputSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIButtonSpec.
func (in *UIButtonSpec) DeepCopy() *UIButtonSpec {
	if in == nil {
		return nil
	}
	out := new(UIButtonSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIButtonStatus) DeepCopyInto(out *UIButtonStatus) {
	*out = *in
	in.LastClickedAt.DeepCopyInto(&out.LastClickedAt)
	if in.Inputs != nil {
		in, out := &in.Inputs, &out.Inputs
		*out = make([]UIInputStatus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIButtonStatus.
func (in *UIButtonStatus) DeepCopy() *UIButtonStatus {
	if in == nil {
		return nil
	}
	out := new(UIButtonStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIChoiceInputSpec) DeepCopyInto(out *UIChoiceInputSpec) {
	*out = *in
	if in.Choices != nil {
		in, out := &in.Choices, &out.Choices
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIChoiceInputSpec.
func (in *UIChoiceInputSpec) DeepCopy() *UIChoiceInputSpec {
	if in == nil {
		return nil
	}
	out := new(UIChoiceInputSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIChoiceInputStatus) DeepCopyInto(out *UIChoiceInputStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIChoiceInputStatus.
func (in *UIChoiceInputStatus) DeepCopy() *UIChoiceInputStatus {
	if in == nil {
		return nil
	}
	out := new(UIChoiceInputStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIComponentLocation) DeepCopyInto(out *UIComponentLocation) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIComponentLocation.
func (in *UIComponentLocation) DeepCopy() *UIComponentLocation {
	if in == nil {
		return nil
	}
	out := new(UIComponentLocation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIComponentLocationResource) DeepCopyInto(out *UIComponentLocationResource) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIComponentLocationResource.
func (in *UIComponentLocationResource) DeepCopy() *UIComponentLocationResource {
	if in == nil {
		return nil
	}
	out := new(UIComponentLocationResource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIFeatureFlag) DeepCopyInto(out *UIFeatureFlag) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIFeatureFlag.
func (in *UIFeatureFlag) DeepCopy() *UIFeatureFlag {
	if in == nil {
		return nil
	}
	out := new(UIFeatureFlag)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIHiddenInputSpec) DeepCopyInto(out *UIHiddenInputSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIHiddenInputSpec.
func (in *UIHiddenInputSpec) DeepCopy() *UIHiddenInputSpec {
	if in == nil {
		return nil
	}
	out := new(UIHiddenInputSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIHiddenInputStatus) DeepCopyInto(out *UIHiddenInputStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIHiddenInputStatus.
func (in *UIHiddenInputStatus) DeepCopy() *UIHiddenInputStatus {
	if in == nil {
		return nil
	}
	out := new(UIHiddenInputStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIInputSpec) DeepCopyInto(out *UIInputSpec) {
	*out = *in
	if in.Text != nil {
		in, out := &in.Text, &out.Text
		*out = new(UITextInputSpec)
		**out = **in
	}
	if in.Bool != nil {
		in, out := &in.Bool, &out.Bool
		*out = new(UIBoolInputSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Hidden != nil {
		in, out := &in.Hidden, &out.Hidden
		*out = new(UIHiddenInputSpec)
		**out = **in
	}
	if in.Choice != nil {
		in, out := &in.Choice, &out.Choice
		*out = new(UIChoiceInputSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIInputSpec.
func (in *UIInputSpec) DeepCopy() *UIInputSpec {
	if in == nil {
		return nil
	}
	out := new(UIInputSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIInputStatus) DeepCopyInto(out *UIInputStatus) {
	*out = *in
	if in.Text != nil {
		in, out := &in.Text, &out.Text
		*out = new(UITextInputStatus)
		**out = **in
	}
	if in.Bool != nil {
		in, out := &in.Bool, &out.Bool
		*out = new(UIBoolInputStatus)
		**out = **in
	}
	if in.Hidden != nil {
		in, out := &in.Hidden, &out.Hidden
		*out = new(UIHiddenInputStatus)
		**out = **in
	}
	if in.Choice != nil {
		in, out := &in.Choice, &out.Choice
		*out = new(UIChoiceInputStatus)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIInputStatus.
func (in *UIInputStatus) DeepCopy() *UIInputStatus {
	if in == nil {
		return nil
	}
	out := new(UIInputStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResource) DeepCopyInto(out *UIResource) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResource.
func (in *UIResource) DeepCopy() *UIResource {
	if in == nil {
		return nil
	}
	out := new(UIResource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *UIResource) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceCondition) DeepCopyInto(out *UIResourceCondition) {
	*out = *in
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceCondition.
func (in *UIResourceCondition) DeepCopy() *UIResourceCondition {
	if in == nil {
		return nil
	}
	out := new(UIResourceCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceKubernetes) DeepCopyInto(out *UIResourceKubernetes) {
	*out = *in
	in.PodCreationTime.DeepCopyInto(&out.PodCreationTime)
	in.PodUpdateStartTime.DeepCopyInto(&out.PodUpdateStartTime)
	if in.DisplayNames != nil {
		in, out := &in.DisplayNames, &out.DisplayNames
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceKubernetes.
func (in *UIResourceKubernetes) DeepCopy() *UIResourceKubernetes {
	if in == nil {
		return nil
	}
	out := new(UIResourceKubernetes)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceLink) DeepCopyInto(out *UIResourceLink) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceLink.
func (in *UIResourceLink) DeepCopy() *UIResourceLink {
	if in == nil {
		return nil
	}
	out := new(UIResourceLink)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceList) DeepCopyInto(out *UIResourceList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]UIResource, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceList.
func (in *UIResourceList) DeepCopy() *UIResourceList {
	if in == nil {
		return nil
	}
	out := new(UIResourceList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *UIResourceList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceLocal) DeepCopyInto(out *UIResourceLocal) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceLocal.
func (in *UIResourceLocal) DeepCopy() *UIResourceLocal {
	if in == nil {
		return nil
	}
	out := new(UIResourceLocal)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceSpec) DeepCopyInto(out *UIResourceSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceSpec.
func (in *UIResourceSpec) DeepCopy() *UIResourceSpec {
	if in == nil {
		return nil
	}
	out := new(UIResourceSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceStateWaiting) DeepCopyInto(out *UIResourceStateWaiting) {
	*out = *in
	if in.On != nil {
		in, out := &in.On, &out.On
		*out = make([]UIResourceStateWaitingOnRef, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceStateWaiting.
func (in *UIResourceStateWaiting) DeepCopy() *UIResourceStateWaiting {
	if in == nil {
		return nil
	}
	out := new(UIResourceStateWaiting)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceStateWaitingOnRef) DeepCopyInto(out *UIResourceStateWaitingOnRef) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceStateWaitingOnRef.
func (in *UIResourceStateWaitingOnRef) DeepCopy() *UIResourceStateWaitingOnRef {
	if in == nil {
		return nil
	}
	out := new(UIResourceStateWaitingOnRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceStatus) DeepCopyInto(out *UIResourceStatus) {
	*out = *in
	in.LastDeployTime.DeepCopyInto(&out.LastDeployTime)
	if in.BuildHistory != nil {
		in, out := &in.BuildHistory, &out.BuildHistory
		*out = make([]UIBuildTerminated, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.CurrentBuild != nil {
		in, out := &in.CurrentBuild, &out.CurrentBuild
		*out = new(UIBuildRunning)
		(*in).DeepCopyInto(*out)
	}
	in.PendingBuildSince.DeepCopyInto(&out.PendingBuildSince)
	if in.EndpointLinks != nil {
		in, out := &in.EndpointLinks, &out.EndpointLinks
		*out = make([]UIResourceLink, len(*in))
		copy(*out, *in)
	}
	if in.K8sResourceInfo != nil {
		in, out := &in.K8sResourceInfo, &out.K8sResourceInfo
		*out = new(UIResourceKubernetes)
		(*in).DeepCopyInto(*out)
	}
	if in.LocalResourceInfo != nil {
		in, out := &in.LocalResourceInfo, &out.LocalResourceInfo
		*out = new(UIResourceLocal)
		**out = **in
	}
	if in.Specs != nil {
		in, out := &in.Specs, &out.Specs
		*out = make([]UIResourceTargetSpec, len(*in))
		copy(*out, *in)
	}
	in.DisableStatus.DeepCopyInto(&out.DisableStatus)
	if in.Waiting != nil {
		in, out := &in.Waiting, &out.Waiting
		*out = new(UIResourceStateWaiting)
		(*in).DeepCopyInto(*out)
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]UIResourceCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceStatus.
func (in *UIResourceStatus) DeepCopy() *UIResourceStatus {
	if in == nil {
		return nil
	}
	out := new(UIResourceStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UIResourceTargetSpec) DeepCopyInto(out *UIResourceTargetSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UIResourceTargetSpec.
func (in *UIResourceTargetSpec) DeepCopy() *UIResourceTargetSpec {
	if in == nil {
		return nil
	}
	out := new(UIResourceTargetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UISession) DeepCopyInto(out *UISession) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UISession.
func (in *UISession) DeepCopy() *UISession {
	if in == nil {
		return nil
	}
	out := new(UISession)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *UISession) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UISessionList) DeepCopyInto(out *UISessionList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]UISession, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UISessionList.
func (in *UISessionList) DeepCopy() *UISessionList {
	if in == nil {
		return nil
	}
	out := new(UISessionList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *UISessionList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UISessionSpec) DeepCopyInto(out *UISessionSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UISessionSpec.
func (in *UISessionSpec) DeepCopy() *UISessionSpec {
	if in == nil {
		return nil
	}
	out := new(UISessionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UISessionStatus) DeepCopyInto(out *UISessionStatus) {
	*out = *in
	if in.FeatureFlags != nil {
		in, out := &in.FeatureFlags, &out.FeatureFlags
		*out = make([]UIFeatureFlag, len(*in))
		copy(*out, *in)
	}
	out.RunningTiltBuild = in.RunningTiltBuild
	out.VersionSettings = in.VersionSettings
	in.TiltStartTime.DeepCopyInto(&out.TiltStartTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UISessionStatus.
func (in *UISessionStatus) DeepCopy() *UISessionStatus {
	if in == nil {
		return nil
	}
	out := new(UISessionStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UITextInputSpec) DeepCopyInto(out *UITextInputSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UITextInputSpec.
func (in *UITextInputSpec) DeepCopy() *UITextInputSpec {
	if in == nil {
		return nil
	}
	out := new(UITextInputSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UITextInputStatus) DeepCopyInto(out *UITextInputStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UITextInputStatus.
func (in *UITextInputStatus) DeepCopy() *UITextInputStatus {
	if in == nil {
		return nil
	}
	out := new(UITextInputStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VersionSettings) DeepCopyInto(out *VersionSettings) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VersionSettings.
func (in *VersionSettings) DeepCopy() *VersionSettings {
	if in == nil {
		return nil
	}
	out := new(VersionSettings)
	in.DeepCopyInto(out)
	return out
}
