package repositories

// ATTENTION!
// This rule was autogenerated!
// Before making changes, consider updating the generator.

import (
	"github.com/aquasecurity/tfsec/internal/app/tfsec/block"
	"github.com/aquasecurity/tfsec/internal/app/tfsec/scanner"
	"github.com/aquasecurity/tfsec/pkg/provider"
	"github.com/aquasecurity/tfsec/pkg/result"
	"github.com/aquasecurity/tfsec/pkg/rule"
	"github.com/aquasecurity/tfsec/pkg/severity"
)

func init() {
	scanner.RegisterCheckRule(rule.Rule{
		Provider:  provider.GitHubProvider,
		Service:   "repositories",
		ShortCode: "vulnerability-alerts",
		Documentation: rule.RuleDocumentation{
			Summary:     "Github vulnerability alerts should be enabled.",
			Explanation: `You can do this by setting the <code>vulnerability_alerts</code> attribute to 'true'.`,
			Impact:      "Insecure vulnerabilities might be used in the codebase.",
			Resolution:  "Enable vulnerability alerts for all repositories.",
			BadExample: []string{`
resource "github_repository" "bad_example" {
  name        		   = "example"
  description 		   = "My awesome codebase"
  vulnerability_alerts = false
}
`},
			GoodExample: []string{`
resource "github_repository" "good_example" {
  name        		   = "example"
  description 		   = "My awesome codebase"
  vulnerability_alerts = true
}
`,
				`
resource "github_repository" "good_example" {
  name        		   = "example"
  description 		   = "My awesome codebase"
  vulnerability_alerts = false
  archived             = true
}
`},
			Links: []string{
				"https://registry.terraform.io/providers/hashicorp/github/latest/docs/resources/repository#vulnerability_alerts",
				"https://docs.github.com/en/code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/about-alerts-for-vulnerable-dependencies",
			},
		},
		RequiredTypes: []string{
			"resource",
		},
		RequiredLabels: []string{
			"github_repository",
		},
		DefaultSeverity: severity.High,
		CheckFunc: func(set result.Set, resourceBlock block.Block, module block.Module) {
			if archivedAttr := resourceBlock.GetAttribute("archived"); archivedAttr.IsTrue() {
				return
			}
			if vulnerabilityAlertsAttr := resourceBlock.GetAttribute("vulnerability_alerts"); vulnerabilityAlertsAttr.IsNil() { // alert on use of default value
				set.AddResult().
					WithDescription("Resource '%s' uses default value for vulnerability_alerts", resourceBlock.FullName())
			} else if vulnerabilityAlertsAttr.IsFalse() {
				set.AddResult().
					WithDescription("Resource '%s' does not have vulnerability_alerts set to true", resourceBlock.FullName()).
					WithAttribute(vulnerabilityAlertsAttr)
			}
		},
	})
}
