# users

## Description

Users table

<details>
<summary><strong>Table Definition</strong></summary>

```sql
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(50) NOT NULL,
  `email` varchar(355) NOT NULL COMMENT 'ex. user@example.com',
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=[Redacted by tbls] DEFAULT CHARSET=utf8mb4 COMMENT='Users table'
```

</details>

## Columns

| Name | Type | Default | Nullable | Extra Definition | Children | Parents | Comment | Labels |
| ---- | ---- | ------- | -------- | ---------------- | -------- | ------- | ------- | ------ |
| id | int(11) |  | false | auto_increment | [comments](comments.md) [comment_stars](comment_stars.md) [posts](posts.md) [same_name_constraints](same_name_constraints.md) [user_options](user_options.md) [logs](logs.md) |  |  |  |
| username | varchar(50) |  | false |  |  |  |  |  |
| password | varchar(50) |  | false |  |  |  |  | `secure` `encrypted` |
| email | varchar(355) |  | false |  |  |  | ex. user@example.com | `secure` |
| created | timestamp | current_timestamp() | false | on update current_timestamp() |  |  |  |  |
| updated | timestamp | '0000-00-00 00:00:00' | false |  |  |  |  |  |

## Constraints

| Name | Type | Definition |
| ---- | ---- | ---------- |
| email | UNIQUE | UNIQUE KEY email (email) |
| PRIMARY | PRIMARY KEY | PRIMARY KEY (id) |
| username | UNIQUE | UNIQUE KEY username (username) |

## Indexes

| Name | Definition |
| ---- | ---------- |
| PRIMARY | PRIMARY KEY (id) USING BTREE |
| email | UNIQUE KEY email (email) USING BTREE |
| username | UNIQUE KEY username (username) USING BTREE |

## Relations

![er](users.svg)

---

> Generated by [tbls](https://github.com/k1LoW/tbls)
