<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw edge-services`
Edge Services API
  
- [Backend-stage management commands](#backend-stage-management-commands)
  - [Create backend stage](#create-backend-stage)
  - [Delete backend stage](#delete-backend-stage)
  - [Get backend stage](#get-backend-stage)
  - [List backend stages](#list-backend-stages)
  - [Update backend stage](#update-backend-stage)
- [Cache-stage management commands](#cache-stage-management-commands)
  - [Create cache stage](#create-cache-stage)
  - [Delete cache stage](#delete-cache-stage)
  - [Get cache stage](#get-cache-stage)
  - [List cache stages](#list-cache-stages)
  - [Update cache stage](#update-cache-stage)
- [DNS-stage management commands](#dns-stage-management-commands)
  - [Create DNS stage](#create-dns-stage)
  - [Delete DNS stage](#delete-dns-stage)
  - [Get DNS stage](#get-dns-stage)
  - [List DNS stages](#list-dns-stages)
  - [Update DNS stage](#update-dns-stage)
- [Pipeline management commands](#pipeline-management-commands)
  - [Create pipeline](#create-pipeline)
  - [Delete pipeline](#delete-pipeline)
  - [Get pipeline](#get-pipeline)
  - [List pipelines](#list-pipelines)
  - [List Head stage for your pipeline.](#list-head-stage-for-your-pipeline.)
  - [Configure a entry point to your pipeline. You must specify a `head stage` to form a stage-chain that goes all the way to the backend stage (origin), so the HTTP request will be processed according to the stages you created.](#configure-a-entry-point-to-your-pipeline.-you-must-specify-a-`head-stage`-to-form-a-stage-chain-that-goes-all-the-way-to-the-backend-stage-(origin),-so-the-http-request-will-be-processed-according-to-the-stages-you-created.)
  - [Update pipeline](#update-pipeline)
- [Purge-request management commands](#purge-request-management-commands)
  - [Create purge request](#create-purge-request)
  - [Get purge request](#get-purge-request)
  - [List purge requests](#list-purge-requests)
- [Route-rules management commands](#route-rules-management-commands)
  - [Add route rules](#add-route-rules)
  - [List route rules](#list-route-rules)
  - [Set route rules](#set-route-rules)
- [Route-stage management commands](#route-stage-management-commands)
  - [Create route stage](#create-route-stage)
  - [Delete route stage](#delete-route-stage)
  - [Get route stage](#get-route-stage)
  - [List route stages](#list-route-stages)
  - [Update route stage](#update-route-stage)
- [TLS-stage management commands](#tls-stage-management-commands)
  - [Create TLS stage](#create-tls-stage)
  - [Delete TLS stage](#delete-tls-stage)
  - [Get TLS stage](#get-tls-stage)
  - [List TLS stages](#list-tls-stages)
  - [Update TLS stage](#update-tls-stage)
- [WAF-stage management commands](#waf-stage-management-commands)
  - [Create WAF stage](#create-waf-stage)
  - [Delete WAF stage](#delete-waf-stage)
  - [Get WAF stage](#get-waf-stage)
  - [List WAF stages](#list-waf-stages)
  - [Update WAF stage](#update-waf-stage)

  
## Backend-stage management commands

Backend-stage management commands.


### Create backend stage

Create a new backend stage. You must specify either a `scaleway_s3` (for a Scaleway Object Storage bucket) or `scaleway_lb` (for a Scaleway Load Balancer) field to configure the origin.

**Usage:**

```
scw edge-services backend-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| scaleway-s3.bucket-name |  | Name of the Bucket |
| scaleway-s3.bucket-region |  | Region of the Bucket |
| scaleway-s3.is-website |  | Defines whether the bucket website feature is enabled |
| scaleway-lb.lbs.{index}.id |  | ID of the Load Balancer |
| scaleway-lb.lbs.{index}.zone |  | Zone of the Load Balancer |
| scaleway-lb.lbs.{index}.frontend-id |  | ID of the frontend linked to the Load Balancer |
| scaleway-lb.lbs.{index}.is-ssl |  | Defines whether the Load Balancer's frontend handles SSL connections |
| scaleway-lb.lbs.{index}.domain-name |  | Fully Qualified Domain Name (in the format subdomain.example.com) to use in HTTP requests sent towards your Load Balancer |
| scaleway-lb.lbs.{index}.has-websocket |  | Defines whether to forward websocket requests to the load balancer |
| pipeline-id | Required | Pipeline ID the Backend stage belongs to |
| scaleway-serverless-container.region |  |  |
| scaleway-serverless-container.container-id |  |  |
| scaleway-serverless-function.region |  |  |
| scaleway-serverless-function.function-id |  |  |



### Delete backend stage

Delete an existing backend stage, specified by its `backend_stage_id`. Deleting a backend stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services backend-stage delete <backend-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-stage-id | Required | ID of the backend stage to delete |



### Get backend stage

Retrieve information about an existing backend stage, specified by its `backend_stage_id`. Its full details, including `scaleway_s3` or `scaleway_lb`, are returned in the response object.

**Usage:**

```
scw edge-services backend-stage get <backend-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-stage-id | Required | ID of the requested backend stage |



### List backend stages

List all backend stages, for a Scaleway Organization or Scaleway Project. By default, the backend stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services backend-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of backend stages in the response |
| pipeline-id | Required | Pipeline ID to filter for. Only backend stages from this pipeline will be returned |
| bucket-name |  | Bucket name to filter for. Only backend stages from this Bucket will be returned |
| bucket-region |  | Bucket region to filter for. Only backend stages with buckets in this region will be returned |
| lb-id |  | Load Balancer ID to filter for. Only backend stages with this Load Balancer will be returned |



### Update backend stage

Update the parameters of an existing backend stage, specified by its `backend_stage_id`.

**Usage:**

```
scw edge-services backend-stage update <backend-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-stage-id | Required | ID of the backend stage to update |
| scaleway-s3.bucket-name |  | Name of the Bucket |
| scaleway-s3.bucket-region |  | Region of the Bucket |
| scaleway-s3.is-website |  | Defines whether the bucket website feature is enabled |
| scaleway-lb.lbs.{index}.id |  | ID of the Load Balancer |
| scaleway-lb.lbs.{index}.zone |  | Zone of the Load Balancer |
| scaleway-lb.lbs.{index}.frontend-id |  | ID of the frontend linked to the Load Balancer |
| scaleway-lb.lbs.{index}.is-ssl |  | Defines whether the Load Balancer's frontend handles SSL connections |
| scaleway-lb.lbs.{index}.domain-name |  | Fully Qualified Domain Name (in the format subdomain.example.com) to use in HTTP requests sent towards your Load Balancer |
| scaleway-lb.lbs.{index}.has-websocket |  | Defines whether to forward websocket requests to the load balancer |
| pipeline-id |  | Pipeline ID the Backend stage belongs to |
| scaleway-serverless-container.region |  |  |
| scaleway-serverless-container.container-id |  |  |
| scaleway-serverless-function.region |  |  |
| scaleway-serverless-function.function-id |  |  |



## Cache-stage management commands

Cache-stage management commands.


### Create cache stage

Create a new cache stage. You must specify the `fallback_ttl` field to customize the TTL of the cache.

**Usage:**

```
scw edge-services cache-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fallback-ttl | Default: `3600s` | Time To Live (TTL) in seconds. Defines how long content is cached |
| include-cookies |  | Defines whether responses to requests with cookies must be stored in the cache |
| backend-stage-id |  | Backend stage ID the cache stage will be linked to |
| pipeline-id | Required | Pipeline ID the Cache stage belongs to |
| waf-stage-id |  |  |
| route-stage-id |  |  |



### Delete cache stage

Delete an existing cache stage, specified by its `cache_stage_id`. Deleting a cache stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services cache-stage delete <cache-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cache-stage-id | Required | ID of the cache stage to delete |



### Get cache stage

Retrieve information about an existing cache stage, specified by its `cache_stage_id`. Its full details, including Time To Live (TTL), are returned in the response object.

**Usage:**

```
scw edge-services cache-stage get <cache-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cache-stage-id | Required | ID of the requested cache stage |



### List cache stages

List all cache stages, for a Scaleway Organization or Scaleway Project. By default, the cache stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services cache-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of cache stages in the response |
| pipeline-id | Required | Pipeline ID to filter for. Only cache stages from this pipeline will be returned |



### Update cache stage

Update the parameters of an existing cache stage, specified by its `cache_stage_id`. Parameters which can be updated include the `fallback_ttl`, `include_cookies` and `backend_stage_id`.

**Usage:**

```
scw edge-services cache-stage update <cache-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cache-stage-id | Required | ID of the cache stage to update |
| fallback-ttl |  | Time To Live (TTL) in seconds. Defines how long content is cached |
| include-cookies |  | Defines whether responses to requests with cookies must be stored in the cache |
| backend-stage-id |  | Backend stage ID the cache stage will be linked to |
| waf-stage-id |  |  |
| route-stage-id |  |  |



## DNS-stage management commands

DNS-stage management commands.


### Create DNS stage

Create a new DNS stage. You must specify the `fqdns` field to customize the domain endpoint, using a domain you already own.

**Usage:**

```
scw edge-services dns-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| fqdns.{index} |  | Fully Qualified Domain Name (in the format subdomain.example.com) to attach to the stage |
| tls-stage-id |  | TLS stage ID the DNS stage will be linked to |
| cache-stage-id |  | Cache stage ID the DNS stage will be linked to |
| backend-stage-id |  | Backend stage ID the DNS stage will be linked to |
| pipeline-id | Required | Pipeline ID the DNS stage belongs to |



### Delete DNS stage

Delete an existing DNS stage, specified by its `dns_stage_id`. Deleting a DNS stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services dns-stage delete <dns-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-stage-id | Required | ID of the DNS stage to delete |



### Get DNS stage

Retrieve information about an existing DNS stage, specified by its `dns_stage_id`. Its full details, including FQDNs, are returned in the response object.

**Usage:**

```
scw edge-services dns-stage get <dns-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-stage-id | Required | ID of the requested DNS stage |



### List DNS stages

List all DNS stages, for a Scaleway Organization or Scaleway Project. By default, the DNS stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services dns-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of DNS stages in the response |
| pipeline-id | Required | Pipeline ID to filter for. Only DNS stages from this pipeline will be returned |
| fqdn |  | Fully Qualified Domain Name to filter for (in the format subdomain.example.com). Only DNS stages with this FQDN will be returned |



### Update DNS stage

Update the parameters of an existing DNS stage, specified by its `dns_stage_id`.

**Usage:**

```
scw edge-services dns-stage update <dns-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-stage-id | Required | ID of the DNS stage to update |
| fqdns.{index} |  | Fully Qualified Domain Name (in the format subdomain.example.com) attached to the stage |
| tls-stage-id |  | TLS stage ID the DNS stage will be linked to |
| cache-stage-id |  | Cache stage ID the DNS stage will be linked to |
| backend-stage-id |  | Backend stage ID the DNS stage will be linked to |



## Pipeline management commands

Pipeline management commands.


### Create pipeline

Create a new pipeline. You must specify a `dns_stage_id` to form a stage-chain that goes all the way to the backend stage (origin), so the HTTP request will be processed according to the stages you created.

**Usage:**

```
scw edge-services pipeline create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required | Name of the pipeline |
| description | Required | Description of the pipeline |



### Delete pipeline

Delete an existing pipeline, specified by its `pipeline_id`. Deleting a pipeline is permanent, and cannot be undone. Note that all stages linked to the pipeline are also deleted.

**Usage:**

```
scw edge-services pipeline delete <pipeline-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | ID of the pipeline to delete |



### Get pipeline

Retrieve information about an existing pipeline, specified by its `pipeline_id`. Its full details, including errors, are returned in the response object.

**Usage:**

```
scw edge-services pipeline get <pipeline-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | ID of the requested pipeline |



### List pipelines

List all pipelines, for a Scaleway Organization or Scaleway Project. By default, the pipelines returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services pipeline list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of pipelines in the response |
| name |  | Pipeline name to filter for. Only pipelines with this string within their name will be returned |
| project-id |  | Project ID to filter for. Only pipelines from this Project will be returned |
| has-backend-stage-lb |  | Filter on backend stage. Only pipelines with a Load Balancer origin will be returned |
| organization-id |  | Organization ID to filter for. Only pipelines from this Organization will be returned |



### List Head stage for your pipeline.

List Head stage for your pipeline.

**Usage:**

```
scw edge-services pipeline list-head <pipeline-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | ID of the pipeline to update |



### Configure a entry point to your pipeline. You must specify a `head stage` to form a stage-chain that goes all the way to the backend stage (origin), so the HTTP request will be processed according to the stages you created.

You must specify either a `add_new_head_stage` (to add a new head stage), `remove_head_stage` (to remove a head stage) or `swap_head_stage` (to replace a head stage).

**Usage:**

```
scw edge-services pipeline set-head <pipeline-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | ID of the pipeline to update |
| add-new-head-stage.new-stage-id |  |  |
| remove-head-stage.remove-stage-id |  |  |
| swap-head-stage.new-stage-id |  |  |
| swap-head-stage.current-stage-id |  |  |



### Update pipeline

Update the parameters of an existing pipeline, specified by its `pipeline_id`. Parameters which can be updated include the `name`, `description` and `dns_stage_id`.

**Usage:**

```
scw edge-services pipeline update <pipeline-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | ID of the pipeline to update |
| name |  | Name of the pipeline |
| description |  | Description of the pipeline |



## Purge-request management commands

Purge-request management commands.


### Create purge request

Create a new purge request. You must specify either the `all` field (to purge all content) or a list of `assets` (to define the precise assets to purge).

**Usage:**

```
scw edge-services purge-request create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | Pipeline ID in which the purge request will be created |
| assets.{index} |  | List of asserts to purge |
| all |  | Defines whether to purge all content |



### Get purge request

Retrieve information about a purge request, specified by its `purge_request_id`. Its full details, including `status` and `target`, are returned in the response object.

**Usage:**

```
scw edge-services purge-request get <purge-request-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| purge-request-id | Required | ID of the requested purge request |



### List purge requests

List all purge requests, for a Scaleway Organization or Scaleway Project. This enables you to retrieve a history of all previously-made purge requests. By default, the purge requests returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services purge-request list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of purge requests in the response |
| project-id |  | Project ID to filter for. Only purge requests from this Project will be returned |
| pipeline-id |  | Pipeline ID to filter for. Only purge requests from this pipeline will be returned |
| organization-id |  | Organization ID to filter for. Only purge requests from this Project will be returned |



## Route-rules management commands

Route-rules management commands.


### Add route rules

Add route rules to an existing route stage, specified by its `route_stage_id`.

**Usage:**

```
scw edge-services route-rules add <route-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-stage-id | Required | ID of the route stage to update |
| route-rules.{index}.rule-http-match.method-filters.{index} | One of: `unknown_method_filter`, `get`, `post`, `put`, `patch`, `delete`, `head`, `options` | HTTP methods to filter for. A request using any of these methods will be considered to match the rule. Possible values are `get`, `post`, `put`, `patch`, `delete`, `head`, `options`. All methods will match if none is provided |
| route-rules.{index}.rule-http-match.path-filter.path-filter-type | One of: `unknown_path_filter`, `regex` | Type of filter to match for the HTTP URL path. For now, all path filters must be written in regex and use the `regex` type |
| route-rules.{index}.rule-http-match.path-filter.value |  | Value to be matched for the HTTP URL path |
| route-rules.{index}.backend-stage-id |  | ID of the backend stage that requests matching the rule should be forwarded to |
| after-position |  | Add rules after the given position |
| before-position |  | Add rules before the given position |



### List route rules

List all route rules of an existing route stage, specified by its `route_stage_id`.

**Usage:**

```
scw edge-services route-rules list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-stage-id | Required | Route stage ID to filter for. Only route rules from this route stage will be returned |



### Set route rules

Set the rules of an existing route stage, specified by its `route_stage_id`.

**Usage:**

```
scw edge-services route-rules set <route-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-stage-id | Required | ID of the route stage to update |
| route-rules.{index}.rule-http-match.method-filters.{index} | One of: `unknown_method_filter`, `get`, `post`, `put`, `patch`, `delete`, `head`, `options` | HTTP methods to filter for. A request using any of these methods will be considered to match the rule. Possible values are `get`, `post`, `put`, `patch`, `delete`, `head`, `options`. All methods will match if none is provided |
| route-rules.{index}.rule-http-match.path-filter.path-filter-type | One of: `unknown_path_filter`, `regex` | Type of filter to match for the HTTP URL path. For now, all path filters must be written in regex and use the `regex` type |
| route-rules.{index}.rule-http-match.path-filter.value |  | Value to be matched for the HTTP URL path |
| route-rules.{index}.backend-stage-id |  | ID of the backend stage that requests matching the rule should be forwarded to |



## Route-stage management commands

Route-stage management commands.


### Create route stage

Create a new route stage. You must specify the `waf_stage_id` field to customize the route.

**Usage:**

```
scw edge-services route-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | Pipeline ID the route stage belongs to |
| waf-stage-id |  | ID of the WAF stage HTTP requests should be forwarded to when no rules are matched |



### Delete route stage

Delete an existing route stage, specified by its `route_stage_id`. Deleting a route stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services route-stage delete <route-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-stage-id | Required | ID of the route stage to delete |



### Get route stage

Retrieve information about an existing route stage, specified by its `route_stage_id`. The summary of the route stage (without route rules) is returned in the response object.

**Usage:**

```
scw edge-services route-stage get <route-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-stage-id | Required | ID of the requested route stage |



### List route stages

List all route stages, for a given pipeline. By default, the route stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services route-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of route stages in the response |
| pipeline-id | Required | Pipeline ID to filter for. Only route stages from this pipeline will be returned |



### Update route stage

Update the parameters of an existing route stage, specified by its `route_stage_id`.

**Usage:**

```
scw edge-services route-stage update <route-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-stage-id | Required | ID of the route stage to update |
| waf-stage-id |  | ID of the WAF stage HTTP requests should be forwarded to when no rules are matched |



## TLS-stage management commands

TLS-stage management commands.


### Create TLS stage

Create a new TLS stage. You must specify either the `secrets` or `managed_certificate` fields to customize the SSL/TLS certificate of your endpoint. Choose `secrets` if you are using a pre-existing certificate held in Scaleway Secret Manager, or `managed_certificate` to let Scaleway generate and manage a Let's Encrypt certificate for your customized endpoint.

**Usage:**

```
scw edge-services tls-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| secrets.{index}.secret-id |  | ID of the Secret |
| secrets.{index}.region |  | Region of the Secret |
| managed-certificate |  | True when Scaleway generates and manages a Let's Encrypt certificate for the TLS stage/custom endpoint |
| cache-stage-id |  | Cache stage ID the TLS stage will be linked to |
| backend-stage-id |  | Backend stage ID the TLS stage will be linked to |
| pipeline-id | Required | Pipeline ID the TLS stage belongs to |
| route-stage-id |  |  |
| waf-stage-id |  |  |



### Delete TLS stage

Delete an existing TLS stage, specified by its `tls_stage_id`. Deleting a TLS stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services tls-stage delete <tls-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tls-stage-id | Required | ID of the TLS stage to delete |



### Get TLS stage

Retrieve information about an existing TLS stage, specified by its `tls_stage_id`. Its full details, including secrets and certificate expiration date are returned in the response object.

**Usage:**

```
scw edge-services tls-stage get <tls-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tls-stage-id | Required | ID of the requested TLS stage |



### List TLS stages

List all TLS stages, for a Scaleway Organization or Scaleway Project. By default, the TLS stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services tls-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of TLS stages in the response |
| pipeline-id | Required | Pipeline ID to filter for. Only TLS stages from this pipeline will be returned |
| secret-id |  | Secret ID to filter for. Only TLS stages with this Secret ID will be returned |
| secret-region |  | Secret region to filter for. Only TLS stages with a Secret in this region will be returned |



### Update TLS stage

Update the parameters of an existing TLS stage, specified by its `tls_stage_id`. Both `tls_secrets_config` and `managed_certificate` parameters can be updated.

**Usage:**

```
scw edge-services tls-stage update <tls-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tls-stage-id | Required | ID of the TLS stage to update |
| tls-secrets-config.tls-secrets.{index}.secret-id |  | ID of the Secret |
| tls-secrets-config.tls-secrets.{index}.region |  | Region of the Secret |
| managed-certificate |  | True when Scaleway generates and manages a Let's Encrypt certificate for the TLS stage/custom endpoint |
| cache-stage-id |  | Cache stage ID the TLS stage will be linked to |
| backend-stage-id |  | Backend stage ID the TLS stage will be linked to |
| route-stage-id |  |  |
| waf-stage-id |  |  |



## WAF-stage management commands

WAF-stage management commands.


### Create WAF stage

Create a new WAF stage. You must specify the `mode` and `paranoia_level` fields to customize the WAF.

**Usage:**

```
scw edge-services waf-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | Pipeline ID the WAF stage belongs to |
| mode | One of: `unknown_mode`, `disable`, `log_only`, `enable` | Mode defining WAF behavior (`disable`/`log_only`/`enable`) |
| paranoia-level |  | Sensitivity level (`1`,`2`,`3`,`4`) to use when classifying requests as malicious. With a high level, requests are more likely to be classed as malicious, and false positives are expected. With a lower level, requests are more likely to be classed as benign. |
| backend-stage-id |  | ID of the backend stage to forward requests to after the WAF stage |



### Delete WAF stage

Delete an existing WAF stage, specified by its `waf_stage_id`. Deleting a WAF stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services waf-stage delete <waf-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| waf-stage-id | Required | ID of the WAF stage to delete |



### Get WAF stage

Retrieve information about an existing WAF stage, specified by its `waf_stage_id`. Its full details are returned in the response object.

**Usage:**

```
scw edge-services waf-stage get <waf-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| waf-stage-id | Required | ID of the requested WAF stage |



### List WAF stages

List all WAF stages, for a Scaleway Organization or Scaleway Project. By default, the WAF stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services waf-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of WAF stages in the response |
| pipeline-id | Required | Pipeline ID to filter for. Only WAF stages from this pipeline will be returned |



### Update WAF stage

Update the parameters of an existing WAF stage, specified by its `waf_stage_id`. Both `mode` and `paranoia_level` parameters can be updated.

**Usage:**

```
scw edge-services waf-stage update <waf-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| waf-stage-id | Required | ID of the WAF stage to update |
| mode | One of: `unknown_mode`, `disable`, `log_only`, `enable` | Mode defining WAF behavior (`disable`/`log_only`/`enable`) |
| paranoia-level |  | Sensitivity level (`1`,`2`,`3`,`4`) to use when classifying requests as malicious. With a high level, requests are more likely to be classed as malicious, and false positives are expected. With a lower level, requests are more likely to be classed as benign. |
| backend-stage-id |  | ID of the backend stage to forward requests to after the WAF stage |



