// Copyright 2016-2018, Pulumi Corporation.  All rights reserved.

package ints

import (
	"testing"

	"github.com/pulumi/pulumi/pkg/v2/testing/integration"
)

// TestQuery creates a stack and runs a query over the stack's resource ouptputs.
func TestQuery(t *testing.T) {
	integration.ProgramTest(t, &integration.ProgramTestOptions{
		// Create Pulumi resources.
		Dir:          "step1",
		StackName:    "query-stack-781a480a-fcac-4e5a-ab08-a73bc8cbcdd2",
		Dependencies: []string{"@pulumi/pulumi"},
		CloudURL:     "file://~", // Required; we hard-code the stack name
		EditDirs: []integration.EditDir{
			// Try to create resources during `pulumi query`. This should fail.
			{
				Dir:           "step2",
				Additive:      true,
				QueryMode:     true,
				ExpectFailure: true,
			},
			// Run a query during `pulumi query`. Should succeed.
			{
				Dir:           "step3",
				Additive:      true,
				QueryMode:     true,
				ExpectFailure: false,
			},
		},
	})
}
