//
// This file generated by rdl (development version)
//

package rdl

import (
	"encoding/json"
	"fmt"
)

var _ = json.Marshal
var _ = fmt.Printf

//
// Options - options comment
//
type Options int

//
// Options constants
//
const (
	_ Options = iota
	ONE
	TWO
	THREE
)

var namesOptions = []string{
	ONE:   "ONE",
	TWO:   "TWO",
	THREE: "THREE",
}

//
// NewOptions - return a string representation of the enum
//
func NewOptions(init ...interface{}) Options {
	if len(init) == 1 {
		switch v := init[0].(type) {
		case Options:
			return v
		case int:
			return Options(v)
		case int32:
			return Options(v)
		case string:
			for i, s := range namesOptions {
				if s == v {
					return Options(i)
				}
			}
		default:
			panic("Bad init value for Options enum")
		}
	}
	return Options(0) //default to the first enum value
}

//
// String - return a string representation of the enum
//
func (e Options) String() string {
	return namesOptions[e]
}

//
// MarshalJSON is defined for proper JSON encoding of a Options
//
func (e Options) MarshalJSON() ([]byte, error) {
	return json.Marshal(e.String())
}

//
// UnmarshalJSON is defined for proper JSON decoding of a Options
//
func (e *Options) UnmarshalJSON(b []byte) error {
	var j string
	err := json.Unmarshal(b, &j)
	if err == nil {
		s := string(j)
		for v, s2 := range namesOptions {
			if s == s2 {
				*e = Options(v)
				return nil
			}
		}
		err = fmt.Errorf("Bad enum symbol for type Options: %s", s)
	}
	return err
}

//
// SymTest -
//
type SymTest struct {
	Symmap map[Symbol]string `json:"symmap"`
	Symary []Symbol          `json:"symary"`
	Sym    Symbol            `json:"sym"`
}

//
// NewSymTest - creates an initialized SymTest instance, returns a pointer to it
//
func NewSymTest(init ...*SymTest) *SymTest {
	var o *SymTest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(SymTest)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (pTypeDef *SymTest) Init() *SymTest {
	if pTypeDef.Symmap == nil {
		pTypeDef.Symmap = make(map[Symbol]string)
	}
	if pTypeDef.Symary == nil {
		pTypeDef.Symary = make([]Symbol, 0)
	}
	return pTypeDef
}

type rawSymTest SymTest

//
// UnmarshalJSON is defined for proper JSON decoding of a SymTest
//
func (pTypeDef *SymTest) UnmarshalJSON(b []byte) error {
	var r rawSymTest
	err := json.Unmarshal(b, &r)
	if err == nil {
		o := SymTest(r)
		*pTypeDef = *((&o).Init())
		err = pTypeDef.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (pTypeDef *SymTest) Validate() error {
	if pTypeDef.Symmap == nil {
		return fmt.Errorf("SymTest: Missing required field: symmap")
	}
	if pTypeDef.Symary == nil {
		return fmt.Errorf("SymTest: Missing required field: symary")
	}
	if pTypeDef.Sym == "" {
		return fmt.Errorf("SymTest: Missing required field: sym")
	}
	return nil
}

//
// StringTest -
//
type StringTest struct {
	Name   string   `json:"name"`
	Parent string   `json:"parent"`
	Names  []string `json:"names,omitempty" rdl:"optional"`
	Enc    string   `json:"enc,omitempty" rdl:"optional"`
}

//
// NewStringTest - creates an initialized StringTest instance, returns a pointer to it
//
func NewStringTest(init ...*StringTest) *StringTest {
	var o *StringTest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(StringTest)
	}
	return o
}

type rawStringTest StringTest

//
// UnmarshalJSON is defined for proper JSON decoding of a StringTest
//
func (pTypeDef *StringTest) UnmarshalJSON(b []byte) error {
	var r rawStringTest
	err := json.Unmarshal(b, &r)
	if err == nil {
		o := StringTest(r)
		*pTypeDef = o
		err = pTypeDef.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (pTypeDef *StringTest) Validate() error {
	if pTypeDef.Name == "" {
		return fmt.Errorf("StringTest: Missing required field: name")
	}
	if pTypeDef.Parent == "" {
		return fmt.Errorf("StringTest: Missing required field: parent")
	}
	return nil
}

//
// MapTest -
//
type MapTest struct {
	Locations map[string]int32 `json:"locations"`
}

//
// NewMapTest - creates an initialized MapTest instance, returns a pointer to it
//
func NewMapTest(init ...*MapTest) *MapTest {
	var o *MapTest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(MapTest)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (pTypeDef *MapTest) Init() *MapTest {
	if pTypeDef.Locations == nil {
		pTypeDef.Locations = make(map[string]int32)
	}
	return pTypeDef
}

type rawMapTest MapTest

//
// UnmarshalJSON is defined for proper JSON decoding of a MapTest
//
func (pTypeDef *MapTest) UnmarshalJSON(b []byte) error {
	var r rawMapTest
	err := json.Unmarshal(b, &r)
	if err == nil {
		o := MapTest(r)
		*pTypeDef = *((&o).Init())
		err = pTypeDef.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (pTypeDef *MapTest) Validate() error {
	if pTypeDef.Locations == nil {
		return fmt.Errorf("MapTest: Missing required field: locations")
	}
	return nil
}

//
// ArrayOfInt -
//
type ArrayOfInt []int32

//
// MapArrayTest -
//
type MapArrayTest struct {
	Locations map[string]ArrayOfInt `json:"locations"`
}

//
// NewMapArrayTest - creates an initialized MapArrayTest instance, returns a pointer to it
//
func NewMapArrayTest(init ...*MapArrayTest) *MapArrayTest {
	var o *MapArrayTest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(MapArrayTest)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (pTypeDef *MapArrayTest) Init() *MapArrayTest {
	if pTypeDef.Locations == nil {
		pTypeDef.Locations = make(map[string]ArrayOfInt)
	}
	return pTypeDef
}

type rawMapArrayTest MapArrayTest

//
// UnmarshalJSON is defined for proper JSON decoding of a MapArrayTest
//
func (pTypeDef *MapArrayTest) UnmarshalJSON(b []byte) error {
	var r rawMapArrayTest
	err := json.Unmarshal(b, &r)
	if err == nil {
		o := MapArrayTest(r)
		*pTypeDef = *((&o).Init())
		err = pTypeDef.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (pTypeDef *MapArrayTest) Validate() error {
	if pTypeDef.Locations == nil {
		return fmt.Errorf("MapArrayTest: Missing required field: locations")
	}
	return nil
}

//
// IntOOBTest -
//
type IntOOBTest struct {
	Theyear int32 `json:"theyear"`
}

//
// NewIntOOBTest - creates an initialized IntOOBTest instance, returns a pointer to it
//
func NewIntOOBTest(init ...*IntOOBTest) *IntOOBTest {
	var o *IntOOBTest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(IntOOBTest)
	}
	return o
}

type rawIntOOBTest IntOOBTest

//
// UnmarshalJSON is defined for proper JSON decoding of a IntOOBTest
//
func (pTypeDef *IntOOBTest) UnmarshalJSON(b []byte) error {
	var r rawIntOOBTest
	err := json.Unmarshal(b, &r)
	if err == nil {
		o := IntOOBTest(r)
		*pTypeDef = o
		err = pTypeDef.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (pTypeDef *IntOOBTest) Validate() error {
	return nil
}

//
// NegativeNumberTest -
//
type NegativeNumberTest struct {
	Mylatitude float64 `json:"mylatitude"`
}

//
// NewNegativeNumberTest - creates an initialized NegativeNumberTest instance, returns a pointer to it
//
func NewNegativeNumberTest(init ...*NegativeNumberTest) *NegativeNumberTest {
	var o *NegativeNumberTest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(NegativeNumberTest)
	}
	return o
}

type rawNegativeNumberTest NegativeNumberTest

//
// UnmarshalJSON is defined for proper JSON decoding of a NegativeNumberTest
//
func (pTypeDef *NegativeNumberTest) UnmarshalJSON(b []byte) error {
	var r rawNegativeNumberTest
	err := json.Unmarshal(b, &r)
	if err == nil {
		o := NegativeNumberTest(r)
		*pTypeDef = o
		err = pTypeDef.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (pTypeDef *NegativeNumberTest) Validate() error {
	return nil
}

//
// UUIDTest -
//
type UUIDTest struct {
	Myid UUID `json:"myid"`
}

//
// NewUUIDTest - creates an initialized UUIDTest instance, returns a pointer to it
//
func NewUUIDTest(init ...*UUIDTest) *UUIDTest {
	var o *UUIDTest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(UUIDTest)
	}
	return o
}

type rawUUIDTest UUIDTest

//
// UnmarshalJSON is defined for proper JSON decoding of a UUIDTest
//
func (pTypeDef *UUIDTest) UnmarshalJSON(b []byte) error {
	var r rawUUIDTest
	err := json.Unmarshal(b, &r)
	if err == nil {
		o := UUIDTest(r)
		*pTypeDef = o
		err = pTypeDef.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (pTypeDef *UUIDTest) Validate() error {
	if pTypeDef.Myid == nil {
		return fmt.Errorf("UUIDTest: Missing required field: myid")
	}
	return nil
}

//
// TimestampTest -
//
type TimestampTest struct {
	Mytime Timestamp `json:"mytime"`
}

//
// NewTimestampTest - creates an initialized TimestampTest instance, returns a pointer to it
//
func NewTimestampTest(init ...*TimestampTest) *TimestampTest {
	var o *TimestampTest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(TimestampTest)
	}
	return o
}

type rawTimestampTest TimestampTest

//
// UnmarshalJSON is defined for proper JSON decoding of a TimestampTest
//
func (pTypeDef *TimestampTest) UnmarshalJSON(b []byte) error {
	var r rawTimestampTest
	err := json.Unmarshal(b, &r)
	if err == nil {
		o := TimestampTest(r)
		*pTypeDef = o
		err = pTypeDef.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (pTypeDef *TimestampTest) Validate() error {
	if pTypeDef.Mytime.IsZero() {
		return fmt.Errorf("TimestampTest: Missing required field: mytime")
	}
	return nil
}

//
// Test -
//
type Test struct {
	Name         string     `json:"name"`
	Utfname      string     `json:"utfname"`
	Bool         bool       `json:"bool"`
	Bool2        bool       `json:"bool2"`
	Int          int32      `json:"int"`
	Mylong       int64      `json:"mylong"`
	Mydbl        float64    `json:"mydbl"`
	Intarray     ArrayOfInt `json:"intarray,omitempty" rdl:"optional"`
	My_int_array []int32    `json:"my_int_array"`
	My_str_array []string   `json:"my_str_array"`
	Myuuid       UUID       `json:"myuuid"`
	Myaz         string     `json:"myaz"`
	Myyear       int32      `json:"myyear"`
	Mypi         float64    `json:"mypi"`
	Myotherlong  int64      `json:"myotherlong"`
	Mytime       Timestamp  `json:"mytime"`
	Myoptions    Options    `json:"myoptions"`
	Co1          string     `json:"co1"`
	Co2          string     `json:"co2"`
	Co3          string     `json:"co3"`
	Symtest      *SymTest   `json:"symtest"`
}

//
// NewTest - creates an initialized Test instance, returns a pointer to it
//
func NewTest(init ...*Test) *Test {
	var o *Test
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Test)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (pTypeDef *Test) Init() *Test {
	if pTypeDef.My_int_array == nil {
		pTypeDef.My_int_array = make([]int32, 0)
	}
	if pTypeDef.My_str_array == nil {
		pTypeDef.My_str_array = make([]string, 0)
	}
	if pTypeDef.Symtest == nil {
		pTypeDef.Symtest = NewSymTest()
	}
	return pTypeDef
}

type rawTest Test

//
// UnmarshalJSON is defined for proper JSON decoding of a Test
//
func (pTypeDef *Test) UnmarshalJSON(b []byte) error {
	var r rawTest
	err := json.Unmarshal(b, &r)
	if err == nil {
		o := Test(r)
		*pTypeDef = *((&o).Init())
		err = pTypeDef.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (pTypeDef *Test) Validate() error {
	if pTypeDef.Name == "" {
		return fmt.Errorf("Test: Missing required field: name")
	}
	if pTypeDef.Utfname == "" {
		return fmt.Errorf("Test: Missing required field: utfname")
	}
	if pTypeDef.My_int_array == nil {
		return fmt.Errorf("Test: Missing required field: my_int_array")
	}
	if pTypeDef.My_str_array == nil {
		return fmt.Errorf("Test: Missing required field: my_str_array")
	}
	fmt.Println("myuuid:", pTypeDef.Myuuid)
	if pTypeDef.Myuuid == nil {
		return fmt.Errorf("Test: Missing required field: myuuid")
	}
	if pTypeDef.Myaz == "" {
		return fmt.Errorf("Test: Missing required field: myaz")
	}
	if pTypeDef.Mytime.IsZero() {
		return fmt.Errorf("Test: Missing required field: mytime")
	}
	if pTypeDef.Co1 == "" {
		return fmt.Errorf("Test: Missing required field: co1")
	}
	if pTypeDef.Co2 == "" {
		return fmt.Errorf("Test: Missing required field: co2")
	}
	if pTypeDef.Co3 == "" {
		return fmt.Errorf("Test: Missing required field: co3")
	}
	if pTypeDef.Symtest == nil {
		return fmt.Errorf("Test: Missing required field: symtest")
	}
	return nil
}
