// Code generated by "mdtogo"; DO NOT EDIT.
package api

var ConfigIoLong = `# Configuration IO API Semantics

Resource Configuration may be read / written from / to sources such as directories,
stdin|out or network. Tools may be composed using pipes such that the tools writing
Resource Configuration may be a different tool from the one that read the configuration.
In order for tools to be composed in this way, while preserving origin information --
such as the original file, index, etc.:

Tools **SHOULD** insert the following annotations when reading from sources,
and **SHOULD** delete the annotations when writing to sinks.

### ` + "`" + `config.kubernetes.io/path` + "`" + `

Records the slash-delimited, OS-agnostic, relative file path to a Resource.

This annotation **SHOULD** be set when reading Resources from files.
It **SHOULD** be unset when writing Resources to files.
When writing Resources to a directory, the Resource **SHOULD** be written to the corresponding
path relative to that directory.

Example:

	metadata:
	  annotations:
	    config.kubernetes.io/path: "relative/file/path.yaml"

### ` + "`" + `config.kubernetes.io/index` + "`" + `

Records the index of a Resource in file. In a multi-object YAML file, Resources are separated
by three dashes (` + "`" + `---` + "`" + `), and the index represents the position of the Resource starting from zero.

This annotation **SHOULD** be set when reading Resources from files.
It **SHOULD** be unset when writing Resources to files.
When writing multiple Resources to the same file, the Resource **SHOULD** be written in the
relative order matching the index.

When this annotation is not specified, it implies a value of ` + "`" + `0` + "`" + `.

Example:

	metadata:
	  annotations:
	    config.kubernetes.io/path: "relative/file/path.yaml"
	    config.kubernetes.io/index: 2

This represents the third Resource in the file.

### ` + "`" + `config.kubernetes.io/local-config` + "`" + `

` + "`" + `config.kubernetes.io/local-config` + "`" + ` declares that the configuration is to local tools
rather than a remote Resource. e.g. The ` + "`" + `Kustomization` + "`" + ` config in a ` + "`" + `kustomization.yaml` + "`" + `
**SHOULD** contain this annotation so that tools know it is not intended to be sent to
the Kubernetes api server.

Example:

	metadata:
	  annotations:
	    config.kubernetes.io/local-config: "true"`

var (
	FunctionsImplShort = `Following is an example for implementing an nginx abstraction using a configuration`
	FunctionsImplLong  = `# Running Configuration Functions using kustomize CLI

Configuration functions can be implemented using any toolchain and invoked using any
container workflow orchestrator including Tekton, Cloud Build, or run directly using ` + "`" + `docker run` + "`" + `.

Run ` + "`" + `config help docs-fn-spec` + "`" + ` to see the Configuration Functions Specification.

` + "`" + `kustomize fn run` + "`" + ` is an example orchestrator for invoking Configuration Functions. This
document describes how to implement and invoke an example function.

function.

### ` + "`" + `nginx-template.sh` + "`" + `

` + "`" + `nginx-template.sh` + "`" + ` is a simple bash script which uses a _heredoc_ as a templating solution
for generating Resources from the functionConfig input fields.

The script wraps itself using ` + "`" + `config run wrap -- $0` + "`" + ` which will:

1. Parse the ` + "`" + `ResourceList.functionConfig` + "`" + ` (provided to the container stdin) into env vars
2. Merge the stdout into the original list of Resources
3. Defaults filenames for newly generated Resources (if they are not set as annotations)
   to ` + "`" + `config/NAME_KIND.yaml` + "`" + `
4. Format the output

	#!/bin/bash
	# script must run wrapped by "kustomize fn run wrap"
	# for parsing input the functionConfig into env vars
	if [ -z ${WRAPPED} ]; then
	  export WRAPPED=true
	  config run wrap -- $0
	  exit $?
	fi

	cat <<End-of-message
	apiVersion: v1
	kind: Service
	metadata:
	  name: ${NAME}
	  labels:
	    app: nginx
	    instance: ${NAME}
	spec:
	  ports:
	  - port: 80
	    targetPort: 80
	    name: http
	  selector:
	    app: nginx
	    instance: ${NAME}
	---
	apiVersion: apps/v1
	kind: Deployment
	metadata:
	  name: ${NAME}
	  labels:
	    app: nginx
	    instance: ${NAME}
	spec:
	  replicas: ${REPLICAS}
	  selector:
	    matchLabels:
	      app: nginx
	      instance: ${NAME}
	  template:
	    metadata:
	      labels:
	        app: nginx
	        instance: ${NAME}
	    spec:
	      containers:
	      - name: nginx
	        image: nginx:1.7.9
	        ports:
	        - containerPort: 80
	End-of-message

### Dockerfile

` + "`" + `Dockerfile` + "`" + ` installs ` + "`" + `kustomize fn` + "`" + ` and copies the script into the container image.

	FROM golang:1.19-bullseye
	RUN go get sigs.k8s.io/kustomize/cmd/config
	RUN mv /go/bin/config /usr/bin/config
	COPY nginx-template.sh /usr/bin/nginx-template.sh
	CMD ["nginx-template.sh]

## Example Function Usage

Following is an example of running the ` + "`" + `kustomize fn run` + "`" + ` using the preceding API.

When run by ` + "`" + `kustomize fn run` + "`" + `, functions are run in containers with the
following environment:

- Network: ` + "`" + `none` + "`" + `
- User: ` + "`" + `nobody` + "`" + `
- Security Options: ` + "`" + `no-new-privileges` + "`" + `
- Volumes: the volume containing the ` + "`" + `functionConfig` + "`" + ` yaml is mounted under ` + "`" + `/local` + "`" + ` as ` + "`" + `ro` + "`" + `

### Input

` + "`" + `dir/nginx.yaml` + "`" + ` contains a reference to the Function. The contents of ` + "`" + `nginx.yaml` + "`" + `
are passed to the Function through the ` + "`" + `ResourceList.functionConfig` + "`" + ` field.

	apiVersion: example.com/v1beta1
	kind: Nginx
	metadata:
	  name: my-instance
	  annotations:
	    config.kubernetes.io/local-config: "true"
	    config.kubernetes.io/function: |
	      container:
	        image: gcr.io/example-functions/nginx-template:v1.0.0
	spec:
	  replicas: 5

- ` + "`" + `annotations[config.kubernetes.io/function].container.image` + "`" + `: the image to use for this API
- ` + "`" + `annotations[config.kubernetes.io/local-config]` + "`" + `: mark this as not a Resource that should
  be applied

### Output

The function is invoked using byrunning ` + "`" + `kustomize fn run dir/` + "`" + `.

` + "`" + `dir/my-instance_deployment.yaml` + "`" + ` contains the Deployment:

	apiVersion: apps/v1
	kind: Deployment
	metadata:
	  name: my-instance
	  labels:
	    app: nginx
	    instance: my-instance
	spec:
	  replicas: 5
	  selector:
	    matchLabels:
	      app: nginx
	      instance: my-instance
	  template:
	    metadata:
	      labels:
	        app: nginx
	        instance: my-instance
	    spec:
	      containers:
	        - name: nginx
	          image: nginx:1.7.9
	          ports:
	            - containerPort: 80

` + "`" + `dir/my-instance_service.yaml` + "`" + ` contains the Service:

	apiVersion: v1
	kind: Service
	metadata:
	  name: my-instance
	  labels:
	    app: nginx
	    instance: my-instance
	spec:
	  ports:
	    - port: 80
	      targetPort: 80
	      name: http
	  selector:
	    app: nginx
	    instance: my-instance`
)

var (
	FunctionsSpecShort = `_Configuration functions_ enable shift-left practices (client-side) through:`
	FunctionsSpecLong  = `# Configuration Functions Specification

This document specifies a standard for client-side functions that operate on
Kubernetes declarative configurations. This standard enables creating
small, interoperable, and language-independent executable programs packaged as
containers that can be chained together as part of a configuration management pipeline.
The end result of such a pipeline are fully rendered configurations that can then be
applied to a control plane (e.g. Using ‘kubectl apply’ for Kubernetes control plane).
As such, although this document references Kubernetes Resource Model and API conventions,
it is completely decoupled from Kubernetes API machinery and does not depend on any
in-cluster components.

This document references terms described in [Kubernetes API Conventions][1].

The key words "MUST", "MUST NOT", "REQUIRED", "SHALL", "SHALL NOT", "SHOULD",
"SHOULD NOT", "RECOMMENDED", "MAY", and "OPTIONAL" in this document are to be
interpreted as described in [RFC 2119][2].


- Pre-commit / delivery validation and linting of configuration
  - e.g. Fail if any containers don't have CPU / Memory limits
- Implementation of abstractions as client actuated APIs (e.g. templating)
  - e.g. Create a client-side _"CRD"_ for generating configuration checked into git
- Aspect Orient configuration / Injection of cross-cutting configuration
  - e.g. T-Shirt size containers by annotating Resources with ` + "`" + `small` + "`" + `, ` + "`" + `medium` + "`" + `, ` + "`" + `large` + "`" + `
    and inject the cpu and memory resources into containers accordingly.
  - e.g. Inject ` + "`" + `init` + "`" + ` and ` + "`" + `side-car` + "`" + ` containers into Resources based off of Resource
    Type, annotations, etc.

Performing these on the client rather than the server enables:

- Configuration to be reviewed prior to being sent to the API server
- Configuration to be validated as part of the CI/CD pipeline
- Configuration for Resources to validated holistically rather than individually
  per-Resource
  - e.g. ensure the ` + "`" + `Service.selector` + "`" + ` and ` + "`" + `Deployment.spec.template` + "`" + ` labels
    match.
  - e.g. MutatingWebHooks are scoped to a single Resource instance at a time.
- Low-level tweaks to the output of high-level abstractions
  - e.g. add an ` + "`" + `init container` + "`" + ` to a client _"CRD"_ Resource after it was generated.
- Composition and layering of multiple functions together
  - Compose generation, injection, validation together

## Spec

### Input Type

A function MUST accept as input a single [Kubernetes List type][3].
The ` + "`" + `items` + "`" + ` field in the input will contain a sequence of [Object types][3].
A function MAY not support [Simple types][3] and List types.

An example using ` + "`" + `v1/ConfigMapList` + "`" + ` as input:

	apiVersion: v1
	kind: ConfigMapList
	items:
	  - apiVersion: v1
	    kind: ConfigMap
	    metadata:
	      name: config1
	    data:
	      p1: v1
	      p2: v2
	  - apiVersion: v1
	    kind: ConfigMap
	    metadata:
	      name: config2

An example using ` + "`" + `v1/List` + "`" + ` as input:

	apiVersion: v1
	kind: List
	items:
	  - apiVersion: foo-corp.com/v1
	    kind: FulfillmentCenter
	    metadata:
	      name: staging
	    address: "100 Main St."
	  - apiVersion: rbac.authorization.k8s.io/v1
	    kind: ClusterRole
	    metadata:
	      name: namespace-reader
	    rules:
	      - resources:
	          - namespaces
	        apiGroups:
	          - ""
	        verbs:
	          - get
	          - watch
	          - list

In addition, a function MUST accept as input a List of kind ` + "`" + `ResourceList` + "`" + ` where the
` + "`" + `functionConfig` + "`" + ` field, if present, will contain the invocation-specific configuration passed to the function
by the orchestrator.
Functions MAY consider this field optional so that they can be triggered in an ad-hoc fashion.

An example using ` + "`" + `config.kubernetes.io/v1beta1/ResourceList` + "`" + ` as input:

	apiVersion: config.kubernetes.io/v1beta1
	kind: ResourceList
	functionConfig:
	  apiVersion: foo-corp.com/v1
	  kind: FulfillmentCenter
	  metadata:
	    name: staging
	    metadata:
	      annotations:
	        config.kubernetes.io/function: |
	          container:
	            image: gcr.io/example/foo:v1.0.0
	  spec:
	    address: "100 Main St."
	items:
	  - apiVersion: rbac.authorization.k8s.io/v1
	    kind: ClusterRole
	    metadata:
	      name: namespace-reader
	    rules:
	      - resources:
	          - namespaces
	        apiGroups:
	          - ""
	        verbs:
	          - get
	          - watch
	          - list

Here ` + "`" + `FulfillmentCenter` + "`" + ` kind with name ` + "`" + `staging` + "`" + ` is passed as the invocation-specific configuration
to the function.

### Output Type

A function’s output MUST be the same as the input specification above
-- i.e. ` + "`" + `ResourceList` + "`" + ` or ` + "`" + `List` + "`" + `.
This is necessary to enable chaining two or more functions together in a pipeline.
The serialization format of the output SHOULD match that of its input on each invocation
-- e.g. if the input was a ` + "`" + `ResourceList` + "`" + `, the output should also be a ` + "`" + `ResourceList` + "`" + `.

### Serialization Format

A function MUST support YAML as a serialization format for the input and output.
A function MUST use utf8 encoding (as YAML is a superset of JSON, JSON will also be supported
by any conforming function).

### Operations

A function MAY Create, Update, or Delete any number of items in the ` + "`" + `items` + "`" + ` field and output the
resultant list.

A function MAY modify annotations with prefix ` + "`" + `config.kubernetes.io` + "`" + `, but must be careful about
doing so since they’re used for orchestration purposes and will likely impact subsequent functions
in the pipeline.

A function SHOULD preserve comments when input serialization format is YAML.
This allows for human authoring of configuration to coexist with changes made by functions.

### Containerization

A function MUST be implemented as a container.

A function container MUST be capable of running as a non-root user if it does not require
access to host filesystem or makes network calls.

### stdin/stdout/stderr and Exit Codes

A function MUST accept input from stdin and emit output to stdout.

Any error messages MUST be emitted to stderr.

An exit code of zero indicates function execution was successful.
A non-zero exit code indicates a failure.

[1]: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md
[2]: https://tools.ietf.org/html/rfc2119
[3]: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#types-kinds`
)

var Merge2Long = `# Merge (2-way)

  2-way merges fields from a source to a destination, overriding the destination fields
  where they differ.

  ### Merge Rules

  Fields are recursively merged using the following rules:

  - scalars
    - if present only in the dest, it keeps its value
    - if present in the src and is non-null, take the src value -- if ` + "`" + `null` + "`" + `, clear it
    - example src: ` + "`" + `5` + "`" + `, dest: ` + "`" + `3` + "`" + ` => result: ` + "`" + `5` + "`" + `

  - non-associative lists -- lists without a merge key
    - if present only in the dest, it keeps its value
    - if present in the src and is non-null, take the src value -- if ` + "`" + `null` + "`" + `, clear it
    - example src: ` + "`" + `[1, 2, 3]` + "`" + `, dest: ` + "`" + `[a, b, c]` + "`" + ` => result: ` + "`" + `[1, 2, 3]` + "`" + `

  - map keys and fields -- paired by the map-key / field-name
    - if present only in the dest, it keeps its value
    - if present only in the src, it is added to the dest
    - if the field is present in both the src and dest, and the src value is
      ` + "`" + `null` + "`" + `, the field is removed from the dest
    - if the field is present in both the src and dest, the value is recursively merged
    - example src: ` + "`" + `{'key1': 'value1', 'key2': 'value2'}` + "`" + `,
      dest: ` + "`" + `{'key2': 'value0', 'key3': 'value3'}` + "`" + `
      => result: ` + "`" + `{'key1': 'value1', 'key2': 'value2', 'key3': 'value3'}` + "`" + `

  - associative list elements -- paired by the associative key
    - if present only in the dest, it keeps its value in the list
    - if present only in the src, it is added to the dest list
    - if the field is present in both the src and dest, the value is recursively merged

  ### Associative Keys

  Associative keys are used to identify "same" elements within 2 different lists, and merge them.
  The following fields are recognized as associative keys:

  [` + "`" + `mountPath` + "`" + `, ` + "`" + `devicePath` + "`" + `, ` + "`" + `ip` + "`" + `, ` + "`" + `type` + "`" + `, ` + "`" + `topologyKey` + "`" + `, ` + "`" + `name` + "`" + `, ` + "`" + `containerPort` + "`" + `]

  Any lists where all of the elements contain associative keys will be merged as associative lists.

  ### Example

  > Source

	apiVersion: apps/v1
	kind: Deployment
	spec:
	  replicas: 3 # scalar
	  template:
	    spec:
	      containers:  # associative list -- (name)
	      - name: nginx
	        image: nginx:1.7
	        command: ['new_run.sh', 'arg1'] # non-associative list
	      - name: sidecar2
	        image: sidecar2:v1

  > Destination

	apiVersion: apps/v1
	kind: Deployment
	spec:
	  replicas: 1
	  template:
	    spec:
	      containers:
	      - name: nginx
	        image: nginx:1.6
	        command: ['old_run.sh', 'arg0']
	      - name: sidecar1
	        image: sidecar1:v1

  > Result

	apiVersion: apps/v1
	kind: Deployment
	spec:
	  replicas: 3 # scalar
	  template:
	    spec:
	      containers:  # associative list -- (name)
	      - name: nginx
	        image: nginx:1.7
	        command: ['new_run.sh', 'arg1'] # non-associative list
	      - name: sidecar1
	        image: sidecar1:v1
	      - name: sidecar2
	        image: sidecar2:v1`

var Merge3Long = `# Merge (3-way)

  3-way merge identifies changes between an original source + updated source and merges the result
  into a destination, overriding the destination fields where they have changed between
  original and updated.

### Resource MergeRules

  - Resources present in the original and deleted from the update are deleted.
  - Resources missing from the original and added in the update are added.
  - Resources present only in the dest are kept without changes.
  - Resources present in both the update and the dest have their fields merged with the destination.

### Field Merge Rules

  Fields are recursively merged using the following rules:

  - scalars
    - if present in either dest or updated and ` + "`" + `null` + "`" + `, clear the value
    - if unchanged between original and updated, keep dest value
    - if changed between original and updated (added, deleted, changed), take the updated value

  - non-associative lists -- lists without a merge key
    - if present in either dest or updated and ` + "`" + `null` + "`" + `, clear the value
    - if unchanged between original and updated, keep dest value
    - if changed between original and updated (added, deleted, changed), take the updated value

  - map keys and fields -- paired by the map-key / field-name
    - if present in either dest or updated and ` + "`" + `null` + "`" + `, clear the value
    - if present only in the dest, it keeps its value
    - if not-present in the dest, add the delta between original-updated as a field
    - otherwise recursively merge the value between original, updated, dest

  - associative list elements -- paired by the associative key
    - if present only in the dest, it keeps its value
    - if not-present in the dest, add the delta between original-updated as a field
    - otherwise recursively merge the value between original, updated, dest

### Associative Keys

  Associative keys are used to identify "same" elements within 2 different lists, and merge them.
  The following fields are recognized as associative keys:

  [` + "`" + `mountPath` + "`" + `, ` + "`" + `devicePath` + "`" + `, ` + "`" + `ip` + "`" + `, ` + "`" + `type` + "`" + `, ` + "`" + `topologyKey` + "`" + `, ` + "`" + `name` + "`" + `, ` + "`" + `containerPort` + "`" + `]

  Any lists where all of the elements contain associative keys will be merged as associative lists.`
