// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/workload_group.proto

// `WorkloadGroup` describes a collection of workload instances.
// It provides a specification that the workload instances can use to bootstrap
// their proxies, including the metadata and identity. It is only intended to
// be used with non-k8s workloads like Virtual Machines, and is meant to mimic
// the existing sidecar injection and deployment specification model used for
// Kubernetes workloads to bootstrap Istio proxies.
//
// The following example declares a workload group representing a collection
// of workloads that will be registered under `reviews` in namespace
// `bookinfo`. The set of labels will be associated with each workload
// instance during the bootstrap process, and the ports 3550 and 8080
// will be associated with the workload group and use service account `default`.
// `app.kubernetes.io/version` is just an arbitrary example of a label.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: WorkloadGroup
// metadata:
//   name: reviews
//   namespace: bookinfo
// spec:
//   metadata:
//     labels:
//       app.kubernetes.io/name: reviews
//       app.kubernetes.io/version: "1.3.4"
//   template:
//     ports:
//       grpc: 3550
//       http: 8080
//     serviceAccount: default
//   probe:
//     initialDelaySeconds: 5
//     timeoutSeconds: 3
//     periodSeconds: 4
//     successThreshold: 3
//     failureThreshold: 3
//     httpGet:
//      path: /foo/bar
//      host: 127.0.0.1
//      port: 3100
//      scheme: HTTPS
//      httpHeaders:
//      - name: Lit-Header
//        value: Im-The-Best
// ```
// {{</tab>}}
// {{</tabset>}}
//

package v1alpha3

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// `WorkloadGroup` enables specifying the properties of a single workload for bootstrap and
// provides a template for `WorkloadEntry`, similar to how `Deployment` specifies properties
// of workloads via `Pod` templates. A `WorkloadGroup` can have more than one `WorkloadEntry`.
// `WorkloadGroup` has no relationship to resources which control service registry like `ServiceEntry`
// and as such doesn't configure host name for these workloads.
//
// <!-- crd generation tags
// +cue-gen:WorkloadGroup:groupName:networking.istio.io
// +cue-gen:WorkloadGroup:version:v1alpha3
// +cue-gen:WorkloadGroup:storageVersion
// +cue-gen:WorkloadGroup:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:WorkloadGroup:subresource:status
// +cue-gen:WorkloadGroup:scope:Namespaced
// +cue-gen:WorkloadGroup:resource:categories=istio-io,networking-istio-io,shortNames=wg,plural=workloadgroups
// +cue-gen:WorkloadGroup:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// +cue-gen:WorkloadGroup:preserveUnknownFields:false
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
type WorkloadGroup struct {
	// Metadata that will be used for all corresponding `WorkloadEntries`.
	// User labels for a workload group should be set here in `metadata` rather than in `template`.
	Metadata *WorkloadGroup_ObjectMeta `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Template to be used for the generation of `WorkloadEntry` resources that belong to this `WorkloadGroup`.
	// Please note that `address` and `labels` fields should not be set in the template, and an empty `serviceAccount`
	// should default to `default`. The workload identities (mTLS certificates) will be bootstrapped using the
	// specified service account's token. Workload entries in this group will be in the same namespace as the
	// workload group, and inherit the labels and annotations from the above `metadata` field.
	Template *WorkloadEntry `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	// `ReadinessProbe` describes the configuration the user must provide for healthchecking on their workload.
	// This configuration mirrors K8S in both syntax and logic for the most part.
	Probe                *ReadinessProbe `protobuf:"bytes,3,opt,name=probe,proto3" json:"probe,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *WorkloadGroup) Reset()         { *m = WorkloadGroup{} }
func (m *WorkloadGroup) String() string { return proto.CompactTextString(m) }
func (*WorkloadGroup) ProtoMessage()    {}
func (*WorkloadGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_621fb79d92a8ed09, []int{0}
}
func (m *WorkloadGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkloadGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkloadGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkloadGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkloadGroup.Merge(m, src)
}
func (m *WorkloadGroup) XXX_Size() int {
	return m.Size()
}
func (m *WorkloadGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkloadGroup.DiscardUnknown(m)
}

var xxx_messageInfo_WorkloadGroup proto.InternalMessageInfo

func (m *WorkloadGroup) GetMetadata() *WorkloadGroup_ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *WorkloadGroup) GetTemplate() *WorkloadEntry {
	if m != nil {
		return m.Template
	}
	return nil
}

func (m *WorkloadGroup) GetProbe() *ReadinessProbe {
	if m != nil {
		return m.Probe
	}
	return nil
}

// `ObjectMeta` describes metadata that will be attached to a `WorkloadEntry`.
// It is a subset of the supported Kubernetes metadata.
type WorkloadGroup_ObjectMeta struct {
	// Labels to attach
	Labels map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Annotations to attach
	Annotations          map[string]string `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *WorkloadGroup_ObjectMeta) Reset()         { *m = WorkloadGroup_ObjectMeta{} }
func (m *WorkloadGroup_ObjectMeta) String() string { return proto.CompactTextString(m) }
func (*WorkloadGroup_ObjectMeta) ProtoMessage()    {}
func (*WorkloadGroup_ObjectMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_621fb79d92a8ed09, []int{0, 0}
}
func (m *WorkloadGroup_ObjectMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkloadGroup_ObjectMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkloadGroup_ObjectMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkloadGroup_ObjectMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkloadGroup_ObjectMeta.Merge(m, src)
}
func (m *WorkloadGroup_ObjectMeta) XXX_Size() int {
	return m.Size()
}
func (m *WorkloadGroup_ObjectMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkloadGroup_ObjectMeta.DiscardUnknown(m)
}

var xxx_messageInfo_WorkloadGroup_ObjectMeta proto.InternalMessageInfo

func (m *WorkloadGroup_ObjectMeta) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *WorkloadGroup_ObjectMeta) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

type ReadinessProbe struct {
	// Number of seconds after the container has started before readiness probes are initiated.
	InitialDelaySeconds int32 `protobuf:"varint,2,opt,name=initial_delay_seconds,json=initialDelaySeconds,proto3" json:"initial_delay_seconds,omitempty"`
	// Number of seconds after which the probe times out.
	// Defaults to 1 second. Minimum value is 1 second.
	TimeoutSeconds int32 `protobuf:"varint,3,opt,name=timeout_seconds,json=timeoutSeconds,proto3" json:"timeout_seconds,omitempty"`
	// How often (in seconds) to perform the probe.
	// Default to 10 seconds. Minimum value is 1 second.
	PeriodSeconds int32 `protobuf:"varint,4,opt,name=period_seconds,json=periodSeconds,proto3" json:"period_seconds,omitempty"`
	// Minimum consecutive successes for the probe to be considered successful after having failed.
	// Defaults to 1 second.
	SuccessThreshold int32 `protobuf:"varint,5,opt,name=success_threshold,json=successThreshold,proto3" json:"success_threshold,omitempty"`
	// Minimum consecutive failures for the probe to be considered failed after having succeeded.
	// Defaults to 3 seconds.
	FailureThreshold int32 `protobuf:"varint,6,opt,name=failure_threshold,json=failureThreshold,proto3" json:"failure_threshold,omitempty"`
	// Users can only provide one configuration for healthchecks (tcp, http, exec),
	// and this is expressed as a oneof. All of the other configuration values
	// hold true for any of the healthcheck methods.
	//
	// Types that are valid to be assigned to HealthCheckMethod:
	//	*ReadinessProbe_HttpGet
	//	*ReadinessProbe_TcpSocket
	//	*ReadinessProbe_Exec
	HealthCheckMethod    isReadinessProbe_HealthCheckMethod `protobuf_oneof:"health_check_method"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ReadinessProbe) Reset()         { *m = ReadinessProbe{} }
func (m *ReadinessProbe) String() string { return proto.CompactTextString(m) }
func (*ReadinessProbe) ProtoMessage()    {}
func (*ReadinessProbe) Descriptor() ([]byte, []int) {
	return fileDescriptor_621fb79d92a8ed09, []int{1}
}
func (m *ReadinessProbe) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadinessProbe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadinessProbe.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReadinessProbe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadinessProbe.Merge(m, src)
}
func (m *ReadinessProbe) XXX_Size() int {
	return m.Size()
}
func (m *ReadinessProbe) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadinessProbe.DiscardUnknown(m)
}

var xxx_messageInfo_ReadinessProbe proto.InternalMessageInfo

type isReadinessProbe_HealthCheckMethod interface {
	isReadinessProbe_HealthCheckMethod()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ReadinessProbe_HttpGet struct {
	HttpGet *HTTPHealthCheckConfig `protobuf:"bytes,7,opt,name=http_get,json=httpGet,proto3,oneof" json:"http_get,omitempty"`
}
type ReadinessProbe_TcpSocket struct {
	TcpSocket *TCPHealthCheckConfig `protobuf:"bytes,8,opt,name=tcp_socket,json=tcpSocket,proto3,oneof" json:"tcp_socket,omitempty"`
}
type ReadinessProbe_Exec struct {
	Exec *ExecHealthCheckConfig `protobuf:"bytes,9,opt,name=exec,proto3,oneof" json:"exec,omitempty"`
}

func (*ReadinessProbe_HttpGet) isReadinessProbe_HealthCheckMethod()   {}
func (*ReadinessProbe_TcpSocket) isReadinessProbe_HealthCheckMethod() {}
func (*ReadinessProbe_Exec) isReadinessProbe_HealthCheckMethod()      {}

func (m *ReadinessProbe) GetHealthCheckMethod() isReadinessProbe_HealthCheckMethod {
	if m != nil {
		return m.HealthCheckMethod
	}
	return nil
}

func (m *ReadinessProbe) GetInitialDelaySeconds() int32 {
	if m != nil {
		return m.InitialDelaySeconds
	}
	return 0
}

func (m *ReadinessProbe) GetTimeoutSeconds() int32 {
	if m != nil {
		return m.TimeoutSeconds
	}
	return 0
}

func (m *ReadinessProbe) GetPeriodSeconds() int32 {
	if m != nil {
		return m.PeriodSeconds
	}
	return 0
}

func (m *ReadinessProbe) GetSuccessThreshold() int32 {
	if m != nil {
		return m.SuccessThreshold
	}
	return 0
}

func (m *ReadinessProbe) GetFailureThreshold() int32 {
	if m != nil {
		return m.FailureThreshold
	}
	return 0
}

func (m *ReadinessProbe) GetHttpGet() *HTTPHealthCheckConfig {
	if x, ok := m.GetHealthCheckMethod().(*ReadinessProbe_HttpGet); ok {
		return x.HttpGet
	}
	return nil
}

func (m *ReadinessProbe) GetTcpSocket() *TCPHealthCheckConfig {
	if x, ok := m.GetHealthCheckMethod().(*ReadinessProbe_TcpSocket); ok {
		return x.TcpSocket
	}
	return nil
}

func (m *ReadinessProbe) GetExec() *ExecHealthCheckConfig {
	if x, ok := m.GetHealthCheckMethod().(*ReadinessProbe_Exec); ok {
		return x.Exec
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReadinessProbe) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReadinessProbe_HttpGet)(nil),
		(*ReadinessProbe_TcpSocket)(nil),
		(*ReadinessProbe_Exec)(nil),
	}
}

type HTTPHealthCheckConfig struct {
	// Path to access on the HTTP server.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Port on which the endpoint lives.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Host name to connect to, defaults to the pod IP. You probably want to set
	// "Host" in httpHeaders instead.
	Host string `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	// HTTP or HTTPS, defaults to HTTP
	Scheme string `protobuf:"bytes,4,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// Headers the proxy will pass on to make the request.
	// Allows repeated headers.
	HttpHeaders          []*HTTPHeader `protobuf:"bytes,5,rep,name=http_headers,json=httpHeaders,proto3" json:"http_headers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *HTTPHealthCheckConfig) Reset()         { *m = HTTPHealthCheckConfig{} }
func (m *HTTPHealthCheckConfig) String() string { return proto.CompactTextString(m) }
func (*HTTPHealthCheckConfig) ProtoMessage()    {}
func (*HTTPHealthCheckConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_621fb79d92a8ed09, []int{2}
}
func (m *HTTPHealthCheckConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPHealthCheckConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPHealthCheckConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPHealthCheckConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPHealthCheckConfig.Merge(m, src)
}
func (m *HTTPHealthCheckConfig) XXX_Size() int {
	return m.Size()
}
func (m *HTTPHealthCheckConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPHealthCheckConfig.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPHealthCheckConfig proto.InternalMessageInfo

func (m *HTTPHealthCheckConfig) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HTTPHealthCheckConfig) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *HTTPHealthCheckConfig) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *HTTPHealthCheckConfig) GetScheme() string {
	if m != nil {
		return m.Scheme
	}
	return ""
}

func (m *HTTPHealthCheckConfig) GetHttpHeaders() []*HTTPHeader {
	if m != nil {
		return m.HttpHeaders
	}
	return nil
}

type HTTPHeader struct {
	// The header field name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The header field value
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPHeader) Reset()         { *m = HTTPHeader{} }
func (m *HTTPHeader) String() string { return proto.CompactTextString(m) }
func (*HTTPHeader) ProtoMessage()    {}
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_621fb79d92a8ed09, []int{3}
}
func (m *HTTPHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPHeader.Merge(m, src)
}
func (m *HTTPHeader) XXX_Size() int {
	return m.Size()
}
func (m *HTTPHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPHeader.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPHeader proto.InternalMessageInfo

func (m *HTTPHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HTTPHeader) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type TCPHealthCheckConfig struct {
	// Host to connect to, defaults to localhost
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Port of host
	Port                 uint32   `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TCPHealthCheckConfig) Reset()         { *m = TCPHealthCheckConfig{} }
func (m *TCPHealthCheckConfig) String() string { return proto.CompactTextString(m) }
func (*TCPHealthCheckConfig) ProtoMessage()    {}
func (*TCPHealthCheckConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_621fb79d92a8ed09, []int{4}
}
func (m *TCPHealthCheckConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TCPHealthCheckConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TCPHealthCheckConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TCPHealthCheckConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TCPHealthCheckConfig.Merge(m, src)
}
func (m *TCPHealthCheckConfig) XXX_Size() int {
	return m.Size()
}
func (m *TCPHealthCheckConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TCPHealthCheckConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TCPHealthCheckConfig proto.InternalMessageInfo

func (m *TCPHealthCheckConfig) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *TCPHealthCheckConfig) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

type ExecHealthCheckConfig struct {
	// Command to run. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
	Command              []string `protobuf:"bytes,1,rep,name=command,proto3" json:"command,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecHealthCheckConfig) Reset()         { *m = ExecHealthCheckConfig{} }
func (m *ExecHealthCheckConfig) String() string { return proto.CompactTextString(m) }
func (*ExecHealthCheckConfig) ProtoMessage()    {}
func (*ExecHealthCheckConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_621fb79d92a8ed09, []int{5}
}
func (m *ExecHealthCheckConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecHealthCheckConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecHealthCheckConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecHealthCheckConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecHealthCheckConfig.Merge(m, src)
}
func (m *ExecHealthCheckConfig) XXX_Size() int {
	return m.Size()
}
func (m *ExecHealthCheckConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecHealthCheckConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExecHealthCheckConfig proto.InternalMessageInfo

func (m *ExecHealthCheckConfig) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

func init() {
	proto.RegisterType((*WorkloadGroup)(nil), "istio.networking.v1alpha3.WorkloadGroup")
	proto.RegisterType((*WorkloadGroup_ObjectMeta)(nil), "istio.networking.v1alpha3.WorkloadGroup.ObjectMeta")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.LabelsEntry")
	proto.RegisterType((*ReadinessProbe)(nil), "istio.networking.v1alpha3.ReadinessProbe")
	proto.RegisterType((*HTTPHealthCheckConfig)(nil), "istio.networking.v1alpha3.HTTPHealthCheckConfig")
	proto.RegisterType((*HTTPHeader)(nil), "istio.networking.v1alpha3.HTTPHeader")
	proto.RegisterType((*TCPHealthCheckConfig)(nil), "istio.networking.v1alpha3.TCPHealthCheckConfig")
	proto.RegisterType((*ExecHealthCheckConfig)(nil), "istio.networking.v1alpha3.ExecHealthCheckConfig")
}

func init() {
	proto.RegisterFile("networking/v1alpha3/workload_group.proto", fileDescriptor_621fb79d92a8ed09)
}

var fileDescriptor_621fb79d92a8ed09 = []byte{
	// 708 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0xdd, 0x4e, 0xdb, 0x4a,
	0x10, 0xc7, 0x8f, 0xf3, 0x45, 0x3c, 0x39, 0x70, 0x38, 0x0b, 0x39, 0xf2, 0xc9, 0x05, 0x45, 0x91,
	0x50, 0x53, 0x55, 0x72, 0x0a, 0x48, 0x55, 0xdb, 0x8b, 0x22, 0xbe, 0x4a, 0x54, 0x15, 0x81, 0x4c,
	0x24, 0xa4, 0xde, 0x58, 0x1b, 0x7b, 0x12, 0x6f, 0x63, 0x7b, 0x2d, 0xef, 0x86, 0xc2, 0x9b, 0x55,
	0xea, 0x0b, 0x70, 0xd9, 0x47, 0xa8, 0xf2, 0x00, 0x7d, 0x86, 0xca, 0x6b, 0xe7, 0x83, 0xca, 0x84,
	0x96, 0xbb, 0xf1, 0xcc, 0x7f, 0x7e, 0x3b, 0x1f, 0xeb, 0x85, 0x56, 0x88, 0xf2, 0x33, 0x8f, 0x87,
	0x2c, 0x1c, 0xb4, 0xaf, 0xb6, 0xa9, 0x1f, 0x79, 0x74, 0xb7, 0x9d, 0x38, 0x7c, 0x4e, 0x5d, 0x7b,
	0x10, 0xf3, 0x51, 0x64, 0x46, 0x31, 0x97, 0x9c, 0xfc, 0xcf, 0x84, 0x64, 0xdc, 0x9c, 0xe9, 0xcd,
	0x89, 0xbe, 0xf1, 0x64, 0xc0, 0xf9, 0xc0, 0xc7, 0x36, 0x8d, 0x58, 0xbb, 0xcf, 0xd0, 0x77, 0xed,
	0x1e, 0x7a, 0xf4, 0x8a, 0xf1, 0x38, 0xcd, 0x6d, 0x2c, 0x3e, 0x05, 0x43, 0x19, 0xdf, 0xa4, 0xca,
	0xe6, 0x97, 0x12, 0x2c, 0x5f, 0x66, 0x81, 0x93, 0xe4, 0x74, 0x72, 0x06, 0xd5, 0x00, 0x25, 0x75,
	0xa9, 0xa4, 0x86, 0xb6, 0xa9, 0xb5, 0x6a, 0x3b, 0xbb, 0xe6, 0xbd, 0xa5, 0x98, 0x77, 0x72, 0xcd,
	0xb3, 0xde, 0x27, 0x74, 0xe4, 0x29, 0x4a, 0x6a, 0x4d, 0x21, 0xe4, 0x3d, 0x54, 0x25, 0x06, 0x91,
	0x4f, 0x25, 0x1a, 0x05, 0x05, 0x6c, 0xfd, 0x06, 0xf0, 0x38, 0x29, 0xf2, 0xa0, 0x34, 0xde, 0xd7,
	0x0a, 0xd6, 0x34, 0x9f, 0xec, 0x41, 0x39, 0x8a, 0x79, 0x0f, 0x8d, 0xa2, 0x02, 0x3d, 0x5b, 0x00,
	0xb2, 0x90, 0xba, 0x2c, 0x44, 0x21, 0xce, 0x93, 0x04, 0x2b, 0xcd, 0x6b, 0xdc, 0x16, 0x00, 0x66,
	0x55, 0x92, 0x4b, 0xa8, 0xf8, 0xb4, 0x87, 0xbe, 0x30, 0xb4, 0xcd, 0x62, 0xab, 0xb6, 0xb3, 0xf7,
	0x88, 0x56, 0xcd, 0x0f, 0x8a, 0xa0, 0x0a, 0xb6, 0x32, 0x1c, 0xe9, 0x43, 0x8d, 0x86, 0x21, 0x97,
	0x54, 0x32, 0x1e, 0x0a, 0xa3, 0xa0, 0xe8, 0x47, 0x8f, 0xa1, 0xef, 0xcf, 0x30, 0xe9, 0x11, 0xf3,
	0xe0, 0xc6, 0x6b, 0xa8, 0xcd, 0x1d, 0x4f, 0x56, 0xa1, 0x38, 0xc4, 0x1b, 0xb5, 0x37, 0xdd, 0x4a,
	0x4c, 0xb2, 0x0e, 0xe5, 0x2b, 0xea, 0x8f, 0xd2, 0xd1, 0xeb, 0x56, 0xfa, 0xf1, 0xa6, 0xf0, 0x4a,
	0x6b, 0xbc, 0x85, 0xd5, 0x5f, 0xd9, 0x7f, 0x92, 0xdf, 0xfc, 0x51, 0x84, 0x95, 0xbb, 0x43, 0x26,
	0x3b, 0x50, 0x67, 0x21, 0x93, 0x8c, 0xfa, 0xb6, 0x8b, 0x3e, 0xbd, 0xb1, 0x05, 0x3a, 0x3c, 0x74,
	0x85, 0x4a, 0x2e, 0x5b, 0x6b, 0x59, 0xf0, 0x28, 0x89, 0x5d, 0xa4, 0x21, 0xf2, 0x14, 0xfe, 0x91,
	0x2c, 0x40, 0x3e, 0x92, 0x53, 0x75, 0x51, 0xa9, 0x57, 0x32, 0xf7, 0x44, 0xb8, 0x05, 0x2b, 0x11,
	0xc6, 0x8c, 0xbb, 0x53, 0x5d, 0x49, 0xe9, 0x96, 0x53, 0xef, 0x44, 0xf6, 0x1c, 0xfe, 0x15, 0x23,
	0xc7, 0x41, 0x21, 0x6c, 0xe9, 0xc5, 0x28, 0x3c, 0xee, 0xbb, 0x46, 0x59, 0x29, 0x57, 0xb3, 0x40,
	0x77, 0xe2, 0x4f, 0xc4, 0x7d, 0xca, 0xfc, 0x51, 0x8c, 0x73, 0xe2, 0x4a, 0x2a, 0xce, 0x02, 0x33,
	0xf1, 0x29, 0x54, 0x3d, 0x29, 0x23, 0x7b, 0x80, 0xd2, 0x58, 0x52, 0xf7, 0xef, 0xc5, 0x82, 0x85,
	0x76, 0xba, 0xdd, 0xf3, 0x0e, 0x52, 0x5f, 0x7a, 0x87, 0x1e, 0x3a, 0xc3, 0x43, 0x1e, 0xf6, 0xd9,
	0xa0, 0xf3, 0x97, 0xb5, 0x94, 0x30, 0x4e, 0x50, 0x92, 0x73, 0x00, 0xe9, 0x44, 0xb6, 0xe0, 0xce,
	0x10, 0xa5, 0x51, 0x55, 0xc0, 0xf6, 0x02, 0x60, 0xf7, 0x30, 0x97, 0xa7, 0x4b, 0x27, 0xba, 0x50,
	0x0c, 0xf2, 0x0e, 0x4a, 0x78, 0x8d, 0x8e, 0xa1, 0x3f, 0x58, 0xdc, 0xf1, 0x35, 0x3a, 0x79, 0x30,
	0x95, 0x7f, 0x50, 0x87, 0x35, 0x4f, 0x05, 0x6d, 0x27, 0x89, 0xda, 0x01, 0x4a, 0x8f, 0xbb, 0xcd,
	0xaf, 0x1a, 0xd4, 0x73, 0xbb, 0x22, 0x04, 0x4a, 0x11, 0x95, 0x5e, 0x76, 0x6f, 0x94, 0x4d, 0x0c,
	0x28, 0x45, 0x3c, 0x96, 0x6a, 0xf5, 0xcb, 0xd9, 0x8f, 0xac, 0x3c, 0x89, 0xda, 0xe3, 0x42, 0xaa,
	0x35, 0xeb, 0x96, 0xb2, 0xc9, 0x7f, 0x50, 0x11, 0x8e, 0x87, 0x01, 0xaa, 0xa5, 0xea, 0x56, 0xf6,
	0x45, 0x3a, 0xf0, 0xb7, 0x9a, 0xb9, 0x87, 0xd4, 0xc5, 0x58, 0x18, 0x65, 0xf5, 0x23, 0x6d, 0x3d,
	0x3c, 0x77, 0x17, 0x63, 0xab, 0x96, 0xa4, 0xa6, 0xb6, 0x68, 0xbe, 0x04, 0x98, 0x85, 0x92, 0x1a,
	0x42, 0x1a, 0xe0, 0xa4, 0xe2, 0xc4, 0xce, 0xbf, 0xea, 0xcd, 0x23, 0x58, 0xcf, 0x9b, 0xfc, 0xb4,
	0x0b, 0x6d, 0xae, 0x8b, 0x7b, 0x7b, 0x6e, 0x6e, 0x43, 0x3d, 0x77, 0xe6, 0xc4, 0x80, 0x25, 0x87,
	0x07, 0x01, 0x0d, 0x5d, 0xf5, 0x04, 0xe9, 0xd6, 0xe4, 0xf3, 0xc0, 0xbc, 0x1d, 0x6f, 0x68, 0xdf,
	0xc6, 0x1b, 0xda, 0xf7, 0xf1, 0x86, 0xf6, 0x71, 0x33, 0xed, 0x98, 0x71, 0xf5, 0xea, 0xe7, 0xbc,
	0xef, 0xbd, 0x8a, 0x7a, 0xd1, 0x77, 0x7f, 0x06, 0x00, 0x00, 0xff, 0xff, 0x3a, 0xe3, 0x83, 0x8e,
	0x63, 0x06, 0x00, 0x00,
}

func (m *WorkloadGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkloadGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkloadGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Probe != nil {
		{
			size, err := m.Probe.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Template != nil {
		{
			size, err := m.Template.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WorkloadGroup_ObjectMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkloadGroup_ObjectMeta) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkloadGroup_ObjectMeta) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ReadinessProbe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadinessProbe) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadinessProbe) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.HealthCheckMethod != nil {
		{
			size := m.HealthCheckMethod.Size()
			i -= size
			if _, err := m.HealthCheckMethod.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.FailureThreshold != 0 {
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(m.FailureThreshold))
		i--
		dAtA[i] = 0x30
	}
	if m.SuccessThreshold != 0 {
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(m.SuccessThreshold))
		i--
		dAtA[i] = 0x28
	}
	if m.PeriodSeconds != 0 {
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(m.PeriodSeconds))
		i--
		dAtA[i] = 0x20
	}
	if m.TimeoutSeconds != 0 {
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(m.TimeoutSeconds))
		i--
		dAtA[i] = 0x18
	}
	if m.InitialDelaySeconds != 0 {
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(m.InitialDelaySeconds))
		i--
		dAtA[i] = 0x10
	}
	return len(dAtA) - i, nil
}

func (m *ReadinessProbe_HttpGet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadinessProbe_HttpGet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.HttpGet != nil {
		{
			size, err := m.HttpGet.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *ReadinessProbe_TcpSocket) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadinessProbe_TcpSocket) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.TcpSocket != nil {
		{
			size, err := m.TcpSocket.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *ReadinessProbe_Exec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadinessProbe_Exec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Exec != nil {
		{
			size, err := m.Exec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *HTTPHealthCheckConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPHealthCheckConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPHealthCheckConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.HttpHeaders) > 0 {
		for iNdEx := len(m.HttpHeaders) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HttpHeaders[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintWorkloadGroup(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Scheme) > 0 {
		i -= len(m.Scheme)
		copy(dAtA[i:], m.Scheme)
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(m.Scheme)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Port != 0 {
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HTTPHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TCPHealthCheckConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TCPHealthCheckConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TCPHealthCheckConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Port != 0 {
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExecHealthCheckConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecHealthCheckConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecHealthCheckConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Command) > 0 {
		for iNdEx := len(m.Command) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Command[iNdEx])
			copy(dAtA[i:], m.Command[iNdEx])
			i = encodeVarintWorkloadGroup(dAtA, i, uint64(len(m.Command[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintWorkloadGroup(dAtA []byte, offset int, v uint64) int {
	offset -= sovWorkloadGroup(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *WorkloadGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	if m.Template != nil {
		l = m.Template.Size()
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	if m.Probe != nil {
		l = m.Probe.Size()
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WorkloadGroup_ObjectMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovWorkloadGroup(uint64(len(k))) + 1 + len(v) + sovWorkloadGroup(uint64(len(v)))
			n += mapEntrySize + 1 + sovWorkloadGroup(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovWorkloadGroup(uint64(len(k))) + 1 + len(v) + sovWorkloadGroup(uint64(len(v)))
			n += mapEntrySize + 1 + sovWorkloadGroup(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReadinessProbe) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.InitialDelaySeconds != 0 {
		n += 1 + sovWorkloadGroup(uint64(m.InitialDelaySeconds))
	}
	if m.TimeoutSeconds != 0 {
		n += 1 + sovWorkloadGroup(uint64(m.TimeoutSeconds))
	}
	if m.PeriodSeconds != 0 {
		n += 1 + sovWorkloadGroup(uint64(m.PeriodSeconds))
	}
	if m.SuccessThreshold != 0 {
		n += 1 + sovWorkloadGroup(uint64(m.SuccessThreshold))
	}
	if m.FailureThreshold != 0 {
		n += 1 + sovWorkloadGroup(uint64(m.FailureThreshold))
	}
	if m.HealthCheckMethod != nil {
		n += m.HealthCheckMethod.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReadinessProbe_HttpGet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpGet != nil {
		l = m.HttpGet.Size()
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	return n
}
func (m *ReadinessProbe_TcpSocket) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TcpSocket != nil {
		l = m.TcpSocket.Size()
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	return n
}
func (m *ReadinessProbe_Exec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Exec != nil {
		l = m.Exec.Size()
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	return n
}
func (m *HTTPHealthCheckConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovWorkloadGroup(uint64(m.Port))
	}
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	l = len(m.Scheme)
	if l > 0 {
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	if len(m.HttpHeaders) > 0 {
		for _, e := range m.HttpHeaders {
			l = e.Size()
			n += 1 + l + sovWorkloadGroup(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TCPHealthCheckConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovWorkloadGroup(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovWorkloadGroup(uint64(m.Port))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExecHealthCheckConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovWorkloadGroup(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovWorkloadGroup(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozWorkloadGroup(x uint64) (n int) {
	return sovWorkloadGroup(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *WorkloadGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorkloadGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WorkloadGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WorkloadGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &WorkloadGroup_ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Template", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Template == nil {
				m.Template = &WorkloadEntry{}
			}
			if err := m.Template.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Probe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Probe == nil {
				m.Probe = &ReadinessProbe{}
			}
			if err := m.Probe.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorkloadGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WorkloadGroup_ObjectMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorkloadGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ObjectMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ObjectMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowWorkloadGroup
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkloadGroup
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkloadGroup
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipWorkloadGroup(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowWorkloadGroup
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkloadGroup
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkloadGroup
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipWorkloadGroup(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthWorkloadGroup
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorkloadGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadinessProbe) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorkloadGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadinessProbe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadinessProbe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialDelaySeconds", wireType)
			}
			m.InitialDelaySeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitialDelaySeconds |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutSeconds", wireType)
			}
			m.TimeoutSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeoutSeconds |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeriodSeconds", wireType)
			}
			m.PeriodSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PeriodSeconds |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuccessThreshold", wireType)
			}
			m.SuccessThreshold = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SuccessThreshold |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailureThreshold", wireType)
			}
			m.FailureThreshold = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FailureThreshold |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpGet", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HTTPHealthCheckConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HealthCheckMethod = &ReadinessProbe_HttpGet{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpSocket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TCPHealthCheckConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HealthCheckMethod = &ReadinessProbe_TcpSocket{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExecHealthCheckConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HealthCheckMethod = &ReadinessProbe_Exec{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorkloadGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPHealthCheckConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorkloadGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPHealthCheckConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPHealthCheckConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scheme", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scheme = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpHeaders = append(m.HttpHeaders, &HTTPHeader{})
			if err := m.HttpHeaders[len(m.HttpHeaders)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorkloadGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorkloadGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorkloadGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TCPHealthCheckConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorkloadGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TCPHealthCheckConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TCPHealthCheckConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipWorkloadGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExecHealthCheckConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorkloadGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecHealthCheckConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecHealthCheckConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorkloadGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorkloadGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipWorkloadGroup(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowWorkloadGroup
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowWorkloadGroup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthWorkloadGroup
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupWorkloadGroup
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthWorkloadGroup
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthWorkloadGroup        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowWorkloadGroup          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupWorkloadGroup = fmt.Errorf("proto: unexpected end of group")
)
