// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/envoy_filter.proto

// `EnvoyFilter` provides a mechanism to customize the Envoy
// configuration generated by Istio Pilot. Use EnvoyFilter to modify
// values for certain fields, add specific filters, or even add
// entirely new listeners, clusters, etc. This feature must be used
// with care, as incorrect configurations could potentially
// destabilize the entire mesh. Unlike other Istio networking objects,
// EnvoyFilters are additively applied. Any number of EnvoyFilters can
// exist for a given workload in a specific namespace. The order of
// application of these EnvoyFilters is as follows: all EnvoyFilters
// in the config [root
// namespace](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig),
// followed by all matching EnvoyFilters in the workload's namespace.
//
// **NOTE 1**: Some aspects of this API are deeply tied to the internal
// implementation in Istio networking subsystem as well as Envoy's XDS
// API. While the EnvoyFilter API by itself will maintain backward
// compatibility, any envoy configuration provided through this
// mechanism should be carefully monitored across Istio proxy version
// upgrades, to ensure that deprecated fields are removed and replaced
// appropriately.
//
// **NOTE 2**: When multiple EnvoyFilters are bound to the same
// workload in a given namespace, all patches will be processed
// sequentially in order of creation time.  The behavior is undefined
// if multiple EnvoyFilter configurations conflict with each other.
//
// **NOTE 3**: To apply an EnvoyFilter resource to all workloads
// (sidecars and gateways) in the system, define the resource in the
// config [root
// namespace](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig),
// without a workloadSelector.
//
// The example below declares a global default EnvoyFilter resource in
// the root namespace called `istio-config`, that adds a custom
// protocol filter on all sidecars in the system, for outbound port
// 9307. The filter should be added before the terminating tcp_proxy
// filter to take effect. In addition, it sets a 30s idle timeout for
// all HTTP connections in both gateways and sidecars.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: custom-protocol
//   namespace: istio-config # as defined in meshConfig resource.
// spec:
//   configPatches:
//   - applyTo: NETWORK_FILTER
//     match:
//       context: SIDECAR_OUTBOUND # will match outbound listeners in all sidecars
//       listener:
//         portNumber: 9307
//         filterChain:
//           filter:
//             name: "envoy.filters.network.tcp_proxy"
//     patch:
//       operation: INSERT_BEFORE
//       value:
//         # This is the full filter config including the name and typed_config section.
//         name: "envoy.config.filter.network.custom_protocol"
//         typed_config:
//          ...
//   - applyTo: NETWORK_FILTER # http connection manager is a filter in Envoy
//     match:
//       # context omitted so that this applies to both sidecars and gateways
//       listener:
//         filterChain:
//           filter:
//             name: "envoy.filters.network.http_connection_manager"
//     patch:
//       operation: MERGE
//       value:
//         name: "envoy.filters.network.http_connection_manager"
//         typed_config:
//           "@type": "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager"
//           common_http_protocol_options:
//             idle_timeout: 30s
// ```
//
// The following example enables Envoy's Lua filter for all inbound
// HTTP calls arriving at service port 8080 of the reviews service pod
// with labels "app: reviews", in the bookinfo namespace. The lua
// filter calls out to an external service internal.org.net:8888 that
// requires a special cluster definition in envoy. The cluster is also
// added to the sidecar as part of this configuration.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: reviews-lua
//   namespace: bookinfo
// spec:
//   workloadSelector:
//     labels:
//       app: reviews
//   configPatches:
//     # The first patch adds the lua filter to the listener/http connection manager
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//       listener:
//         portNumber: 8080
//         filterChain:
//           filter:
//             name: "envoy.filters.network.http_connection_manager"
//             subFilter:
//               name: "envoy.filters.http.router"
//     patch:
//       operation: INSERT_BEFORE
//       value: # lua filter specification
//        name: envoy.lua
//        typed_config:
//           "@type": "type.googleapis.com/envoy.extensions.filters.http.lua.v3.Lua"
//           inlineCode: |
//             function envoy_on_request(request_handle)
//               -- Make an HTTP call to an upstream host with the following headers, body, and timeout.
//               local headers, body = request_handle:httpCall(
//                "lua_cluster",
//                {
//                 [":method"] = "POST",
//                 [":path"] = "/acl",
//                 [":authority"] = "internal.org.net"
//                },
//               "authorize call",
//               5000)
//             end
//   # The second patch adds the cluster that is referenced by the lua code
//   # cds match is omitted as a new cluster is being added
//   - applyTo: CLUSTER
//     match:
//       context: SIDECAR_OUTBOUND
//     patch:
//       operation: ADD
//       value: # cluster specification
//         name: "lua_cluster"
//         type: STRICT_DNS
//         connect_timeout: 0.5s
//         lb_policy: ROUND_ROBIN
//         load_assignment:
//           cluster_name: lua_cluster
//           endpoints:
//           - lb_endpoints:
//             - endpoint:
//                 address:
//                   socket_address:
//                     protocol: TCP
//                     address: "internal.org.net"
//                     port_value: 8888
// ```
//
// The following example overwrites certain fields (HTTP idle timeout
// and X-Forward-For trusted hops) in the HTTP connection manager in a
// listener on the ingress gateway in istio-system namespace for the
// SNI host app.example.com:
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: hcm-tweaks
//   namespace: istio-system
// spec:
//   workloadSelector:
//     labels:
//       istio: ingressgateway
//   configPatches:
//   - applyTo: NETWORK_FILTER # http connection manager is a filter in Envoy
//     match:
//       context: GATEWAY
//       listener:
//         filterChain:
//           sni: app.example.com
//           filter:
//             name: "envoy.filters.network.http_connection_manager"
//     patch:
//       operation: MERGE
//       value:
//         typed_config:
//           "@type": "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager"
//           xff_num_trusted_hops: 5
//           common_http_protocol_options:
//             idle_timeout: 30s
// ```
//
// The following example inserts an attributegen filter
// that produces `istio_operationId` attribute which is consumed
// by the istio.stats fiter. `filterClass: STATS` encodes this dependency.
//
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: reviews-request-operation
//   namespace: myns
// spec:
//   workloadSelector:
//     labels:
//       app: reviews
//   configPatches:
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//     patch:
//       operation: ADD
//       filterClass: STATS # This filter will run *before* the Istio stats filter.
//       value:
//         name: istio.request_operation
//         typed_config:
//          "@type": type.googleapis.com/udpa.type.v1.TypedStruct
//          type_url: type.googleapis.com/envoy.extensions.filters.http.wasm.v3.Wasm
//          value:
//            config:
//              configuration: |
//                {
//                  "attributes": [
//                    {
//                      "output_attribute": "istio_operationId",
//                      "match": [
//                        {
//                          "value": "ListReviews",
//                          "condition": "request.url_path == '/reviews' && request.method == 'GET'"
//                        }]
//                    }]
//                }
//              vm_config:
//                runtime: envoy.wasm.runtime.null
//                code:
//                  local: { inline_string: "envoy.wasm.attributegen" }
// ```
//
// The following example inserts an http ext_authz filter in the `myns` namespace.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: myns-ext-authz
//   namespace: myns
// spec:
//   configPatches:
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//     patch:
//       operation: ADD
//       filterClass: AUTHZ # This filter will run *after* the Istio authz filter.
//       value:
//         name: envoy.filters.http.ext_authz
//         typed_config:
//           "@type": type.googleapis.com/envoy.extensions.filters.http.ext_authz.v3.ExtAuthz
//           grpc_service:
//             envoy_grpc:
//               cluster_name: acme-ext-authz
//             initial_metadata:
//             - key: foo
//               value: myauth.acme # required by local ext auth server.
// ```
//
// A workload in the `myns` namespace needs to access a different ext_auth server
// that does not accept initial metadata. Since proto merge cannot remove fields, the
// following configuration uses the `REPLACE` operation. If you do not need to inherit
// fields, REPLACE is preferred over MERGE.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: mysvc-ext-authz
//   namespace: myns
// spec:
//   workloadSelector:
//     labels:
//       app: mysvc
//   configPatches:
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//     patch:
//       operation: REPLACE
//       value:
//         name: envoy.filters.http.ext_authz
//         typed_config:
//           "@type": type.googleapis.com/envoy.extensions.filters.http.ext_authz.v3.ExtAuthz
//           grpc_service:
//             envoy_grpc:
//               cluster_name: acme-ext-authz-alt
// ```
//
// The following example deploys a Wasm extension for all inbound sidecar HTTP requests.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: wasm-example
//   namespace: myns
// spec:
//   configPatches:
//   # The first patch defines a named Wasm extension and provides a URL to fetch Wasm binary from,
//   # and the binary configuration. It should come before the next patch that applies it.
//   # This resource is visible to all proxies in the namespace "myns". It is possible to provide
//   # multiple definitions for the same name "my-wasm-extension" in multiple namespaces. We recommend that:
//   # - if overriding is desired, then the root level definition can be overriden per namespace with REPLACE.
//   # - if overriding is not desired, then the name should be qualified with the namespace "myns/my-wasm-extension",
//   #   to avoid accidental name collisions.
//   - applyTo: EXTENSION_CONFIG
//     patch:
//       operation: ADD # REPLACE is also supported, and would override a cluster level resource with the same name.
//       value:
//         name: my-wasm-extension
//         typed_config:
//           "@type": type.googleapis.com/envoy.extensions.filters.http.wasm.v3.Wasm
//           config:
//             root_id: my-wasm-root-id
//             vm_config:
//               vm_id: my-wasm-vm-id
//               runtime: envoy.wasm.runtime.v8
//               code:
//                 remote:
//                   http_uri:
//                     uri: http://my-wasm-binary-uri
//             configuration:
//               "@type": "type.googleapis.com/google.protobuf.StringValue"
//               value: |
//                 {}
//   # The second patch instructs to apply the above Wasm filter to the listener/http connection manager.
//   - applyTo: HTTP_FILTER
//     match:
//       context: SIDECAR_INBOUND
//     patch:
//       operation: ADD
//       filterClass: AUTHZ # This filter will run *after* the Istio authz filter.
//       value:
//         name: my-wasm-extension # This must match the name above
//         config_discovery:
//           config_source:
//             ads: {}
//           type_urls: ["envoy.extensions.filters.http.wasm.v3.Wasm"]
// ```
//
// The following example adds a Wasm service extension for all proxies using a locally available Wasm file.
// The singleton Wasm extension is used to maintain a shared state between workers executing Wasm filters.
// For example, a local rate limit extension would rely on a singleton to limit requests across all workers.
// As another example, an authorization Wasm extension can use a singleton to maintain a database of accounts.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: wasm-service
//   namespace: myns
// spec:
//   configPatches:
//   - applyTo: BOOTSTRAP
//     patch:
//       operation: MERGE
//       value:
//         bootstrap_extensions:
//         - name: envoy.bootstrap.wasm
//           typed_config:
//             "@type": type.googleapis.com/envoy.extensions.wasm.v3.WasmService
//             singleton: true
//             config:
//               name: my_plugin
//               configuration:
//                 "@type": type.googleapis.com/google.protobuf.StringValue
//                 value: |
//                   {}
//               vm_config:
//                 runtime: "envoy.wasm.runtime.v8"
//                 code:
//                   local:
//                     filename: "/etc/envoy_filter_http_wasm_example.wasm"
// ```

package v1alpha3

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// DeepCopyInto supports using EnvoyFilter within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter) DeepCopyInto(out *EnvoyFilter) {
	p := proto.Clone(in).(*EnvoyFilter)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter. Required by controller-gen.
func (in *EnvoyFilter) DeepCopy() *EnvoyFilter {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter. Required by controller-gen.
func (in *EnvoyFilter) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_ProxyMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_ProxyMatch) DeepCopyInto(out *EnvoyFilter_ProxyMatch) {
	p := proto.Clone(in).(*EnvoyFilter_ProxyMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ProxyMatch. Required by controller-gen.
func (in *EnvoyFilter_ProxyMatch) DeepCopy() *EnvoyFilter_ProxyMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_ProxyMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ProxyMatch. Required by controller-gen.
func (in *EnvoyFilter_ProxyMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_ClusterMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_ClusterMatch) DeepCopyInto(out *EnvoyFilter_ClusterMatch) {
	p := proto.Clone(in).(*EnvoyFilter_ClusterMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ClusterMatch. Required by controller-gen.
func (in *EnvoyFilter_ClusterMatch) DeepCopy() *EnvoyFilter_ClusterMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_ClusterMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ClusterMatch. Required by controller-gen.
func (in *EnvoyFilter_ClusterMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_RouteConfigurationMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_RouteConfigurationMatch) DeepCopyInto(out *EnvoyFilter_RouteConfigurationMatch) {
	p := proto.Clone(in).(*EnvoyFilter_RouteConfigurationMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_RouteConfigurationMatch. Required by controller-gen.
func (in *EnvoyFilter_RouteConfigurationMatch) DeepCopy() *EnvoyFilter_RouteConfigurationMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_RouteConfigurationMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_RouteConfigurationMatch. Required by controller-gen.
func (in *EnvoyFilter_RouteConfigurationMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_RouteConfigurationMatch_RouteMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_RouteConfigurationMatch_RouteMatch) DeepCopyInto(out *EnvoyFilter_RouteConfigurationMatch_RouteMatch) {
	p := proto.Clone(in).(*EnvoyFilter_RouteConfigurationMatch_RouteMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_RouteConfigurationMatch_RouteMatch. Required by controller-gen.
func (in *EnvoyFilter_RouteConfigurationMatch_RouteMatch) DeepCopy() *EnvoyFilter_RouteConfigurationMatch_RouteMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_RouteConfigurationMatch_RouteMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_RouteConfigurationMatch_RouteMatch. Required by controller-gen.
func (in *EnvoyFilter_RouteConfigurationMatch_RouteMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) DeepCopyInto(out *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) {
	p := proto.Clone(in).(*EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch. Required by controller-gen.
func (in *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) DeepCopy() *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch. Required by controller-gen.
func (in *EnvoyFilter_RouteConfigurationMatch_VirtualHostMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_ListenerMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_ListenerMatch) DeepCopyInto(out *EnvoyFilter_ListenerMatch) {
	p := proto.Clone(in).(*EnvoyFilter_ListenerMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ListenerMatch. Required by controller-gen.
func (in *EnvoyFilter_ListenerMatch) DeepCopy() *EnvoyFilter_ListenerMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_ListenerMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ListenerMatch. Required by controller-gen.
func (in *EnvoyFilter_ListenerMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_ListenerMatch_FilterChainMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_ListenerMatch_FilterChainMatch) DeepCopyInto(out *EnvoyFilter_ListenerMatch_FilterChainMatch) {
	p := proto.Clone(in).(*EnvoyFilter_ListenerMatch_FilterChainMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ListenerMatch_FilterChainMatch. Required by controller-gen.
func (in *EnvoyFilter_ListenerMatch_FilterChainMatch) DeepCopy() *EnvoyFilter_ListenerMatch_FilterChainMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_ListenerMatch_FilterChainMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ListenerMatch_FilterChainMatch. Required by controller-gen.
func (in *EnvoyFilter_ListenerMatch_FilterChainMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_ListenerMatch_FilterMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_ListenerMatch_FilterMatch) DeepCopyInto(out *EnvoyFilter_ListenerMatch_FilterMatch) {
	p := proto.Clone(in).(*EnvoyFilter_ListenerMatch_FilterMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ListenerMatch_FilterMatch. Required by controller-gen.
func (in *EnvoyFilter_ListenerMatch_FilterMatch) DeepCopy() *EnvoyFilter_ListenerMatch_FilterMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_ListenerMatch_FilterMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ListenerMatch_FilterMatch. Required by controller-gen.
func (in *EnvoyFilter_ListenerMatch_FilterMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_ListenerMatch_SubFilterMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_ListenerMatch_SubFilterMatch) DeepCopyInto(out *EnvoyFilter_ListenerMatch_SubFilterMatch) {
	p := proto.Clone(in).(*EnvoyFilter_ListenerMatch_SubFilterMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ListenerMatch_SubFilterMatch. Required by controller-gen.
func (in *EnvoyFilter_ListenerMatch_SubFilterMatch) DeepCopy() *EnvoyFilter_ListenerMatch_SubFilterMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_ListenerMatch_SubFilterMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_ListenerMatch_SubFilterMatch. Required by controller-gen.
func (in *EnvoyFilter_ListenerMatch_SubFilterMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_Patch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_Patch) DeepCopyInto(out *EnvoyFilter_Patch) {
	p := proto.Clone(in).(*EnvoyFilter_Patch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_Patch. Required by controller-gen.
func (in *EnvoyFilter_Patch) DeepCopy() *EnvoyFilter_Patch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_Patch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_Patch. Required by controller-gen.
func (in *EnvoyFilter_Patch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_EnvoyConfigObjectMatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_EnvoyConfigObjectMatch) DeepCopyInto(out *EnvoyFilter_EnvoyConfigObjectMatch) {
	p := proto.Clone(in).(*EnvoyFilter_EnvoyConfigObjectMatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_EnvoyConfigObjectMatch. Required by controller-gen.
func (in *EnvoyFilter_EnvoyConfigObjectMatch) DeepCopy() *EnvoyFilter_EnvoyConfigObjectMatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_EnvoyConfigObjectMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_EnvoyConfigObjectMatch. Required by controller-gen.
func (in *EnvoyFilter_EnvoyConfigObjectMatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}

// DeepCopyInto supports using EnvoyFilter_EnvoyConfigObjectPatch within kubernetes types, where deepcopy-gen is used.
func (in *EnvoyFilter_EnvoyConfigObjectPatch) DeepCopyInto(out *EnvoyFilter_EnvoyConfigObjectPatch) {
	p := proto.Clone(in).(*EnvoyFilter_EnvoyConfigObjectPatch)
	*out = *p
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_EnvoyConfigObjectPatch. Required by controller-gen.
func (in *EnvoyFilter_EnvoyConfigObjectPatch) DeepCopy() *EnvoyFilter_EnvoyConfigObjectPatch {
	if in == nil {
		return nil
	}
	out := new(EnvoyFilter_EnvoyConfigObjectPatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInterface is an autogenerated deepcopy function, copying the receiver, creating a new EnvoyFilter_EnvoyConfigObjectPatch. Required by controller-gen.
func (in *EnvoyFilter_EnvoyConfigObjectPatch) DeepCopyInterface() interface{} {
	return in.DeepCopy()
}
