//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright (c) SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha1

import (
	unsafe "unsafe"

	openstack "github.com/gardener/gardener-extension-provider-openstack/pkg/apis/openstack"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*CloudControllerManagerConfig)(nil), (*openstack.CloudControllerManagerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CloudControllerManagerConfig_To_openstack_CloudControllerManagerConfig(a.(*CloudControllerManagerConfig), b.(*openstack.CloudControllerManagerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.CloudControllerManagerConfig)(nil), (*CloudControllerManagerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig(a.(*openstack.CloudControllerManagerConfig), b.(*CloudControllerManagerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CloudProfileConfig)(nil), (*openstack.CloudProfileConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CloudProfileConfig_To_openstack_CloudProfileConfig(a.(*CloudProfileConfig), b.(*openstack.CloudProfileConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.CloudProfileConfig)(nil), (*CloudProfileConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_CloudProfileConfig_To_v1alpha1_CloudProfileConfig(a.(*openstack.CloudProfileConfig), b.(*CloudProfileConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Constraints)(nil), (*openstack.Constraints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Constraints_To_openstack_Constraints(a.(*Constraints), b.(*openstack.Constraints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.Constraints)(nil), (*Constraints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_Constraints_To_v1alpha1_Constraints(a.(*openstack.Constraints), b.(*Constraints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControlPlaneConfig)(nil), (*openstack.ControlPlaneConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControlPlaneConfig_To_openstack_ControlPlaneConfig(a.(*ControlPlaneConfig), b.(*openstack.ControlPlaneConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.ControlPlaneConfig)(nil), (*ControlPlaneConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_ControlPlaneConfig_To_v1alpha1_ControlPlaneConfig(a.(*openstack.ControlPlaneConfig), b.(*ControlPlaneConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FloatingPool)(nil), (*openstack.FloatingPool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_FloatingPool_To_openstack_FloatingPool(a.(*FloatingPool), b.(*openstack.FloatingPool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.FloatingPool)(nil), (*FloatingPool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_FloatingPool_To_v1alpha1_FloatingPool(a.(*openstack.FloatingPool), b.(*FloatingPool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FloatingPoolStatus)(nil), (*openstack.FloatingPoolStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_FloatingPoolStatus_To_openstack_FloatingPoolStatus(a.(*FloatingPoolStatus), b.(*openstack.FloatingPoolStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.FloatingPoolStatus)(nil), (*FloatingPoolStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_FloatingPoolStatus_To_v1alpha1_FloatingPoolStatus(a.(*openstack.FloatingPoolStatus), b.(*FloatingPoolStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InfrastructureConfig)(nil), (*openstack.InfrastructureConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_InfrastructureConfig_To_openstack_InfrastructureConfig(a.(*InfrastructureConfig), b.(*openstack.InfrastructureConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.InfrastructureConfig)(nil), (*InfrastructureConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_InfrastructureConfig_To_v1alpha1_InfrastructureConfig(a.(*openstack.InfrastructureConfig), b.(*InfrastructureConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InfrastructureStatus)(nil), (*openstack.InfrastructureStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_InfrastructureStatus_To_openstack_InfrastructureStatus(a.(*InfrastructureStatus), b.(*openstack.InfrastructureStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.InfrastructureStatus)(nil), (*InfrastructureStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_InfrastructureStatus_To_v1alpha1_InfrastructureStatus(a.(*openstack.InfrastructureStatus), b.(*InfrastructureStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KeyStoneURL)(nil), (*openstack.KeyStoneURL)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KeyStoneURL_To_openstack_KeyStoneURL(a.(*KeyStoneURL), b.(*openstack.KeyStoneURL), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.KeyStoneURL)(nil), (*KeyStoneURL)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_KeyStoneURL_To_v1alpha1_KeyStoneURL(a.(*openstack.KeyStoneURL), b.(*KeyStoneURL), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LoadBalancerClass)(nil), (*openstack.LoadBalancerClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LoadBalancerClass_To_openstack_LoadBalancerClass(a.(*LoadBalancerClass), b.(*openstack.LoadBalancerClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.LoadBalancerClass)(nil), (*LoadBalancerClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_LoadBalancerClass_To_v1alpha1_LoadBalancerClass(a.(*openstack.LoadBalancerClass), b.(*LoadBalancerClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LoadBalancerProvider)(nil), (*openstack.LoadBalancerProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LoadBalancerProvider_To_openstack_LoadBalancerProvider(a.(*LoadBalancerProvider), b.(*openstack.LoadBalancerProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.LoadBalancerProvider)(nil), (*LoadBalancerProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_LoadBalancerProvider_To_v1alpha1_LoadBalancerProvider(a.(*openstack.LoadBalancerProvider), b.(*LoadBalancerProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineImage)(nil), (*openstack.MachineImage)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MachineImage_To_openstack_MachineImage(a.(*MachineImage), b.(*openstack.MachineImage), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.MachineImage)(nil), (*MachineImage)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_MachineImage_To_v1alpha1_MachineImage(a.(*openstack.MachineImage), b.(*MachineImage), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineImageVersion)(nil), (*openstack.MachineImageVersion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MachineImageVersion_To_openstack_MachineImageVersion(a.(*MachineImageVersion), b.(*openstack.MachineImageVersion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.MachineImageVersion)(nil), (*MachineImageVersion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_MachineImageVersion_To_v1alpha1_MachineImageVersion(a.(*openstack.MachineImageVersion), b.(*MachineImageVersion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineImages)(nil), (*openstack.MachineImages)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MachineImages_To_openstack_MachineImages(a.(*MachineImages), b.(*openstack.MachineImages), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.MachineImages)(nil), (*MachineImages)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_MachineImages_To_v1alpha1_MachineImages(a.(*openstack.MachineImages), b.(*MachineImages), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NetworkStatus)(nil), (*openstack.NetworkStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_NetworkStatus_To_openstack_NetworkStatus(a.(*NetworkStatus), b.(*openstack.NetworkStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.NetworkStatus)(nil), (*NetworkStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_NetworkStatus_To_v1alpha1_NetworkStatus(a.(*openstack.NetworkStatus), b.(*NetworkStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Networks)(nil), (*openstack.Networks)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Networks_To_openstack_Networks(a.(*Networks), b.(*openstack.Networks), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.Networks)(nil), (*Networks)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_Networks_To_v1alpha1_Networks(a.(*openstack.Networks), b.(*Networks), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NodeStatus)(nil), (*openstack.NodeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_NodeStatus_To_openstack_NodeStatus(a.(*NodeStatus), b.(*openstack.NodeStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.NodeStatus)(nil), (*NodeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_NodeStatus_To_v1alpha1_NodeStatus(a.(*openstack.NodeStatus), b.(*NodeStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*RegionIDMapping)(nil), (*openstack.RegionIDMapping)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_RegionIDMapping_To_openstack_RegionIDMapping(a.(*RegionIDMapping), b.(*openstack.RegionIDMapping), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.RegionIDMapping)(nil), (*RegionIDMapping)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_RegionIDMapping_To_v1alpha1_RegionIDMapping(a.(*openstack.RegionIDMapping), b.(*RegionIDMapping), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Router)(nil), (*openstack.Router)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Router_To_openstack_Router(a.(*Router), b.(*openstack.Router), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.Router)(nil), (*Router)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_Router_To_v1alpha1_Router(a.(*openstack.Router), b.(*Router), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*RouterStatus)(nil), (*openstack.RouterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_RouterStatus_To_openstack_RouterStatus(a.(*RouterStatus), b.(*openstack.RouterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.RouterStatus)(nil), (*RouterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_RouterStatus_To_v1alpha1_RouterStatus(a.(*openstack.RouterStatus), b.(*RouterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SecurityGroup)(nil), (*openstack.SecurityGroup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SecurityGroup_To_openstack_SecurityGroup(a.(*SecurityGroup), b.(*openstack.SecurityGroup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.SecurityGroup)(nil), (*SecurityGroup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_SecurityGroup_To_v1alpha1_SecurityGroup(a.(*openstack.SecurityGroup), b.(*SecurityGroup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ServerGroup)(nil), (*openstack.ServerGroup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ServerGroup_To_openstack_ServerGroup(a.(*ServerGroup), b.(*openstack.ServerGroup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.ServerGroup)(nil), (*ServerGroup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_ServerGroup_To_v1alpha1_ServerGroup(a.(*openstack.ServerGroup), b.(*ServerGroup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ServerGroupDependency)(nil), (*openstack.ServerGroupDependency)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ServerGroupDependency_To_openstack_ServerGroupDependency(a.(*ServerGroupDependency), b.(*openstack.ServerGroupDependency), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.ServerGroupDependency)(nil), (*ServerGroupDependency)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_ServerGroupDependency_To_v1alpha1_ServerGroupDependency(a.(*openstack.ServerGroupDependency), b.(*ServerGroupDependency), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Subnet)(nil), (*openstack.Subnet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Subnet_To_openstack_Subnet(a.(*Subnet), b.(*openstack.Subnet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.Subnet)(nil), (*Subnet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_Subnet_To_v1alpha1_Subnet(a.(*openstack.Subnet), b.(*Subnet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkerConfig)(nil), (*openstack.WorkerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkerConfig_To_openstack_WorkerConfig(a.(*WorkerConfig), b.(*openstack.WorkerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.WorkerConfig)(nil), (*WorkerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_WorkerConfig_To_v1alpha1_WorkerConfig(a.(*openstack.WorkerConfig), b.(*WorkerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkerStatus)(nil), (*openstack.WorkerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkerStatus_To_openstack_WorkerStatus(a.(*WorkerStatus), b.(*openstack.WorkerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*openstack.WorkerStatus)(nil), (*WorkerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_openstack_WorkerStatus_To_v1alpha1_WorkerStatus(a.(*openstack.WorkerStatus), b.(*WorkerStatus), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_CloudControllerManagerConfig_To_openstack_CloudControllerManagerConfig(in *CloudControllerManagerConfig, out *openstack.CloudControllerManagerConfig, s conversion.Scope) error {
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	return nil
}

// Convert_v1alpha1_CloudControllerManagerConfig_To_openstack_CloudControllerManagerConfig is an autogenerated conversion function.
func Convert_v1alpha1_CloudControllerManagerConfig_To_openstack_CloudControllerManagerConfig(in *CloudControllerManagerConfig, out *openstack.CloudControllerManagerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_CloudControllerManagerConfig_To_openstack_CloudControllerManagerConfig(in, out, s)
}

func autoConvert_openstack_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig(in *openstack.CloudControllerManagerConfig, out *CloudControllerManagerConfig, s conversion.Scope) error {
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	return nil
}

// Convert_openstack_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig is an autogenerated conversion function.
func Convert_openstack_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig(in *openstack.CloudControllerManagerConfig, out *CloudControllerManagerConfig, s conversion.Scope) error {
	return autoConvert_openstack_CloudControllerManagerConfig_To_v1alpha1_CloudControllerManagerConfig(in, out, s)
}

func autoConvert_v1alpha1_CloudProfileConfig_To_openstack_CloudProfileConfig(in *CloudProfileConfig, out *openstack.CloudProfileConfig, s conversion.Scope) error {
	if err := Convert_v1alpha1_Constraints_To_openstack_Constraints(&in.Constraints, &out.Constraints, s); err != nil {
		return err
	}
	out.DNSServers = *(*[]string)(unsafe.Pointer(&in.DNSServers))
	out.DHCPDomain = (*string)(unsafe.Pointer(in.DHCPDomain))
	out.KeyStoneURL = in.KeyStoneURL
	out.KeyStoneURLs = *(*[]openstack.KeyStoneURL)(unsafe.Pointer(&in.KeyStoneURLs))
	out.MachineImages = *(*[]openstack.MachineImages)(unsafe.Pointer(&in.MachineImages))
	out.RequestTimeout = (*v1.Duration)(unsafe.Pointer(in.RequestTimeout))
	out.RescanBlockStorageOnResize = (*bool)(unsafe.Pointer(in.RescanBlockStorageOnResize))
	out.IgnoreVolumeAZ = (*bool)(unsafe.Pointer(in.IgnoreVolumeAZ))
	out.NodeVolumeAttachLimit = (*int32)(unsafe.Pointer(in.NodeVolumeAttachLimit))
	out.UseOctavia = (*bool)(unsafe.Pointer(in.UseOctavia))
	out.UseSNAT = (*bool)(unsafe.Pointer(in.UseSNAT))
	out.ServerGroupPolicies = *(*[]string)(unsafe.Pointer(&in.ServerGroupPolicies))
	out.ResolvConfOptions = *(*[]string)(unsafe.Pointer(&in.ResolvConfOptions))
	return nil
}

// Convert_v1alpha1_CloudProfileConfig_To_openstack_CloudProfileConfig is an autogenerated conversion function.
func Convert_v1alpha1_CloudProfileConfig_To_openstack_CloudProfileConfig(in *CloudProfileConfig, out *openstack.CloudProfileConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_CloudProfileConfig_To_openstack_CloudProfileConfig(in, out, s)
}

func autoConvert_openstack_CloudProfileConfig_To_v1alpha1_CloudProfileConfig(in *openstack.CloudProfileConfig, out *CloudProfileConfig, s conversion.Scope) error {
	if err := Convert_openstack_Constraints_To_v1alpha1_Constraints(&in.Constraints, &out.Constraints, s); err != nil {
		return err
	}
	out.DNSServers = *(*[]string)(unsafe.Pointer(&in.DNSServers))
	out.DHCPDomain = (*string)(unsafe.Pointer(in.DHCPDomain))
	out.KeyStoneURL = in.KeyStoneURL
	out.KeyStoneURLs = *(*[]KeyStoneURL)(unsafe.Pointer(&in.KeyStoneURLs))
	out.MachineImages = *(*[]MachineImages)(unsafe.Pointer(&in.MachineImages))
	out.RequestTimeout = (*v1.Duration)(unsafe.Pointer(in.RequestTimeout))
	out.RescanBlockStorageOnResize = (*bool)(unsafe.Pointer(in.RescanBlockStorageOnResize))
	out.IgnoreVolumeAZ = (*bool)(unsafe.Pointer(in.IgnoreVolumeAZ))
	out.NodeVolumeAttachLimit = (*int32)(unsafe.Pointer(in.NodeVolumeAttachLimit))
	out.UseOctavia = (*bool)(unsafe.Pointer(in.UseOctavia))
	out.UseSNAT = (*bool)(unsafe.Pointer(in.UseSNAT))
	out.ServerGroupPolicies = *(*[]string)(unsafe.Pointer(&in.ServerGroupPolicies))
	out.ResolvConfOptions = *(*[]string)(unsafe.Pointer(&in.ResolvConfOptions))
	return nil
}

// Convert_openstack_CloudProfileConfig_To_v1alpha1_CloudProfileConfig is an autogenerated conversion function.
func Convert_openstack_CloudProfileConfig_To_v1alpha1_CloudProfileConfig(in *openstack.CloudProfileConfig, out *CloudProfileConfig, s conversion.Scope) error {
	return autoConvert_openstack_CloudProfileConfig_To_v1alpha1_CloudProfileConfig(in, out, s)
}

func autoConvert_v1alpha1_Constraints_To_openstack_Constraints(in *Constraints, out *openstack.Constraints, s conversion.Scope) error {
	out.FloatingPools = *(*[]openstack.FloatingPool)(unsafe.Pointer(&in.FloatingPools))
	out.LoadBalancerProviders = *(*[]openstack.LoadBalancerProvider)(unsafe.Pointer(&in.LoadBalancerProviders))
	return nil
}

// Convert_v1alpha1_Constraints_To_openstack_Constraints is an autogenerated conversion function.
func Convert_v1alpha1_Constraints_To_openstack_Constraints(in *Constraints, out *openstack.Constraints, s conversion.Scope) error {
	return autoConvert_v1alpha1_Constraints_To_openstack_Constraints(in, out, s)
}

func autoConvert_openstack_Constraints_To_v1alpha1_Constraints(in *openstack.Constraints, out *Constraints, s conversion.Scope) error {
	out.FloatingPools = *(*[]FloatingPool)(unsafe.Pointer(&in.FloatingPools))
	out.LoadBalancerProviders = *(*[]LoadBalancerProvider)(unsafe.Pointer(&in.LoadBalancerProviders))
	return nil
}

// Convert_openstack_Constraints_To_v1alpha1_Constraints is an autogenerated conversion function.
func Convert_openstack_Constraints_To_v1alpha1_Constraints(in *openstack.Constraints, out *Constraints, s conversion.Scope) error {
	return autoConvert_openstack_Constraints_To_v1alpha1_Constraints(in, out, s)
}

func autoConvert_v1alpha1_ControlPlaneConfig_To_openstack_ControlPlaneConfig(in *ControlPlaneConfig, out *openstack.ControlPlaneConfig, s conversion.Scope) error {
	out.CloudControllerManager = (*openstack.CloudControllerManagerConfig)(unsafe.Pointer(in.CloudControllerManager))
	out.LoadBalancerClasses = *(*[]openstack.LoadBalancerClass)(unsafe.Pointer(&in.LoadBalancerClasses))
	out.LoadBalancerProvider = in.LoadBalancerProvider
	out.Zone = (*string)(unsafe.Pointer(in.Zone))
	return nil
}

// Convert_v1alpha1_ControlPlaneConfig_To_openstack_ControlPlaneConfig is an autogenerated conversion function.
func Convert_v1alpha1_ControlPlaneConfig_To_openstack_ControlPlaneConfig(in *ControlPlaneConfig, out *openstack.ControlPlaneConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControlPlaneConfig_To_openstack_ControlPlaneConfig(in, out, s)
}

func autoConvert_openstack_ControlPlaneConfig_To_v1alpha1_ControlPlaneConfig(in *openstack.ControlPlaneConfig, out *ControlPlaneConfig, s conversion.Scope) error {
	out.CloudControllerManager = (*CloudControllerManagerConfig)(unsafe.Pointer(in.CloudControllerManager))
	out.LoadBalancerClasses = *(*[]LoadBalancerClass)(unsafe.Pointer(&in.LoadBalancerClasses))
	out.LoadBalancerProvider = in.LoadBalancerProvider
	out.Zone = (*string)(unsafe.Pointer(in.Zone))
	return nil
}

// Convert_openstack_ControlPlaneConfig_To_v1alpha1_ControlPlaneConfig is an autogenerated conversion function.
func Convert_openstack_ControlPlaneConfig_To_v1alpha1_ControlPlaneConfig(in *openstack.ControlPlaneConfig, out *ControlPlaneConfig, s conversion.Scope) error {
	return autoConvert_openstack_ControlPlaneConfig_To_v1alpha1_ControlPlaneConfig(in, out, s)
}

func autoConvert_v1alpha1_FloatingPool_To_openstack_FloatingPool(in *FloatingPool, out *openstack.FloatingPool, s conversion.Scope) error {
	out.Name = in.Name
	out.Region = (*string)(unsafe.Pointer(in.Region))
	out.Domain = (*string)(unsafe.Pointer(in.Domain))
	out.DefaultFloatingSubnet = (*string)(unsafe.Pointer(in.DefaultFloatingSubnet))
	out.NonConstraining = (*bool)(unsafe.Pointer(in.NonConstraining))
	out.LoadBalancerClasses = *(*[]openstack.LoadBalancerClass)(unsafe.Pointer(&in.LoadBalancerClasses))
	return nil
}

// Convert_v1alpha1_FloatingPool_To_openstack_FloatingPool is an autogenerated conversion function.
func Convert_v1alpha1_FloatingPool_To_openstack_FloatingPool(in *FloatingPool, out *openstack.FloatingPool, s conversion.Scope) error {
	return autoConvert_v1alpha1_FloatingPool_To_openstack_FloatingPool(in, out, s)
}

func autoConvert_openstack_FloatingPool_To_v1alpha1_FloatingPool(in *openstack.FloatingPool, out *FloatingPool, s conversion.Scope) error {
	out.Name = in.Name
	out.Region = (*string)(unsafe.Pointer(in.Region))
	out.Domain = (*string)(unsafe.Pointer(in.Domain))
	out.DefaultFloatingSubnet = (*string)(unsafe.Pointer(in.DefaultFloatingSubnet))
	out.NonConstraining = (*bool)(unsafe.Pointer(in.NonConstraining))
	out.LoadBalancerClasses = *(*[]LoadBalancerClass)(unsafe.Pointer(&in.LoadBalancerClasses))
	return nil
}

// Convert_openstack_FloatingPool_To_v1alpha1_FloatingPool is an autogenerated conversion function.
func Convert_openstack_FloatingPool_To_v1alpha1_FloatingPool(in *openstack.FloatingPool, out *FloatingPool, s conversion.Scope) error {
	return autoConvert_openstack_FloatingPool_To_v1alpha1_FloatingPool(in, out, s)
}

func autoConvert_v1alpha1_FloatingPoolStatus_To_openstack_FloatingPoolStatus(in *FloatingPoolStatus, out *openstack.FloatingPoolStatus, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	return nil
}

// Convert_v1alpha1_FloatingPoolStatus_To_openstack_FloatingPoolStatus is an autogenerated conversion function.
func Convert_v1alpha1_FloatingPoolStatus_To_openstack_FloatingPoolStatus(in *FloatingPoolStatus, out *openstack.FloatingPoolStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_FloatingPoolStatus_To_openstack_FloatingPoolStatus(in, out, s)
}

func autoConvert_openstack_FloatingPoolStatus_To_v1alpha1_FloatingPoolStatus(in *openstack.FloatingPoolStatus, out *FloatingPoolStatus, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	return nil
}

// Convert_openstack_FloatingPoolStatus_To_v1alpha1_FloatingPoolStatus is an autogenerated conversion function.
func Convert_openstack_FloatingPoolStatus_To_v1alpha1_FloatingPoolStatus(in *openstack.FloatingPoolStatus, out *FloatingPoolStatus, s conversion.Scope) error {
	return autoConvert_openstack_FloatingPoolStatus_To_v1alpha1_FloatingPoolStatus(in, out, s)
}

func autoConvert_v1alpha1_InfrastructureConfig_To_openstack_InfrastructureConfig(in *InfrastructureConfig, out *openstack.InfrastructureConfig, s conversion.Scope) error {
	out.FloatingPoolName = in.FloatingPoolName
	out.FloatingPoolSubnetName = (*string)(unsafe.Pointer(in.FloatingPoolSubnetName))
	if err := Convert_v1alpha1_Networks_To_openstack_Networks(&in.Networks, &out.Networks, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_InfrastructureConfig_To_openstack_InfrastructureConfig is an autogenerated conversion function.
func Convert_v1alpha1_InfrastructureConfig_To_openstack_InfrastructureConfig(in *InfrastructureConfig, out *openstack.InfrastructureConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_InfrastructureConfig_To_openstack_InfrastructureConfig(in, out, s)
}

func autoConvert_openstack_InfrastructureConfig_To_v1alpha1_InfrastructureConfig(in *openstack.InfrastructureConfig, out *InfrastructureConfig, s conversion.Scope) error {
	out.FloatingPoolName = in.FloatingPoolName
	out.FloatingPoolSubnetName = (*string)(unsafe.Pointer(in.FloatingPoolSubnetName))
	if err := Convert_openstack_Networks_To_v1alpha1_Networks(&in.Networks, &out.Networks, s); err != nil {
		return err
	}
	return nil
}

// Convert_openstack_InfrastructureConfig_To_v1alpha1_InfrastructureConfig is an autogenerated conversion function.
func Convert_openstack_InfrastructureConfig_To_v1alpha1_InfrastructureConfig(in *openstack.InfrastructureConfig, out *InfrastructureConfig, s conversion.Scope) error {
	return autoConvert_openstack_InfrastructureConfig_To_v1alpha1_InfrastructureConfig(in, out, s)
}

func autoConvert_v1alpha1_InfrastructureStatus_To_openstack_InfrastructureStatus(in *InfrastructureStatus, out *openstack.InfrastructureStatus, s conversion.Scope) error {
	if err := Convert_v1alpha1_NetworkStatus_To_openstack_NetworkStatus(&in.Networks, &out.Networks, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_NodeStatus_To_openstack_NodeStatus(&in.Node, &out.Node, s); err != nil {
		return err
	}
	out.SecurityGroups = *(*[]openstack.SecurityGroup)(unsafe.Pointer(&in.SecurityGroups))
	return nil
}

// Convert_v1alpha1_InfrastructureStatus_To_openstack_InfrastructureStatus is an autogenerated conversion function.
func Convert_v1alpha1_InfrastructureStatus_To_openstack_InfrastructureStatus(in *InfrastructureStatus, out *openstack.InfrastructureStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_InfrastructureStatus_To_openstack_InfrastructureStatus(in, out, s)
}

func autoConvert_openstack_InfrastructureStatus_To_v1alpha1_InfrastructureStatus(in *openstack.InfrastructureStatus, out *InfrastructureStatus, s conversion.Scope) error {
	if err := Convert_openstack_NetworkStatus_To_v1alpha1_NetworkStatus(&in.Networks, &out.Networks, s); err != nil {
		return err
	}
	if err := Convert_openstack_NodeStatus_To_v1alpha1_NodeStatus(&in.Node, &out.Node, s); err != nil {
		return err
	}
	out.SecurityGroups = *(*[]SecurityGroup)(unsafe.Pointer(&in.SecurityGroups))
	return nil
}

// Convert_openstack_InfrastructureStatus_To_v1alpha1_InfrastructureStatus is an autogenerated conversion function.
func Convert_openstack_InfrastructureStatus_To_v1alpha1_InfrastructureStatus(in *openstack.InfrastructureStatus, out *InfrastructureStatus, s conversion.Scope) error {
	return autoConvert_openstack_InfrastructureStatus_To_v1alpha1_InfrastructureStatus(in, out, s)
}

func autoConvert_v1alpha1_KeyStoneURL_To_openstack_KeyStoneURL(in *KeyStoneURL, out *openstack.KeyStoneURL, s conversion.Scope) error {
	out.Region = in.Region
	out.URL = in.URL
	return nil
}

// Convert_v1alpha1_KeyStoneURL_To_openstack_KeyStoneURL is an autogenerated conversion function.
func Convert_v1alpha1_KeyStoneURL_To_openstack_KeyStoneURL(in *KeyStoneURL, out *openstack.KeyStoneURL, s conversion.Scope) error {
	return autoConvert_v1alpha1_KeyStoneURL_To_openstack_KeyStoneURL(in, out, s)
}

func autoConvert_openstack_KeyStoneURL_To_v1alpha1_KeyStoneURL(in *openstack.KeyStoneURL, out *KeyStoneURL, s conversion.Scope) error {
	out.Region = in.Region
	out.URL = in.URL
	return nil
}

// Convert_openstack_KeyStoneURL_To_v1alpha1_KeyStoneURL is an autogenerated conversion function.
func Convert_openstack_KeyStoneURL_To_v1alpha1_KeyStoneURL(in *openstack.KeyStoneURL, out *KeyStoneURL, s conversion.Scope) error {
	return autoConvert_openstack_KeyStoneURL_To_v1alpha1_KeyStoneURL(in, out, s)
}

func autoConvert_v1alpha1_LoadBalancerClass_To_openstack_LoadBalancerClass(in *LoadBalancerClass, out *openstack.LoadBalancerClass, s conversion.Scope) error {
	out.Name = in.Name
	out.Purpose = (*string)(unsafe.Pointer(in.Purpose))
	out.FloatingSubnetID = (*string)(unsafe.Pointer(in.FloatingSubnetID))
	out.FloatingSubnetTags = (*string)(unsafe.Pointer(in.FloatingSubnetTags))
	out.FloatingSubnetName = (*string)(unsafe.Pointer(in.FloatingSubnetName))
	out.FloatingNetworkID = (*string)(unsafe.Pointer(in.FloatingNetworkID))
	out.SubnetID = (*string)(unsafe.Pointer(in.SubnetID))
	return nil
}

// Convert_v1alpha1_LoadBalancerClass_To_openstack_LoadBalancerClass is an autogenerated conversion function.
func Convert_v1alpha1_LoadBalancerClass_To_openstack_LoadBalancerClass(in *LoadBalancerClass, out *openstack.LoadBalancerClass, s conversion.Scope) error {
	return autoConvert_v1alpha1_LoadBalancerClass_To_openstack_LoadBalancerClass(in, out, s)
}

func autoConvert_openstack_LoadBalancerClass_To_v1alpha1_LoadBalancerClass(in *openstack.LoadBalancerClass, out *LoadBalancerClass, s conversion.Scope) error {
	out.Name = in.Name
	out.Purpose = (*string)(unsafe.Pointer(in.Purpose))
	out.FloatingSubnetID = (*string)(unsafe.Pointer(in.FloatingSubnetID))
	out.FloatingSubnetTags = (*string)(unsafe.Pointer(in.FloatingSubnetTags))
	out.FloatingSubnetName = (*string)(unsafe.Pointer(in.FloatingSubnetName))
	out.FloatingNetworkID = (*string)(unsafe.Pointer(in.FloatingNetworkID))
	out.SubnetID = (*string)(unsafe.Pointer(in.SubnetID))
	return nil
}

// Convert_openstack_LoadBalancerClass_To_v1alpha1_LoadBalancerClass is an autogenerated conversion function.
func Convert_openstack_LoadBalancerClass_To_v1alpha1_LoadBalancerClass(in *openstack.LoadBalancerClass, out *LoadBalancerClass, s conversion.Scope) error {
	return autoConvert_openstack_LoadBalancerClass_To_v1alpha1_LoadBalancerClass(in, out, s)
}

func autoConvert_v1alpha1_LoadBalancerProvider_To_openstack_LoadBalancerProvider(in *LoadBalancerProvider, out *openstack.LoadBalancerProvider, s conversion.Scope) error {
	out.Name = in.Name
	out.Region = (*string)(unsafe.Pointer(in.Region))
	return nil
}

// Convert_v1alpha1_LoadBalancerProvider_To_openstack_LoadBalancerProvider is an autogenerated conversion function.
func Convert_v1alpha1_LoadBalancerProvider_To_openstack_LoadBalancerProvider(in *LoadBalancerProvider, out *openstack.LoadBalancerProvider, s conversion.Scope) error {
	return autoConvert_v1alpha1_LoadBalancerProvider_To_openstack_LoadBalancerProvider(in, out, s)
}

func autoConvert_openstack_LoadBalancerProvider_To_v1alpha1_LoadBalancerProvider(in *openstack.LoadBalancerProvider, out *LoadBalancerProvider, s conversion.Scope) error {
	out.Name = in.Name
	out.Region = (*string)(unsafe.Pointer(in.Region))
	return nil
}

// Convert_openstack_LoadBalancerProvider_To_v1alpha1_LoadBalancerProvider is an autogenerated conversion function.
func Convert_openstack_LoadBalancerProvider_To_v1alpha1_LoadBalancerProvider(in *openstack.LoadBalancerProvider, out *LoadBalancerProvider, s conversion.Scope) error {
	return autoConvert_openstack_LoadBalancerProvider_To_v1alpha1_LoadBalancerProvider(in, out, s)
}

func autoConvert_v1alpha1_MachineImage_To_openstack_MachineImage(in *MachineImage, out *openstack.MachineImage, s conversion.Scope) error {
	out.Name = in.Name
	out.Version = in.Version
	out.Image = in.Image
	out.ID = in.ID
	return nil
}

// Convert_v1alpha1_MachineImage_To_openstack_MachineImage is an autogenerated conversion function.
func Convert_v1alpha1_MachineImage_To_openstack_MachineImage(in *MachineImage, out *openstack.MachineImage, s conversion.Scope) error {
	return autoConvert_v1alpha1_MachineImage_To_openstack_MachineImage(in, out, s)
}

func autoConvert_openstack_MachineImage_To_v1alpha1_MachineImage(in *openstack.MachineImage, out *MachineImage, s conversion.Scope) error {
	out.Name = in.Name
	out.Version = in.Version
	out.Image = in.Image
	out.ID = in.ID
	return nil
}

// Convert_openstack_MachineImage_To_v1alpha1_MachineImage is an autogenerated conversion function.
func Convert_openstack_MachineImage_To_v1alpha1_MachineImage(in *openstack.MachineImage, out *MachineImage, s conversion.Scope) error {
	return autoConvert_openstack_MachineImage_To_v1alpha1_MachineImage(in, out, s)
}

func autoConvert_v1alpha1_MachineImageVersion_To_openstack_MachineImageVersion(in *MachineImageVersion, out *openstack.MachineImageVersion, s conversion.Scope) error {
	out.Version = in.Version
	out.Image = in.Image
	out.Regions = *(*[]openstack.RegionIDMapping)(unsafe.Pointer(&in.Regions))
	return nil
}

// Convert_v1alpha1_MachineImageVersion_To_openstack_MachineImageVersion is an autogenerated conversion function.
func Convert_v1alpha1_MachineImageVersion_To_openstack_MachineImageVersion(in *MachineImageVersion, out *openstack.MachineImageVersion, s conversion.Scope) error {
	return autoConvert_v1alpha1_MachineImageVersion_To_openstack_MachineImageVersion(in, out, s)
}

func autoConvert_openstack_MachineImageVersion_To_v1alpha1_MachineImageVersion(in *openstack.MachineImageVersion, out *MachineImageVersion, s conversion.Scope) error {
	out.Version = in.Version
	out.Image = in.Image
	out.Regions = *(*[]RegionIDMapping)(unsafe.Pointer(&in.Regions))
	return nil
}

// Convert_openstack_MachineImageVersion_To_v1alpha1_MachineImageVersion is an autogenerated conversion function.
func Convert_openstack_MachineImageVersion_To_v1alpha1_MachineImageVersion(in *openstack.MachineImageVersion, out *MachineImageVersion, s conversion.Scope) error {
	return autoConvert_openstack_MachineImageVersion_To_v1alpha1_MachineImageVersion(in, out, s)
}

func autoConvert_v1alpha1_MachineImages_To_openstack_MachineImages(in *MachineImages, out *openstack.MachineImages, s conversion.Scope) error {
	out.Name = in.Name
	out.Versions = *(*[]openstack.MachineImageVersion)(unsafe.Pointer(&in.Versions))
	return nil
}

// Convert_v1alpha1_MachineImages_To_openstack_MachineImages is an autogenerated conversion function.
func Convert_v1alpha1_MachineImages_To_openstack_MachineImages(in *MachineImages, out *openstack.MachineImages, s conversion.Scope) error {
	return autoConvert_v1alpha1_MachineImages_To_openstack_MachineImages(in, out, s)
}

func autoConvert_openstack_MachineImages_To_v1alpha1_MachineImages(in *openstack.MachineImages, out *MachineImages, s conversion.Scope) error {
	out.Name = in.Name
	out.Versions = *(*[]MachineImageVersion)(unsafe.Pointer(&in.Versions))
	return nil
}

// Convert_openstack_MachineImages_To_v1alpha1_MachineImages is an autogenerated conversion function.
func Convert_openstack_MachineImages_To_v1alpha1_MachineImages(in *openstack.MachineImages, out *MachineImages, s conversion.Scope) error {
	return autoConvert_openstack_MachineImages_To_v1alpha1_MachineImages(in, out, s)
}

func autoConvert_v1alpha1_NetworkStatus_To_openstack_NetworkStatus(in *NetworkStatus, out *openstack.NetworkStatus, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	if err := Convert_v1alpha1_FloatingPoolStatus_To_openstack_FloatingPoolStatus(&in.FloatingPool, &out.FloatingPool, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_RouterStatus_To_openstack_RouterStatus(&in.Router, &out.Router, s); err != nil {
		return err
	}
	out.Subnets = *(*[]openstack.Subnet)(unsafe.Pointer(&in.Subnets))
	return nil
}

// Convert_v1alpha1_NetworkStatus_To_openstack_NetworkStatus is an autogenerated conversion function.
func Convert_v1alpha1_NetworkStatus_To_openstack_NetworkStatus(in *NetworkStatus, out *openstack.NetworkStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_NetworkStatus_To_openstack_NetworkStatus(in, out, s)
}

func autoConvert_openstack_NetworkStatus_To_v1alpha1_NetworkStatus(in *openstack.NetworkStatus, out *NetworkStatus, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	if err := Convert_openstack_FloatingPoolStatus_To_v1alpha1_FloatingPoolStatus(&in.FloatingPool, &out.FloatingPool, s); err != nil {
		return err
	}
	if err := Convert_openstack_RouterStatus_To_v1alpha1_RouterStatus(&in.Router, &out.Router, s); err != nil {
		return err
	}
	out.Subnets = *(*[]Subnet)(unsafe.Pointer(&in.Subnets))
	return nil
}

// Convert_openstack_NetworkStatus_To_v1alpha1_NetworkStatus is an autogenerated conversion function.
func Convert_openstack_NetworkStatus_To_v1alpha1_NetworkStatus(in *openstack.NetworkStatus, out *NetworkStatus, s conversion.Scope) error {
	return autoConvert_openstack_NetworkStatus_To_v1alpha1_NetworkStatus(in, out, s)
}

func autoConvert_v1alpha1_Networks_To_openstack_Networks(in *Networks, out *openstack.Networks, s conversion.Scope) error {
	out.Router = (*openstack.Router)(unsafe.Pointer(in.Router))
	out.Worker = in.Worker
	out.Workers = in.Workers
	out.ID = (*string)(unsafe.Pointer(in.ID))
	return nil
}

// Convert_v1alpha1_Networks_To_openstack_Networks is an autogenerated conversion function.
func Convert_v1alpha1_Networks_To_openstack_Networks(in *Networks, out *openstack.Networks, s conversion.Scope) error {
	return autoConvert_v1alpha1_Networks_To_openstack_Networks(in, out, s)
}

func autoConvert_openstack_Networks_To_v1alpha1_Networks(in *openstack.Networks, out *Networks, s conversion.Scope) error {
	out.Router = (*Router)(unsafe.Pointer(in.Router))
	out.Worker = in.Worker
	out.Workers = in.Workers
	out.ID = (*string)(unsafe.Pointer(in.ID))
	return nil
}

// Convert_openstack_Networks_To_v1alpha1_Networks is an autogenerated conversion function.
func Convert_openstack_Networks_To_v1alpha1_Networks(in *openstack.Networks, out *Networks, s conversion.Scope) error {
	return autoConvert_openstack_Networks_To_v1alpha1_Networks(in, out, s)
}

func autoConvert_v1alpha1_NodeStatus_To_openstack_NodeStatus(in *NodeStatus, out *openstack.NodeStatus, s conversion.Scope) error {
	out.KeyName = in.KeyName
	return nil
}

// Convert_v1alpha1_NodeStatus_To_openstack_NodeStatus is an autogenerated conversion function.
func Convert_v1alpha1_NodeStatus_To_openstack_NodeStatus(in *NodeStatus, out *openstack.NodeStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_NodeStatus_To_openstack_NodeStatus(in, out, s)
}

func autoConvert_openstack_NodeStatus_To_v1alpha1_NodeStatus(in *openstack.NodeStatus, out *NodeStatus, s conversion.Scope) error {
	out.KeyName = in.KeyName
	return nil
}

// Convert_openstack_NodeStatus_To_v1alpha1_NodeStatus is an autogenerated conversion function.
func Convert_openstack_NodeStatus_To_v1alpha1_NodeStatus(in *openstack.NodeStatus, out *NodeStatus, s conversion.Scope) error {
	return autoConvert_openstack_NodeStatus_To_v1alpha1_NodeStatus(in, out, s)
}

func autoConvert_v1alpha1_RegionIDMapping_To_openstack_RegionIDMapping(in *RegionIDMapping, out *openstack.RegionIDMapping, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	return nil
}

// Convert_v1alpha1_RegionIDMapping_To_openstack_RegionIDMapping is an autogenerated conversion function.
func Convert_v1alpha1_RegionIDMapping_To_openstack_RegionIDMapping(in *RegionIDMapping, out *openstack.RegionIDMapping, s conversion.Scope) error {
	return autoConvert_v1alpha1_RegionIDMapping_To_openstack_RegionIDMapping(in, out, s)
}

func autoConvert_openstack_RegionIDMapping_To_v1alpha1_RegionIDMapping(in *openstack.RegionIDMapping, out *RegionIDMapping, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	return nil
}

// Convert_openstack_RegionIDMapping_To_v1alpha1_RegionIDMapping is an autogenerated conversion function.
func Convert_openstack_RegionIDMapping_To_v1alpha1_RegionIDMapping(in *openstack.RegionIDMapping, out *RegionIDMapping, s conversion.Scope) error {
	return autoConvert_openstack_RegionIDMapping_To_v1alpha1_RegionIDMapping(in, out, s)
}

func autoConvert_v1alpha1_Router_To_openstack_Router(in *Router, out *openstack.Router, s conversion.Scope) error {
	out.ID = in.ID
	return nil
}

// Convert_v1alpha1_Router_To_openstack_Router is an autogenerated conversion function.
func Convert_v1alpha1_Router_To_openstack_Router(in *Router, out *openstack.Router, s conversion.Scope) error {
	return autoConvert_v1alpha1_Router_To_openstack_Router(in, out, s)
}

func autoConvert_openstack_Router_To_v1alpha1_Router(in *openstack.Router, out *Router, s conversion.Scope) error {
	out.ID = in.ID
	return nil
}

// Convert_openstack_Router_To_v1alpha1_Router is an autogenerated conversion function.
func Convert_openstack_Router_To_v1alpha1_Router(in *openstack.Router, out *Router, s conversion.Scope) error {
	return autoConvert_openstack_Router_To_v1alpha1_Router(in, out, s)
}

func autoConvert_v1alpha1_RouterStatus_To_openstack_RouterStatus(in *RouterStatus, out *openstack.RouterStatus, s conversion.Scope) error {
	out.ID = in.ID
	return nil
}

// Convert_v1alpha1_RouterStatus_To_openstack_RouterStatus is an autogenerated conversion function.
func Convert_v1alpha1_RouterStatus_To_openstack_RouterStatus(in *RouterStatus, out *openstack.RouterStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_RouterStatus_To_openstack_RouterStatus(in, out, s)
}

func autoConvert_openstack_RouterStatus_To_v1alpha1_RouterStatus(in *openstack.RouterStatus, out *RouterStatus, s conversion.Scope) error {
	out.ID = in.ID
	return nil
}

// Convert_openstack_RouterStatus_To_v1alpha1_RouterStatus is an autogenerated conversion function.
func Convert_openstack_RouterStatus_To_v1alpha1_RouterStatus(in *openstack.RouterStatus, out *RouterStatus, s conversion.Scope) error {
	return autoConvert_openstack_RouterStatus_To_v1alpha1_RouterStatus(in, out, s)
}

func autoConvert_v1alpha1_SecurityGroup_To_openstack_SecurityGroup(in *SecurityGroup, out *openstack.SecurityGroup, s conversion.Scope) error {
	out.Purpose = openstack.Purpose(in.Purpose)
	out.ID = in.ID
	out.Name = in.Name
	return nil
}

// Convert_v1alpha1_SecurityGroup_To_openstack_SecurityGroup is an autogenerated conversion function.
func Convert_v1alpha1_SecurityGroup_To_openstack_SecurityGroup(in *SecurityGroup, out *openstack.SecurityGroup, s conversion.Scope) error {
	return autoConvert_v1alpha1_SecurityGroup_To_openstack_SecurityGroup(in, out, s)
}

func autoConvert_openstack_SecurityGroup_To_v1alpha1_SecurityGroup(in *openstack.SecurityGroup, out *SecurityGroup, s conversion.Scope) error {
	out.Purpose = Purpose(in.Purpose)
	out.ID = in.ID
	out.Name = in.Name
	return nil
}

// Convert_openstack_SecurityGroup_To_v1alpha1_SecurityGroup is an autogenerated conversion function.
func Convert_openstack_SecurityGroup_To_v1alpha1_SecurityGroup(in *openstack.SecurityGroup, out *SecurityGroup, s conversion.Scope) error {
	return autoConvert_openstack_SecurityGroup_To_v1alpha1_SecurityGroup(in, out, s)
}

func autoConvert_v1alpha1_ServerGroup_To_openstack_ServerGroup(in *ServerGroup, out *openstack.ServerGroup, s conversion.Scope) error {
	out.Policy = in.Policy
	return nil
}

// Convert_v1alpha1_ServerGroup_To_openstack_ServerGroup is an autogenerated conversion function.
func Convert_v1alpha1_ServerGroup_To_openstack_ServerGroup(in *ServerGroup, out *openstack.ServerGroup, s conversion.Scope) error {
	return autoConvert_v1alpha1_ServerGroup_To_openstack_ServerGroup(in, out, s)
}

func autoConvert_openstack_ServerGroup_To_v1alpha1_ServerGroup(in *openstack.ServerGroup, out *ServerGroup, s conversion.Scope) error {
	out.Policy = in.Policy
	return nil
}

// Convert_openstack_ServerGroup_To_v1alpha1_ServerGroup is an autogenerated conversion function.
func Convert_openstack_ServerGroup_To_v1alpha1_ServerGroup(in *openstack.ServerGroup, out *ServerGroup, s conversion.Scope) error {
	return autoConvert_openstack_ServerGroup_To_v1alpha1_ServerGroup(in, out, s)
}

func autoConvert_v1alpha1_ServerGroupDependency_To_openstack_ServerGroupDependency(in *ServerGroupDependency, out *openstack.ServerGroupDependency, s conversion.Scope) error {
	out.PoolName = in.PoolName
	out.ID = in.ID
	out.Name = in.Name
	return nil
}

// Convert_v1alpha1_ServerGroupDependency_To_openstack_ServerGroupDependency is an autogenerated conversion function.
func Convert_v1alpha1_ServerGroupDependency_To_openstack_ServerGroupDependency(in *ServerGroupDependency, out *openstack.ServerGroupDependency, s conversion.Scope) error {
	return autoConvert_v1alpha1_ServerGroupDependency_To_openstack_ServerGroupDependency(in, out, s)
}

func autoConvert_openstack_ServerGroupDependency_To_v1alpha1_ServerGroupDependency(in *openstack.ServerGroupDependency, out *ServerGroupDependency, s conversion.Scope) error {
	out.PoolName = in.PoolName
	out.ID = in.ID
	out.Name = in.Name
	return nil
}

// Convert_openstack_ServerGroupDependency_To_v1alpha1_ServerGroupDependency is an autogenerated conversion function.
func Convert_openstack_ServerGroupDependency_To_v1alpha1_ServerGroupDependency(in *openstack.ServerGroupDependency, out *ServerGroupDependency, s conversion.Scope) error {
	return autoConvert_openstack_ServerGroupDependency_To_v1alpha1_ServerGroupDependency(in, out, s)
}

func autoConvert_v1alpha1_Subnet_To_openstack_Subnet(in *Subnet, out *openstack.Subnet, s conversion.Scope) error {
	out.Purpose = openstack.Purpose(in.Purpose)
	out.ID = in.ID
	return nil
}

// Convert_v1alpha1_Subnet_To_openstack_Subnet is an autogenerated conversion function.
func Convert_v1alpha1_Subnet_To_openstack_Subnet(in *Subnet, out *openstack.Subnet, s conversion.Scope) error {
	return autoConvert_v1alpha1_Subnet_To_openstack_Subnet(in, out, s)
}

func autoConvert_openstack_Subnet_To_v1alpha1_Subnet(in *openstack.Subnet, out *Subnet, s conversion.Scope) error {
	out.Purpose = Purpose(in.Purpose)
	out.ID = in.ID
	return nil
}

// Convert_openstack_Subnet_To_v1alpha1_Subnet is an autogenerated conversion function.
func Convert_openstack_Subnet_To_v1alpha1_Subnet(in *openstack.Subnet, out *Subnet, s conversion.Scope) error {
	return autoConvert_openstack_Subnet_To_v1alpha1_Subnet(in, out, s)
}

func autoConvert_v1alpha1_WorkerConfig_To_openstack_WorkerConfig(in *WorkerConfig, out *openstack.WorkerConfig, s conversion.Scope) error {
	out.ServerGroup = (*openstack.ServerGroup)(unsafe.Pointer(in.ServerGroup))
	return nil
}

// Convert_v1alpha1_WorkerConfig_To_openstack_WorkerConfig is an autogenerated conversion function.
func Convert_v1alpha1_WorkerConfig_To_openstack_WorkerConfig(in *WorkerConfig, out *openstack.WorkerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkerConfig_To_openstack_WorkerConfig(in, out, s)
}

func autoConvert_openstack_WorkerConfig_To_v1alpha1_WorkerConfig(in *openstack.WorkerConfig, out *WorkerConfig, s conversion.Scope) error {
	out.ServerGroup = (*ServerGroup)(unsafe.Pointer(in.ServerGroup))
	return nil
}

// Convert_openstack_WorkerConfig_To_v1alpha1_WorkerConfig is an autogenerated conversion function.
func Convert_openstack_WorkerConfig_To_v1alpha1_WorkerConfig(in *openstack.WorkerConfig, out *WorkerConfig, s conversion.Scope) error {
	return autoConvert_openstack_WorkerConfig_To_v1alpha1_WorkerConfig(in, out, s)
}

func autoConvert_v1alpha1_WorkerStatus_To_openstack_WorkerStatus(in *WorkerStatus, out *openstack.WorkerStatus, s conversion.Scope) error {
	out.MachineImages = *(*[]openstack.MachineImage)(unsafe.Pointer(&in.MachineImages))
	out.ServerGroupDependencies = *(*[]openstack.ServerGroupDependency)(unsafe.Pointer(&in.ServerGroupDependencies))
	return nil
}

// Convert_v1alpha1_WorkerStatus_To_openstack_WorkerStatus is an autogenerated conversion function.
func Convert_v1alpha1_WorkerStatus_To_openstack_WorkerStatus(in *WorkerStatus, out *openstack.WorkerStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkerStatus_To_openstack_WorkerStatus(in, out, s)
}

func autoConvert_openstack_WorkerStatus_To_v1alpha1_WorkerStatus(in *openstack.WorkerStatus, out *WorkerStatus, s conversion.Scope) error {
	out.MachineImages = *(*[]MachineImage)(unsafe.Pointer(&in.MachineImages))
	out.ServerGroupDependencies = *(*[]ServerGroupDependency)(unsafe.Pointer(&in.ServerGroupDependencies))
	return nil
}

// Convert_openstack_WorkerStatus_To_v1alpha1_WorkerStatus is an autogenerated conversion function.
func Convert_openstack_WorkerStatus_To_v1alpha1_WorkerStatus(in *openstack.WorkerStatus, out *WorkerStatus, s conversion.Scope) error {
	return autoConvert_openstack_WorkerStatus_To_v1alpha1_WorkerStatus(in, out, s)
}
