/*
Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/gardener/gardener/pkg/apis/settings/v1alpha1/generated.proto

package v1alpha1

import (
	fmt "fmt"

	io "io"

	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"

	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func (m *ClusterOpenIDConnectPreset) Reset()      { *m = ClusterOpenIDConnectPreset{} }
func (*ClusterOpenIDConnectPreset) ProtoMessage() {}
func (*ClusterOpenIDConnectPreset) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0cd3f80cc90ed56, []int{0}
}
func (m *ClusterOpenIDConnectPreset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterOpenIDConnectPreset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ClusterOpenIDConnectPreset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterOpenIDConnectPreset.Merge(m, src)
}
func (m *ClusterOpenIDConnectPreset) XXX_Size() int {
	return m.Size()
}
func (m *ClusterOpenIDConnectPreset) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterOpenIDConnectPreset.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterOpenIDConnectPreset proto.InternalMessageInfo

func (m *ClusterOpenIDConnectPresetList) Reset()      { *m = ClusterOpenIDConnectPresetList{} }
func (*ClusterOpenIDConnectPresetList) ProtoMessage() {}
func (*ClusterOpenIDConnectPresetList) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0cd3f80cc90ed56, []int{1}
}
func (m *ClusterOpenIDConnectPresetList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterOpenIDConnectPresetList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ClusterOpenIDConnectPresetList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterOpenIDConnectPresetList.Merge(m, src)
}
func (m *ClusterOpenIDConnectPresetList) XXX_Size() int {
	return m.Size()
}
func (m *ClusterOpenIDConnectPresetList) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterOpenIDConnectPresetList.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterOpenIDConnectPresetList proto.InternalMessageInfo

func (m *ClusterOpenIDConnectPresetSpec) Reset()      { *m = ClusterOpenIDConnectPresetSpec{} }
func (*ClusterOpenIDConnectPresetSpec) ProtoMessage() {}
func (*ClusterOpenIDConnectPresetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0cd3f80cc90ed56, []int{2}
}
func (m *ClusterOpenIDConnectPresetSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterOpenIDConnectPresetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ClusterOpenIDConnectPresetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterOpenIDConnectPresetSpec.Merge(m, src)
}
func (m *ClusterOpenIDConnectPresetSpec) XXX_Size() int {
	return m.Size()
}
func (m *ClusterOpenIDConnectPresetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterOpenIDConnectPresetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterOpenIDConnectPresetSpec proto.InternalMessageInfo

func (m *KubeAPIServerOpenIDConnect) Reset()      { *m = KubeAPIServerOpenIDConnect{} }
func (*KubeAPIServerOpenIDConnect) ProtoMessage() {}
func (*KubeAPIServerOpenIDConnect) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0cd3f80cc90ed56, []int{3}
}
func (m *KubeAPIServerOpenIDConnect) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KubeAPIServerOpenIDConnect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *KubeAPIServerOpenIDConnect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KubeAPIServerOpenIDConnect.Merge(m, src)
}
func (m *KubeAPIServerOpenIDConnect) XXX_Size() int {
	return m.Size()
}
func (m *KubeAPIServerOpenIDConnect) XXX_DiscardUnknown() {
	xxx_messageInfo_KubeAPIServerOpenIDConnect.DiscardUnknown(m)
}

var xxx_messageInfo_KubeAPIServerOpenIDConnect proto.InternalMessageInfo

func (m *OpenIDConnectClientAuthentication) Reset()      { *m = OpenIDConnectClientAuthentication{} }
func (*OpenIDConnectClientAuthentication) ProtoMessage() {}
func (*OpenIDConnectClientAuthentication) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0cd3f80cc90ed56, []int{4}
}
func (m *OpenIDConnectClientAuthentication) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OpenIDConnectClientAuthentication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *OpenIDConnectClientAuthentication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OpenIDConnectClientAuthentication.Merge(m, src)
}
func (m *OpenIDConnectClientAuthentication) XXX_Size() int {
	return m.Size()
}
func (m *OpenIDConnectClientAuthentication) XXX_DiscardUnknown() {
	xxx_messageInfo_OpenIDConnectClientAuthentication.DiscardUnknown(m)
}

var xxx_messageInfo_OpenIDConnectClientAuthentication proto.InternalMessageInfo

func (m *OpenIDConnectPreset) Reset()      { *m = OpenIDConnectPreset{} }
func (*OpenIDConnectPreset) ProtoMessage() {}
func (*OpenIDConnectPreset) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0cd3f80cc90ed56, []int{5}
}
func (m *OpenIDConnectPreset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OpenIDConnectPreset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *OpenIDConnectPreset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OpenIDConnectPreset.Merge(m, src)
}
func (m *OpenIDConnectPreset) XXX_Size() int {
	return m.Size()
}
func (m *OpenIDConnectPreset) XXX_DiscardUnknown() {
	xxx_messageInfo_OpenIDConnectPreset.DiscardUnknown(m)
}

var xxx_messageInfo_OpenIDConnectPreset proto.InternalMessageInfo

func (m *OpenIDConnectPresetList) Reset()      { *m = OpenIDConnectPresetList{} }
func (*OpenIDConnectPresetList) ProtoMessage() {}
func (*OpenIDConnectPresetList) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0cd3f80cc90ed56, []int{6}
}
func (m *OpenIDConnectPresetList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OpenIDConnectPresetList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *OpenIDConnectPresetList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OpenIDConnectPresetList.Merge(m, src)
}
func (m *OpenIDConnectPresetList) XXX_Size() int {
	return m.Size()
}
func (m *OpenIDConnectPresetList) XXX_DiscardUnknown() {
	xxx_messageInfo_OpenIDConnectPresetList.DiscardUnknown(m)
}

var xxx_messageInfo_OpenIDConnectPresetList proto.InternalMessageInfo

func (m *OpenIDConnectPresetSpec) Reset()      { *m = OpenIDConnectPresetSpec{} }
func (*OpenIDConnectPresetSpec) ProtoMessage() {}
func (*OpenIDConnectPresetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0cd3f80cc90ed56, []int{7}
}
func (m *OpenIDConnectPresetSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OpenIDConnectPresetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *OpenIDConnectPresetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OpenIDConnectPresetSpec.Merge(m, src)
}
func (m *OpenIDConnectPresetSpec) XXX_Size() int {
	return m.Size()
}
func (m *OpenIDConnectPresetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_OpenIDConnectPresetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_OpenIDConnectPresetSpec proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ClusterOpenIDConnectPreset)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.ClusterOpenIDConnectPreset")
	proto.RegisterType((*ClusterOpenIDConnectPresetList)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.ClusterOpenIDConnectPresetList")
	proto.RegisterType((*ClusterOpenIDConnectPresetSpec)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.ClusterOpenIDConnectPresetSpec")
	proto.RegisterType((*KubeAPIServerOpenIDConnect)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.KubeAPIServerOpenIDConnect")
	proto.RegisterMapType((map[string]string)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.KubeAPIServerOpenIDConnect.RequiredClaimsEntry")
	proto.RegisterType((*OpenIDConnectClientAuthentication)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.OpenIDConnectClientAuthentication")
	proto.RegisterMapType((map[string]string)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.OpenIDConnectClientAuthentication.ExtraConfigEntry")
	proto.RegisterType((*OpenIDConnectPreset)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.OpenIDConnectPreset")
	proto.RegisterType((*OpenIDConnectPresetList)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.OpenIDConnectPresetList")
	proto.RegisterType((*OpenIDConnectPresetSpec)(nil), "github.com.gardener.gardener.pkg.apis.settings.v1alpha1.OpenIDConnectPresetSpec")
}

func init() {
	proto.RegisterFile("github.com/gardener/gardener/pkg/apis/settings/v1alpha1/generated.proto", fileDescriptor_f0cd3f80cc90ed56)
}

var fileDescriptor_f0cd3f80cc90ed56 = []byte{
	// 957 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x55, 0x4f, 0x6f, 0xe3, 0xc4,
	0x1b, 0x8e, 0x93, 0x26, 0xbf, 0x64, 0xd2, 0x7f, 0xbf, 0x29, 0xa2, 0x51, 0x0e, 0x4e, 0xc9, 0x01,
	0xf5, 0x00, 0x0e, 0x5d, 0x56, 0xec, 0x6a, 0x0f, 0x48, 0x49, 0x76, 0x55, 0x45, 0x14, 0x6d, 0x34,
	0x51, 0xb5, 0xd2, 0x8a, 0x03, 0x8e, 0xf3, 0xd6, 0x19, 0xe2, 0xd8, 0xde, 0x99, 0x71, 0x68, 0x85,
	0x84, 0xf8, 0x08, 0x7c, 0x06, 0x38, 0x70, 0x60, 0x3f, 0x05, 0xa7, 0x1e, 0xf7, 0xb8, 0xa7, 0x88,
	0x9a, 0x1b, 0x7c, 0x01, 0xb8, 0x21, 0x8f, 0x27, 0xb5, 0x9d, 0x36, 0xb0, 0x54, 0xad, 0xf6, 0xe6,
	0x79, 0xff, 0x3d, 0xcf, 0xfb, 0xcc, 0xeb, 0x79, 0xd1, 0xa1, 0x4d, 0xc5, 0x38, 0x18, 0x1a, 0x96,
	0x37, 0x6d, 0xd9, 0x26, 0x1b, 0x81, 0x0b, 0x2c, 0xf9, 0xf0, 0x27, 0x76, 0xcb, 0xf4, 0x29, 0x6f,
	0x71, 0x10, 0x82, 0xba, 0x36, 0x6f, 0xcd, 0x0e, 0x4c, 0xc7, 0x1f, 0x9b, 0x07, 0x2d, 0x3b, 0x0a,
	0x30, 0x05, 0x8c, 0x0c, 0x9f, 0x79, 0xc2, 0xc3, 0x0f, 0x92, 0x42, 0xc6, 0x22, 0x3f, 0xf9, 0xf0,
	0x27, 0xb6, 0x11, 0x15, 0x32, 0x16, 0x85, 0x8c, 0x45, 0xa1, 0xfa, 0x87, 0x69, 0x06, 0x9e, 0xed,
	0xb5, 0x64, 0xbd, 0x61, 0x70, 0x22, 0x4f, 0xf2, 0x20, 0xbf, 0x62, 0x9c, 0xfa, 0xfd, 0xc9, 0x43,
	0x6e, 0x50, 0x2f, 0xa2, 0x35, 0x35, 0xad, 0x31, 0x75, 0x81, 0x9d, 0x25, 0x3c, 0xa7, 0x20, 0xcc,
	0xd6, 0xec, 0x0a, 0xbb, 0x7a, 0x6b, 0x55, 0x16, 0x0b, 0x5c, 0x41, 0xa7, 0x70, 0x25, 0xe1, 0x93,
	0x7f, 0x4b, 0xe0, 0xd6, 0x18, 0xa6, 0xe6, 0x72, 0x5e, 0xf3, 0x2f, 0x0d, 0xd5, 0xbb, 0x4e, 0xc0,
	0x05, 0xb0, 0xa7, 0x3e, 0xb8, 0xbd, 0xc7, 0x5d, 0xcf, 0x75, 0xc1, 0x12, 0x7d, 0x06, 0x1c, 0x04,
	0xfe, 0x12, 0x95, 0x23, 0x8a, 0x23, 0x53, 0x98, 0x35, 0x6d, 0x4f, 0xdb, 0xaf, 0xde, 0xfb, 0xc8,
	0x88, 0x91, 0x8c, 0x34, 0x52, 0xa2, 0x57, 0x14, 0x6d, 0xcc, 0x0e, 0x8c, 0xa7, 0xc3, 0xaf, 0xc0,
	0x12, 0x9f, 0x83, 0x30, 0x3b, 0xf8, 0x7c, 0xde, 0xc8, 0x85, 0xf3, 0x06, 0x4a, 0x6c, 0xe4, 0xb2,
	0x2a, 0x3e, 0x43, 0x6b, 0xdc, 0x07, 0xab, 0x96, 0x97, 0xd5, 0x9f, 0x19, 0x37, 0xbc, 0x16, 0x63,
	0x75, 0x13, 0x03, 0x1f, 0xac, 0xce, 0xba, 0x22, 0xb1, 0x16, 0x9d, 0x88, 0x84, 0x6c, 0xfe, 0xa9,
	0x21, 0x7d, 0x75, 0xda, 0x11, 0xe5, 0x02, 0x7f, 0x71, 0xa5, 0x7f, 0xe3, 0xcd, 0xfa, 0x8f, 0xb2,
	0x65, 0xf7, 0xdb, 0x0a, 0xb8, 0xbc, 0xb0, 0xa4, 0x7a, 0x3f, 0x45, 0x45, 0x2a, 0x60, 0xca, 0x6b,
	0xf9, 0xbd, 0xc2, 0x7e, 0xf5, 0xde, 0xe0, 0x0e, 0x9a, 0xef, 0x6c, 0x28, 0xfc, 0x62, 0x2f, 0x42,
	0x22, 0x31, 0x60, 0xf3, 0x97, 0xfc, 0x3f, 0xb5, 0x1e, 0x69, 0x84, 0x7f, 0xd6, 0xd0, 0xae, 0x77,
	0xbd, 0x4f, 0x49, 0xd1, 0xbf, 0x31, 0xdf, 0x55, 0xb7, 0xd4, 0x50, 0x64, 0x77, 0x57, 0x04, 0x90,
	0x55, 0x8c, 0x30, 0x43, 0x5b, 0x3e, 0xf3, 0xa2, 0xf9, 0x1a, 0x80, 0x03, 0x96, 0xf0, 0x98, 0x9a,
	0xa8, 0x8f, 0xdf, 0xf0, 0xbe, 0xcc, 0x21, 0x38, 0x8b, 0xd4, 0xce, 0x4e, 0x38, 0x6f, 0x6c, 0xf5,
	0xb3, 0xf5, 0xc8, 0x32, 0x40, 0xf3, 0xc7, 0x22, 0xaa, 0x7f, 0x16, 0x0c, 0xa1, 0xdd, 0xef, 0x0d,
	0x80, 0xcd, 0x96, 0xa4, 0xc4, 0xfb, 0xa8, 0x6c, 0x99, 0x9d, 0xc0, 0x1d, 0x39, 0x20, 0x05, 0xab,
	0x74, 0xd6, 0xa3, 0x39, 0xe8, 0xb6, 0x63, 0x1b, 0xb9, 0xf4, 0xe2, 0x0f, 0x50, 0xd9, 0x72, 0x28,
	0xb8, 0xa2, 0xf7, 0x58, 0xb2, 0xae, 0x24, 0x53, 0xd3, 0x55, 0x76, 0x72, 0x19, 0x81, 0x0f, 0x50,
	0xd5, 0x66, 0x5e, 0xe0, 0xf3, 0xae, 0x63, 0xd2, 0x69, 0xad, 0x20, 0x13, 0xb6, 0xc2, 0x79, 0xa3,
	0x7a, 0x98, 0x98, 0x49, 0x3a, 0x06, 0xdf, 0x47, 0xeb, 0xf1, 0xb1, 0xcf, 0xe0, 0x84, 0x9e, 0xd6,
	0xd6, 0x62, 0x90, 0x70, 0xde, 0x58, 0x3f, 0x4c, 0xd9, 0x49, 0x26, 0x0a, 0xb7, 0x50, 0x85, 0x72,
	0x1e, 0x00, 0x3b, 0x26, 0x47, 0xb5, 0xa2, 0x4c, 0xf9, 0xbf, 0xe2, 0x55, 0xe9, 0x2d, 0x1c, 0x24,
	0x89, 0xc1, 0x3f, 0x69, 0x68, 0x93, 0xc1, 0x8b, 0x80, 0x32, 0x18, 0x49, 0x60, 0x5e, 0x2b, 0xc9,
	0xc9, 0xb6, 0x6f, 0x3c, 0x29, 0xab, 0xf5, 0x35, 0x48, 0x06, 0xe9, 0x89, 0x2b, 0xd8, 0x59, 0xe7,
	0x5d, 0xc5, 0x6f, 0x33, 0xeb, 0x24, 0x4b, 0xb4, 0x22, 0x0d, 0x39, 0xb5, 0x5d, 0xea, 0xda, 0x6d,
	0xc7, 0xe6, 0xb5, 0xff, 0xed, 0x15, 0x16, 0x1a, 0x0e, 0x12, 0x33, 0x49, 0xc7, 0xe0, 0x07, 0x68,
	0x23, 0xe0, 0xc0, 0x5c, 0x73, 0x0a, 0xb1, 0xf0, 0xe5, 0x58, 0x91, 0x70, 0xde, 0xd8, 0x38, 0x4e,
	0x3b, 0x48, 0x36, 0x0e, 0x3f, 0x42, 0x9b, 0x0b, 0x83, 0x92, 0xbf, 0x22, 0x33, 0x71, 0xc4, 0xf3,
	0x38, 0xe3, 0x21, 0x4b, 0x91, 0xf5, 0x36, 0xda, 0xb9, 0xa6, 0x4d, 0xbc, 0x8d, 0x0a, 0x13, 0x38,
	0x8b, 0xa7, 0x8a, 0x44, 0x9f, 0xf8, 0x1d, 0x54, 0x9c, 0x99, 0x4e, 0x00, 0xf1, 0xfc, 0x90, 0xf8,
	0xf0, 0x28, 0xff, 0x50, 0x6b, 0xbe, 0xcc, 0xa3, 0xf7, 0x32, 0xc2, 0xc5, 0x23, 0xd5, 0x0e, 0xc4,
	0x18, 0x5c, 0x41, 0x2d, 0x53, 0x50, 0xcf, 0xc5, 0x4d, 0x54, 0xe2, 0x60, 0x31, 0x10, 0x6a, 0x54,
	0x51, 0x38, 0x6f, 0x94, 0x06, 0xd2, 0x42, 0x94, 0x07, 0xff, 0xa0, 0xa1, 0x2a, 0x9c, 0x0a, 0x66,
	0x76, 0x3d, 0xf7, 0x84, 0xda, 0xea, 0xd5, 0x9a, 0xdc, 0xce, 0x2b, 0x70, 0x1d, 0x2b, 0xe3, 0x49,
	0x82, 0x16, 0xdf, 0xef, 0x8e, 0xba, 0xdf, 0x6a, 0xca, 0x43, 0xd2, 0xa4, 0xea, 0x9f, 0xa2, 0xed,
	0xe5, 0xac, 0xff, 0x24, 0xd7, 0x1f, 0x1a, 0xda, 0x79, 0x3b, 0x9b, 0x90, 0x65, 0x36, 0xe1, 0xed,
	0x3f, 0xae, 0xd7, 0xad, 0xc0, 0xdf, 0x35, 0xb4, 0xfb, 0x76, 0x76, 0xdf, 0x8b, 0xec, 0xee, 0x3b,
	0xba, 0xcd, 0x76, 0x57, 0x2c, 0xbd, 0x97, 0x05, 0xb4, 0x6a, 0xb1, 0xe0, 0x6f, 0xa2, 0xf9, 0x8f,
	0xde, 0x18, 0xd5, 0xea, 0xe0, 0x0e, 0x5e, 0xac, 0xce, 0xa6, 0xa2, 0x55, 0x8a, 0x9d, 0x44, 0x41,
	0xe2, 0x6f, 0x51, 0x29, 0x7e, 0xdd, 0xd5, 0xdd, 0x3f, 0xbf, 0xbb, 0x5f, 0x2a, 0xfe, 0xb1, 0x63,
	0x0f, 0x51, 0xa8, 0xd8, 0x41, 0x1b, 0x7c, 0xec, 0x79, 0xc9, 0xea, 0x2c, 0xdc, 0x7c, 0x75, 0xca,
	0xf7, 0x70, 0x90, 0xae, 0x46, 0xb2, 0xc5, 0xf1, 0xfb, 0xa8, 0xf4, 0x35, 0x50, 0x7b, 0x2c, 0xe4,
	0x1a, 0x2a, 0x26, 0xaa, 0x3c, 0x93, 0x56, 0xa2, 0xbc, 0x1d, 0xe3, 0xfc, 0x42, 0xcf, 0xbd, 0xba,
	0xd0, 0x73, 0xaf, 0x2f, 0xf4, 0xdc, 0x77, 0xa1, 0xae, 0x9d, 0x87, 0xba, 0xf6, 0x2a, 0xd4, 0xb5,
	0xd7, 0xa1, 0xae, 0xfd, 0x1a, 0xea, 0xda, 0xf7, 0xbf, 0xe9, 0xb9, 0xe7, 0xe5, 0x45, 0xef, 0x7f,
	0x07, 0x00, 0x00, 0xff, 0xff, 0x68, 0xeb, 0xae, 0x3a, 0x1b, 0x0c, 0x00, 0x00,
}

func (m *ClusterOpenIDConnectPreset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterOpenIDConnectPreset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterOpenIDConnectPreset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ClusterOpenIDConnectPresetList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterOpenIDConnectPresetList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterOpenIDConnectPresetList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ListMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ClusterOpenIDConnectPresetSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterOpenIDConnectPresetSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterOpenIDConnectPresetSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ProjectSelector != nil {
		{
			size, err := m.ProjectSelector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	{
		size, err := m.OpenIDConnectPresetSpec.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *KubeAPIServerOpenIDConnect) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KubeAPIServerOpenIDConnect) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KubeAPIServerOpenIDConnect) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UsernamePrefix != nil {
		i -= len(*m.UsernamePrefix)
		copy(dAtA[i:], *m.UsernamePrefix)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.UsernamePrefix)))
		i--
		dAtA[i] = 0x4a
	}
	if m.UsernameClaim != nil {
		i -= len(*m.UsernameClaim)
		copy(dAtA[i:], *m.UsernameClaim)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.UsernameClaim)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.SigningAlgs) > 0 {
		for iNdEx := len(m.SigningAlgs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.SigningAlgs[iNdEx])
			copy(dAtA[i:], m.SigningAlgs[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.SigningAlgs[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.RequiredClaims) > 0 {
		keysForRequiredClaims := make([]string, 0, len(m.RequiredClaims))
		for k := range m.RequiredClaims {
			keysForRequiredClaims = append(keysForRequiredClaims, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForRequiredClaims)
		for iNdEx := len(keysForRequiredClaims) - 1; iNdEx >= 0; iNdEx-- {
			v := m.RequiredClaims[string(keysForRequiredClaims[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForRequiredClaims[iNdEx])
			copy(dAtA[i:], keysForRequiredClaims[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(keysForRequiredClaims[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	i -= len(m.IssuerURL)
	copy(dAtA[i:], m.IssuerURL)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.IssuerURL)))
	i--
	dAtA[i] = 0x2a
	if m.GroupsPrefix != nil {
		i -= len(*m.GroupsPrefix)
		copy(dAtA[i:], *m.GroupsPrefix)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.GroupsPrefix)))
		i--
		dAtA[i] = 0x22
	}
	if m.GroupsClaim != nil {
		i -= len(*m.GroupsClaim)
		copy(dAtA[i:], *m.GroupsClaim)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.GroupsClaim)))
		i--
		dAtA[i] = 0x1a
	}
	i -= len(m.ClientID)
	copy(dAtA[i:], m.ClientID)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.ClientID)))
	i--
	dAtA[i] = 0x12
	if m.CABundle != nil {
		i -= len(*m.CABundle)
		copy(dAtA[i:], *m.CABundle)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.CABundle)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OpenIDConnectClientAuthentication) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OpenIDConnectClientAuthentication) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OpenIDConnectClientAuthentication) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ExtraConfig) > 0 {
		keysForExtraConfig := make([]string, 0, len(m.ExtraConfig))
		for k := range m.ExtraConfig {
			keysForExtraConfig = append(keysForExtraConfig, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForExtraConfig)
		for iNdEx := len(keysForExtraConfig) - 1; iNdEx >= 0; iNdEx-- {
			v := m.ExtraConfig[string(keysForExtraConfig[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGenerated(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForExtraConfig[iNdEx])
			copy(dAtA[i:], keysForExtraConfig[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(keysForExtraConfig[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGenerated(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Secret != nil {
		i -= len(*m.Secret)
		copy(dAtA[i:], *m.Secret)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Secret)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OpenIDConnectPreset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OpenIDConnectPreset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OpenIDConnectPreset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *OpenIDConnectPresetList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OpenIDConnectPresetList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OpenIDConnectPresetList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ListMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *OpenIDConnectPresetSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OpenIDConnectPresetSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OpenIDConnectPresetSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i = encodeVarintGenerated(dAtA, i, uint64(m.Weight))
	i--
	dAtA[i] = 0x20
	if m.ShootSelector != nil {
		{
			size, err := m.ShootSelector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Client != nil {
		{
			size, err := m.Client.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	{
		size, err := m.Server.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ClusterOpenIDConnectPreset) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ObjectMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *ClusterOpenIDConnectPresetList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ListMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *ClusterOpenIDConnectPresetSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.OpenIDConnectPresetSpec.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if m.ProjectSelector != nil {
		l = m.ProjectSelector.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *KubeAPIServerOpenIDConnect) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CABundle != nil {
		l = len(*m.CABundle)
		n += 1 + l + sovGenerated(uint64(l))
	}
	l = len(m.ClientID)
	n += 1 + l + sovGenerated(uint64(l))
	if m.GroupsClaim != nil {
		l = len(*m.GroupsClaim)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.GroupsPrefix != nil {
		l = len(*m.GroupsPrefix)
		n += 1 + l + sovGenerated(uint64(l))
	}
	l = len(m.IssuerURL)
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.RequiredClaims) > 0 {
		for k, v := range m.RequiredClaims {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	if len(m.SigningAlgs) > 0 {
		for _, s := range m.SigningAlgs {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.UsernameClaim != nil {
		l = len(*m.UsernameClaim)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.UsernamePrefix != nil {
		l = len(*m.UsernamePrefix)
		n += 1 + l + sovGenerated(uint64(l))
	}
	return n
}

func (m *OpenIDConnectClientAuthentication) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Secret != nil {
		l = len(*m.Secret)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.ExtraConfig) > 0 {
		for k, v := range m.ExtraConfig {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGenerated(uint64(len(k))) + 1 + len(v) + sovGenerated(uint64(len(v)))
			n += mapEntrySize + 1 + sovGenerated(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *OpenIDConnectPreset) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ObjectMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *OpenIDConnectPresetList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ListMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *OpenIDConnectPresetSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Server.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if m.Client != nil {
		l = m.Client.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ShootSelector != nil {
		l = m.ShootSelector.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	n += 1 + sovGenerated(uint64(m.Weight))
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ClusterOpenIDConnectPreset) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ClusterOpenIDConnectPreset{`,
		`ObjectMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ObjectMeta), "ObjectMeta", "v1.ObjectMeta", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "ClusterOpenIDConnectPresetSpec", "ClusterOpenIDConnectPresetSpec", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ClusterOpenIDConnectPresetList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]ClusterOpenIDConnectPreset{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(strings.Replace(f.String(), "ClusterOpenIDConnectPreset", "ClusterOpenIDConnectPreset", 1), `&`, ``, 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&ClusterOpenIDConnectPresetList{`,
		`ListMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ListMeta), "ListMeta", "v1.ListMeta", 1), `&`, ``, 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *ClusterOpenIDConnectPresetSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ClusterOpenIDConnectPresetSpec{`,
		`OpenIDConnectPresetSpec:` + strings.Replace(strings.Replace(this.OpenIDConnectPresetSpec.String(), "OpenIDConnectPresetSpec", "OpenIDConnectPresetSpec", 1), `&`, ``, 1) + `,`,
		`ProjectSelector:` + strings.Replace(fmt.Sprintf("%v", this.ProjectSelector), "LabelSelector", "v1.LabelSelector", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *KubeAPIServerOpenIDConnect) String() string {
	if this == nil {
		return "nil"
	}
	keysForRequiredClaims := make([]string, 0, len(this.RequiredClaims))
	for k := range this.RequiredClaims {
		keysForRequiredClaims = append(keysForRequiredClaims, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForRequiredClaims)
	mapStringForRequiredClaims := "map[string]string{"
	for _, k := range keysForRequiredClaims {
		mapStringForRequiredClaims += fmt.Sprintf("%v: %v,", k, this.RequiredClaims[k])
	}
	mapStringForRequiredClaims += "}"
	s := strings.Join([]string{`&KubeAPIServerOpenIDConnect{`,
		`CABundle:` + valueToStringGenerated(this.CABundle) + `,`,
		`ClientID:` + fmt.Sprintf("%v", this.ClientID) + `,`,
		`GroupsClaim:` + valueToStringGenerated(this.GroupsClaim) + `,`,
		`GroupsPrefix:` + valueToStringGenerated(this.GroupsPrefix) + `,`,
		`IssuerURL:` + fmt.Sprintf("%v", this.IssuerURL) + `,`,
		`RequiredClaims:` + mapStringForRequiredClaims + `,`,
		`SigningAlgs:` + fmt.Sprintf("%v", this.SigningAlgs) + `,`,
		`UsernameClaim:` + valueToStringGenerated(this.UsernameClaim) + `,`,
		`UsernamePrefix:` + valueToStringGenerated(this.UsernamePrefix) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OpenIDConnectClientAuthentication) String() string {
	if this == nil {
		return "nil"
	}
	keysForExtraConfig := make([]string, 0, len(this.ExtraConfig))
	for k := range this.ExtraConfig {
		keysForExtraConfig = append(keysForExtraConfig, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForExtraConfig)
	mapStringForExtraConfig := "map[string]string{"
	for _, k := range keysForExtraConfig {
		mapStringForExtraConfig += fmt.Sprintf("%v: %v,", k, this.ExtraConfig[k])
	}
	mapStringForExtraConfig += "}"
	s := strings.Join([]string{`&OpenIDConnectClientAuthentication{`,
		`Secret:` + valueToStringGenerated(this.Secret) + `,`,
		`ExtraConfig:` + mapStringForExtraConfig + `,`,
		`}`,
	}, "")
	return s
}
func (this *OpenIDConnectPreset) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OpenIDConnectPreset{`,
		`ObjectMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ObjectMeta), "ObjectMeta", "v1.ObjectMeta", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "OpenIDConnectPresetSpec", "OpenIDConnectPresetSpec", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OpenIDConnectPresetList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]OpenIDConnectPreset{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(strings.Replace(f.String(), "OpenIDConnectPreset", "OpenIDConnectPreset", 1), `&`, ``, 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&OpenIDConnectPresetList{`,
		`ListMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ListMeta), "ListMeta", "v1.ListMeta", 1), `&`, ``, 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *OpenIDConnectPresetSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OpenIDConnectPresetSpec{`,
		`Server:` + strings.Replace(strings.Replace(this.Server.String(), "KubeAPIServerOpenIDConnect", "KubeAPIServerOpenIDConnect", 1), `&`, ``, 1) + `,`,
		`Client:` + strings.Replace(this.Client.String(), "OpenIDConnectClientAuthentication", "OpenIDConnectClientAuthentication", 1) + `,`,
		`ShootSelector:` + strings.Replace(fmt.Sprintf("%v", this.ShootSelector), "LabelSelector", "v1.LabelSelector", 1) + `,`,
		`Weight:` + fmt.Sprintf("%v", this.Weight) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ClusterOpenIDConnectPreset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterOpenIDConnectPreset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterOpenIDConnectPreset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterOpenIDConnectPresetList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterOpenIDConnectPresetList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterOpenIDConnectPresetList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ListMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, ClusterOpenIDConnectPreset{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterOpenIDConnectPresetSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterOpenIDConnectPresetSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterOpenIDConnectPresetSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpenIDConnectPresetSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OpenIDConnectPresetSpec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectSelector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProjectSelector == nil {
				m.ProjectSelector = &v1.LabelSelector{}
			}
			if err := m.ProjectSelector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KubeAPIServerOpenIDConnect) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KubeAPIServerOpenIDConnect: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KubeAPIServerOpenIDConnect: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CABundle", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.CABundle = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupsClaim", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.GroupsClaim = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupsPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.GroupsPrefix = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IssuerURL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IssuerURL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequiredClaims", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequiredClaims == nil {
				m.RequiredClaims = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.RequiredClaims[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigningAlgs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigningAlgs = append(m.SigningAlgs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsernameClaim", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.UsernameClaim = &s
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsernamePrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.UsernamePrefix = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OpenIDConnectClientAuthentication) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OpenIDConnectClientAuthentication: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OpenIDConnectClientAuthentication: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Secret = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExtraConfig == nil {
				m.ExtraConfig = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGenerated
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthGenerated
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGenerated(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthGenerated
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ExtraConfig[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OpenIDConnectPreset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OpenIDConnectPreset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OpenIDConnectPreset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OpenIDConnectPresetList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OpenIDConnectPresetList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OpenIDConnectPresetList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ListMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, OpenIDConnectPreset{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OpenIDConnectPresetSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OpenIDConnectPresetSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OpenIDConnectPresetSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Server", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Server.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Client", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Client == nil {
				m.Client = &OpenIDConnectClientAuthentication{}
			}
			if err := m.Client.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShootSelector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ShootSelector == nil {
				m.ShootSelector = &v1.LabelSelector{}
			}
			if err := m.ShootSelector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Weight |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGenerated
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGenerated
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGenerated        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGenerated = fmt.Errorf("proto: unexpected end of group")
)
