/*
Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/gardener/gardener/pkg/apis/operations/v1alpha1/generated.proto

package v1alpha1

import (
	fmt "fmt"

	v1alpha1 "github.com/gardener/gardener/pkg/apis/core/v1alpha1"

	io "io"

	proto "github.com/gogo/protobuf/proto"
	v12 "k8s.io/api/core/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"

	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func (m *Bastion) Reset()      { *m = Bastion{} }
func (*Bastion) ProtoMessage() {}
func (*Bastion) Descriptor() ([]byte, []int) {
	return fileDescriptor_a8b335fad1255a79, []int{0}
}
func (m *Bastion) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bastion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Bastion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bastion.Merge(m, src)
}
func (m *Bastion) XXX_Size() int {
	return m.Size()
}
func (m *Bastion) XXX_DiscardUnknown() {
	xxx_messageInfo_Bastion.DiscardUnknown(m)
}

var xxx_messageInfo_Bastion proto.InternalMessageInfo

func (m *BastionIngressPolicy) Reset()      { *m = BastionIngressPolicy{} }
func (*BastionIngressPolicy) ProtoMessage() {}
func (*BastionIngressPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_a8b335fad1255a79, []int{1}
}
func (m *BastionIngressPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BastionIngressPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *BastionIngressPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BastionIngressPolicy.Merge(m, src)
}
func (m *BastionIngressPolicy) XXX_Size() int {
	return m.Size()
}
func (m *BastionIngressPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_BastionIngressPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_BastionIngressPolicy proto.InternalMessageInfo

func (m *BastionList) Reset()      { *m = BastionList{} }
func (*BastionList) ProtoMessage() {}
func (*BastionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_a8b335fad1255a79, []int{2}
}
func (m *BastionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BastionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *BastionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BastionList.Merge(m, src)
}
func (m *BastionList) XXX_Size() int {
	return m.Size()
}
func (m *BastionList) XXX_DiscardUnknown() {
	xxx_messageInfo_BastionList.DiscardUnknown(m)
}

var xxx_messageInfo_BastionList proto.InternalMessageInfo

func (m *BastionSpec) Reset()      { *m = BastionSpec{} }
func (*BastionSpec) ProtoMessage() {}
func (*BastionSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_a8b335fad1255a79, []int{3}
}
func (m *BastionSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BastionSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *BastionSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BastionSpec.Merge(m, src)
}
func (m *BastionSpec) XXX_Size() int {
	return m.Size()
}
func (m *BastionSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_BastionSpec.DiscardUnknown(m)
}

var xxx_messageInfo_BastionSpec proto.InternalMessageInfo

func (m *BastionStatus) Reset()      { *m = BastionStatus{} }
func (*BastionStatus) ProtoMessage() {}
func (*BastionStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_a8b335fad1255a79, []int{4}
}
func (m *BastionStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BastionStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *BastionStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BastionStatus.Merge(m, src)
}
func (m *BastionStatus) XXX_Size() int {
	return m.Size()
}
func (m *BastionStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_BastionStatus.DiscardUnknown(m)
}

var xxx_messageInfo_BastionStatus proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Bastion)(nil), "github.com.gardener.gardener.pkg.apis.operations.v1alpha1.Bastion")
	proto.RegisterType((*BastionIngressPolicy)(nil), "github.com.gardener.gardener.pkg.apis.operations.v1alpha1.BastionIngressPolicy")
	proto.RegisterType((*BastionList)(nil), "github.com.gardener.gardener.pkg.apis.operations.v1alpha1.BastionList")
	proto.RegisterType((*BastionSpec)(nil), "github.com.gardener.gardener.pkg.apis.operations.v1alpha1.BastionSpec")
	proto.RegisterType((*BastionStatus)(nil), "github.com.gardener.gardener.pkg.apis.operations.v1alpha1.BastionStatus")
}

func init() {
	proto.RegisterFile("github.com/gardener/gardener/pkg/apis/operations/v1alpha1/generated.proto", fileDescriptor_a8b335fad1255a79)
}

var fileDescriptor_a8b335fad1255a79 = []byte{
	// 789 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x94, 0xcf, 0x6f, 0xe3, 0x44,
	0x14, 0xc7, 0xe3, 0x36, 0xdd, 0x66, 0xa7, 0x59, 0x58, 0xcd, 0xae, 0x4a, 0xd4, 0x83, 0x53, 0x72,
	0x21, 0x42, 0x62, 0x42, 0x57, 0x2b, 0xb4, 0x5c, 0x38, 0x78, 0xc5, 0xd2, 0x88, 0xb2, 0x8d, 0x26,
	0x2b, 0x0e, 0x88, 0x03, 0x13, 0xfb, 0xd5, 0x19, 0x12, 0x7b, 0xac, 0x99, 0x49, 0x20, 0x1c, 0x10,
	0x7f, 0x02, 0xe2, 0x9f, 0xa2, 0xc7, 0x3d, 0x70, 0xd8, 0x53, 0x44, 0xcd, 0x9f, 0xc1, 0x05, 0x79,
	0x3c, 0x8e, 0x1d, 0x92, 0x8a, 0x40, 0xb9, 0x79, 0xde, 0xbc, 0xf7, 0xf9, 0xbe, 0x5f, 0x1e, 0xd4,
	0x0f, 0xb9, 0x1e, 0xcf, 0x46, 0xc4, 0x17, 0x51, 0x2f, 0x64, 0x32, 0x80, 0x18, 0x64, 0xf9, 0x91,
	0x4c, 0xc2, 0x1e, 0x4b, 0xb8, 0xea, 0x89, 0x04, 0x24, 0xd3, 0x5c, 0xc4, 0xaa, 0x37, 0x3f, 0x63,
	0xd3, 0x64, 0xcc, 0xce, 0x7a, 0x61, 0xe6, 0xc2, 0x34, 0x04, 0x24, 0x91, 0x42, 0x0b, 0xfc, 0x71,
	0x89, 0x22, 0x05, 0xa1, 0xfc, 0x48, 0x26, 0x21, 0xc9, 0x50, 0xa4, 0x44, 0x91, 0x02, 0x75, 0xf2,
	0x7c, 0xb7, 0x2c, 0x7c, 0x21, 0xe1, 0x56, 0xfd, 0x93, 0x0f, 0xaa, 0x10, 0x11, 0x8a, 0x9e, 0x31,
	0x8f, 0x66, 0x57, 0xe6, 0x64, 0x0e, 0xe6, 0xcb, 0xba, 0x77, 0x26, 0xcf, 0x14, 0xe1, 0x22, 0x23,
	0x17, 0xe0, 0x0d, 0x64, 0xb7, 0xe2, 0x13, 0x83, 0xfe, 0x4e, 0xc8, 0x09, 0x8f, 0xc3, 0x6d, 0x9e,
	0x4f, 0x4b, 0xcf, 0x88, 0xf9, 0x63, 0x1e, 0x83, 0x5c, 0x94, 0x89, 0x47, 0xa0, 0xd9, 0xb6, 0xa8,
	0xde, 0x6d, 0x51, 0x72, 0x16, 0x6b, 0x1e, 0xc1, 0x46, 0xc0, 0x47, 0xff, 0x14, 0xa0, 0xfc, 0x31,
	0x44, 0xec, 0xef, 0x71, 0x9d, 0x5f, 0xf7, 0xd0, 0xa1, 0xc7, 0x54, 0xd6, 0x76, 0xfc, 0x0d, 0x6a,
	0x64, 0xf9, 0x04, 0x4c, 0xb3, 0x96, 0x73, 0xea, 0x74, 0x8f, 0x9e, 0x7c, 0x48, 0x72, 0x2c, 0xa9,
	0x62, 0xcb, 0x89, 0x65, 0xde, 0x64, 0x7e, 0x46, 0x2e, 0x47, 0xdf, 0x82, 0xaf, 0xbf, 0x00, 0xcd,
	0x3c, 0x7c, 0xbd, 0x6c, 0xd7, 0xd2, 0x65, 0x1b, 0x95, 0x36, 0xba, 0xa2, 0xe2, 0x31, 0xaa, 0xab,
	0x04, 0xfc, 0xd6, 0x9e, 0xa1, 0xbf, 0x20, 0xff, 0x79, 0x31, 0x88, 0xcd, 0x79, 0x98, 0x80, 0xef,
	0x35, 0xad, 0x66, 0x3d, 0x3b, 0x51, 0xa3, 0x80, 0x13, 0x74, 0x4f, 0x69, 0xa6, 0x67, 0xaa, 0xb5,
	0x6f, 0xb4, 0xce, 0xff, 0x07, 0x2d, 0xc3, 0xf3, 0xde, 0xb2, 0x6a, 0xf7, 0xf2, 0x33, 0xb5, 0x3a,
	0x9d, 0x00, 0x3d, 0xb6, 0x8e, 0xfd, 0x38, 0x94, 0xa0, 0xd4, 0x40, 0x4c, 0xb9, 0xbf, 0xc0, 0x17,
	0xe8, 0x90, 0x27, 0xde, 0x54, 0xf8, 0x13, 0xdb, 0xd4, 0x77, 0x2b, 0x4d, 0x25, 0xe5, 0xf2, 0x64,
	0x8d, 0xec, 0x0f, 0x8c, 0xa3, 0xf7, 0xb6, 0xd5, 0x38, 0xb4, 0x06, 0x5a, 0x20, 0x3a, 0xbf, 0x39,
	0xe8, 0xc8, 0xca, 0x5c, 0x70, 0xa5, 0xf1, 0xd7, 0x1b, 0x33, 0x23, 0xbb, 0xcd, 0x2c, 0x8b, 0x36,
	0x13, 0x7b, 0x68, 0xb5, 0x1a, 0x85, 0xa5, 0x32, 0xaf, 0x10, 0x1d, 0x70, 0x0d, 0x91, 0x6a, 0xed,
	0x9d, 0xee, 0x77, 0x8f, 0x9e, 0x78, 0x77, 0x6f, 0xa2, 0xf7, 0xc0, 0xca, 0x1d, 0xf4, 0x33, 0x30,
	0xcd, 0xf9, 0x9d, 0x3f, 0xf7, 0x56, 0x65, 0x65, 0x43, 0xc4, 0x5f, 0xa2, 0x86, 0x1a, 0x0b, 0xa1,
	0x29, 0x5c, 0xd9, 0xb2, 0xba, 0xd5, 0xae, 0x65, 0xbf, 0xa5, 0x29, 0x42, 0xf8, 0x6c, 0x9a, 0x6f,
	0x1a, 0x85, 0x2b, 0x90, 0x10, 0xfb, 0x50, 0x16, 0x34, 0xb4, 0x04, 0xba, 0x62, 0xe1, 0x2e, 0x6a,
	0x28, 0x80, 0xe0, 0x25, 0x8b, 0xc0, 0x2c, 0xe1, 0x7d, 0xaf, 0x69, 0x3c, 0xad, 0x8d, 0xae, 0x6e,
	0xf1, 0x53, 0xd4, 0x4c, 0xa4, 0x98, 0xf3, 0x00, 0xe4, 0xab, 0x45, 0x02, 0x66, 0x8d, 0xee, 0x7b,
	0x0f, 0xd3, 0x65, 0xbb, 0x39, 0xa8, 0xd8, 0xe9, 0x9a, 0x17, 0x7e, 0x86, 0x9a, 0x4a, 0x8d, 0x07,
	0xb3, 0xd1, 0x94, 0xfb, 0x9f, 0xc3, 0xa2, 0x55, 0x37, 0x51, 0x8f, 0x6d, 0x46, 0xcd, 0xe1, 0xf0,
	0x7c, 0x75, 0x47, 0xd7, 0x3c, 0xf1, 0x0f, 0xe8, 0x90, 0xe7, 0x7b, 0xd3, 0x3a, 0x30, 0xcd, 0xbe,
	0xbc, 0x7b, 0xb3, 0xd7, 0x16, 0xb1, 0xb2, 0x54, 0xb9, 0x99, 0x16, 0x82, 0x9d, 0x5f, 0xea, 0xe8,
	0xc1, 0xda, 0x92, 0xe3, 0x97, 0x65, 0x36, 0x79, 0xfb, 0xdf, 0xdb, 0xde, 0x7e, 0x16, 0x78, 0x6c,
	0xca, 0x62, 0x1f, 0xa4, 0x85, 0x7a, 0x47, 0xdb, 0x14, 0xb0, 0x44, 0xc8, 0x17, 0x71, 0xc0, 0x4d,
	0x9e, 0x76, 0x9b, 0x3e, 0xd9, 0xb1, 0x40, 0xab, 0x66, 0x4b, 0x7b, 0x5e, 0x60, 0xca, 0xa7, 0x66,
	0x65, 0x52, 0xb4, 0xa2, 0x82, 0x7f, 0x44, 0xc7, 0x53, 0xa6, 0xf4, 0x39, 0x30, 0xa9, 0x47, 0xc0,
	0xf4, 0x2b, 0x1e, 0x81, 0xd2, 0x2c, 0x4a, 0xec, 0x93, 0xf0, 0xfe, 0x6e, 0x3f, 0x4a, 0x16, 0xe6,
	0x9d, 0xa4, 0xcb, 0xf6, 0xf1, 0xc5, 0x56, 0x1a, 0xbd, 0x45, 0x05, 0xcf, 0xd0, 0x23, 0xf8, 0x3e,
	0xe1, 0xf9, 0x70, 0x4a, 0xf1, 0xfa, 0xbf, 0x16, 0x7f, 0x27, 0x5d, 0xb6, 0x1f, 0x7d, 0xba, 0x89,
	0xa2, 0xdb, 0xf8, 0xf8, 0x05, 0xc2, 0x62, 0xa4, 0x40, 0xce, 0x21, 0xf8, 0x2c, 0x7f, 0xec, 0xb9,
	0x88, 0x5b, 0x07, 0xa7, 0x4e, 0x77, 0xdf, 0x3b, 0x4e, 0x97, 0x6d, 0x7c, 0xb9, 0x71, 0x4b, 0xb7,
	0x44, 0x78, 0xe4, 0xfa, 0xc6, 0xad, 0xbd, 0xbe, 0x71, 0x6b, 0x6f, 0x6e, 0xdc, 0xda, 0x4f, 0xa9,
	0xeb, 0x5c, 0xa7, 0xae, 0xf3, 0x3a, 0x75, 0x9d, 0x37, 0xa9, 0xeb, 0xfc, 0x9e, 0xba, 0xce, 0xcf,
	0x7f, 0xb8, 0xb5, 0xaf, 0x1a, 0xc5, 0x60, 0xfe, 0x0a, 0x00, 0x00, 0xff, 0xff, 0x5e, 0xa9, 0x86,
	0xef, 0x31, 0x08, 0x00, 0x00,
}

func (m *Bastion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bastion) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Bastion) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	{
		size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *BastionIngressPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BastionIngressPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BastionIngressPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.IPBlock.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *BastionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BastionList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BastionList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ListMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *BastionSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BastionSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BastionSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Ingress) > 0 {
		for iNdEx := len(m.Ingress) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ingress[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	i -= len(m.SSHPublicKey)
	copy(dAtA[i:], m.SSHPublicKey)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.SSHPublicKey)))
	i--
	dAtA[i] = 0x22
	if m.ProviderType != nil {
		i -= len(*m.ProviderType)
		copy(dAtA[i:], *m.ProviderType)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ProviderType)))
		i--
		dAtA[i] = 0x1a
	}
	if m.SeedName != nil {
		i -= len(*m.SeedName)
		copy(dAtA[i:], *m.SeedName)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.SeedName)))
		i--
		dAtA[i] = 0x12
	}
	{
		size, err := m.ShootRef.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *BastionStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BastionStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BastionStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ObservedGeneration != nil {
		i = encodeVarintGenerated(dAtA, i, uint64(*m.ObservedGeneration))
		i--
		dAtA[i] = 0x28
	}
	if m.ExpirationTimestamp != nil {
		{
			size, err := m.ExpirationTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.LastHeartbeatTimestamp != nil {
		{
			size, err := m.LastHeartbeatTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Ingress != nil {
		{
			size, err := m.Ingress.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Bastion) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ObjectMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Status.Size()
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *BastionIngressPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.IPBlock.Size()
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *BastionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ListMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *BastionSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ShootRef.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if m.SeedName != nil {
		l = len(*m.SeedName)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ProviderType != nil {
		l = len(*m.ProviderType)
		n += 1 + l + sovGenerated(uint64(l))
	}
	l = len(m.SSHPublicKey)
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Ingress) > 0 {
		for _, e := range m.Ingress {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *BastionStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Ingress != nil {
		l = m.Ingress.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.LastHeartbeatTimestamp != nil {
		l = m.LastHeartbeatTimestamp.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ExpirationTimestamp != nil {
		l = m.ExpirationTimestamp.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ObservedGeneration != nil {
		n += 1 + sovGenerated(uint64(*m.ObservedGeneration))
	}
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Bastion) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Bastion{`,
		`ObjectMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ObjectMeta), "ObjectMeta", "v1.ObjectMeta", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "BastionSpec", "BastionSpec", 1), `&`, ``, 1) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "BastionStatus", "BastionStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *BastionIngressPolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&BastionIngressPolicy{`,
		`IPBlock:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.IPBlock), "IPBlock", "v11.IPBlock", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *BastionList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]Bastion{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(strings.Replace(f.String(), "Bastion", "Bastion", 1), `&`, ``, 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&BastionList{`,
		`ListMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ListMeta), "ListMeta", "v1.ListMeta", 1), `&`, ``, 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *BastionSpec) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForIngress := "[]BastionIngressPolicy{"
	for _, f := range this.Ingress {
		repeatedStringForIngress += strings.Replace(strings.Replace(f.String(), "BastionIngressPolicy", "BastionIngressPolicy", 1), `&`, ``, 1) + ","
	}
	repeatedStringForIngress += "}"
	s := strings.Join([]string{`&BastionSpec{`,
		`ShootRef:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ShootRef), "LocalObjectReference", "v12.LocalObjectReference", 1), `&`, ``, 1) + `,`,
		`SeedName:` + valueToStringGenerated(this.SeedName) + `,`,
		`ProviderType:` + valueToStringGenerated(this.ProviderType) + `,`,
		`SSHPublicKey:` + fmt.Sprintf("%v", this.SSHPublicKey) + `,`,
		`Ingress:` + repeatedStringForIngress + `,`,
		`}`,
	}, "")
	return s
}
func (this *BastionStatus) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForConditions := "[]Condition{"
	for _, f := range this.Conditions {
		repeatedStringForConditions += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForConditions += "}"
	s := strings.Join([]string{`&BastionStatus{`,
		`Ingress:` + strings.Replace(fmt.Sprintf("%v", this.Ingress), "LoadBalancerIngress", "v12.LoadBalancerIngress", 1) + `,`,
		`Conditions:` + repeatedStringForConditions + `,`,
		`LastHeartbeatTimestamp:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatTimestamp), "Time", "v1.Time", 1) + `,`,
		`ExpirationTimestamp:` + strings.Replace(fmt.Sprintf("%v", this.ExpirationTimestamp), "Time", "v1.Time", 1) + `,`,
		`ObservedGeneration:` + valueToStringGenerated(this.ObservedGeneration) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Bastion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bastion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bastion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BastionIngressPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BastionIngressPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BastionIngressPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IPBlock", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.IPBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BastionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BastionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BastionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ListMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, Bastion{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BastionSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BastionSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BastionSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShootRef", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ShootRef.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeedName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.SeedName = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProviderType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ProviderType = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SSHPublicKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SSHPublicKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ingress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ingress = append(m.Ingress, BastionIngressPolicy{})
			if err := m.Ingress[len(m.Ingress)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BastionStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BastionStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BastionStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ingress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ingress == nil {
				m.Ingress = &v12.LoadBalancerIngress{}
			}
			if err := m.Ingress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conditions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Conditions = append(m.Conditions, v1alpha1.Condition{})
			if err := m.Conditions[len(m.Conditions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatTimestamp == nil {
				m.LastHeartbeatTimestamp = &v1.Time{}
			}
			if err := m.LastHeartbeatTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpirationTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpirationTimestamp == nil {
				m.ExpirationTimestamp = &v1.Time{}
			}
			if err := m.ExpirationTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedGeneration", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ObservedGeneration = &v
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGenerated
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGenerated
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGenerated        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGenerated = fmt.Errorf("proto: unexpected end of group")
)
