// Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package v1alpha1

import (
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

var _ Object = (*BackupBucket)(nil)

// BackupBucketResource is a constant for the name of the BackupBucket resource.
const BackupBucketResource = "BackupBucket"

// +genclient
// +genclient:nonNamespaced
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// BackupBucket is a specification for backup bucket.
type BackupBucket struct {
	metav1.TypeMeta `json:",inline"`
	// +optional
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   BackupBucketSpec   `json:"spec"`
	Status BackupBucketStatus `json:"status"`
}

// GetExtensionSpec implements Object.
func (i *BackupBucket) GetExtensionSpec() Spec {
	return &i.Spec
}

// GetExtensionStatus implements Object.
func (i *BackupBucket) GetExtensionStatus() Status {
	return &i.Status
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// BackupBucketList is a list of BackupBucket resources.
type BackupBucketList struct {
	metav1.TypeMeta `json:",inline"`
	// +optional
	metav1.ListMeta `json:"metadata,omitempty"`

	// Items is the list of BackupBucket.
	Items []BackupBucket `json:"items"`
}

// BackupBucketSpec is the spec for an BackupBucket resource.
type BackupBucketSpec struct {
	// DefaultSpec is a structure containing common fields used by all extension resources.
	DefaultSpec `json:",inline"`
	// Region is the region of this bucket.
	Region string `json:"region"`
	// SecretRef is a reference to a secret that contains the credentials to access object store.
	SecretRef corev1.SecretReference `json:"secretRef"`
}

// BackupBucketStatus is the status for an BackupBucket resource.
type BackupBucketStatus struct {
	// DefaultStatus is a structure containing common fields used by all extension resources.
	DefaultStatus `json:",inline"`
	// GeneratedSecretRef is reference to the secret generated by backup bucket, which
	// will have object store specific credentials.
	// +optional
	GeneratedSecretRef *corev1.SecretReference `json:"generatedSecretRef,omitempty"`
}
