/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	acmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
	scheme "github.com/cert-manager/cert-manager/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// OrdersGetter has a method to return a OrderInterface.
// A group's client should implement this interface.
type OrdersGetter interface {
	Orders(namespace string) OrderInterface
}

// OrderInterface has methods to work with Order resources.
type OrderInterface interface {
	Create(ctx context.Context, order *acmev1.Order, opts metav1.CreateOptions) (*acmev1.Order, error)
	Update(ctx context.Context, order *acmev1.Order, opts metav1.UpdateOptions) (*acmev1.Order, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, order *acmev1.Order, opts metav1.UpdateOptions) (*acmev1.Order, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*acmev1.Order, error)
	List(ctx context.Context, opts metav1.ListOptions) (*acmev1.OrderList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *acmev1.Order, err error)
	OrderExpansion
}

// orders implements OrderInterface
type orders struct {
	*gentype.ClientWithList[*acmev1.Order, *acmev1.OrderList]
}

// newOrders returns a Orders
func newOrders(c *AcmeV1Client, namespace string) *orders {
	return &orders{
		gentype.NewClientWithList[*acmev1.Order, *acmev1.OrderList](
			"orders",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *acmev1.Order { return &acmev1.Order{} },
			func() *acmev1.OrderList { return &acmev1.OrderList{} },
		),
	}
}
