/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	kopsv1alpha2 "k8s.io/kops/pkg/apis/kops/v1alpha2"
	scheme "k8s.io/kops/pkg/client/clientset_generated/clientset/scheme"
)

// HostsGetter has a method to return a HostInterface.
// A group's client should implement this interface.
type HostsGetter interface {
	Hosts(namespace string) HostInterface
}

// HostInterface has methods to work with Host resources.
type HostInterface interface {
	Create(ctx context.Context, host *kopsv1alpha2.Host, opts v1.CreateOptions) (*kopsv1alpha2.Host, error)
	Update(ctx context.Context, host *kopsv1alpha2.Host, opts v1.UpdateOptions) (*kopsv1alpha2.Host, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*kopsv1alpha2.Host, error)
	List(ctx context.Context, opts v1.ListOptions) (*kopsv1alpha2.HostList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *kopsv1alpha2.Host, err error)
	HostExpansion
}

// hosts implements HostInterface
type hosts struct {
	*gentype.ClientWithList[*kopsv1alpha2.Host, *kopsv1alpha2.HostList]
}

// newHosts returns a Hosts
func newHosts(c *KopsV1alpha2Client, namespace string) *hosts {
	return &hosts{
		gentype.NewClientWithList[*kopsv1alpha2.Host, *kopsv1alpha2.HostList](
			"hosts",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *kopsv1alpha2.Host { return &kopsv1alpha2.Host{} },
			func() *kopsv1alpha2.HostList { return &kopsv1alpha2.HostList{} },
		),
	}
}
