/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package internalversion

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	kops "k8s.io/kops/pkg/apis/kops"
	scheme "k8s.io/kops/pkg/client/clientset_generated/clientset/scheme"
)

// InstanceGroupsGetter has a method to return a InstanceGroupInterface.
// A group's client should implement this interface.
type InstanceGroupsGetter interface {
	InstanceGroups(namespace string) InstanceGroupInterface
}

// InstanceGroupInterface has methods to work with InstanceGroup resources.
type InstanceGroupInterface interface {
	Create(ctx context.Context, instanceGroup *kops.InstanceGroup, opts v1.CreateOptions) (*kops.InstanceGroup, error)
	Update(ctx context.Context, instanceGroup *kops.InstanceGroup, opts v1.UpdateOptions) (*kops.InstanceGroup, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*kops.InstanceGroup, error)
	List(ctx context.Context, opts v1.ListOptions) (*kops.InstanceGroupList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *kops.InstanceGroup, err error)
	InstanceGroupExpansion
}

// instanceGroups implements InstanceGroupInterface
type instanceGroups struct {
	*gentype.ClientWithList[*kops.InstanceGroup, *kops.InstanceGroupList]
}

// newInstanceGroups returns a InstanceGroups
func newInstanceGroups(c *KopsClient, namespace string) *instanceGroups {
	return &instanceGroups{
		gentype.NewClientWithList[*kops.InstanceGroup, *kops.InstanceGroupList](
			"instancegroups",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *kops.InstanceGroup { return &kops.InstanceGroup{} },
			func() *kops.InstanceGroupList { return &kops.InstanceGroupList{} },
		),
	}
}
