## Release notes for kOps 1.20 series

# Significant changes

* Default container runtime is now set to `containerd` for new clusters running Kubernetes 1.20.0+.

* Added experimental Azure support. To get started check the [docs](https://kops.sigs.k8s.io/getting_started/azure/)

* Default settings for AWS instances are updated to take advantage of recent performance and security features:
    * Default etcd volumes encryption changes to enabled for newly created clusters
    * Default root volume encryption changes to enabled
    * Default etcd volumes type changes from `gp2` to `gp3`
    * Default root volume type changes from `gp2` to `gp3`

* Added [template funtions](https://kops.sigs.k8s.io/operations/cluster_template/#template-functions) for kubernetes version based on channel data.

* kOps now use helm3 functions for merging template `--set` and `--values` arguments. This has slightly different behaviour than previous helm2-like logic.

* Following kubeadm, control plane nodes are now labelled with `node-role.kubernetes.io/control-plane=""`

* Default node image for GCE changed from COS to Ubuntu for K8s versions >= 1.18.0. This is to more closely align with the AWS implementation (the most mature support) and because COS limits the ability to modify files on its disk.

# Breaking changes

* Support for Kubernetes 1.11 and 1.12 has been removed.

* Support for Terraform version 0.11 has been removed.

* Support for the feature flag `Terraform-0.12` has been removed.  All generated Terraform HCL2/JSON files will support versions `0.12.26+` and `0.13.0+`.

# Required Actions

* If you are using the Calico network plugin in a cross-subnet setup, you may have to manually remove the AWS Source/Dest Check controller (`k8s-ec2-srcdst`) deployment that was previously deprecated and replaced with the new [awsSrcDstCheck](https://docs.projectcalico.org/reference/resources/felixconfig#spec) feature.

* If you are using self-hosted channels files, you have to add the new `architectureID` field, with one of the `amd64` or `arm64` values.

* If you are running `kops toolbox template` in an airgapped environment, you have to set `--channel` to point to a local channel file.

* If your workload targets control plane nodes, you need to change them to select the `node-role.kubernetes.io/control-plane=""` label. You should also add the `node-role.kubernetes.io/control-plane:NoSchedule` toleration to these workloads. This taint will not be added to control plane nodes before kOps 1.22.

# Deprecations

* Support for Kubernetes versions 1.13 and 1.14 are deprecated and will be removed in kOps 1.21.

* The [manifest based metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) has been deprecated in favour of a configurable addon.

* The [manifest based cluster autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler) has been deprecated in favour of a configurable addon.

* The `node-role.kubernetes.io/master` and `kubernetes.io/role` labels are deprecated and will be removed from control plane nodes in kOps 1.22

* The experimental node-authorizer that could be enabled using `nodeAuthorization` has been removed. Setting this value is now forbidden.

* Due to lack of maintainers, the Aliyun/Alibaba Cloud support has been deprecated. The current implementation will be left as-is until the implementation needs updates or otherwise becomes incompatible. At that point, it will be removed. We very much welcome anyone willing to contribute to this cloud provider.

* Support for AWS LaunchConfiguration has been deprecated and will be removed in kOps 1.21.

# Full change list since 1.19.0 release

## 1.19.0-beta.3 to 1.20.0-alpha.1

* Update docs for cutting new release branches [@rifelpet](https://github.com/rifelpet) [#10084](https://github.com/kubernetes/kops/pull/10084)
* Update security_groups.md [@yurrriq](https://github.com/yurrriq) [#10078](https://github.com/kubernetes/kops/pull/10078)
* Take node labels from cloud tags on AWS [@johngmyers](https://github.com/johngmyers) [#9575](https://github.com/kubernetes/kops/pull/9575)
* Update Office Hours Zoom link [@johngmyers](https://github.com/johngmyers) [#10087](https://github.com/kubernetes/kops/pull/10087)
* Update zoom links on the spanish README [@rdrgmnzs](https://github.com/rdrgmnzs) [#10088](https://github.com/kubernetes/kops/pull/10088)
* Ignore changes to ForAPIServer field [@justinsb](https://github.com/justinsb) [#10086](https://github.com/kubernetes/kops/pull/10086)
* Update Flannel CNI to v0.13.0 [@hakman](https://github.com/hakman) [#10064](https://github.com/kubernetes/kops/pull/10064)
* kubetest2 - Implement create/validate/delete cluster functionality [@rifelpet](https://github.com/rifelpet) [#10083](https://github.com/kubernetes/kops/pull/10083)
* Cert circular deps [@olemarkus](https://github.com/olemarkus) [#10092](https://github.com/kubernetes/kops/pull/10092)
* Fix cilium template by specifying boolean as a string for enable-metrics [@h3poteto](https://github.com/h3poteto) [#10094](https://github.com/kubernetes/kops/pull/10094)
* Release notes for 1.18.2 [@justinsb](https://github.com/justinsb) [#10097](https://github.com/kubernetes/kops/pull/10097)
* Update Kops Go build supported versions 1.15 [@bmelbourne](https://github.com/bmelbourne) [#10099](https://github.com/kubernetes/kops/pull/10099)
* Spotinst: Bump the Spot Cluster Controller to 1.0.68 [@liranp](https://github.com/liranp) [#10103](https://github.com/kubernetes/kops/pull/10103)
* Remove hack/workaround from etcd-manager certificate expiration advisory [@hakman](https://github.com/hakman) [#10102](https://github.com/kubernetes/kops/pull/10102)
* Install container runtime packages as assets [@hakman](https://github.com/hakman) [#10048](https://github.com/kubernetes/kops/pull/10048)
* Default to exporting a kubecfg, even without credentials [@justinsb](https://github.com/justinsb) [#10105](https://github.com/kubernetes/kops/pull/10105)
* Remove dependency of TerraformJSON feature flag [@johngmyers](https://github.com/johngmyers) [#10106](https://github.com/kubernetes/kops/pull/10106)
* Makefile and hack script cleanup [@rifelpet](https://github.com/rifelpet) [#10112](https://github.com/kubernetes/kops/pull/10112)
* Update channels [@hakman](https://github.com/hakman) [#10117](https://github.com/kubernetes/kops/pull/10117)
* Update Calico config for eBPF mode [@hakman](https://github.com/hakman) [#10115](https://github.com/kubernetes/kops/pull/10115)
* Add random AWS zone logic + specify build stage location [@rifelpet](https://github.com/rifelpet) [#10121](https://github.com/kubernetes/kops/pull/10121)
* Update AWS VPC CNI to 1.7.5 [@MoShitrit](https://github.com/MoShitrit) [#10124](https://github.com/kubernetes/kops/pull/10124)
* Add nodeLocalDNSCache.kubeDnsOnly option [@javipolo](https://github.com/javipolo) [#10111](https://github.com/kubernetes/kops/pull/10111)
* Align AWS VPC CNI manifest with upstream [@hakman](https://github.com/hakman) [#10126](https://github.com/kubernetes/kops/pull/10126)
* Fix release notes links to point to https://kops.sigs.k8s [@hakman](https://github.com/hakman) [#10118](https://github.com/kubernetes/kops/pull/10118)
* Add verify-cloudformation script [@rifelpet](https://github.com/rifelpet) [#10130](https://github.com/kubernetes/kops/pull/10130)
* Fix cloudformation lint errors [@rifelpet](https://github.com/rifelpet) [#10131](https://github.com/kubernetes/kops/pull/10131)
* Update shell style for CLI docs for better compatibility [@hakman](https://github.com/hakman) [#10128](https://github.com/kubernetes/kops/pull/10128)
* Prevent unintended resource updates to LB attatchments [@rdrgmnzs](https://github.com/rdrgmnzs) [#9794](https://github.com/kubernetes/kops/pull/9794)
* Make verify-cloudformation job fail when issues are found [@rifelpet](https://github.com/rifelpet) [#10133](https://github.com/kubernetes/kops/pull/10133)
* Set minimum Terraform version to 0.12.26/0.13.0 [@bmelbourne](https://github.com/bmelbourne) [#10109](https://github.com/kubernetes/kops/pull/10109)
* ELB/TargetGroup/ASG attachment fixes [@rifelpet](https://github.com/rifelpet) [#10138](https://github.com/kubernetes/kops/pull/10138)
* Prepare for version 1.20 [@johngmyers](https://github.com/johngmyers) [#10101](https://github.com/kubernetes/kops/pull/10101)
* Rebrand kops to kOps [@hakman](https://github.com/hakman) [#10077](https://github.com/kubernetes/kops/pull/10077)
* Remove code for no-longer-supported k8s releases [@johngmyers](https://github.com/johngmyers) [#10141](https://github.com/kubernetes/kops/pull/10141)
* allow reauth for openstack client [@zetaab](https://github.com/zetaab) [#10144](https://github.com/kubernetes/kops/pull/10144)
* Simplify etcd options builder [@hakman](https://github.com/hakman) [#10145](https://github.com/kubernetes/kops/pull/10145)
* Update AWS Cloudmock for complex and externallb integration test clusters [@rifelpet](https://github.com/rifelpet) [#10140](https://github.com/kubernetes/kops/pull/10140)
* Deprecate field calico.majorVersion [@hakman](https://github.com/hakman) [#10143](https://github.com/kubernetes/kops/pull/10143)
* [Digital Ocean] Use Debian10 as default image [@srikiz](https://github.com/srikiz) [#10098](https://github.com/kubernetes/kops/pull/10098)
* Fix NLB naming for terraform and cloudformation targets [@rifelpet](https://github.com/rifelpet) [#10158](https://github.com/kubernetes/kops/pull/10158)
* Move NLB's VPC CIDR security group rule logic into model [@rifelpet](https://github.com/rifelpet) [#10161](https://github.com/kubernetes/kops/pull/10161)
* Fix additionalSecurityGroups support for NLB [@rifelpet](https://github.com/rifelpet) [#10162](https://github.com/kubernetes/kops/pull/10162)
* Some typos [@Hellcatlk](https://github.com/Hellcatlk) [#10160](https://github.com/kubernetes/kops/pull/10160)
* Fix output for CF and TF [@hakman](https://github.com/hakman) [#10164](https://github.com/kubernetes/kops/pull/10164)
* Avoid waiting on validation during rolling update for inapplicable instance groups [@bharath-123](https://github.com/bharath-123) [#10065](https://github.com/kubernetes/kops/pull/10065)
* OpenStack Reset deviceID status if needed [@zetaab](https://github.com/zetaab) [#10178](https://github.com/kubernetes/kops/pull/10178)
* Remove unused bearer token field from kubeconfig builder [@rifelpet](https://github.com/rifelpet) [#10181](https://github.com/kubernetes/kops/pull/10181)
* Compare KubernetesAPIAccess to OpenStack allowedCIDRs deterministically [@havulv](https://github.com/havulv) [#10186](https://github.com/kubernetes/kops/pull/10186)
* Consistent naming of security group rules [@olemarkus](https://github.com/olemarkus) [#10179](https://github.com/kubernetes/kops/pull/10179)
* Upgrade Hashicorp HCLv2 Go module v2.7.0 [@bmelbourne](https://github.com/bmelbourne) [#10189](https://github.com/kubernetes/kops/pull/10189)
* Fix auto scaling group changes when using spot instances [@hakman](https://github.com/hakman) [#10187](https://github.com/kubernetes/kops/pull/10187)
* Upgrade sprig to v3 [@olemarkus](https://github.com/olemarkus) [#10191](https://github.com/kubernetes/kops/pull/10191)
* Upgrade helm to 2.17 and use the helm.sh reference [@olemarkus](https://github.com/olemarkus) [#10192](https://github.com/kubernetes/kops/pull/10192)
* Fix AWS NLB reconciliation [@hakman](https://github.com/hakman) [#10199](https://github.com/kubernetes/kops/pull/10199)
* Fix disabling spot instances when using launch templates [@hakman](https://github.com/hakman) [#10198](https://github.com/kubernetes/kops/pull/10198)
* Add ACM cert permalink [@rifelpet](https://github.com/rifelpet) [#10156](https://github.com/kubernetes/kops/pull/10156)
*  Setup a second NLB listener when an AWS ACM certificate is used [@rifelpet](https://github.com/rifelpet),[@hakman](https://github.com/hakman) [#10157](https://github.com/kubernetes/kops/pull/10157)
* Update Go to v1.15.4 [@hakman](https://github.com/hakman) [#10209](https://github.com/kubernetes/kops/pull/10209)
* Upgrade docker client [@olemarkus](https://github.com/olemarkus) [#10193](https://github.com/kubernetes/kops/pull/10193)
* Spotinst: Configure Resource Limits in Ocean Auto Scaler [@liranp](https://github.com/liranp) [#10190](https://github.com/kubernetes/kops/pull/10190)
* Release notes 1.19.0-beta.1 [@hakman](https://github.com/hakman) [#10213](https://github.com/kubernetes/kops/pull/10213)
* Use LaunchTemplate versions instead of timestamped LaunchTemplates [@hakman](https://github.com/hakman) [#10151](https://github.com/kubernetes/kops/pull/10151)
* Update kOps version after 1.19.0-beta.1 release [@hakman](https://github.com/hakman) [#10216](https://github.com/kubernetes/kops/pull/10216)
* Remove components from cluster validation [@johngmyers](https://github.com/johngmyers) [#10214](https://github.com/kubernetes/kops/pull/10214)
* Allow to use custom csi plugin image and enable topology support [@zetaab](https://github.com/zetaab) [#10215](https://github.com/kubernetes/kops/pull/10215)
* Update validate cluster cli docs [@johngmyers](https://github.com/johngmyers) [#10219](https://github.com/kubernetes/kops/pull/10219)
* Fix cluster autoscaler docs [@djablonski-moia](https://github.com/djablonski-moia) [#10225](https://github.com/kubernetes/kops/pull/10225)
* Make etcd-manager log verbosity configurable [@elblivion](https://github.com/elblivion) [#10194](https://github.com/kubernetes/kops/pull/10194)
* Update k8s versions nov 2020 [@MoShitrit](https://github.com/MoShitrit) [#10227](https://github.com/kubernetes/kops/pull/10227)
* Update Ubuntu ami to latest version [@MoShitrit](https://github.com/MoShitrit) [#10195](https://github.com/kubernetes/kops/pull/10195)
* Fix various nits [@hakman](https://github.com/hakman) [#10217](https://github.com/kubernetes/kops/pull/10217)
* Switch ARM64 CI to Graviton2 CPU [@hakman](https://github.com/hakman) [#10230](https://github.com/kubernetes/kops/pull/10230)
* Update docs related to audit logging [@hakman](https://github.com/hakman) [#10231](https://github.com/kubernetes/kops/pull/10231)
* Don't install the misc packages for k8s 1.20+ [@johngmyers](https://github.com/johngmyers) [#10222](https://github.com/kubernetes/kops/pull/10222)
* Fix readme [@karancode](https://github.com/karancode) [#10228](https://github.com/kubernetes/kops/pull/10228)
* Update kops as kOps and remove extra spaces from .md files [@axpraka](https://github.com/axpraka),[@hakman](https://github.com/hakman) [#10235](https://github.com/kubernetes/kops/pull/10235)
* Add default runtime and runtimes fields in the docker config [@bharath-123](https://github.com/bharath-123) [#10238](https://github.com/kubernetes/kops/pull/10238)
* Fix cluster validation dependency on local kubeconfig [@eddycharly](https://github.com/eddycharly) [#10221](https://github.com/kubernetes/kops/pull/10221)
* Associate instance group to pod validation failures in cluster validation. [@bharath-123](https://github.com/bharath-123) [#10237](https://github.com/kubernetes/kops/pull/10237)
* Add HPA Flags for `horizontal-pod-autoscaler-initial-readiness-delay` & `horizontal-pod-autoscaler-cpu-initialization-period` [@JoelBCarter](https://github.com/JoelBCarter) [#10241](https://github.com/kubernetes/kops/pull/10241)
* Remove more code specific to unsupported etcd v2 [@johngmyers](https://github.com/johngmyers) [#10245](https://github.com/kubernetes/kops/pull/10245)
* GCE: ignore (output-only) networkInterface.name [@justinsb](https://github.com/justinsb) [#10242](https://github.com/kubernetes/kops/pull/10242)
* Make it possible to use OnDelete update strategy on addon daemonset [@olemarkus](https://github.com/olemarkus) [#10167](https://github.com/kubernetes/kops/pull/10167)
* Fix version of storage-aws addon manifest [@johngmyers](https://github.com/johngmyers) [#10247](https://github.com/kubernetes/kops/pull/10247)
* Fix cloudformation lint job [@rifelpet](https://github.com/rifelpet) [#10256](https://github.com/kubernetes/kops/pull/10256)
* Update etcd-manager to 3.0.20201117 [@justinsb](https://github.com/justinsb) [#10257](https://github.com/kubernetes/kops/pull/10257)
* Use separate domain for kops-controller bootstrap [@johngmyers](https://github.com/johngmyers) [#10239](https://github.com/kubernetes/kops/pull/10239)
* Revert "Switch ARM64 CI to Graviton2 CPU" [@hakman](https://github.com/hakman) [#10262](https://github.com/kubernetes/kops/pull/10262)
* Update Bazel rules for Go to v0.24.7 [@hakman](https://github.com/hakman) [#10240](https://github.com/kubernetes/kops/pull/10240)
* Update k8s dependencies to 1.20.0-beta.2 [@rifelpet](https://github.com/rifelpet) [#10266](https://github.com/kubernetes/kops/pull/10266)
* Push multi-arch images [@hakman](https://github.com/hakman) [#10265](https://github.com/kubernetes/kops/pull/10265)
* alpha channel: update legacy images [@justinsb](https://github.com/justinsb) [#10269](https://github.com/kubernetes/kops/pull/10269)
* Fix multi-arch image pushing [@hakman](https://github.com/hakman) [#10270](https://github.com/kubernetes/kops/pull/10270)
* Add sslPolicy for NLB to change listener's security policy [@FrankYang0529](https://github.com/FrankYang0529) [#9666](https://github.com/kubernetes/kops/pull/9666)
* Optimize Bazel builds by os and arch [@hakman](https://github.com/hakman) [#10267](https://github.com/kubernetes/kops/pull/10267)
* Fix incorrect URLs in kops cluster documentation [@bycEEE](https://github.com/bycEEE) [#10274](https://github.com/kubernetes/kops/pull/10274)
* Use etcd v3.4.13 for k8s v1.19+ [@hakman](https://github.com/hakman) [#10277](https://github.com/kubernetes/kops/pull/10277)
* Parse TargetGroup names from ARNs [@hakman](https://github.com/hakman) [#10276](https://github.com/kubernetes/kops/pull/10276)
* Add Go code-generator v0.20.0-beta.2 crypto hash [@bmelbourne](https://github.com/bmelbourne) [#10285](https://github.com/kubernetes/kops/pull/10285)
* Add ACM/NLB instructions to 1.19 release notes [@rifelpet](https://github.com/rifelpet) [#10292](https://github.com/kubernetes/kops/pull/10292)
* Release notes for 1.19.0-beta.2 [@hakman](https://github.com/hakman) [#10293](https://github.com/kubernetes/kops/pull/10293)
* Add more NLB release notes and documentation [@rifelpet](https://github.com/rifelpet) [#10294](https://github.com/kubernetes/kops/pull/10294)
* Can check cert expiry using openssl [@alok87](https://github.com/alok87),[@hakman](https://github.com/hakman) [#10282](https://github.com/kubernetes/kops/pull/10282)
* [weave] Add support for default version override [@dntosas](https://github.com/dntosas),[@hakman](https://github.com/hakman) [#10273](https://github.com/kubernetes/kops/pull/10273)
* Add support of Azure Blob storage to VFS [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#10258](https://github.com/kubernetes/kops/pull/10258)
* Update kOps version after 1.19.0-beta.2 release [@hakman](https://github.com/hakman) [#10295](https://github.com/kubernetes/kops/pull/10295)
* Remove support for using legacy ELB name [@hakman](https://github.com/hakman) [#10296](https://github.com/kubernetes/kops/pull/10296)
* Remove dead code [@hakman](https://github.com/hakman) [#10297](https://github.com/kubernetes/kops/pull/10297)
* Remove support for disabling manifest normalization [@johngmyers](https://github.com/johngmyers) [#10298](https://github.com/kubernetes/kops/pull/10298)
* Upgrade cloud-provider-openstack to 1.19.2 [@rifelpet](https://github.com/rifelpet) [#10303](https://github.com/kubernetes/kops/pull/10303)
* Fix a typo in an error message returned from buildAzureBlobPath [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#10305](https://github.com/kubernetes/kops/pull/10305)
* Allow setting CPU limit and Mem request / limit for kube API server [@rdrgmnzs](https://github.com/rdrgmnzs) [#10275](https://github.com/kubernetes/kops/pull/10275)
* Optimize Bazel dev builds by arch [@hakman](https://github.com/hakman) [#10309](https://github.com/kubernetes/kops/pull/10309)
* Update Calico to v3.17.0 [@hakman](https://github.com/hakman) [#10310](https://github.com/kubernetes/kops/pull/10310)
* [Digital Ocean] Upgrade godo sdk to v1.54 [@srikiz](https://github.com/srikiz) [#10320](https://github.com/kubernetes/kops/pull/10320)
* Tolerate missing detached EC2 instances [@hwoarang](https://github.com/hwoarang) [#10319](https://github.com/kubernetes/kops/pull/10319)
* Don't try to detach masters [@olemarkus](https://github.com/olemarkus) [#10328](https://github.com/kubernetes/kops/pull/10328)
* Remove copyright notice from nodeup scripts to reduce the user-data size. [@rdrgmnzs](https://github.com/rdrgmnzs) [#10333](https://github.com/kubernetes/kops/pull/10333)
* Add docs for metrics server [@olemarkus](https://github.com/olemarkus) [#10332](https://github.com/kubernetes/kops/pull/10332)
* Push alpha to stable [@MoShitrit](https://github.com/MoShitrit) [#10336](https://github.com/kubernetes/kops/pull/10336)
* Add paramaeters related to Taint based Evictions in kube-apiserver [@h3poteto](https://github.com/h3poteto) [#10339](https://github.com/kubernetes/kops/pull/10339)
* Allow using gp3 for root volumes [@olemarkus](https://github.com/olemarkus) [#10345](https://github.com/kubernetes/kops/pull/10345)
* Update containerd and Docker versions [@hakman](https://github.com/hakman) [#10341](https://github.com/kubernetes/kops/pull/10341)
* Update aws-sdk-go to v1.36.0 [@hakman](https://github.com/hakman) [#10347](https://github.com/kubernetes/kops/pull/10347)
* Bump aws-vpc-cni version to 1.7.6 [@MoShitrit](https://github.com/MoShitrit) [#10337](https://github.com/kubernetes/kops/pull/10337)
* Update etcd-manager to 3.0.20201202 [@justinsb](https://github.com/justinsb) [#10351](https://github.com/kubernetes/kops/pull/10351)
* Update DigitalOcean cloud-controller-manager to v0.1.30 [@timoreimann](https://github.com/timoreimann) [#10352](https://github.com/kubernetes/kops/pull/10352)
* Add aws-cloud-controller-manager config to addons [@nckturner](https://github.com/nckturner) [#9704](https://github.com/kubernetes/kops/pull/9704)
* Allow attaching same external target group to multiple instance groups [@hakman](https://github.com/hakman) [#10335](https://github.com/kubernetes/kops/pull/10335)
* Add fuzzer and OSS-fuzz build script [@AdamKorcz](https://github.com/AdamKorcz) [#10326](https://github.com/kubernetes/kops/pull/10326)
* Set --service-account-issuer for k8s 1.20+ [@johngmyers](https://github.com/johngmyers) [#10284](https://github.com/kubernetes/kops/pull/10284)
* Promote addon docs to first level menu item [@olemarkus](https://github.com/olemarkus) [#10355](https://github.com/kubernetes/kops/pull/10355)
* [Digital Ocean] Promote to Beta [@srikiz](https://github.com/srikiz) [#10312](https://github.com/kubernetes/kops/pull/10312)
* Give users the option to gzip and base64 encode the heredocs in the nodeup.sh user-data [@rdrgmnzs](https://github.com/rdrgmnzs) [#10357](https://github.com/kubernetes/kops/pull/10357)
* Add integration test for creating an HA cluster in shared zone [@hakman](https://github.com/hakman) [#10365](https://github.com/kubernetes/kops/pull/10365)
* Add minimal cert-manager addon [@olemarkus](https://github.com/olemarkus) [#10318](https://github.com/kubernetes/kops/pull/10318)
* Add option to reuse existing Elastic IPs for NAT gateways [@hakman](https://github.com/hakman) [#10374](https://github.com/kubernetes/kops/pull/10374)
* Remove resource limits from cluster autoscaler [@olemarkus](https://github.com/olemarkus) [#10375](https://github.com/kubernetes/kops/pull/10375)
* Remove dependency on TravisCI [@hakman](https://github.com/hakman) [#10366](https://github.com/kubernetes/kops/pull/10366)
* fix cluster-autoscaler README url from cluster_spec -> addons [@isaachui](https://github.com/isaachui) [#10373](https://github.com/kubernetes/kops/pull/10373)
* Rename duplicate ci target to quick-ci [@hakman](https://github.com/hakman) [#10378](https://github.com/kubernetes/kops/pull/10378)
* Use custom-configured ServiceAccountIssuer when present [@johngmyers](https://github.com/johngmyers) [#10364](https://github.com/kubernetes/kops/pull/10364)
* Add option for setting the volume encryption key in AWS [@hakman](https://github.com/hakman) [#10359](https://github.com/kubernetes/kops/pull/10359)
* Add support for AWS IMDS v2 [@bharath-123](https://github.com/bharath-123) [#10324](https://github.com/kubernetes/kops/pull/10324)
* Update k8s dependencies to v1.20.0 [@hakman](https://github.com/hakman) [#10390](https://github.com/kubernetes/kops/pull/10390)
* Update docs for CentOS 8 [@hakman](https://github.com/hakman) [#10368](https://github.com/kubernetes/kops/pull/10368)
* Move tools into separate `hack` go module [@rifelpet](https://github.com/rifelpet) [#10308](https://github.com/kubernetes/kops/pull/10308)
* Update etcd-manager to 20201209 [@justinsb](https://github.com/justinsb) [#10394](https://github.com/kubernetes/kops/pull/10394)
* Mount /lib64 for Protokube only on AMD64 [@hakman](https://github.com/hakman) [#10396](https://github.com/kubernetes/kops/pull/10396)
* Explicitly specify http_endpoint in terraform launch template [@bharath-123](https://github.com/bharath-123) [#10398](https://github.com/kubernetes/kops/pull/10398)
* Update alpha channel with December 2020 k8s releases and bump Ubuntu AMI version [@MoShitrit](https://github.com/MoShitrit) [#10401](https://github.com/kubernetes/kops/pull/10401)
* Hack script improvements [@rifelpet](https://github.com/rifelpet) [#10407](https://github.com/kubernetes/kops/pull/10407)
* hack/goimports - Replace mapfile with read [@rifelpet](https://github.com/rifelpet) [#10410](https://github.com/kubernetes/kops/pull/10410)
* Allow override of registry and tag for Calico images [@hakman](https://github.com/hakman) [#10316](https://github.com/kubernetes/kops/pull/10316)
* Update Calico to v3.17.1 [@hakman](https://github.com/hakman) [#10408](https://github.com/kubernetes/kops/pull/10408)
* Bump aws-cni to 1.7.7 [@MoShitrit](https://github.com/MoShitrit) [#10416](https://github.com/kubernetes/kops/pull/10416)
* Add support for containerd v1.4.3 ARM64 [@hakman](https://github.com/hakman) [#10418](https://github.com/kubernetes/kops/pull/10418)
* Add release note for terraform launch template migration [@rifelpet](https://github.com/rifelpet) [#10423](https://github.com/kubernetes/kops/pull/10423)
* Expose metrics port when PrometheusMetricsEnabled set to true in Calico [@avdhoot](https://github.com/avdhoot) [#10414](https://github.com/kubernetes/kops/pull/10414)
* Bump etcd client to 3.4.13. Use go modules [@olemarkus](https://github.com/olemarkus) [#10425](https://github.com/kubernetes/kops/pull/10425)
* Use the kubernetes-sigs version of yaml [@olemarkus](https://github.com/olemarkus) [#10427](https://github.com/kubernetes/kops/pull/10427)
* Bump heredoc to v2 [@olemarkus](https://github.com/olemarkus) [#10429](https://github.com/kubernetes/kops/pull/10429)
* Update container runtime service files [@hakman](https://github.com/hakman) [#10428](https://github.com/kubernetes/kops/pull/10428)
* Template functions for recommended kubernetes versions [@olemarkus](https://github.com/olemarkus) [#10369](https://github.com/kubernetes/kops/pull/10369)
* Make CoreDNS the default DNS server [@rajansandeep](https://github.com/rajansandeep) [#7919](https://github.com/kubernetes/kops/pull/7919)
* Delay defaulting to CoreDNS to k8s v1.20 [@hakman](https://github.com/hakman) [#10435](https://github.com/kubernetes/kops/pull/10435)
* Bump go-bindata and use go module [@olemarkus](https://github.com/olemarkus) [#10421](https://github.com/kubernetes/kops/pull/10421)
* Bump sftp to 1.12 [@olemarkus](https://github.com/olemarkus) [#10436](https://github.com/kubernetes/kops/pull/10436)
* IAM ServiceAccount Roles: truncate name at 64 characters [@justinsb](https://github.com/justinsb) [#10437](https://github.com/kubernetes/kops/pull/10437)
* Bump helm to v3 [@olemarkus](https://github.com/olemarkus) [#10426](https://github.com/kubernetes/kops/pull/10426)
* cloudmock - guard the VPC CIDR association calls with a mutex [@rifelpet](https://github.com/rifelpet) [#10440](https://github.com/kubernetes/kops/pull/10440)
* Upgrade mkdocs dependencies to latest [@rifelpet](https://github.com/rifelpet) [#10433](https://github.com/kubernetes/kops/pull/10433)
* Spotinst: Schedule Ocean Controller to Linux nodes only [@liranp](https://github.com/liranp) [#10444](https://github.com/kubernetes/kops/pull/10444)
* Bump AWS-CNI to version 1.7.8 [@MoShitrit](https://github.com/MoShitrit) [#10447](https://github.com/kubernetes/kops/pull/10447)
* protokube - query host by label when setting tags [@rdrgmnzs](https://github.com/rdrgmnzs) [#10413](https://github.com/kubernetes/kops/pull/10413)
* Allow Calico to run on systems with loose reverse path forwarding [@hakman](https://github.com/hakman) [#10442](https://github.com/kubernetes/kops/pull/10442)
* Bump k8s versions on alpha and bump Ubuntu AMI version on stable [@MoShitrit](https://github.com/MoShitrit) [#10464](https://github.com/kubernetes/kops/pull/10464)
* Remove gjtempleton as reviewer [@gjtempleton](https://github.com/gjtempleton) [#10466](https://github.com/kubernetes/kops/pull/10466)
* Calico: Allow operators to choose which encapsulation mode to use [@seh](https://github.com/seh) [#10404](https://github.com/kubernetes/kops/pull/10404)
* Spotinst: Ignore volume type case sensitivity to prevent unnecessary updates [@liranp](https://github.com/liranp) [#10450](https://github.com/kubernetes/kops/pull/10450)
* Spotinst: Expose Ocean Headroom percentage and autoconfig labels [@liranp](https://github.com/liranp) [#10449](https://github.com/kubernetes/kops/pull/10449)
* Spotinst: Support for multiple subnets per zone [@liranp](https://github.com/liranp) [#10452](https://github.com/kubernetes/kops/pull/10452)
* Add new-pod-scale-up-delay in Cluster Autoscaler spec [@akshedu](https://github.com/akshedu) [#10471](https://github.com/kubernetes/kops/pull/10471)
* Replace (some) deprecated ResourceHolder with Resource [@justinsb](https://github.com/justinsb) [#10472](https://github.com/kubernetes/kops/pull/10472)
* Remove ResourceHolder: remove last usages and remove code [@justinsb](https://github.com/justinsb) [#10478](https://github.com/kubernetes/kops/pull/10478)
* Refactor MirroredAsset into mirrors package [@justinsb](https://github.com/justinsb) [#10475](https://github.com/kubernetes/kops/pull/10475)
* Refactor nodeUpConfigBuilder to be standalone [@justinsb](https://github.com/justinsb) [#10476](https://github.com/kubernetes/kops/pull/10476)
* Avoid recursive type definitions in schema [@justinsb](https://github.com/justinsb) [#10482](https://github.com/kubernetes/kops/pull/10482)
* Drop support for containerd 1.2 [@hakman](https://github.com/hakman) [#10483](https://github.com/kubernetes/kops/pull/10483)
* Update CNI plugins to v0.8.7 [@hakman](https://github.com/hakman) [#10481](https://github.com/kubernetes/kops/pull/10481)
* Add Azure support [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#10114](https://github.com/kubernetes/kops/pull/10114)
* Refactor GCE InstanceTemplate [@justinsb](https://github.com/justinsb) [#10477](https://github.com/kubernetes/kops/pull/10477)
* Use Region method of fi.Cloud [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#10474](https://github.com/kubernetes/kops/pull/10474)
* Spotinst: Bump the Ocean Controller to 1.0.69 [@liranp](https://github.com/liranp) [#10487](https://github.com/kubernetes/kops/pull/10487)
* Added event-qps and event-burst flags to kubelet [@DOboznyi](https://github.com/DOboznyi) [#10486](https://github.com/kubernetes/kops/pull/10486)
* Add config options for container runtime package URL and Hash [@hakman](https://github.com/hakman) [#10473](https://github.com/kubernetes/kops/pull/10473)
* Fix cluster setup when KOPS_ARCH is set [@hakman](https://github.com/hakman) [#10496](https://github.com/kubernetes/kops/pull/10496)
* Docs: Rename "Development" section to "Contributing" and add instructions to update the base AMI version of Ubuntu [@MoShitrit](https://github.com/MoShitrit) [#10455](https://github.com/kubernetes/kops/pull/10455)
* Release notes for 1.19.0-beta.3 [@hakman](https://github.com/hakman) [#10497](https://github.com/kubernetes/kops/pull/10497)
* Use containerd.sock for AmazonVPC CNI with containerd [@hakman](https://github.com/hakman) [#10502](https://github.com/kubernetes/kops/pull/10502)
* Remove support for Kubenet with containerd [@hakman](https://github.com/hakman) [#10501](https://github.com/kubernetes/kops/pull/10501)
* Add containerd option for registry mirrors [@hakman](https://github.com/hakman) [#10507](https://github.com/kubernetes/kops/pull/10507)
* Treat InvalidDhcpOptionsId.NotFound as already-deleted [@wongma7](https://github.com/wongma7) [#10508](https://github.com/kubernetes/kops/pull/10508)
* Add required toleration to gpu documentation [@silashansen](https://github.com/silashansen) [#10509](https://github.com/kubernetes/kops/pull/10509)
* AWS IAM Role Tagging [@rifelpet](https://github.com/rifelpet) [#10488](https://github.com/kubernetes/kops/pull/10488)
* Update stable channel with recent k8s releases [@MoShitrit](https://github.com/MoShitrit) [#10514](https://github.com/kubernetes/kops/pull/10514)
* Run k/k's e2e suite via new kubetest2 make target [@rifelpet](https://github.com/rifelpet) [#10504](https://github.com/kubernetes/kops/pull/10504)
* Remove copyright YEAR from generated Go files [@bmelbourne](https://github.com/bmelbourne) [#10520](https://github.com/kubernetes/kops/pull/10520)
* e2e - dump cluster manifests into artifacts and add --kubernetes-version  [@rifelpet](https://github.com/rifelpet) [#10522](https://github.com/kubernetes/kops/pull/10522)
* kubetest2: Pass through some AWS env vars [@justinsb](https://github.com/justinsb) [#10525](https://github.com/kubernetes/kops/pull/10525)
* kubetest2: add initial support for GCE [@justinsb](https://github.com/justinsb) [#10524](https://github.com/kubernetes/kops/pull/10524)
* Add gp3 Volume Type to etcd [@msidwell](https://github.com/msidwell) [#10453](https://github.com/kubernetes/kops/pull/10453)
* Only include API server additional security groups in InstanceGroups for masters [@seh](https://github.com/seh) [#10519](https://github.com/kubernetes/kops/pull/10519)
* Update kube-router to v1.1.1 [@hakman](https://github.com/hakman) [#10512](https://github.com/kubernetes/kops/pull/10512)
* IRSA - continue adding route53 permisions to masters [@rifelpet](https://github.com/rifelpet) [#10529](https://github.com/kubernetes/kops/pull/10529)
* Add possibility to set volume throughput for gp3 volumes [@hakman](https://github.com/hakman) [#10530](https://github.com/kubernetes/kops/pull/10530)
* Prefix etcd cluster names with letters [@hakman](https://github.com/hakman) [#10361](https://github.com/kubernetes/kops/pull/10361)
* Recognize ubuntu 20.10 [@justinsb](https://github.com/justinsb) [#10278](https://github.com/kubernetes/kops/pull/10278)
* Don't allow ebs volume TF resource names to begin with digit [@rifelpet](https://github.com/rifelpet) [#10424](https://github.com/kubernetes/kops/pull/10424)
* Add K8s Docker runtime support deprecation release note [@bmelbourne](https://github.com/bmelbourne),[@hakman](https://github.com/hakman) [#10371](https://github.com/kubernetes/kops/pull/10371)
* Make it possible to change the etcd volume type and iops [@olemarkus](https://github.com/olemarkus) [#10461](https://github.com/kubernetes/kops/pull/10461)
* Promote Ole Markus to approvers list [@hakman](https://github.com/hakman) [#10542](https://github.com/kubernetes/kops/pull/10542)
* Add containerd config file to Flatcar based instances [@hakman](https://github.com/hakman) [#10540](https://github.com/kubernetes/kops/pull/10540)
* Add control-plane node role label to cp nodes [@olemarkus](https://github.com/olemarkus) [#10397](https://github.com/kubernetes/kops/pull/10397)
* Move bootstrapchannelbuilder to a dedicated package [@olemarkus](https://github.com/olemarkus) [#10409](https://github.com/kubernetes/kops/pull/10409)
* kubetest2: support specifying admin-access value [@justinsb](https://github.com/justinsb) [#10526](https://github.com/kubernetes/kops/pull/10526)
* GCE: Don't warn about NVME [@justinsb](https://github.com/justinsb) [#10548](https://github.com/kubernetes/kops/pull/10548)
* Simple upgrade test using kubetest2 framework [@justinsb](https://github.com/justinsb) [#10523](https://github.com/kubernetes/kops/pull/10523)
* Refactor and centralize distribution logic [@justinsb](https://github.com/justinsb) [#10538](https://github.com/kubernetes/kops/pull/10538)
* Fix to handle exit code of gazelle command in hack/verify-bazel.sh [@h3poteto](https://github.com/h3poteto) [#10182](https://github.com/kubernetes/kops/pull/10182)
* COS/GCE: exec on kubelet/flexvolume dirs [@justinsb](https://github.com/justinsb) [#10547](https://github.com/kubernetes/kops/pull/10547)
* Fix typo in comment [@fenggw-fnst](https://github.com/fenggw-fnst) [#10541](https://github.com/kubernetes/kops/pull/10541)
* Openstack: Prevent data race in servergroup member list [@justinsb](https://github.com/justinsb) [#10553](https://github.com/kubernetes/kops/pull/10553)
* Updates GCE channels to use ubuntu over COS [@geojaz](https://github.com/geojaz) [#10554](https://github.com/kubernetes/kops/pull/10554)
* Kubetest2 - use our own tester that wraps kubetest2's ginkgo tester [@rifelpet](https://github.com/rifelpet) [#10549](https://github.com/kubernetes/kops/pull/10549)
* Spotinst: Specify Spot percentage per Instance Group [@liranp](https://github.com/liranp) [#10551](https://github.com/kubernetes/kops/pull/10551)
* update gophercloud dependency [@zetaab](https://github.com/zetaab) [#10556](https://github.com/kubernetes/kops/pull/10556)
* Upgrade Go v1.15.6 / Bazel v3.4.1 [@bmelbourne](https://github.com/bmelbourne) [#10550](https://github.com/kubernetes/kops/pull/10550)
* Remove node-authorization [@olemarkus](https://github.com/olemarkus) [#10439](https://github.com/kubernetes/kops/pull/10439)
* [addons/CA] Add support for specifying resources and metrics [@dntosas](https://github.com/dntosas) [#10281](https://github.com/kubernetes/kops/pull/10281)
* Spotinst: Iterate over metadata labels only once [@liranp](https://github.com/liranp) [#10560](https://github.com/kubernetes/kops/pull/10560)
* Default cgroup driver to systemd from k8s 1.20 [@bharath-123](https://github.com/bharath-123) [#10419](https://github.com/kubernetes/kops/pull/10419)
* AWS CSI driver [@olemarkus](https://github.com/olemarkus) [#10467](https://github.com/kubernetes/kops/pull/10467)
* Upgrade cfn-lint to 0.44.3 [@rifelpet](https://github.com/rifelpet) [#10565](https://github.com/kubernetes/kops/pull/10565)
* Fix file not found error detection in fs://  [@rifelpet](https://github.com/rifelpet) [#10566](https://github.com/kubernetes/kops/pull/10566)
* Fix NLB listener -> target group association for TF & CF [@rifelpet](https://github.com/rifelpet) [#10567](https://github.com/kubernetes/kops/pull/10567)
* Spotinst: Bump the Ocean Controller to 1.0.70 [@liranp](https://github.com/liranp) [#10573](https://github.com/kubernetes/kops/pull/10573)
* Spotinst: Specify whether scale-down activities should be restricted [@liranp](https://github.com/liranp) [#10561](https://github.com/kubernetes/kops/pull/10561)
* [OpenStack] Use new hash format in instance names [@zetaab](https://github.com/zetaab) [#10557](https://github.com/kubernetes/kops/pull/10557)
* kubetest2 - Add manifest template support [@rifelpet](https://github.com/rifelpet) [#10559](https://github.com/kubernetes/kops/pull/10559)
* Updates to Alpha versions - k8s & kOps [@MoShitrit](https://github.com/MoShitrit) [#10576](https://github.com/kubernetes/kops/pull/10576)
* Use Bazel 3.4.1 for postsubmit jobs [@hakman](https://github.com/hakman) [#10578](https://github.com/kubernetes/kops/pull/10578)
* Give kubetest2 its own makefile [@rifelpet](https://github.com/rifelpet) [#10577](https://github.com/kubernetes/kops/pull/10577)
* Use consistent naming for the remaining SGRs part two [@olemarkus](https://github.com/olemarkus) [#10188](https://github.com/kubernetes/kops/pull/10188)
* [DigitalOcean] add e2e tests [@srikiz](https://github.com/srikiz) [#10575](https://github.com/kubernetes/kops/pull/10575)
* Allow nodeup (and others) to replace in-use files [@justinsb](https://github.com/justinsb) [#10581](https://github.com/kubernetes/kops/pull/10581)
* Dial-down logging on flagbuilder [@justinsb](https://github.com/justinsb) [#10582](https://github.com/kubernetes/kops/pull/10582)
* Fix default make target [@rifelpet](https://github.com/rifelpet) [#10584](https://github.com/kubernetes/kops/pull/10584)
* containerd: Add /etc/crictl config to enable crictl [@justinsb](https://github.com/justinsb) [#10585](https://github.com/kubernetes/kops/pull/10585)
* Add CF integration test for gp3 volumes [@hakman](https://github.com/hakman) [#10569](https://github.com/kubernetes/kops/pull/10569)
* Release 1.20.0-alpha.1 [@hakman](https://github.com/hakman) [#10591](https://github.com/kubernetes/kops/pull/10591)

## 1.20.0-alpha.1 to 1.20.0-alpha.2

* Release notes for 1.20.0-alpha.1 [@hakman](https://github.com/hakman) [#10592](https://github.com/kubernetes/kops/pull/10592)
* Make cluster proportional autoscaler image configurable. [@bjhaid](https://github.com/bjhaid) [#10564](https://github.com/kubernetes/kops/pull/10564)
* Set default container runtime to containerd [@bmelbourne](https://github.com/bmelbourne) [#10370](https://github.com/kubernetes/kops/pull/10370)
* Fix minor docs typos [@JamesJJ](https://github.com/JamesJJ) [#10598](https://github.com/kubernetes/kops/pull/10598)
* Validate cluster cloud labels [@olemarkus](https://github.com/olemarkus) [#10599](https://github.com/kubernetes/kops/pull/10599)
* Exclude terraform.lock.hcl files from Git repo [@bmelbourne](https://github.com/bmelbourne) [#10597](https://github.com/kubernetes/kops/pull/10597)
* Provide required --kubernetes-version flags to kubetest2-kops --up [@rifelpet](https://github.com/rifelpet) [#10600](https://github.com/kubernetes/kops/pull/10600)
* Kubetest - add networking support + misc fixes [@rifelpet](https://github.com/rifelpet) [#10601](https://github.com/kubernetes/kops/pull/10601)
* Require KOPS_TERRAFORM_0_12_RENAMED, to guard against tf breakage [@justinsb](https://github.com/justinsb),[@hakman](https://github.com/hakman) [#10602](https://github.com/kubernetes/kops/pull/10602)
* Add troubleshooting documentation [@olemarkus](https://github.com/olemarkus) [#10594](https://github.com/kubernetes/kops/pull/10594)
* Fix menu link to troubleshooting [@olemarkus](https://github.com/olemarkus) [#10607](https://github.com/kubernetes/kops/pull/10607)
* Use kops binary built by kubetest2-kops in upgrade script [@rifelpet](https://github.com/rifelpet) [#10613](https://github.com/kubernetes/kops/pull/10613)
* Warn if cilium encryption is enabled, but no secret has been set [@olemarkus](https://github.com/olemarkus) [#10608](https://github.com/kubernetes/kops/pull/10608)
* kubetest2 upgrade script - PATH needs to be a directory [@rifelpet](https://github.com/rifelpet) [#10617](https://github.com/kubernetes/kops/pull/10617)
* Add support for container-log-max-size/files with kubelet [@hakman](https://github.com/hakman) [#10612](https://github.com/kubernetes/kops/pull/10612)
* Add network and router availability zone hints to OpenStack [@ottosulin](https://github.com/ottosulin) [#10616](https://github.com/kubernetes/kops/pull/10616)
* Increase CoreDNS default ttl [@johanneswuerbach](https://github.com/johanneswuerbach) [#10610](https://github.com/kubernetes/kops/pull/10610)
* Update Go to v1.15.7 [@hakman](https://github.com/hakman) [#10614](https://github.com/kubernetes/kops/pull/10614)
* kubetest2 - Add support for specifying a kubernetes version marker file [@rifelpet](https://github.com/rifelpet) [#10620](https://github.com/kubernetes/kops/pull/10620)
* kubetest 2 - fix parsing of k8s version semver values [@rifelpet](https://github.com/rifelpet) [#10621](https://github.com/kubernetes/kops/pull/10621)
* Update Weave to v2.8.0 [@hakman](https://github.com/hakman) [#10604](https://github.com/kubernetes/kops/pull/10604)
* Update AWS instances defaults [@hakman](https://github.com/hakman) [#10624](https://github.com/kubernetes/kops/pull/10624)
* kubetest2 - update the skip regex for the upgrade scenario [@rifelpet](https://github.com/rifelpet) [#10626](https://github.com/kubernetes/kops/pull/10626)
* Install dbus if needed for protokube with containerd [@justinsb](https://github.com/justinsb) [#10583](https://github.com/kubernetes/kops/pull/10583)
* Ensure SpecOverrideFlag is set in upgrade test [@rifelpet](https://github.com/rifelpet) [#10628](https://github.com/kubernetes/kops/pull/10628)
* Fix unbound variable in upgrade scenario script [@rifelpet](https://github.com/rifelpet) [#10631](https://github.com/kubernetes/kops/pull/10631)
* kubetest2 - increase validation timeout for the upgrade scenario [@hakman](https://github.com/hakman) [#10632](https://github.com/kubernetes/kops/pull/10632)
* Add startup probe for calico-kube-controllers [@hakman](https://github.com/hakman) [#10633](https://github.com/kubernetes/kops/pull/10633)
* Remove coredns dnsprovider [@olemarkus](https://github.com/olemarkus) [#10629](https://github.com/kubernetes/kops/pull/10629)
* Spotinst: Avoid unnecessary duplication of tasks [@liranp](https://github.com/liranp) [#10630](https://github.com/kubernetes/kops/pull/10630)
* enableRemoteNodeIdentity actually defaults to true [@olemarkus](https://github.com/olemarkus) [#10635](https://github.com/kubernetes/kops/pull/10635)
* Replace gopkg yaml with k8s-sigs yaml [@olemarkus](https://github.com/olemarkus) [#10634](https://github.com/kubernetes/kops/pull/10634)
* protokube: Remove unused ExecuteTemplate function [@justinsb](https://github.com/justinsb) [#10637](https://github.com/kubernetes/kops/pull/10637)
* Fix phony make target for setting up kubetest2 [@rifelpet](https://github.com/rifelpet) [#10636](https://github.com/kubernetes/kops/pull/10636)
* [Digital Ocean] Add SFO3 region. Also update e2e tests to use full list of supported zones [@srikiz](https://github.com/srikiz) [#10622](https://github.com/kubernetes/kops/pull/10622)
* etcd-manager: Update to 3.0.20210122 [@justinsb](https://github.com/justinsb) [#10638](https://github.com/kubernetes/kops/pull/10638)
* Update k8s versions in stable channel and bump ubuntu ami version in alpha channel [@MoShitrit](https://github.com/MoShitrit) [#10639](https://github.com/kubernetes/kops/pull/10639)
* Update kubetest2 library [@rifelpet](https://github.com/rifelpet) [#10646](https://github.com/kubernetes/kops/pull/10646)
* feat: implement azure get api ingress status fn [@ngalantowicz](https://github.com/ngalantowicz) [#10609](https://github.com/kubernetes/kops/pull/10609)
* Use the same package marker for kubectl as for e2e binary [@rifelpet](https://github.com/rifelpet) [#10649](https://github.com/kubernetes/kops/pull/10649)
* Reword 'what is kOps' [@olemarkus](https://github.com/olemarkus) [#10570](https://github.com/kubernetes/kops/pull/10570)
* Add back support for kubenet style networking with containerd [@hakman](https://github.com/hakman) [#10651](https://github.com/kubernetes/kops/pull/10651)
* Add `set instancegroup` command [@gabrieljackson](https://github.com/gabrieljackson) [#10593](https://github.com/kubernetes/kops/pull/10593)
* Set the tcp_rmem sysctl in bootstrap script [@justinsb](https://github.com/justinsb) [#10654](https://github.com/kubernetes/kops/pull/10654)
* Add --create-args kubetest2 flag [@rifelpet](https://github.com/rifelpet) [#10658](https://github.com/kubernetes/kops/pull/10658)
* Fix cluster_spec.md indentation [@trondhindenes](https://github.com/trondhindenes) [#10660](https://github.com/kubernetes/kops/pull/10660)
* Allow attaching same external load balancer to multiple instance groups [@hakman](https://github.com/hakman) [#10666](https://github.com/kubernetes/kops/pull/10666)
* Fix typo [@adrianmoisey](https://github.com/adrianmoisey) [#10667](https://github.com/kubernetes/kops/pull/10667)
* Update kops e2e testing docs [@bmelbourne](https://github.com/bmelbourne) [#10652](https://github.com/kubernetes/kops/pull/10652)
* Create default loadbalancer when SSL certificate is specified [@rudeigerc](https://github.com/rudeigerc) [#10665](https://github.com/kubernetes/kops/pull/10665)
* Bump Ubuntu images for AWS and GCE [@hakman](https://github.com/hakman) [#10670](https://github.com/kubernetes/kops/pull/10670)
* Release notes for 1.18.3 [@justinsb](https://github.com/justinsb) [#10673](https://github.com/kubernetes/kops/pull/10673)
* Remove taints from spotinst ocean terraform resource [@rifelpet](https://github.com/rifelpet) [#10674](https://github.com/kubernetes/kops/pull/10674)
* Allow SSH user to be overridden for `toolbox dump` [@rifelpet](https://github.com/rifelpet) [#10675](https://github.com/kubernetes/kops/pull/10675)
* kubetest2 - Use --ssh-user to dump logs [@rifelpet](https://github.com/rifelpet) [#10676](https://github.com/kubernetes/kops/pull/10676)
* Update AWS etcd-manager volumes defaults [@hakman](https://github.com/hakman) [#10661](https://github.com/kubernetes/kops/pull/10661)
* Update aws-sdk-go to 1.37.0 [@rifelpet](https://github.com/rifelpet) [#10682](https://github.com/kubernetes/kops/pull/10682)
* Release notes for 1.19.0 [@justinsb](https://github.com/justinsb) [#10683](https://github.com/kubernetes/kops/pull/10683)
* Update release compatibility matrix [@johngmyers](https://github.com/johngmyers) [#10684](https://github.com/kubernetes/kops/pull/10684)
* Default IMDSv2 to "optional" for AWS [@hakman](https://github.com/hakman) [#10655](https://github.com/kubernetes/kops/pull/10655)
* Add link to 1.19 [@olemarkus](https://github.com/olemarkus) [#10686](https://github.com/kubernetes/kops/pull/10686)
* Fix header indentation in addons.md [@olemarkus](https://github.com/olemarkus) [#10685](https://github.com/kubernetes/kops/pull/10685)
* Documentation update: Corrected externalPolicy AWS ARN formatting [@timothyclarke](https://github.com/timothyclarke) [#10680](https://github.com/kubernetes/kops/pull/10680)
* Remove 'not released' notice from 1.19 notes [@olemarkus](https://github.com/olemarkus) [#10688](https://github.com/kubernetes/kops/pull/10688)
* Fix bug preventing tasks using gp2 [@olemarkus](https://github.com/olemarkus) [#10694](https://github.com/kubernetes/kops/pull/10694)
* Have channels create PKI for addons [@olemarkus](https://github.com/olemarkus) [#10545](https://github.com/kubernetes/kops/pull/10545)
* Add template function returning the latest image [@olemarkus](https://github.com/olemarkus) [#10689](https://github.com/kubernetes/kops/pull/10689)
* Update Weave to v2.8.1 [@hakman](https://github.com/hakman) [#10698](https://github.com/kubernetes/kops/pull/10698)
* Increase IMDSv2 hop limit on control plane nodes [@olemarkus](https://github.com/olemarkus) [#10702](https://github.com/kubernetes/kops/pull/10702)
* Kubetest2 - refactor how `kops create cluster` arguments are set [@rifelpet](https://github.com/rifelpet) [#10701](https://github.com/kubernetes/kops/pull/10701)
* Update upgrade test to use 1.18->1.19 [@rifelpet](https://github.com/rifelpet) [#10710](https://github.com/kubernetes/kops/pull/10710)
* Fix create args for upgrade test [@rifelpet](https://github.com/rifelpet) [#10711](https://github.com/kubernetes/kops/pull/10711)
* Docs: Fix ServiceAccountVolume proposed configuration for Istio [@dntosas](https://github.com/dntosas) [#10712](https://github.com/kubernetes/kops/pull/10712)
* Update the skipped tests in the upgrade job to help the test stage pass [@rifelpet](https://github.com/rifelpet) [#10713](https://github.com/kubernetes/kops/pull/10713)
* Remove unused instanceGroup parameter from setClusterFields [@bharath-123](https://github.com/bharath-123) [#10690](https://github.com/kubernetes/kops/pull/10690)
* Update code reference links in docs [@bharath-123](https://github.com/bharath-123) [#10696](https://github.com/kubernetes/kops/pull/10696)
* Fix rendering issue created by #10414 [@avdhoot](https://github.com/avdhoot) [#10700](https://github.com/kubernetes/kops/pull/10700)
* Fix panic when exporting kubecfg for AWS cluster without load balancer [@rifelpet](https://github.com/rifelpet) [#10720](https://github.com/kubernetes/kops/pull/10720)
* Cleanup kops-controller Route53 record during cluster deletion [@rifelpet](https://github.com/rifelpet) [#10721](https://github.com/kubernetes/kops/pull/10721)
* Revert making imdsv2 default [@olemarkus](https://github.com/olemarkus) [#10729](https://github.com/kubernetes/kops/pull/10729)
* Throw error if path being set by kops set is not present in struct [@bharath-123](https://github.com/bharath-123) [#10692](https://github.com/kubernetes/kops/pull/10692)
* Use expected LaunchTemplateId in updating ASG when MixedInstancePolicy is changed [@h3poteto](https://github.com/h3poteto) [#10742](https://github.com/kubernetes/kops/pull/10742)
* Fix ineffassign issues [@zhijianli88](https://github.com/zhijianli88) [#10739](https://github.com/kubernetes/kops/pull/10739)
* Deprecate aliyun [@olemarkus](https://github.com/olemarkus) [#10746](https://github.com/kubernetes/kops/pull/10746)
* alpha channel: Update older images [@justinsb](https://github.com/justinsb) [#10748](https://github.com/kubernetes/kops/pull/10748)
* Fix docs build failure [@bharath-123](https://github.com/bharath-123) [#10750](https://github.com/kubernetes/kops/pull/10750)
* add user agent to openstack api requests [@zetaab](https://github.com/zetaab) [#10732](https://github.com/kubernetes/kops/pull/10732)
* Add support for cilium 1.9 [@olemarkus](https://github.com/olemarkus) [#10695](https://github.com/kubernetes/kops/pull/10695)
* Use EnsureTask instead of prepending IG names to external ELB tasks [@rifelpet](https://github.com/rifelpet) [#10754](https://github.com/kubernetes/kops/pull/10754)
* nodeup file: Set owner & group when we write the file. [@justinsb](https://github.com/justinsb),[@hakman](https://github.com/hakman) [#10757](https://github.com/kubernetes/kops/pull/10757)
* Always generate kops-controller certs [@hakman](https://github.com/hakman) [#10758](https://github.com/kubernetes/kops/pull/10758)
* Release 1.20.0-alpha.2 [@hakman](https://github.com/hakman) [#10765](https://github.com/kubernetes/kops/pull/10765)

## 1.20.0-alpha.2 to 1.20.0-beta.1

* fix: asset task copy docker image [@johanneswuerbach](https://github.com/johanneswuerbach) [#10767](https://github.com/kubernetes/kops/pull/10767)
* Add AWS LoadBalancerController [@olemarkus](https://github.com/olemarkus) [#10489](https://github.com/kubernetes/kops/pull/10489)
* Update Calico to v3.17.2 [@hakman](https://github.com/hakman) [#10787](https://github.com/kubernetes/kops/pull/10787)
* Enable CSIMigrationAWS if CSI EBS driver is installed [@olemarkus](https://github.com/olemarkus) [#10791](https://github.com/kubernetes/kops/pull/10791)
* Fill Role names in kops-controller-config instead of instance profile names when it is specified [@h3poteto](https://github.com/h3poteto) [#10728](https://github.com/kubernetes/kops/pull/10728)
* Update Docker to v19.03.15 [@hakman](https://github.com/hakman) [#10802](https://github.com/kubernetes/kops/pull/10802)
* Fix LaunchSpec TF output [@hakman](https://github.com/hakman) [#10806](https://github.com/kubernetes/kops/pull/10806)
* add azure support for internal loadbalancer to k8s api [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#10744](https://github.com/kubernetes/kops/pull/10744)
* Allow managed images for Azure instance groups [@NickSchleicher](https://github.com/NickSchleicher) [#10797](https://github.com/kubernetes/kops/pull/10797)
* kubenet containerd: match upstream [@justinsb](https://github.com/justinsb) [#10759](https://github.com/kubernetes/kops/pull/10759)
* Storage: Allow disabling of kOps's management of StorageClasses [@seh](https://github.com/seh) [#10733](https://github.com/kubernetes/kops/pull/10733)
* Spotinst: Replace corev1.Taint to fix HCL2 serialization [@liranp](https://github.com/liranp) [#10819](https://github.com/kubernetes/kops/pull/10819)
* Spotinst: Bump the Ocean Controller to 1.0.72 [@liranp](https://github.com/liranp) [#10820](https://github.com/kubernetes/kops/pull/10820)
* Allow to control which subnets and IPs get used for the API loadbalancer [@codablock](https://github.com/codablock) [#10741](https://github.com/kubernetes/kops/pull/10741)
* Use correct tag when creating node labels from azure cloud tags [@NickSchleicher](https://github.com/NickSchleicher) [#10619](https://github.com/kubernetes/kops/pull/10619)
* containerd installation: always configure, even if we don't install [@justinsb](https://github.com/justinsb) [#10813](https://github.com/kubernetes/kops/pull/10813)
* Precreate the kops-controller DNS name [@rifelpet](https://github.com/rifelpet) [#10833](https://github.com/kubernetes/kops/pull/10833)
* Actually enable systemd cgroup for containerd [@codablock](https://github.com/codablock) [#10846](https://github.com/kubernetes/kops/pull/10846)
* Update Go to v1.15.8 [@hakman](https://github.com/hakman) [#10853](https://github.com/kubernetes/kops/pull/10853)
* Add support for CAS 1.20 + support for disabling CAS for a given IG [@olemarkus](https://github.com/olemarkus) [#10857](https://github.com/kubernetes/kops/pull/10857)
* Add liveness probe for calico-kube-controllers [@hakman](https://github.com/hakman) [#10856](https://github.com/kubernetes/kops/pull/10856)
* Bump aws node termination handler to 1.12.0 [@bharath-123](https://github.com/bharath-123) [#10863](https://github.com/kubernetes/kops/pull/10863)
* Update AWS CNI to latest patch version [@MoShitrit](https://github.com/MoShitrit) [#10876](https://github.com/kubernetes/kops/pull/10876)
* Bump metrics-server to 0.4.2 [@olemarkus](https://github.com/olemarkus) [#10858](https://github.com/kubernetes/kops/pull/10858)
* Fixes for 1.21 e2e tests [@olemarkus](https://github.com/olemarkus) [#10879](https://github.com/kubernetes/kops/pull/10879)
* Add validation for instanceType and ami architecture  [@bharath-123](https://github.com/bharath-123),[@hakman](https://github.com/hakman) [#10747](https://github.com/kubernetes/kops/pull/10747)
* fix loadBalancerID null pointer [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#10886](https://github.com/kubernetes/kops/pull/10886)
* Update Calico to v3.18.0 [@hakman](https://github.com/hakman) [#10904](https://github.com/kubernetes/kops/pull/10904)
* Adding Elastic IP Allocations to NLB API [@timothyclarke](https://github.com/timothyclarke) [#10872](https://github.com/kubernetes/kops/pull/10872)
* add usage of subnet and routetable shared resources in azure [@ngalantowicz](https://github.com/ngalantowicz) [#10900](https://github.com/kubernetes/kops/pull/10900)
* Release 1.20.0-beta.1 [@hakman](https://github.com/hakman) [#10906](https://github.com/kubernetes/kops/pull/10906)

## 1.20.0-beta.1 to 1.20.0-beta.2

* add support for azure public loadbalancer [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#10915](https://github.com/kubernetes/kops/pull/10915)
* Spotinst: Prevent instance groups with the same suffix from being deleted [@liranp](https://github.com/liranp) [#10918](https://github.com/kubernetes/kops/pull/10918)
* Fix nil pointer deference for image ID with spotinst [@hakman](https://github.com/hakman) [#10924](https://github.com/kubernetes/kops/pull/10924)
* Sort external policies when checking for changes [@hakman](https://github.com/hakman) [#10940](https://github.com/kubernetes/kops/pull/10940)
* Further improve cloudLabel validation [@olemarkus](https://github.com/olemarkus) [#10910](https://github.com/kubernetes/kops/pull/10910)
* Update etcd-manager to 3.0.20210228 [@justinsb](https://github.com/justinsb) [#10949](https://github.com/kubernetes/kops/pull/10949)
* Allow multi-CNI setups to set usesSecondaryIP [@ravens](https://github.com/ravens) [#10828](https://github.com/kubernetes/kops/pull/10828)
* Spotinst: Don't skip LB attachments when SpotinstHybrid is enabled [@liranp](https://github.com/liranp) [#10961](https://github.com/kubernetes/kops/pull/10961)
* Add AWS Transit Gateway support [@rifelpet](https://github.com/rifelpet) [#10948](https://github.com/kubernetes/kops/pull/10948)
* gce doesn't suffix the IG names with ClusterName [@olemarkus](https://github.com/olemarkus) [#10944](https://github.com/kubernetes/kops/pull/10944)
* Fix node label conversion in Azure [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#10935](https://github.com/kubernetes/kops/pull/10935)
* Spotinst: Bump the Ocean Controller to 1.0.73 [@liranp](https://github.com/liranp) [#10960](https://github.com/kubernetes/kops/pull/10960)
* Add support for enable-cadvisor-json-endpoints with Kubelet [@adrianmoisey](https://github.com/adrianmoisey) [#10957](https://github.com/kubernetes/kops/pull/10957)
* Add explicit RBAC permissions for finalizers subresources [@olemarkus](https://github.com/olemarkus) [#10966](https://github.com/kubernetes/kops/pull/10966)
* Add support for CPU Credits on AWS t2 and t3 instance families [@rifelpet](https://github.com/rifelpet) [#10934](https://github.com/kubernetes/kops/pull/10934)
* Update controller-runtime to v0.8.2 for kOps 1.20 [@hakman](https://github.com/hakman) [#10967](https://github.com/kubernetes/kops/pull/10967)
* Removing duplicate local and output values in terraform(#10786) [@mmerrill3](https://github.com/mmerrill3) [#10978](https://github.com/kubernetes/kops/pull/10978)
* Add CloudLabels as --extra-tags to aws-ebs-csi driver [@codablock](https://github.com/codablock) [#10976](https://github.com/kubernetes/kops/pull/10976)
* Use internal api url for jwks [@olemarkus](https://github.com/olemarkus) [#10888](https://github.com/kubernetes/kops/pull/10888)
* Disable Calico Prometheus metrics by default [@hakman](https://github.com/hakman) [#10982](https://github.com/kubernetes/kops/pull/10982)
* Add etcd-manager discoveryPollInterval option [@ottosulin](https://github.com/ottosulin) [#10975](https://github.com/kubernetes/kops/pull/10975)
* Storage: Amend default choice for StorageClass management to honor a specified OpenStack-related value [@seh](https://github.com/seh) [#11002](https://github.com/kubernetes/kops/pull/11002)
* Use exponential backoff for DNS updates [@hakman](https://github.com/hakman) [#10996](https://github.com/kubernetes/kops/pull/10996)
* Update Calico to v3.18.1 [@hakman](https://github.com/hakman) [#11018](https://github.com/kubernetes/kops/pull/11018)
* Various cleanups around apply_cluster and awsmodel [@olemarkus](https://github.com/olemarkus) [#10579](https://github.com/kubernetes/kops/pull/10579)
* Spotinst: Add support for block device mappings in Ocean Launch Spec [@liranp](https://github.com/liranp) [#11009](https://github.com/kubernetes/kops/pull/11009)
* Fix rendering of multiple Docker insecure registries [@hakman](https://github.com/hakman) [#11027](https://github.com/kubernetes/kops/pull/11027)
* Release 1.20.0-beta.2 [@hakman](https://github.com/hakman) [#11031](https://github.com/kubernetes/kops/pull/11031)

## 1.20.0-beta.2 to 1.20.0

* azure: fix null pointer when updating in place cluster [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#11015](https://github.com/kubernetes/kops/pull/11015)
* Honor OS update policy at InstanceGroup level too [@seh](https://github.com/seh) [#10913](https://github.com/kubernetes/kops/pull/10913)
* Cleanup some nodeup & protokube logging [@rifelpet](https://github.com/rifelpet) [#11052](https://github.com/kubernetes/kops/pull/11052)
* Improve instance type validation error message [@bharath-123](https://github.com/bharath-123) [#11043](https://github.com/kubernetes/kops/pull/11043)
* Add channels entries for image architecture [@hakman](https://github.com/hakman) [#11046](https://github.com/kubernetes/kops/pull/11046)
* Upgrade AWS CNI to version 1.7.10 [@MoShitrit](https://github.com/MoShitrit) [#11078](https://github.com/kubernetes/kops/pull/11078)
* Ensure protokube can connect to kube-apiserver before starting the sync loop [@olemarkus](https://github.com/olemarkus) [#11093](https://github.com/kubernetes/kops/pull/11093)
* Put awslbcontroller on the control-plane [@olemarkus](https://github.com/olemarkus) [#11091](https://github.com/kubernetes/kops/pull/11091)
* Have nodeup retry kops-controller bootstrapping sooner if DNS isn't setup [@rifelpet](https://github.com/rifelpet) [#11101](https://github.com/kubernetes/kops/pull/11101)
* Update containerd to v1.3.10/v1.4.4 [@bmelbourne](https://github.com/bmelbourne) [#11084](https://github.com/kubernetes/kops/pull/11084)
* Update kube-router to v1.2.1 [@hakman](https://github.com/hakman) [#11124](https://github.com/kubernetes/kops/pull/11124)
* Remove instance-selector label [@bharath-123](https://github.com/bharath-123) [#11048](https://github.com/kubernetes/kops/pull/11048)
* Validate that kube-apiserver has the necessary authz modes set [@olemarkus](https://github.com/olemarkus) [#11127](https://github.com/kubernetes/kops/pull/11127)
* [DigitalOcean] Fix DO Tag issue [@srikiz](https://github.com/srikiz) [#11102](https://github.com/kubernetes/kops/pull/11102)
* Revert "Update kube-router to v1.2.0" [@hakman](https://github.com/hakman) [#11134](https://github.com/kubernetes/kops/pull/11134)
* replace hard coded aws region checks with aws sdk calls [@guydog28](https://github.com/guydog28) [#11119](https://github.com/kubernetes/kops/pull/11119)
* Add scaleDownDelayAfterAdd to clusterAutoscaler spec [@jurriaanpro](https://github.com/jurriaanpro) [#11140](https://github.com/kubernetes/kops/pull/11140)
* Add an option to skip NTP installation [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#11160](https://github.com/kubernetes/kops/pull/11160)
* Spotinst: Use BDM to configure the root volume size at VNG level [@liranp](https://github.com/liranp) [#11179](https://github.com/kubernetes/kops/pull/11179)
* Spotinst: Configure headroom resources only at the VNG level [@liranp](https://github.com/liranp) [#11181](https://github.com/kubernetes/kops/pull/11181)
* Release 1.20.0 [@justinsb](https://github.com/justinsb) [#11192](https://github.com/kubernetes/kops/pull/11192)

## 1.20.0 to 1.20.1

* Correct typos [@Akiros001](https://github.com/Akiros001) [#11190](https://github.com/kubernetes/kops/pull/11190)
* Use "string" for architecture type in ChannelRecommendedImage [@hakman](https://github.com/hakman) [#11220](https://github.com/kubernetes/kops/pull/11220)
* Always secure api -> kubelet communication [@olemarkus](https://github.com/olemarkus) [#11185](https://github.com/kubernetes/kops/pull/11185)
* Fix etcd volume validation logic [@hakman](https://github.com/hakman) [#11225](https://github.com/kubernetes/kops/pull/11225)
* Remove validations for EBS from cluster validation [@h3poteto](https://github.com/h3poteto) [#11228](https://github.com/kubernetes/kops/pull/11228)
* Add support for Docker v20.10.6 [@hakman](https://github.com/hakman) [#11236](https://github.com/kubernetes/kops/pull/11236)
* Add Azure image to alpha/stable channel [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#11271](https://github.com/kubernetes/kops/pull/11271)
* Exclude nodes from load balancers upon cordoning [@johngmyers](https://github.com/johngmyers) [#11273](https://github.com/kubernetes/kops/pull/11273)
* Fix cilium template scoping typo [@javipolo](https://github.com/javipolo) [#11270](https://github.com/kubernetes/kops/pull/11270)
* If one tries to use eip with a public ip that doesn't exist, fail [@olemarkus](https://github.com/olemarkus) [#11276](https://github.com/kubernetes/kops/pull/11276)
* Spotinst: Prevent nil pointer dereference [@liranp](https://github.com/liranp) [#11289](https://github.com/kubernetes/kops/pull/11289)
* Spotinst: Update spotinst/ocean-controller to v1.0.74 [@liranp](https://github.com/liranp) [#11286](https://github.com/kubernetes/kops/pull/11286)
* Make it possible to detect field changes when mixedInstancePolicy is removed [@h3poteto](https://github.com/h3poteto) [#11255](https://github.com/kubernetes/kops/pull/11255)
* Add ability to set a default Issuer in certManager addon [@javipolo](https://github.com/javipolo) [#11281](https://github.com/kubernetes/kops/pull/11281)
* Filter servers using cluster name in tags [@zetaab](https://github.com/zetaab) [#11305](https://github.com/kubernetes/kops/pull/11305)
* Use the full operator instead of the generic one [@olemarkus](https://github.com/olemarkus) [#11312](https://github.com/kubernetes/kops/pull/11312)
* Update Calico to v3.18.2 [@hakman](https://github.com/hakman) [#11339](https://github.com/kubernetes/kops/pull/11339)
* Set SAN for addon CAs [@olemarkus](https://github.com/olemarkus) [#11328](https://github.com/kubernetes/kops/pull/11328)
* Add support for configuring Cilium enable-host-reachable-services. [@bjhaid](https://github.com/bjhaid),[@hakman](https://github.com/hakman) [#11333](https://github.com/kubernetes/kops/pull/11333)
* Mount /run inside etcd-manager pods for systemd mounts [@hakman](https://github.com/hakman) [#11352](https://github.com/kubernetes/kops/pull/11352)
* Expose hubble agent when hubble is enabled [@olemarkus](https://github.com/olemarkus) [#11314](https://github.com/kubernetes/kops/pull/11314)
* Mark control-plane node for update when etcd volume size changes [@hakman](https://github.com/hakman) [#11365](https://github.com/kubernetes/kops/pull/11365)
* Update Calico to v3.18.3 for kOps 1.20 [@hakman](https://github.com/hakman) [#11377](https://github.com/kubernetes/kops/pull/11377)
* Don't try to mount hubble TLS on the agent if we don't use hubble [@olemarkus](https://github.com/olemarkus) [#11379](https://github.com/kubernetes/kops/pull/11379)
* Add elasticloadbalancing:ModifyTargetGroupAttributes to aws lb controller [@olemarkus](https://github.com/olemarkus) [#11393](https://github.com/kubernetes/kops/pull/11393)
* Use etcd-manager built from etcdadm repo [@justinsb](https://github.com/justinsb),[@hakman](https://github.com/hakman) [#11098](https://github.com/kubernetes/kops/pull/11098)
* csi/aws: Bump templates + add support for warm pools [@dntosas](https://github.com/dntosas),[@codablock](https://github.com/codablock) [#11304](https://github.com/kubernetes/kops/pull/11304)
* Verify all versions are set correctly [@johngmyers](https://github.com/johngmyers) [#11413](https://github.com/kubernetes/kops/pull/11413)
* Backport rename of service-account key to 1.20 [@johngmyers](https://github.com/johngmyers) [#11388](https://github.com/kubernetes/kops/pull/11388)
* Update verify-terraform to use 0.14.11 [@rifelpet](https://github.com/rifelpet) [#11436](https://github.com/kubernetes/kops/pull/11436)
* Create new clusters without forcing a container runtime [@hakman](https://github.com/hakman) [#11428](https://github.com/kubernetes/kops/pull/11428)
* Allow AWS instance types with multiple architectures [@hakman](https://github.com/hakman) [#11463](https://github.com/kubernetes/kops/pull/11463)

## 1.20.1 to 1.20.2

* Release 1.20.1 [@justinsb](https://github.com/justinsb) [#11467](https://github.com/kubernetes/kops/pull/11467)
* Update containerd to v1.4.6 [@hakman](https://github.com/hakman) [#11535](https://github.com/kubernetes/kops/pull/11535)
* Allow cert-manager to be provisioned externally [@codablock](https://github.com/codablock) [#11354](https://github.com/kubernetes/kops/pull/11354)
* upup: gcetasks: force send AutoCreateSubnetworks field when set to false [@nicktrav](https://github.com/nicktrav) [#11457](https://github.com/kubernetes/kops/pull/11457)
* [metrics-server] Bump manifest to latest stable [@dntosas](https://github.com/dntosas),[@hakman](https://github.com/hakman) [#11319](https://github.com/kubernetes/kops/pull/11319)
* Allow Spotinst to use comma separated instance types [@hakman](https://github.com/hakman) [#11560](https://github.com/kubernetes/kops/pull/11560)
* Only update kubeconfig user when we have user info [@justinsb](https://github.com/justinsb) [#11584](https://github.com/kubernetes/kops/pull/11584)
* Add init image field for Amazon VPC CNI [@ryan-dyer](https://github.com/ryan-dyer) [#11602](https://github.com/kubernetes/kops/pull/11602)
* Fix duplicate CopyFile tasks [@johngmyers](https://github.com/johngmyers) [#11619](https://github.com/kubernetes/kops/pull/11619)
* Use the OnDelete updateStrategy for AWS VPC CNI DaemonSet [@johngmyers](https://github.com/johngmyers) [#11590](https://github.com/kubernetes/kops/pull/11590)
* Consolidate CSI livenessprobe images for multi-arch support [@rifelpet](https://github.com/rifelpet) [#11652](https://github.com/kubernetes/kops/pull/11652)
* Fix set-version leaving backup files with "-e" suffix [@johngmyers](https://github.com/johngmyers) [#11691](https://github.com/kubernetes/kops/pull/11691)
* Add support for Docker v20.10.7 [@hakman](https://github.com/hakman) [#11674](https://github.com/kubernetes/kops/pull/11674)
* Bump the cas addon version. [@olemarkus](https://github.com/olemarkus) [#11780](https://github.com/kubernetes/kops/pull/11780)

## 1.20.2 to 1.20.3

* Release 1.20.2 [@justinsb](https://github.com/justinsb) [#11800](https://github.com/kubernetes/kops/pull/11800)
* Also set haveUserInfo=true in case --user was provided in "kops export kubecfg" [@codablock](https://github.com/codablock) [#11778](https://github.com/kubernetes/kops/pull/11778)
* Handle containerExec hooks when using containerd [@hakman](https://github.com/hakman) [#11852](https://github.com/kubernetes/kops/pull/11852)
* Update aws-sdk-go to v1.37.33 for kOps 1.20 [@hakman](https://github.com/hakman) [#11858](https://github.com/kubernetes/kops/pull/11858)
* Include GCP Project in terraform HCL2 output [@rifelpet](https://github.com/rifelpet) [#11901](https://github.com/kubernetes/kops/pull/11901)
* cluster validation - allow flapping of validation errors [@rifelpet](https://github.com/rifelpet) [#11049](https://github.com/kubernetes/kops/pull/11049)
* Add log rotation for etcd-cilium.log [@hakman](https://github.com/hakman) [#11943](https://github.com/kubernetes/kops/pull/11943)
* Don't ignore channel value in toolbox template [@hakman](https://github.com/hakman) [#12464](https://github.com/kubernetes/kops/pull/12464)
* Update containerd and Docker for kOps 1.20 [@hakman](https://github.com/hakman) [#12509](https://github.com/kubernetes/kops/pull/12509)
