/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import (
	"io"

	"github.com/spf13/cobra"
	"github.com/spf13/cobra/doc"
	"k8s.io/kops/cmd/kops/util"
)

const fileHeader = `
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

`

type GenHelpDocsOptions struct {
	OutDir string
}

func NewCmdGenCLIDocs(f *util.Factory, out io.Writer) *cobra.Command {
	options := &GenHelpDocsOptions{}

	cmd := &cobra.Command{
		Use:               "gen-cli-docs",
		Short:             "Generate CLI help docs",
		Hidden:            true,
		Args:              cobra.NoArgs,
		ValidArgsFunction: cobra.NoFileCompletions,
		RunE: func(cmd *cobra.Command, args []string) error {
			return RunGenCLIDocs(options)
		},
	}

	cmd.Flags().StringVar(&options.OutDir, "out", "", "path to write out to.")
	cmd.MarkFlagDirname("out")

	return cmd
}

func RunGenCLIDocs(options *GenHelpDocsOptions) error {
	rootCommand.cobraCommand.DisableAutoGenTag = true

	// unset KOPS_STATE_STORE from default value
	for _, c := range rootCommand.cobraCommand.Commands() {
		c.Flag("state").DefValue = ""
	}

	linkHandler := func(link string) string { return link }
	filePrepender := func(filname string) string { return fileHeader }

	return doc.GenMarkdownTreeCustom(rootCommand.cobraCommand, options.OutDir, filePrepender, linkHandler)
}
