# Put the line below in your Nushell config file:
#
#   jump shell nushell | save --append $nu.config-path
#
# The following lines are autogenerated:

$env.config = ($env.config | upsert hooks {
  pre_prompt: ($env.config.hooks.pre_prompt? | default [] | append {||
    jump chdir
  })
})

def __jump_base_dir [] {
  if ($env.JUMP_BASED_PATH? != null) {
    $env.JUMP_BASED_PATH
  } else {
    try { git rev-parse --show-toplevel } catch { "" }
  }
}

alias builtin-cd = cd

def --env {{.Bind}} [...terms: directory] {
  match ($terms | get 0?) {
    ".." => { builtin-cd .. }
    "-" => { builtin-cd - }
    "." => {
      let base_dir = (__jump_base_dir)
      let remaining = ($terms | skip 1)
      let dir = (jump cd $base_dir ...$remaining)
      if ($dir | path exists) { builtin-cd $dir }
    }
    _ => {
      let dir = (jump cd ...$terms)
      if ($dir | path exists) { builtin-cd $dir }
    }
  }
}
