# Contributing to Flaggy

Thanks for your interest in improving Flaggy! The following guide outlines the standard workflow for proposing and landing a change. Following these steps helps maintainers review contributions efficiently and keeps the project healthy.

* **Getting Started**
  - **Open an issue** describing the problem you want to fix or the feature you plan to add. This gives us a chance to discuss the proposal before you start coding.
  - **Fork the repository** to your own GitHub account so you can develop the change independently of the main project.
* **Implementing Your Change**
  - Make your modifications in your fork (create a topic branch if that helps keep things organized).
  - Add or update tests so your change is well covered.
  - Run the full test suite locally and ensure everything passes (`go test ./...`).
* **Opening a Pull Request**
  - Push your updates to your fork.
  - Open a pull request against the main repository, referencing the issue created earlier. Include context about what the change does and any testing performed.
  - Participate in the review process and incorporate any requested changes. Keep your branch up to date with the main branch as needed.

We appreciate your contributions and look forward to collaborating with you!
