// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: parser/pbf/internal/osmpbf/osmformat.proto

/*
	Package osmpbf is a generated protocol buffer package.

	It is generated from these files:
		parser/pbf/internal/osmpbf/osmformat.proto

	It has these top-level messages:
		HeaderBlock
		HeaderBBox
		PrimitiveBlock
		PrimitiveGroup
		StringTable
		Info
		DenseInfo
		ChangeSet
		Node
		DenseNodes
		Way
		Relation
*/
package osmpbf

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Relation_MemberType int32

const (
	Relation_NODE     Relation_MemberType = 0
	Relation_WAY      Relation_MemberType = 1
	Relation_RELATION Relation_MemberType = 2
)

var Relation_MemberType_name = map[int32]string{
	0: "NODE",
	1: "WAY",
	2: "RELATION",
}
var Relation_MemberType_value = map[string]int32{
	"NODE":     0,
	"WAY":      1,
	"RELATION": 2,
}

func (x Relation_MemberType) Enum() *Relation_MemberType {
	p := new(Relation_MemberType)
	*p = x
	return p
}
func (x Relation_MemberType) String() string {
	return proto.EnumName(Relation_MemberType_name, int32(x))
}
func (x *Relation_MemberType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Relation_MemberType_value, data, "Relation_MemberType")
	if err != nil {
		return err
	}
	*x = Relation_MemberType(value)
	return nil
}
func (Relation_MemberType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorOsmformat, []int{11, 0}
}

type HeaderBlock struct {
	Bbox *HeaderBBox `protobuf:"bytes,1,opt,name=bbox" json:"bbox,omitempty"`
	// Additional tags to aid in parsing this dataset
	RequiredFeatures []string `protobuf:"bytes,4,rep,name=required_features,json=requiredFeatures" json:"required_features,omitempty"`
	OptionalFeatures []string `protobuf:"bytes,5,rep,name=optional_features,json=optionalFeatures" json:"optional_features,omitempty"`
	Writingprogram   string   `protobuf:"bytes,16,opt,name=writingprogram" json:"writingprogram"`
	Source           string   `protobuf:"bytes,17,opt,name=source" json:"source"`
	// replication timestamp, expressed in seconds since the epoch,
	// otherwise the same value as in the "timestamp=..." field
	// in the state.txt file used by Osmosis
	OsmosisReplicationTimestamp int64 `protobuf:"varint,32,opt,name=osmosis_replication_timestamp,json=osmosisReplicationTimestamp" json:"osmosis_replication_timestamp"`
	// replication sequence number (sequenceNumber in state.txt)
	OsmosisReplicationSequenceNumber int64 `protobuf:"varint,33,opt,name=osmosis_replication_sequence_number,json=osmosisReplicationSequenceNumber" json:"osmosis_replication_sequence_number"`
	// replication base URL (from Osmosis' configuration.txt file)
	OsmosisReplicationBaseUrl string `protobuf:"bytes,34,opt,name=osmosis_replication_base_url,json=osmosisReplicationBaseUrl" json:"osmosis_replication_base_url"`
}

func (m *HeaderBlock) Reset()                    { *m = HeaderBlock{} }
func (m *HeaderBlock) String() string            { return proto.CompactTextString(m) }
func (*HeaderBlock) ProtoMessage()               {}
func (*HeaderBlock) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{0} }

func (m *HeaderBlock) GetBbox() *HeaderBBox {
	if m != nil {
		return m.Bbox
	}
	return nil
}

func (m *HeaderBlock) GetRequiredFeatures() []string {
	if m != nil {
		return m.RequiredFeatures
	}
	return nil
}

func (m *HeaderBlock) GetOptionalFeatures() []string {
	if m != nil {
		return m.OptionalFeatures
	}
	return nil
}

func (m *HeaderBlock) GetWritingprogram() string {
	if m != nil {
		return m.Writingprogram
	}
	return ""
}

func (m *HeaderBlock) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *HeaderBlock) GetOsmosisReplicationTimestamp() int64 {
	if m != nil {
		return m.OsmosisReplicationTimestamp
	}
	return 0
}

func (m *HeaderBlock) GetOsmosisReplicationSequenceNumber() int64 {
	if m != nil {
		return m.OsmosisReplicationSequenceNumber
	}
	return 0
}

func (m *HeaderBlock) GetOsmosisReplicationBaseUrl() string {
	if m != nil {
		return m.OsmosisReplicationBaseUrl
	}
	return ""
}

type HeaderBBox struct {
	Left   int64 `protobuf:"zigzag64,1,req,name=left" json:"left"`
	Right  int64 `protobuf:"zigzag64,2,req,name=right" json:"right"`
	Top    int64 `protobuf:"zigzag64,3,req,name=top" json:"top"`
	Bottom int64 `protobuf:"zigzag64,4,req,name=bottom" json:"bottom"`
}

func (m *HeaderBBox) Reset()                    { *m = HeaderBBox{} }
func (m *HeaderBBox) String() string            { return proto.CompactTextString(m) }
func (*HeaderBBox) ProtoMessage()               {}
func (*HeaderBBox) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{1} }

func (m *HeaderBBox) GetLeft() int64 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *HeaderBBox) GetRight() int64 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *HeaderBBox) GetTop() int64 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *HeaderBBox) GetBottom() int64 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

type PrimitiveBlock struct {
	Stringtable    *StringTable      `protobuf:"bytes,1,req,name=stringtable" json:"stringtable,omitempty"`
	Primitivegroup []*PrimitiveGroup `protobuf:"bytes,2,rep,name=primitivegroup" json:"primitivegroup,omitempty"`
	// Granularity, units of nanodegrees, used to store coordinates in this block
	Granularity *int32 `protobuf:"varint,17,opt,name=granularity,def=100" json:"granularity,omitempty"`
	// Offset value between the output coordinates coordinates and the granularity grid in unites of nanodegrees.
	LatOffset *int64 `protobuf:"varint,19,opt,name=lat_offset,json=latOffset,def=0" json:"lat_offset,omitempty"`
	LonOffset *int64 `protobuf:"varint,20,opt,name=lon_offset,json=lonOffset,def=0" json:"lon_offset,omitempty"`
	// Granularity of dates, normally represented in units of milliseconds since the 1970 epoch.
	DateGranularity *int32 `protobuf:"varint,18,opt,name=date_granularity,json=dateGranularity,def=1000" json:"date_granularity,omitempty"`
}

func (m *PrimitiveBlock) Reset()                    { *m = PrimitiveBlock{} }
func (m *PrimitiveBlock) String() string            { return proto.CompactTextString(m) }
func (*PrimitiveBlock) ProtoMessage()               {}
func (*PrimitiveBlock) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{2} }

const Default_PrimitiveBlock_Granularity int32 = 100
const Default_PrimitiveBlock_LatOffset int64 = 0
const Default_PrimitiveBlock_LonOffset int64 = 0
const Default_PrimitiveBlock_DateGranularity int32 = 1000

func (m *PrimitiveBlock) GetStringtable() *StringTable {
	if m != nil {
		return m.Stringtable
	}
	return nil
}

func (m *PrimitiveBlock) GetPrimitivegroup() []*PrimitiveGroup {
	if m != nil {
		return m.Primitivegroup
	}
	return nil
}

func (m *PrimitiveBlock) GetGranularity() int32 {
	if m != nil && m.Granularity != nil {
		return *m.Granularity
	}
	return Default_PrimitiveBlock_Granularity
}

func (m *PrimitiveBlock) GetLatOffset() int64 {
	if m != nil && m.LatOffset != nil {
		return *m.LatOffset
	}
	return Default_PrimitiveBlock_LatOffset
}

func (m *PrimitiveBlock) GetLonOffset() int64 {
	if m != nil && m.LonOffset != nil {
		return *m.LonOffset
	}
	return Default_PrimitiveBlock_LonOffset
}

func (m *PrimitiveBlock) GetDateGranularity() int32 {
	if m != nil && m.DateGranularity != nil {
		return *m.DateGranularity
	}
	return Default_PrimitiveBlock_DateGranularity
}

// Group of OSMPrimitives. All primitives in a group must be the same type.
type PrimitiveGroup struct {
	Nodes      []Node      `protobuf:"bytes,1,rep,name=nodes" json:"nodes"`
	Dense      *DenseNodes `protobuf:"bytes,2,opt,name=dense" json:"dense,omitempty"`
	Ways       []Way       `protobuf:"bytes,3,rep,name=ways" json:"ways"`
	Relations  []Relation  `protobuf:"bytes,4,rep,name=relations" json:"relations"`
	Changesets []ChangeSet `protobuf:"bytes,5,rep,name=changesets" json:"changesets"`
}

func (m *PrimitiveGroup) Reset()                    { *m = PrimitiveGroup{} }
func (m *PrimitiveGroup) String() string            { return proto.CompactTextString(m) }
func (*PrimitiveGroup) ProtoMessage()               {}
func (*PrimitiveGroup) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{3} }

func (m *PrimitiveGroup) GetNodes() []Node {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *PrimitiveGroup) GetDense() *DenseNodes {
	if m != nil {
		return m.Dense
	}
	return nil
}

func (m *PrimitiveGroup) GetWays() []Way {
	if m != nil {
		return m.Ways
	}
	return nil
}

func (m *PrimitiveGroup) GetRelations() []Relation {
	if m != nil {
		return m.Relations
	}
	return nil
}

func (m *PrimitiveGroup) GetChangesets() []ChangeSet {
	if m != nil {
		return m.Changesets
	}
	return nil
}

// * String table, contains the common strings in each block.
//
// Note that we reserve index '0' as a delimiter, so the entry at that
// index in the table is ALWAYS blank and unused.
//
type StringTable struct {
	S [][]byte `protobuf:"bytes,1,rep,name=s" json:"s,omitempty"`
}

func (m *StringTable) Reset()                    { *m = StringTable{} }
func (m *StringTable) String() string            { return proto.CompactTextString(m) }
func (*StringTable) ProtoMessage()               {}
func (*StringTable) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{4} }

func (m *StringTable) GetS() [][]byte {
	if m != nil {
		return m.S
	}
	return nil
}

// Optional metadata that may be included into each primitive.
type Info struct {
	Version   *int32 `protobuf:"varint,1,opt,name=version,def=-1" json:"version,omitempty"`
	Timestamp int64  `protobuf:"varint,2,opt,name=timestamp" json:"timestamp"`
	Changeset int64  `protobuf:"varint,3,opt,name=changeset" json:"changeset"`
	Uid       int32  `protobuf:"varint,4,opt,name=uid" json:"uid"`
	UserSid   uint32 `protobuf:"varint,5,opt,name=user_sid,json=userSid" json:"user_sid"`
	// The visible flag is used to store history information. It indicates that
	// the current object version has been created by a delete operation on the
	// OSM API.
	// When a writer sets this flag, it MUST add a required_features tag with
	// value "HistoricalInformation" to the HeaderBlock.
	// If this flag is not available for some object it MUST be assumed to be
	// true if the file has the required_features tag "HistoricalInformation"
	// set.
	Visible bool `protobuf:"varint,6,opt,name=visible" json:"visible"`
}

func (m *Info) Reset()                    { *m = Info{} }
func (m *Info) String() string            { return proto.CompactTextString(m) }
func (*Info) ProtoMessage()               {}
func (*Info) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{5} }

const Default_Info_Version int32 = -1

func (m *Info) GetVersion() int32 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return Default_Info_Version
}

func (m *Info) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *Info) GetChangeset() int64 {
	if m != nil {
		return m.Changeset
	}
	return 0
}

func (m *Info) GetUid() int32 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *Info) GetUserSid() uint32 {
	if m != nil {
		return m.UserSid
	}
	return 0
}

func (m *Info) GetVisible() bool {
	if m != nil {
		return m.Visible
	}
	return false
}

// * Optional metadata that may be included into each primitive. Special dense format used in DenseNodes.
type DenseInfo struct {
	Version   []int32 `protobuf:"varint,1,rep,packed,name=version" json:"version,omitempty"`
	Timestamp []int64 `protobuf:"zigzag64,2,rep,packed,name=timestamp" json:"timestamp,omitempty"`
	Changeset []int64 `protobuf:"zigzag64,3,rep,packed,name=changeset" json:"changeset,omitempty"`
	Uid       []int32 `protobuf:"zigzag32,4,rep,packed,name=uid" json:"uid,omitempty"`
	UserSid   []int32 `protobuf:"zigzag32,5,rep,packed,name=user_sid,json=userSid" json:"user_sid,omitempty"`
	// The visible flag is used to store history information. It indicates that
	// the current object version has been created by a delete operation on the
	// OSM API.
	// When a writer sets this flag, it MUST add a required_features tag with
	// value "HistoricalInformation" to the HeaderBlock.
	// If this flag is not available for some object it MUST be assumed to be
	// true if the file has the required_features tag "HistoricalInformation"
	// set.
	Visible []bool `protobuf:"varint,6,rep,packed,name=visible" json:"visible,omitempty"`
}

func (m *DenseInfo) Reset()                    { *m = DenseInfo{} }
func (m *DenseInfo) String() string            { return proto.CompactTextString(m) }
func (*DenseInfo) ProtoMessage()               {}
func (*DenseInfo) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{6} }

func (m *DenseInfo) GetVersion() []int32 {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *DenseInfo) GetTimestamp() []int64 {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *DenseInfo) GetChangeset() []int64 {
	if m != nil {
		return m.Changeset
	}
	return nil
}

func (m *DenseInfo) GetUid() []int32 {
	if m != nil {
		return m.Uid
	}
	return nil
}

func (m *DenseInfo) GetUserSid() []int32 {
	if m != nil {
		return m.UserSid
	}
	return nil
}

func (m *DenseInfo) GetVisible() []bool {
	if m != nil {
		return m.Visible
	}
	return nil
}

// THIS IS STUB DESIGN FOR CHANGESETS. NOT USED RIGHT NOW.
// TODO:    REMOVE THIS?
type ChangeSet struct {
	Id int64 `protobuf:"varint,1,req,name=id" json:"id"`
}

func (m *ChangeSet) Reset()                    { *m = ChangeSet{} }
func (m *ChangeSet) String() string            { return proto.CompactTextString(m) }
func (*ChangeSet) ProtoMessage()               {}
func (*ChangeSet) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{7} }

func (m *ChangeSet) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type Node struct {
	Id int64 `protobuf:"zigzag64,1,req,name=id" json:"id"`
	// Parallel arrays.
	Keys []uint32 `protobuf:"varint,2,rep,packed,name=keys" json:"keys,omitempty"`
	Vals []uint32 `protobuf:"varint,3,rep,packed,name=vals" json:"vals,omitempty"`
	Info Info     `protobuf:"bytes,4,opt,name=info" json:"info"`
	Lat  int64    `protobuf:"zigzag64,8,req,name=lat" json:"lat"`
	Lon  int64    `protobuf:"zigzag64,9,req,name=lon" json:"lon"`
}

func (m *Node) Reset()                    { *m = Node{} }
func (m *Node) String() string            { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()               {}
func (*Node) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{8} }

func (m *Node) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Node) GetKeys() []uint32 {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *Node) GetVals() []uint32 {
	if m != nil {
		return m.Vals
	}
	return nil
}

func (m *Node) GetInfo() Info {
	if m != nil {
		return m.Info
	}
	return Info{}
}

func (m *Node) GetLat() int64 {
	if m != nil {
		return m.Lat
	}
	return 0
}

func (m *Node) GetLon() int64 {
	if m != nil {
		return m.Lon
	}
	return 0
}

type DenseNodes struct {
	Id []int64 `protobuf:"zigzag64,1,rep,packed,name=id" json:"id,omitempty"`
	// repeated Info info = 4;
	Denseinfo *DenseInfo `protobuf:"bytes,5,opt,name=denseinfo" json:"denseinfo,omitempty"`
	Lat       []int64    `protobuf:"zigzag64,8,rep,packed,name=lat" json:"lat,omitempty"`
	Lon       []int64    `protobuf:"zigzag64,9,rep,packed,name=lon" json:"lon,omitempty"`
	// Special packing of keys and vals into one array. May be empty if all nodes in this block are tagless.
	KeysVals []int32 `protobuf:"varint,10,rep,packed,name=keys_vals,json=keysVals" json:"keys_vals,omitempty"`
}

func (m *DenseNodes) Reset()                    { *m = DenseNodes{} }
func (m *DenseNodes) String() string            { return proto.CompactTextString(m) }
func (*DenseNodes) ProtoMessage()               {}
func (*DenseNodes) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{9} }

func (m *DenseNodes) GetId() []int64 {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *DenseNodes) GetDenseinfo() *DenseInfo {
	if m != nil {
		return m.Denseinfo
	}
	return nil
}

func (m *DenseNodes) GetLat() []int64 {
	if m != nil {
		return m.Lat
	}
	return nil
}

func (m *DenseNodes) GetLon() []int64 {
	if m != nil {
		return m.Lon
	}
	return nil
}

func (m *DenseNodes) GetKeysVals() []int32 {
	if m != nil {
		return m.KeysVals
	}
	return nil
}

type Way struct {
	Id int64 `protobuf:"varint,1,req,name=id" json:"id"`
	// Parallel arrays.
	Keys []uint32 `protobuf:"varint,2,rep,packed,name=keys" json:"keys,omitempty"`
	Vals []uint32 `protobuf:"varint,3,rep,packed,name=vals" json:"vals,omitempty"`
	Info Info     `protobuf:"bytes,4,opt,name=info" json:"info"`
	Refs []int64  `protobuf:"zigzag64,8,rep,packed,name=refs" json:"refs,omitempty"`
}

func (m *Way) Reset()                    { *m = Way{} }
func (m *Way) String() string            { return proto.CompactTextString(m) }
func (*Way) ProtoMessage()               {}
func (*Way) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{10} }

func (m *Way) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Way) GetKeys() []uint32 {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *Way) GetVals() []uint32 {
	if m != nil {
		return m.Vals
	}
	return nil
}

func (m *Way) GetInfo() Info {
	if m != nil {
		return m.Info
	}
	return Info{}
}

func (m *Way) GetRefs() []int64 {
	if m != nil {
		return m.Refs
	}
	return nil
}

type Relation struct {
	Id int64 `protobuf:"varint,1,req,name=id" json:"id"`
	// Parallel arrays.
	Keys []uint32 `protobuf:"varint,2,rep,packed,name=keys" json:"keys,omitempty"`
	Vals []uint32 `protobuf:"varint,3,rep,packed,name=vals" json:"vals,omitempty"`
	Info Info     `protobuf:"bytes,4,opt,name=info" json:"info"`
	// Parallel arrays
	RolesSid []int32               `protobuf:"varint,8,rep,packed,name=roles_sid,json=rolesSid" json:"roles_sid,omitempty"`
	Memids   []int64               `protobuf:"zigzag64,9,rep,packed,name=memids" json:"memids,omitempty"`
	Types    []Relation_MemberType `protobuf:"varint,10,rep,packed,name=types,enum=osmpbf.Relation_MemberType" json:"types,omitempty"`
}

func (m *Relation) Reset()                    { *m = Relation{} }
func (m *Relation) String() string            { return proto.CompactTextString(m) }
func (*Relation) ProtoMessage()               {}
func (*Relation) Descriptor() ([]byte, []int) { return fileDescriptorOsmformat, []int{11} }

func (m *Relation) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Relation) GetKeys() []uint32 {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *Relation) GetVals() []uint32 {
	if m != nil {
		return m.Vals
	}
	return nil
}

func (m *Relation) GetInfo() Info {
	if m != nil {
		return m.Info
	}
	return Info{}
}

func (m *Relation) GetRolesSid() []int32 {
	if m != nil {
		return m.RolesSid
	}
	return nil
}

func (m *Relation) GetMemids() []int64 {
	if m != nil {
		return m.Memids
	}
	return nil
}

func (m *Relation) GetTypes() []Relation_MemberType {
	if m != nil {
		return m.Types
	}
	return nil
}

func init() {
	proto.RegisterType((*HeaderBlock)(nil), "osmpbf.HeaderBlock")
	proto.RegisterType((*HeaderBBox)(nil), "osmpbf.HeaderBBox")
	proto.RegisterType((*PrimitiveBlock)(nil), "osmpbf.PrimitiveBlock")
	proto.RegisterType((*PrimitiveGroup)(nil), "osmpbf.PrimitiveGroup")
	proto.RegisterType((*StringTable)(nil), "osmpbf.StringTable")
	proto.RegisterType((*Info)(nil), "osmpbf.Info")
	proto.RegisterType((*DenseInfo)(nil), "osmpbf.DenseInfo")
	proto.RegisterType((*ChangeSet)(nil), "osmpbf.ChangeSet")
	proto.RegisterType((*Node)(nil), "osmpbf.Node")
	proto.RegisterType((*DenseNodes)(nil), "osmpbf.DenseNodes")
	proto.RegisterType((*Way)(nil), "osmpbf.Way")
	proto.RegisterType((*Relation)(nil), "osmpbf.Relation")
	proto.RegisterEnum("osmpbf.Relation_MemberType", Relation_MemberType_name, Relation_MemberType_value)
}
func (m *HeaderBlock) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderBlock) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Bbox != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(m.Bbox.Size()))
		n1, err := m.Bbox.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.RequiredFeatures) > 0 {
		for _, s := range m.RequiredFeatures {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.OptionalFeatures) > 0 {
		for _, s := range m.OptionalFeatures {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	dAtA[i] = 0x82
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(len(m.Writingprogram)))
	i += copy(dAtA[i:], m.Writingprogram)
	dAtA[i] = 0x8a
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(len(m.Source)))
	i += copy(dAtA[i:], m.Source)
	dAtA[i] = 0x80
	i++
	dAtA[i] = 0x2
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.OsmosisReplicationTimestamp))
	dAtA[i] = 0x88
	i++
	dAtA[i] = 0x2
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.OsmosisReplicationSequenceNumber))
	dAtA[i] = 0x92
	i++
	dAtA[i] = 0x2
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(len(m.OsmosisReplicationBaseUrl)))
	i += copy(dAtA[i:], m.OsmosisReplicationBaseUrl)
	return i, nil
}

func (m *HeaderBBox) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderBBox) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64((uint64(m.Left)<<1)^uint64((m.Left>>63))))
	dAtA[i] = 0x10
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64((uint64(m.Right)<<1)^uint64((m.Right>>63))))
	dAtA[i] = 0x18
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64((uint64(m.Top)<<1)^uint64((m.Top>>63))))
	dAtA[i] = 0x20
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64((uint64(m.Bottom)<<1)^uint64((m.Bottom>>63))))
	return i, nil
}

func (m *PrimitiveBlock) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrimitiveBlock) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Stringtable == nil {
		return 0, proto.NewRequiredNotSetError("stringtable")
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(m.Stringtable.Size()))
		n2, err := m.Stringtable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.Primitivegroup) > 0 {
		for _, msg := range m.Primitivegroup {
			dAtA[i] = 0x12
			i++
			i = encodeVarintOsmformat(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Granularity != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(*m.Granularity))
	}
	if m.DateGranularity != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(*m.DateGranularity))
	}
	if m.LatOffset != nil {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(*m.LatOffset))
	}
	if m.LonOffset != nil {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(*m.LonOffset))
	}
	return i, nil
}

func (m *PrimitiveGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrimitiveGroup) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for _, msg := range m.Nodes {
			dAtA[i] = 0xa
			i++
			i = encodeVarintOsmformat(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Dense != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(m.Dense.Size()))
		n3, err := m.Dense.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.Ways) > 0 {
		for _, msg := range m.Ways {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintOsmformat(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Relations) > 0 {
		for _, msg := range m.Relations {
			dAtA[i] = 0x22
			i++
			i = encodeVarintOsmformat(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Changesets) > 0 {
		for _, msg := range m.Changesets {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintOsmformat(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *StringTable) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringTable) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.S) > 0 {
		for _, b := range m.S {
			dAtA[i] = 0xa
			i++
			i = encodeVarintOsmformat(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *Info) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Info) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Version != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(*m.Version))
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.Timestamp))
	dAtA[i] = 0x18
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.Changeset))
	dAtA[i] = 0x20
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.Uid))
	dAtA[i] = 0x28
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.UserSid))
	dAtA[i] = 0x30
	i++
	if m.Visible {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *DenseInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DenseInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Version) > 0 {
		dAtA5 := make([]byte, len(m.Version)*10)
		var j4 int
		for _, num1 := range m.Version {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j4))
		i += copy(dAtA[i:], dAtA5[:j4])
	}
	if len(m.Timestamp) > 0 {
		var j6 int
		dAtA8 := make([]byte, len(m.Timestamp)*10)
		for _, num := range m.Timestamp {
			x7 := (uint64(num) << 1) ^ uint64((num >> 63))
			for x7 >= 1<<7 {
				dAtA8[j6] = uint8(uint64(x7)&0x7f | 0x80)
				j6++
				x7 >>= 7
			}
			dAtA8[j6] = uint8(x7)
			j6++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j6))
		i += copy(dAtA[i:], dAtA8[:j6])
	}
	if len(m.Changeset) > 0 {
		var j9 int
		dAtA11 := make([]byte, len(m.Changeset)*10)
		for _, num := range m.Changeset {
			x10 := (uint64(num) << 1) ^ uint64((num >> 63))
			for x10 >= 1<<7 {
				dAtA11[j9] = uint8(uint64(x10)&0x7f | 0x80)
				j9++
				x10 >>= 7
			}
			dAtA11[j9] = uint8(x10)
			j9++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j9))
		i += copy(dAtA[i:], dAtA11[:j9])
	}
	if len(m.Uid) > 0 {
		dAtA12 := make([]byte, len(m.Uid)*5)
		var j13 int
		for _, num := range m.Uid {
			x14 := (uint32(num) << 1) ^ uint32((num >> 31))
			for x14 >= 1<<7 {
				dAtA12[j13] = uint8(uint64(x14)&0x7f | 0x80)
				j13++
				x14 >>= 7
			}
			dAtA12[j13] = uint8(x14)
			j13++
		}
		dAtA[i] = 0x22
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j13))
		i += copy(dAtA[i:], dAtA12[:j13])
	}
	if len(m.UserSid) > 0 {
		dAtA15 := make([]byte, len(m.UserSid)*5)
		var j16 int
		for _, num := range m.UserSid {
			x17 := (uint32(num) << 1) ^ uint32((num >> 31))
			for x17 >= 1<<7 {
				dAtA15[j16] = uint8(uint64(x17)&0x7f | 0x80)
				j16++
				x17 >>= 7
			}
			dAtA15[j16] = uint8(x17)
			j16++
		}
		dAtA[i] = 0x2a
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j16))
		i += copy(dAtA[i:], dAtA15[:j16])
	}
	if len(m.Visible) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(len(m.Visible)))
		for _, b := range m.Visible {
			if b {
				dAtA[i] = 1
			} else {
				dAtA[i] = 0
			}
			i++
		}
	}
	return i, nil
}

func (m *ChangeSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangeSet) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.Id))
	return i, nil
}

func (m *Node) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Node) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64((uint64(m.Id)<<1)^uint64((m.Id>>63))))
	if len(m.Keys) > 0 {
		dAtA19 := make([]byte, len(m.Keys)*10)
		var j18 int
		for _, num := range m.Keys {
			for num >= 1<<7 {
				dAtA19[j18] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j18++
			}
			dAtA19[j18] = uint8(num)
			j18++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j18))
		i += copy(dAtA[i:], dAtA19[:j18])
	}
	if len(m.Vals) > 0 {
		dAtA21 := make([]byte, len(m.Vals)*10)
		var j20 int
		for _, num := range m.Vals {
			for num >= 1<<7 {
				dAtA21[j20] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j20++
			}
			dAtA21[j20] = uint8(num)
			j20++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j20))
		i += copy(dAtA[i:], dAtA21[:j20])
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.Info.Size()))
	n22, err := m.Info.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	dAtA[i] = 0x40
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64((uint64(m.Lat)<<1)^uint64((m.Lat>>63))))
	dAtA[i] = 0x48
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64((uint64(m.Lon)<<1)^uint64((m.Lon>>63))))
	return i, nil
}

func (m *DenseNodes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DenseNodes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		var j23 int
		dAtA25 := make([]byte, len(m.Id)*10)
		for _, num := range m.Id {
			x24 := (uint64(num) << 1) ^ uint64((num >> 63))
			for x24 >= 1<<7 {
				dAtA25[j23] = uint8(uint64(x24)&0x7f | 0x80)
				j23++
				x24 >>= 7
			}
			dAtA25[j23] = uint8(x24)
			j23++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j23))
		i += copy(dAtA[i:], dAtA25[:j23])
	}
	if m.Denseinfo != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(m.Denseinfo.Size()))
		n26, err := m.Denseinfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if len(m.Lat) > 0 {
		var j27 int
		dAtA29 := make([]byte, len(m.Lat)*10)
		for _, num := range m.Lat {
			x28 := (uint64(num) << 1) ^ uint64((num >> 63))
			for x28 >= 1<<7 {
				dAtA29[j27] = uint8(uint64(x28)&0x7f | 0x80)
				j27++
				x28 >>= 7
			}
			dAtA29[j27] = uint8(x28)
			j27++
		}
		dAtA[i] = 0x42
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j27))
		i += copy(dAtA[i:], dAtA29[:j27])
	}
	if len(m.Lon) > 0 {
		var j30 int
		dAtA32 := make([]byte, len(m.Lon)*10)
		for _, num := range m.Lon {
			x31 := (uint64(num) << 1) ^ uint64((num >> 63))
			for x31 >= 1<<7 {
				dAtA32[j30] = uint8(uint64(x31)&0x7f | 0x80)
				j30++
				x31 >>= 7
			}
			dAtA32[j30] = uint8(x31)
			j30++
		}
		dAtA[i] = 0x4a
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j30))
		i += copy(dAtA[i:], dAtA32[:j30])
	}
	if len(m.KeysVals) > 0 {
		dAtA34 := make([]byte, len(m.KeysVals)*10)
		var j33 int
		for _, num1 := range m.KeysVals {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA34[j33] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j33++
			}
			dAtA34[j33] = uint8(num)
			j33++
		}
		dAtA[i] = 0x52
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j33))
		i += copy(dAtA[i:], dAtA34[:j33])
	}
	return i, nil
}

func (m *Way) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Way) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.Id))
	if len(m.Keys) > 0 {
		dAtA36 := make([]byte, len(m.Keys)*10)
		var j35 int
		for _, num := range m.Keys {
			for num >= 1<<7 {
				dAtA36[j35] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j35++
			}
			dAtA36[j35] = uint8(num)
			j35++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j35))
		i += copy(dAtA[i:], dAtA36[:j35])
	}
	if len(m.Vals) > 0 {
		dAtA38 := make([]byte, len(m.Vals)*10)
		var j37 int
		for _, num := range m.Vals {
			for num >= 1<<7 {
				dAtA38[j37] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j37++
			}
			dAtA38[j37] = uint8(num)
			j37++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j37))
		i += copy(dAtA[i:], dAtA38[:j37])
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.Info.Size()))
	n39, err := m.Info.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n39
	if len(m.Refs) > 0 {
		var j40 int
		dAtA42 := make([]byte, len(m.Refs)*10)
		for _, num := range m.Refs {
			x41 := (uint64(num) << 1) ^ uint64((num >> 63))
			for x41 >= 1<<7 {
				dAtA42[j40] = uint8(uint64(x41)&0x7f | 0x80)
				j40++
				x41 >>= 7
			}
			dAtA42[j40] = uint8(x41)
			j40++
		}
		dAtA[i] = 0x42
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j40))
		i += copy(dAtA[i:], dAtA42[:j40])
	}
	return i, nil
}

func (m *Relation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Relation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.Id))
	if len(m.Keys) > 0 {
		dAtA44 := make([]byte, len(m.Keys)*10)
		var j43 int
		for _, num := range m.Keys {
			for num >= 1<<7 {
				dAtA44[j43] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j43++
			}
			dAtA44[j43] = uint8(num)
			j43++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j43))
		i += copy(dAtA[i:], dAtA44[:j43])
	}
	if len(m.Vals) > 0 {
		dAtA46 := make([]byte, len(m.Vals)*10)
		var j45 int
		for _, num := range m.Vals {
			for num >= 1<<7 {
				dAtA46[j45] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j45++
			}
			dAtA46[j45] = uint8(num)
			j45++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j45))
		i += copy(dAtA[i:], dAtA46[:j45])
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintOsmformat(dAtA, i, uint64(m.Info.Size()))
	n47, err := m.Info.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n47
	if len(m.RolesSid) > 0 {
		dAtA49 := make([]byte, len(m.RolesSid)*10)
		var j48 int
		for _, num1 := range m.RolesSid {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA49[j48] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j48++
			}
			dAtA49[j48] = uint8(num)
			j48++
		}
		dAtA[i] = 0x42
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j48))
		i += copy(dAtA[i:], dAtA49[:j48])
	}
	if len(m.Memids) > 0 {
		var j50 int
		dAtA52 := make([]byte, len(m.Memids)*10)
		for _, num := range m.Memids {
			x51 := (uint64(num) << 1) ^ uint64((num >> 63))
			for x51 >= 1<<7 {
				dAtA52[j50] = uint8(uint64(x51)&0x7f | 0x80)
				j50++
				x51 >>= 7
			}
			dAtA52[j50] = uint8(x51)
			j50++
		}
		dAtA[i] = 0x4a
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j50))
		i += copy(dAtA[i:], dAtA52[:j50])
	}
	if len(m.Types) > 0 {
		dAtA54 := make([]byte, len(m.Types)*10)
		var j53 int
		for _, num := range m.Types {
			for num >= 1<<7 {
				dAtA54[j53] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j53++
			}
			dAtA54[j53] = uint8(num)
			j53++
		}
		dAtA[i] = 0x52
		i++
		i = encodeVarintOsmformat(dAtA, i, uint64(j53))
		i += copy(dAtA[i:], dAtA54[:j53])
	}
	return i, nil
}

func encodeVarintOsmformat(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HeaderBlock) Size() (n int) {
	var l int
	_ = l
	if m.Bbox != nil {
		l = m.Bbox.Size()
		n += 1 + l + sovOsmformat(uint64(l))
	}
	if len(m.RequiredFeatures) > 0 {
		for _, s := range m.RequiredFeatures {
			l = len(s)
			n += 1 + l + sovOsmformat(uint64(l))
		}
	}
	if len(m.OptionalFeatures) > 0 {
		for _, s := range m.OptionalFeatures {
			l = len(s)
			n += 1 + l + sovOsmformat(uint64(l))
		}
	}
	l = len(m.Writingprogram)
	n += 2 + l + sovOsmformat(uint64(l))
	l = len(m.Source)
	n += 2 + l + sovOsmformat(uint64(l))
	n += 2 + sovOsmformat(uint64(m.OsmosisReplicationTimestamp))
	n += 2 + sovOsmformat(uint64(m.OsmosisReplicationSequenceNumber))
	l = len(m.OsmosisReplicationBaseUrl)
	n += 2 + l + sovOsmformat(uint64(l))
	return n
}

func (m *HeaderBBox) Size() (n int) {
	var l int
	_ = l
	n += 1 + sozOsmformat(uint64(m.Left))
	n += 1 + sozOsmformat(uint64(m.Right))
	n += 1 + sozOsmformat(uint64(m.Top))
	n += 1 + sozOsmformat(uint64(m.Bottom))
	return n
}

func (m *PrimitiveBlock) Size() (n int) {
	var l int
	_ = l
	if m.Stringtable != nil {
		l = m.Stringtable.Size()
		n += 1 + l + sovOsmformat(uint64(l))
	}
	if len(m.Primitivegroup) > 0 {
		for _, e := range m.Primitivegroup {
			l = e.Size()
			n += 1 + l + sovOsmformat(uint64(l))
		}
	}
	if m.Granularity != nil {
		n += 2 + sovOsmformat(uint64(*m.Granularity))
	}
	if m.DateGranularity != nil {
		n += 2 + sovOsmformat(uint64(*m.DateGranularity))
	}
	if m.LatOffset != nil {
		n += 2 + sovOsmformat(uint64(*m.LatOffset))
	}
	if m.LonOffset != nil {
		n += 2 + sovOsmformat(uint64(*m.LonOffset))
	}
	return n
}

func (m *PrimitiveGroup) Size() (n int) {
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovOsmformat(uint64(l))
		}
	}
	if m.Dense != nil {
		l = m.Dense.Size()
		n += 1 + l + sovOsmformat(uint64(l))
	}
	if len(m.Ways) > 0 {
		for _, e := range m.Ways {
			l = e.Size()
			n += 1 + l + sovOsmformat(uint64(l))
		}
	}
	if len(m.Relations) > 0 {
		for _, e := range m.Relations {
			l = e.Size()
			n += 1 + l + sovOsmformat(uint64(l))
		}
	}
	if len(m.Changesets) > 0 {
		for _, e := range m.Changesets {
			l = e.Size()
			n += 1 + l + sovOsmformat(uint64(l))
		}
	}
	return n
}

func (m *StringTable) Size() (n int) {
	var l int
	_ = l
	if len(m.S) > 0 {
		for _, b := range m.S {
			l = len(b)
			n += 1 + l + sovOsmformat(uint64(l))
		}
	}
	return n
}

func (m *Info) Size() (n int) {
	var l int
	_ = l
	if m.Version != nil {
		n += 1 + sovOsmformat(uint64(*m.Version))
	}
	n += 1 + sovOsmformat(uint64(m.Timestamp))
	n += 1 + sovOsmformat(uint64(m.Changeset))
	n += 1 + sovOsmformat(uint64(m.Uid))
	n += 1 + sovOsmformat(uint64(m.UserSid))
	n += 2
	return n
}

func (m *DenseInfo) Size() (n int) {
	var l int
	_ = l
	if len(m.Version) > 0 {
		l = 0
		for _, e := range m.Version {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Timestamp) > 0 {
		l = 0
		for _, e := range m.Timestamp {
			l += sozOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Changeset) > 0 {
		l = 0
		for _, e := range m.Changeset {
			l += sozOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Uid) > 0 {
		l = 0
		for _, e := range m.Uid {
			l += sozOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.UserSid) > 0 {
		l = 0
		for _, e := range m.UserSid {
			l += sozOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Visible) > 0 {
		n += 1 + sovOsmformat(uint64(len(m.Visible))) + len(m.Visible)*1
	}
	return n
}

func (m *ChangeSet) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovOsmformat(uint64(m.Id))
	return n
}

func (m *Node) Size() (n int) {
	var l int
	_ = l
	n += 1 + sozOsmformat(uint64(m.Id))
	if len(m.Keys) > 0 {
		l = 0
		for _, e := range m.Keys {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Vals) > 0 {
		l = 0
		for _, e := range m.Vals {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	l = m.Info.Size()
	n += 1 + l + sovOsmformat(uint64(l))
	n += 1 + sozOsmformat(uint64(m.Lat))
	n += 1 + sozOsmformat(uint64(m.Lon))
	return n
}

func (m *DenseNodes) Size() (n int) {
	var l int
	_ = l
	if len(m.Id) > 0 {
		l = 0
		for _, e := range m.Id {
			l += sozOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if m.Denseinfo != nil {
		l = m.Denseinfo.Size()
		n += 1 + l + sovOsmformat(uint64(l))
	}
	if len(m.Lat) > 0 {
		l = 0
		for _, e := range m.Lat {
			l += sozOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Lon) > 0 {
		l = 0
		for _, e := range m.Lon {
			l += sozOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.KeysVals) > 0 {
		l = 0
		for _, e := range m.KeysVals {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	return n
}

func (m *Way) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovOsmformat(uint64(m.Id))
	if len(m.Keys) > 0 {
		l = 0
		for _, e := range m.Keys {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Vals) > 0 {
		l = 0
		for _, e := range m.Vals {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	l = m.Info.Size()
	n += 1 + l + sovOsmformat(uint64(l))
	if len(m.Refs) > 0 {
		l = 0
		for _, e := range m.Refs {
			l += sozOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	return n
}

func (m *Relation) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovOsmformat(uint64(m.Id))
	if len(m.Keys) > 0 {
		l = 0
		for _, e := range m.Keys {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Vals) > 0 {
		l = 0
		for _, e := range m.Vals {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	l = m.Info.Size()
	n += 1 + l + sovOsmformat(uint64(l))
	if len(m.RolesSid) > 0 {
		l = 0
		for _, e := range m.RolesSid {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Memids) > 0 {
		l = 0
		for _, e := range m.Memids {
			l += sozOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	if len(m.Types) > 0 {
		l = 0
		for _, e := range m.Types {
			l += sovOsmformat(uint64(e))
		}
		n += 1 + sovOsmformat(uint64(l)) + l
	}
	return n
}

func sovOsmformat(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozOsmformat(x uint64) (n int) {
	return sovOsmformat(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *HeaderBlock) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderBlock: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderBlock: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bbox", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bbox == nil {
				m.Bbox = &HeaderBBox{}
			}
			if err := m.Bbox.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequiredFeatures", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequiredFeatures = append(m.RequiredFeatures, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OptionalFeatures", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OptionalFeatures = append(m.OptionalFeatures, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Writingprogram", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Writingprogram = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 32:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OsmosisReplicationTimestamp", wireType)
			}
			m.OsmosisReplicationTimestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OsmosisReplicationTimestamp |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 33:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OsmosisReplicationSequenceNumber", wireType)
			}
			m.OsmosisReplicationSequenceNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OsmosisReplicationSequenceNumber |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OsmosisReplicationBaseUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OsmosisReplicationBaseUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderBBox) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderBBox: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderBBox: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Left", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.Left = int64(v)
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Right", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.Right = int64(v)
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Top", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.Top = int64(v)
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bottom", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.Bottom = int64(v)
			hasFields[0] |= uint64(0x00000008)
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return proto.NewRequiredNotSetError("left")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return proto.NewRequiredNotSetError("right")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return proto.NewRequiredNotSetError("top")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return proto.NewRequiredNotSetError("bottom")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrimitiveBlock) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrimitiveBlock: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrimitiveBlock: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stringtable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stringtable == nil {
				m.Stringtable = &StringTable{}
			}
			if err := m.Stringtable.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitivegroup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Primitivegroup = append(m.Primitivegroup, &PrimitiveGroup{})
			if err := m.Primitivegroup[len(m.Primitivegroup)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Granularity", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Granularity = &v
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DateGranularity", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DateGranularity = &v
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LatOffset", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LatOffset = &v
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LonOffset", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LonOffset = &v
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return proto.NewRequiredNotSetError("stringtable")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrimitiveGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrimitiveGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrimitiveGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, Node{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dense", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dense == nil {
				m.Dense = &DenseNodes{}
			}
			if err := m.Dense.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ways", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ways = append(m.Ways, Way{})
			if err := m.Ways[len(m.Ways)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Relations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Relations = append(m.Relations, Relation{})
			if err := m.Relations[len(m.Relations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Changesets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Changesets = append(m.Changesets, ChangeSet{})
			if err := m.Changesets[len(m.Changesets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringTable) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringTable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringTable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field S", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.S = append(m.S, make([]byte, postIndex-iNdEx))
			copy(m.S[len(m.S)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Info) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Info: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Info: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Version = &v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Changeset", wireType)
			}
			m.Changeset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Changeset |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
			m.Uid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Uid |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserSid", wireType)
			}
			m.UserSid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UserSid |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Visible", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Visible = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DenseInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DenseInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DenseInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Version = append(m.Version, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Version = append(m.Version, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
		case 2:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
				m.Timestamp = append(m.Timestamp, int64(v))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
					m.Timestamp = append(m.Timestamp, int64(v))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
		case 3:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
				m.Changeset = append(m.Changeset, int64(v))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
					m.Changeset = append(m.Changeset, int64(v))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Changeset", wireType)
			}
		case 4:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
				m.Uid = append(m.Uid, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
					m.Uid = append(m.Uid, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
		case 5:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
				m.UserSid = append(m.UserSid, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
					m.UserSid = append(m.UserSid, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field UserSid", wireType)
			}
		case 6:
			if wireType == 0 {
				var v int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Visible = append(m.Visible, bool(v != 0))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Visible = append(m.Visible, bool(v != 0))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Visible", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangeSet) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangeSet: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangeSet: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return proto.NewRequiredNotSetError("id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Node) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Node: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Node: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.Id = int64(v)
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Keys = append(m.Keys, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Keys = append(m.Keys, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Vals = append(m.Vals, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Vals = append(m.Vals, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Vals", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lat", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.Lat = int64(v)
			hasFields[0] |= uint64(0x00000002)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lon", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.Lon = int64(v)
			hasFields[0] |= uint64(0x00000004)
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return proto.NewRequiredNotSetError("id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return proto.NewRequiredNotSetError("lat")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return proto.NewRequiredNotSetError("lon")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DenseNodes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DenseNodes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DenseNodes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
				m.Id = append(m.Id, int64(v))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
					m.Id = append(m.Id, int64(v))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Denseinfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Denseinfo == nil {
				m.Denseinfo = &DenseInfo{}
			}
			if err := m.Denseinfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
				m.Lat = append(m.Lat, int64(v))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
					m.Lat = append(m.Lat, int64(v))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Lat", wireType)
			}
		case 9:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
				m.Lon = append(m.Lon, int64(v))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
					m.Lon = append(m.Lon, int64(v))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Lon", wireType)
			}
		case 10:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.KeysVals = append(m.KeysVals, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.KeysVals = append(m.KeysVals, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field KeysVals", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Way) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Way: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Way: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Keys = append(m.Keys, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Keys = append(m.Keys, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Vals = append(m.Vals, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Vals = append(m.Vals, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Vals", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
				m.Refs = append(m.Refs, int64(v))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
					m.Refs = append(m.Refs, int64(v))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Refs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return proto.NewRequiredNotSetError("id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Relation) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Relation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Relation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Keys = append(m.Keys, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Keys = append(m.Keys, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Vals = append(m.Vals, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Vals = append(m.Vals, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Vals", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOsmformat
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RolesSid = append(m.RolesSid, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RolesSid = append(m.RolesSid, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesSid", wireType)
			}
		case 9:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
				m.Memids = append(m.Memids, int64(v))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
					m.Memids = append(m.Memids, int64(v))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Memids", wireType)
			}
		case 10:
			if wireType == 0 {
				var v Relation_MemberType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (Relation_MemberType(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Types = append(m.Types, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthOsmformat
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v Relation_MemberType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowOsmformat
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (Relation_MemberType(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Types = append(m.Types, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Types", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOsmformat(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOsmformat
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return proto.NewRequiredNotSetError("id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipOsmformat(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowOsmformat
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOsmformat
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthOsmformat
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowOsmformat
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipOsmformat(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthOsmformat = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowOsmformat   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("parser/pbf/internal/osmpbf/osmformat.proto", fileDescriptorOsmformat) }

var fileDescriptorOsmformat = []byte{
	// 1109 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0x4f, 0x6f, 0x1b, 0xc5,
	0x1b, 0xee, 0xfe, 0x71, 0x62, 0xbf, 0x4e, 0xf3, 0x73, 0xa6, 0x51, 0xb5, 0xbf, 0x36, 0x4d, 0xb6,
	0x8b, 0x8a, 0x56, 0x40, 0x6d, 0xd7, 0xa2, 0x42, 0xea, 0x01, 0xa9, 0xa6, 0xa5, 0xad, 0x04, 0x29,
	0xda, 0x04, 0x2a, 0x4e, 0xd6, 0xd8, 0x3b, 0x76, 0x46, 0xdd, 0xdd, 0xd9, 0xce, 0xcc, 0xa6, 0xf1,
	0x67, 0xe0, 0xc2, 0x1d, 0x89, 0x0b, 0x7c, 0x10, 0x38, 0x20, 0xf5, 0xc8, 0x27, 0x40, 0x28, 0x7c,
	0x0b, 0x4e, 0x68, 0x66, 0x77, 0xbc, 0xeb, 0x24, 0x57, 0xb8, 0x79, 0x9e, 0xe7, 0x99, 0x77, 0xde,
	0xe7, 0xfd, 0xb3, 0x86, 0x0f, 0x72, 0xcc, 0x05, 0xe1, 0x83, 0x7c, 0x3a, 0x1f, 0xd0, 0x4c, 0x12,
	0x9e, 0xe1, 0x64, 0xc0, 0x44, 0xaa, 0xce, 0x4c, 0xa4, 0x73, 0xc6, 0x53, 0x2c, 0xfb, 0x39, 0x67,
	0x92, 0xa1, 0x8d, 0x12, 0xbf, 0x75, 0x7f, 0x41, 0xe5, 0x49, 0x31, 0xed, 0xcf, 0x58, 0x3a, 0x58,
	0xb0, 0x05, 0x1b, 0x68, 0x7a, 0x5a, 0xcc, 0xf5, 0x49, 0x1f, 0xf4, 0xaf, 0xf2, 0x5a, 0xf0, 0xab,
	0x03, 0xdd, 0xe7, 0x04, 0xc7, 0x84, 0x8f, 0x13, 0x36, 0x7b, 0x8d, 0xde, 0x07, 0x77, 0x3a, 0x65,
	0x67, 0x9e, 0xe5, 0x5b, 0x61, 0x77, 0x84, 0xfa, 0x65, 0xd4, 0x7e, 0x25, 0x19, 0xb3, 0xb3, 0x48,
	0xf3, 0xe8, 0x43, 0xd8, 0xe1, 0xe4, 0x4d, 0x41, 0x39, 0x89, 0x27, 0x73, 0x82, 0x65, 0xc1, 0x89,
	0xf0, 0x5c, 0xdf, 0x09, 0x3b, 0x51, 0xcf, 0x10, 0x9f, 0x57, 0xb8, 0x12, 0xb3, 0x5c, 0x52, 0x96,
	0xe1, 0xa4, 0x16, 0xb7, 0x4a, 0xb1, 0x21, 0x56, 0xe2, 0x8f, 0x60, 0xfb, 0x2d, 0xa7, 0x92, 0x66,
	0x8b, 0x9c, 0xb3, 0x05, 0xc7, 0xa9, 0xd7, 0xf3, 0xad, 0xb0, 0x33, 0x76, 0xdf, 0xfd, 0x71, 0x70,
	0x2d, 0xba, 0xc0, 0xa1, 0x3d, 0xd8, 0x10, 0xac, 0xe0, 0x33, 0xe2, 0xed, 0x34, 0x54, 0x15, 0x86,
	0x9e, 0xc3, 0x1d, 0x26, 0x52, 0x26, 0xa8, 0x98, 0x70, 0x92, 0x27, 0x74, 0x86, 0xd5, 0x63, 0x13,
	0x49, 0x53, 0x22, 0x24, 0x4e, 0x73, 0xcf, 0xf7, 0xad, 0xd0, 0xa9, 0x2e, 0xdd, 0xae, 0xa4, 0x51,
	0xad, 0x3c, 0x36, 0x42, 0x74, 0x04, 0xef, 0x5d, 0x15, 0x49, 0x90, 0x37, 0x05, 0xc9, 0x66, 0x64,
	0x92, 0x15, 0xe9, 0x94, 0x70, 0xef, 0x6e, 0x23, 0x9e, 0x7f, 0x39, 0xde, 0x51, 0x25, 0x3f, 0xd4,
	0x6a, 0xf4, 0x14, 0xf6, 0xae, 0x0a, 0x3a, 0xc5, 0x82, 0x4c, 0x0a, 0x9e, 0x78, 0x41, 0xc3, 0xd2,
	0xff, 0x2f, 0x47, 0x1b, 0x63, 0x41, 0xbe, 0xe6, 0x49, 0x70, 0x06, 0x50, 0xf7, 0x07, 0x79, 0xe0,
	0x26, 0x64, 0x2e, 0x3d, 0xcb, 0xb7, 0x43, 0x54, 0x5d, 0xd6, 0x08, 0xba, 0x05, 0x2d, 0x4e, 0x17,
	0x27, 0xd2, 0xb3, 0x1b, 0x54, 0x09, 0xa1, 0x9b, 0xe0, 0x48, 0x96, 0x7b, 0x4e, 0x83, 0x51, 0x80,
	0xaa, 0xef, 0x94, 0x49, 0xc9, 0x52, 0xcf, 0x6d, 0x50, 0x15, 0x16, 0xfc, 0x64, 0xc3, 0xf6, 0x57,
	0x9c, 0xa6, 0x54, 0xd2, 0x53, 0x52, 0x0e, 0xd0, 0x43, 0xe8, 0x0a, 0xc9, 0x69, 0xb6, 0x90, 0x78,
	0x9a, 0x10, 0x9d, 0x45, 0x77, 0x74, 0xc3, 0xcc, 0xd1, 0x91, 0xa6, 0x8e, 0x15, 0x15, 0x35, 0x75,
	0xe8, 0x53, 0xd8, 0xce, 0x4d, 0xa0, 0x05, 0x67, 0x45, 0xee, 0xd9, 0xbe, 0x13, 0x76, 0x47, 0x37,
	0xcd, 0xcd, 0xd5, 0x33, 0xcf, 0x14, 0x1b, 0x5d, 0x50, 0xa3, 0x7b, 0xd0, 0x5d, 0x70, 0x9c, 0x15,
	0x09, 0xe6, 0x54, 0x2e, 0xf5, 0x30, 0xb4, 0x1e, 0x39, 0x0f, 0x86, 0xc3, 0xa8, 0x89, 0xa3, 0x01,
	0xf4, 0x62, 0x2c, 0xc9, 0xa4, 0xa9, 0x45, 0x5a, 0xeb, 0x3e, 0x18, 0x0e, 0x87, 0xd1, 0xff, 0x14,
	0xfb, 0xac, 0x71, 0xc1, 0x07, 0x48, 0xb0, 0x9c, 0xb0, 0xf9, 0x5c, 0x10, 0xe9, 0xdd, 0x50, 0xed,
	0x7d, 0x64, 0x0d, 0xa3, 0x4e, 0x82, 0xe5, 0x4b, 0x8d, 0x69, 0x05, 0xcb, 0x8c, 0x62, 0xb7, 0x56,
	0xb0, 0xac, 0x54, 0x04, 0x7f, 0x5b, 0x8d, 0x2a, 0xe9, 0xf4, 0x51, 0x08, 0xad, 0x8c, 0xc5, 0x44,
	0x78, 0x96, 0x76, 0xb9, 0x65, 0x5c, 0x1e, 0xb2, 0x98, 0x98, 0xc6, 0x68, 0x81, 0x52, 0xc6, 0x24,
	0x13, 0xc4, 0xb3, 0xd7, 0x37, 0xf2, 0x89, 0x02, 0x95, 0x5c, 0x44, 0xa5, 0x00, 0xdd, 0x03, 0xf7,
	0x2d, 0x5e, 0x0a, 0xcf, 0xd1, 0x21, 0xbb, 0x46, 0xf8, 0x0a, 0x2f, 0xcd, 0x14, 0x28, 0x1a, 0x7d,
	0x0c, 0x1d, 0x4e, 0x12, 0x3d, 0x40, 0xe5, 0xc6, 0x76, 0x47, 0x3d, 0xa3, 0x8d, 0x2a, 0xa2, 0xba,
	0x50, 0x0b, 0xd1, 0x27, 0x00, 0xb3, 0x13, 0x9c, 0x2d, 0x88, 0x20, 0xb2, 0xdc, 0xdd, 0xee, 0x68,
	0xc7, 0x5c, 0xfb, 0x4c, 0x33, 0x47, 0x44, 0x56, 0xf7, 0x1a, 0xd2, 0xe0, 0x36, 0x74, 0x1b, 0x4d,
	0x47, 0x5b, 0x60, 0x95, 0xa6, 0xb7, 0x22, 0x4b, 0x04, 0xbf, 0x59, 0xe0, 0xbe, 0xc8, 0xe6, 0x0c,
	0xed, 0xc1, 0xe6, 0x29, 0xe1, 0x82, 0xb2, 0x4c, 0x7f, 0x79, 0x5a, 0x8f, 0xec, 0xfb, 0x0f, 0x22,
	0x03, 0xa1, 0x00, 0x3a, 0xf5, 0xca, 0xda, 0x8d, 0x15, 0xab, 0x61, 0xa5, 0x59, 0xbd, 0xea, 0x39,
	0x4d, 0xcd, 0x0a, 0x56, 0x43, 0x5e, 0xd0, 0xd8, 0x73, 0xd5, 0x0b, 0x66, 0xc8, 0x0b, 0x1a, 0xa3,
	0x03, 0x68, 0x17, 0x82, 0xf0, 0x89, 0xa0, 0xb1, 0xd7, 0xf2, 0xad, 0xf0, 0x7a, 0x45, 0x6e, 0x2a,
	0xf4, 0x88, 0xc6, 0x68, 0x1f, 0x36, 0x4f, 0xa9, 0xa0, 0x6a, 0xa0, 0x37, 0x7c, 0x2b, 0x6c, 0x1b,
	0xbe, 0x02, 0x83, 0x5f, 0x2c, 0xe8, 0xe8, 0x86, 0x5c, 0x36, 0xe3, 0x84, 0xad, 0xb1, 0xdd, 0xb3,
	0x6a, 0x33, 0xfe, 0xba, 0x19, 0x27, 0x44, 0x9a, 0x6f, 0x58, 0xf1, 0xd7, 0xad, 0xac, 0x14, 0xb5,
	0x91, 0x5d, 0x63, 0xc4, 0x09, 0x77, 0x34, 0xa7, 0x6d, 0xdc, 0x59, 0xb3, 0x61, 0xa8, 0x95, 0x89,
	0xbd, 0xa6, 0x09, 0x27, 0x6c, 0x57, 0x69, 0x55, 0x16, 0xee, 0x42, 0x67, 0xd5, 0x46, 0xb4, 0x0b,
	0x36, 0x8d, 0xf5, 0xee, 0x9a, 0x2a, 0xda, 0x34, 0x0e, 0x7e, 0xb6, 0xc0, 0x55, 0x13, 0xd7, 0xa0,
	0x51, 0x4d, 0xa3, 0x9b, 0xe0, 0xbe, 0x26, 0x4b, 0xa1, 0x3d, 0x5d, 0xd7, 0xc1, 0xf5, 0x59, 0xe1,
	0xa7, 0x38, 0x29, 0xe7, 0xb2, 0xc2, 0xd5, 0x59, 0xfd, 0xd5, 0xd0, 0x6c, 0xce, 0x74, 0x3b, 0x1a,
	0x2b, 0xa0, 0x4a, 0x68, 0x06, 0x56, 0xf1, 0xaa, 0x6b, 0x09, 0x96, 0x5e, 0xbb, 0xf9, 0x69, 0x4a,
	0xb0, 0xee, 0x66, 0xc2, 0x32, 0xaf, 0xb3, 0x86, 0xb3, 0x2c, 0xf8, 0xd1, 0x02, 0xa8, 0xb7, 0x03,
	0xa1, 0x2a, 0x59, 0x53, 0x46, 0x95, 0xea, 0x00, 0x3a, 0x7a, 0x67, 0xf4, 0xfb, 0x2d, 0xfd, 0xfe,
	0xce, 0xda, 0x62, 0xa9, 0x24, 0xa2, 0x5a, 0xa3, 0x0a, 0x5e, 0xe6, 0x60, 0xa2, 0xe8, 0x0c, 0x76,
	0x4d, 0x06, 0x35, 0xca, 0x32, 0x74, 0x00, 0x1d, 0xe5, 0x7b, 0xa2, 0x4d, 0xc3, 0x6a, 0x00, 0xda,
	0x0a, 0xfc, 0x06, 0x27, 0x22, 0xf8, 0xce, 0x02, 0xe7, 0x15, 0x5e, 0x5e, 0x5d, 0xe5, 0x7f, 0xb1,
	0x8c, 0x2e, 0x27, 0x73, 0xd1, 0xf0, 0xa0, 0xcf, 0xc1, 0x0f, 0x36, 0xb4, 0xcd, 0xde, 0xff, 0xc7,
	0x29, 0x1d, 0x40, 0x87, 0xb3, 0x84, 0x08, 0x3d, 0xb1, 0xed, 0xba, 0x52, 0x1a, 0x54, 0x23, 0x7b,
	0x0b, 0x36, 0x52, 0x92, 0xd2, 0x58, 0x34, 0x6a, 0x5c, 0x21, 0xe8, 0x21, 0xb4, 0xe4, 0x32, 0x27,
	0x65, 0x89, 0xb7, 0x47, 0xb7, 0x2f, 0x7e, 0xc3, 0xfa, 0x5f, 0x12, 0xf5, 0x27, 0x7b, 0xbc, 0xcc,
	0x89, 0xbe, 0x57, 0xaa, 0x83, 0xfb, 0x00, 0x35, 0x81, 0xda, 0xe0, 0x1e, 0xbe, 0x7c, 0xf2, 0xb4,
	0x77, 0x0d, 0x6d, 0x82, 0xf3, 0xea, 0xf1, 0xb7, 0x3d, 0x0b, 0x6d, 0x41, 0x3b, 0x7a, 0xfa, 0xc5,
	0xe3, 0xe3, 0x17, 0x2f, 0x0f, 0x7b, 0xf6, 0xf8, 0xee, 0xbb, 0xf3, 0x7d, 0xeb, 0xf7, 0xf3, 0x7d,
	0xeb, 0xcf, 0xf3, 0x7d, 0xeb, 0xfb, 0xbf, 0xf6, 0xaf, 0xc1, 0xf5, 0x19, 0x67, 0x62, 0xba, 0xec,
	0x4f, 0x69, 0x86, 0xf9, 0xf2, 0xb9, 0xf3, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xee, 0x1f, 0xea,
	0x2a, 0xa6, 0x09, 0x00, 0x00,
}

