<p align="center">
  <img  src="https://raw.githubusercontent.com/helmwave/logo/main/logo.png" style="max-height:100%;" height="300px" />
</p>

<h1 align="center"> Helmwave</h1>

<p align="center">
  <a href="https://github.com/helmwave/helmwave/actions?query=workflow%3Arelease"><img src="https://github.com/helmwave/helmwave/workflows/release/badge.svg" /></a>
  <a href="https://codecov.io/gh/helmwave/helmwave"><img src="https://codecov.io/gh/helmwave/helmwave/branch/main/graph/badge.svg?token=0WXxYhIG4S" alt="codecov"/></a>
  <a href="https://bestpractices.coreinfrastructure.org/projects/5426"><img src="https://bestpractices.coreinfrastructure.org/projects/5426/badge"></a>
  <a href="https://www.codacy.com/gh/helmwave/helmwave/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=helmwave/helmwave&amp;utm_campaign=Badge_Grade"><img src="https://app.codacy.com/project/badge/Grade/200ca37690b7463b976f1ece36b53a4e"/></a>
  <a href="https://www.codefactor.io/repository/github/helmwave/helmwave"><img src="https://www.codefactor.io/repository/github/helmwave/helmwave/badge" alt="CodeFactor" /></a>
  <img alt="GitHub" src="https://img.shields.io/github/license/zhilyaev/helmwave">
  <img alt="GitHub tag (latest SemVer)" src="https://img.shields.io/github/v/tag/zhilyaev/helmwave?label=latest">
</p>


🌊 Helmwave is **[helm3](https://github.com/helm/helm/)-native** tool for deploy your Helm Charts.
HelmWave is like docker-compose for helm.

> We focus on speed execution, tiny size, pretty debugging.

With 🌊 helmwave you will become a superhero:

- Deploy multiple environments by one step
- Separate values for environments
- Common values for apps
- Keep a directory of chart value files
- Maintain changes in version control
- Template values
- Step by Step deployment (depends_on, allow_failure)
- Live tracking kubernetes resources with kubedog
- Fetch data from external datasource like vault, aws sm
- ... and much more!

[![asciicast](https://asciinema.org/a/591181.svg)](https://asciinema.org/a/591181)

## 📖 [Documentation](https://docs.helmwave.app)

Documentation available at https://docs.helmwave.app


## Community, discussion, contribution, and support

- <a href="https://t.me/helmwave" ><img src="https://img.shields.io/badge/telegram-chat-179cde.svg?logo=telegram" /></a>
- [kanban](https://github.com/orgs/helmwave/projects/3)
- [contribution guide](https://github.com/helmwave/helmwave/blob/main/CONTRIBUTING.md)
- [security and vulnerabilities](https://github.com/helmwave/helmwave/blob/main/SECURITY.md)


## Stargazers over time

[![Stargazers over time](https://starchart.cc/helmwave/helmwave.svg)](https://starchart.cc/helmwave/helmwave)
