// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/reviews/v1beta/merchantreviews_common.proto

package reviewspb

import (
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The method used to collect the review.
type MerchantReviewAttributes_CollectionMethod int32

const (
	// Collection method unspecified.
	MerchantReviewAttributes_COLLECTION_METHOD_UNSPECIFIED MerchantReviewAttributes_CollectionMethod = 0
	// The user was not responding to a specific solicitation when they
	// submitted the review.
	MerchantReviewAttributes_MERCHANT_UNSOLICITED MerchantReviewAttributes_CollectionMethod = 1
	// The user submitted the review in response to a solicitation when the
	// user placed an order.
	MerchantReviewAttributes_POINT_OF_SALE MerchantReviewAttributes_CollectionMethod = 2
	// The user submitted the review in response to a solicitation after
	// fulfillment of the user's order.
	MerchantReviewAttributes_AFTER_FULFILLMENT MerchantReviewAttributes_CollectionMethod = 3
)

// Enum value maps for MerchantReviewAttributes_CollectionMethod.
var (
	MerchantReviewAttributes_CollectionMethod_name = map[int32]string{
		0: "COLLECTION_METHOD_UNSPECIFIED",
		1: "MERCHANT_UNSOLICITED",
		2: "POINT_OF_SALE",
		3: "AFTER_FULFILLMENT",
	}
	MerchantReviewAttributes_CollectionMethod_value = map[string]int32{
		"COLLECTION_METHOD_UNSPECIFIED": 0,
		"MERCHANT_UNSOLICITED":          1,
		"POINT_OF_SALE":                 2,
		"AFTER_FULFILLMENT":             3,
	}
)

func (x MerchantReviewAttributes_CollectionMethod) Enum() *MerchantReviewAttributes_CollectionMethod {
	p := new(MerchantReviewAttributes_CollectionMethod)
	*p = x
	return p
}

func (x MerchantReviewAttributes_CollectionMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MerchantReviewAttributes_CollectionMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_enumTypes[0].Descriptor()
}

func (MerchantReviewAttributes_CollectionMethod) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_enumTypes[0]
}

func (x MerchantReviewAttributes_CollectionMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MerchantReviewAttributes_CollectionMethod.Descriptor instead.
func (MerchantReviewAttributes_CollectionMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescGZIP(), []int{0, 0}
}

// How the issue affects the serving of the merchant review.
type MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity int32

const (
	// Not specified.
	MerchantReviewStatus_MerchantReviewItemLevelIssue_SEVERITY_UNSPECIFIED MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity = 0
	// This issue represents a warning and does not have a direct affect
	// on the merchant review.
	MerchantReviewStatus_MerchantReviewItemLevelIssue_NOT_IMPACTED MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity = 1
	// Issue disapproves the merchant review.
	MerchantReviewStatus_MerchantReviewItemLevelIssue_DISAPPROVED MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity = 2
)

// Enum value maps for MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity.
var (
	MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "NOT_IMPACTED",
		2: "DISAPPROVED",
	}
	MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"NOT_IMPACTED":         1,
		"DISAPPROVED":          2,
	}
)

func (x MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity) Enum() *MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity {
	p := new(MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity)
	*p = x
	return p
}

func (x MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_enumTypes[1].Descriptor()
}

func (MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_enumTypes[1]
}

func (x MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity.Descriptor instead.
func (MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescGZIP(), []int{1, 1, 0}
}

// Attributes.
type MerchantReviewAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Must be unique and stable across all requests. In other words, if
	// a request today and another 90 days ago refer to the same merchant, they
	// must have the same id.
	MerchantId *string `protobuf:"bytes,1,opt,name=merchant_id,json=merchantId,proto3,oneof" json:"merchant_id,omitempty"`
	// Optional. Human-readable display name for the merchant.
	MerchantDisplayName *string `protobuf:"bytes,2,opt,name=merchant_display_name,json=merchantDisplayName,proto3,oneof" json:"merchant_display_name,omitempty"`
	// Optional. URL to the merchant's main website. Do not use a redirect URL for
	// this value. In other words, the value should point directly to the
	// merchant's site.
	MerchantLink *string `protobuf:"bytes,3,opt,name=merchant_link,json=merchantLink,proto3,oneof" json:"merchant_link,omitempty"`
	// Optional. URL to the landing page that hosts the reviews for this merchant.
	// Do not use a redirect URL.
	MerchantRatingLink *string `protobuf:"bytes,4,opt,name=merchant_rating_link,json=merchantRatingLink,proto3,oneof" json:"merchant_rating_link,omitempty"`
	// Optional. The minimum possible number for the rating. This should be the
	// worst possible rating and should not be a value for no rating.
	MinRating *int64 `protobuf:"varint,5,opt,name=min_rating,json=minRating,proto3,oneof" json:"min_rating,omitempty"`
	// Optional. The maximum possible number for the rating. The value of the max
	// rating must be greater than the value of the min rating.
	MaxRating *int64 `protobuf:"varint,6,opt,name=max_rating,json=maxRating,proto3,oneof" json:"max_rating,omitempty"`
	// Optional. The reviewer's overall rating of the merchant.
	Rating *float64 `protobuf:"fixed64,7,opt,name=rating,proto3,oneof" json:"rating,omitempty"`
	// Optional. The title of the review.
	Title *string `protobuf:"bytes,8,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Required. This should be any freeform text provided by the user and should
	// not be truncated. If multiple responses to different questions are
	// provided, all responses should be included, with the minimal context for
	// the responses to make sense. Context should not be provided if questions
	// were left unanswered.
	Content *string `protobuf:"bytes,9,opt,name=content,proto3,oneof" json:"content,omitempty"`
	// Optional. A permanent, unique identifier for the author of the review in
	// the publisher's system.
	ReviewerId *string `protobuf:"bytes,10,opt,name=reviewer_id,json=reviewerId,proto3,oneof" json:"reviewer_id,omitempty"`
	// Optional. Display name of the review author.
	ReviewerUsername *string `protobuf:"bytes,11,opt,name=reviewer_username,json=reviewerUsername,proto3,oneof" json:"reviewer_username,omitempty"`
	// Optional. Set to true if the reviewer should remain anonymous.
	IsAnonymous *bool `protobuf:"varint,12,opt,name=is_anonymous,json=isAnonymous,proto3,oneof" json:"is_anonymous,omitempty"`
	// Optional. The method used to collect the review.
	CollectionMethod *MerchantReviewAttributes_CollectionMethod `protobuf:"varint,13,opt,name=collection_method,json=collectionMethod,proto3,enum=google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes_CollectionMethod,oneof" json:"collection_method,omitempty"`
	// Required. The timestamp indicating when the review was written.
	ReviewTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=review_time,json=reviewTime,proto3,oneof" json:"review_time,omitempty"`
	// Required. The language of the review defined by BCP-47 language code.
	ReviewLanguage *string `protobuf:"bytes,15,opt,name=review_language,json=reviewLanguage,proto3,oneof" json:"review_language,omitempty"`
	// Optional. The country where the reviewer made the order defined by ISO
	// 3166-1 Alpha-2 Country Code.
	ReviewCountry *string `protobuf:"bytes,16,opt,name=review_country,json=reviewCountry,proto3,oneof" json:"review_country,omitempty"`
}

func (x *MerchantReviewAttributes) Reset() {
	*x = MerchantReviewAttributes{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MerchantReviewAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantReviewAttributes) ProtoMessage() {}

func (x *MerchantReviewAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantReviewAttributes.ProtoReflect.Descriptor instead.
func (*MerchantReviewAttributes) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescGZIP(), []int{0}
}

func (x *MerchantReviewAttributes) GetMerchantId() string {
	if x != nil && x.MerchantId != nil {
		return *x.MerchantId
	}
	return ""
}

func (x *MerchantReviewAttributes) GetMerchantDisplayName() string {
	if x != nil && x.MerchantDisplayName != nil {
		return *x.MerchantDisplayName
	}
	return ""
}

func (x *MerchantReviewAttributes) GetMerchantLink() string {
	if x != nil && x.MerchantLink != nil {
		return *x.MerchantLink
	}
	return ""
}

func (x *MerchantReviewAttributes) GetMerchantRatingLink() string {
	if x != nil && x.MerchantRatingLink != nil {
		return *x.MerchantRatingLink
	}
	return ""
}

func (x *MerchantReviewAttributes) GetMinRating() int64 {
	if x != nil && x.MinRating != nil {
		return *x.MinRating
	}
	return 0
}

func (x *MerchantReviewAttributes) GetMaxRating() int64 {
	if x != nil && x.MaxRating != nil {
		return *x.MaxRating
	}
	return 0
}

func (x *MerchantReviewAttributes) GetRating() float64 {
	if x != nil && x.Rating != nil {
		return *x.Rating
	}
	return 0
}

func (x *MerchantReviewAttributes) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *MerchantReviewAttributes) GetContent() string {
	if x != nil && x.Content != nil {
		return *x.Content
	}
	return ""
}

func (x *MerchantReviewAttributes) GetReviewerId() string {
	if x != nil && x.ReviewerId != nil {
		return *x.ReviewerId
	}
	return ""
}

func (x *MerchantReviewAttributes) GetReviewerUsername() string {
	if x != nil && x.ReviewerUsername != nil {
		return *x.ReviewerUsername
	}
	return ""
}

func (x *MerchantReviewAttributes) GetIsAnonymous() bool {
	if x != nil && x.IsAnonymous != nil {
		return *x.IsAnonymous
	}
	return false
}

func (x *MerchantReviewAttributes) GetCollectionMethod() MerchantReviewAttributes_CollectionMethod {
	if x != nil && x.CollectionMethod != nil {
		return *x.CollectionMethod
	}
	return MerchantReviewAttributes_COLLECTION_METHOD_UNSPECIFIED
}

func (x *MerchantReviewAttributes) GetReviewTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReviewTime
	}
	return nil
}

func (x *MerchantReviewAttributes) GetReviewLanguage() string {
	if x != nil && x.ReviewLanguage != nil {
		return *x.ReviewLanguage
	}
	return ""
}

func (x *MerchantReviewAttributes) GetReviewCountry() string {
	if x != nil && x.ReviewCountry != nil {
		return *x.ReviewCountry
	}
	return ""
}

// The status of a merchant review, data validation issues, that is, information
// about a merchant review computed asynchronously.
type MerchantReviewStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The intended destinations for the merchant review.
	DestinationStatuses []*MerchantReviewStatus_MerchantReviewDestinationStatus `protobuf:"bytes,3,rep,name=destination_statuses,json=destinationStatuses,proto3" json:"destination_statuses,omitempty"`
	// Output only. A list of all issues associated with the merchant review.
	ItemLevelIssues []*MerchantReviewStatus_MerchantReviewItemLevelIssue `protobuf:"bytes,4,rep,name=item_level_issues,json=itemLevelIssues,proto3" json:"item_level_issues,omitempty"`
	// Output only. Date on which the item has been created, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Date on which the item has been last updated, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
}

func (x *MerchantReviewStatus) Reset() {
	*x = MerchantReviewStatus{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MerchantReviewStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantReviewStatus) ProtoMessage() {}

func (x *MerchantReviewStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantReviewStatus.ProtoReflect.Descriptor instead.
func (*MerchantReviewStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescGZIP(), []int{1}
}

func (x *MerchantReviewStatus) GetDestinationStatuses() []*MerchantReviewStatus_MerchantReviewDestinationStatus {
	if x != nil {
		return x.DestinationStatuses
	}
	return nil
}

func (x *MerchantReviewStatus) GetItemLevelIssues() []*MerchantReviewStatus_MerchantReviewItemLevelIssue {
	if x != nil {
		return x.ItemLevelIssues
	}
	return nil
}

func (x *MerchantReviewStatus) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MerchantReviewStatus) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

// The destination status of the merchant review status.
type MerchantReviewStatus_MerchantReviewDestinationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the reporting context.
	ReportingContext typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,1,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum" json:"reporting_context,omitempty"`
}

func (x *MerchantReviewStatus_MerchantReviewDestinationStatus) Reset() {
	*x = MerchantReviewStatus_MerchantReviewDestinationStatus{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MerchantReviewStatus_MerchantReviewDestinationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantReviewStatus_MerchantReviewDestinationStatus) ProtoMessage() {}

func (x *MerchantReviewStatus_MerchantReviewDestinationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantReviewStatus_MerchantReviewDestinationStatus.ProtoReflect.Descriptor instead.
func (*MerchantReviewStatus_MerchantReviewDestinationStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescGZIP(), []int{1, 0}
}

func (x *MerchantReviewStatus_MerchantReviewDestinationStatus) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil {
		return x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

// The ItemLevelIssue of the merchant review status.
type MerchantReviewStatus_MerchantReviewItemLevelIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The error code of the issue.
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	// Output only. How this issue affects serving of the merchant review.
	Severity MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=google.shopping.merchant.reviews.v1beta.MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity" json:"severity,omitempty"`
	// Output only. Whether the issue can be resolved by the merchant.
	Resolution string `protobuf:"bytes,3,opt,name=resolution,proto3" json:"resolution,omitempty"`
	// Output only. The attribute's name, if the issue is caused by a single
	// attribute.
	Attribute string `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
	// Output only. The reporting context the issue applies to.
	ReportingContext typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,5,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum" json:"reporting_context,omitempty"`
	// Output only. A short issue description in English.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. A detailed issue description in English.
	Detail string `protobuf:"bytes,7,opt,name=detail,proto3" json:"detail,omitempty"`
	// Output only. The URL of a web page to help with resolving this issue.
	Documentation string `protobuf:"bytes,8,opt,name=documentation,proto3" json:"documentation,omitempty"`
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) Reset() {
	*x = MerchantReviewStatus_MerchantReviewItemLevelIssue{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantReviewStatus_MerchantReviewItemLevelIssue) ProtoMessage() {}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantReviewStatus_MerchantReviewItemLevelIssue.ProtoReflect.Descriptor instead.
func (*MerchantReviewStatus_MerchantReviewItemLevelIssue) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescGZIP(), []int{1, 1}
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) GetSeverity() MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity {
	if x != nil {
		return x.Severity
	}
	return MerchantReviewStatus_MerchantReviewItemLevelIssue_SEVERITY_UNSPECIFIED
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) GetResolution() string {
	if x != nil {
		return x.Resolution
	}
	return ""
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil {
		return x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

func (x *MerchantReviewStatus_MerchantReviewItemLevelIssue) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

var File_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDesc = []byte{
	0x0a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xff, 0x09, 0x0a, 0x18, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x12, 0x29, 0x0a, 0x0b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x3c, 0x0a, 0x15, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x01, 0x52, 0x13, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0d, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x0c, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x3a, 0x0a, 0x14, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x12, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6e,
	0x6b, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52,
	0x09, 0x6d, 0x69, 0x6e, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a,
	0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x05, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x52, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x06, 0x52, 0x06, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x07, 0x52, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x08,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0b,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x65, 0x72, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x11, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x65, 0x72, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0a, 0x52, 0x10, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2b,
	0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0b, 0x52, 0x0b, 0x69, 0x73, 0x41,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x88, 0x01, 0x01, 0x12, 0x89, 0x01, 0x0a, 0x11,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x0c, 0x52, 0x10, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x0d, 0x52,
	0x0a, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x31,
	0x0a, 0x0f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x0e, 0x52, 0x0e,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x2f, 0x0a, 0x0e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x72, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0f,
	0x52, 0x0d, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x88,
	0x01, 0x01, 0x22, 0x79, 0x0a, 0x10, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x4d, 0x45, 0x52,
	0x43, 0x48, 0x41, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x4f, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x4f, 0x46, 0x5f,
	0x53, 0x41, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f,
	0x46, 0x55, 0x4c, 0x46, 0x49, 0x4c, 0x4c, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x42, 0x18, 0x0a,
	0x16, 0x5f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x42, 0x09, 0x0a, 0x07, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x5f,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x69, 0x73, 0x5f, 0x61,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x12,
	0x0a, 0x10, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x8c, 0x09, 0x0a, 0x14, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x95,
	0x01, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x4d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x11, 0x69, 0x74, 0x65, 0x6d, 0x5f,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x69, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x1a, 0x90, 0x01, 0x0a, 0x1f, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x6d, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x1a, 0xad, 0x04, 0x0a, 0x1c, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x84,
	0x01, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x49,
	0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x53, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x65, 0x76,
	0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x6d, 0x0a,
	0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x45, 0x6e, 0x75, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x25, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x12, 0x29, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x0a, 0x08, 0x53,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52,
	0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x49, 0x53, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56,
	0x45, 0x44, 0x10, 0x02, 0x42, 0x9a, 0x02, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x42, 0x1a, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x4b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x70, 0x62, 0xaa,
	0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5c, 0x4d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x5c, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x5c, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x3a, 0x3a, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescData = file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDesc
)

func file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescData)
	})
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDescData
}

var file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_goTypes = []any{
	(MerchantReviewAttributes_CollectionMethod)(0),                  // 0: google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes.CollectionMethod
	(MerchantReviewStatus_MerchantReviewItemLevelIssue_Severity)(0), // 1: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.MerchantReviewItemLevelIssue.Severity
	(*MerchantReviewAttributes)(nil),                                // 2: google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes
	(*MerchantReviewStatus)(nil),                                    // 3: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus
	(*MerchantReviewStatus_MerchantReviewDestinationStatus)(nil),    // 4: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.MerchantReviewDestinationStatus
	(*MerchantReviewStatus_MerchantReviewItemLevelIssue)(nil),       // 5: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.MerchantReviewItemLevelIssue
	(*timestamppb.Timestamp)(nil),                                   // 6: google.protobuf.Timestamp
	(typepb.ReportingContext_ReportingContextEnum)(0),               // 7: google.shopping.type.ReportingContext.ReportingContextEnum
}
var file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_depIdxs = []int32{
	0, // 0: google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes.collection_method:type_name -> google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes.CollectionMethod
	6, // 1: google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes.review_time:type_name -> google.protobuf.Timestamp
	4, // 2: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.destination_statuses:type_name -> google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.MerchantReviewDestinationStatus
	5, // 3: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.item_level_issues:type_name -> google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.MerchantReviewItemLevelIssue
	6, // 4: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.create_time:type_name -> google.protobuf.Timestamp
	6, // 5: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.last_update_time:type_name -> google.protobuf.Timestamp
	7, // 6: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.MerchantReviewDestinationStatus.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	1, // 7: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.MerchantReviewItemLevelIssue.severity:type_name -> google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.MerchantReviewItemLevelIssue.Severity
	7, // 8: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus.MerchantReviewItemLevelIssue.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_init() }
func file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_init() {
	if File_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto != nil {
		return
	}
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto = out.File
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_rawDesc = nil
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_goTypes = nil
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_depIdxs = nil
}
