// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/termsofserviceagreementstate.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This resource represents the agreement state for a given account and terms of
// service kind.
// The state is as follows:
//
// * If the merchant has accepted a terms of service:
// [accepted](TermsOfServiceAggrementState.accepted) will be populated,
// otherwise it will be empty
// * If the merchant must sign a terms of service:
// [required](TermsOfServiceAggrementState.required) will be populated,
// otherwise it will be empty.
//
// Note that both [required](TermsOfServiceAggrementState.required) and
// [accepted](TermsOfServiceAggrementState.accepted) can be present. In this
// case the `accepted` terms of services will have an expiration date set in the
// [valid_until](Accepted.valid_until) field. The `required` terms of services
// need to be accepted before `valid_until` in order for the account to continue
// having a valid agreement. When accepting new terms of services we expect 3Ps
// to display the text associated with the given terms of service agreement (the
// url to the file containing the text is added in the Required message below as
// [tos_file_uri](Accepted.tos_file_uri). The actual acceptance of the terms of
// service is done by calling accept on the [TermsOfService](TermsOfService)
// resource.
type TermsOfServiceAgreementState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the terms of service version.
	// Format: `accounts/{account}/termsOfServiceAgreementState/{identifier}`
	// The identifier format is: `{TermsOfServiceKind}-{country}`
	// For example, an identifier could be: `MERCHANT_CENTER-US`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Region code as defined by https://cldr.unicode.org/. This is the
	// country the current state applies to.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Terms of Service kind associated with the particular version.
	TermsOfServiceKind TermsOfServiceKind `protobuf:"varint,3,opt,name=terms_of_service_kind,json=termsOfServiceKind,proto3,enum=google.shopping.merchant.accounts.v1beta.TermsOfServiceKind" json:"terms_of_service_kind,omitempty"`
	// The accepted terms of service of this kind and for the associated
	// region_code
	Accepted *Accepted `protobuf:"bytes,4,opt,name=accepted,proto3,oneof" json:"accepted,omitempty"`
	// The required terms of service
	Required *Required `protobuf:"bytes,5,opt,name=required,proto3,oneof" json:"required,omitempty"`
}

func (x *TermsOfServiceAgreementState) Reset() {
	*x = TermsOfServiceAgreementState{}
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TermsOfServiceAgreementState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TermsOfServiceAgreementState) ProtoMessage() {}

func (x *TermsOfServiceAgreementState) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TermsOfServiceAgreementState.ProtoReflect.Descriptor instead.
func (*TermsOfServiceAgreementState) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescGZIP(), []int{0}
}

func (x *TermsOfServiceAgreementState) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TermsOfServiceAgreementState) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *TermsOfServiceAgreementState) GetTermsOfServiceKind() TermsOfServiceKind {
	if x != nil {
		return x.TermsOfServiceKind
	}
	return TermsOfServiceKind_TERMS_OF_SERVICE_KIND_UNSPECIFIED
}

func (x *TermsOfServiceAgreementState) GetAccepted() *Accepted {
	if x != nil {
		return x.Accepted
	}
	return nil
}

func (x *TermsOfServiceAgreementState) GetRequired() *Required {
	if x != nil {
		return x.Required
	}
	return nil
}

// Describes the accepted terms of service.
type Accepted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The accepted
	// [termsOfService](google.shopping.merchant.accounts.v1main.TermsOfService).
	TermsOfService string `protobuf:"bytes,1,opt,name=terms_of_service,json=termsOfService,proto3" json:"terms_of_service,omitempty"`
	// The account where the acceptance was recorded. This can be the account
	// itself or, in the case of subaccounts, the MCA account.
	AcceptedBy string `protobuf:"bytes,2,opt,name=accepted_by,json=acceptedBy,proto3" json:"accepted_by,omitempty"`
	// When set, it states that the accepted
	// [TermsOfService](google.shopping.merchant.accounts.v1main.TermsOfService)
	// is only valid until the end of this date (in UTC). A new one must be
	// accepted before then. The information of the required
	// [TermsOfService](google.shopping.merchant.accounts.v1main.TermsOfService)
	// is found in the [Required](Required) message.
	ValidUntil *date.Date `protobuf:"bytes,3,opt,name=valid_until,json=validUntil,proto3,oneof" json:"valid_until,omitempty"`
}

func (x *Accepted) Reset() {
	*x = Accepted{}
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Accepted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Accepted) ProtoMessage() {}

func (x *Accepted) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Accepted.ProtoReflect.Descriptor instead.
func (*Accepted) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescGZIP(), []int{1}
}

func (x *Accepted) GetTermsOfService() string {
	if x != nil {
		return x.TermsOfService
	}
	return ""
}

func (x *Accepted) GetAcceptedBy() string {
	if x != nil {
		return x.AcceptedBy
	}
	return ""
}

func (x *Accepted) GetValidUntil() *date.Date {
	if x != nil {
		return x.ValidUntil
	}
	return nil
}

// Describes the terms of service which are required to be accepted.
type Required struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The
	// [termsOfService](google.shopping.merchant.accounts.v1main.TermsOfService)
	// that need to be accepted.
	TermsOfService string `protobuf:"bytes,1,opt,name=terms_of_service,json=termsOfService,proto3" json:"terms_of_service,omitempty"`
	// Full URL to the terms of service file. This field is the same as
	// [TermsOfService.file_uri](TermsOfService.file_uri), it is added
	// here for convenience only.
	TosFileUri string `protobuf:"bytes,2,opt,name=tos_file_uri,json=tosFileUri,proto3" json:"tos_file_uri,omitempty"`
}

func (x *Required) Reset() {
	*x = Required{}
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Required) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Required) ProtoMessage() {}

func (x *Required) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Required.ProtoReflect.Descriptor instead.
func (*Required) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescGZIP(), []int{2}
}

func (x *Required) GetTermsOfService() string {
	if x != nil {
		return x.TermsOfService
	}
	return ""
}

func (x *Required) GetTosFileUri() string {
	if x != nil {
		return x.TosFileUri
	}
	return ""
}

// Request message for the `GetTermsOfServiceAgreementState` method.
type GetTermsOfServiceAgreementStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the terms of service version.
	// Format: `accounts/{account}/termsOfServiceAgreementState/{identifier}`
	// The identifier format is: `{TermsOfServiceKind}-{country}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTermsOfServiceAgreementStateRequest) Reset() {
	*x = GetTermsOfServiceAgreementStateRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTermsOfServiceAgreementStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTermsOfServiceAgreementStateRequest) ProtoMessage() {}

func (x *GetTermsOfServiceAgreementStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTermsOfServiceAgreementStateRequest.ProtoReflect.Descriptor instead.
func (*GetTermsOfServiceAgreementStateRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescGZIP(), []int{3}
}

func (x *GetTermsOfServiceAgreementStateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `RetrieveForApplicationTermsOfServiceAgreementState`
// method.
type RetrieveForApplicationTermsOfServiceAgreementStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account for which to get a TermsOfServiceAgreementState
	// Format: `accounts/{account}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *RetrieveForApplicationTermsOfServiceAgreementStateRequest) Reset() {
	*x = RetrieveForApplicationTermsOfServiceAgreementStateRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrieveForApplicationTermsOfServiceAgreementStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveForApplicationTermsOfServiceAgreementStateRequest) ProtoMessage() {}

func (x *RetrieveForApplicationTermsOfServiceAgreementStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveForApplicationTermsOfServiceAgreementStateRequest.ProtoReflect.Descriptor instead.
func (*RetrieveForApplicationTermsOfServiceAgreementStateRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescGZIP(), []int{4}
}

func (x *RetrieveForApplicationTermsOfServiceAgreementStateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

var File_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDesc = []byte{
	0x0a, 0x4b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x74, 0x65, 0x72, 0x6d, 0x73,
	0x6f, 0x66, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x61, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x41, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x6f, 0x66, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x6b, 0x69, 0x6e, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc9, 0x04, 0x0a, 0x1c, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x4f,
	0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x6f, 0x0a, 0x15, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x65, 0x72, 0x6d, 0x73,
	0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x12, 0x74,
	0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x69, 0x6e,
	0x64, 0x12, 0x53, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x08, 0x61, 0x63, 0x63, 0x65, 0x70,
	0x74, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x48, 0x01, 0x52, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x88, 0x01, 0x01, 0x3a, 0xb9, 0x01, 0xea, 0x41,
	0xb5, 0x01, 0x0a, 0x37, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72,
	0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f,
	0x74, 0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67,
	0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x7d, 0x2a, 0x1d, 0x74, 0x65, 0x72, 0x6d,
	0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x32, 0x1c, 0x74, 0x65, 0x72, 0x6d, 0x73,
	0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x65, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x22, 0xf7, 0x01, 0x0a, 0x08, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x12, 0x58,
	0x0a, 0x10, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x4f,
	0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0e, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x4f,
	0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64,
	0x42, 0x79, 0x12, 0x37, 0x0a, 0x0b, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x75, 0x6e, 0x74, 0x69,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x55, 0x6e, 0x74, 0x69, 0x6c, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x22, 0x86, 0x01, 0x0a, 0x08,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x58, 0x0a, 0x10, 0x74, 0x65, 0x72, 0x6d,
	0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x0e, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x74, 0x6f, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x73, 0x46, 0x69, 0x6c,
	0x65, 0x55, 0x72, 0x69, 0x22, 0x7d, 0x0a, 0x26, 0x47, 0x65, 0x74, 0x54, 0x65, 0x72, 0x6d, 0x73,
	0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x39, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65,
	0x46, 0x6f, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65,
	0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x32, 0xcf, 0x05, 0x0a, 0x23, 0x54,
	0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72,
	0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x8e, 0x02, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x4f,
	0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x54, 0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12,
	0x42, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xcd, 0x02, 0x0a, 0x32, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65,
	0x46, 0x6f, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65,
	0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x63, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x46, 0x6f,
	0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x72, 0x6d,
	0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x65, 0x72, 0x6d, 0x73,
	0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x6a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x12, 0x59, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74,
	0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72,
	0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x65, 0x46, 0x6f, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xa3, 0x01, 0x0a,
	0x2c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x21, 0x54,
	0x65, 0x72, 0x6d, 0x73, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x72,
	0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x4e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_goTypes = []any{
	(*TermsOfServiceAgreementState)(nil),           // 0: google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementState
	(*Accepted)(nil),                               // 1: google.shopping.merchant.accounts.v1beta.Accepted
	(*Required)(nil),                               // 2: google.shopping.merchant.accounts.v1beta.Required
	(*GetTermsOfServiceAgreementStateRequest)(nil), // 3: google.shopping.merchant.accounts.v1beta.GetTermsOfServiceAgreementStateRequest
	(*RetrieveForApplicationTermsOfServiceAgreementStateRequest)(nil), // 4: google.shopping.merchant.accounts.v1beta.RetrieveForApplicationTermsOfServiceAgreementStateRequest
	(TermsOfServiceKind)(0), // 5: google.shopping.merchant.accounts.v1beta.TermsOfServiceKind
	(*date.Date)(nil),       // 6: google.type.Date
}
var file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_depIdxs = []int32{
	5, // 0: google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementState.terms_of_service_kind:type_name -> google.shopping.merchant.accounts.v1beta.TermsOfServiceKind
	1, // 1: google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementState.accepted:type_name -> google.shopping.merchant.accounts.v1beta.Accepted
	2, // 2: google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementState.required:type_name -> google.shopping.merchant.accounts.v1beta.Required
	6, // 3: google.shopping.merchant.accounts.v1beta.Accepted.valid_until:type_name -> google.type.Date
	3, // 4: google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementStateService.GetTermsOfServiceAgreementState:input_type -> google.shopping.merchant.accounts.v1beta.GetTermsOfServiceAgreementStateRequest
	4, // 5: google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementStateService.RetrieveForApplicationTermsOfServiceAgreementState:input_type -> google.shopping.merchant.accounts.v1beta.RetrieveForApplicationTermsOfServiceAgreementStateRequest
	0, // 6: google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementStateService.GetTermsOfServiceAgreementState:output_type -> google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementState
	0, // 7: google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementStateService.RetrieveForApplicationTermsOfServiceAgreementState:output_type -> google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementState
	6, // [6:8] is the sub-list for method output_type
	4, // [4:6] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto != nil {
		return
	}
	file_google_shopping_merchant_accounts_v1beta_termsofservicekind_proto_init()
	file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes[1].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_termsofserviceagreementstate_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TermsOfServiceAgreementStateServiceClient is the client API for TermsOfServiceAgreementStateService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TermsOfServiceAgreementStateServiceClient interface {
	// Returns the state of a terms of service agreement.
	GetTermsOfServiceAgreementState(ctx context.Context, in *GetTermsOfServiceAgreementStateRequest, opts ...grpc.CallOption) (*TermsOfServiceAgreementState, error)
	// Retrieves the state of the agreement for the application terms of service.
	RetrieveForApplicationTermsOfServiceAgreementState(ctx context.Context, in *RetrieveForApplicationTermsOfServiceAgreementStateRequest, opts ...grpc.CallOption) (*TermsOfServiceAgreementState, error)
}

type termsOfServiceAgreementStateServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTermsOfServiceAgreementStateServiceClient(cc grpc.ClientConnInterface) TermsOfServiceAgreementStateServiceClient {
	return &termsOfServiceAgreementStateServiceClient{cc}
}

func (c *termsOfServiceAgreementStateServiceClient) GetTermsOfServiceAgreementState(ctx context.Context, in *GetTermsOfServiceAgreementStateRequest, opts ...grpc.CallOption) (*TermsOfServiceAgreementState, error) {
	out := new(TermsOfServiceAgreementState)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementStateService/GetTermsOfServiceAgreementState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *termsOfServiceAgreementStateServiceClient) RetrieveForApplicationTermsOfServiceAgreementState(ctx context.Context, in *RetrieveForApplicationTermsOfServiceAgreementStateRequest, opts ...grpc.CallOption) (*TermsOfServiceAgreementState, error) {
	out := new(TermsOfServiceAgreementState)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementStateService/RetrieveForApplicationTermsOfServiceAgreementState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TermsOfServiceAgreementStateServiceServer is the server API for TermsOfServiceAgreementStateService service.
type TermsOfServiceAgreementStateServiceServer interface {
	// Returns the state of a terms of service agreement.
	GetTermsOfServiceAgreementState(context.Context, *GetTermsOfServiceAgreementStateRequest) (*TermsOfServiceAgreementState, error)
	// Retrieves the state of the agreement for the application terms of service.
	RetrieveForApplicationTermsOfServiceAgreementState(context.Context, *RetrieveForApplicationTermsOfServiceAgreementStateRequest) (*TermsOfServiceAgreementState, error)
}

// UnimplementedTermsOfServiceAgreementStateServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTermsOfServiceAgreementStateServiceServer struct {
}

func (*UnimplementedTermsOfServiceAgreementStateServiceServer) GetTermsOfServiceAgreementState(context.Context, *GetTermsOfServiceAgreementStateRequest) (*TermsOfServiceAgreementState, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTermsOfServiceAgreementState not implemented")
}
func (*UnimplementedTermsOfServiceAgreementStateServiceServer) RetrieveForApplicationTermsOfServiceAgreementState(context.Context, *RetrieveForApplicationTermsOfServiceAgreementStateRequest) (*TermsOfServiceAgreementState, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveForApplicationTermsOfServiceAgreementState not implemented")
}

func RegisterTermsOfServiceAgreementStateServiceServer(s *grpc.Server, srv TermsOfServiceAgreementStateServiceServer) {
	s.RegisterService(&_TermsOfServiceAgreementStateService_serviceDesc, srv)
}

func _TermsOfServiceAgreementStateService_GetTermsOfServiceAgreementState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTermsOfServiceAgreementStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TermsOfServiceAgreementStateServiceServer).GetTermsOfServiceAgreementState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementStateService/GetTermsOfServiceAgreementState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TermsOfServiceAgreementStateServiceServer).GetTermsOfServiceAgreementState(ctx, req.(*GetTermsOfServiceAgreementStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TermsOfServiceAgreementStateService_RetrieveForApplicationTermsOfServiceAgreementState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveForApplicationTermsOfServiceAgreementStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TermsOfServiceAgreementStateServiceServer).RetrieveForApplicationTermsOfServiceAgreementState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementStateService/RetrieveForApplicationTermsOfServiceAgreementState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TermsOfServiceAgreementStateServiceServer).RetrieveForApplicationTermsOfServiceAgreementState(ctx, req.(*RetrieveForApplicationTermsOfServiceAgreementStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TermsOfServiceAgreementStateService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.TermsOfServiceAgreementStateService",
	HandlerType: (*TermsOfServiceAgreementStateServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetTermsOfServiceAgreementState",
			Handler:    _TermsOfServiceAgreementStateService_GetTermsOfServiceAgreementState_Handler,
		},
		{
			MethodName: "RetrieveForApplicationTermsOfServiceAgreementState",
			Handler:    _TermsOfServiceAgreementStateService_RetrieveForApplicationTermsOfServiceAgreementState_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/termsofserviceagreementstate.proto",
}
