// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/businessinfo.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	phone_number "google.golang.org/genproto/googleapis/type/phone_number"
	postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Collection of information related to a business.
type BusinessInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the business info.
	// Format: `accounts/{account}/businessInfo`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The address of the business.
	Address *postaladdress.PostalAddress `protobuf:"bytes,2,opt,name=address,proto3,oneof" json:"address,omitempty"`
	// Output only. The phone number of the business.
	Phone *phone_number.PhoneNumber `protobuf:"bytes,3,opt,name=phone,proto3,oneof" json:"phone,omitempty"`
	// Output only. The phone verification state of the business.
	PhoneVerificationState *PhoneVerificationState `protobuf:"varint,4,opt,name=phone_verification_state,json=phoneVerificationState,proto3,enum=google.shopping.merchant.accounts.v1beta.PhoneVerificationState,oneof" json:"phone_verification_state,omitempty"`
	// Optional. The customer service of the business.
	CustomerService *CustomerService `protobuf:"bytes,5,opt,name=customer_service,json=customerService,proto3,oneof" json:"customer_service,omitempty"`
	// Optional. The 10-digit [Korean business registration
	// number](https://support.google.com/merchants/answer/9037766) separated with
	// dashes in the format: XXX-XX-XXXXX.
	KoreanBusinessRegistrationNumber *string `protobuf:"bytes,6,opt,name=korean_business_registration_number,json=koreanBusinessRegistrationNumber,proto3,oneof" json:"korean_business_registration_number,omitempty"`
}

func (x *BusinessInfo) Reset() {
	*x = BusinessInfo{}
	mi := &file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BusinessInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BusinessInfo) ProtoMessage() {}

func (x *BusinessInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BusinessInfo.ProtoReflect.Descriptor instead.
func (*BusinessInfo) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescGZIP(), []int{0}
}

func (x *BusinessInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BusinessInfo) GetAddress() *postaladdress.PostalAddress {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *BusinessInfo) GetPhone() *phone_number.PhoneNumber {
	if x != nil {
		return x.Phone
	}
	return nil
}

func (x *BusinessInfo) GetPhoneVerificationState() PhoneVerificationState {
	if x != nil && x.PhoneVerificationState != nil {
		return *x.PhoneVerificationState
	}
	return PhoneVerificationState_PHONE_VERIFICATION_STATE_UNSPECIFIED
}

func (x *BusinessInfo) GetCustomerService() *CustomerService {
	if x != nil {
		return x.CustomerService
	}
	return nil
}

func (x *BusinessInfo) GetKoreanBusinessRegistrationNumber() string {
	if x != nil && x.KoreanBusinessRegistrationNumber != nil {
		return *x.KoreanBusinessRegistrationNumber
	}
	return ""
}

// Request message for the `GetBusinessInfo` method.
type GetBusinessInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the business info.
	// Format: `accounts/{account}/businessInfo`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBusinessInfoRequest) Reset() {
	*x = GetBusinessInfoRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBusinessInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBusinessInfoRequest) ProtoMessage() {}

func (x *GetBusinessInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBusinessInfoRequest.ProtoReflect.Descriptor instead.
func (*GetBusinessInfoRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescGZIP(), []int{1}
}

func (x *GetBusinessInfoRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `UpdateBusinessInfo` method.
type UpdateBusinessInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new version of the business info.
	BusinessInfo *BusinessInfo `protobuf:"bytes,1,opt,name=business_info,json=businessInfo,proto3" json:"business_info,omitempty"`
	// Required. List of fields being updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBusinessInfoRequest) Reset() {
	*x = UpdateBusinessInfoRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBusinessInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBusinessInfoRequest) ProtoMessage() {}

func (x *UpdateBusinessInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBusinessInfoRequest.ProtoReflect.Descriptor instead.
func (*UpdateBusinessInfoRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateBusinessInfoRequest) GetBusinessInfo() *BusinessInfo {
	if x != nil {
		return x.BusinessInfo
	}
	return nil
}

func (x *UpdateBusinessInfoRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_shopping_merchant_accounts_v1beta_businessinfo_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x62, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x45, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x76, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x2f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x2f, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcd, 0x05, 0x0a, 0x0c, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65,
	0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x3e, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50,
	0x6f, 0x73, 0x74, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x38, 0x0a, 0x05, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x68, 0x6f,
	0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52,
	0x05, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x88, 0x01, 0x01, 0x12, 0x84, 0x01, 0x0a, 0x18, 0x70, 0x68,
	0x6f, 0x6e, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x56, 0x65, 0x72,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x02, 0x52, 0x16, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x6e, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x0f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x57, 0x0a, 0x23, 0x6b, 0x6f, 0x72, 0x65, 0x61, 0x6e, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x04, 0x52, 0x20, 0x6b, 0x6f, 0x72, 0x65, 0x61, 0x6e, 0x42, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x88, 0x01, 0x01, 0x3a, 0x6a, 0xea, 0x41, 0x67, 0x0a, 0x27,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x62, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x2a, 0x0d, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65,
	0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x32, 0x0c, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x42, 0x1b, 0x0a, 0x19, 0x5f,
	0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x26, 0x0a,
	0x24, 0x5f, 0x6b, 0x6f, 0x72, 0x65, 0x61, 0x6e, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x5d, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x42, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61,
	0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbf, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42,
	0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x60, 0x0a, 0x0d, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x32, 0xb2, 0x04, 0x0a, 0x13, 0x42, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xcb,
	0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x3e, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x7d, 0x12, 0x83, 0x02, 0x0a,
	0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f,
	0x22, 0x70, 0xda, 0x41, 0x19, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x0d, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x32, 0x3d, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66,
	0x6f, 0x7d, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61,
	0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x93, 0x01, 0x0a, 0x2c,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x11, 0x42, 0x75,
	0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_goTypes = []any{
	(*BusinessInfo)(nil),                // 0: google.shopping.merchant.accounts.v1beta.BusinessInfo
	(*GetBusinessInfoRequest)(nil),      // 1: google.shopping.merchant.accounts.v1beta.GetBusinessInfoRequest
	(*UpdateBusinessInfoRequest)(nil),   // 2: google.shopping.merchant.accounts.v1beta.UpdateBusinessInfoRequest
	(*postaladdress.PostalAddress)(nil), // 3: google.type.PostalAddress
	(*phone_number.PhoneNumber)(nil),    // 4: google.type.PhoneNumber
	(PhoneVerificationState)(0),         // 5: google.shopping.merchant.accounts.v1beta.PhoneVerificationState
	(*CustomerService)(nil),             // 6: google.shopping.merchant.accounts.v1beta.CustomerService
	(*fieldmaskpb.FieldMask)(nil),       // 7: google.protobuf.FieldMask
}
var file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_depIdxs = []int32{
	3, // 0: google.shopping.merchant.accounts.v1beta.BusinessInfo.address:type_name -> google.type.PostalAddress
	4, // 1: google.shopping.merchant.accounts.v1beta.BusinessInfo.phone:type_name -> google.type.PhoneNumber
	5, // 2: google.shopping.merchant.accounts.v1beta.BusinessInfo.phone_verification_state:type_name -> google.shopping.merchant.accounts.v1beta.PhoneVerificationState
	6, // 3: google.shopping.merchant.accounts.v1beta.BusinessInfo.customer_service:type_name -> google.shopping.merchant.accounts.v1beta.CustomerService
	0, // 4: google.shopping.merchant.accounts.v1beta.UpdateBusinessInfoRequest.business_info:type_name -> google.shopping.merchant.accounts.v1beta.BusinessInfo
	7, // 5: google.shopping.merchant.accounts.v1beta.UpdateBusinessInfoRequest.update_mask:type_name -> google.protobuf.FieldMask
	1, // 6: google.shopping.merchant.accounts.v1beta.BusinessInfoService.GetBusinessInfo:input_type -> google.shopping.merchant.accounts.v1beta.GetBusinessInfoRequest
	2, // 7: google.shopping.merchant.accounts.v1beta.BusinessInfoService.UpdateBusinessInfo:input_type -> google.shopping.merchant.accounts.v1beta.UpdateBusinessInfoRequest
	0, // 8: google.shopping.merchant.accounts.v1beta.BusinessInfoService.GetBusinessInfo:output_type -> google.shopping.merchant.accounts.v1beta.BusinessInfo
	0, // 9: google.shopping.merchant.accounts.v1beta.BusinessInfoService.UpdateBusinessInfo:output_type -> google.shopping.merchant.accounts.v1beta.BusinessInfo
	8, // [8:10] is the sub-list for method output_type
	6, // [6:8] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_businessinfo_proto != nil {
		return
	}
	file_google_shopping_merchant_accounts_v1beta_customerservice_proto_init()
	file_google_shopping_merchant_accounts_v1beta_phoneverificationstate_proto_init()
	file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_businessinfo_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_businessinfo_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BusinessInfoServiceClient is the client API for BusinessInfoService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BusinessInfoServiceClient interface {
	// Retrieves the business info of an account.
	GetBusinessInfo(ctx context.Context, in *GetBusinessInfoRequest, opts ...grpc.CallOption) (*BusinessInfo, error)
	// Updates the business info of an account. Executing this method requires
	// admin access.
	UpdateBusinessInfo(ctx context.Context, in *UpdateBusinessInfoRequest, opts ...grpc.CallOption) (*BusinessInfo, error)
}

type businessInfoServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBusinessInfoServiceClient(cc grpc.ClientConnInterface) BusinessInfoServiceClient {
	return &businessInfoServiceClient{cc}
}

func (c *businessInfoServiceClient) GetBusinessInfo(ctx context.Context, in *GetBusinessInfoRequest, opts ...grpc.CallOption) (*BusinessInfo, error) {
	out := new(BusinessInfo)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.BusinessInfoService/GetBusinessInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessInfoServiceClient) UpdateBusinessInfo(ctx context.Context, in *UpdateBusinessInfoRequest, opts ...grpc.CallOption) (*BusinessInfo, error) {
	out := new(BusinessInfo)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.BusinessInfoService/UpdateBusinessInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BusinessInfoServiceServer is the server API for BusinessInfoService service.
type BusinessInfoServiceServer interface {
	// Retrieves the business info of an account.
	GetBusinessInfo(context.Context, *GetBusinessInfoRequest) (*BusinessInfo, error)
	// Updates the business info of an account. Executing this method requires
	// admin access.
	UpdateBusinessInfo(context.Context, *UpdateBusinessInfoRequest) (*BusinessInfo, error)
}

// UnimplementedBusinessInfoServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBusinessInfoServiceServer struct {
}

func (*UnimplementedBusinessInfoServiceServer) GetBusinessInfo(context.Context, *GetBusinessInfoRequest) (*BusinessInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBusinessInfo not implemented")
}
func (*UnimplementedBusinessInfoServiceServer) UpdateBusinessInfo(context.Context, *UpdateBusinessInfoRequest) (*BusinessInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBusinessInfo not implemented")
}

func RegisterBusinessInfoServiceServer(s *grpc.Server, srv BusinessInfoServiceServer) {
	s.RegisterService(&_BusinessInfoService_serviceDesc, srv)
}

func _BusinessInfoService_GetBusinessInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBusinessInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessInfoServiceServer).GetBusinessInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.BusinessInfoService/GetBusinessInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessInfoServiceServer).GetBusinessInfo(ctx, req.(*GetBusinessInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessInfoService_UpdateBusinessInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBusinessInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessInfoServiceServer).UpdateBusinessInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.BusinessInfoService/UpdateBusinessInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessInfoServiceServer).UpdateBusinessInfo(ctx, req.(*UpdateBusinessInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BusinessInfoService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.BusinessInfoService",
	HandlerType: (*BusinessInfoServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBusinessInfo",
			Handler:    _BusinessInfoService_GetBusinessInfo_Handler,
		},
		{
			MethodName: "UpdateBusinessInfo",
			Handler:    _BusinessInfoService_UpdateBusinessInfo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/businessinfo.proto",
}
