// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/automaticimprovements.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Collection of information related to the [automatic
// improvements](https://developers.google.com/shopping-content/guides/automatic-improvements)
// of an account.
type AutomaticImprovements struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the automatic improvements.
	// Format: `accounts/{account}/automaticImprovements`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Turning on [item
	// updates](https://support.google.com/merchants/answer/3246284) allows
	// Google to automatically update items for you. When item updates are on,
	// Google uses the structured data markup on the website and advanced data
	// extractors to update the price and availability of the items. When the item
	// updates are off, items with mismatched data aren't shown.
	// This field is only updated (cleared) if provided in the update mask.
	ItemUpdates *AutomaticItemUpdates `protobuf:"bytes,2,opt,name=item_updates,json=itemUpdates,proto3,oneof" json:"item_updates,omitempty"`
	// This improvement will attempt to automatically correct submitted images if
	// they don't meet the [image
	// requirements](https://support.google.com/merchants/answer/6324350), for
	// example, removing overlays. If successful, the image will be replaced and
	// approved. This improvement is only applied to images of disapproved offers.
	// For more information see: [Automatic image
	// improvements](https://support.google.com/merchants/answer/9242973)
	// This field is only updated (cleared) if provided in the update mask.
	ImageImprovements *AutomaticImageImprovements `protobuf:"bytes,3,opt,name=image_improvements,json=imageImprovements,proto3,oneof" json:"image_improvements,omitempty"`
	// Not available for MCAs
	// [accounts](https://support.google.com/merchants/answer/188487). By turning
	// on [automatic shipping
	// improvements](https://support.google.com/merchants/answer/10027038),
	// you are allowing Google to improve the accuracy of your delivery times
	// shown to shoppers using Google. More accurate delivery times, especially
	// when faster, typically lead to better conversion rates. Google will improve
	// your estimated delivery times based on various factors:
	// * Delivery address of an order
	// * Current handling time and shipping time settings
	// * Estimated weekdays or business days
	// * Parcel tracking data
	// This field is only updated (cleared) if provided in the update mask.
	ShippingImprovements *AutomaticShippingImprovements `protobuf:"bytes,4,opt,name=shipping_improvements,json=shippingImprovements,proto3,oneof" json:"shipping_improvements,omitempty"`
}

func (x *AutomaticImprovements) Reset() {
	*x = AutomaticImprovements{}
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomaticImprovements) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomaticImprovements) ProtoMessage() {}

func (x *AutomaticImprovements) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomaticImprovements.ProtoReflect.Descriptor instead.
func (*AutomaticImprovements) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescGZIP(), []int{0}
}

func (x *AutomaticImprovements) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AutomaticImprovements) GetItemUpdates() *AutomaticItemUpdates {
	if x != nil {
		return x.ItemUpdates
	}
	return nil
}

func (x *AutomaticImprovements) GetImageImprovements() *AutomaticImageImprovements {
	if x != nil {
		return x.ImageImprovements
	}
	return nil
}

func (x *AutomaticImprovements) GetShippingImprovements() *AutomaticShippingImprovements {
	if x != nil {
		return x.ShippingImprovements
	}
	return nil
}

// Turning on [item
// updates](https://support.google.com/merchants/answer/3246284) allows
// Google to automatically update items for you. When item updates are on,
// Google uses the structured data markup on the website and advanced data
// extractors to update the price and availability of the items. When the item
// updates are off, items with mismatched data aren't shown.
type AutomaticItemUpdates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Determines which attributes of the items should be automatically
	// updated. If this field is not present and provided in the update mask, then
	// the settings will be deleted. If there are no settings for subaccount, they
	// are inherited from aggregator.
	AccountItemUpdatesSettings *AutomaticItemUpdates_ItemUpdatesAccountLevelSettings `protobuf:"bytes,1,opt,name=account_item_updates_settings,json=accountItemUpdatesSettings,proto3" json:"account_item_updates_settings,omitempty"`
	// Output only. The effective value of allow_price_updates.
	// If account_item_updates_settings is present, then this value is the same.
	// Otherwise, it represents the inherited value of the parent account.
	// The default value is true if no settings are present.
	// Read-only.
	EffectiveAllowPriceUpdates bool `protobuf:"varint,2,opt,name=effective_allow_price_updates,json=effectiveAllowPriceUpdates,proto3" json:"effective_allow_price_updates,omitempty"`
	// Output only. The effective value of allow_availability_updates.
	// If account_item_updates_settings is present, then this value is the same.
	// Otherwise, it represents the inherited value of the parent account.
	// The default value is true if no settings are present.
	// Read-only.
	EffectiveAllowAvailabilityUpdates bool `protobuf:"varint,3,opt,name=effective_allow_availability_updates,json=effectiveAllowAvailabilityUpdates,proto3" json:"effective_allow_availability_updates,omitempty"`
	// Output only. The effective value of
	// allow_strict_availability_updates.
	// If account_item_updates_settings is present, then this value is the same.
	// Otherwise, it represents the inherited value of the parent account.
	// The default value is true if no settings are present.
	// Read-only.
	EffectiveAllowStrictAvailabilityUpdates bool `protobuf:"varint,4,opt,name=effective_allow_strict_availability_updates,json=effectiveAllowStrictAvailabilityUpdates,proto3" json:"effective_allow_strict_availability_updates,omitempty"`
	// Output only. The effective value of allow_condition_updates.
	// If account_item_updates_settings is present, then this value is the same.
	// Otherwise, it represents the inherited value of the parent account.
	// The default value is true if no settings are present.
	// Read-only.
	EffectiveAllowConditionUpdates bool `protobuf:"varint,5,opt,name=effective_allow_condition_updates,json=effectiveAllowConditionUpdates,proto3" json:"effective_allow_condition_updates,omitempty"`
}

func (x *AutomaticItemUpdates) Reset() {
	*x = AutomaticItemUpdates{}
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomaticItemUpdates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomaticItemUpdates) ProtoMessage() {}

func (x *AutomaticItemUpdates) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomaticItemUpdates.ProtoReflect.Descriptor instead.
func (*AutomaticItemUpdates) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescGZIP(), []int{1}
}

func (x *AutomaticItemUpdates) GetAccountItemUpdatesSettings() *AutomaticItemUpdates_ItemUpdatesAccountLevelSettings {
	if x != nil {
		return x.AccountItemUpdatesSettings
	}
	return nil
}

func (x *AutomaticItemUpdates) GetEffectiveAllowPriceUpdates() bool {
	if x != nil {
		return x.EffectiveAllowPriceUpdates
	}
	return false
}

func (x *AutomaticItemUpdates) GetEffectiveAllowAvailabilityUpdates() bool {
	if x != nil {
		return x.EffectiveAllowAvailabilityUpdates
	}
	return false
}

func (x *AutomaticItemUpdates) GetEffectiveAllowStrictAvailabilityUpdates() bool {
	if x != nil {
		return x.EffectiveAllowStrictAvailabilityUpdates
	}
	return false
}

func (x *AutomaticItemUpdates) GetEffectiveAllowConditionUpdates() bool {
	if x != nil {
		return x.EffectiveAllowConditionUpdates
	}
	return false
}

// This improvement will attempt to automatically correct submitted images if
// they don't meet the [image
// requirements](https://support.google.com/merchants/answer/6324350), for
// example, removing overlays. If successful, the image will be replaced and
// approved. This improvement is only applied to images of disapproved offers.
// For more information see: [Automatic image
// improvements](https://support.google.com/merchants/answer/9242973)
type AutomaticImageImprovements struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Determines how the images should be automatically updated.
	// If this field is not present and provided in the update mask, then the
	// settings will be deleted. If there are no settings for subaccount, they are
	// inherited from aggregator.
	AccountImageImprovementsSettings *AutomaticImageImprovements_ImageImprovementsAccountLevelSettings `protobuf:"bytes,1,opt,name=account_image_improvements_settings,json=accountImageImprovementsSettings,proto3,oneof" json:"account_image_improvements_settings,omitempty"`
	// Output only. The effective value of allow_automatic_image_improvements.
	// If account_image_improvements_settings is present, then this value is the
	// same. Otherwise, it represents the inherited value of the parent account.
	// Read-only.
	EffectiveAllowAutomaticImageImprovements bool `protobuf:"varint,2,opt,name=effective_allow_automatic_image_improvements,json=effectiveAllowAutomaticImageImprovements,proto3" json:"effective_allow_automatic_image_improvements,omitempty"`
}

func (x *AutomaticImageImprovements) Reset() {
	*x = AutomaticImageImprovements{}
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomaticImageImprovements) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomaticImageImprovements) ProtoMessage() {}

func (x *AutomaticImageImprovements) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomaticImageImprovements.ProtoReflect.Descriptor instead.
func (*AutomaticImageImprovements) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescGZIP(), []int{2}
}

func (x *AutomaticImageImprovements) GetAccountImageImprovementsSettings() *AutomaticImageImprovements_ImageImprovementsAccountLevelSettings {
	if x != nil {
		return x.AccountImageImprovementsSettings
	}
	return nil
}

func (x *AutomaticImageImprovements) GetEffectiveAllowAutomaticImageImprovements() bool {
	if x != nil {
		return x.EffectiveAllowAutomaticImageImprovements
	}
	return false
}

// Not available for MCAs
// [accounts](https://support.google.com/merchants/answer/188487). By turning on
// [automatic shipping
// improvements](https://support.google.com/merchants/answer/10027038),
// you are allowing Google to improve the accuracy of your delivery times shown
// to shoppers using Google. More accurate delivery times, especially when
// faster, typically lead to better conversion rates. Google will improve your
// estimated delivery times based on various factors:
// * Delivery address of an order
// * Current handling time and shipping time settings
// * Estimated weekdays or business days
// * Parcel tracking data
type AutomaticShippingImprovements struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables automatic shipping improvements.
	AllowShippingImprovements *bool `protobuf:"varint,1,opt,name=allow_shipping_improvements,json=allowShippingImprovements,proto3,oneof" json:"allow_shipping_improvements,omitempty"`
}

func (x *AutomaticShippingImprovements) Reset() {
	*x = AutomaticShippingImprovements{}
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomaticShippingImprovements) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomaticShippingImprovements) ProtoMessage() {}

func (x *AutomaticShippingImprovements) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomaticShippingImprovements.ProtoReflect.Descriptor instead.
func (*AutomaticShippingImprovements) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescGZIP(), []int{3}
}

func (x *AutomaticShippingImprovements) GetAllowShippingImprovements() bool {
	if x != nil && x.AllowShippingImprovements != nil {
		return *x.AllowShippingImprovements
	}
	return false
}

// Request message for the `GetAutomaticImprovements` method.
type GetAutomaticImprovementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the automatic improvements.
	// Format: `accounts/{account}/automaticImprovements`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAutomaticImprovementsRequest) Reset() {
	*x = GetAutomaticImprovementsRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAutomaticImprovementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAutomaticImprovementsRequest) ProtoMessage() {}

func (x *GetAutomaticImprovementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAutomaticImprovementsRequest.ProtoReflect.Descriptor instead.
func (*GetAutomaticImprovementsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescGZIP(), []int{4}
}

func (x *GetAutomaticImprovementsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `UpdateAutomaticImprovements` method.
type UpdateAutomaticImprovementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new version of the automatic imrovements.
	AutomaticImprovements *AutomaticImprovements `protobuf:"bytes,1,opt,name=automatic_improvements,json=automaticImprovements,proto3" json:"automatic_improvements,omitempty"`
	// Required. List of fields being updated.
	// The following fields are supported (in both `snake_case` and
	// `lowerCamelCase`):
	//
	// - `item_updates`
	// - `item_updates.account_level_settings`
	// - `image_improvements`
	// - `image_improvements.account_level_settings`
	// - `shipping_improvements`
	// - `shipping_improvements.allow_shipping_improvements`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAutomaticImprovementsRequest) Reset() {
	*x = UpdateAutomaticImprovementsRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAutomaticImprovementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAutomaticImprovementsRequest) ProtoMessage() {}

func (x *UpdateAutomaticImprovementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAutomaticImprovementsRequest.ProtoReflect.Descriptor instead.
func (*UpdateAutomaticImprovementsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateAutomaticImprovementsRequest) GetAutomaticImprovements() *AutomaticImprovements {
	if x != nil {
		return x.AutomaticImprovements
	}
	return nil
}

func (x *UpdateAutomaticImprovementsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Settings for the Automatic Item Updates.
type AutomaticItemUpdates_ItemUpdatesAccountLevelSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If price updates are enabled, Google always updates the active price with
	// the crawled information.
	AllowPriceUpdates *bool `protobuf:"varint,1,opt,name=allow_price_updates,json=allowPriceUpdates,proto3,oneof" json:"allow_price_updates,omitempty"`
	// If availability updates are enabled, any previous availability values
	// get overwritten if Google finds an out-of-stock annotation on the offer's
	// page.
	// If additionally `allow_strict_availability_updates` field is set to
	// true, values get overwritten if Google finds an in-stock annotation on
	// the offer’s page.
	AllowAvailabilityUpdates *bool `protobuf:"varint,2,opt,name=allow_availability_updates,json=allowAvailabilityUpdates,proto3,oneof" json:"allow_availability_updates,omitempty"`
	// If `allow_availability_updates` is enabled, items are automatically
	// updated in all your Shopping target countries. By default, availability
	// updates will only be applied to items that are 'out of stock' on your
	// website but 'in stock' on Shopping. Set this to true to also update items
	// that are 'in stock' on your website, but 'out of stock' on Google
	// Shopping. In order for this field to have an effect, you must also set
	// `allow_availability_updates`.
	AllowStrictAvailabilityUpdates *bool `protobuf:"varint,3,opt,name=allow_strict_availability_updates,json=allowStrictAvailabilityUpdates,proto3,oneof" json:"allow_strict_availability_updates,omitempty"`
	// If condition updates are enabled, Google always updates item condition
	// with the condition detected from the details of your product.
	AllowConditionUpdates *bool `protobuf:"varint,4,opt,name=allow_condition_updates,json=allowConditionUpdates,proto3,oneof" json:"allow_condition_updates,omitempty"`
}

func (x *AutomaticItemUpdates_ItemUpdatesAccountLevelSettings) Reset() {
	*x = AutomaticItemUpdates_ItemUpdatesAccountLevelSettings{}
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomaticItemUpdates_ItemUpdatesAccountLevelSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomaticItemUpdates_ItemUpdatesAccountLevelSettings) ProtoMessage() {}

func (x *AutomaticItemUpdates_ItemUpdatesAccountLevelSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomaticItemUpdates_ItemUpdatesAccountLevelSettings.ProtoReflect.Descriptor instead.
func (*AutomaticItemUpdates_ItemUpdatesAccountLevelSettings) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescGZIP(), []int{1, 0}
}

func (x *AutomaticItemUpdates_ItemUpdatesAccountLevelSettings) GetAllowPriceUpdates() bool {
	if x != nil && x.AllowPriceUpdates != nil {
		return *x.AllowPriceUpdates
	}
	return false
}

func (x *AutomaticItemUpdates_ItemUpdatesAccountLevelSettings) GetAllowAvailabilityUpdates() bool {
	if x != nil && x.AllowAvailabilityUpdates != nil {
		return *x.AllowAvailabilityUpdates
	}
	return false
}

func (x *AutomaticItemUpdates_ItemUpdatesAccountLevelSettings) GetAllowStrictAvailabilityUpdates() bool {
	if x != nil && x.AllowStrictAvailabilityUpdates != nil {
		return *x.AllowStrictAvailabilityUpdates
	}
	return false
}

func (x *AutomaticItemUpdates_ItemUpdatesAccountLevelSettings) GetAllowConditionUpdates() bool {
	if x != nil && x.AllowConditionUpdates != nil {
		return *x.AllowConditionUpdates
	}
	return false
}

// Settings for the Automatic Image Improvements.
type AutomaticImageImprovements_ImageImprovementsAccountLevelSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables automatic image improvements.
	AllowAutomaticImageImprovements *bool `protobuf:"varint,1,opt,name=allow_automatic_image_improvements,json=allowAutomaticImageImprovements,proto3,oneof" json:"allow_automatic_image_improvements,omitempty"`
}

func (x *AutomaticImageImprovements_ImageImprovementsAccountLevelSettings) Reset() {
	*x = AutomaticImageImprovements_ImageImprovementsAccountLevelSettings{}
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomaticImageImprovements_ImageImprovementsAccountLevelSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomaticImageImprovements_ImageImprovementsAccountLevelSettings) ProtoMessage() {}

func (x *AutomaticImageImprovements_ImageImprovementsAccountLevelSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomaticImageImprovements_ImageImprovementsAccountLevelSettings.ProtoReflect.Descriptor instead.
func (*AutomaticImageImprovements_ImageImprovementsAccountLevelSettings) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescGZIP(), []int{2, 0}
}

func (x *AutomaticImageImprovements_ImageImprovementsAccountLevelSettings) GetAllowAutomaticImageImprovements() bool {
	if x != nil && x.AllowAutomaticImageImprovements != nil {
		return *x.AllowAutomaticImageImprovements
	}
	return false
}

var File_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDesc = []byte{
	0x0a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x63, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe9, 0x04, 0x0a, 0x15, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x66, 0x0a, 0x0c, 0x69, 0x74, 0x65, 0x6d,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x49, 0x74, 0x65, 0x6d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x48, 0x00,
	0x52, 0x0b, 0x69, 0x74, 0x65, 0x6d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x78, 0x0a, 0x12, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x63, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x48, 0x01, 0x52, 0x11, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x15, 0x73,
	0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x53,
	0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x48, 0x02, 0x52, 0x14, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x49,
	0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x88, 0x01, 0x01, 0x3a, 0x8e,
	0x01, 0xea, 0x41, 0x8a, 0x01, 0x0a, 0x30, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61,
	0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x28, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2a, 0x15, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x32, 0x15, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42,
	0x0f, 0x0a, 0x0d, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73,
	0x42, 0x15, 0x0a, 0x13, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x73, 0x68, 0x69, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x22, 0xb2, 0x07, 0x0a, 0x14, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49,
	0x74, 0x65, 0x6d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0xa6, 0x01, 0x0a, 0x1d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x74, 0x65, 0x6d, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x73, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x49, 0x74, 0x65, 0x6d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x46, 0x0a, 0x1d, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x1a, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x50,
	0x72, 0x69, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x24, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x21,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x73, 0x12, 0x61, 0x0a, 0x2b, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x27, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x21, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x1e, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x41,
	0x6c, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x1a, 0x9f, 0x03, 0x0a, 0x1f, 0x49, 0x74, 0x65, 0x6d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a,
	0x1a, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x01, 0x52, 0x18, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x4e, 0x0a, 0x21, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
	0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x1e, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x3b, 0x0a, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x03, 0x52, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x42, 0x16, 0x0a,
	0x14, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x73, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x42, 0x24, 0x0a, 0x22, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x22, 0x92, 0x04, 0x0a, 0x1a, 0x41, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xc3, 0x01, 0x0a, 0x23, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x6a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49,
	0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x2c, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x28, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x1a, 0xa0, 0x01, 0x0a, 0x25, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x50, 0x0a, 0x22, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x1f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x88, 0x01, 0x01, 0x42, 0x25, 0x0a, 0x23,
	0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x84, 0x01, 0x0a, 0x1d,
	0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x43, 0x0a,
	0x1b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f,
	0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x68, 0x69, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x88,
	0x01, 0x01, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x68, 0x69,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x22, 0x6f, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xe3, 0x01, 0x0a, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7b, 0x0a, 0x16, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49,
	0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x15, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x32, 0x9f, 0x05, 0x0a, 0x1c, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xef, 0x01, 0x0a, 0x18, 0x47,
	0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49,
	0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3a, 0x12, 0x38, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49,
	0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x7d, 0x12, 0xc3, 0x02, 0x0a,
	0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63,
	0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49,
	0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x94, 0x01, 0xda, 0x41,
	0x22, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x69, 0x3a, 0x16, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x63, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x32, 0x4f, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x7d, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61,
	0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x9c, 0x01, 0x0a, 0x2c,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x1a, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x3b,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_goTypes = []any{
	(*AutomaticImprovements)(nil),                                            // 0: google.shopping.merchant.accounts.v1beta.AutomaticImprovements
	(*AutomaticItemUpdates)(nil),                                             // 1: google.shopping.merchant.accounts.v1beta.AutomaticItemUpdates
	(*AutomaticImageImprovements)(nil),                                       // 2: google.shopping.merchant.accounts.v1beta.AutomaticImageImprovements
	(*AutomaticShippingImprovements)(nil),                                    // 3: google.shopping.merchant.accounts.v1beta.AutomaticShippingImprovements
	(*GetAutomaticImprovementsRequest)(nil),                                  // 4: google.shopping.merchant.accounts.v1beta.GetAutomaticImprovementsRequest
	(*UpdateAutomaticImprovementsRequest)(nil),                               // 5: google.shopping.merchant.accounts.v1beta.UpdateAutomaticImprovementsRequest
	(*AutomaticItemUpdates_ItemUpdatesAccountLevelSettings)(nil),             // 6: google.shopping.merchant.accounts.v1beta.AutomaticItemUpdates.ItemUpdatesAccountLevelSettings
	(*AutomaticImageImprovements_ImageImprovementsAccountLevelSettings)(nil), // 7: google.shopping.merchant.accounts.v1beta.AutomaticImageImprovements.ImageImprovementsAccountLevelSettings
	(*fieldmaskpb.FieldMask)(nil),                                            // 8: google.protobuf.FieldMask
}
var file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_depIdxs = []int32{
	1, // 0: google.shopping.merchant.accounts.v1beta.AutomaticImprovements.item_updates:type_name -> google.shopping.merchant.accounts.v1beta.AutomaticItemUpdates
	2, // 1: google.shopping.merchant.accounts.v1beta.AutomaticImprovements.image_improvements:type_name -> google.shopping.merchant.accounts.v1beta.AutomaticImageImprovements
	3, // 2: google.shopping.merchant.accounts.v1beta.AutomaticImprovements.shipping_improvements:type_name -> google.shopping.merchant.accounts.v1beta.AutomaticShippingImprovements
	6, // 3: google.shopping.merchant.accounts.v1beta.AutomaticItemUpdates.account_item_updates_settings:type_name -> google.shopping.merchant.accounts.v1beta.AutomaticItemUpdates.ItemUpdatesAccountLevelSettings
	7, // 4: google.shopping.merchant.accounts.v1beta.AutomaticImageImprovements.account_image_improvements_settings:type_name -> google.shopping.merchant.accounts.v1beta.AutomaticImageImprovements.ImageImprovementsAccountLevelSettings
	0, // 5: google.shopping.merchant.accounts.v1beta.UpdateAutomaticImprovementsRequest.automatic_improvements:type_name -> google.shopping.merchant.accounts.v1beta.AutomaticImprovements
	8, // 6: google.shopping.merchant.accounts.v1beta.UpdateAutomaticImprovementsRequest.update_mask:type_name -> google.protobuf.FieldMask
	4, // 7: google.shopping.merchant.accounts.v1beta.AutomaticImprovementsService.GetAutomaticImprovements:input_type -> google.shopping.merchant.accounts.v1beta.GetAutomaticImprovementsRequest
	5, // 8: google.shopping.merchant.accounts.v1beta.AutomaticImprovementsService.UpdateAutomaticImprovements:input_type -> google.shopping.merchant.accounts.v1beta.UpdateAutomaticImprovementsRequest
	0, // 9: google.shopping.merchant.accounts.v1beta.AutomaticImprovementsService.GetAutomaticImprovements:output_type -> google.shopping.merchant.accounts.v1beta.AutomaticImprovements
	0, // 10: google.shopping.merchant.accounts.v1beta.AutomaticImprovementsService.UpdateAutomaticImprovements:output_type -> google.shopping.merchant.accounts.v1beta.AutomaticImprovements
	9, // [9:11] is the sub-list for method output_type
	7, // [7:9] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto != nil {
		return
	}
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[2].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes[7].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_automaticimprovements_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AutomaticImprovementsServiceClient is the client API for AutomaticImprovementsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AutomaticImprovementsServiceClient interface {
	// Retrieves the automatic improvements of an account.
	GetAutomaticImprovements(ctx context.Context, in *GetAutomaticImprovementsRequest, opts ...grpc.CallOption) (*AutomaticImprovements, error)
	// Updates the automatic improvements of an account.
	UpdateAutomaticImprovements(ctx context.Context, in *UpdateAutomaticImprovementsRequest, opts ...grpc.CallOption) (*AutomaticImprovements, error)
}

type automaticImprovementsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAutomaticImprovementsServiceClient(cc grpc.ClientConnInterface) AutomaticImprovementsServiceClient {
	return &automaticImprovementsServiceClient{cc}
}

func (c *automaticImprovementsServiceClient) GetAutomaticImprovements(ctx context.Context, in *GetAutomaticImprovementsRequest, opts ...grpc.CallOption) (*AutomaticImprovements, error) {
	out := new(AutomaticImprovements)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.AutomaticImprovementsService/GetAutomaticImprovements", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *automaticImprovementsServiceClient) UpdateAutomaticImprovements(ctx context.Context, in *UpdateAutomaticImprovementsRequest, opts ...grpc.CallOption) (*AutomaticImprovements, error) {
	out := new(AutomaticImprovements)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.AutomaticImprovementsService/UpdateAutomaticImprovements", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutomaticImprovementsServiceServer is the server API for AutomaticImprovementsService service.
type AutomaticImprovementsServiceServer interface {
	// Retrieves the automatic improvements of an account.
	GetAutomaticImprovements(context.Context, *GetAutomaticImprovementsRequest) (*AutomaticImprovements, error)
	// Updates the automatic improvements of an account.
	UpdateAutomaticImprovements(context.Context, *UpdateAutomaticImprovementsRequest) (*AutomaticImprovements, error)
}

// UnimplementedAutomaticImprovementsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAutomaticImprovementsServiceServer struct {
}

func (*UnimplementedAutomaticImprovementsServiceServer) GetAutomaticImprovements(context.Context, *GetAutomaticImprovementsRequest) (*AutomaticImprovements, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutomaticImprovements not implemented")
}
func (*UnimplementedAutomaticImprovementsServiceServer) UpdateAutomaticImprovements(context.Context, *UpdateAutomaticImprovementsRequest) (*AutomaticImprovements, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAutomaticImprovements not implemented")
}

func RegisterAutomaticImprovementsServiceServer(s *grpc.Server, srv AutomaticImprovementsServiceServer) {
	s.RegisterService(&_AutomaticImprovementsService_serviceDesc, srv)
}

func _AutomaticImprovementsService_GetAutomaticImprovements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutomaticImprovementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutomaticImprovementsServiceServer).GetAutomaticImprovements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.AutomaticImprovementsService/GetAutomaticImprovements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutomaticImprovementsServiceServer).GetAutomaticImprovements(ctx, req.(*GetAutomaticImprovementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutomaticImprovementsService_UpdateAutomaticImprovements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutomaticImprovementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutomaticImprovementsServiceServer).UpdateAutomaticImprovements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.AutomaticImprovementsService/UpdateAutomaticImprovements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutomaticImprovementsServiceServer).UpdateAutomaticImprovements(ctx, req.(*UpdateAutomaticImprovementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AutomaticImprovementsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.AutomaticImprovementsService",
	HandlerType: (*AutomaticImprovementsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAutomaticImprovements",
			Handler:    _AutomaticImprovementsService_GetAutomaticImprovements_Handler,
		},
		{
			MethodName: "UpdateAutomaticImprovements",
			Handler:    _AutomaticImprovementsService_UpdateAutomaticImprovements_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/automaticimprovements.proto",
}
