// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/servicehealth/v1/event_service.proto

package servicehealthpb

import (
	context "context"
	reflect "reflect"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

var File_google_cloud_servicehealth_v1_event_service_proto protoreflect.FileDescriptor

var file_google_cloud_servicehealth_v1_event_service_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2f, 0x76, 0x31, 0x2f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x32, 0xaa,
	0x0a, 0x0a, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x12, 0xae, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x9b, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xe3, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xd0, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x4a, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe7, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70,
	0x61, 0x63, 0x74, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63,
	0x74, 0x73, 0x12, 0xd4, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x22, 0x4b, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x50, 0xca, 0x41, 0x1c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe4, 0x01, 0x0a, 0x21,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76,
	0x31, 0x42, 0x11, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x70, 0x62, 0x3b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x70, 0x62, 0xaa,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var file_google_cloud_servicehealth_v1_event_service_proto_goTypes = []any{
	(*ListEventsRequest)(nil),               // 0: google.cloud.servicehealth.v1.ListEventsRequest
	(*GetEventRequest)(nil),                 // 1: google.cloud.servicehealth.v1.GetEventRequest
	(*ListOrganizationEventsRequest)(nil),   // 2: google.cloud.servicehealth.v1.ListOrganizationEventsRequest
	(*GetOrganizationEventRequest)(nil),     // 3: google.cloud.servicehealth.v1.GetOrganizationEventRequest
	(*ListOrganizationImpactsRequest)(nil),  // 4: google.cloud.servicehealth.v1.ListOrganizationImpactsRequest
	(*GetOrganizationImpactRequest)(nil),    // 5: google.cloud.servicehealth.v1.GetOrganizationImpactRequest
	(*ListEventsResponse)(nil),              // 6: google.cloud.servicehealth.v1.ListEventsResponse
	(*Event)(nil),                           // 7: google.cloud.servicehealth.v1.Event
	(*ListOrganizationEventsResponse)(nil),  // 8: google.cloud.servicehealth.v1.ListOrganizationEventsResponse
	(*OrganizationEvent)(nil),               // 9: google.cloud.servicehealth.v1.OrganizationEvent
	(*ListOrganizationImpactsResponse)(nil), // 10: google.cloud.servicehealth.v1.ListOrganizationImpactsResponse
	(*OrganizationImpact)(nil),              // 11: google.cloud.servicehealth.v1.OrganizationImpact
}
var file_google_cloud_servicehealth_v1_event_service_proto_depIdxs = []int32{
	0,  // 0: google.cloud.servicehealth.v1.ServiceHealth.ListEvents:input_type -> google.cloud.servicehealth.v1.ListEventsRequest
	1,  // 1: google.cloud.servicehealth.v1.ServiceHealth.GetEvent:input_type -> google.cloud.servicehealth.v1.GetEventRequest
	2,  // 2: google.cloud.servicehealth.v1.ServiceHealth.ListOrganizationEvents:input_type -> google.cloud.servicehealth.v1.ListOrganizationEventsRequest
	3,  // 3: google.cloud.servicehealth.v1.ServiceHealth.GetOrganizationEvent:input_type -> google.cloud.servicehealth.v1.GetOrganizationEventRequest
	4,  // 4: google.cloud.servicehealth.v1.ServiceHealth.ListOrganizationImpacts:input_type -> google.cloud.servicehealth.v1.ListOrganizationImpactsRequest
	5,  // 5: google.cloud.servicehealth.v1.ServiceHealth.GetOrganizationImpact:input_type -> google.cloud.servicehealth.v1.GetOrganizationImpactRequest
	6,  // 6: google.cloud.servicehealth.v1.ServiceHealth.ListEvents:output_type -> google.cloud.servicehealth.v1.ListEventsResponse
	7,  // 7: google.cloud.servicehealth.v1.ServiceHealth.GetEvent:output_type -> google.cloud.servicehealth.v1.Event
	8,  // 8: google.cloud.servicehealth.v1.ServiceHealth.ListOrganizationEvents:output_type -> google.cloud.servicehealth.v1.ListOrganizationEventsResponse
	9,  // 9: google.cloud.servicehealth.v1.ServiceHealth.GetOrganizationEvent:output_type -> google.cloud.servicehealth.v1.OrganizationEvent
	10, // 10: google.cloud.servicehealth.v1.ServiceHealth.ListOrganizationImpacts:output_type -> google.cloud.servicehealth.v1.ListOrganizationImpactsResponse
	11, // 11: google.cloud.servicehealth.v1.ServiceHealth.GetOrganizationImpact:output_type -> google.cloud.servicehealth.v1.OrganizationImpact
	6,  // [6:12] is the sub-list for method output_type
	0,  // [0:6] is the sub-list for method input_type
	0,  // [0:0] is the sub-list for extension type_name
	0,  // [0:0] is the sub-list for extension extendee
	0,  // [0:0] is the sub-list for field type_name
}

func init() { file_google_cloud_servicehealth_v1_event_service_proto_init() }
func file_google_cloud_servicehealth_v1_event_service_proto_init() {
	if File_google_cloud_servicehealth_v1_event_service_proto != nil {
		return
	}
	file_google_cloud_servicehealth_v1_event_resources_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_servicehealth_v1_event_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   0,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_servicehealth_v1_event_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_servicehealth_v1_event_service_proto_depIdxs,
	}.Build()
	File_google_cloud_servicehealth_v1_event_service_proto = out.File
	file_google_cloud_servicehealth_v1_event_service_proto_rawDesc = nil
	file_google_cloud_servicehealth_v1_event_service_proto_goTypes = nil
	file_google_cloud_servicehealth_v1_event_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ServiceHealthClient is the client API for ServiceHealth service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ServiceHealthClient interface {
	// Lists events under a given project and location.
	ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error)
	// Retrieves a resource containing information about an event.
	GetEvent(ctx context.Context, in *GetEventRequest, opts ...grpc.CallOption) (*Event, error)
	// Lists organization events under a given organization and location.
	ListOrganizationEvents(ctx context.Context, in *ListOrganizationEventsRequest, opts ...grpc.CallOption) (*ListOrganizationEventsResponse, error)
	// Retrieves a resource containing information about an event affecting an
	// organization .
	GetOrganizationEvent(ctx context.Context, in *GetOrganizationEventRequest, opts ...grpc.CallOption) (*OrganizationEvent, error)
	// Lists assets impacted by organization events under a given organization and
	// location.
	ListOrganizationImpacts(ctx context.Context, in *ListOrganizationImpactsRequest, opts ...grpc.CallOption) (*ListOrganizationImpactsResponse, error)
	// Retrieves a resource containing information about impact to an asset under
	// an organization affected by a service health event.
	GetOrganizationImpact(ctx context.Context, in *GetOrganizationImpactRequest, opts ...grpc.CallOption) (*OrganizationImpact, error)
}

type serviceHealthClient struct {
	cc grpc.ClientConnInterface
}

func NewServiceHealthClient(cc grpc.ClientConnInterface) ServiceHealthClient {
	return &serviceHealthClient{cc}
}

func (c *serviceHealthClient) ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error) {
	out := new(ListEventsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.servicehealth.v1.ServiceHealth/ListEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceHealthClient) GetEvent(ctx context.Context, in *GetEventRequest, opts ...grpc.CallOption) (*Event, error) {
	out := new(Event)
	err := c.cc.Invoke(ctx, "/google.cloud.servicehealth.v1.ServiceHealth/GetEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceHealthClient) ListOrganizationEvents(ctx context.Context, in *ListOrganizationEventsRequest, opts ...grpc.CallOption) (*ListOrganizationEventsResponse, error) {
	out := new(ListOrganizationEventsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.servicehealth.v1.ServiceHealth/ListOrganizationEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceHealthClient) GetOrganizationEvent(ctx context.Context, in *GetOrganizationEventRequest, opts ...grpc.CallOption) (*OrganizationEvent, error) {
	out := new(OrganizationEvent)
	err := c.cc.Invoke(ctx, "/google.cloud.servicehealth.v1.ServiceHealth/GetOrganizationEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceHealthClient) ListOrganizationImpacts(ctx context.Context, in *ListOrganizationImpactsRequest, opts ...grpc.CallOption) (*ListOrganizationImpactsResponse, error) {
	out := new(ListOrganizationImpactsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.servicehealth.v1.ServiceHealth/ListOrganizationImpacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceHealthClient) GetOrganizationImpact(ctx context.Context, in *GetOrganizationImpactRequest, opts ...grpc.CallOption) (*OrganizationImpact, error) {
	out := new(OrganizationImpact)
	err := c.cc.Invoke(ctx, "/google.cloud.servicehealth.v1.ServiceHealth/GetOrganizationImpact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceHealthServer is the server API for ServiceHealth service.
type ServiceHealthServer interface {
	// Lists events under a given project and location.
	ListEvents(context.Context, *ListEventsRequest) (*ListEventsResponse, error)
	// Retrieves a resource containing information about an event.
	GetEvent(context.Context, *GetEventRequest) (*Event, error)
	// Lists organization events under a given organization and location.
	ListOrganizationEvents(context.Context, *ListOrganizationEventsRequest) (*ListOrganizationEventsResponse, error)
	// Retrieves a resource containing information about an event affecting an
	// organization .
	GetOrganizationEvent(context.Context, *GetOrganizationEventRequest) (*OrganizationEvent, error)
	// Lists assets impacted by organization events under a given organization and
	// location.
	ListOrganizationImpacts(context.Context, *ListOrganizationImpactsRequest) (*ListOrganizationImpactsResponse, error)
	// Retrieves a resource containing information about impact to an asset under
	// an organization affected by a service health event.
	GetOrganizationImpact(context.Context, *GetOrganizationImpactRequest) (*OrganizationImpact, error)
}

// UnimplementedServiceHealthServer can be embedded to have forward compatible implementations.
type UnimplementedServiceHealthServer struct {
}

func (*UnimplementedServiceHealthServer) ListEvents(context.Context, *ListEventsRequest) (*ListEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvents not implemented")
}
func (*UnimplementedServiceHealthServer) GetEvent(context.Context, *GetEventRequest) (*Event, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEvent not implemented")
}
func (*UnimplementedServiceHealthServer) ListOrganizationEvents(context.Context, *ListOrganizationEventsRequest) (*ListOrganizationEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrganizationEvents not implemented")
}
func (*UnimplementedServiceHealthServer) GetOrganizationEvent(context.Context, *GetOrganizationEventRequest) (*OrganizationEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganizationEvent not implemented")
}
func (*UnimplementedServiceHealthServer) ListOrganizationImpacts(context.Context, *ListOrganizationImpactsRequest) (*ListOrganizationImpactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrganizationImpacts not implemented")
}
func (*UnimplementedServiceHealthServer) GetOrganizationImpact(context.Context, *GetOrganizationImpactRequest) (*OrganizationImpact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganizationImpact not implemented")
}

func RegisterServiceHealthServer(s *grpc.Server, srv ServiceHealthServer) {
	s.RegisterService(&_ServiceHealth_serviceDesc, srv)
}

func _ServiceHealth_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceHealthServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicehealth.v1.ServiceHealth/ListEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceHealthServer).ListEvents(ctx, req.(*ListEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceHealth_GetEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceHealthServer).GetEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicehealth.v1.ServiceHealth/GetEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceHealthServer).GetEvent(ctx, req.(*GetEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceHealth_ListOrganizationEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOrganizationEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceHealthServer).ListOrganizationEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicehealth.v1.ServiceHealth/ListOrganizationEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceHealthServer).ListOrganizationEvents(ctx, req.(*ListOrganizationEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceHealth_GetOrganizationEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceHealthServer).GetOrganizationEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicehealth.v1.ServiceHealth/GetOrganizationEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceHealthServer).GetOrganizationEvent(ctx, req.(*GetOrganizationEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceHealth_ListOrganizationImpacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOrganizationImpactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceHealthServer).ListOrganizationImpacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicehealth.v1.ServiceHealth/ListOrganizationImpacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceHealthServer).ListOrganizationImpacts(ctx, req.(*ListOrganizationImpactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceHealth_GetOrganizationImpact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationImpactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceHealthServer).GetOrganizationImpact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.servicehealth.v1.ServiceHealth/GetOrganizationImpact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceHealthServer).GetOrganizationImpact(ctx, req.(*GetOrganizationImpactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceHealth_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.servicehealth.v1.ServiceHealth",
	HandlerType: (*ServiceHealthServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEvents",
			Handler:    _ServiceHealth_ListEvents_Handler,
		},
		{
			MethodName: "GetEvent",
			Handler:    _ServiceHealth_GetEvent_Handler,
		},
		{
			MethodName: "ListOrganizationEvents",
			Handler:    _ServiceHealth_ListOrganizationEvents_Handler,
		},
		{
			MethodName: "GetOrganizationEvent",
			Handler:    _ServiceHealth_GetOrganizationEvent_Handler,
		},
		{
			MethodName: "ListOrganizationImpacts",
			Handler:    _ServiceHealth_ListOrganizationImpacts_Handler,
		},
		{
			MethodName: "GetOrganizationImpact",
			Handler:    _ServiceHealth_GetOrganizationImpact_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/servicehealth/v1/event_service.proto",
}
