// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/servicehealth/v1/event_resources.proto

package servicehealthpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The event fields to include in ListEvents API response. This enum lists all
// possible event views.
type EventView int32

const (
	// Unspecified event view. Default to `EVENT_VIEW_BASIC`.
	EventView_EVENT_VIEW_UNSPECIFIED EventView = 0
	// Includes all fields except `updates`. This view is the default for
	// ListEvents API.
	EventView_EVENT_VIEW_BASIC EventView = 1
	// Includes all event fields.
	EventView_EVENT_VIEW_FULL EventView = 2
)

// Enum value maps for EventView.
var (
	EventView_name = map[int32]string{
		0: "EVENT_VIEW_UNSPECIFIED",
		1: "EVENT_VIEW_BASIC",
		2: "EVENT_VIEW_FULL",
	}
	EventView_value = map[string]int32{
		"EVENT_VIEW_UNSPECIFIED": 0,
		"EVENT_VIEW_BASIC":       1,
		"EVENT_VIEW_FULL":        2,
	}
)

func (x EventView) Enum() *EventView {
	p := new(EventView)
	*p = x
	return p
}

func (x EventView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[0].Descriptor()
}

func (EventView) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[0]
}

func (x EventView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventView.Descriptor instead.
func (EventView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{0}
}

// The organization event fields to include in ListOrganizationEvents API
// response. This enum lists all possible organization event views.
type OrganizationEventView int32

const (
	// Unspecified event view. Default to `ORGANIZATION_EVENT_VIEW_BASIC`.
	OrganizationEventView_ORGANIZATION_EVENT_VIEW_UNSPECIFIED OrganizationEventView = 0
	// Includes all organization event fields except `updates`. This view is the
	// default for ListOrganizationEvents API.
	OrganizationEventView_ORGANIZATION_EVENT_VIEW_BASIC OrganizationEventView = 1
	// Includes all organization event fields.
	OrganizationEventView_ORGANIZATION_EVENT_VIEW_FULL OrganizationEventView = 2
)

// Enum value maps for OrganizationEventView.
var (
	OrganizationEventView_name = map[int32]string{
		0: "ORGANIZATION_EVENT_VIEW_UNSPECIFIED",
		1: "ORGANIZATION_EVENT_VIEW_BASIC",
		2: "ORGANIZATION_EVENT_VIEW_FULL",
	}
	OrganizationEventView_value = map[string]int32{
		"ORGANIZATION_EVENT_VIEW_UNSPECIFIED": 0,
		"ORGANIZATION_EVENT_VIEW_BASIC":       1,
		"ORGANIZATION_EVENT_VIEW_FULL":        2,
	}
)

func (x OrganizationEventView) Enum() *OrganizationEventView {
	p := new(OrganizationEventView)
	*p = x
	return p
}

func (x OrganizationEventView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrganizationEventView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[1].Descriptor()
}

func (OrganizationEventView) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[1]
}

func (x OrganizationEventView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OrganizationEventView.Descriptor instead.
func (OrganizationEventView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{1}
}

// The category of the event. This enum lists all possible categories of
// event.
type Event_EventCategory int32

const (
	// Unspecified category.
	Event_EVENT_CATEGORY_UNSPECIFIED Event_EventCategory = 0
	// Event category for service outage or degradation.
	Event_INCIDENT Event_EventCategory = 2
)

// Enum value maps for Event_EventCategory.
var (
	Event_EventCategory_name = map[int32]string{
		0: "EVENT_CATEGORY_UNSPECIFIED",
		2: "INCIDENT",
	}
	Event_EventCategory_value = map[string]int32{
		"EVENT_CATEGORY_UNSPECIFIED": 0,
		"INCIDENT":                   2,
	}
)

func (x Event_EventCategory) Enum() *Event_EventCategory {
	p := new(Event_EventCategory)
	*p = x
	return p
}

func (x Event_EventCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Event_EventCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[2].Descriptor()
}

func (Event_EventCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[2]
}

func (x Event_EventCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Event_EventCategory.Descriptor instead.
func (Event_EventCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{0, 0}
}

// The detailed category of an event. Contains all possible states for all
// event categories.
type Event_DetailedCategory int32

const (
	// Unspecified detailed category.
	Event_DETAILED_CATEGORY_UNSPECIFIED Event_DetailedCategory = 0
	// Indicates an event with category INCIDENT has a confirmed impact to at
	// least one Google Cloud product.
	Event_CONFIRMED_INCIDENT Event_DetailedCategory = 1
	// Indicates an event with category INCIDENT is under investigation to
	// determine if it has a confirmed impact on any Google Cloud products.
	Event_EMERGING_INCIDENT Event_DetailedCategory = 2
)

// Enum value maps for Event_DetailedCategory.
var (
	Event_DetailedCategory_name = map[int32]string{
		0: "DETAILED_CATEGORY_UNSPECIFIED",
		1: "CONFIRMED_INCIDENT",
		2: "EMERGING_INCIDENT",
	}
	Event_DetailedCategory_value = map[string]int32{
		"DETAILED_CATEGORY_UNSPECIFIED": 0,
		"CONFIRMED_INCIDENT":            1,
		"EMERGING_INCIDENT":             2,
	}
)

func (x Event_DetailedCategory) Enum() *Event_DetailedCategory {
	p := new(Event_DetailedCategory)
	*p = x
	return p
}

func (x Event_DetailedCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Event_DetailedCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[3].Descriptor()
}

func (Event_DetailedCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[3]
}

func (x Event_DetailedCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Event_DetailedCategory.Descriptor instead.
func (Event_DetailedCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{0, 1}
}

// The state of the event. This enum lists all possible states of event.
type Event_State int32

const (
	// Unspecified state.
	Event_STATE_UNSPECIFIED Event_State = 0
	// Event is actively affecting a Google Cloud product and will continue to
	// receive updates.
	Event_ACTIVE Event_State = 1
	// Event is no longer affecting the Google Cloud product or has been merged
	// with another event.
	Event_CLOSED Event_State = 2
)

// Enum value maps for Event_State.
var (
	Event_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CLOSED",
	}
	Event_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CLOSED":            2,
	}
)

func (x Event_State) Enum() *Event_State {
	p := new(Event_State)
	*p = x
	return p
}

func (x Event_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Event_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[4].Descriptor()
}

func (Event_State) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[4]
}

func (x Event_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Event_State.Descriptor instead.
func (Event_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{0, 2}
}

// The detailed state of the incident. This enum lists all possible detailed
// states of an incident.
type Event_DetailedState int32

const (
	// Unspecified detail state.
	Event_DETAILED_STATE_UNSPECIFIED Event_DetailedState = 0
	// Google engineers are actively investigating the event to determine the
	// impact.
	Event_EMERGING Event_DetailedState = 1
	// The incident is confirmed and impacting at least one Google Cloud
	// product. Ongoing status updates will be provided until it is resolved.
	Event_CONFIRMED Event_DetailedState = 2
	// The incident is no longer affecting any Google Cloud product, and there
	// will be no further updates.
	Event_RESOLVED Event_DetailedState = 3
	// The incident was merged into a parent incident. All further updates will
	// be published to the parent only. The `parent_event` field contains the
	// name of the parent.
	Event_MERGED Event_DetailedState = 4
	// The incident was automatically closed because of the following reasons:
	//
	//   - The impact of the incident could not be confirmed.
	//
	//   - The incident was intermittent or resolved itself.
	//
	//     The incident does not have a resolution because no action or
	//     investigation happened. If it is intermittent, the incident may reopen.
	Event_AUTO_CLOSED Event_DetailedState = 9
	// Upon investigation, Google engineers concluded that the incident is not
	// affecting a Google Cloud product. This state can change if the incident
	// is reviewed again.
	Event_FALSE_POSITIVE Event_DetailedState = 10
)

// Enum value maps for Event_DetailedState.
var (
	Event_DetailedState_name = map[int32]string{
		0:  "DETAILED_STATE_UNSPECIFIED",
		1:  "EMERGING",
		2:  "CONFIRMED",
		3:  "RESOLVED",
		4:  "MERGED",
		9:  "AUTO_CLOSED",
		10: "FALSE_POSITIVE",
	}
	Event_DetailedState_value = map[string]int32{
		"DETAILED_STATE_UNSPECIFIED": 0,
		"EMERGING":                   1,
		"CONFIRMED":                  2,
		"RESOLVED":                   3,
		"MERGED":                     4,
		"AUTO_CLOSED":                9,
		"FALSE_POSITIVE":             10,
	}
)

func (x Event_DetailedState) Enum() *Event_DetailedState {
	p := new(Event_DetailedState)
	*p = x
	return p
}

func (x Event_DetailedState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Event_DetailedState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[5].Descriptor()
}

func (Event_DetailedState) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[5]
}

func (x Event_DetailedState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Event_DetailedState.Descriptor instead.
func (Event_DetailedState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{0, 3}
}

// Communicates why a given incident is deemed relevant in the context of a
// given project. This enum lists all possible detailed states of relevance.
type Event_Relevance int32

const (
	// Unspecified relevance.
	Event_RELEVANCE_UNSPECIFIED Event_Relevance = 0
	// The relevance of the incident to the project is unknown.
	Event_UNKNOWN Event_Relevance = 2
	// The incident does not impact the project.
	Event_NOT_IMPACTED Event_Relevance = 6
	// The incident is associated with a Google Cloud product your project uses,
	// but the incident may not be impacting your project. For example, the
	// incident may be impacting a Google Cloud product that your project uses,
	// but in a location that your project does not use.
	Event_PARTIALLY_RELATED Event_Relevance = 7
	// The incident has a direct connection with your project and impacts a
	// Google Cloud product in a location your project uses.
	Event_RELATED Event_Relevance = 8
	// The incident is verified to be impacting your project.
	Event_IMPACTED Event_Relevance = 9
)

// Enum value maps for Event_Relevance.
var (
	Event_Relevance_name = map[int32]string{
		0: "RELEVANCE_UNSPECIFIED",
		2: "UNKNOWN",
		6: "NOT_IMPACTED",
		7: "PARTIALLY_RELATED",
		8: "RELATED",
		9: "IMPACTED",
	}
	Event_Relevance_value = map[string]int32{
		"RELEVANCE_UNSPECIFIED": 0,
		"UNKNOWN":               2,
		"NOT_IMPACTED":          6,
		"PARTIALLY_RELATED":     7,
		"RELATED":               8,
		"IMPACTED":              9,
	}
)

func (x Event_Relevance) Enum() *Event_Relevance {
	p := new(Event_Relevance)
	*p = x
	return p
}

func (x Event_Relevance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Event_Relevance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[6].Descriptor()
}

func (Event_Relevance) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[6]
}

func (x Event_Relevance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Event_Relevance.Descriptor instead.
func (Event_Relevance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{0, 4}
}

// The category of the event. This enum lists all possible categories of
// event.
type OrganizationEvent_EventCategory int32

const (
	// Unspecified category.
	OrganizationEvent_EVENT_CATEGORY_UNSPECIFIED OrganizationEvent_EventCategory = 0
	// Event category for service outage or degradation.
	OrganizationEvent_INCIDENT OrganizationEvent_EventCategory = 2
)

// Enum value maps for OrganizationEvent_EventCategory.
var (
	OrganizationEvent_EventCategory_name = map[int32]string{
		0: "EVENT_CATEGORY_UNSPECIFIED",
		2: "INCIDENT",
	}
	OrganizationEvent_EventCategory_value = map[string]int32{
		"EVENT_CATEGORY_UNSPECIFIED": 0,
		"INCIDENT":                   2,
	}
)

func (x OrganizationEvent_EventCategory) Enum() *OrganizationEvent_EventCategory {
	p := new(OrganizationEvent_EventCategory)
	*p = x
	return p
}

func (x OrganizationEvent_EventCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrganizationEvent_EventCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[7].Descriptor()
}

func (OrganizationEvent_EventCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[7]
}

func (x OrganizationEvent_EventCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OrganizationEvent_EventCategory.Descriptor instead.
func (OrganizationEvent_EventCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{1, 0}
}

// The detailed category of an event. Contains all possible states for all
// event categories.
type OrganizationEvent_DetailedCategory int32

const (
	// Unspecified detailed category.
	OrganizationEvent_DETAILED_CATEGORY_UNSPECIFIED OrganizationEvent_DetailedCategory = 0
	// Indicates an event with category INCIDENT has a confirmed impact to at
	// least one Google Cloud product.
	OrganizationEvent_CONFIRMED_INCIDENT OrganizationEvent_DetailedCategory = 1
	// Indicates an event with category INCIDENT is under investigation to
	// determine if it has a confirmed impact on any Google Cloud products.
	OrganizationEvent_EMERGING_INCIDENT OrganizationEvent_DetailedCategory = 2
)

// Enum value maps for OrganizationEvent_DetailedCategory.
var (
	OrganizationEvent_DetailedCategory_name = map[int32]string{
		0: "DETAILED_CATEGORY_UNSPECIFIED",
		1: "CONFIRMED_INCIDENT",
		2: "EMERGING_INCIDENT",
	}
	OrganizationEvent_DetailedCategory_value = map[string]int32{
		"DETAILED_CATEGORY_UNSPECIFIED": 0,
		"CONFIRMED_INCIDENT":            1,
		"EMERGING_INCIDENT":             2,
	}
)

func (x OrganizationEvent_DetailedCategory) Enum() *OrganizationEvent_DetailedCategory {
	p := new(OrganizationEvent_DetailedCategory)
	*p = x
	return p
}

func (x OrganizationEvent_DetailedCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrganizationEvent_DetailedCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[8].Descriptor()
}

func (OrganizationEvent_DetailedCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[8]
}

func (x OrganizationEvent_DetailedCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OrganizationEvent_DetailedCategory.Descriptor instead.
func (OrganizationEvent_DetailedCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{1, 1}
}

// The state of the organization event. This enum lists all possible states of
// event.
type OrganizationEvent_State int32

const (
	// Unspecified state.
	OrganizationEvent_STATE_UNSPECIFIED OrganizationEvent_State = 0
	// Event is actively affecting a Google Cloud product and will continue to
	// receive updates.
	OrganizationEvent_ACTIVE OrganizationEvent_State = 1
	// Event is no longer affecting the Google Cloud product or has been merged
	// with another event.
	OrganizationEvent_CLOSED OrganizationEvent_State = 2
)

// Enum value maps for OrganizationEvent_State.
var (
	OrganizationEvent_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CLOSED",
	}
	OrganizationEvent_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CLOSED":            2,
	}
)

func (x OrganizationEvent_State) Enum() *OrganizationEvent_State {
	p := new(OrganizationEvent_State)
	*p = x
	return p
}

func (x OrganizationEvent_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrganizationEvent_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[9].Descriptor()
}

func (OrganizationEvent_State) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[9]
}

func (x OrganizationEvent_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OrganizationEvent_State.Descriptor instead.
func (OrganizationEvent_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{1, 2}
}

// The detailed state of the incident. This enum lists all possible detailed
// states of an incident.
type OrganizationEvent_DetailedState int32

const (
	// Unspecified detail state.
	OrganizationEvent_DETAILED_STATE_UNSPECIFIED OrganizationEvent_DetailedState = 0
	// Google engineers are actively investigating the incident to determine the
	// impact.
	OrganizationEvent_EMERGING OrganizationEvent_DetailedState = 1
	// The incident is confirmed and impacting at least one Google Cloud
	// product. Ongoing status updates will be provided until it is resolved.
	OrganizationEvent_CONFIRMED OrganizationEvent_DetailedState = 2
	// The incident is no longer affecting any Google Cloud product, and there
	// will be no further updates.
	OrganizationEvent_RESOLVED OrganizationEvent_DetailedState = 3
	// The incident was merged into a parent event. All further updates will be
	// published to the parent only. The `parent_event` contains the name of the
	// parent.
	OrganizationEvent_MERGED OrganizationEvent_DetailedState = 4
	// The incident was automatically closed because of the following reasons:
	//
	//   - The impact of the incident could not be confirmed.
	//
	//   - The incident was intermittent or resolved itself.
	//
	//     The incident does not have a resolution because no action or
	//     investigation happened. If it is intermittent, the incident may reopen.
	OrganizationEvent_AUTO_CLOSED OrganizationEvent_DetailedState = 9
	// Upon investigation, Google engineers concluded that the incident is not
	// affecting a Google Cloud product. This state can change if the incident
	// is reviewed again.
	OrganizationEvent_FALSE_POSITIVE OrganizationEvent_DetailedState = 10
)

// Enum value maps for OrganizationEvent_DetailedState.
var (
	OrganizationEvent_DetailedState_name = map[int32]string{
		0:  "DETAILED_STATE_UNSPECIFIED",
		1:  "EMERGING",
		2:  "CONFIRMED",
		3:  "RESOLVED",
		4:  "MERGED",
		9:  "AUTO_CLOSED",
		10: "FALSE_POSITIVE",
	}
	OrganizationEvent_DetailedState_value = map[string]int32{
		"DETAILED_STATE_UNSPECIFIED": 0,
		"EMERGING":                   1,
		"CONFIRMED":                  2,
		"RESOLVED":                   3,
		"MERGED":                     4,
		"AUTO_CLOSED":                9,
		"FALSE_POSITIVE":             10,
	}
)

func (x OrganizationEvent_DetailedState) Enum() *OrganizationEvent_DetailedState {
	p := new(OrganizationEvent_DetailedState)
	*p = x
	return p
}

func (x OrganizationEvent_DetailedState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrganizationEvent_DetailedState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[10].Descriptor()
}

func (OrganizationEvent_DetailedState) Type() protoreflect.EnumType {
	return &file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes[10]
}

func (x OrganizationEvent_DetailedState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OrganizationEvent_DetailedState.Descriptor instead.
func (OrganizationEvent_DetailedState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{1, 3}
}

// Represents service health events that may affect Google Cloud products.
// Event resource is a read-only view and does not allow any modifications. All
// fields are output only.
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. Name of the event. Unique name of the event in
	// this scope including project and location using the form
	// `projects/{project_id}/locations/{location}/events/{event_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Brief description for the event.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Output only. Free-form, human-readable description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The category of the event.
	Category Event_EventCategory `protobuf:"varint,4,opt,name=category,proto3,enum=google.cloud.servicehealth.v1.Event_EventCategory" json:"category,omitempty"`
	// Output only. The detailed category of the event.
	DetailedCategory Event_DetailedCategory `protobuf:"varint,21,opt,name=detailed_category,json=detailedCategory,proto3,enum=google.cloud.servicehealth.v1.Event_DetailedCategory" json:"detailed_category,omitempty"`
	// Output only. The current state of the event.
	State Event_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.servicehealth.v1.Event_State" json:"state,omitempty"`
	// Output only. The current detailed state of the incident.
	DetailedState Event_DetailedState `protobuf:"varint,19,opt,name=detailed_state,json=detailedState,proto3,enum=google.cloud.servicehealth.v1.Event_DetailedState" json:"detailed_state,omitempty"`
	// Google Cloud products and locations impacted by the event.
	EventImpacts []*EventImpact `protobuf:"bytes,20,rep,name=event_impacts,json=eventImpacts,proto3" json:"event_impacts,omitempty"`
	// Output only. Communicates why a given event is deemed relevant in the
	// context of a given project.
	Relevance Event_Relevance `protobuf:"varint,8,opt,name=relevance,proto3,enum=google.cloud.servicehealth.v1.Event_Relevance" json:"relevance,omitempty"`
	// Output only. Event updates are correspondence from Google.
	Updates []*EventUpdate `protobuf:"bytes,9,rep,name=updates,proto3" json:"updates,omitempty"`
	// Output only. When `detailed_state`=`MERGED`, `parent_event` contains the
	// name of the parent event. All further updates will be published to the
	// parent event.
	ParentEvent string `protobuf:"bytes,10,opt,name=parent_event,json=parentEvent,proto3" json:"parent_event,omitempty"`
	// Output only. The time when the event was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The start time of the event, if applicable.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The end time of the event, if applicable.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The time when the next update can be expected.
	NextUpdateTime *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=next_update_time,json=nextUpdateTime,proto3" json:"next_update_time,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Event) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Event) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Event) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Event) GetCategory() Event_EventCategory {
	if x != nil {
		return x.Category
	}
	return Event_EVENT_CATEGORY_UNSPECIFIED
}

func (x *Event) GetDetailedCategory() Event_DetailedCategory {
	if x != nil {
		return x.DetailedCategory
	}
	return Event_DETAILED_CATEGORY_UNSPECIFIED
}

func (x *Event) GetState() Event_State {
	if x != nil {
		return x.State
	}
	return Event_STATE_UNSPECIFIED
}

func (x *Event) GetDetailedState() Event_DetailedState {
	if x != nil {
		return x.DetailedState
	}
	return Event_DETAILED_STATE_UNSPECIFIED
}

func (x *Event) GetEventImpacts() []*EventImpact {
	if x != nil {
		return x.EventImpacts
	}
	return nil
}

func (x *Event) GetRelevance() Event_Relevance {
	if x != nil {
		return x.Relevance
	}
	return Event_RELEVANCE_UNSPECIFIED
}

func (x *Event) GetUpdates() []*EventUpdate {
	if x != nil {
		return x.Updates
	}
	return nil
}

func (x *Event) GetParentEvent() string {
	if x != nil {
		return x.ParentEvent
	}
	return ""
}

func (x *Event) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Event) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Event) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Event) GetNextUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextUpdateTime
	}
	return nil
}

// Represents service health events that may affect Google Cloud products used
// across the organization. It is a read-only view and does not allow any
// modifications.
type OrganizationEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. Name of the event. Unique name of the event in
	// this scope including organization ID and location using the form
	// `organizations/{organization_id}/locations/{location}/organizationEvents/{event_id}`.
	//
	// `organization_id` - see [Getting your organization resource
	// ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
	// `location` - The location to get the service health events from.<br>
	// `event_id` - Organization event ID to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Brief description for the event.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Output only. Free-form, human-readable description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The category of the event.
	Category OrganizationEvent_EventCategory `protobuf:"varint,4,opt,name=category,proto3,enum=google.cloud.servicehealth.v1.OrganizationEvent_EventCategory" json:"category,omitempty"`
	// Output only. The detailed category of the event.
	DetailedCategory OrganizationEvent_DetailedCategory `protobuf:"varint,17,opt,name=detailed_category,json=detailedCategory,proto3,enum=google.cloud.servicehealth.v1.OrganizationEvent_DetailedCategory" json:"detailed_category,omitempty"`
	// Output only. The current state of the event.
	State OrganizationEvent_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.servicehealth.v1.OrganizationEvent_State" json:"state,omitempty"`
	// Output only. The current detailed state of the incident.
	DetailedState OrganizationEvent_DetailedState `protobuf:"varint,16,opt,name=detailed_state,json=detailedState,proto3,enum=google.cloud.servicehealth.v1.OrganizationEvent_DetailedState" json:"detailed_state,omitempty"`
	// Output only. Represents the Google Cloud products and locations impacted by
	// the event.
	EventImpacts []*EventImpact `protobuf:"bytes,15,rep,name=event_impacts,json=eventImpacts,proto3" json:"event_impacts,omitempty"`
	// Output only. Incident-only field. Event updates are correspondence from
	// Google.
	Updates []*EventUpdate `protobuf:"bytes,8,rep,name=updates,proto3" json:"updates,omitempty"`
	// Output only. When `detailed_state`=`MERGED`, `parent_event` contains the
	// name of the parent event. All further updates will be published to the
	// parent event.
	ParentEvent string `protobuf:"bytes,9,opt,name=parent_event,json=parentEvent,proto3" json:"parent_event,omitempty"`
	// Output only. The time the update was posted.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The start time of the event, if applicable.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The end time of the event, if applicable.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Incident-only field. The time when the next update can be
	// expected.
	NextUpdateTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=next_update_time,json=nextUpdateTime,proto3" json:"next_update_time,omitempty"`
}

func (x *OrganizationEvent) Reset() {
	*x = OrganizationEvent{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OrganizationEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrganizationEvent) ProtoMessage() {}

func (x *OrganizationEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrganizationEvent.ProtoReflect.Descriptor instead.
func (*OrganizationEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{1}
}

func (x *OrganizationEvent) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OrganizationEvent) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *OrganizationEvent) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *OrganizationEvent) GetCategory() OrganizationEvent_EventCategory {
	if x != nil {
		return x.Category
	}
	return OrganizationEvent_EVENT_CATEGORY_UNSPECIFIED
}

func (x *OrganizationEvent) GetDetailedCategory() OrganizationEvent_DetailedCategory {
	if x != nil {
		return x.DetailedCategory
	}
	return OrganizationEvent_DETAILED_CATEGORY_UNSPECIFIED
}

func (x *OrganizationEvent) GetState() OrganizationEvent_State {
	if x != nil {
		return x.State
	}
	return OrganizationEvent_STATE_UNSPECIFIED
}

func (x *OrganizationEvent) GetDetailedState() OrganizationEvent_DetailedState {
	if x != nil {
		return x.DetailedState
	}
	return OrganizationEvent_DETAILED_STATE_UNSPECIFIED
}

func (x *OrganizationEvent) GetEventImpacts() []*EventImpact {
	if x != nil {
		return x.EventImpacts
	}
	return nil
}

func (x *OrganizationEvent) GetUpdates() []*EventUpdate {
	if x != nil {
		return x.Updates
	}
	return nil
}

func (x *OrganizationEvent) GetParentEvent() string {
	if x != nil {
		return x.ParentEvent
	}
	return ""
}

func (x *OrganizationEvent) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *OrganizationEvent) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *OrganizationEvent) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OrganizationEvent) GetNextUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextUpdateTime
	}
	return nil
}

// Records an update made to the event.
type EventUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the update was posted.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Brief title for the event.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Output only. Free-form, human-readable description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Symptoms of the event, if available.
	Symptom string `protobuf:"bytes,4,opt,name=symptom,proto3" json:"symptom,omitempty"`
	// Output only. Workaround steps to remediate the event impact, if available.
	Workaround string `protobuf:"bytes,5,opt,name=workaround,proto3" json:"workaround,omitempty"`
}

func (x *EventUpdate) Reset() {
	*x = EventUpdate{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventUpdate) ProtoMessage() {}

func (x *EventUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventUpdate.ProtoReflect.Descriptor instead.
func (*EventUpdate) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{2}
}

func (x *EventUpdate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EventUpdate) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *EventUpdate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EventUpdate) GetSymptom() string {
	if x != nil {
		return x.Symptom
	}
	return ""
}

func (x *EventUpdate) GetWorkaround() string {
	if x != nil {
		return x.Workaround
	}
	return ""
}

// Represents the locations impacted by the event.
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location impacted by the event. Example: `"us-central1"`
	LocationName string `protobuf:"bytes,1,opt,name=location_name,json=locationName,proto3" json:"location_name,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Location) GetLocationName() string {
	if x != nil {
		return x.LocationName
	}
	return ""
}

// Represents the Google Cloud product impacted by the event.
type Product struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud product impacted by the event. Example: `"Google Cloud SQL"`
	ProductName string `protobuf:"bytes,1,opt,name=product_name,json=productName,proto3" json:"product_name,omitempty"`
	// Unique identifier for the product.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Product) Reset() {
	*x = Product{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Product) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Product) ProtoMessage() {}

func (x *Product) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Product.ProtoReflect.Descriptor instead.
func (*Product) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Product) GetProductName() string {
	if x != nil {
		return x.ProductName
	}
	return ""
}

func (x *Product) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Represents the Google Cloud products and locations impacted by the event.
type EventImpact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud product impacted by the event.
	Product *Product `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// Location impacted by the event.
	Location *Location `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *EventImpact) Reset() {
	*x = EventImpact{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventImpact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventImpact) ProtoMessage() {}

func (x *EventImpact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventImpact.ProtoReflect.Descriptor instead.
func (*EventImpact) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{5}
}

func (x *EventImpact) GetProduct() *Product {
	if x != nil {
		return x.Product
	}
	return nil
}

func (x *EventImpact) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

// Represents impact to assets at organizational level. It is a read-only view
// and does not allow any modifications.
type OrganizationImpact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. Unique name of the organization impact in this
	// scope including organization and location using the form
	// `organizations/{organization_id}/locations/{location}/organizationImpacts/{organization_impact_id}`.
	//
	// `organization_id` - ID (number) of the organization that contains the
	// event. To get your `organization_id`, see
	// [Getting your organization resource
	// ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
	// `organization_impact_id` - ID of the [OrganizationImpact
	// resource](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. A list of event names impacting the asset.
	Events []string `protobuf:"bytes,2,rep,name=events,proto3" json:"events,omitempty"`
	// Output only. Google Cloud asset possibly impacted by the specified events.
	Asset *Asset `protobuf:"bytes,3,opt,name=asset,proto3" json:"asset,omitempty"`
	// Output only. The time when the affected project was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *OrganizationImpact) Reset() {
	*x = OrganizationImpact{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OrganizationImpact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrganizationImpact) ProtoMessage() {}

func (x *OrganizationImpact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrganizationImpact.ProtoReflect.Descriptor instead.
func (*OrganizationImpact) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{6}
}

func (x *OrganizationImpact) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OrganizationImpact) GetEvents() []string {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *OrganizationImpact) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *OrganizationImpact) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Represents the asset impacted by the events.
type Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Full name of the resource as defined in
	// [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name).
	AssetName string `protobuf:"bytes,1,opt,name=asset_name,json=assetName,proto3" json:"asset_name,omitempty"`
	// Output only. Type of the asset. Example:
	// `"cloudresourcemanager.googleapis.com/Project"`
	AssetType string `protobuf:"bytes,2,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
}

func (x *Asset) Reset() {
	*x = Asset{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset) ProtoMessage() {}

func (x *Asset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset.ProtoReflect.Descriptor instead.
func (*Asset) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{7}
}

func (x *Asset) GetAssetName() string {
	if x != nil {
		return x.AssetName
	}
	return ""
}

func (x *Asset) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

// Requests list of events.
type ListEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value using the form
	// `projects/{project_id}/locations/{location}/events`.
	//
	// `project_id` - ID of the project for which to list service health
	// events.
	// `location` - The location to get the service health events from.
	// To retrieve service health events of category = INCIDENT, use `location` =
	// `global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of events that should be returned.  Acceptable
	// values are 1 to 100, inclusive. (The default value is 10.) If more results
	// are available, the service returns a next_page_token that you can use to
	// get the next page of results in subsequent list requests. The service may
	// return fewer events than the requested page_size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	// Provide Page token returned by a previous `ListEvents` call to retrieve the
	// next page of results. When paginating, all other parameters provided to
	// `ListEvents` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter expression that filters resources listed in the
	// response. The expression takes the following forms: <br>
	// *   field=value for `category` and `state`<br>
	// *   field &lt;, >, &lt;=, or >= value for `update_time` <br>
	// Examples: `category=INCIDENT`, `update_time>="2000-01-01T11:30:00-04:00"`,
	// `event_impacts.product.product_name:"Eventarc"`
	// <br>
	//
	// Multiple filter queries are separated by spaces. Example:
	// `category=INCIDENT state=ACTIVE`.
	//
	// By default, each expression is an AND expression. However, you can include
	// AND and OR expressions explicitly.
	//
	// Filter is supported for the following fields: `category`, `state`,
	// `update_time`, `event_impacts.product.product_name`
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Event fields to include in response.
	View EventView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.servicehealth.v1.EventView" json:"view,omitempty"`
}

func (x *ListEventsRequest) Reset() {
	*x = ListEventsRequest{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventsRequest) ProtoMessage() {}

func (x *ListEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventsRequest.ProtoReflect.Descriptor instead.
func (*ListEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{8}
}

func (x *ListEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEventsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEventsRequest) GetView() EventView {
	if x != nil {
		return x.View
	}
	return EventView_EVENT_VIEW_UNSPECIFIED
}

// Response to request for listing events.
type ListEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of events.
	Events []*Event `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	// Output only. The continuation token, used to page through large result
	// sets. Provide this value in a subsequent request as page_token to retrieve
	// the next page.
	//
	// If this field is not present, there are no subsequent results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListEventsResponse) Reset() {
	*x = ListEventsResponse{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventsResponse) ProtoMessage() {}

func (x *ListEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventsResponse.ProtoReflect.Descriptor instead.
func (*ListEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{9}
}

func (x *ListEventsResponse) GetEvents() []*Event {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *ListEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEventsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Gets information about a specific event.
type GetEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique name of the event in this scope including project
	// and location using the form
	// `projects/{project_id}/locations/{location}/events/{event_id}`.
	//
	// `project_id` - Project ID of the project that contains the event. <br>
	// `location` - The location to get the service health events from. <br>
	// `event_id` - Event ID to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEventRequest) Reset() {
	*x = GetEventRequest{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEventRequest) ProtoMessage() {}

func (x *GetEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEventRequest.ProtoReflect.Descriptor instead.
func (*GetEventRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{10}
}

func (x *GetEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Requests list of events that affect an organization.
type ListOrganizationEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value using the form
	// `organizations/{organization_id}/locations/{location}/organizationEvents`.
	//
	// `organization_id` - ID (number) of the project that contains the event. To
	// get your `organization_id`, see
	// [Getting your organization resource
	// ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
	// `location` - The location to get the service health events from. To
	// retrieve service health events of category = INCIDENT, use `location` =
	// `global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of events that should be returned.  Acceptable
	// values are `1` to `100`, inclusive. (The default value is `10`.) If more
	// results are available, the service returns a `next_page_token` that you can
	// use to get the next page of results in subsequent list requests. The
	// service may return fewer events than the requested `page_size`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	//
	// Provide Page token returned by a previous `ListOrganizationEvents` call to
	// retrieve the next page of results.
	//
	// When paginating, all other parameters provided to
	// `ListOrganizationEvents` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter expression that filters resources listed in the
	// response. The expression takes the following forms:
	//
	// *   field=value for `category` and `state`
	// *   field &lt;, >, &lt;=, or >= value for `update_time`
	//
	// Examples: `category=INCIDENT`, `update_time>="2000-01-01T11:30:00-04:00"`
	//
	// Multiple filter queries are space-separated. Example:
	// `category=INCIDENT state=ACTIVE`.
	//
	// By default, each expression is an AND expression. However, you can include
	// AND and OR expressions explicitly.
	//
	// Filter is supported for the following fields: `category`, `state`,
	// `update_time`
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. OrganizationEvent fields to include in response.
	View OrganizationEventView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.servicehealth.v1.OrganizationEventView" json:"view,omitempty"`
}

func (x *ListOrganizationEventsRequest) Reset() {
	*x = ListOrganizationEventsRequest{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationEventsRequest) ProtoMessage() {}

func (x *ListOrganizationEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrganizationEventsRequest.ProtoReflect.Descriptor instead.
func (*ListOrganizationEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{11}
}

func (x *ListOrganizationEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOrganizationEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOrganizationEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListOrganizationEventsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListOrganizationEventsRequest) GetView() OrganizationEventView {
	if x != nil {
		return x.View
	}
	return OrganizationEventView_ORGANIZATION_EVENT_VIEW_UNSPECIFIED
}

// Response to request for listing organization events.
type ListOrganizationEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of organization events affecting an organization.
	OrganizationEvents []*OrganizationEvent `protobuf:"bytes,1,rep,name=organization_events,json=organizationEvents,proto3" json:"organization_events,omitempty"`
	// Output only. The continuation token, used to page through large result
	// sets. Provide this value in a subsequent request as `page_token` to
	// retrieve the next page.
	//
	// If this field is not present, there are no subsequent results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListOrganizationEventsResponse) Reset() {
	*x = ListOrganizationEventsResponse{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationEventsResponse) ProtoMessage() {}

func (x *ListOrganizationEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrganizationEventsResponse.ProtoReflect.Descriptor instead.
func (*ListOrganizationEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{12}
}

func (x *ListOrganizationEventsResponse) GetOrganizationEvents() []*OrganizationEvent {
	if x != nil {
		return x.OrganizationEvents
	}
	return nil
}

func (x *ListOrganizationEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListOrganizationEventsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Gets information about a specific event affecting an organization.
type GetOrganizationEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique name of the event in this scope including organization and
	// event ID using the form
	// `organizations/{organization_id}/locations/locations/global/organizationEvents/{event_id}`.
	//
	// `organization_id` - ID (number) of the project that contains the event. To
	// get your `organization_id`, see
	// [Getting your organization resource
	// ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
	// `event_id` - Organization event ID to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOrganizationEventRequest) Reset() {
	*x = GetOrganizationEventRequest{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationEventRequest) ProtoMessage() {}

func (x *GetOrganizationEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOrganizationEventRequest.ProtoReflect.Descriptor instead.
func (*GetOrganizationEventRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{13}
}

func (x *GetOrganizationEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Requests list of projects under an organization affected by an event.
type ListOrganizationImpactsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value using the form
	// `organizations/{organization_id}/locations/{location}/organizationImpacts`.
	//
	// `organization_id` - ID (number) of the project that contains the event. To
	// get your `organization_id`, see
	// [Getting your organization resource
	// ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of events that should be returned. Acceptable
	// values are `1` to `100`, inclusive. The default value is `10`.
	//
	//	If more results are available, the service returns a
	//
	// `next_page_token` that can be used to get the next page of results in
	// subsequent list requests. The service may return fewer
	// [impacts](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact)
	// than the requested `page_size`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	//
	// Provide `page_token` returned by a previous `ListOrganizationImpacts` call
	// to retrieve the next page of results.
	//
	// When paginating, all other parameters provided to `ListOrganizationImpacts`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter expression that filters resources listed in the
	// response. The expression is in the form of `field:value` for checking if a
	// repeated field contains a value.
	//
	// Example:
	// `events:organizations%2F{organization_id}%2Flocations%2Fglobal%2ForganizationEvents%2Fevent-id`
	//
	// To get your `{organization_id}`, see
	// [Getting your organization resource
	// ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
	//
	// Multiple filter queries are separated by spaces.
	//
	// By default, each expression is an AND expression. However, you can include
	// AND and OR expressions explicitly.
	// Filter is supported for the following fields: `events`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListOrganizationImpactsRequest) Reset() {
	*x = ListOrganizationImpactsRequest{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationImpactsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationImpactsRequest) ProtoMessage() {}

func (x *ListOrganizationImpactsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrganizationImpactsRequest.ProtoReflect.Descriptor instead.
func (*ListOrganizationImpactsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{14}
}

func (x *ListOrganizationImpactsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOrganizationImpactsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOrganizationImpactsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListOrganizationImpactsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response to request for listing projects under an organization affected by an
// event.
type ListOrganizationImpactsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of
	// [impacts](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact)
	// for an organization affected by service health events.
	OrganizationImpacts []*OrganizationImpact `protobuf:"bytes,1,rep,name=organization_impacts,json=organizationImpacts,proto3" json:"organization_impacts,omitempty"`
	// Output only. The continuation token, used to page through large result
	// sets. Provide this value in a subsequent request as `page_token` to
	// retrieve the next page.
	//
	// If this field is not present, there are no subsequent results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListOrganizationImpactsResponse) Reset() {
	*x = ListOrganizationImpactsResponse{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationImpactsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationImpactsResponse) ProtoMessage() {}

func (x *ListOrganizationImpactsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrganizationImpactsResponse.ProtoReflect.Descriptor instead.
func (*ListOrganizationImpactsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{15}
}

func (x *ListOrganizationImpactsResponse) GetOrganizationImpacts() []*OrganizationImpact {
	if x != nil {
		return x.OrganizationImpacts
	}
	return nil
}

func (x *ListOrganizationImpactsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListOrganizationImpactsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Gets information about an event that affects a project under an organization.
type GetOrganizationImpactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource using the form
	// `organizations/{organization_id}/locations/global/organizationImpacts/{organization_impact_id}`.
	//
	// `organization_id` - ID (number) of the organization that contains the
	// event. To get your `organization_id`, see
	// [Getting your organization resource
	// ID](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).<br>
	// `organization_impact_id` - ID of the [OrganizationImpact
	// resource](/service-health/docs/reference/rest/v1beta/organizations.locations.organizationImpacts#OrganizationImpact).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOrganizationImpactRequest) Reset() {
	*x = GetOrganizationImpactRequest{}
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationImpactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationImpactRequest) ProtoMessage() {}

func (x *GetOrganizationImpactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOrganizationImpactRequest.ProtoReflect.Descriptor instead.
func (*GetOrganizationImpactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP(), []int{16}
}

func (x *GetOrganizationImpactRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_servicehealth_v1_event_resources_proto protoreflect.FileDescriptor

var file_google_cloud_servicehealth_v1_event_resources_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2f, 0x76, 0x31, 0x2f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xbe, 0x0c, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x08, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x67,
	0x0a, 0x11, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5e,
	0x0a, 0x0e, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4f,
	0x0a, 0x0d, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x18,
	0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x61, 0x63,
	0x74, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x12,
	0x51, 0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x49, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x6e, 0x65, 0x78, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x3d,
	0x0a, 0x0d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12,
	0x1e, 0x0a, 0x1a, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x43, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x22, 0x64, 0x0a,
	0x10, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x12, 0x21, 0x0a, 0x1d, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x43, 0x41,
	0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45,
	0x44, 0x5f, 0x49, 0x4e, 0x43, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11,
	0x45, 0x4d, 0x45, 0x52, 0x47, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x43, 0x49, 0x44, 0x45, 0x4e,
	0x54, 0x10, 0x02, 0x22, 0x36, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x02, 0x22, 0x8b, 0x01, 0x0a, 0x0d,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a,
	0x1a, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x45, 0x4d, 0x45, 0x52, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45,
	0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x52, 0x47,
	0x45, 0x44, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x43, 0x4c, 0x4f,
	0x53, 0x45, 0x44, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x41, 0x4c, 0x53, 0x45, 0x5f, 0x50,
	0x4f, 0x53, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0x0a, 0x22, 0x77, 0x0a, 0x09, 0x52, 0x65, 0x6c,
	0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x4c, 0x45, 0x56, 0x41,
	0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x02, 0x12, 0x10,
	0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x45, 0x44, 0x10, 0x06,
	0x12, 0x15, 0x0a, 0x11, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x52, 0x45,
	0x4c, 0x41, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4c, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x45, 0x44,
	0x10, 0x09, 0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x22, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x7d, 0x2a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x32, 0x05, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x22, 0xef, 0x0b, 0x0a, 0x11, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x73, 0x0a, 0x11, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x51, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x6a, 0x0a, 0x0e, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x18, 0x0f, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x73, 0x12, 0x49, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0c,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6e,
	0x65, 0x78, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x3d, 0x0a,
	0x0d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x1e,
	0x0a, 0x1a, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x49, 0x4e, 0x43, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x22, 0x64, 0x0a, 0x10,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x12, 0x21, 0x0a, 0x1d, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x43, 0x41, 0x54,
	0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44,
	0x5f, 0x49, 0x4e, 0x43, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x45,
	0x4d, 0x45, 0x52, 0x47, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x43, 0x49, 0x44, 0x45, 0x4e, 0x54,
	0x10, 0x02, 0x22, 0x36, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x02, 0x22, 0x8b, 0x01, 0x0a, 0x0d, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x1a,
	0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x45, 0x4d, 0x45, 0x52, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f,
	0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53,
	0x4f, 0x4c, 0x56, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x52, 0x47, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x43, 0x4c, 0x4f, 0x53,
	0x45, 0x44, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x41, 0x4c, 0x53, 0x45, 0x5f, 0x50, 0x4f,
	0x53, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0x0a, 0x3a, 0xa9, 0x01, 0xea, 0x41, 0xa5, 0x01, 0x0a,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x4c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x7d, 0x2a, 0x12, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x32, 0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x22, 0xd5, 0x01, 0x0a, 0x0b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x79, 0x6d, 0x70,
	0x74, 0x6f, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x73, 0x79, 0x6d, 0x70, 0x74, 0x6f, 0x6d, 0x12, 0x23, 0x0a, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x61,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0x2f, 0x0a, 0x08,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x3c, 0x0a,
	0x07, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x94, 0x01, 0x0a, 0x0b,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x43, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb5, 0x03, 0x0a, 0x12, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x05, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0xbb, 0x01, 0xea,
	0x41, 0xb7, 0x01, 0x0a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d,
	0x70, 0x61, 0x63, 0x74, 0x12, 0x5b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x7d, 0x2a, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x32, 0x12, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x22, 0x4f, 0x0a, 0x05, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0xfd, 0x01, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xab, 0x01, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x51, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa1, 0x02, 0x0a,
	0x1d, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x4d, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x22, 0xdc, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x69, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x1e, 0x4c,
	0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0xe0, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x14, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x73,
	0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x6b, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x2a, 0x52, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1a,
	0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46,
	0x55, 0x4c, 0x4c, 0x10, 0x02, 0x2a, 0x85, 0x01, 0x0a, 0x15, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x27, 0x0a, 0x23, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x4f, 0x52, 0x47, 0x41,
	0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x56,
	0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x4f,
	0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x42, 0xcf, 0x02,
	0xea, 0x41, 0x66, 0x0a, 0x31, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_servicehealth_v1_event_resources_proto_rawDescOnce sync.Once
	file_google_cloud_servicehealth_v1_event_resources_proto_rawDescData = file_google_cloud_servicehealth_v1_event_resources_proto_rawDesc
)

func file_google_cloud_servicehealth_v1_event_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_servicehealth_v1_event_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_servicehealth_v1_event_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_servicehealth_v1_event_resources_proto_rawDescData)
	})
	return file_google_cloud_servicehealth_v1_event_resources_proto_rawDescData
}

var file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_servicehealth_v1_event_resources_proto_goTypes = []any{
	(EventView)(0),                          // 0: google.cloud.servicehealth.v1.EventView
	(OrganizationEventView)(0),              // 1: google.cloud.servicehealth.v1.OrganizationEventView
	(Event_EventCategory)(0),                // 2: google.cloud.servicehealth.v1.Event.EventCategory
	(Event_DetailedCategory)(0),             // 3: google.cloud.servicehealth.v1.Event.DetailedCategory
	(Event_State)(0),                        // 4: google.cloud.servicehealth.v1.Event.State
	(Event_DetailedState)(0),                // 5: google.cloud.servicehealth.v1.Event.DetailedState
	(Event_Relevance)(0),                    // 6: google.cloud.servicehealth.v1.Event.Relevance
	(OrganizationEvent_EventCategory)(0),    // 7: google.cloud.servicehealth.v1.OrganizationEvent.EventCategory
	(OrganizationEvent_DetailedCategory)(0), // 8: google.cloud.servicehealth.v1.OrganizationEvent.DetailedCategory
	(OrganizationEvent_State)(0),            // 9: google.cloud.servicehealth.v1.OrganizationEvent.State
	(OrganizationEvent_DetailedState)(0),    // 10: google.cloud.servicehealth.v1.OrganizationEvent.DetailedState
	(*Event)(nil),                           // 11: google.cloud.servicehealth.v1.Event
	(*OrganizationEvent)(nil),               // 12: google.cloud.servicehealth.v1.OrganizationEvent
	(*EventUpdate)(nil),                     // 13: google.cloud.servicehealth.v1.EventUpdate
	(*Location)(nil),                        // 14: google.cloud.servicehealth.v1.Location
	(*Product)(nil),                         // 15: google.cloud.servicehealth.v1.Product
	(*EventImpact)(nil),                     // 16: google.cloud.servicehealth.v1.EventImpact
	(*OrganizationImpact)(nil),              // 17: google.cloud.servicehealth.v1.OrganizationImpact
	(*Asset)(nil),                           // 18: google.cloud.servicehealth.v1.Asset
	(*ListEventsRequest)(nil),               // 19: google.cloud.servicehealth.v1.ListEventsRequest
	(*ListEventsResponse)(nil),              // 20: google.cloud.servicehealth.v1.ListEventsResponse
	(*GetEventRequest)(nil),                 // 21: google.cloud.servicehealth.v1.GetEventRequest
	(*ListOrganizationEventsRequest)(nil),   // 22: google.cloud.servicehealth.v1.ListOrganizationEventsRequest
	(*ListOrganizationEventsResponse)(nil),  // 23: google.cloud.servicehealth.v1.ListOrganizationEventsResponse
	(*GetOrganizationEventRequest)(nil),     // 24: google.cloud.servicehealth.v1.GetOrganizationEventRequest
	(*ListOrganizationImpactsRequest)(nil),  // 25: google.cloud.servicehealth.v1.ListOrganizationImpactsRequest
	(*ListOrganizationImpactsResponse)(nil), // 26: google.cloud.servicehealth.v1.ListOrganizationImpactsResponse
	(*GetOrganizationImpactRequest)(nil),    // 27: google.cloud.servicehealth.v1.GetOrganizationImpactRequest
	(*timestamppb.Timestamp)(nil),           // 28: google.protobuf.Timestamp
}
var file_google_cloud_servicehealth_v1_event_resources_proto_depIdxs = []int32{
	2,  // 0: google.cloud.servicehealth.v1.Event.category:type_name -> google.cloud.servicehealth.v1.Event.EventCategory
	3,  // 1: google.cloud.servicehealth.v1.Event.detailed_category:type_name -> google.cloud.servicehealth.v1.Event.DetailedCategory
	4,  // 2: google.cloud.servicehealth.v1.Event.state:type_name -> google.cloud.servicehealth.v1.Event.State
	5,  // 3: google.cloud.servicehealth.v1.Event.detailed_state:type_name -> google.cloud.servicehealth.v1.Event.DetailedState
	16, // 4: google.cloud.servicehealth.v1.Event.event_impacts:type_name -> google.cloud.servicehealth.v1.EventImpact
	6,  // 5: google.cloud.servicehealth.v1.Event.relevance:type_name -> google.cloud.servicehealth.v1.Event.Relevance
	13, // 6: google.cloud.servicehealth.v1.Event.updates:type_name -> google.cloud.servicehealth.v1.EventUpdate
	28, // 7: google.cloud.servicehealth.v1.Event.update_time:type_name -> google.protobuf.Timestamp
	28, // 8: google.cloud.servicehealth.v1.Event.start_time:type_name -> google.protobuf.Timestamp
	28, // 9: google.cloud.servicehealth.v1.Event.end_time:type_name -> google.protobuf.Timestamp
	28, // 10: google.cloud.servicehealth.v1.Event.next_update_time:type_name -> google.protobuf.Timestamp
	7,  // 11: google.cloud.servicehealth.v1.OrganizationEvent.category:type_name -> google.cloud.servicehealth.v1.OrganizationEvent.EventCategory
	8,  // 12: google.cloud.servicehealth.v1.OrganizationEvent.detailed_category:type_name -> google.cloud.servicehealth.v1.OrganizationEvent.DetailedCategory
	9,  // 13: google.cloud.servicehealth.v1.OrganizationEvent.state:type_name -> google.cloud.servicehealth.v1.OrganizationEvent.State
	10, // 14: google.cloud.servicehealth.v1.OrganizationEvent.detailed_state:type_name -> google.cloud.servicehealth.v1.OrganizationEvent.DetailedState
	16, // 15: google.cloud.servicehealth.v1.OrganizationEvent.event_impacts:type_name -> google.cloud.servicehealth.v1.EventImpact
	13, // 16: google.cloud.servicehealth.v1.OrganizationEvent.updates:type_name -> google.cloud.servicehealth.v1.EventUpdate
	28, // 17: google.cloud.servicehealth.v1.OrganizationEvent.update_time:type_name -> google.protobuf.Timestamp
	28, // 18: google.cloud.servicehealth.v1.OrganizationEvent.start_time:type_name -> google.protobuf.Timestamp
	28, // 19: google.cloud.servicehealth.v1.OrganizationEvent.end_time:type_name -> google.protobuf.Timestamp
	28, // 20: google.cloud.servicehealth.v1.OrganizationEvent.next_update_time:type_name -> google.protobuf.Timestamp
	28, // 21: google.cloud.servicehealth.v1.EventUpdate.update_time:type_name -> google.protobuf.Timestamp
	15, // 22: google.cloud.servicehealth.v1.EventImpact.product:type_name -> google.cloud.servicehealth.v1.Product
	14, // 23: google.cloud.servicehealth.v1.EventImpact.location:type_name -> google.cloud.servicehealth.v1.Location
	18, // 24: google.cloud.servicehealth.v1.OrganizationImpact.asset:type_name -> google.cloud.servicehealth.v1.Asset
	28, // 25: google.cloud.servicehealth.v1.OrganizationImpact.update_time:type_name -> google.protobuf.Timestamp
	0,  // 26: google.cloud.servicehealth.v1.ListEventsRequest.view:type_name -> google.cloud.servicehealth.v1.EventView
	11, // 27: google.cloud.servicehealth.v1.ListEventsResponse.events:type_name -> google.cloud.servicehealth.v1.Event
	1,  // 28: google.cloud.servicehealth.v1.ListOrganizationEventsRequest.view:type_name -> google.cloud.servicehealth.v1.OrganizationEventView
	12, // 29: google.cloud.servicehealth.v1.ListOrganizationEventsResponse.organization_events:type_name -> google.cloud.servicehealth.v1.OrganizationEvent
	17, // 30: google.cloud.servicehealth.v1.ListOrganizationImpactsResponse.organization_impacts:type_name -> google.cloud.servicehealth.v1.OrganizationImpact
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_google_cloud_servicehealth_v1_event_resources_proto_init() }
func file_google_cloud_servicehealth_v1_event_resources_proto_init() {
	if File_google_cloud_servicehealth_v1_event_resources_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_servicehealth_v1_event_resources_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_servicehealth_v1_event_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_servicehealth_v1_event_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_servicehealth_v1_event_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_servicehealth_v1_event_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_servicehealth_v1_event_resources_proto = out.File
	file_google_cloud_servicehealth_v1_event_resources_proto_rawDesc = nil
	file_google_cloud_servicehealth_v1_event_resources_proto_goTypes = nil
	file_google_cloud_servicehealth_v1_event_resources_proto_depIdxs = nil
}
