// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/api/servicecontrol/v1/quota_controller.proto

package servicecontrolpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported quota modes.
type QuotaOperation_QuotaMode int32

const (
	// Guard against implicit default. Must not be used.
	QuotaOperation_UNSPECIFIED QuotaOperation_QuotaMode = 0
	// For AllocateQuota request, allocates quota for the amount specified in
	// the service configuration or specified using the quota metrics. If the
	// amount is higher than the available quota, allocation error will be
	// returned and no quota will be allocated.
	// If multiple quotas are part of the request, and one fails, none of the
	// quotas are allocated or released.
	QuotaOperation_NORMAL QuotaOperation_QuotaMode = 1
	// The operation allocates quota for the amount specified in the service
	// configuration or specified using the quota metrics. If the amount is
	// higher than the available quota, request does not fail but all available
	// quota will be allocated.
	// For rate quota, BEST_EFFORT will continue to deduct from other groups
	// even if one does not have enough quota. For allocation, it will find the
	// minimum available amount across all groups and deduct that amount from
	// all the affected groups.
	QuotaOperation_BEST_EFFORT QuotaOperation_QuotaMode = 2
	// For AllocateQuota request, only checks if there is enough quota
	// available and does not change the available quota. No lock is placed on
	// the available quota either.
	QuotaOperation_CHECK_ONLY QuotaOperation_QuotaMode = 3
	// Unimplemented. When used in AllocateQuotaRequest, this returns the
	// effective quota limit(s) in the response, and no quota check will be
	// performed. Not supported for other requests, and even for
	// AllocateQuotaRequest, this is currently supported only for allowlisted
	// services.
	QuotaOperation_QUERY_ONLY QuotaOperation_QuotaMode = 4
	// The operation allocates quota for the amount specified in the service
	// configuration or specified using the quota metrics. If the requested
	// amount is higher than the available quota, request does not fail and
	// remaining quota would become negative (going over the limit).
	// Not supported for Rate Quota.
	QuotaOperation_ADJUST_ONLY QuotaOperation_QuotaMode = 5
)

// Enum value maps for QuotaOperation_QuotaMode.
var (
	QuotaOperation_QuotaMode_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "NORMAL",
		2: "BEST_EFFORT",
		3: "CHECK_ONLY",
		4: "QUERY_ONLY",
		5: "ADJUST_ONLY",
	}
	QuotaOperation_QuotaMode_value = map[string]int32{
		"UNSPECIFIED": 0,
		"NORMAL":      1,
		"BEST_EFFORT": 2,
		"CHECK_ONLY":  3,
		"QUERY_ONLY":  4,
		"ADJUST_ONLY": 5,
	}
)

func (x QuotaOperation_QuotaMode) Enum() *QuotaOperation_QuotaMode {
	p := new(QuotaOperation_QuotaMode)
	*p = x
	return p
}

func (x QuotaOperation_QuotaMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaOperation_QuotaMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_servicecontrol_v1_quota_controller_proto_enumTypes[0].Descriptor()
}

func (QuotaOperation_QuotaMode) Type() protoreflect.EnumType {
	return &file_google_api_servicecontrol_v1_quota_controller_proto_enumTypes[0]
}

func (x QuotaOperation_QuotaMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaOperation_QuotaMode.Descriptor instead.
func (QuotaOperation_QuotaMode) EnumDescriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_quota_controller_proto_rawDescGZIP(), []int{1, 0}
}

// Error codes related to project config validations are deprecated since the
// quota controller methods do not perform these validations. Instead services
// have to call the Check method, without quota_properties field, to perform
// these validations before calling the quota controller methods. These
// methods check only for project deletion to be wipe out compliant.
type QuotaError_Code int32

const (
	// This is never used.
	QuotaError_UNSPECIFIED QuotaError_Code = 0
	// Quota allocation failed.
	// Same as [google.rpc.Code.RESOURCE_EXHAUSTED][google.rpc.Code.RESOURCE_EXHAUSTED].
	QuotaError_RESOURCE_EXHAUSTED QuotaError_Code = 8
	// Consumer cannot access the service because the service requires active
	// billing.
	QuotaError_BILLING_NOT_ACTIVE QuotaError_Code = 107
	// Consumer's project has been marked as deleted (soft deletion).
	QuotaError_PROJECT_DELETED QuotaError_Code = 108
	// Specified API key is invalid.
	QuotaError_API_KEY_INVALID QuotaError_Code = 105
	// Specified API Key has expired.
	QuotaError_API_KEY_EXPIRED QuotaError_Code = 112
)

// Enum value maps for QuotaError_Code.
var (
	QuotaError_Code_name = map[int32]string{
		0:   "UNSPECIFIED",
		8:   "RESOURCE_EXHAUSTED",
		107: "BILLING_NOT_ACTIVE",
		108: "PROJECT_DELETED",
		105: "API_KEY_INVALID",
		112: "API_KEY_EXPIRED",
	}
	QuotaError_Code_value = map[string]int32{
		"UNSPECIFIED":        0,
		"RESOURCE_EXHAUSTED": 8,
		"BILLING_NOT_ACTIVE": 107,
		"PROJECT_DELETED":    108,
		"API_KEY_INVALID":    105,
		"API_KEY_EXPIRED":    112,
	}
)

func (x QuotaError_Code) Enum() *QuotaError_Code {
	p := new(QuotaError_Code)
	*p = x
	return p
}

func (x QuotaError_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaError_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_servicecontrol_v1_quota_controller_proto_enumTypes[1].Descriptor()
}

func (QuotaError_Code) Type() protoreflect.EnumType {
	return &file_google_api_servicecontrol_v1_quota_controller_proto_enumTypes[1]
}

func (x QuotaError_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaError_Code.Descriptor instead.
func (QuotaError_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_quota_controller_proto_rawDescGZIP(), []int{3, 0}
}

// Request message for the AllocateQuota method.
type AllocateQuotaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the service as specified in the service configuration. For example,
	// `"pubsub.googleapis.com"`.
	//
	// See [google.api.Service][google.api.Service] for the definition of a service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// Operation that describes the quota allocation.
	AllocateOperation *QuotaOperation `protobuf:"bytes,2,opt,name=allocate_operation,json=allocateOperation,proto3" json:"allocate_operation,omitempty"`
	// Specifies which version of service configuration should be used to process
	// the request. If unspecified or no matching version can be found, the latest
	// one will be used.
	ServiceConfigId string `protobuf:"bytes,4,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
}

func (x *AllocateQuotaRequest) Reset() {
	*x = AllocateQuotaRequest{}
	mi := &file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocateQuotaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocateQuotaRequest) ProtoMessage() {}

func (x *AllocateQuotaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocateQuotaRequest.ProtoReflect.Descriptor instead.
func (*AllocateQuotaRequest) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_quota_controller_proto_rawDescGZIP(), []int{0}
}

func (x *AllocateQuotaRequest) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *AllocateQuotaRequest) GetAllocateOperation() *QuotaOperation {
	if x != nil {
		return x.AllocateOperation
	}
	return nil
}

func (x *AllocateQuotaRequest) GetServiceConfigId() string {
	if x != nil {
		return x.ServiceConfigId
	}
	return ""
}

// Represents information regarding a quota operation.
type QuotaOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identity of the operation. This is expected to be unique within the scope
	// of the service that generated the operation, and guarantees idempotency in
	// case of retries.
	//
	// In order to ensure best performance and latency in the Quota backends,
	// operation_ids are optimally associated with time, so that related
	// operations can be accessed fast in storage. For this reason, the
	// recommended token for services that intend to operate at a high QPS is
	// Unix time in nanos + UUID
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// Fully qualified name of the API method for which this quota operation is
	// requested. This name is used for matching quota rules or metric rules and
	// billing status rules defined in service configuration.
	//
	// This field should not be set if any of the following is true:
	// (1) the quota operation is performed on non-API resources.
	// (2) quota_metrics is set because the caller is doing quota override.
	//
	// Example of an RPC method name:
	//
	//	google.example.library.v1.LibraryService.CreateShelf
	MethodName string `protobuf:"bytes,2,opt,name=method_name,json=methodName,proto3" json:"method_name,omitempty"`
	// Identity of the consumer for whom this quota operation is being performed.
	//
	// This can be in one of the following formats:
	//
	//	project:<project_id>,
	//	project_number:<project_number>,
	//	api_key:<api_key>.
	ConsumerId string `protobuf:"bytes,3,opt,name=consumer_id,json=consumerId,proto3" json:"consumer_id,omitempty"`
	// Labels describing the operation.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Represents information about this operation. Each MetricValueSet
	// corresponds to a metric defined in the service configuration.
	// The data type used in the MetricValueSet must agree with
	// the data type specified in the metric definition.
	//
	// Within a single operation, it is not allowed to have more than one
	// MetricValue instances that have the same metric names and identical
	// label value combinations. If a request has such duplicated MetricValue
	// instances, the entire request is rejected with
	// an invalid argument error.
	//
	// This field is mutually exclusive with method_name.
	QuotaMetrics []*MetricValueSet `protobuf:"bytes,5,rep,name=quota_metrics,json=quotaMetrics,proto3" json:"quota_metrics,omitempty"`
	// Quota mode for this operation.
	QuotaMode QuotaOperation_QuotaMode `protobuf:"varint,6,opt,name=quota_mode,json=quotaMode,proto3,enum=google.api.servicecontrol.v1.QuotaOperation_QuotaMode" json:"quota_mode,omitempty"`
}

func (x *QuotaOperation) Reset() {
	*x = QuotaOperation{}
	mi := &file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuotaOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaOperation) ProtoMessage() {}

func (x *QuotaOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaOperation.ProtoReflect.Descriptor instead.
func (*QuotaOperation) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_quota_controller_proto_rawDescGZIP(), []int{1}
}

func (x *QuotaOperation) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *QuotaOperation) GetMethodName() string {
	if x != nil {
		return x.MethodName
	}
	return ""
}

func (x *QuotaOperation) GetConsumerId() string {
	if x != nil {
		return x.ConsumerId
	}
	return ""
}

func (x *QuotaOperation) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *QuotaOperation) GetQuotaMetrics() []*MetricValueSet {
	if x != nil {
		return x.QuotaMetrics
	}
	return nil
}

func (x *QuotaOperation) GetQuotaMode() QuotaOperation_QuotaMode {
	if x != nil {
		return x.QuotaMode
	}
	return QuotaOperation_UNSPECIFIED
}

// Response message for the AllocateQuota method.
type AllocateQuotaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The same operation_id value used in the AllocateQuotaRequest. Used for
	// logging and diagnostics purposes.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// Indicates the decision of the allocate.
	AllocateErrors []*QuotaError `protobuf:"bytes,2,rep,name=allocate_errors,json=allocateErrors,proto3" json:"allocate_errors,omitempty"`
	// Quota metrics to indicate the result of allocation. Depending on the
	// request, one or more of the following metrics will be included:
	//
	// 1. Per quota group or per quota metric incremental usage will be specified
	// using the following delta metric :
	//
	//	"serviceruntime.googleapis.com/api/consumer/quota_used_count"
	//
	// 2. The quota limit reached condition will be specified using the following
	// boolean metric :
	//
	//	"serviceruntime.googleapis.com/quota/exceeded"
	QuotaMetrics []*MetricValueSet `protobuf:"bytes,3,rep,name=quota_metrics,json=quotaMetrics,proto3" json:"quota_metrics,omitempty"`
	// ID of the actual config used to process the request.
	ServiceConfigId string `protobuf:"bytes,4,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
}

func (x *AllocateQuotaResponse) Reset() {
	*x = AllocateQuotaResponse{}
	mi := &file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocateQuotaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocateQuotaResponse) ProtoMessage() {}

func (x *AllocateQuotaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocateQuotaResponse.ProtoReflect.Descriptor instead.
func (*AllocateQuotaResponse) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_quota_controller_proto_rawDescGZIP(), []int{2}
}

func (x *AllocateQuotaResponse) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *AllocateQuotaResponse) GetAllocateErrors() []*QuotaError {
	if x != nil {
		return x.AllocateErrors
	}
	return nil
}

func (x *AllocateQuotaResponse) GetQuotaMetrics() []*MetricValueSet {
	if x != nil {
		return x.QuotaMetrics
	}
	return nil
}

func (x *AllocateQuotaResponse) GetServiceConfigId() string {
	if x != nil {
		return x.ServiceConfigId
	}
	return ""
}

// Represents error information for [QuotaOperation][google.api.servicecontrol.v1.QuotaOperation].
type QuotaError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error code.
	Code QuotaError_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.api.servicecontrol.v1.QuotaError_Code" json:"code,omitempty"`
	// Subject to whom this error applies. See the specific enum for more details
	// on this field. For example, "clientip:<ip address of client>" or
	// "project:<Google developer project id>".
	Subject string `protobuf:"bytes,2,opt,name=subject,proto3" json:"subject,omitempty"`
	// Free-form text that provides details on the cause of the error.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Contains additional information about the quota error.
	// If available, `status.code` will be non zero.
	Status *status.Status `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *QuotaError) Reset() {
	*x = QuotaError{}
	mi := &file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuotaError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaError) ProtoMessage() {}

func (x *QuotaError) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaError.ProtoReflect.Descriptor instead.
func (*QuotaError) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_quota_controller_proto_rawDescGZIP(), []int{3}
}

func (x *QuotaError) GetCode() QuotaError_Code {
	if x != nil {
		return x.Code
	}
	return QuotaError_UNSPECIFIED
}

func (x *QuotaError) GetSubject() string {
	if x != nil {
		return x.Subject
	}
	return ""
}

func (x *QuotaError) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *QuotaError) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

var File_google_api_servicecontrol_v1_quota_controller_proto protoreflect.FileDescriptor

var file_google_api_servicecontrol_v1_quota_controller_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2f, 0x76, 0x31, 0x2f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc2, 0x01, 0x0a, 0x14, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x5b, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a,
	0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0x98, 0x04, 0x0a, 0x0e, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x50, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x51, 0x0a, 0x0d, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x65, 0x74, 0x52, 0x0c, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x55, 0x0a, 0x0a, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x6f,
	0x64, 0x65, 0x52, 0x09, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x4d, 0x6f, 0x64, 0x65, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6a, 0x0a, 0x09, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x45, 0x53, 0x54, 0x5f, 0x45, 0x46, 0x46, 0x4f, 0x52,
	0x54, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x4f, 0x4e, 0x4c,
	0x59, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x4f, 0x4e, 0x4c,
	0x59, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x5f, 0x4f, 0x4e,
	0x4c, 0x59, 0x10, 0x05, 0x22, 0x8c, 0x02, 0x0a, 0x15, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x51, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x0d, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x65, 0x74, 0x52, 0x0c, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x49, 0x64, 0x22, 0xc0, 0x02, 0x0a, 0x0a, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x41, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x86, 0x01,
	0x0a, 0x04, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x45, 0x58, 0x48, 0x41, 0x55, 0x53, 0x54, 0x45, 0x44, 0x10, 0x08, 0x12,
	0x16, 0x0a, 0x12, 0x42, 0x49, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x6b, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x52, 0x4f, 0x4a, 0x45,
	0x43, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x6c, 0x12, 0x13, 0x0a, 0x0f,
	0x41, 0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10,
	0x69, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x50, 0x49, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x45, 0x58, 0x50,
	0x49, 0x52, 0x45, 0x44, 0x10, 0x70, 0x32, 0xc5, 0x02, 0x0a, 0x0f, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x12, 0xae, 0x01, 0x0a, 0x0d, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x3a, 0x01, 0x2a,
	0x22, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x3a, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x1a, 0x80, 0x01, 0xca, 0x41,
	0x1d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x5d, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x42, 0xef,
	0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x2e, 0x76, 0x31, 0x42, 0x14, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x21, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_servicecontrol_v1_quota_controller_proto_rawDescOnce sync.Once
	file_google_api_servicecontrol_v1_quota_controller_proto_rawDescData = file_google_api_servicecontrol_v1_quota_controller_proto_rawDesc
)

func file_google_api_servicecontrol_v1_quota_controller_proto_rawDescGZIP() []byte {
	file_google_api_servicecontrol_v1_quota_controller_proto_rawDescOnce.Do(func() {
		file_google_api_servicecontrol_v1_quota_controller_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_servicecontrol_v1_quota_controller_proto_rawDescData)
	})
	return file_google_api_servicecontrol_v1_quota_controller_proto_rawDescData
}

var file_google_api_servicecontrol_v1_quota_controller_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_api_servicecontrol_v1_quota_controller_proto_goTypes = []any{
	(QuotaOperation_QuotaMode)(0), // 0: google.api.servicecontrol.v1.QuotaOperation.QuotaMode
	(QuotaError_Code)(0),          // 1: google.api.servicecontrol.v1.QuotaError.Code
	(*AllocateQuotaRequest)(nil),  // 2: google.api.servicecontrol.v1.AllocateQuotaRequest
	(*QuotaOperation)(nil),        // 3: google.api.servicecontrol.v1.QuotaOperation
	(*AllocateQuotaResponse)(nil), // 4: google.api.servicecontrol.v1.AllocateQuotaResponse
	(*QuotaError)(nil),            // 5: google.api.servicecontrol.v1.QuotaError
	nil,                           // 6: google.api.servicecontrol.v1.QuotaOperation.LabelsEntry
	(*MetricValueSet)(nil),        // 7: google.api.servicecontrol.v1.MetricValueSet
	(*status.Status)(nil),         // 8: google.rpc.Status
}
var file_google_api_servicecontrol_v1_quota_controller_proto_depIdxs = []int32{
	3, // 0: google.api.servicecontrol.v1.AllocateQuotaRequest.allocate_operation:type_name -> google.api.servicecontrol.v1.QuotaOperation
	6, // 1: google.api.servicecontrol.v1.QuotaOperation.labels:type_name -> google.api.servicecontrol.v1.QuotaOperation.LabelsEntry
	7, // 2: google.api.servicecontrol.v1.QuotaOperation.quota_metrics:type_name -> google.api.servicecontrol.v1.MetricValueSet
	0, // 3: google.api.servicecontrol.v1.QuotaOperation.quota_mode:type_name -> google.api.servicecontrol.v1.QuotaOperation.QuotaMode
	5, // 4: google.api.servicecontrol.v1.AllocateQuotaResponse.allocate_errors:type_name -> google.api.servicecontrol.v1.QuotaError
	7, // 5: google.api.servicecontrol.v1.AllocateQuotaResponse.quota_metrics:type_name -> google.api.servicecontrol.v1.MetricValueSet
	1, // 6: google.api.servicecontrol.v1.QuotaError.code:type_name -> google.api.servicecontrol.v1.QuotaError.Code
	8, // 7: google.api.servicecontrol.v1.QuotaError.status:type_name -> google.rpc.Status
	2, // 8: google.api.servicecontrol.v1.QuotaController.AllocateQuota:input_type -> google.api.servicecontrol.v1.AllocateQuotaRequest
	4, // 9: google.api.servicecontrol.v1.QuotaController.AllocateQuota:output_type -> google.api.servicecontrol.v1.AllocateQuotaResponse
	9, // [9:10] is the sub-list for method output_type
	8, // [8:9] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_api_servicecontrol_v1_quota_controller_proto_init() }
func file_google_api_servicecontrol_v1_quota_controller_proto_init() {
	if File_google_api_servicecontrol_v1_quota_controller_proto != nil {
		return
	}
	file_google_api_servicecontrol_v1_metric_value_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_servicecontrol_v1_quota_controller_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_api_servicecontrol_v1_quota_controller_proto_goTypes,
		DependencyIndexes: file_google_api_servicecontrol_v1_quota_controller_proto_depIdxs,
		EnumInfos:         file_google_api_servicecontrol_v1_quota_controller_proto_enumTypes,
		MessageInfos:      file_google_api_servicecontrol_v1_quota_controller_proto_msgTypes,
	}.Build()
	File_google_api_servicecontrol_v1_quota_controller_proto = out.File
	file_google_api_servicecontrol_v1_quota_controller_proto_rawDesc = nil
	file_google_api_servicecontrol_v1_quota_controller_proto_goTypes = nil
	file_google_api_servicecontrol_v1_quota_controller_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// QuotaControllerClient is the client API for QuotaController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type QuotaControllerClient interface {
	// Attempts to allocate quota for the specified consumer. It should be called
	// before the operation is executed.
	//
	// This method requires the `servicemanagement.services.quota`
	// permission on the specified service. For more information, see
	// [Cloud IAM](https://cloud.google.com/iam).
	//
	// **NOTE:** The client **must** fail-open on server errors `INTERNAL`,
	// `UNKNOWN`, `DEADLINE_EXCEEDED`, and `UNAVAILABLE`. To ensure system
	// reliability, the server may inject these errors to prohibit any hard
	// dependency on the quota functionality.
	AllocateQuota(ctx context.Context, in *AllocateQuotaRequest, opts ...grpc.CallOption) (*AllocateQuotaResponse, error)
}

type quotaControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewQuotaControllerClient(cc grpc.ClientConnInterface) QuotaControllerClient {
	return &quotaControllerClient{cc}
}

func (c *quotaControllerClient) AllocateQuota(ctx context.Context, in *AllocateQuotaRequest, opts ...grpc.CallOption) (*AllocateQuotaResponse, error) {
	out := new(AllocateQuotaResponse)
	err := c.cc.Invoke(ctx, "/google.api.servicecontrol.v1.QuotaController/AllocateQuota", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// QuotaControllerServer is the server API for QuotaController service.
type QuotaControllerServer interface {
	// Attempts to allocate quota for the specified consumer. It should be called
	// before the operation is executed.
	//
	// This method requires the `servicemanagement.services.quota`
	// permission on the specified service. For more information, see
	// [Cloud IAM](https://cloud.google.com/iam).
	//
	// **NOTE:** The client **must** fail-open on server errors `INTERNAL`,
	// `UNKNOWN`, `DEADLINE_EXCEEDED`, and `UNAVAILABLE`. To ensure system
	// reliability, the server may inject these errors to prohibit any hard
	// dependency on the quota functionality.
	AllocateQuota(context.Context, *AllocateQuotaRequest) (*AllocateQuotaResponse, error)
}

// UnimplementedQuotaControllerServer can be embedded to have forward compatible implementations.
type UnimplementedQuotaControllerServer struct {
}

func (*UnimplementedQuotaControllerServer) AllocateQuota(context.Context, *AllocateQuotaRequest) (*AllocateQuotaResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AllocateQuota not implemented")
}

func RegisterQuotaControllerServer(s *grpc.Server, srv QuotaControllerServer) {
	s.RegisterService(&_QuotaController_serviceDesc, srv)
}

func _QuotaController_AllocateQuota_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AllocateQuotaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuotaControllerServer).AllocateQuota(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicecontrol.v1.QuotaController/AllocateQuota",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuotaControllerServer).AllocateQuota(ctx, req.(*AllocateQuotaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _QuotaController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.servicecontrol.v1.QuotaController",
	HandlerType: (*QuotaControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AllocateQuota",
			Handler:    _QuotaController_AllocateQuota_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/servicecontrol/v1/quota_controller.proto",
}
