// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/notebooks/v2/gce_setup.proto

package notebookspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Definition of the disk encryption options.
type DiskEncryption int32

const (
	// Disk encryption is not specified.
	DiskEncryption_DISK_ENCRYPTION_UNSPECIFIED DiskEncryption = 0
	// Use Google managed encryption keys to encrypt the boot disk.
	DiskEncryption_GMEK DiskEncryption = 1
	// Use customer managed encryption keys to encrypt the boot disk.
	DiskEncryption_CMEK DiskEncryption = 2
)

// Enum value maps for DiskEncryption.
var (
	DiskEncryption_name = map[int32]string{
		0: "DISK_ENCRYPTION_UNSPECIFIED",
		1: "GMEK",
		2: "CMEK",
	}
	DiskEncryption_value = map[string]int32{
		"DISK_ENCRYPTION_UNSPECIFIED": 0,
		"GMEK":                        1,
		"CMEK":                        2,
	}
)

func (x DiskEncryption) Enum() *DiskEncryption {
	p := new(DiskEncryption)
	*p = x
	return p
}

func (x DiskEncryption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskEncryption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes[0].Descriptor()
}

func (DiskEncryption) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes[0]
}

func (x DiskEncryption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskEncryption.Descriptor instead.
func (DiskEncryption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{0}
}

// Possible disk types.
type DiskType int32

const (
	// Disk type not set.
	DiskType_DISK_TYPE_UNSPECIFIED DiskType = 0
	// Standard persistent disk type.
	DiskType_PD_STANDARD DiskType = 1
	// SSD persistent disk type.
	DiskType_PD_SSD DiskType = 2
	// Balanced persistent disk type.
	DiskType_PD_BALANCED DiskType = 3
	// Extreme persistent disk type.
	DiskType_PD_EXTREME DiskType = 4
)

// Enum value maps for DiskType.
var (
	DiskType_name = map[int32]string{
		0: "DISK_TYPE_UNSPECIFIED",
		1: "PD_STANDARD",
		2: "PD_SSD",
		3: "PD_BALANCED",
		4: "PD_EXTREME",
	}
	DiskType_value = map[string]int32{
		"DISK_TYPE_UNSPECIFIED": 0,
		"PD_STANDARD":           1,
		"PD_SSD":                2,
		"PD_BALANCED":           3,
		"PD_EXTREME":            4,
	}
)

func (x DiskType) Enum() *DiskType {
	p := new(DiskType)
	*p = x
	return p
}

func (x DiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes[1].Descriptor()
}

func (DiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes[1]
}

func (x DiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskType.Descriptor instead.
func (DiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{1}
}

// The type of vNIC driver.
// Default should be NIC_TYPE_UNSPECIFIED.
type NetworkInterface_NicType int32

const (
	// No type specified.
	NetworkInterface_NIC_TYPE_UNSPECIFIED NetworkInterface_NicType = 0
	// VIRTIO
	NetworkInterface_VIRTIO_NET NetworkInterface_NicType = 1
	// GVNIC
	NetworkInterface_GVNIC NetworkInterface_NicType = 2
)

// Enum value maps for NetworkInterface_NicType.
var (
	NetworkInterface_NicType_name = map[int32]string{
		0: "NIC_TYPE_UNSPECIFIED",
		1: "VIRTIO_NET",
		2: "GVNIC",
	}
	NetworkInterface_NicType_value = map[string]int32{
		"NIC_TYPE_UNSPECIFIED": 0,
		"VIRTIO_NET":           1,
		"GVNIC":                2,
	}
)

func (x NetworkInterface_NicType) Enum() *NetworkInterface_NicType {
	p := new(NetworkInterface_NicType)
	*p = x
	return p
}

func (x NetworkInterface_NicType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_NicType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes[2].Descriptor()
}

func (NetworkInterface_NicType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes[2]
}

func (x NetworkInterface_NicType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_NicType.Descriptor instead.
func (NetworkInterface_NicType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{0, 0}
}

// Definition of the types of hardware accelerators that can be used on
// this instance.
type AcceleratorConfig_AcceleratorType int32

const (
	// Accelerator type is not specified.
	AcceleratorConfig_ACCELERATOR_TYPE_UNSPECIFIED AcceleratorConfig_AcceleratorType = 0
	// Accelerator type is Nvidia Tesla P100.
	AcceleratorConfig_NVIDIA_TESLA_P100 AcceleratorConfig_AcceleratorType = 2
	// Accelerator type is Nvidia Tesla V100.
	AcceleratorConfig_NVIDIA_TESLA_V100 AcceleratorConfig_AcceleratorType = 3
	// Accelerator type is Nvidia Tesla P4.
	AcceleratorConfig_NVIDIA_TESLA_P4 AcceleratorConfig_AcceleratorType = 4
	// Accelerator type is Nvidia Tesla T4.
	AcceleratorConfig_NVIDIA_TESLA_T4 AcceleratorConfig_AcceleratorType = 5
	// Accelerator type is Nvidia Tesla A100 - 40GB.
	AcceleratorConfig_NVIDIA_TESLA_A100 AcceleratorConfig_AcceleratorType = 11
	// Accelerator type is Nvidia Tesla A100 - 80GB.
	AcceleratorConfig_NVIDIA_A100_80GB AcceleratorConfig_AcceleratorType = 12
	// Accelerator type is Nvidia Tesla L4.
	AcceleratorConfig_NVIDIA_L4 AcceleratorConfig_AcceleratorType = 13
	// Accelerator type is NVIDIA Tesla T4 Virtual Workstations.
	AcceleratorConfig_NVIDIA_TESLA_T4_VWS AcceleratorConfig_AcceleratorType = 8
	// Accelerator type is NVIDIA Tesla P100 Virtual Workstations.
	AcceleratorConfig_NVIDIA_TESLA_P100_VWS AcceleratorConfig_AcceleratorType = 9
	// Accelerator type is NVIDIA Tesla P4 Virtual Workstations.
	AcceleratorConfig_NVIDIA_TESLA_P4_VWS AcceleratorConfig_AcceleratorType = 10
)

// Enum value maps for AcceleratorConfig_AcceleratorType.
var (
	AcceleratorConfig_AcceleratorType_name = map[int32]string{
		0:  "ACCELERATOR_TYPE_UNSPECIFIED",
		2:  "NVIDIA_TESLA_P100",
		3:  "NVIDIA_TESLA_V100",
		4:  "NVIDIA_TESLA_P4",
		5:  "NVIDIA_TESLA_T4",
		11: "NVIDIA_TESLA_A100",
		12: "NVIDIA_A100_80GB",
		13: "NVIDIA_L4",
		8:  "NVIDIA_TESLA_T4_VWS",
		9:  "NVIDIA_TESLA_P100_VWS",
		10: "NVIDIA_TESLA_P4_VWS",
	}
	AcceleratorConfig_AcceleratorType_value = map[string]int32{
		"ACCELERATOR_TYPE_UNSPECIFIED": 0,
		"NVIDIA_TESLA_P100":            2,
		"NVIDIA_TESLA_V100":            3,
		"NVIDIA_TESLA_P4":              4,
		"NVIDIA_TESLA_T4":              5,
		"NVIDIA_TESLA_A100":            11,
		"NVIDIA_A100_80GB":             12,
		"NVIDIA_L4":                    13,
		"NVIDIA_TESLA_T4_VWS":          8,
		"NVIDIA_TESLA_P100_VWS":        9,
		"NVIDIA_TESLA_P4_VWS":          10,
	}
)

func (x AcceleratorConfig_AcceleratorType) Enum() *AcceleratorConfig_AcceleratorType {
	p := new(AcceleratorConfig_AcceleratorType)
	*p = x
	return p
}

func (x AcceleratorConfig_AcceleratorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AcceleratorConfig_AcceleratorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes[3].Descriptor()
}

func (AcceleratorConfig_AcceleratorType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes[3]
}

func (x AcceleratorConfig_AcceleratorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AcceleratorConfig_AcceleratorType.Descriptor instead.
func (AcceleratorConfig_AcceleratorType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{3, 0}
}

// The definition of a network interface resource attached to a VM.
type NetworkInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the VPC that this VM instance is in.
	// Format:
	// `projects/{project_id}/global/networks/{network_id}`
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. The name of the subnet that this VM instance is in.
	// Format:
	// `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
	Subnet string `protobuf:"bytes,2,opt,name=subnet,proto3" json:"subnet,omitempty"`
	// Optional. The type of vNIC to be used on this interface. This may be gVNIC
	// or VirtioNet.
	NicType NetworkInterface_NicType `protobuf:"varint,3,opt,name=nic_type,json=nicType,proto3,enum=google.cloud.notebooks.v2.NetworkInterface_NicType" json:"nic_type,omitempty"`
}

func (x *NetworkInterface) Reset() {
	*x = NetworkInterface{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInterface) ProtoMessage() {}

func (x *NetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInterface.ProtoReflect.Descriptor instead.
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{0}
}

func (x *NetworkInterface) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NetworkInterface) GetSubnet() string {
	if x != nil {
		return x.Subnet
	}
	return ""
}

func (x *NetworkInterface) GetNicType() NetworkInterface_NicType {
	if x != nil {
		return x.NicType
	}
	return NetworkInterface_NIC_TYPE_UNSPECIFIED
}

// Definition of a custom Compute Engine virtual machine image for starting a
// notebook instance with the environment installed directly on the VM.
type VmImage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Google Cloud project that this VM image belongs
	// to. Format: `{project_id}`
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// The reference to an external Compute Engine VM image.
	//
	// Types that are assignable to Image:
	//
	//	*VmImage_Name
	//	*VmImage_Family
	Image isVmImage_Image `protobuf_oneof:"image"`
}

func (x *VmImage) Reset() {
	*x = VmImage{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmImage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmImage) ProtoMessage() {}

func (x *VmImage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmImage.ProtoReflect.Descriptor instead.
func (*VmImage) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{1}
}

func (x *VmImage) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (m *VmImage) GetImage() isVmImage_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (x *VmImage) GetName() string {
	if x, ok := x.GetImage().(*VmImage_Name); ok {
		return x.Name
	}
	return ""
}

func (x *VmImage) GetFamily() string {
	if x, ok := x.GetImage().(*VmImage_Family); ok {
		return x.Family
	}
	return ""
}

type isVmImage_Image interface {
	isVmImage_Image()
}

type VmImage_Name struct {
	// Optional. Use VM image name to find the image.
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

type VmImage_Family struct {
	// Optional. Use this VM image family to find the image; the newest image in
	// this family will be used.
	Family string `protobuf:"bytes,3,opt,name=family,proto3,oneof"`
}

func (*VmImage_Name) isVmImage_Image() {}

func (*VmImage_Family) isVmImage_Image() {}

// Definition of a container image for starting a notebook instance with the
// environment installed in a container.
type ContainerImage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The path to the container image repository. For example:
	// `gcr.io/{project_id}/{image_name}`
	Repository string `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// Optional. The tag of the container image. If not specified, this defaults
	// to the latest tag.
	Tag string `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *ContainerImage) Reset() {
	*x = ContainerImage{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerImage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerImage) ProtoMessage() {}

func (x *ContainerImage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerImage.ProtoReflect.Descriptor instead.
func (*ContainerImage) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{2}
}

func (x *ContainerImage) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *ContainerImage) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

// An accelerator configuration for a VM instance
// Definition of a hardware accelerator. Note that there is no check on `type`
// and `core_count` combinations. TPUs are not supported.
// See [GPUs on Compute
// Engine](https://cloud.google.com/compute/docs/gpus/#gpus-list) to find a
// valid combination.
type AcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Type of this accelerator.
	Type AcceleratorConfig_AcceleratorType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.notebooks.v2.AcceleratorConfig_AcceleratorType" json:"type,omitempty"`
	// Optional. Count of cores of this accelerator.
	CoreCount int64 `protobuf:"varint,2,opt,name=core_count,json=coreCount,proto3" json:"core_count,omitempty"`
}

func (x *AcceleratorConfig) Reset() {
	*x = AcceleratorConfig{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorConfig) ProtoMessage() {}

func (x *AcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorConfig.ProtoReflect.Descriptor instead.
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{3}
}

func (x *AcceleratorConfig) GetType() AcceleratorConfig_AcceleratorType {
	if x != nil {
		return x.Type
	}
	return AcceleratorConfig_ACCELERATOR_TYPE_UNSPECIFIED
}

func (x *AcceleratorConfig) GetCoreCount() int64 {
	if x != nil {
		return x.CoreCount
	}
	return 0
}

// A set of Shielded Instance options.
// See [Images using supported Shielded VM
// features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
// Not all combinations are valid.
type ShieldedInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Defines whether the VM instance has Secure Boot enabled.
	//
	// Secure Boot helps ensure that the system only runs authentic software by
	// verifying the digital signature of all boot components, and halting the
	// boot process if signature verification fails. Disabled by default.
	EnableSecureBoot bool `protobuf:"varint,1,opt,name=enable_secure_boot,json=enableSecureBoot,proto3" json:"enable_secure_boot,omitempty"`
	// Optional. Defines whether the VM instance has the vTPM enabled. Enabled by
	// default.
	EnableVtpm bool `protobuf:"varint,2,opt,name=enable_vtpm,json=enableVtpm,proto3" json:"enable_vtpm,omitempty"`
	// Optional. Defines whether the VM instance has integrity monitoring enabled.
	//
	// Enables monitoring and attestation of the boot integrity of the VM
	// instance. The attestation is performed against the integrity policy
	// baseline. This baseline is initially derived from the implicitly trusted
	// boot image when the VM instance is created. Enabled by default.
	EnableIntegrityMonitoring bool `protobuf:"varint,3,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
}

func (x *ShieldedInstanceConfig) Reset() {
	*x = ShieldedInstanceConfig{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShieldedInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShieldedInstanceConfig) ProtoMessage() {}

func (x *ShieldedInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShieldedInstanceConfig.ProtoReflect.Descriptor instead.
func (*ShieldedInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{4}
}

func (x *ShieldedInstanceConfig) GetEnableSecureBoot() bool {
	if x != nil {
		return x.EnableSecureBoot
	}
	return false
}

func (x *ShieldedInstanceConfig) GetEnableVtpm() bool {
	if x != nil {
		return x.EnableVtpm
	}
	return false
}

func (x *ShieldedInstanceConfig) GetEnableIntegrityMonitoring() bool {
	if x != nil {
		return x.EnableIntegrityMonitoring
	}
	return false
}

// A GPU driver configuration
type GPUDriverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether the end user authorizes Google Cloud to install GPU
	// driver on this VM instance. If this field is empty or set to false, the GPU
	// driver won't be installed. Only applicable to instances with GPUs.
	EnableGpuDriver bool `protobuf:"varint,1,opt,name=enable_gpu_driver,json=enableGpuDriver,proto3" json:"enable_gpu_driver,omitempty"`
	// Optional. Specify a custom Cloud Storage path where the GPU driver is
	// stored. If not specified, we'll automatically choose from official GPU
	// drivers.
	CustomGpuDriverPath string `protobuf:"bytes,2,opt,name=custom_gpu_driver_path,json=customGpuDriverPath,proto3" json:"custom_gpu_driver_path,omitempty"`
}

func (x *GPUDriverConfig) Reset() {
	*x = GPUDriverConfig{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GPUDriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GPUDriverConfig) ProtoMessage() {}

func (x *GPUDriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GPUDriverConfig.ProtoReflect.Descriptor instead.
func (*GPUDriverConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{5}
}

func (x *GPUDriverConfig) GetEnableGpuDriver() bool {
	if x != nil {
		return x.EnableGpuDriver
	}
	return false
}

func (x *GPUDriverConfig) GetCustomGpuDriverPath() string {
	if x != nil {
		return x.CustomGpuDriverPath
	}
	return ""
}

// An instance-attached disk resource.
type DataDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The size of the disk in GB attached to this VM instance, up to a
	// maximum of 64000 GB (64 TB). If not specified, this defaults to 100.
	DiskSizeGb int64 `protobuf:"varint,1,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Optional. Input only. Indicates the type of the disk.
	DiskType DiskType `protobuf:"varint,2,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.notebooks.v2.DiskType" json:"disk_type,omitempty"`
	// Optional. Input only. Disk encryption method used on the boot and data
	// disks, defaults to GMEK.
	DiskEncryption DiskEncryption `protobuf:"varint,5,opt,name=disk_encryption,json=diskEncryption,proto3,enum=google.cloud.notebooks.v2.DiskEncryption" json:"disk_encryption,omitempty"`
	// Optional. Input only. The KMS key used to encrypt the disks, only
	// applicable if disk_encryption is CMEK. Format:
	// `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
	//
	// Learn more about using your own encryption keys.
	KmsKey string `protobuf:"bytes,6,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
}

func (x *DataDisk) Reset() {
	*x = DataDisk{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDisk) ProtoMessage() {}

func (x *DataDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDisk.ProtoReflect.Descriptor instead.
func (*DataDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{6}
}

func (x *DataDisk) GetDiskSizeGb() int64 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *DataDisk) GetDiskType() DiskType {
	if x != nil {
		return x.DiskType
	}
	return DiskType_DISK_TYPE_UNSPECIFIED
}

func (x *DataDisk) GetDiskEncryption() DiskEncryption {
	if x != nil {
		return x.DiskEncryption
	}
	return DiskEncryption_DISK_ENCRYPTION_UNSPECIFIED
}

func (x *DataDisk) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

// The definition of a boot disk.
type BootDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The size of the boot disk in GB attached to this instance, up to
	// a maximum of 64000 GB (64 TB). If not specified, this defaults to the
	// recommended value of 150GB.
	DiskSizeGb int64 `protobuf:"varint,1,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Optional. Indicates the type of the disk.
	DiskType DiskType `protobuf:"varint,2,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.notebooks.v2.DiskType" json:"disk_type,omitempty"`
	// Optional. Input only. Disk encryption method used on the boot and data
	// disks, defaults to GMEK.
	DiskEncryption DiskEncryption `protobuf:"varint,3,opt,name=disk_encryption,json=diskEncryption,proto3,enum=google.cloud.notebooks.v2.DiskEncryption" json:"disk_encryption,omitempty"`
	// Optional. Input only. The KMS key used to encrypt the disks, only
	// applicable if disk_encryption is CMEK. Format:
	// `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
	//
	// Learn more about using your own encryption keys.
	KmsKey string `protobuf:"bytes,4,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
}

func (x *BootDisk) Reset() {
	*x = BootDisk{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BootDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BootDisk) ProtoMessage() {}

func (x *BootDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BootDisk.ProtoReflect.Descriptor instead.
func (*BootDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{7}
}

func (x *BootDisk) GetDiskSizeGb() int64 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *BootDisk) GetDiskType() DiskType {
	if x != nil {
		return x.DiskType
	}
	return DiskType_DISK_TYPE_UNSPECIFIED
}

func (x *BootDisk) GetDiskEncryption() DiskEncryption {
	if x != nil {
		return x.DiskEncryption
	}
	return DiskEncryption_DISK_ENCRYPTION_UNSPECIFIED
}

func (x *BootDisk) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

// A service account that acts as an identity.
type ServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Email address of the service account.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// Output only. The list of scopes to be made available for this service
	// account. Set by the CLH to https://www.googleapis.com/auth/cloud-platform
	Scopes []string `protobuf:"bytes,2,rep,name=scopes,proto3" json:"scopes,omitempty"`
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{8}
}

func (x *ServiceAccount) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ServiceAccount) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// The definition of how to configure a VM instance outside of Resources and
// Identity.
type GceSetup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The machine type of the VM instance.
	// https://cloud.google.com/compute/docs/machine-resource
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Optional. The hardware accelerators used on this instance. If you use
	// accelerators, make sure that your configuration has
	// [enough vCPUs and memory to support the `machine_type` you have
	// selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
	// Currently supports only one accelerator configuration.
	AcceleratorConfigs []*AcceleratorConfig `protobuf:"bytes,2,rep,name=accelerator_configs,json=acceleratorConfigs,proto3" json:"accelerator_configs,omitempty"`
	// Optional. The service account that serves as an identity for the VM
	// instance. Currently supports only one service account.
	ServiceAccounts []*ServiceAccount `protobuf:"bytes,3,rep,name=service_accounts,json=serviceAccounts,proto3" json:"service_accounts,omitempty"`
	// Type of the image; can be one of VM image, or container image.
	//
	// Types that are assignable to Image:
	//
	//	*GceSetup_VmImage
	//	*GceSetup_ContainerImage
	Image isGceSetup_Image `protobuf_oneof:"image"`
	// Optional. The boot disk for the VM.
	BootDisk *BootDisk `protobuf:"bytes,6,opt,name=boot_disk,json=bootDisk,proto3" json:"boot_disk,omitempty"`
	// Optional. Data disks attached to the VM instance.
	// Currently supports only one data disk.
	DataDisks []*DataDisk `protobuf:"bytes,7,rep,name=data_disks,json=dataDisks,proto3" json:"data_disks,omitempty"`
	// Optional. Shielded VM configuration.
	// [Images using supported Shielded VM
	// features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
	ShieldedInstanceConfig *ShieldedInstanceConfig `protobuf:"bytes,8,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	// Optional. The network interfaces for the VM.
	// Supports only one interface.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,9,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// Optional. If true, no external IP will be assigned to this VM instance.
	DisablePublicIp bool `protobuf:"varint,10,opt,name=disable_public_ip,json=disablePublicIp,proto3" json:"disable_public_ip,omitempty"`
	// Optional. The Compute Engine tags to add to runtime (see [Tagging
	// instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
	Tags []string `protobuf:"bytes,11,rep,name=tags,proto3" json:"tags,omitempty"`
	// Optional. Custom metadata to apply to this instance.
	Metadata map[string]string `protobuf:"bytes,12,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Flag to enable ip forwarding or not, default false/off.
	// https://cloud.google.com/vpc/docs/using-routes#canipforward
	EnableIpForwarding bool `protobuf:"varint,13,opt,name=enable_ip_forwarding,json=enableIpForwarding,proto3" json:"enable_ip_forwarding,omitempty"`
	// Optional. Configuration for GPU drivers.
	GpuDriverConfig *GPUDriverConfig `protobuf:"bytes,14,opt,name=gpu_driver_config,json=gpuDriverConfig,proto3" json:"gpu_driver_config,omitempty"`
}

func (x *GceSetup) Reset() {
	*x = GceSetup{}
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GceSetup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GceSetup) ProtoMessage() {}

func (x *GceSetup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GceSetup.ProtoReflect.Descriptor instead.
func (*GceSetup) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP(), []int{9}
}

func (x *GceSetup) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *GceSetup) GetAcceleratorConfigs() []*AcceleratorConfig {
	if x != nil {
		return x.AcceleratorConfigs
	}
	return nil
}

func (x *GceSetup) GetServiceAccounts() []*ServiceAccount {
	if x != nil {
		return x.ServiceAccounts
	}
	return nil
}

func (m *GceSetup) GetImage() isGceSetup_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (x *GceSetup) GetVmImage() *VmImage {
	if x, ok := x.GetImage().(*GceSetup_VmImage); ok {
		return x.VmImage
	}
	return nil
}

func (x *GceSetup) GetContainerImage() *ContainerImage {
	if x, ok := x.GetImage().(*GceSetup_ContainerImage); ok {
		return x.ContainerImage
	}
	return nil
}

func (x *GceSetup) GetBootDisk() *BootDisk {
	if x != nil {
		return x.BootDisk
	}
	return nil
}

func (x *GceSetup) GetDataDisks() []*DataDisk {
	if x != nil {
		return x.DataDisks
	}
	return nil
}

func (x *GceSetup) GetShieldedInstanceConfig() *ShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *GceSetup) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

func (x *GceSetup) GetDisablePublicIp() bool {
	if x != nil {
		return x.DisablePublicIp
	}
	return false
}

func (x *GceSetup) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *GceSetup) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *GceSetup) GetEnableIpForwarding() bool {
	if x != nil {
		return x.EnableIpForwarding
	}
	return false
}

func (x *GceSetup) GetGpuDriverConfig() *GPUDriverConfig {
	if x != nil {
		return x.GpuDriverConfig
	}
	return nil
}

type isGceSetup_Image interface {
	isGceSetup_Image()
}

type GceSetup_VmImage struct {
	// Optional. Use a Compute Engine VM image to start the notebook instance.
	VmImage *VmImage `protobuf:"bytes,4,opt,name=vm_image,json=vmImage,proto3,oneof"`
}

type GceSetup_ContainerImage struct {
	// Optional. Use a container image to start the notebook instance.
	ContainerImage *ContainerImage `protobuf:"bytes,5,opt,name=container_image,json=containerImage,proto3,oneof"`
}

func (*GceSetup_VmImage) isGceSetup_Image() {}

func (*GceSetup_ContainerImage) isGceSetup_Image() {}

var File_google_cloud_notebooks_v2_gce_setup_proto protoreflect.FileDescriptor

var file_google_cloud_notebooks_v2_gce_setup_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x63, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe3, 0x01, 0x0a, 0x10, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1b, 0x0a, 0x06, 0x73,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x08, 0x6e, 0x69, 0x63, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x2e, 0x4e, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6e, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x22, 0x3e, 0x0a,
	0x07, 0x4e, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4e, 0x49, 0x43, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x49, 0x52, 0x54, 0x49, 0x4f, 0x5f, 0x4e, 0x45, 0x54,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x56, 0x4e, 0x49, 0x43, 0x10, 0x02, 0x22, 0x6b, 0x0a,
	0x07, 0x56, 0x6d, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x19, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x06, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x06, 0x66, 0x61, 0x6d, 0x69, 0x6c,
	0x79, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x22, 0x4c, 0x0a, 0x0e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0a,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x15, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x03, 0x74, 0x61, 0x67, 0x22, 0xa5, 0x03, 0x0a, 0x11, 0x41, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x63, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x94, 0x02, 0x0a, 0x0f, 0x41, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a,
	0x1c, 0x41, 0x43, 0x43, 0x45, 0x4c, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f,
	0x50, 0x31, 0x30, 0x30, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41,
	0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x56, 0x31, 0x30, 0x30, 0x10, 0x03, 0x12, 0x13, 0x0a,
	0x0f, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x34,
	0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53,
	0x4c, 0x41, 0x5f, 0x54, 0x34, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44, 0x49,
	0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x41, 0x31, 0x30, 0x30, 0x10, 0x0b, 0x12, 0x14,
	0x0a, 0x10, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x41, 0x31, 0x30, 0x30, 0x5f, 0x38, 0x30,
	0x47, 0x42, 0x10, 0x0c, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x4c,
	0x34, 0x10, 0x0d, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45,
	0x53, 0x4c, 0x41, 0x5f, 0x54, 0x34, 0x5f, 0x56, 0x57, 0x53, 0x10, 0x08, 0x12, 0x19, 0x0a, 0x15,
	0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x31, 0x30,
	0x30, 0x5f, 0x56, 0x57, 0x53, 0x10, 0x09, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x56, 0x49, 0x44, 0x49,
	0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x34, 0x5f, 0x56, 0x57, 0x53, 0x10, 0x0a,
	0x22, 0xb6, 0x01, 0x0a, 0x16, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x12, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x12, 0x24,
	0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x74, 0x70, 0x6d, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x56, 0x74, 0x70, 0x6d, 0x12, 0x43, 0x0a, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x7c, 0x0a, 0x0f, 0x47, 0x50, 0x55,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2f, 0x0a, 0x11,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x47, 0x70, 0x75, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x12, 0x38, 0x0a,
	0x16, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x47, 0x70, 0x75, 0x44, 0x72, 0x69,
	0x76, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x22, 0xf8, 0x01, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61,
	0x44, 0x69, 0x73, 0x6b, 0x12, 0x25, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x67, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x48, 0x0a, 0x09, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73,
	0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1f, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x22, 0xf5, 0x01, 0x0a, 0x08, 0x42, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x12,
	0x25, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x45, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a,
	0x0f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x6b, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x07, 0x6b, 0x6d, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x22, 0x48, 0x0a, 0x0e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x73, 0x22, 0xed, 0x08, 0x0a, 0x08, 0x47, 0x63, 0x65, 0x53, 0x65, 0x74, 0x75,
	0x70, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x62, 0x0a, 0x13, 0x61, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x61, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x59, 0x0a,
	0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x08, 0x76, 0x6d, 0x5f, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6d, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x76, 0x6d, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x59,
	0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x62, 0x6f, 0x6f,
	0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b,
	0x12, 0x47, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x70, 0x0a, 0x18, 0x73, 0x68, 0x69,
	0x65, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x16, 0x73, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x12, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x11,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69,
	0x70, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x12, 0x17, 0x0a,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x52, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x63, 0x65, 0x53, 0x65, 0x74, 0x75, 0x70, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x35, 0x0a, 0x14, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x70, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x70, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x5b, 0x0a, 0x11, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x50, 0x55, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x67,
	0x70, 0x75, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3b,
	0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x2a, 0x45, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x45,
	0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x4d, 0x45, 0x4b, 0x10,
	0x01, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4d, 0x45, 0x4b, 0x10, 0x02, 0x2a, 0x63, 0x0a, 0x08, 0x44,
	0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x53, 0x4b, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52,
	0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x44, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x02, 0x12,
	0x0f, 0x0a, 0x0b, 0x50, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x44, 0x5f, 0x45, 0x58, 0x54, 0x52, 0x45, 0x4d, 0x45, 0x10, 0x04,
	0x42, 0xc4, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x76, 0x32, 0x42, 0x0d, 0x47, 0x63, 0x65, 0x53, 0x65, 0x74, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x70, 0x62, 0x3b, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x70, 0x62,
	0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x19, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_notebooks_v2_gce_setup_proto_rawDescOnce sync.Once
	file_google_cloud_notebooks_v2_gce_setup_proto_rawDescData = file_google_cloud_notebooks_v2_gce_setup_proto_rawDesc
)

func file_google_cloud_notebooks_v2_gce_setup_proto_rawDescGZIP() []byte {
	file_google_cloud_notebooks_v2_gce_setup_proto_rawDescOnce.Do(func() {
		file_google_cloud_notebooks_v2_gce_setup_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_notebooks_v2_gce_setup_proto_rawDescData)
	})
	return file_google_cloud_notebooks_v2_gce_setup_proto_rawDescData
}

var file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_notebooks_v2_gce_setup_proto_goTypes = []any{
	(DiskEncryption)(0),                    // 0: google.cloud.notebooks.v2.DiskEncryption
	(DiskType)(0),                          // 1: google.cloud.notebooks.v2.DiskType
	(NetworkInterface_NicType)(0),          // 2: google.cloud.notebooks.v2.NetworkInterface.NicType
	(AcceleratorConfig_AcceleratorType)(0), // 3: google.cloud.notebooks.v2.AcceleratorConfig.AcceleratorType
	(*NetworkInterface)(nil),               // 4: google.cloud.notebooks.v2.NetworkInterface
	(*VmImage)(nil),                        // 5: google.cloud.notebooks.v2.VmImage
	(*ContainerImage)(nil),                 // 6: google.cloud.notebooks.v2.ContainerImage
	(*AcceleratorConfig)(nil),              // 7: google.cloud.notebooks.v2.AcceleratorConfig
	(*ShieldedInstanceConfig)(nil),         // 8: google.cloud.notebooks.v2.ShieldedInstanceConfig
	(*GPUDriverConfig)(nil),                // 9: google.cloud.notebooks.v2.GPUDriverConfig
	(*DataDisk)(nil),                       // 10: google.cloud.notebooks.v2.DataDisk
	(*BootDisk)(nil),                       // 11: google.cloud.notebooks.v2.BootDisk
	(*ServiceAccount)(nil),                 // 12: google.cloud.notebooks.v2.ServiceAccount
	(*GceSetup)(nil),                       // 13: google.cloud.notebooks.v2.GceSetup
	nil,                                    // 14: google.cloud.notebooks.v2.GceSetup.MetadataEntry
}
var file_google_cloud_notebooks_v2_gce_setup_proto_depIdxs = []int32{
	2,  // 0: google.cloud.notebooks.v2.NetworkInterface.nic_type:type_name -> google.cloud.notebooks.v2.NetworkInterface.NicType
	3,  // 1: google.cloud.notebooks.v2.AcceleratorConfig.type:type_name -> google.cloud.notebooks.v2.AcceleratorConfig.AcceleratorType
	1,  // 2: google.cloud.notebooks.v2.DataDisk.disk_type:type_name -> google.cloud.notebooks.v2.DiskType
	0,  // 3: google.cloud.notebooks.v2.DataDisk.disk_encryption:type_name -> google.cloud.notebooks.v2.DiskEncryption
	1,  // 4: google.cloud.notebooks.v2.BootDisk.disk_type:type_name -> google.cloud.notebooks.v2.DiskType
	0,  // 5: google.cloud.notebooks.v2.BootDisk.disk_encryption:type_name -> google.cloud.notebooks.v2.DiskEncryption
	7,  // 6: google.cloud.notebooks.v2.GceSetup.accelerator_configs:type_name -> google.cloud.notebooks.v2.AcceleratorConfig
	12, // 7: google.cloud.notebooks.v2.GceSetup.service_accounts:type_name -> google.cloud.notebooks.v2.ServiceAccount
	5,  // 8: google.cloud.notebooks.v2.GceSetup.vm_image:type_name -> google.cloud.notebooks.v2.VmImage
	6,  // 9: google.cloud.notebooks.v2.GceSetup.container_image:type_name -> google.cloud.notebooks.v2.ContainerImage
	11, // 10: google.cloud.notebooks.v2.GceSetup.boot_disk:type_name -> google.cloud.notebooks.v2.BootDisk
	10, // 11: google.cloud.notebooks.v2.GceSetup.data_disks:type_name -> google.cloud.notebooks.v2.DataDisk
	8,  // 12: google.cloud.notebooks.v2.GceSetup.shielded_instance_config:type_name -> google.cloud.notebooks.v2.ShieldedInstanceConfig
	4,  // 13: google.cloud.notebooks.v2.GceSetup.network_interfaces:type_name -> google.cloud.notebooks.v2.NetworkInterface
	14, // 14: google.cloud.notebooks.v2.GceSetup.metadata:type_name -> google.cloud.notebooks.v2.GceSetup.MetadataEntry
	9,  // 15: google.cloud.notebooks.v2.GceSetup.gpu_driver_config:type_name -> google.cloud.notebooks.v2.GPUDriverConfig
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_notebooks_v2_gce_setup_proto_init() }
func file_google_cloud_notebooks_v2_gce_setup_proto_init() {
	if File_google_cloud_notebooks_v2_gce_setup_proto != nil {
		return
	}
	file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[1].OneofWrappers = []any{
		(*VmImage_Name)(nil),
		(*VmImage_Family)(nil),
	}
	file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes[9].OneofWrappers = []any{
		(*GceSetup_VmImage)(nil),
		(*GceSetup_ContainerImage)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_notebooks_v2_gce_setup_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_notebooks_v2_gce_setup_proto_goTypes,
		DependencyIndexes: file_google_cloud_notebooks_v2_gce_setup_proto_depIdxs,
		EnumInfos:         file_google_cloud_notebooks_v2_gce_setup_proto_enumTypes,
		MessageInfos:      file_google_cloud_notebooks_v2_gce_setup_proto_msgTypes,
	}.Build()
	File_google_cloud_notebooks_v2_gce_setup_proto = out.File
	file_google_cloud_notebooks_v2_gce_setup_proto_rawDesc = nil
	file_google_cloud_notebooks_v2_gce_setup_proto_goTypes = nil
	file_google_cloud_notebooks_v2_gce_setup_proto_depIdxs = nil
}
