// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/networkservices/v1/dep.proto

package networkservicespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The part of the request or response for which the extension is called.
type EventType int32

const (
	// Unspecified value. Do not use.
	EventType_EVENT_TYPE_UNSPECIFIED EventType = 0
	// If included in `supported_events`,
	// the extension is called when the HTTP request headers arrive.
	EventType_REQUEST_HEADERS EventType = 1
	// If included in `supported_events`,
	// the extension is called when the HTTP request body arrives.
	EventType_REQUEST_BODY EventType = 2
	// If included in `supported_events`,
	// the extension is called when the HTTP response headers arrive.
	EventType_RESPONSE_HEADERS EventType = 3
	// If included in `supported_events`,
	// the extension is called when the HTTP response body arrives.
	EventType_RESPONSE_BODY EventType = 4
	// If included in `supported_events`,
	// the extension is called when the HTTP request trailers arrives.
	EventType_REQUEST_TRAILERS EventType = 5
	// If included in `supported_events`,
	// the extension is called when the HTTP response trailers arrives.
	EventType_RESPONSE_TRAILERS EventType = 6
)

// Enum value maps for EventType.
var (
	EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "REQUEST_HEADERS",
		2: "REQUEST_BODY",
		3: "RESPONSE_HEADERS",
		4: "RESPONSE_BODY",
		5: "REQUEST_TRAILERS",
		6: "RESPONSE_TRAILERS",
	}
	EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED": 0,
		"REQUEST_HEADERS":        1,
		"REQUEST_BODY":           2,
		"RESPONSE_HEADERS":       3,
		"RESPONSE_BODY":          4,
		"REQUEST_TRAILERS":       5,
		"RESPONSE_TRAILERS":      6,
	}
)

func (x EventType) Enum() *EventType {
	p := new(EventType)
	*p = x
	return p
}

func (x EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkservices_v1_dep_proto_enumTypes[0].Descriptor()
}

func (EventType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkservices_v1_dep_proto_enumTypes[0]
}

func (x EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventType.Descriptor instead.
func (EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{0}
}

// Load balancing schemes supported by the `LbTrafficExtension` resource and
// `LbRouteExtension` resource.
// For more information, refer to [Choosing a load
// balancer](https://cloud.google.com/load-balancing/docs/backend-service).
type LoadBalancingScheme int32

const (
	// Default value. Do not use.
	LoadBalancingScheme_LOAD_BALANCING_SCHEME_UNSPECIFIED LoadBalancingScheme = 0
	// Signifies that this is used for Internal HTTP(S) Load Balancing.
	LoadBalancingScheme_INTERNAL_MANAGED LoadBalancingScheme = 1
	// Signifies that this is used for External Managed HTTP(S) Load
	// Balancing.
	LoadBalancingScheme_EXTERNAL_MANAGED LoadBalancingScheme = 2
)

// Enum value maps for LoadBalancingScheme.
var (
	LoadBalancingScheme_name = map[int32]string{
		0: "LOAD_BALANCING_SCHEME_UNSPECIFIED",
		1: "INTERNAL_MANAGED",
		2: "EXTERNAL_MANAGED",
	}
	LoadBalancingScheme_value = map[string]int32{
		"LOAD_BALANCING_SCHEME_UNSPECIFIED": 0,
		"INTERNAL_MANAGED":                  1,
		"EXTERNAL_MANAGED":                  2,
	}
)

func (x LoadBalancingScheme) Enum() *LoadBalancingScheme {
	p := new(LoadBalancingScheme)
	*p = x
	return p
}

func (x LoadBalancingScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancingScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkservices_v1_dep_proto_enumTypes[1].Descriptor()
}

func (LoadBalancingScheme) Type() protoreflect.EnumType {
	return &file_google_cloud_networkservices_v1_dep_proto_enumTypes[1]
}

func (x LoadBalancingScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancingScheme.Descriptor instead.
func (LoadBalancingScheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{1}
}

// A single extension chain wrapper that contains the match conditions and
// extensions to execute.
type ExtensionChain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name for this extension chain.
	// The name is logged as part of the HTTP request logs.
	// The name must conform with RFC-1034, is restricted to lower-cased letters,
	// numbers and hyphens, and can have a maximum length of 63 characters.
	// Additionally, the first character must be a letter and the last a letter or
	// a number.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Conditions under which this chain is invoked for a request.
	MatchCondition *ExtensionChain_MatchCondition `protobuf:"bytes,2,opt,name=match_condition,json=matchCondition,proto3" json:"match_condition,omitempty"`
	// Required. A set of extensions to execute for the matching request.
	// At least one extension is required.
	// Up to 3 extensions can be defined for each extension chain
	// for `LbTrafficExtension` resource.
	// `LbRouteExtension` chains are limited to 1 extension per extension chain.
	Extensions []*ExtensionChain_Extension `protobuf:"bytes,3,rep,name=extensions,proto3" json:"extensions,omitempty"`
}

func (x *ExtensionChain) Reset() {
	*x = ExtensionChain{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtensionChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionChain) ProtoMessage() {}

func (x *ExtensionChain) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionChain.ProtoReflect.Descriptor instead.
func (*ExtensionChain) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{0}
}

func (x *ExtensionChain) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExtensionChain) GetMatchCondition() *ExtensionChain_MatchCondition {
	if x != nil {
		return x.MatchCondition
	}
	return nil
}

func (x *ExtensionChain) GetExtensions() []*ExtensionChain_Extension {
	if x != nil {
		return x.Extensions
	}
	return nil
}

// `LbTrafficExtension` is a resource that lets the extension service modify the
// headers and payloads of both requests and responses without impacting the
// choice of backend services or any other security policies associated with the
// backend service.
type LbTrafficExtension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifier. Name of the `LbTrafficExtension` resource in the
	// following format:
	// `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_extension}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. A human-readable description of the resource.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Set of labels associated with the `LbTrafficExtension` resource.
	//
	// The format must comply with [the requirements for
	// labels](https://cloud.google.com/compute/docs/labeling-resources#requirements)
	// for Google Cloud resources.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. A list of references to the forwarding rules to which this
	// service extension is attached to. At least one forwarding rule is required.
	// There can be only one `LBTrafficExtension` resource per forwarding rule.
	ForwardingRules []string `protobuf:"bytes,5,rep,name=forwarding_rules,json=forwardingRules,proto3" json:"forwarding_rules,omitempty"`
	// Required. A set of ordered extension chains that contain the match
	// conditions and extensions to execute. Match conditions for each extension
	// chain are evaluated in sequence for a given request. The first extension
	// chain that has a condition that matches the request is executed.
	// Any subsequent extension chains do not execute.
	// Limited to 5 extension chains per resource.
	ExtensionChains []*ExtensionChain `protobuf:"bytes,7,rep,name=extension_chains,json=extensionChains,proto3" json:"extension_chains,omitempty"`
	// Required. All backend services and forwarding rules referenced by this
	// extension must share the same load balancing scheme. Supported values:
	// `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`. For more information, refer to
	// [Choosing a load
	// balancer](https://cloud.google.com/load-balancing/docs/backend-service).
	LoadBalancingScheme LoadBalancingScheme `protobuf:"varint,8,opt,name=load_balancing_scheme,json=loadBalancingScheme,proto3,enum=google.cloud.networkservices.v1.LoadBalancingScheme" json:"load_balancing_scheme,omitempty"`
	// Optional. The metadata provided here is included in the
	// `ProcessingRequest.metadata_context.filter_metadata` map field. The
	// metadata is available under the key
	// `com.google.lb_traffic_extension.<resource_name>`.
	// The following variables are supported in the metadata:
	//
	// `{forwarding_rule_id}` - substituted with the forwarding rule's fully
	//
	//	qualified resource name.
	Metadata *structpb.Struct `protobuf:"bytes,10,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *LbTrafficExtension) Reset() {
	*x = LbTrafficExtension{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LbTrafficExtension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LbTrafficExtension) ProtoMessage() {}

func (x *LbTrafficExtension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LbTrafficExtension.ProtoReflect.Descriptor instead.
func (*LbTrafficExtension) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{1}
}

func (x *LbTrafficExtension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LbTrafficExtension) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *LbTrafficExtension) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *LbTrafficExtension) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *LbTrafficExtension) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LbTrafficExtension) GetForwardingRules() []string {
	if x != nil {
		return x.ForwardingRules
	}
	return nil
}

func (x *LbTrafficExtension) GetExtensionChains() []*ExtensionChain {
	if x != nil {
		return x.ExtensionChains
	}
	return nil
}

func (x *LbTrafficExtension) GetLoadBalancingScheme() LoadBalancingScheme {
	if x != nil {
		return x.LoadBalancingScheme
	}
	return LoadBalancingScheme_LOAD_BALANCING_SCHEME_UNSPECIFIED
}

func (x *LbTrafficExtension) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Message for requesting list of `LbTrafficExtension` resources.
type ListLbTrafficExtensionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the `LbTrafficExtension`
	// resources are listed, specified in the following format:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. The server might return fewer items than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results that the server returns.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListLbTrafficExtensionsRequest) Reset() {
	*x = ListLbTrafficExtensionsRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLbTrafficExtensionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLbTrafficExtensionsRequest) ProtoMessage() {}

func (x *ListLbTrafficExtensionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLbTrafficExtensionsRequest.ProtoReflect.Descriptor instead.
func (*ListLbTrafficExtensionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{2}
}

func (x *ListLbTrafficExtensionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLbTrafficExtensionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLbTrafficExtensionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListLbTrafficExtensionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListLbTrafficExtensionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing `LbTrafficExtension` resources.
type ListLbTrafficExtensionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of `LbTrafficExtension` resources.
	LbTrafficExtensions []*LbTrafficExtension `protobuf:"bytes,1,rep,name=lb_traffic_extensions,json=lbTrafficExtensions,proto3" json:"lb_traffic_extensions,omitempty"`
	// A token identifying a page of results that the server returns.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListLbTrafficExtensionsResponse) Reset() {
	*x = ListLbTrafficExtensionsResponse{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLbTrafficExtensionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLbTrafficExtensionsResponse) ProtoMessage() {}

func (x *ListLbTrafficExtensionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLbTrafficExtensionsResponse.ProtoReflect.Descriptor instead.
func (*ListLbTrafficExtensionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{3}
}

func (x *ListLbTrafficExtensionsResponse) GetLbTrafficExtensions() []*LbTrafficExtension {
	if x != nil {
		return x.LbTrafficExtensions
	}
	return nil
}

func (x *ListLbTrafficExtensionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListLbTrafficExtensionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a `LbTrafficExtension` resource.
type GetLbTrafficExtensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the `LbTrafficExtension` resource to get. Must be in
	// the format
	// `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_extension}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLbTrafficExtensionRequest) Reset() {
	*x = GetLbTrafficExtensionRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLbTrafficExtensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLbTrafficExtensionRequest) ProtoMessage() {}

func (x *GetLbTrafficExtensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLbTrafficExtensionRequest.ProtoReflect.Descriptor instead.
func (*GetLbTrafficExtensionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{4}
}

func (x *GetLbTrafficExtensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a `LbTrafficExtension` resource.
type CreateLbTrafficExtensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the `LbTrafficExtension` resource. Must be
	// in the format `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User-provided ID of the `LbTrafficExtension` resource to be
	// created.
	LbTrafficExtensionId string `protobuf:"bytes,2,opt,name=lb_traffic_extension_id,json=lbTrafficExtensionId,proto3" json:"lb_traffic_extension_id,omitempty"`
	// Required. `LbTrafficExtension` resource to be created.
	LbTrafficExtension *LbTrafficExtension `protobuf:"bytes,3,opt,name=lb_traffic_extension,json=lbTrafficExtension,proto3" json:"lb_traffic_extension,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server can ignore
	// the request if it has already been completed. The server guarantees
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, ignores the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateLbTrafficExtensionRequest) Reset() {
	*x = CreateLbTrafficExtensionRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateLbTrafficExtensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLbTrafficExtensionRequest) ProtoMessage() {}

func (x *CreateLbTrafficExtensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLbTrafficExtensionRequest.ProtoReflect.Descriptor instead.
func (*CreateLbTrafficExtensionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{5}
}

func (x *CreateLbTrafficExtensionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateLbTrafficExtensionRequest) GetLbTrafficExtensionId() string {
	if x != nil {
		return x.LbTrafficExtensionId
	}
	return ""
}

func (x *CreateLbTrafficExtensionRequest) GetLbTrafficExtension() *LbTrafficExtension {
	if x != nil {
		return x.LbTrafficExtension
	}
	return nil
}

func (x *CreateLbTrafficExtensionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating a `LbTrafficExtension` resource.
type UpdateLbTrafficExtensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Used to specify the fields to be overwritten in the
	// `LbTrafficExtension` resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field is overwritten if it is in the mask. If the
	// user does not specify a mask, then all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. `LbTrafficExtension` resource being updated.
	LbTrafficExtension *LbTrafficExtension `protobuf:"bytes,2,opt,name=lb_traffic_extension,json=lbTrafficExtension,proto3" json:"lb_traffic_extension,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server can ignore
	// the request if it has already been completed. The server guarantees
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, ignores the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateLbTrafficExtensionRequest) Reset() {
	*x = UpdateLbTrafficExtensionRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateLbTrafficExtensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLbTrafficExtensionRequest) ProtoMessage() {}

func (x *UpdateLbTrafficExtensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLbTrafficExtensionRequest.ProtoReflect.Descriptor instead.
func (*UpdateLbTrafficExtensionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateLbTrafficExtensionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateLbTrafficExtensionRequest) GetLbTrafficExtension() *LbTrafficExtension {
	if x != nil {
		return x.LbTrafficExtension
	}
	return nil
}

func (x *UpdateLbTrafficExtensionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a `LbTrafficExtension` resource.
type DeleteLbTrafficExtensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `LbTrafficExtension` resource to delete. Must be
	// in the format
	// `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_extension}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server can ignore
	// the request if it has already been completed. The server guarantees
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, ignores the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteLbTrafficExtensionRequest) Reset() {
	*x = DeleteLbTrafficExtensionRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteLbTrafficExtensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLbTrafficExtensionRequest) ProtoMessage() {}

func (x *DeleteLbTrafficExtensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLbTrafficExtensionRequest.ProtoReflect.Descriptor instead.
func (*DeleteLbTrafficExtensionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteLbTrafficExtensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteLbTrafficExtensionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// `LbRouteExtension` is a resource that lets you control where traffic is
// routed to for a given request.
type LbRouteExtension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifier. Name of the `LbRouteExtension` resource in the
	// following format:
	// `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extension}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. A human-readable description of the resource.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Set of labels associated with the `LbRouteExtension` resource.
	//
	// The format must comply with [the requirements for
	// labels](https://cloud.google.com/compute/docs/labeling-resources#requirements)
	// for Google Cloud resources.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. A list of references to the forwarding rules to which this
	// service extension is attached to. At least one forwarding rule is required.
	// There can be only one `LbRouteExtension` resource per forwarding rule.
	ForwardingRules []string `protobuf:"bytes,5,rep,name=forwarding_rules,json=forwardingRules,proto3" json:"forwarding_rules,omitempty"`
	// Required. A set of ordered extension chains that contain the match
	// conditions and extensions to execute. Match conditions for each extension
	// chain are evaluated in sequence for a given request. The first extension
	// chain that has a condition that matches the request is executed.
	// Any subsequent extension chains do not execute.
	// Limited to 5 extension chains per resource.
	ExtensionChains []*ExtensionChain `protobuf:"bytes,7,rep,name=extension_chains,json=extensionChains,proto3" json:"extension_chains,omitempty"`
	// Required. All backend services and forwarding rules referenced by this
	// extension must share the same load balancing scheme. Supported values:
	// `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`. For more information, refer to
	// [Choosing a load
	// balancer](https://cloud.google.com/load-balancing/docs/backend-service).
	LoadBalancingScheme LoadBalancingScheme `protobuf:"varint,8,opt,name=load_balancing_scheme,json=loadBalancingScheme,proto3,enum=google.cloud.networkservices.v1.LoadBalancingScheme" json:"load_balancing_scheme,omitempty"`
	// Optional. The metadata provided here is included as part of the
	// `metadata_context` (of type `google.protobuf.Struct`) in the
	// `ProcessingRequest` message sent to the extension
	// server. The metadata is available under the namespace
	// `com.google.lb_route_extension.<resource_name>`.
	// The following variables are supported in the metadata Struct:
	//
	// `{forwarding_rule_id}` - substituted with the forwarding rule's fully
	//
	//	qualified resource name.
	Metadata *structpb.Struct `protobuf:"bytes,10,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *LbRouteExtension) Reset() {
	*x = LbRouteExtension{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LbRouteExtension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LbRouteExtension) ProtoMessage() {}

func (x *LbRouteExtension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LbRouteExtension.ProtoReflect.Descriptor instead.
func (*LbRouteExtension) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{8}
}

func (x *LbRouteExtension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LbRouteExtension) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *LbRouteExtension) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *LbRouteExtension) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *LbRouteExtension) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LbRouteExtension) GetForwardingRules() []string {
	if x != nil {
		return x.ForwardingRules
	}
	return nil
}

func (x *LbRouteExtension) GetExtensionChains() []*ExtensionChain {
	if x != nil {
		return x.ExtensionChains
	}
	return nil
}

func (x *LbRouteExtension) GetLoadBalancingScheme() LoadBalancingScheme {
	if x != nil {
		return x.LoadBalancingScheme
	}
	return LoadBalancingScheme_LOAD_BALANCING_SCHEME_UNSPECIFIED
}

func (x *LbRouteExtension) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Message for requesting list of `LbRouteExtension` resources.
type ListLbRouteExtensionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the `LbRouteExtension`
	// resources are listed, specified in the following format:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. The server might return fewer items than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results that the server returns.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListLbRouteExtensionsRequest) Reset() {
	*x = ListLbRouteExtensionsRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLbRouteExtensionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLbRouteExtensionsRequest) ProtoMessage() {}

func (x *ListLbRouteExtensionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLbRouteExtensionsRequest.ProtoReflect.Descriptor instead.
func (*ListLbRouteExtensionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{9}
}

func (x *ListLbRouteExtensionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLbRouteExtensionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLbRouteExtensionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListLbRouteExtensionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListLbRouteExtensionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing `LbRouteExtension` resources.
type ListLbRouteExtensionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of `LbRouteExtension` resources.
	LbRouteExtensions []*LbRouteExtension `protobuf:"bytes,1,rep,name=lb_route_extensions,json=lbRouteExtensions,proto3" json:"lb_route_extensions,omitempty"`
	// A token identifying a page of results that the server returns.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListLbRouteExtensionsResponse) Reset() {
	*x = ListLbRouteExtensionsResponse{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLbRouteExtensionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLbRouteExtensionsResponse) ProtoMessage() {}

func (x *ListLbRouteExtensionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLbRouteExtensionsResponse.ProtoReflect.Descriptor instead.
func (*ListLbRouteExtensionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{10}
}

func (x *ListLbRouteExtensionsResponse) GetLbRouteExtensions() []*LbRouteExtension {
	if x != nil {
		return x.LbRouteExtensions
	}
	return nil
}

func (x *ListLbRouteExtensionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListLbRouteExtensionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a `LbRouteExtension` resource.
type GetLbRouteExtensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the `LbRouteExtension` resource to get. Must be in the
	// format
	// `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extension}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLbRouteExtensionRequest) Reset() {
	*x = GetLbRouteExtensionRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLbRouteExtensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLbRouteExtensionRequest) ProtoMessage() {}

func (x *GetLbRouteExtensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLbRouteExtensionRequest.ProtoReflect.Descriptor instead.
func (*GetLbRouteExtensionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{11}
}

func (x *GetLbRouteExtensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a `LbRouteExtension` resource.
type CreateLbRouteExtensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the `LbRouteExtension` resource. Must be
	// in the format `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User-provided ID of the `LbRouteExtension` resource to be
	// created.
	LbRouteExtensionId string `protobuf:"bytes,2,opt,name=lb_route_extension_id,json=lbRouteExtensionId,proto3" json:"lb_route_extension_id,omitempty"`
	// Required. `LbRouteExtension` resource to be created.
	LbRouteExtension *LbRouteExtension `protobuf:"bytes,3,opt,name=lb_route_extension,json=lbRouteExtension,proto3" json:"lb_route_extension,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server can ignore
	// the request if it has already been completed. The server guarantees
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, ignores the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateLbRouteExtensionRequest) Reset() {
	*x = CreateLbRouteExtensionRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateLbRouteExtensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLbRouteExtensionRequest) ProtoMessage() {}

func (x *CreateLbRouteExtensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLbRouteExtensionRequest.ProtoReflect.Descriptor instead.
func (*CreateLbRouteExtensionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{12}
}

func (x *CreateLbRouteExtensionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateLbRouteExtensionRequest) GetLbRouteExtensionId() string {
	if x != nil {
		return x.LbRouteExtensionId
	}
	return ""
}

func (x *CreateLbRouteExtensionRequest) GetLbRouteExtension() *LbRouteExtension {
	if x != nil {
		return x.LbRouteExtension
	}
	return nil
}

func (x *CreateLbRouteExtensionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating a `LbRouteExtension` resource.
type UpdateLbRouteExtensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Used to specify the fields to be overwritten in the
	// `LbRouteExtension` resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field is overwritten if it is in the mask. If the
	// user does not specify a mask, then all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. `LbRouteExtension` resource being updated.
	LbRouteExtension *LbRouteExtension `protobuf:"bytes,2,opt,name=lb_route_extension,json=lbRouteExtension,proto3" json:"lb_route_extension,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server can ignore
	// the request if it has already been completed. The server guarantees
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, ignores the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateLbRouteExtensionRequest) Reset() {
	*x = UpdateLbRouteExtensionRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateLbRouteExtensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLbRouteExtensionRequest) ProtoMessage() {}

func (x *UpdateLbRouteExtensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLbRouteExtensionRequest.ProtoReflect.Descriptor instead.
func (*UpdateLbRouteExtensionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateLbRouteExtensionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateLbRouteExtensionRequest) GetLbRouteExtension() *LbRouteExtension {
	if x != nil {
		return x.LbRouteExtension
	}
	return nil
}

func (x *UpdateLbRouteExtensionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a `LbRouteExtension` resource.
type DeleteLbRouteExtensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `LbRouteExtension` resource to delete. Must be in
	// the format
	// `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extension}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server can ignore
	// the request if it has already been completed. The server guarantees
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, ignores the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteLbRouteExtensionRequest) Reset() {
	*x = DeleteLbRouteExtensionRequest{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteLbRouteExtensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLbRouteExtensionRequest) ProtoMessage() {}

func (x *DeleteLbRouteExtensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLbRouteExtensionRequest.ProtoReflect.Descriptor instead.
func (*DeleteLbRouteExtensionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteLbRouteExtensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteLbRouteExtensionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Conditions under which this chain is invoked for a request.
type ExtensionChain_MatchCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A Common Expression Language (CEL) expression that is used to
	// match requests for which the extension chain is executed.
	//
	// For more information, see [CEL matcher language
	// reference](https://cloud.google.com/service-extensions/docs/cel-matcher-language-reference).
	CelExpression string `protobuf:"bytes,1,opt,name=cel_expression,json=celExpression,proto3" json:"cel_expression,omitempty"`
}

func (x *ExtensionChain_MatchCondition) Reset() {
	*x = ExtensionChain_MatchCondition{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtensionChain_MatchCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionChain_MatchCondition) ProtoMessage() {}

func (x *ExtensionChain_MatchCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionChain_MatchCondition.ProtoReflect.Descriptor instead.
func (*ExtensionChain_MatchCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ExtensionChain_MatchCondition) GetCelExpression() string {
	if x != nil {
		return x.CelExpression
	}
	return ""
}

// A single extension in the chain to execute for the matching request.
type ExtensionChain_Extension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name for this extension.
	// The name is logged as part of the HTTP request logs.
	// The name must conform with RFC-1034, is restricted to lower-cased
	// letters, numbers and hyphens, and can have a maximum length of 63
	// characters. Additionally, the first character must be a letter and the
	// last a letter or a number.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The `:authority` header in the gRPC request sent from Envoy
	// to the extension service.
	// Required for Callout extensions.
	Authority string `protobuf:"bytes,2,opt,name=authority,proto3" json:"authority,omitempty"`
	// Required. The reference to the service that runs the extension.
	//
	// Currently only callout extensions are supported here.
	//
	// To configure a callout extension, `service` must be a fully-qualified
	// reference
	// to a [backend
	// service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices)
	// in the format:
	// `https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}`
	// or
	// `https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}`.
	Service string `protobuf:"bytes,3,opt,name=service,proto3" json:"service,omitempty"`
	// Optional. A set of events during request or response processing for which
	// this extension is called. This field is required for the
	// `LbTrafficExtension` resource. It must not be set for the
	// `LbRouteExtension` resource.
	SupportedEvents []EventType `protobuf:"varint,4,rep,packed,name=supported_events,json=supportedEvents,proto3,enum=google.cloud.networkservices.v1.EventType" json:"supported_events,omitempty"`
	// Optional. Specifies the timeout for each individual message on the
	// stream. The timeout must be between 10-1000 milliseconds. Required for
	// Callout extensions.
	Timeout *durationpb.Duration `protobuf:"bytes,5,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Optional. Determines how the proxy behaves if the call to the extension
	// fails or times out.
	//
	// When set to `TRUE`, request or response processing continues without
	// error. Any subsequent extensions in the extension chain are also
	// executed. When set to `FALSE` or the default setting of `FALSE` is used,
	// one of the following happens:
	//
	// * If response headers have not been delivered to the downstream client,
	// a generic 500 error is returned to the client. The error response can be
	// tailored by configuring a custom error response in the load balancer.
	//
	// * If response headers have been delivered, then the HTTP stream to the
	// downstream client is reset.
	FailOpen bool `protobuf:"varint,6,opt,name=fail_open,json=failOpen,proto3" json:"fail_open,omitempty"`
	// Optional. List of the HTTP headers to forward to the extension
	// (from the client or backend). If omitted, all headers are sent.
	// Each element is a string indicating the header name.
	ForwardHeaders []string `protobuf:"bytes,7,rep,name=forward_headers,json=forwardHeaders,proto3" json:"forward_headers,omitempty"`
}

func (x *ExtensionChain_Extension) Reset() {
	*x = ExtensionChain_Extension{}
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtensionChain_Extension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionChain_Extension) ProtoMessage() {}

func (x *ExtensionChain_Extension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_dep_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionChain_Extension.ProtoReflect.Descriptor instead.
func (*ExtensionChain_Extension) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ExtensionChain_Extension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExtensionChain_Extension) GetAuthority() string {
	if x != nil {
		return x.Authority
	}
	return ""
}

func (x *ExtensionChain_Extension) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ExtensionChain_Extension) GetSupportedEvents() []EventType {
	if x != nil {
		return x.SupportedEvents
	}
	return nil
}

func (x *ExtensionChain_Extension) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *ExtensionChain_Extension) GetFailOpen() bool {
	if x != nil {
		return x.FailOpen
	}
	return false
}

func (x *ExtensionChain_Extension) GetForwardHeaders() []string {
	if x != nil {
		return x.ForwardHeaders
	}
	return nil
}

var File_google_cloud_networkservices_v1_dep_proto protoreflect.FileDescriptor

var file_google_cloud_networkservices_v1_dep_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x64, 0x65, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x84, 0x05,
	0x0a, 0x0e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x69, 0x6e,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6c, 0x0a, 0x0f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x68,
	0x61, 0x69, 0x6e, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3c, 0x0a, 0x0e, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x65, 0x6c,
	0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x65, 0x6c, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xcc, 0x02, 0x0a, 0x09, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x09,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x1d, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x5a,
	0x0a, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x0a, 0x07, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x66, 0x61, 0x69, 0x6c, 0x5f, 0x6f, 0x70, 0x65,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x66, 0x61,
	0x69, 0x6c, 0x4f, 0x70, 0x65, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x22, 0xe5, 0x06, 0x0a, 0x12, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x2e, 0x0a, 0x10, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x12, 0x5f, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68,
	0x61, 0x69, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x69, 0x6e,
	0x73, 0x12, 0x6d, 0x0a, 0x15, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x6c, 0x6f, 0x61,
	0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65,
	0x12, 0x38, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xb4, 0x01, 0xea, 0x41, 0xb0, 0x01, 0x0a, 0x31, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x62, 0x54,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x62,
	0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x7d, 0x2a, 0x13, 0x6c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x12, 0x6c, 0x62, 0x54, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf6, 0x01, 0x0a,
	0x1e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69,
	0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd4, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x62,
	0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x67, 0x0a, 0x15, 0x6c, 0x62, 0x5f,
	0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x62, 0x54, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6c,
	0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x6d, 0x0a, 0x1c,
	0x47, 0x65, 0x74, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x33, 0x0a, 0x31, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc8, 0x02, 0x0a, 0x1f,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69,
	0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x17, 0x6c, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x6c, 0x62, 0x54, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x6a,
	0x0a, 0x14, 0x6c, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69,
	0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b,
	0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xfb, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x6a, 0x0a, 0x14,
	0x6c, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x62, 0x54,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41,
	0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0x9c, 0x01, 0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c,
	0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01,
	0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xd7, 0x06, 0x0a, 0x10, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x08, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x10, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x6d, 0x0a, 0x15,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0xaa, 0x01, 0xea, 0x41, 0xa6, 0x01, 0x0a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x11, 0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x10, 0x6c, 0x62, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf2, 0x01,
	0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xcc, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x62, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a, 0x13, 0x6c, 0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x69, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xba, 0x02, 0x0a,
	0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x36, 0x0a, 0x15, 0x6c, 0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x12, 0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x64, 0x0a, 0x12, 0x6c, 0x62, 0x5f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6c, 0x62, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xf3, 0x01, 0x0a, 0x1d, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x64, 0x0a,
	0x12, 0x6c, 0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x62, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7,
	0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x98, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x2a, 0xa4, 0x01, 0x0a, 0x09, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f,
	0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x53, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x51,
	0x55, 0x45, 0x53, 0x54, 0x5f, 0x42, 0x4f, 0x44, 0x59, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x52,
	0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x53, 0x10,
	0x03, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x42, 0x4f,
	0x44, 0x59, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f,
	0x54, 0x52, 0x41, 0x49, 0x4c, 0x45, 0x52, 0x53, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45,
	0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x49, 0x4c, 0x45, 0x52, 0x53, 0x10,
	0x06, 0x2a, 0x68, 0x0a, 0x13, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69,
	0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x4c, 0x4f, 0x41, 0x44,
	0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x14, 0x0a, 0x10, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4d, 0x41, 0x4e, 0x41,
	0x47, 0x45, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41,
	0x4c, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x02, 0x32, 0xee, 0x14, 0x0a, 0x0a,
	0x44, 0x65, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe6, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x62, 0x54,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x62,
	0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0xd3, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4c, 0x62, 0x54, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39,
	0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb3, 0x02, 0x0a, 0x18, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c,
	0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb5, 0x01, 0xca, 0x41, 0x27, 0x0a, 0x12, 0x4c,
	0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x33, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x62,
	0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x2c, 0x6c, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f,
	0x3a, 0x14, 0x6c, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x62, 0x54, 0x72,
	0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0xb5, 0x02, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x01,
	0xca, 0x41, 0x27, 0x0a, 0x12, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x20, 0x6c, 0x62, 0x5f,
	0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x64, 0x3a, 0x14, 0x6c, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6c, 0x62, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf0, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x62, 0x54,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x62, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xde, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x62, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xcb, 0x01, 0x0a, 0x13,
	0x47, 0x65, 0x74, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa5, 0x02, 0x0a, 0x16, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xab, 0x01, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x4c, 0x62, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x6c, 0x62, 0x5f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x12, 0x6c, 0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0xa7, 0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01, 0xca, 0x41,
	0x25, 0x0a, 0x10, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1e, 0x6c, 0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x3a, 0x12, 0x6c,
	0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x32, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6c, 0x62, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x16,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c,
	0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x62, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe9, 0x01, 0x0a,
	0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x42, 0x08, 0x44, 0x65, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0xaa,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkservices_v1_dep_proto_rawDescOnce sync.Once
	file_google_cloud_networkservices_v1_dep_proto_rawDescData = file_google_cloud_networkservices_v1_dep_proto_rawDesc
)

func file_google_cloud_networkservices_v1_dep_proto_rawDescGZIP() []byte {
	file_google_cloud_networkservices_v1_dep_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkservices_v1_dep_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkservices_v1_dep_proto_rawDescData)
	})
	return file_google_cloud_networkservices_v1_dep_proto_rawDescData
}

var file_google_cloud_networkservices_v1_dep_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_networkservices_v1_dep_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_cloud_networkservices_v1_dep_proto_goTypes = []any{
	(EventType)(0),                          // 0: google.cloud.networkservices.v1.EventType
	(LoadBalancingScheme)(0),                // 1: google.cloud.networkservices.v1.LoadBalancingScheme
	(*ExtensionChain)(nil),                  // 2: google.cloud.networkservices.v1.ExtensionChain
	(*LbTrafficExtension)(nil),              // 3: google.cloud.networkservices.v1.LbTrafficExtension
	(*ListLbTrafficExtensionsRequest)(nil),  // 4: google.cloud.networkservices.v1.ListLbTrafficExtensionsRequest
	(*ListLbTrafficExtensionsResponse)(nil), // 5: google.cloud.networkservices.v1.ListLbTrafficExtensionsResponse
	(*GetLbTrafficExtensionRequest)(nil),    // 6: google.cloud.networkservices.v1.GetLbTrafficExtensionRequest
	(*CreateLbTrafficExtensionRequest)(nil), // 7: google.cloud.networkservices.v1.CreateLbTrafficExtensionRequest
	(*UpdateLbTrafficExtensionRequest)(nil), // 8: google.cloud.networkservices.v1.UpdateLbTrafficExtensionRequest
	(*DeleteLbTrafficExtensionRequest)(nil), // 9: google.cloud.networkservices.v1.DeleteLbTrafficExtensionRequest
	(*LbRouteExtension)(nil),                // 10: google.cloud.networkservices.v1.LbRouteExtension
	(*ListLbRouteExtensionsRequest)(nil),    // 11: google.cloud.networkservices.v1.ListLbRouteExtensionsRequest
	(*ListLbRouteExtensionsResponse)(nil),   // 12: google.cloud.networkservices.v1.ListLbRouteExtensionsResponse
	(*GetLbRouteExtensionRequest)(nil),      // 13: google.cloud.networkservices.v1.GetLbRouteExtensionRequest
	(*CreateLbRouteExtensionRequest)(nil),   // 14: google.cloud.networkservices.v1.CreateLbRouteExtensionRequest
	(*UpdateLbRouteExtensionRequest)(nil),   // 15: google.cloud.networkservices.v1.UpdateLbRouteExtensionRequest
	(*DeleteLbRouteExtensionRequest)(nil),   // 16: google.cloud.networkservices.v1.DeleteLbRouteExtensionRequest
	(*ExtensionChain_MatchCondition)(nil),   // 17: google.cloud.networkservices.v1.ExtensionChain.MatchCondition
	(*ExtensionChain_Extension)(nil),        // 18: google.cloud.networkservices.v1.ExtensionChain.Extension
	nil,                                     // 19: google.cloud.networkservices.v1.LbTrafficExtension.LabelsEntry
	nil,                                     // 20: google.cloud.networkservices.v1.LbRouteExtension.LabelsEntry
	(*timestamppb.Timestamp)(nil),           // 21: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                 // 22: google.protobuf.Struct
	(*fieldmaskpb.FieldMask)(nil),           // 23: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),             // 24: google.protobuf.Duration
	(*longrunningpb.Operation)(nil),         // 25: google.longrunning.Operation
}
var file_google_cloud_networkservices_v1_dep_proto_depIdxs = []int32{
	17, // 0: google.cloud.networkservices.v1.ExtensionChain.match_condition:type_name -> google.cloud.networkservices.v1.ExtensionChain.MatchCondition
	18, // 1: google.cloud.networkservices.v1.ExtensionChain.extensions:type_name -> google.cloud.networkservices.v1.ExtensionChain.Extension
	21, // 2: google.cloud.networkservices.v1.LbTrafficExtension.create_time:type_name -> google.protobuf.Timestamp
	21, // 3: google.cloud.networkservices.v1.LbTrafficExtension.update_time:type_name -> google.protobuf.Timestamp
	19, // 4: google.cloud.networkservices.v1.LbTrafficExtension.labels:type_name -> google.cloud.networkservices.v1.LbTrafficExtension.LabelsEntry
	2,  // 5: google.cloud.networkservices.v1.LbTrafficExtension.extension_chains:type_name -> google.cloud.networkservices.v1.ExtensionChain
	1,  // 6: google.cloud.networkservices.v1.LbTrafficExtension.load_balancing_scheme:type_name -> google.cloud.networkservices.v1.LoadBalancingScheme
	22, // 7: google.cloud.networkservices.v1.LbTrafficExtension.metadata:type_name -> google.protobuf.Struct
	3,  // 8: google.cloud.networkservices.v1.ListLbTrafficExtensionsResponse.lb_traffic_extensions:type_name -> google.cloud.networkservices.v1.LbTrafficExtension
	3,  // 9: google.cloud.networkservices.v1.CreateLbTrafficExtensionRequest.lb_traffic_extension:type_name -> google.cloud.networkservices.v1.LbTrafficExtension
	23, // 10: google.cloud.networkservices.v1.UpdateLbTrafficExtensionRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 11: google.cloud.networkservices.v1.UpdateLbTrafficExtensionRequest.lb_traffic_extension:type_name -> google.cloud.networkservices.v1.LbTrafficExtension
	21, // 12: google.cloud.networkservices.v1.LbRouteExtension.create_time:type_name -> google.protobuf.Timestamp
	21, // 13: google.cloud.networkservices.v1.LbRouteExtension.update_time:type_name -> google.protobuf.Timestamp
	20, // 14: google.cloud.networkservices.v1.LbRouteExtension.labels:type_name -> google.cloud.networkservices.v1.LbRouteExtension.LabelsEntry
	2,  // 15: google.cloud.networkservices.v1.LbRouteExtension.extension_chains:type_name -> google.cloud.networkservices.v1.ExtensionChain
	1,  // 16: google.cloud.networkservices.v1.LbRouteExtension.load_balancing_scheme:type_name -> google.cloud.networkservices.v1.LoadBalancingScheme
	22, // 17: google.cloud.networkservices.v1.LbRouteExtension.metadata:type_name -> google.protobuf.Struct
	10, // 18: google.cloud.networkservices.v1.ListLbRouteExtensionsResponse.lb_route_extensions:type_name -> google.cloud.networkservices.v1.LbRouteExtension
	10, // 19: google.cloud.networkservices.v1.CreateLbRouteExtensionRequest.lb_route_extension:type_name -> google.cloud.networkservices.v1.LbRouteExtension
	23, // 20: google.cloud.networkservices.v1.UpdateLbRouteExtensionRequest.update_mask:type_name -> google.protobuf.FieldMask
	10, // 21: google.cloud.networkservices.v1.UpdateLbRouteExtensionRequest.lb_route_extension:type_name -> google.cloud.networkservices.v1.LbRouteExtension
	0,  // 22: google.cloud.networkservices.v1.ExtensionChain.Extension.supported_events:type_name -> google.cloud.networkservices.v1.EventType
	24, // 23: google.cloud.networkservices.v1.ExtensionChain.Extension.timeout:type_name -> google.protobuf.Duration
	4,  // 24: google.cloud.networkservices.v1.DepService.ListLbTrafficExtensions:input_type -> google.cloud.networkservices.v1.ListLbTrafficExtensionsRequest
	6,  // 25: google.cloud.networkservices.v1.DepService.GetLbTrafficExtension:input_type -> google.cloud.networkservices.v1.GetLbTrafficExtensionRequest
	7,  // 26: google.cloud.networkservices.v1.DepService.CreateLbTrafficExtension:input_type -> google.cloud.networkservices.v1.CreateLbTrafficExtensionRequest
	8,  // 27: google.cloud.networkservices.v1.DepService.UpdateLbTrafficExtension:input_type -> google.cloud.networkservices.v1.UpdateLbTrafficExtensionRequest
	9,  // 28: google.cloud.networkservices.v1.DepService.DeleteLbTrafficExtension:input_type -> google.cloud.networkservices.v1.DeleteLbTrafficExtensionRequest
	11, // 29: google.cloud.networkservices.v1.DepService.ListLbRouteExtensions:input_type -> google.cloud.networkservices.v1.ListLbRouteExtensionsRequest
	13, // 30: google.cloud.networkservices.v1.DepService.GetLbRouteExtension:input_type -> google.cloud.networkservices.v1.GetLbRouteExtensionRequest
	14, // 31: google.cloud.networkservices.v1.DepService.CreateLbRouteExtension:input_type -> google.cloud.networkservices.v1.CreateLbRouteExtensionRequest
	15, // 32: google.cloud.networkservices.v1.DepService.UpdateLbRouteExtension:input_type -> google.cloud.networkservices.v1.UpdateLbRouteExtensionRequest
	16, // 33: google.cloud.networkservices.v1.DepService.DeleteLbRouteExtension:input_type -> google.cloud.networkservices.v1.DeleteLbRouteExtensionRequest
	5,  // 34: google.cloud.networkservices.v1.DepService.ListLbTrafficExtensions:output_type -> google.cloud.networkservices.v1.ListLbTrafficExtensionsResponse
	3,  // 35: google.cloud.networkservices.v1.DepService.GetLbTrafficExtension:output_type -> google.cloud.networkservices.v1.LbTrafficExtension
	25, // 36: google.cloud.networkservices.v1.DepService.CreateLbTrafficExtension:output_type -> google.longrunning.Operation
	25, // 37: google.cloud.networkservices.v1.DepService.UpdateLbTrafficExtension:output_type -> google.longrunning.Operation
	25, // 38: google.cloud.networkservices.v1.DepService.DeleteLbTrafficExtension:output_type -> google.longrunning.Operation
	12, // 39: google.cloud.networkservices.v1.DepService.ListLbRouteExtensions:output_type -> google.cloud.networkservices.v1.ListLbRouteExtensionsResponse
	10, // 40: google.cloud.networkservices.v1.DepService.GetLbRouteExtension:output_type -> google.cloud.networkservices.v1.LbRouteExtension
	25, // 41: google.cloud.networkservices.v1.DepService.CreateLbRouteExtension:output_type -> google.longrunning.Operation
	25, // 42: google.cloud.networkservices.v1.DepService.UpdateLbRouteExtension:output_type -> google.longrunning.Operation
	25, // 43: google.cloud.networkservices.v1.DepService.DeleteLbRouteExtension:output_type -> google.longrunning.Operation
	34, // [34:44] is the sub-list for method output_type
	24, // [24:34] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_cloud_networkservices_v1_dep_proto_init() }
func file_google_cloud_networkservices_v1_dep_proto_init() {
	if File_google_cloud_networkservices_v1_dep_proto != nil {
		return
	}
	file_google_cloud_networkservices_v1_common_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkservices_v1_dep_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_networkservices_v1_dep_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkservices_v1_dep_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkservices_v1_dep_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkservices_v1_dep_proto_msgTypes,
	}.Build()
	File_google_cloud_networkservices_v1_dep_proto = out.File
	file_google_cloud_networkservices_v1_dep_proto_rawDesc = nil
	file_google_cloud_networkservices_v1_dep_proto_goTypes = nil
	file_google_cloud_networkservices_v1_dep_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DepServiceClient is the client API for DepService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DepServiceClient interface {
	// Lists `LbTrafficExtension` resources in a given project and location.
	ListLbTrafficExtensions(ctx context.Context, in *ListLbTrafficExtensionsRequest, opts ...grpc.CallOption) (*ListLbTrafficExtensionsResponse, error)
	// Gets details of the specified `LbTrafficExtension` resource.
	GetLbTrafficExtension(ctx context.Context, in *GetLbTrafficExtensionRequest, opts ...grpc.CallOption) (*LbTrafficExtension, error)
	// Creates a new `LbTrafficExtension` resource in a given project and
	// location.
	CreateLbTrafficExtension(ctx context.Context, in *CreateLbTrafficExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of the specified `LbTrafficExtension` resource.
	UpdateLbTrafficExtension(ctx context.Context, in *UpdateLbTrafficExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified `LbTrafficExtension` resource.
	DeleteLbTrafficExtension(ctx context.Context, in *DeleteLbTrafficExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists `LbRouteExtension` resources in a given project and location.
	ListLbRouteExtensions(ctx context.Context, in *ListLbRouteExtensionsRequest, opts ...grpc.CallOption) (*ListLbRouteExtensionsResponse, error)
	// Gets details of the specified `LbRouteExtension` resource.
	GetLbRouteExtension(ctx context.Context, in *GetLbRouteExtensionRequest, opts ...grpc.CallOption) (*LbRouteExtension, error)
	// Creates a new `LbRouteExtension` resource in a given project and location.
	CreateLbRouteExtension(ctx context.Context, in *CreateLbRouteExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of the specified `LbRouteExtension` resource.
	UpdateLbRouteExtension(ctx context.Context, in *UpdateLbRouteExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified `LbRouteExtension` resource.
	DeleteLbRouteExtension(ctx context.Context, in *DeleteLbRouteExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type depServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDepServiceClient(cc grpc.ClientConnInterface) DepServiceClient {
	return &depServiceClient{cc}
}

func (c *depServiceClient) ListLbTrafficExtensions(ctx context.Context, in *ListLbTrafficExtensionsRequest, opts ...grpc.CallOption) (*ListLbTrafficExtensionsResponse, error) {
	out := new(ListLbTrafficExtensionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/ListLbTrafficExtensions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *depServiceClient) GetLbTrafficExtension(ctx context.Context, in *GetLbTrafficExtensionRequest, opts ...grpc.CallOption) (*LbTrafficExtension, error) {
	out := new(LbTrafficExtension)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/GetLbTrafficExtension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *depServiceClient) CreateLbTrafficExtension(ctx context.Context, in *CreateLbTrafficExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/CreateLbTrafficExtension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *depServiceClient) UpdateLbTrafficExtension(ctx context.Context, in *UpdateLbTrafficExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/UpdateLbTrafficExtension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *depServiceClient) DeleteLbTrafficExtension(ctx context.Context, in *DeleteLbTrafficExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/DeleteLbTrafficExtension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *depServiceClient) ListLbRouteExtensions(ctx context.Context, in *ListLbRouteExtensionsRequest, opts ...grpc.CallOption) (*ListLbRouteExtensionsResponse, error) {
	out := new(ListLbRouteExtensionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/ListLbRouteExtensions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *depServiceClient) GetLbRouteExtension(ctx context.Context, in *GetLbRouteExtensionRequest, opts ...grpc.CallOption) (*LbRouteExtension, error) {
	out := new(LbRouteExtension)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/GetLbRouteExtension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *depServiceClient) CreateLbRouteExtension(ctx context.Context, in *CreateLbRouteExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/CreateLbRouteExtension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *depServiceClient) UpdateLbRouteExtension(ctx context.Context, in *UpdateLbRouteExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/UpdateLbRouteExtension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *depServiceClient) DeleteLbRouteExtension(ctx context.Context, in *DeleteLbRouteExtensionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkservices.v1.DepService/DeleteLbRouteExtension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DepServiceServer is the server API for DepService service.
type DepServiceServer interface {
	// Lists `LbTrafficExtension` resources in a given project and location.
	ListLbTrafficExtensions(context.Context, *ListLbTrafficExtensionsRequest) (*ListLbTrafficExtensionsResponse, error)
	// Gets details of the specified `LbTrafficExtension` resource.
	GetLbTrafficExtension(context.Context, *GetLbTrafficExtensionRequest) (*LbTrafficExtension, error)
	// Creates a new `LbTrafficExtension` resource in a given project and
	// location.
	CreateLbTrafficExtension(context.Context, *CreateLbTrafficExtensionRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of the specified `LbTrafficExtension` resource.
	UpdateLbTrafficExtension(context.Context, *UpdateLbTrafficExtensionRequest) (*longrunningpb.Operation, error)
	// Deletes the specified `LbTrafficExtension` resource.
	DeleteLbTrafficExtension(context.Context, *DeleteLbTrafficExtensionRequest) (*longrunningpb.Operation, error)
	// Lists `LbRouteExtension` resources in a given project and location.
	ListLbRouteExtensions(context.Context, *ListLbRouteExtensionsRequest) (*ListLbRouteExtensionsResponse, error)
	// Gets details of the specified `LbRouteExtension` resource.
	GetLbRouteExtension(context.Context, *GetLbRouteExtensionRequest) (*LbRouteExtension, error)
	// Creates a new `LbRouteExtension` resource in a given project and location.
	CreateLbRouteExtension(context.Context, *CreateLbRouteExtensionRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of the specified `LbRouteExtension` resource.
	UpdateLbRouteExtension(context.Context, *UpdateLbRouteExtensionRequest) (*longrunningpb.Operation, error)
	// Deletes the specified `LbRouteExtension` resource.
	DeleteLbRouteExtension(context.Context, *DeleteLbRouteExtensionRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDepServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDepServiceServer struct {
}

func (*UnimplementedDepServiceServer) ListLbTrafficExtensions(context.Context, *ListLbTrafficExtensionsRequest) (*ListLbTrafficExtensionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLbTrafficExtensions not implemented")
}
func (*UnimplementedDepServiceServer) GetLbTrafficExtension(context.Context, *GetLbTrafficExtensionRequest) (*LbTrafficExtension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLbTrafficExtension not implemented")
}
func (*UnimplementedDepServiceServer) CreateLbTrafficExtension(context.Context, *CreateLbTrafficExtensionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLbTrafficExtension not implemented")
}
func (*UnimplementedDepServiceServer) UpdateLbTrafficExtension(context.Context, *UpdateLbTrafficExtensionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLbTrafficExtension not implemented")
}
func (*UnimplementedDepServiceServer) DeleteLbTrafficExtension(context.Context, *DeleteLbTrafficExtensionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLbTrafficExtension not implemented")
}
func (*UnimplementedDepServiceServer) ListLbRouteExtensions(context.Context, *ListLbRouteExtensionsRequest) (*ListLbRouteExtensionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLbRouteExtensions not implemented")
}
func (*UnimplementedDepServiceServer) GetLbRouteExtension(context.Context, *GetLbRouteExtensionRequest) (*LbRouteExtension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLbRouteExtension not implemented")
}
func (*UnimplementedDepServiceServer) CreateLbRouteExtension(context.Context, *CreateLbRouteExtensionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLbRouteExtension not implemented")
}
func (*UnimplementedDepServiceServer) UpdateLbRouteExtension(context.Context, *UpdateLbRouteExtensionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLbRouteExtension not implemented")
}
func (*UnimplementedDepServiceServer) DeleteLbRouteExtension(context.Context, *DeleteLbRouteExtensionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLbRouteExtension not implemented")
}

func RegisterDepServiceServer(s *grpc.Server, srv DepServiceServer) {
	s.RegisterService(&_DepService_serviceDesc, srv)
}

func _DepService_ListLbTrafficExtensions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLbTrafficExtensionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).ListLbTrafficExtensions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/ListLbTrafficExtensions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).ListLbTrafficExtensions(ctx, req.(*ListLbTrafficExtensionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DepService_GetLbTrafficExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLbTrafficExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).GetLbTrafficExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/GetLbTrafficExtension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).GetLbTrafficExtension(ctx, req.(*GetLbTrafficExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DepService_CreateLbTrafficExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLbTrafficExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).CreateLbTrafficExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/CreateLbTrafficExtension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).CreateLbTrafficExtension(ctx, req.(*CreateLbTrafficExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DepService_UpdateLbTrafficExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLbTrafficExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).UpdateLbTrafficExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/UpdateLbTrafficExtension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).UpdateLbTrafficExtension(ctx, req.(*UpdateLbTrafficExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DepService_DeleteLbTrafficExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLbTrafficExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).DeleteLbTrafficExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/DeleteLbTrafficExtension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).DeleteLbTrafficExtension(ctx, req.(*DeleteLbTrafficExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DepService_ListLbRouteExtensions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLbRouteExtensionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).ListLbRouteExtensions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/ListLbRouteExtensions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).ListLbRouteExtensions(ctx, req.(*ListLbRouteExtensionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DepService_GetLbRouteExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLbRouteExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).GetLbRouteExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/GetLbRouteExtension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).GetLbRouteExtension(ctx, req.(*GetLbRouteExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DepService_CreateLbRouteExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLbRouteExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).CreateLbRouteExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/CreateLbRouteExtension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).CreateLbRouteExtension(ctx, req.(*CreateLbRouteExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DepService_UpdateLbRouteExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLbRouteExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).UpdateLbRouteExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/UpdateLbRouteExtension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).UpdateLbRouteExtension(ctx, req.(*UpdateLbRouteExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DepService_DeleteLbRouteExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLbRouteExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DepServiceServer).DeleteLbRouteExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkservices.v1.DepService/DeleteLbRouteExtension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DepServiceServer).DeleteLbRouteExtension(ctx, req.(*DeleteLbRouteExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DepService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkservices.v1.DepService",
	HandlerType: (*DepServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListLbTrafficExtensions",
			Handler:    _DepService_ListLbTrafficExtensions_Handler,
		},
		{
			MethodName: "GetLbTrafficExtension",
			Handler:    _DepService_GetLbTrafficExtension_Handler,
		},
		{
			MethodName: "CreateLbTrafficExtension",
			Handler:    _DepService_CreateLbTrafficExtension_Handler,
		},
		{
			MethodName: "UpdateLbTrafficExtension",
			Handler:    _DepService_UpdateLbTrafficExtension_Handler,
		},
		{
			MethodName: "DeleteLbTrafficExtension",
			Handler:    _DepService_DeleteLbTrafficExtension_Handler,
		},
		{
			MethodName: "ListLbRouteExtensions",
			Handler:    _DepService_ListLbRouteExtensions_Handler,
		},
		{
			MethodName: "GetLbRouteExtension",
			Handler:    _DepService_GetLbRouteExtension_Handler,
		},
		{
			MethodName: "CreateLbRouteExtension",
			Handler:    _DepService_CreateLbRouteExtension_Handler,
		},
		{
			MethodName: "UpdateLbRouteExtension",
			Handler:    _DepService_UpdateLbRouteExtension_Handler,
		},
		{
			MethodName: "DeleteLbRouteExtension",
			Handler:    _DepService_DeleteLbRouteExtension_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkservices/v1/dep.proto",
}
