// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package gkemulticloud

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"
	"time"

	gkemulticloudpb "cloud.google.com/go/gkemulticloud/apiv1/gkemulticloudpb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newAttachedClustersClientHook clientHook

// AttachedClustersCallOptions contains the retry settings for each method of AttachedClustersClient.
type AttachedClustersCallOptions struct {
	CreateAttachedCluster                  []gax.CallOption
	UpdateAttachedCluster                  []gax.CallOption
	ImportAttachedCluster                  []gax.CallOption
	GetAttachedCluster                     []gax.CallOption
	ListAttachedClusters                   []gax.CallOption
	DeleteAttachedCluster                  []gax.CallOption
	GetAttachedServerConfig                []gax.CallOption
	GenerateAttachedClusterInstallManifest []gax.CallOption
	GenerateAttachedClusterAgentToken      []gax.CallOption
	CancelOperation                        []gax.CallOption
	DeleteOperation                        []gax.CallOption
	GetOperation                           []gax.CallOption
	ListOperations                         []gax.CallOption
}

func defaultAttachedClustersGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("gkemulticloud.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("gkemulticloud.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("gkemulticloud.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://gkemulticloud.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAttachedClustersCallOptions() *AttachedClustersCallOptions {
	return &AttachedClustersCallOptions{
		CreateAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ImportAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAttachedClusters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteAttachedCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAttachedServerConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GenerateAttachedClusterInstallManifest: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GenerateAttachedClusterAgentToken: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalAttachedClustersClient is an interface that defines the methods available from GKE Multi-Cloud API.
type internalAttachedClustersClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateAttachedCluster(context.Context, *gkemulticloudpb.CreateAttachedClusterRequest, ...gax.CallOption) (*CreateAttachedClusterOperation, error)
	CreateAttachedClusterOperation(name string) *CreateAttachedClusterOperation
	UpdateAttachedCluster(context.Context, *gkemulticloudpb.UpdateAttachedClusterRequest, ...gax.CallOption) (*UpdateAttachedClusterOperation, error)
	UpdateAttachedClusterOperation(name string) *UpdateAttachedClusterOperation
	ImportAttachedCluster(context.Context, *gkemulticloudpb.ImportAttachedClusterRequest, ...gax.CallOption) (*ImportAttachedClusterOperation, error)
	ImportAttachedClusterOperation(name string) *ImportAttachedClusterOperation
	GetAttachedCluster(context.Context, *gkemulticloudpb.GetAttachedClusterRequest, ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error)
	ListAttachedClusters(context.Context, *gkemulticloudpb.ListAttachedClustersRequest, ...gax.CallOption) *AttachedClusterIterator
	DeleteAttachedCluster(context.Context, *gkemulticloudpb.DeleteAttachedClusterRequest, ...gax.CallOption) (*DeleteAttachedClusterOperation, error)
	DeleteAttachedClusterOperation(name string) *DeleteAttachedClusterOperation
	GetAttachedServerConfig(context.Context, *gkemulticloudpb.GetAttachedServerConfigRequest, ...gax.CallOption) (*gkemulticloudpb.AttachedServerConfig, error)
	GenerateAttachedClusterInstallManifest(context.Context, *gkemulticloudpb.GenerateAttachedClusterInstallManifestRequest, ...gax.CallOption) (*gkemulticloudpb.GenerateAttachedClusterInstallManifestResponse, error)
	GenerateAttachedClusterAgentToken(context.Context, *gkemulticloudpb.GenerateAttachedClusterAgentTokenRequest, ...gax.CallOption) (*gkemulticloudpb.GenerateAttachedClusterAgentTokenResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// AttachedClustersClient is a client for interacting with GKE Multi-Cloud API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The AttachedClusters API provides a single centrally managed service
// to register and manage Anthos attached clusters that run on customer’s owned
// infrastructure.
type AttachedClustersClient struct {
	// The internal transport-dependent client.
	internalClient internalAttachedClustersClient

	// The call options for this service.
	CallOptions *AttachedClustersCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AttachedClustersClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AttachedClustersClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *AttachedClustersClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateAttachedCluster creates a new
// AttachedCluster resource
// on a given Google Cloud Platform project and region.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AttachedClustersClient) CreateAttachedCluster(ctx context.Context, req *gkemulticloudpb.CreateAttachedClusterRequest, opts ...gax.CallOption) (*CreateAttachedClusterOperation, error) {
	return c.internalClient.CreateAttachedCluster(ctx, req, opts...)
}

// CreateAttachedClusterOperation returns a new CreateAttachedClusterOperation from a given name.
// The name must be that of a previously created CreateAttachedClusterOperation, possibly from a different process.
func (c *AttachedClustersClient) CreateAttachedClusterOperation(name string) *CreateAttachedClusterOperation {
	return c.internalClient.CreateAttachedClusterOperation(name)
}

// UpdateAttachedCluster updates an
// AttachedCluster.
func (c *AttachedClustersClient) UpdateAttachedCluster(ctx context.Context, req *gkemulticloudpb.UpdateAttachedClusterRequest, opts ...gax.CallOption) (*UpdateAttachedClusterOperation, error) {
	return c.internalClient.UpdateAttachedCluster(ctx, req, opts...)
}

// UpdateAttachedClusterOperation returns a new UpdateAttachedClusterOperation from a given name.
// The name must be that of a previously created UpdateAttachedClusterOperation, possibly from a different process.
func (c *AttachedClustersClient) UpdateAttachedClusterOperation(name string) *UpdateAttachedClusterOperation {
	return c.internalClient.UpdateAttachedClusterOperation(name)
}

// ImportAttachedCluster imports creates a new
// AttachedCluster resource
// by importing an existing Fleet Membership resource.
//
// Attached Clusters created before the introduction of the Anthos Multi-Cloud
// API can be imported through this method.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AttachedClustersClient) ImportAttachedCluster(ctx context.Context, req *gkemulticloudpb.ImportAttachedClusterRequest, opts ...gax.CallOption) (*ImportAttachedClusterOperation, error) {
	return c.internalClient.ImportAttachedCluster(ctx, req, opts...)
}

// ImportAttachedClusterOperation returns a new ImportAttachedClusterOperation from a given name.
// The name must be that of a previously created ImportAttachedClusterOperation, possibly from a different process.
func (c *AttachedClustersClient) ImportAttachedClusterOperation(name string) *ImportAttachedClusterOperation {
	return c.internalClient.ImportAttachedClusterOperation(name)
}

// GetAttachedCluster describes a specific
// AttachedCluster resource.
func (c *AttachedClustersClient) GetAttachedCluster(ctx context.Context, req *gkemulticloudpb.GetAttachedClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	return c.internalClient.GetAttachedCluster(ctx, req, opts...)
}

// ListAttachedClusters lists all AttachedCluster
// resources on a given Google Cloud project and region.
func (c *AttachedClustersClient) ListAttachedClusters(ctx context.Context, req *gkemulticloudpb.ListAttachedClustersRequest, opts ...gax.CallOption) *AttachedClusterIterator {
	return c.internalClient.ListAttachedClusters(ctx, req, opts...)
}

// DeleteAttachedCluster deletes a specific
// AttachedCluster resource.
//
// If successful, the response contains a newly created
// Operation resource that can be
// described to track the status of the operation.
func (c *AttachedClustersClient) DeleteAttachedCluster(ctx context.Context, req *gkemulticloudpb.DeleteAttachedClusterRequest, opts ...gax.CallOption) (*DeleteAttachedClusterOperation, error) {
	return c.internalClient.DeleteAttachedCluster(ctx, req, opts...)
}

// DeleteAttachedClusterOperation returns a new DeleteAttachedClusterOperation from a given name.
// The name must be that of a previously created DeleteAttachedClusterOperation, possibly from a different process.
func (c *AttachedClustersClient) DeleteAttachedClusterOperation(name string) *DeleteAttachedClusterOperation {
	return c.internalClient.DeleteAttachedClusterOperation(name)
}

// GetAttachedServerConfig returns information, such as supported Kubernetes versions, on a given
// Google Cloud location.
func (c *AttachedClustersClient) GetAttachedServerConfig(ctx context.Context, req *gkemulticloudpb.GetAttachedServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AttachedServerConfig, error) {
	return c.internalClient.GetAttachedServerConfig(ctx, req, opts...)
}

// GenerateAttachedClusterInstallManifest generates the install manifest to be installed on the target cluster.
func (c *AttachedClustersClient) GenerateAttachedClusterInstallManifest(ctx context.Context, req *gkemulticloudpb.GenerateAttachedClusterInstallManifestRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAttachedClusterInstallManifestResponse, error) {
	return c.internalClient.GenerateAttachedClusterInstallManifest(ctx, req, opts...)
}

// GenerateAttachedClusterAgentToken generates an access token for a cluster agent.
func (c *AttachedClustersClient) GenerateAttachedClusterAgentToken(ctx context.Context, req *gkemulticloudpb.GenerateAttachedClusterAgentTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAttachedClusterAgentTokenResponse, error) {
	return c.internalClient.GenerateAttachedClusterAgentToken(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *AttachedClustersClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *AttachedClustersClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *AttachedClustersClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *AttachedClustersClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// attachedClustersGRPCClient is a client for interacting with GKE Multi-Cloud API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type attachedClustersGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing AttachedClustersClient
	CallOptions **AttachedClustersCallOptions

	// The gRPC API client.
	attachedClustersClient gkemulticloudpb.AttachedClustersClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewAttachedClustersClient creates a new attached clusters client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The AttachedClusters API provides a single centrally managed service
// to register and manage Anthos attached clusters that run on customer’s owned
// infrastructure.
func NewAttachedClustersClient(ctx context.Context, opts ...option.ClientOption) (*AttachedClustersClient, error) {
	clientOpts := defaultAttachedClustersGRPCClientOptions()
	if newAttachedClustersClientHook != nil {
		hookOpts, err := newAttachedClustersClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AttachedClustersClient{CallOptions: defaultAttachedClustersCallOptions()}

	c := &attachedClustersGRPCClient{
		connPool:               connPool,
		attachedClustersClient: gkemulticloudpb.NewAttachedClustersClient(connPool),
		CallOptions:            &client.CallOptions,
		logger:                 internaloption.GetLogger(opts),
		operationsClient:       longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *attachedClustersGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *attachedClustersGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *attachedClustersGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *attachedClustersGRPCClient) CreateAttachedCluster(ctx context.Context, req *gkemulticloudpb.CreateAttachedClusterRequest, opts ...gax.CallOption) (*CreateAttachedClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateAttachedCluster[0:len((*c.CallOptions).CreateAttachedCluster):len((*c.CallOptions).CreateAttachedCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.attachedClustersClient.CreateAttachedCluster, req, settings.GRPC, c.logger, "CreateAttachedCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *attachedClustersGRPCClient) UpdateAttachedCluster(ctx context.Context, req *gkemulticloudpb.UpdateAttachedClusterRequest, opts ...gax.CallOption) (*UpdateAttachedClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "attached_cluster.name", url.QueryEscape(req.GetAttachedCluster().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAttachedCluster[0:len((*c.CallOptions).UpdateAttachedCluster):len((*c.CallOptions).UpdateAttachedCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.attachedClustersClient.UpdateAttachedCluster, req, settings.GRPC, c.logger, "UpdateAttachedCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *attachedClustersGRPCClient) ImportAttachedCluster(ctx context.Context, req *gkemulticloudpb.ImportAttachedClusterRequest, opts ...gax.CallOption) (*ImportAttachedClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ImportAttachedCluster[0:len((*c.CallOptions).ImportAttachedCluster):len((*c.CallOptions).ImportAttachedCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.attachedClustersClient.ImportAttachedCluster, req, settings.GRPC, c.logger, "ImportAttachedCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ImportAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *attachedClustersGRPCClient) GetAttachedCluster(ctx context.Context, req *gkemulticloudpb.GetAttachedClusterRequest, opts ...gax.CallOption) (*gkemulticloudpb.AttachedCluster, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAttachedCluster[0:len((*c.CallOptions).GetAttachedCluster):len((*c.CallOptions).GetAttachedCluster)], opts...)
	var resp *gkemulticloudpb.AttachedCluster
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.attachedClustersClient.GetAttachedCluster, req, settings.GRPC, c.logger, "GetAttachedCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *attachedClustersGRPCClient) ListAttachedClusters(ctx context.Context, req *gkemulticloudpb.ListAttachedClustersRequest, opts ...gax.CallOption) *AttachedClusterIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAttachedClusters[0:len((*c.CallOptions).ListAttachedClusters):len((*c.CallOptions).ListAttachedClusters)], opts...)
	it := &AttachedClusterIterator{}
	req = proto.Clone(req).(*gkemulticloudpb.ListAttachedClustersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gkemulticloudpb.AttachedCluster, string, error) {
		resp := &gkemulticloudpb.ListAttachedClustersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.attachedClustersClient.ListAttachedClusters, req, settings.GRPC, c.logger, "ListAttachedClusters")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAttachedClusters(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *attachedClustersGRPCClient) DeleteAttachedCluster(ctx context.Context, req *gkemulticloudpb.DeleteAttachedClusterRequest, opts ...gax.CallOption) (*DeleteAttachedClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAttachedCluster[0:len((*c.CallOptions).DeleteAttachedCluster):len((*c.CallOptions).DeleteAttachedCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.attachedClustersClient.DeleteAttachedCluster, req, settings.GRPC, c.logger, "DeleteAttachedCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *attachedClustersGRPCClient) GetAttachedServerConfig(ctx context.Context, req *gkemulticloudpb.GetAttachedServerConfigRequest, opts ...gax.CallOption) (*gkemulticloudpb.AttachedServerConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAttachedServerConfig[0:len((*c.CallOptions).GetAttachedServerConfig):len((*c.CallOptions).GetAttachedServerConfig)], opts...)
	var resp *gkemulticloudpb.AttachedServerConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.attachedClustersClient.GetAttachedServerConfig, req, settings.GRPC, c.logger, "GetAttachedServerConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *attachedClustersGRPCClient) GenerateAttachedClusterInstallManifest(ctx context.Context, req *gkemulticloudpb.GenerateAttachedClusterInstallManifestRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAttachedClusterInstallManifestResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GenerateAttachedClusterInstallManifest[0:len((*c.CallOptions).GenerateAttachedClusterInstallManifest):len((*c.CallOptions).GenerateAttachedClusterInstallManifest)], opts...)
	var resp *gkemulticloudpb.GenerateAttachedClusterInstallManifestResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.attachedClustersClient.GenerateAttachedClusterInstallManifest, req, settings.GRPC, c.logger, "GenerateAttachedClusterInstallManifest")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *attachedClustersGRPCClient) GenerateAttachedClusterAgentToken(ctx context.Context, req *gkemulticloudpb.GenerateAttachedClusterAgentTokenRequest, opts ...gax.CallOption) (*gkemulticloudpb.GenerateAttachedClusterAgentTokenResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "attached_cluster", url.QueryEscape(req.GetAttachedCluster()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GenerateAttachedClusterAgentToken[0:len((*c.CallOptions).GenerateAttachedClusterAgentToken):len((*c.CallOptions).GenerateAttachedClusterAgentToken)], opts...)
	var resp *gkemulticloudpb.GenerateAttachedClusterAgentTokenResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.attachedClustersClient.GenerateAttachedClusterAgentToken, req, settings.GRPC, c.logger, "GenerateAttachedClusterAgentToken")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *attachedClustersGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *attachedClustersGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *attachedClustersGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *attachedClustersGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateAttachedClusterOperation returns a new CreateAttachedClusterOperation from a given name.
// The name must be that of a previously created CreateAttachedClusterOperation, possibly from a different process.
func (c *attachedClustersGRPCClient) CreateAttachedClusterOperation(name string) *CreateAttachedClusterOperation {
	return &CreateAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteAttachedClusterOperation returns a new DeleteAttachedClusterOperation from a given name.
// The name must be that of a previously created DeleteAttachedClusterOperation, possibly from a different process.
func (c *attachedClustersGRPCClient) DeleteAttachedClusterOperation(name string) *DeleteAttachedClusterOperation {
	return &DeleteAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ImportAttachedClusterOperation returns a new ImportAttachedClusterOperation from a given name.
// The name must be that of a previously created ImportAttachedClusterOperation, possibly from a different process.
func (c *attachedClustersGRPCClient) ImportAttachedClusterOperation(name string) *ImportAttachedClusterOperation {
	return &ImportAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateAttachedClusterOperation returns a new UpdateAttachedClusterOperation from a given name.
// The name must be that of a previously created UpdateAttachedClusterOperation, possibly from a different process.
func (c *attachedClustersGRPCClient) UpdateAttachedClusterOperation(name string) *UpdateAttachedClusterOperation {
	return &UpdateAttachedClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
