// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1beta/evaluation.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Describes the state of an evaluation.
type Evaluation_State int32

const (
	// The evaluation is unspecified.
	Evaluation_STATE_UNSPECIFIED Evaluation_State = 0
	// The service is preparing to run the evaluation.
	Evaluation_PENDING Evaluation_State = 1
	// The evaluation is in progress.
	Evaluation_RUNNING Evaluation_State = 2
	// The evaluation completed successfully.
	Evaluation_SUCCEEDED Evaluation_State = 3
	// The evaluation failed.
	Evaluation_FAILED Evaluation_State = 4
)

// Enum value maps for Evaluation_State.
var (
	Evaluation_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
	}
	Evaluation_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"FAILED":            4,
	}
)

func (x Evaluation_State) Enum() *Evaluation_State {
	p := new(Evaluation_State)
	*p = x
	return p
}

func (x Evaluation_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Evaluation_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_evaluation_proto_enumTypes[0].Descriptor()
}

func (Evaluation_State) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_evaluation_proto_enumTypes[0]
}

func (x Evaluation_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Evaluation_State.Descriptor instead.
func (Evaluation_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescGZIP(), []int{0, 0}
}

// An evaluation is a single execution (or run) of an evaluation process. It
// encapsulates the state of the evaluation and the resulting data.
type Evaluation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The full resource name of the
	// [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation], in the format
	// of `projects/{project}/locations/{location}/evaluations/{evaluation}`.
	//
	// This field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The specification of the evaluation.
	EvaluationSpec *Evaluation_EvaluationSpec `protobuf:"bytes,2,opt,name=evaluation_spec,json=evaluationSpec,proto3" json:"evaluation_spec,omitempty"`
	// Output only. The metrics produced by the evaluation, averaged across all
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s in the
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
	//
	// Only populated when the evaluation's state is SUCCEEDED.
	QualityMetrics *QualityMetrics `protobuf:"bytes,3,opt,name=quality_metrics,json=qualityMetrics,proto3" json:"quality_metrics,omitempty"`
	// Output only. The state of the evaluation.
	State Evaluation_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.discoveryengine.v1beta.Evaluation_State" json:"state,omitempty"`
	// Output only. The error that occurred during evaluation. Only populated when
	// the evaluation's state is FAILED.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Timestamp the
	// [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was created
	// at.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp the
	// [Evaluation][google.cloud.discoveryengine.v1beta.Evaluation] was completed
	// at.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,8,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
}

func (x *Evaluation) Reset() {
	*x = Evaluation{}
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Evaluation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Evaluation) ProtoMessage() {}

func (x *Evaluation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Evaluation.ProtoReflect.Descriptor instead.
func (*Evaluation) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescGZIP(), []int{0}
}

func (x *Evaluation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Evaluation) GetEvaluationSpec() *Evaluation_EvaluationSpec {
	if x != nil {
		return x.EvaluationSpec
	}
	return nil
}

func (x *Evaluation) GetQualityMetrics() *QualityMetrics {
	if x != nil {
		return x.QualityMetrics
	}
	return nil
}

func (x *Evaluation) GetState() Evaluation_State {
	if x != nil {
		return x.State
	}
	return Evaluation_STATE_UNSPECIFIED
}

func (x *Evaluation) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *Evaluation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Evaluation) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Evaluation) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

// Describes the metrics produced by the evaluation.
type QualityMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Recall per document, at various top-k cutoff levels.
	//
	// Recall is the fraction of relevant documents retrieved out of all
	// relevant documents.
	//
	// Example (top-5):
	//   - For a single
	//     [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 3 out
	//     of 5 relevant documents are retrieved in the top-5, recall@5 = 3/5 = 0.6
	DocRecall *QualityMetrics_TopkMetrics `protobuf:"bytes,1,opt,name=doc_recall,json=docRecall,proto3" json:"doc_recall,omitempty"`
	// Precision per document, at various top-k cutoff levels.
	//
	// Precision is the fraction of retrieved documents that are relevant.
	//
	// Example (top-5):
	//   - For a single
	//     [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], If 4 out
	//     of 5 retrieved documents in the top-5 are relevant, precision@5 = 4/5 =
	//     0.8
	DocPrecision *QualityMetrics_TopkMetrics `protobuf:"bytes,2,opt,name=doc_precision,json=docPrecision,proto3" json:"doc_precision,omitempty"`
	// Normalized discounted cumulative gain (NDCG) per document, at various top-k
	// cutoff levels.
	//
	// NDCG measures the ranking quality, giving higher relevance to top
	// results.
	//
	// Example (top-3):
	//
	//	Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
	//	with three retrieved documents (D1, D2, D3) and binary relevance
	//	judgements (1 for relevant, 0 for not relevant):
	//
	//	 Retrieved:  [D3 (0), D1 (1), D2 (1)]
	//	 Ideal:      [D1 (1), D2 (1), D3 (0)]
	//
	//	 Calculate NDCG@3 for each
	//	 [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
	//	  * DCG@3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
	//	  * Ideal DCG@3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
	//	  * NDCG@3: 1.13/1.63 = 0.693
	DocNdcg *QualityMetrics_TopkMetrics `protobuf:"bytes,3,opt,name=doc_ndcg,json=docNdcg,proto3" json:"doc_ndcg,omitempty"`
	// Recall per page, at various top-k cutoff levels.
	//
	// Recall is the fraction of relevant pages retrieved out of all relevant
	// pages.
	//
	// Example (top-5):
	//   - For a single
	//     [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], if 3 out
	//     of 5 relevant pages are retrieved in the top-5, recall@5 = 3/5 = 0.6
	PageRecall *QualityMetrics_TopkMetrics `protobuf:"bytes,4,opt,name=page_recall,json=pageRecall,proto3" json:"page_recall,omitempty"`
	// Normalized discounted cumulative gain (NDCG) per page, at various top-k
	// cutoff levels.
	//
	// NDCG measures the ranking quality, giving higher relevance to top
	// results.
	//
	// Example (top-3):
	//
	//	Suppose [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
	//	with three retrieved pages (P1, P2, P3) and binary relevance judgements (1
	//	for relevant, 0 for not relevant):
	//
	//	 Retrieved:  [P3 (0), P1 (1), P2 (1)]
	//	 Ideal:      [P1 (1), P2 (1), P3 (0)]
	//
	//	 Calculate NDCG@3 for
	//	 [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]:
	//	  * DCG@3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13
	//	  * Ideal DCG@3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63
	//	  * NDCG@3: 1.13/1.63 = 0.693
	PageNdcg *QualityMetrics_TopkMetrics `protobuf:"bytes,5,opt,name=page_ndcg,json=pageNdcg,proto3" json:"page_ndcg,omitempty"`
}

func (x *QualityMetrics) Reset() {
	*x = QualityMetrics{}
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QualityMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QualityMetrics) ProtoMessage() {}

func (x *QualityMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QualityMetrics.ProtoReflect.Descriptor instead.
func (*QualityMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescGZIP(), []int{1}
}

func (x *QualityMetrics) GetDocRecall() *QualityMetrics_TopkMetrics {
	if x != nil {
		return x.DocRecall
	}
	return nil
}

func (x *QualityMetrics) GetDocPrecision() *QualityMetrics_TopkMetrics {
	if x != nil {
		return x.DocPrecision
	}
	return nil
}

func (x *QualityMetrics) GetDocNdcg() *QualityMetrics_TopkMetrics {
	if x != nil {
		return x.DocNdcg
	}
	return nil
}

func (x *QualityMetrics) GetPageRecall() *QualityMetrics_TopkMetrics {
	if x != nil {
		return x.PageRecall
	}
	return nil
}

func (x *QualityMetrics) GetPageNdcg() *QualityMetrics_TopkMetrics {
	if x != nil {
		return x.PageNdcg
	}
	return nil
}

// Describes the specification of the evaluation.
type Evaluation_EvaluationSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The search specification.
	//
	// Types that are assignable to SearchSpec:
	//
	//	*Evaluation_EvaluationSpec_SearchRequest
	SearchSpec isEvaluation_EvaluationSpec_SearchSpec `protobuf_oneof:"search_spec"`
	// Required. The specification of the query set.
	QuerySetSpec *Evaluation_EvaluationSpec_QuerySetSpec `protobuf:"bytes,1,opt,name=query_set_spec,json=querySetSpec,proto3" json:"query_set_spec,omitempty"`
}

func (x *Evaluation_EvaluationSpec) Reset() {
	*x = Evaluation_EvaluationSpec{}
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Evaluation_EvaluationSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Evaluation_EvaluationSpec) ProtoMessage() {}

func (x *Evaluation_EvaluationSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Evaluation_EvaluationSpec.ProtoReflect.Descriptor instead.
func (*Evaluation_EvaluationSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescGZIP(), []int{0, 0}
}

func (m *Evaluation_EvaluationSpec) GetSearchSpec() isEvaluation_EvaluationSpec_SearchSpec {
	if m != nil {
		return m.SearchSpec
	}
	return nil
}

func (x *Evaluation_EvaluationSpec) GetSearchRequest() *SearchRequest {
	if x, ok := x.GetSearchSpec().(*Evaluation_EvaluationSpec_SearchRequest); ok {
		return x.SearchRequest
	}
	return nil
}

func (x *Evaluation_EvaluationSpec) GetQuerySetSpec() *Evaluation_EvaluationSpec_QuerySetSpec {
	if x != nil {
		return x.QuerySetSpec
	}
	return nil
}

type isEvaluation_EvaluationSpec_SearchSpec interface {
	isEvaluation_EvaluationSpec_SearchSpec()
}

type Evaluation_EvaluationSpec_SearchRequest struct {
	// Required. The search request that is used to perform the evaluation.
	//
	// Only the following fields within SearchRequest are supported; if any
	// other fields are provided, an UNSUPPORTED error will be returned:
	//
	// * [SearchRequest.serving_config][google.cloud.discoveryengine.v1beta.SearchRequest.serving_config]
	// * [SearchRequest.branch][google.cloud.discoveryengine.v1beta.SearchRequest.branch]
	// * [SearchRequest.canonical_filter][google.cloud.discoveryengine.v1beta.SearchRequest.canonical_filter]
	// * [SearchRequest.query_expansion_spec][google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec]
	// * [SearchRequest.spell_correction_spec][google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec]
	// * [SearchRequest.content_search_spec][google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec]
	// * [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id]
	SearchRequest *SearchRequest `protobuf:"bytes,2,opt,name=search_request,json=searchRequest,proto3,oneof"`
}

func (*Evaluation_EvaluationSpec_SearchRequest) isEvaluation_EvaluationSpec_SearchSpec() {}

// Describes the specification of the query set.
type Evaluation_EvaluationSpec_QuerySetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
	// used for the evaluation, in the format of
	// `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
	SampleQuerySet string `protobuf:"bytes,1,opt,name=sample_query_set,json=sampleQuerySet,proto3" json:"sample_query_set,omitempty"`
}

func (x *Evaluation_EvaluationSpec_QuerySetSpec) Reset() {
	*x = Evaluation_EvaluationSpec_QuerySetSpec{}
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Evaluation_EvaluationSpec_QuerySetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Evaluation_EvaluationSpec_QuerySetSpec) ProtoMessage() {}

func (x *Evaluation_EvaluationSpec_QuerySetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Evaluation_EvaluationSpec_QuerySetSpec.ProtoReflect.Descriptor instead.
func (*Evaluation_EvaluationSpec_QuerySetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Evaluation_EvaluationSpec_QuerySetSpec) GetSampleQuerySet() string {
	if x != nil {
		return x.SampleQuerySet
	}
	return ""
}

// Stores the metric values at specific top-k levels.
type QualityMetrics_TopkMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The top-1 value.
	Top_1 float64 `protobuf:"fixed64,1,opt,name=top_1,json=top1,proto3" json:"top_1,omitempty"`
	// The top-3 value.
	Top_3 float64 `protobuf:"fixed64,2,opt,name=top_3,json=top3,proto3" json:"top_3,omitempty"`
	// The top-5 value.
	Top_5 float64 `protobuf:"fixed64,3,opt,name=top_5,json=top5,proto3" json:"top_5,omitempty"`
	// The top-10 value.
	Top_10 float64 `protobuf:"fixed64,4,opt,name=top_10,json=top10,proto3" json:"top_10,omitempty"`
}

func (x *QualityMetrics_TopkMetrics) Reset() {
	*x = QualityMetrics_TopkMetrics{}
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QualityMetrics_TopkMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QualityMetrics_TopkMetrics) ProtoMessage() {}

func (x *QualityMetrics_TopkMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QualityMetrics_TopkMetrics.ProtoReflect.Descriptor instead.
func (*QualityMetrics_TopkMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescGZIP(), []int{1, 0}
}

func (x *QualityMetrics_TopkMetrics) GetTop_1() float64 {
	if x != nil {
		return x.Top_1
	}
	return 0
}

func (x *QualityMetrics_TopkMetrics) GetTop_3() float64 {
	if x != nil {
		return x.Top_3
	}
	return 0
}

func (x *QualityMetrics_TopkMetrics) GetTop_5() float64 {
	if x != nil {
		return x.Top_5
	}
	return 0
}

func (x *QualityMetrics_TopkMetrics) GetTop_10() float64 {
	if x != nil {
		return x.Top_10
	}
	return 0
}

var File_google_cloud_discoveryengine_v1beta_evaluation_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe7, 0x08, 0x0a, 0x0a,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x6c, 0x0a, 0x0f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0e, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x61, 0x0a, 0x0f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x50, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x1a, 0xea, 0x02, 0x0a, 0x0e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x60, 0x0a, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x76, 0x0a, 0x0e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x1a, 0x6f,
	0x0a, 0x0c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5f,
	0x0a, 0x10, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f,
	0x0a, 0x2d, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x52,
	0x0e, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x42,
	0x0d, 0x0a, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0x53,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43,
	0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x04, 0x3a, 0x70, 0xea, 0x41, 0x6d, 0x0a, 0x29, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xd7, 0x04, 0x0a, 0x0e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x5e, 0x0a, 0x0a, 0x64, 0x6f, 0x63, 0x5f,
	0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x54, 0x6f, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x09, 0x64,
	0x6f, 0x63, 0x52, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x12, 0x64, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x5f,
	0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x54, 0x6f, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x0c, 0x64, 0x6f, 0x63, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x5a,
	0x0a, 0x08, 0x64, 0x6f, 0x63, 0x5f, 0x6e, 0x64, 0x63, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x54, 0x6f, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x07, 0x64, 0x6f, 0x63, 0x4e, 0x64, 0x63, 0x67, 0x12, 0x60, 0x0a, 0x0b, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x54, 0x6f, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x52, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x12, 0x5c, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x64, 0x63, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x54, 0x6f, 0x70, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x4e, 0x64, 0x63, 0x67, 0x1a, 0x63, 0x0a, 0x0b, 0x54, 0x6f,
	0x70, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x13, 0x0a, 0x05, 0x74, 0x6f, 0x70,
	0x5f, 0x31, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x31, 0x12, 0x13,
	0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x33, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x74,
	0x6f, 0x70, 0x33, 0x12, 0x13, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x35, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x35, 0x12, 0x15, 0x0a, 0x06, 0x74, 0x6f, 0x70, 0x5f,
	0x31, 0x30, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x31, 0x30, 0x42,
	0x96, 0x02, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0f, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x51,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70,
	0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47,
	0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea,
	0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_evaluation_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_discoveryengine_v1beta_evaluation_proto_goTypes = []any{
	(Evaluation_State)(0),                          // 0: google.cloud.discoveryengine.v1beta.Evaluation.State
	(*Evaluation)(nil),                             // 1: google.cloud.discoveryengine.v1beta.Evaluation
	(*QualityMetrics)(nil),                         // 2: google.cloud.discoveryengine.v1beta.QualityMetrics
	(*Evaluation_EvaluationSpec)(nil),              // 3: google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
	(*Evaluation_EvaluationSpec_QuerySetSpec)(nil), // 4: google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
	(*QualityMetrics_TopkMetrics)(nil),             // 5: google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
	(*status.Status)(nil),                          // 6: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                  // 7: google.protobuf.Timestamp
	(*SearchRequest)(nil),                          // 8: google.cloud.discoveryengine.v1beta.SearchRequest
}
var file_google_cloud_discoveryengine_v1beta_evaluation_proto_depIdxs = []int32{
	3,  // 0: google.cloud.discoveryengine.v1beta.Evaluation.evaluation_spec:type_name -> google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec
	2,  // 1: google.cloud.discoveryengine.v1beta.Evaluation.quality_metrics:type_name -> google.cloud.discoveryengine.v1beta.QualityMetrics
	0,  // 2: google.cloud.discoveryengine.v1beta.Evaluation.state:type_name -> google.cloud.discoveryengine.v1beta.Evaluation.State
	6,  // 3: google.cloud.discoveryengine.v1beta.Evaluation.error:type_name -> google.rpc.Status
	7,  // 4: google.cloud.discoveryengine.v1beta.Evaluation.create_time:type_name -> google.protobuf.Timestamp
	7,  // 5: google.cloud.discoveryengine.v1beta.Evaluation.end_time:type_name -> google.protobuf.Timestamp
	6,  // 6: google.cloud.discoveryengine.v1beta.Evaluation.error_samples:type_name -> google.rpc.Status
	5,  // 7: google.cloud.discoveryengine.v1beta.QualityMetrics.doc_recall:type_name -> google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
	5,  // 8: google.cloud.discoveryengine.v1beta.QualityMetrics.doc_precision:type_name -> google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
	5,  // 9: google.cloud.discoveryengine.v1beta.QualityMetrics.doc_ndcg:type_name -> google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
	5,  // 10: google.cloud.discoveryengine.v1beta.QualityMetrics.page_recall:type_name -> google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
	5,  // 11: google.cloud.discoveryengine.v1beta.QualityMetrics.page_ndcg:type_name -> google.cloud.discoveryengine.v1beta.QualityMetrics.TopkMetrics
	8,  // 12: google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.search_request:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest
	4,  // 13: google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.query_set_spec:type_name -> google.cloud.discoveryengine.v1beta.Evaluation.EvaluationSpec.QuerySetSpec
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_evaluation_proto_init() }
func file_google_cloud_discoveryengine_v1beta_evaluation_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_evaluation_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_search_service_proto_init()
	file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes[2].OneofWrappers = []any{
		(*Evaluation_EvaluationSpec_SearchRequest)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_evaluation_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_evaluation_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1beta_evaluation_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_evaluation_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_evaluation_proto = out.File
	file_google_cloud_discoveryengine_v1beta_evaluation_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_evaluation_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_evaluation_proto_depIdxs = nil
}
