// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1alpha/serving_config.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Configures metadata that is used to generate serving time results (e.g.
// search results or recommendation predictions).
// The ServingConfig is passed in the search and predict request and generates
// results.
type ServingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Industry vertical specific config.
	//
	// Types that are assignable to VerticalConfig:
	//
	//	*ServingConfig_MediaConfig_
	//	*ServingConfig_GenericConfig_
	VerticalConfig isServingConfig_VerticalConfig `protobuf_oneof:"vertical_config"`
	// Immutable. Fully qualified name
	// `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}/servingConfigs/{serving_config_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human readable serving config display name. Used in Discovery
	// UI.
	//
	// This field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Immutable. Specifies the solution type that a serving config can
	// be associated with.
	SolutionType SolutionType `protobuf:"varint,3,opt,name=solution_type,json=solutionType,proto3,enum=google.cloud.discoveryengine.v1alpha.SolutionType" json:"solution_type,omitempty"`
	// The id of the model to use at serving time.
	// Currently only RecommendationModels are supported.
	// Can be changed but only to a compatible model (e.g.
	// others-you-may-like CTR to others-you-may-like CVR).
	//
	// Required when
	// [SolutionType][google.cloud.discoveryengine.v1alpha.SolutionType] is
	// [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
	ModelId string `protobuf:"bytes,4,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	// How much diversity to use in recommendation model results e.g.
	// `medium-diversity` or `high-diversity`. Currently supported values:
	//
	// * `no-diversity`
	// * `low-diversity`
	// * `medium-diversity`
	// * `high-diversity`
	// * `auto-diversity`
	//
	// If not specified, we choose default based on recommendation model
	// type. Default value: `no-diversity`.
	//
	// Can only be set if
	// [SolutionType][google.cloud.discoveryengine.v1alpha.SolutionType] is
	// [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
	DiversityLevel string `protobuf:"bytes,5,opt,name=diversity_level,json=diversityLevel,proto3" json:"diversity_level,omitempty"`
	// Bring your own embedding config. The config is used for search semantic
	// retrieval. The retrieval is based on the dot product of
	// [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
	// and the document embeddings that are provided by this EmbeddingConfig. If
	// [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
	// is provided, it overrides this
	// [ServingConfig.embedding_config][google.cloud.discoveryengine.v1alpha.ServingConfig.embedding_config].
	EmbeddingConfig *EmbeddingConfig `protobuf:"bytes,20,opt,name=embedding_config,json=embeddingConfig,proto3" json:"embedding_config,omitempty"`
	// The ranking expression controls the customized ranking on retrieval
	// documents. To leverage this, document embedding is required. The ranking
	// expression setting in ServingConfig applies to all search requests served
	// by the serving config. However, if
	// [SearchRequest.ranking_expression][google.cloud.discoveryengine.v1alpha.SearchRequest.ranking_expression]
	// is specified, it overrides the ServingConfig ranking expression.
	//
	// The ranking expression is a single function or multiple functions that are
	// joined by "+".
	//
	//   - ranking_expression = function, { " + ", function };
	//
	// Supported functions:
	//
	//   - double * relevance_score
	//   - double * dotProduct(embedding_field_path)
	//
	// Function variables:
	//
	//   - `relevance_score`: pre-defined keywords, used for measure relevance
	//     between query and document.
	//
	//   - `embedding_field_path`: the document embedding field
	//     used with query embedding vector.
	//
	//   - `dotProduct`: embedding function between embedding_field_path and query
	//     embedding vector.
	//
	//     Example ranking expression:
	//
	//     If document has an embedding field doc_embedding, the ranking expression
	//     could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
	RankingExpression string `protobuf:"bytes,21,opt,name=ranking_expression,json=rankingExpression,proto3" json:"ranking_expression,omitempty"`
	// Guided search configs.
	GuidedSearchSpec *GuidedSearchSpec `protobuf:"bytes,22,opt,name=guided_search_spec,json=guidedSearchSpec,proto3" json:"guided_search_spec,omitempty"`
	// Custom fine tuning configs.
	// If
	// [SearchRequest.custom_fine_tuning_spec][google.cloud.discoveryengine.v1alpha.SearchRequest.custom_fine_tuning_spec]
	// is set, it has higher priority than the configs set here.
	CustomFineTuningSpec *CustomFineTuningSpec `protobuf:"bytes,24,opt,name=custom_fine_tuning_spec,json=customFineTuningSpec,proto3" json:"custom_fine_tuning_spec,omitempty"`
	// Output only. ServingConfig created timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. ServingConfig updated timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Filter controls to use in serving path.
	// All triggered filter controls will be applied.
	// Filter controls must be in the same data store as the serving config.
	// Maximum of 20 filter controls.
	FilterControlIds []string `protobuf:"bytes,11,rep,name=filter_control_ids,json=filterControlIds,proto3" json:"filter_control_ids,omitempty"`
	// Boost controls to use in serving path.
	// All triggered boost controls will be applied.
	// Boost controls must be in the same data store as the serving config.
	// Maximum of 20 boost controls.
	BoostControlIds []string `protobuf:"bytes,12,rep,name=boost_control_ids,json=boostControlIds,proto3" json:"boost_control_ids,omitempty"`
	// IDs of the redirect controls. Only the first triggered redirect
	// action is applied, even if multiple apply. Maximum number of
	// specifications is 100.
	//
	// Can only be set if
	// [SolutionType][google.cloud.discoveryengine.v1alpha.SolutionType] is
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_SEARCH].
	RedirectControlIds []string `protobuf:"bytes,14,rep,name=redirect_control_ids,json=redirectControlIds,proto3" json:"redirect_control_ids,omitempty"`
	// Condition synonyms specifications. If multiple synonyms conditions
	// match, all matching synonyms controls in the list will execute.
	// Maximum number of specifications is 100.
	//
	// Can only be set if
	// [SolutionType][google.cloud.discoveryengine.v1alpha.SolutionType] is
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_SEARCH].
	SynonymsControlIds []string `protobuf:"bytes,15,rep,name=synonyms_control_ids,json=synonymsControlIds,proto3" json:"synonyms_control_ids,omitempty"`
	// Condition oneway synonyms specifications. If multiple oneway synonyms
	// conditions match, all matching oneway synonyms controls in the list
	// will execute. Maximum number of specifications is 100.
	//
	// Can only be set if
	// [SolutionType][google.cloud.discoveryengine.v1alpha.SolutionType] is
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_SEARCH].
	OnewaySynonymsControlIds []string `protobuf:"bytes,16,rep,name=oneway_synonyms_control_ids,json=onewaySynonymsControlIds,proto3" json:"oneway_synonyms_control_ids,omitempty"`
	// Condition do not associate specifications. If multiple do not
	// associate conditions match, all matching do not associate controls in
	// the list will execute.
	// Order does not matter.
	// Maximum number of specifications is 100.
	//
	// Can only be set if
	// [SolutionType][google.cloud.discoveryengine.v1alpha.SolutionType] is
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_SEARCH].
	DissociateControlIds []string `protobuf:"bytes,17,rep,name=dissociate_control_ids,json=dissociateControlIds,proto3" json:"dissociate_control_ids,omitempty"`
	// Condition replacement specifications.
	// Applied according to the order in the list.
	// A previously replaced term can not be re-replaced.
	// Maximum number of specifications is 100.
	//
	// Can only be set if
	// [SolutionType][google.cloud.discoveryengine.v1alpha.SolutionType] is
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_SEARCH].
	ReplacementControlIds []string `protobuf:"bytes,18,rep,name=replacement_control_ids,json=replacementControlIds,proto3" json:"replacement_control_ids,omitempty"`
	// Condition ignore specifications. If multiple ignore
	// conditions match, all matching ignore controls in the list will
	// execute.
	// Order does not matter.
	// Maximum number of specifications is 100.
	IgnoreControlIds []string `protobuf:"bytes,19,rep,name=ignore_control_ids,json=ignoreControlIds,proto3" json:"ignore_control_ids,omitempty"`
}

func (x *ServingConfig) Reset() {
	*x = ServingConfig{}
	mi := &file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServingConfig) ProtoMessage() {}

func (x *ServingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServingConfig.ProtoReflect.Descriptor instead.
func (*ServingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescGZIP(), []int{0}
}

func (m *ServingConfig) GetVerticalConfig() isServingConfig_VerticalConfig {
	if m != nil {
		return m.VerticalConfig
	}
	return nil
}

func (x *ServingConfig) GetMediaConfig() *ServingConfig_MediaConfig {
	if x, ok := x.GetVerticalConfig().(*ServingConfig_MediaConfig_); ok {
		return x.MediaConfig
	}
	return nil
}

func (x *ServingConfig) GetGenericConfig() *ServingConfig_GenericConfig {
	if x, ok := x.GetVerticalConfig().(*ServingConfig_GenericConfig_); ok {
		return x.GenericConfig
	}
	return nil
}

func (x *ServingConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServingConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ServingConfig) GetSolutionType() SolutionType {
	if x != nil {
		return x.SolutionType
	}
	return SolutionType_SOLUTION_TYPE_UNSPECIFIED
}

func (x *ServingConfig) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

func (x *ServingConfig) GetDiversityLevel() string {
	if x != nil {
		return x.DiversityLevel
	}
	return ""
}

func (x *ServingConfig) GetEmbeddingConfig() *EmbeddingConfig {
	if x != nil {
		return x.EmbeddingConfig
	}
	return nil
}

func (x *ServingConfig) GetRankingExpression() string {
	if x != nil {
		return x.RankingExpression
	}
	return ""
}

func (x *ServingConfig) GetGuidedSearchSpec() *GuidedSearchSpec {
	if x != nil {
		return x.GuidedSearchSpec
	}
	return nil
}

func (x *ServingConfig) GetCustomFineTuningSpec() *CustomFineTuningSpec {
	if x != nil {
		return x.CustomFineTuningSpec
	}
	return nil
}

func (x *ServingConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ServingConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ServingConfig) GetFilterControlIds() []string {
	if x != nil {
		return x.FilterControlIds
	}
	return nil
}

func (x *ServingConfig) GetBoostControlIds() []string {
	if x != nil {
		return x.BoostControlIds
	}
	return nil
}

func (x *ServingConfig) GetRedirectControlIds() []string {
	if x != nil {
		return x.RedirectControlIds
	}
	return nil
}

func (x *ServingConfig) GetSynonymsControlIds() []string {
	if x != nil {
		return x.SynonymsControlIds
	}
	return nil
}

func (x *ServingConfig) GetOnewaySynonymsControlIds() []string {
	if x != nil {
		return x.OnewaySynonymsControlIds
	}
	return nil
}

func (x *ServingConfig) GetDissociateControlIds() []string {
	if x != nil {
		return x.DissociateControlIds
	}
	return nil
}

func (x *ServingConfig) GetReplacementControlIds() []string {
	if x != nil {
		return x.ReplacementControlIds
	}
	return nil
}

func (x *ServingConfig) GetIgnoreControlIds() []string {
	if x != nil {
		return x.IgnoreControlIds
	}
	return nil
}

type isServingConfig_VerticalConfig interface {
	isServingConfig_VerticalConfig()
}

type ServingConfig_MediaConfig_ struct {
	// The MediaConfig of the serving configuration.
	MediaConfig *ServingConfig_MediaConfig `protobuf:"bytes,7,opt,name=media_config,json=mediaConfig,proto3,oneof"`
}

type ServingConfig_GenericConfig_ struct {
	// The GenericConfig of the serving configuration.
	GenericConfig *ServingConfig_GenericConfig `protobuf:"bytes,10,opt,name=generic_config,json=genericConfig,proto3,oneof"`
}

func (*ServingConfig_MediaConfig_) isServingConfig_VerticalConfig() {}

func (*ServingConfig_GenericConfig_) isServingConfig_VerticalConfig() {}

// Specifies the configurations needed for Media Discovery. Currently we
// support:
//
// * `demote_content_watched`: Threshold for watched content demotion.
// Customers can specify if using watched content demotion or use viewed
// detail page. Using the content watched demotion, customers need to specify
// the watched minutes or percentage exceeds the threshold, the content will
// be demoted in the recommendation result.
// * `promote_fresh_content`: cutoff days for fresh content promotion.
// Customers can specify if using content freshness promotion. If the content
// was published within the cutoff days, the content will be promoted in the
// recommendation result.
// Can only be set if
// [SolutionType][google.cloud.discoveryengine.v1alpha.SolutionType] is
// [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
type ServingConfig_MediaConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify the threshold for demoting watched content, the threshold can be
	// either percentage or minutes value.
	// This must be set for `media-complete` event type.
	//
	// Types that are assignable to DemoteContentWatched:
	//
	//	*ServingConfig_MediaConfig_ContentWatchedPercentageThreshold
	//	*ServingConfig_MediaConfig_ContentWatchedSecondsThreshold
	DemoteContentWatched isServingConfig_MediaConfig_DemoteContentWatched `protobuf_oneof:"demote_content_watched"`
	// Specifies the event type used for demoting recommendation result.
	// Currently supported values:
	//
	// * `view-item`: Item viewed.
	// * `media-play`: Start/resume watching a video, playing a song, etc.
	// * `media-complete`: Finished or stopped midway through a video, song,
	// etc.
	//
	// If unset, watch history demotion will not be applied. Content freshness
	// demotion will still be applied.
	DemotionEventType string `protobuf:"bytes,1,opt,name=demotion_event_type,json=demotionEventType,proto3" json:"demotion_event_type,omitempty"`
	// Specifies the content freshness used for recommendation result.
	// Contents will be demoted if contents were published for more than content
	// freshness cutoff days.
	ContentFreshnessCutoffDays int32 `protobuf:"varint,4,opt,name=content_freshness_cutoff_days,json=contentFreshnessCutoffDays,proto3" json:"content_freshness_cutoff_days,omitempty"`
}

func (x *ServingConfig_MediaConfig) Reset() {
	*x = ServingConfig_MediaConfig{}
	mi := &file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServingConfig_MediaConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServingConfig_MediaConfig) ProtoMessage() {}

func (x *ServingConfig_MediaConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServingConfig_MediaConfig.ProtoReflect.Descriptor instead.
func (*ServingConfig_MediaConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescGZIP(), []int{0, 0}
}

func (m *ServingConfig_MediaConfig) GetDemoteContentWatched() isServingConfig_MediaConfig_DemoteContentWatched {
	if m != nil {
		return m.DemoteContentWatched
	}
	return nil
}

func (x *ServingConfig_MediaConfig) GetContentWatchedPercentageThreshold() float32 {
	if x, ok := x.GetDemoteContentWatched().(*ServingConfig_MediaConfig_ContentWatchedPercentageThreshold); ok {
		return x.ContentWatchedPercentageThreshold
	}
	return 0
}

func (x *ServingConfig_MediaConfig) GetContentWatchedSecondsThreshold() float32 {
	if x, ok := x.GetDemoteContentWatched().(*ServingConfig_MediaConfig_ContentWatchedSecondsThreshold); ok {
		return x.ContentWatchedSecondsThreshold
	}
	return 0
}

func (x *ServingConfig_MediaConfig) GetDemotionEventType() string {
	if x != nil {
		return x.DemotionEventType
	}
	return ""
}

func (x *ServingConfig_MediaConfig) GetContentFreshnessCutoffDays() int32 {
	if x != nil {
		return x.ContentFreshnessCutoffDays
	}
	return 0
}

type isServingConfig_MediaConfig_DemoteContentWatched interface {
	isServingConfig_MediaConfig_DemoteContentWatched()
}

type ServingConfig_MediaConfig_ContentWatchedPercentageThreshold struct {
	// Specifies the content watched percentage threshold for demotion.
	// Threshold value must be between [0, 1.0] inclusive.
	ContentWatchedPercentageThreshold float32 `protobuf:"fixed32,2,opt,name=content_watched_percentage_threshold,json=contentWatchedPercentageThreshold,proto3,oneof"`
}

type ServingConfig_MediaConfig_ContentWatchedSecondsThreshold struct {
	// Specifies the content watched minutes threshold for demotion.
	ContentWatchedSecondsThreshold float32 `protobuf:"fixed32,5,opt,name=content_watched_seconds_threshold,json=contentWatchedSecondsThreshold,proto3,oneof"`
}

func (*ServingConfig_MediaConfig_ContentWatchedPercentageThreshold) isServingConfig_MediaConfig_DemoteContentWatched() {
}

func (*ServingConfig_MediaConfig_ContentWatchedSecondsThreshold) isServingConfig_MediaConfig_DemoteContentWatched() {
}

// Specifies the configurations needed for Generic Discovery.Currently we
// support:
//
// * `content_search_spec`: configuration for generic content search.
type ServingConfig_GenericConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the expected behavior of content search.
	// Only valid for content-search enabled data store.
	ContentSearchSpec *SearchRequest_ContentSearchSpec `protobuf:"bytes,1,opt,name=content_search_spec,json=contentSearchSpec,proto3" json:"content_search_spec,omitempty"`
}

func (x *ServingConfig_GenericConfig) Reset() {
	*x = ServingConfig_GenericConfig{}
	mi := &file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServingConfig_GenericConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServingConfig_GenericConfig) ProtoMessage() {}

func (x *ServingConfig_GenericConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServingConfig_GenericConfig.ProtoReflect.Descriptor instead.
func (*ServingConfig_GenericConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ServingConfig_GenericConfig) GetContentSearchSpec() *SearchRequest_ContentSearchSpec {
	if x != nil {
		return x.ContentSearchSpec
	}
	return nil
}

var File_google_cloud_discoveryengine_v1alpha_serving_config_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaa, 0x11, 0x0a,
	0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64,
	0x0a, 0x0c, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a, 0x0e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x0d, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x5f, 0x0a, 0x0d, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x27, 0x0a,
	0x0f, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74,
	0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x60, 0x0a, 0x10, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x61, 0x6e, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x12, 0x67, 0x75, 0x69, 0x64, 0x65,
	0x64, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x75, 0x69, 0x64, 0x65,
	0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x52, 0x10, 0x67, 0x75, 0x69,
	0x64, 0x65, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x12, 0x71, 0x0a,
	0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x69, 0x6e, 0x65,
	0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x52, 0x14, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x10, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49,
	0x64, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x62,
	0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x64, 0x73, 0x12, 0x30,
	0x0a, 0x14, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x72, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x64, 0x73,
	0x12, 0x30, 0x0a, 0x14, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12,
	0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49,
	0x64, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x6f, 0x6e, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x73, 0x79, 0x6e,
	0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x09, 0x52, 0x18, 0x6f, 0x6e, 0x65, 0x77, 0x61, 0x79, 0x53,
	0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x64,
	0x73, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x14, 0x64, 0x69, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x49, 0x64, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x64, 0x73, 0x12,
	0x2c, 0x0a, 0x12, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x49, 0x64, 0x73, 0x1a, 0xba, 0x02,
	0x0a, 0x0b, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x0a,
	0x24, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x21, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x57, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x50, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x12, 0x4b, 0x0a, 0x21, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x77, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x1e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x57, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x53, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x73, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x2e, 0x0a,
	0x13, 0x64, 0x65, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x65, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a,
	0x1d, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x72, 0x65, 0x73, 0x68, 0x6e, 0x65,
	0x73, 0x73, 0x5f, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x1a, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x72, 0x65,
	0x73, 0x68, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x44, 0x61, 0x79, 0x73,
	0x42, 0x18, 0x0a, 0x16, 0x64, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x1a, 0x86, 0x01, 0x0a, 0x0d, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x75, 0x0a, 0x13,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53,
	0x70, 0x65, 0x63, 0x3a, 0x80, 0x03, 0xea, 0x41, 0xfc, 0x02, 0x0a, 0x2c, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0x78, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x7d, 0x12, 0x71, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x42, 0x11, 0x0a, 0x0f, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63,
	0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x9e, 0x02, 0x0a, 0x28, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x12, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62,
	0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49,
	0x4e, 0x45, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_discoveryengine_v1alpha_serving_config_proto_goTypes = []any{
	(*ServingConfig)(nil),                   // 0: google.cloud.discoveryengine.v1alpha.ServingConfig
	(*ServingConfig_MediaConfig)(nil),       // 1: google.cloud.discoveryengine.v1alpha.ServingConfig.MediaConfig
	(*ServingConfig_GenericConfig)(nil),     // 2: google.cloud.discoveryengine.v1alpha.ServingConfig.GenericConfig
	(SolutionType)(0),                       // 3: google.cloud.discoveryengine.v1alpha.SolutionType
	(*EmbeddingConfig)(nil),                 // 4: google.cloud.discoveryengine.v1alpha.EmbeddingConfig
	(*GuidedSearchSpec)(nil),                // 5: google.cloud.discoveryengine.v1alpha.GuidedSearchSpec
	(*CustomFineTuningSpec)(nil),            // 6: google.cloud.discoveryengine.v1alpha.CustomFineTuningSpec
	(*timestamppb.Timestamp)(nil),           // 7: google.protobuf.Timestamp
	(*SearchRequest_ContentSearchSpec)(nil), // 8: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec
}
var file_google_cloud_discoveryengine_v1alpha_serving_config_proto_depIdxs = []int32{
	1, // 0: google.cloud.discoveryengine.v1alpha.ServingConfig.media_config:type_name -> google.cloud.discoveryengine.v1alpha.ServingConfig.MediaConfig
	2, // 1: google.cloud.discoveryengine.v1alpha.ServingConfig.generic_config:type_name -> google.cloud.discoveryengine.v1alpha.ServingConfig.GenericConfig
	3, // 2: google.cloud.discoveryengine.v1alpha.ServingConfig.solution_type:type_name -> google.cloud.discoveryengine.v1alpha.SolutionType
	4, // 3: google.cloud.discoveryengine.v1alpha.ServingConfig.embedding_config:type_name -> google.cloud.discoveryengine.v1alpha.EmbeddingConfig
	5, // 4: google.cloud.discoveryengine.v1alpha.ServingConfig.guided_search_spec:type_name -> google.cloud.discoveryengine.v1alpha.GuidedSearchSpec
	6, // 5: google.cloud.discoveryengine.v1alpha.ServingConfig.custom_fine_tuning_spec:type_name -> google.cloud.discoveryengine.v1alpha.CustomFineTuningSpec
	7, // 6: google.cloud.discoveryengine.v1alpha.ServingConfig.create_time:type_name -> google.protobuf.Timestamp
	7, // 7: google.cloud.discoveryengine.v1alpha.ServingConfig.update_time:type_name -> google.protobuf.Timestamp
	8, // 8: google.cloud.discoveryengine.v1alpha.ServingConfig.GenericConfig.content_search_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_serving_config_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_serving_config_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_serving_config_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1alpha_common_proto_init()
	file_google_cloud_discoveryengine_v1alpha_search_service_proto_init()
	file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes[0].OneofWrappers = []any{
		(*ServingConfig_MediaConfig_)(nil),
		(*ServingConfig_GenericConfig_)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes[1].OneofWrappers = []any{
		(*ServingConfig_MediaConfig_ContentWatchedPercentageThreshold)(nil),
		(*ServingConfig_MediaConfig_ContentWatchedSecondsThreshold)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_serving_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_serving_config_proto_depIdxs,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_serving_config_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_serving_config_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_serving_config_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_serving_config_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_serving_config_proto_depIdxs = nil
}
